import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [scheduler](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoneventbridgescheduler.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Scheduler extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [scheduler](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoneventbridgescheduler.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an Amazon EventBridge Scheduler schedule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    toCreateSchedule(): this;
    /**
     * Grants permission to create an Amazon EventBridge Scheduler schedule group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     */
    toCreateScheduleGroup(): this;
    /**
     * Grants permission to delete an Amazon EventBridge Scheduler schedule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    toDeleteSchedule(): this;
    /**
     * Grants permission to delete an Amazon EventBridge Scheduler schedule group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    toDeleteScheduleGroup(): this;
    /**
     * Grants permission to view details about an Amazon EventBridge Scheduler schedule
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    toGetSchedule(): this;
    /**
     * Grants permission to view details about an Amazon EventBridge Scheduler schedule group
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    toGetScheduleGroup(): this;
    /**
     * Grants permission to list the Amazon EventBridge Scheduler schedule groups in your account
     *
     * Access Level: List
     */
    toListScheduleGroups(): this;
    /**
     * Grants permission to list the Amazon EventBridge Scheduler schedules in your account
     *
     * Access Level: List
     */
    toListSchedules(): this;
    /**
     * Grants permission to lists tag for an Amazon EventBridge Scheduler resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to tag an Amazon EventBridge Scheduler resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     */
    toTagResource(): this;
    /**
     * Grants permission to untag an Amazon EventBridge Scheduler resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     */
    toUntagResource(): this;
    /**
     * Grants permission to modify an Amazon EventBridge Scheduler schedule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    toUpdateSchedule(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type schedule-group to the statement
     *
     * @param groupName - Identifier for the groupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onScheduleGroup(groupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type schedule to the statement
     *
     * @param groupName - Identifier for the groupName.
     * @param scheduleName - Identifier for the scheduleName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSchedule(groupName: string, scheduleName: string, account?: string, region?: string, partition?: string): this;
}
