"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Nimble = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [nimble](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonnimblestudio.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Nimble extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [nimble](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonnimblestudio.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'nimble';
        this.accessLevelList = {
            Write: [
                'AcceptEulas',
                'CreateLaunchProfile',
                'CreateStreamingImage',
                'CreateStreamingSession',
                'CreateStreamingSessionStream',
                'CreateStudio',
                'CreateStudioComponent',
                'DeleteLaunchProfile',
                'DeleteLaunchProfileMember',
                'DeleteStreamingImage',
                'DeleteStreamingSession',
                'DeleteStudio',
                'DeleteStudioComponent',
                'DeleteStudioMember',
                'PutLaunchProfileMembers',
                'PutStudioLogEvents',
                'PutStudioMembers',
                'StartStreamingSession',
                'StartStudioSSOConfigurationRepair',
                'StopStreamingSession',
                'UpdateLaunchProfile',
                'UpdateLaunchProfileMember',
                'UpdateStreamingImage',
                'UpdateStudio',
                'UpdateStudioComponent'
            ],
            Read: [
                'GetEula',
                'GetFeatureMap',
                'GetLaunchProfile',
                'GetLaunchProfileDetails',
                'GetLaunchProfileInitialization',
                'GetLaunchProfileMember',
                'GetStreamingImage',
                'GetStreamingSession',
                'GetStreamingSessionStream',
                'GetStudio',
                'GetStudioComponent',
                'GetStudioMember',
                'ListEulaAcceptances',
                'ListEulas',
                'ListLaunchProfileMembers',
                'ListLaunchProfiles',
                'ListStreamingImages',
                'ListStreamingSessions',
                'ListStudioComponents',
                'ListStudioMembers',
                'ListStudios',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to accept EULAs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_AcceptEulas.html
     */
    toAcceptEulas() {
        return this.to('AcceptEulas');
    }
    /**
     * Grants permission to create a launch profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DescribeNatGateways
     * - ec2:DescribeNetworkAcls
     * - ec2:DescribeRouteTables
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcEndpoints
     * - ec2:RunInstances
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateLaunchProfile.html
     */
    toCreateLaunchProfile() {
        return this.to('CreateLaunchProfile');
    }
    /**
     * Grants permission to create a streaming image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:DescribeImages
     * - ec2:DescribeSnapshots
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifySnapshotAttribute
     * - ec2:RegisterImage
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingImage.html
     */
    toCreateStreamingImage() {
        return this.to('CreateStreamingImage');
    }
    /**
     * Grants permission to create a streaming session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:CreateNetworkInterfacePermission
     * - nimble:GetLaunchProfile
     * - nimble:GetLaunchProfileInitialization
     * - nimble:ListEulaAcceptances
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingSession.html
     */
    toCreateStreamingSession() {
        return this.to('CreateStreamingSession');
    }
    /**
     * Grants permission to create a StreamingSessionStream
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingSessionStream.html
     */
    toCreateStreamingSessionStream() {
        return this.to('CreateStreamingSessionStream');
    }
    /**
     * Grants permission to create a studio
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sso:CreateManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStudio.html
     */
    toCreateStudio() {
        return this.to('CreateStudio');
    }
    /**
     * Grants permission to create a studio component. A studio component designates a network resource to which a launch profile will provide access
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStudioComponent.html
     */
    toCreateStudioComponent() {
        return this.to('CreateStudioComponent');
    }
    /**
     * Grants permission to delete a launch profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteLaunchProfile.html
     */
    toDeleteLaunchProfile() {
        return this.to('DeleteLaunchProfile');
    }
    /**
     * Grants permission to delete a launch profile member
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteLaunchProfileMember.html
     */
    toDeleteLaunchProfileMember() {
        return this.to('DeleteLaunchProfileMember');
    }
    /**
     * Grants permission to delete a streaming image
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DeleteSnapshot
     * - ec2:DeregisterImage
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifySnapshotAttribute
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStreamingImage.html
     */
    toDeleteStreamingImage() {
        return this.to('DeleteStreamingImage');
    }
    /**
     * Grants permission to delete a streaming session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - ec2:DeleteNetworkInterface
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStreamingSession.html
     */
    toDeleteStreamingSession() {
        return this.to('DeleteStreamingSession');
    }
    /**
     * Grants permission to delete a studio
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:DeleteManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudio.html
     */
    toDeleteStudio() {
        return this.to('DeleteStudio');
    }
    /**
     * Grants permission to delete a studio component
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudioComponent.html
     */
    toDeleteStudioComponent() {
        return this.to('DeleteStudioComponent');
    }
    /**
     * Grants permission to delete a studio member
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudioMember.html
     */
    toDeleteStudioMember() {
        return this.to('DeleteStudioMember');
    }
    /**
     * Grants permission to get a EULA
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetEula.html
     */
    toGetEula() {
        return this.to('GetEula');
    }
    /**
     * Grants permission to allow Nimble Studio portal to show the appropriate features for this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     */
    toGetFeatureMap() {
        return this.to('GetFeatureMap');
    }
    /**
     * Grants permission to get a launch profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfile.html
     */
    toGetLaunchProfile() {
        return this.to('GetLaunchProfile');
    }
    /**
     * Grants permission to get a launch profile's details, which includes the summary of studio components and streaming images used by the launch profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileDetails.html
     */
    toGetLaunchProfileDetails() {
        return this.to('GetLaunchProfileDetails');
    }
    /**
     * Grants permission to get a launch profile initialization. A launch profile initialization is a dereferenced version of a launch profile, including attached studio component connection information
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileInitialization.html
     */
    toGetLaunchProfileInitialization() {
        return this.to('GetLaunchProfileInitialization');
    }
    /**
     * Grants permission to get a launch profile member
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileMember.html
     */
    toGetLaunchProfileMember() {
        return this.to('GetLaunchProfileMember');
    }
    /**
     * Grants permission to get a streaming image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingImage.html
     */
    toGetStreamingImage() {
        return this.to('GetStreamingImage');
    }
    /**
     * Grants permission to get a streaming session
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingSession.html
     */
    toGetStreamingSession() {
        return this.to('GetStreamingSession');
    }
    /**
     * Grants permission to get a streaming session stream
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingSessionStream.html
     */
    toGetStreamingSessionStream() {
        return this.to('GetStreamingSessionStream');
    }
    /**
     * Grants permission to get a studio
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudio.html
     */
    toGetStudio() {
        return this.to('GetStudio');
    }
    /**
     * Grants permission to get a studio component
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudioComponent.html
     */
    toGetStudioComponent() {
        return this.to('GetStudioComponent');
    }
    /**
     * Grants permission to get a studio member
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudioMember.html
     */
    toGetStudioMember() {
        return this.to('GetStudioMember');
    }
    /**
     * Grants permission to list EULA acceptances
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListEulaAcceptances.html
     */
    toListEulaAcceptances() {
        return this.to('ListEulaAcceptances');
    }
    /**
     * Grants permission to list EULAs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListEulas.html
     */
    toListEulas() {
        return this.to('ListEulas');
    }
    /**
     * Grants permission to list launch profile members
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListLaunchProfileMembers.html
     */
    toListLaunchProfileMembers() {
        return this.to('ListLaunchProfileMembers');
    }
    /**
     * Grants permission to list launch profiles
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifPrincipalId()
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListLaunchProfiles.html
     */
    toListLaunchProfiles() {
        return this.to('ListLaunchProfiles');
    }
    /**
     * Grants permission to list streaming images
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStreamingImages.html
     */
    toListStreamingImages() {
        return this.to('ListStreamingImages');
    }
    /**
     * Grants permission to list streaming sessions
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCreatedBy()
     * - .ifOwnedBy()
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStreamingSessions.html
     */
    toListStreamingSessions() {
        return this.to('ListStreamingSessions');
    }
    /**
     * Grants permission to list studio components
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudioComponents.html
     */
    toListStudioComponents() {
        return this.to('ListStudioComponents');
    }
    /**
     * Grants permission to list studio members
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudioMembers.html
     */
    toListStudioMembers() {
        return this.to('ListStudioMembers');
    }
    /**
     * Grants permission to list all studios
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudios.html
     */
    toListStudios() {
        return this.to('ListStudios');
    }
    /**
     * Grants permission to list all tags on a Nimble Studio resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to add/update launch profile members
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso-directory:DescribeUsers
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_PutLaunchProfileMembers.html
     */
    toPutLaunchProfileMembers() {
        return this.to('PutLaunchProfileMembers');
    }
    /**
     * Grants permission to report metrics and logs for the Nimble Studio portal to monitor application health
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     */
    toPutStudioLogEvents() {
        return this.to('PutStudioLogEvents');
    }
    /**
     * Grants permission to add/update studio members
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso-directory:DescribeUsers
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_PutStudioMembers.html
     */
    toPutStudioMembers() {
        return this.to('PutStudioMembers');
    }
    /**
     * Grants permission to start a streaming session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - nimble:GetLaunchProfile
     * - nimble:GetLaunchProfileMember
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StartStreamingSession.html
     */
    toStartStreamingSession() {
        return this.to('StartStreamingSession');
    }
    /**
     * Grants permission to repair the studio's AWS IAM Identity Center configuration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:CreateManagedApplicationInstance
     * - sso:GetManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StartStudioSSOConfigurationRepair.html
     */
    toStartStudioSSOConfigurationRepair() {
        return this.to('StartStudioSSOConfigurationRepair');
    }
    /**
     * Grants permission to stop a streaming session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - nimble:GetLaunchProfile
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StopStreamingSession.html
     */
    toStopStreamingSession() {
        return this.to('StopStreamingSession');
    }
    /**
     * Grants permission to add or overwrite one or more tags for the specified Nimble Studio resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to disassociate one or more tags from the specified Nimble Studio resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a launch profile
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeNatGateways
     * - ec2:DescribeNetworkAcls
     * - ec2:DescribeRouteTables
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcEndpoints
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateLaunchProfile.html
     */
    toUpdateLaunchProfile() {
        return this.to('UpdateLaunchProfile');
    }
    /**
     * Grants permission to update a launch profile member
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateLaunchProfileMember.html
     */
    toUpdateLaunchProfileMember() {
        return this.to('UpdateLaunchProfileMember');
    }
    /**
     * Grants permission to update a streaming image
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStreamingImage.html
     */
    toUpdateStreamingImage() {
        return this.to('UpdateStreamingImage');
    }
    /**
     * Grants permission to update a studio
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStudio.html
     */
    toUpdateStudio() {
        return this.to('UpdateStudio');
    }
    /**
     * Grants permission to update a studio component
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStudioComponent.html
     */
    toUpdateStudioComponent() {
        return this.to('UpdateStudioComponent');
    }
    /**
     * Adds a resource of type studio to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_Studio.html
     *
     * @param studioId - Identifier for the studioId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifStudioId()
     */
    onStudio(studioId, account, region, partition) {
        return this.on(`arn:${partition || Nimble.defaultPartition}:nimble:${region || '*'}:${account || '*'}:studio/${studioId}`);
    }
    /**
     * Adds a resource of type streaming-image to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StreamingImage.html
     *
     * @param streamingImageId - Identifier for the streamingImageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifStudioId()
     */
    onStreamingImage(streamingImageId, account, region, partition) {
        return this.on(`arn:${partition || Nimble.defaultPartition}:nimble:${region || '*'}:${account || '*'}:streaming-image/${streamingImageId}`);
    }
    /**
     * Adds a resource of type studio-component to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StudioComponent.html
     *
     * @param studioComponentId - Identifier for the studioComponentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifStudioId()
     */
    onStudioComponent(studioComponentId, account, region, partition) {
        return this.on(`arn:${partition || Nimble.defaultPartition}:nimble:${region || '*'}:${account || '*'}:studio-component/${studioComponentId}`);
    }
    /**
     * Adds a resource of type launch-profile to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_LaunchProfile.html
     *
     * @param launchProfileId - Identifier for the launchProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifStudioId()
     */
    onLaunchProfile(launchProfileId, account, region, partition) {
        return this.on(`arn:${partition || Nimble.defaultPartition}:nimble:${region || '*'}:${account || '*'}:launch-profile/${launchProfileId}`);
    }
    /**
     * Adds a resource of type streaming-session to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StreamingSession.html
     *
     * @param streamingSessionId - Identifier for the streamingSessionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifCreatedBy()
     * - .ifOwnedBy()
     */
    onStreamingSession(streamingSessionId, account, region, partition) {
        return this.on(`arn:${partition || Nimble.defaultPartition}:nimble:${region || '*'}:${account || '*'}:streaming-session/${streamingSessionId}`);
    }
    /**
     * Adds a resource of type eula to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_Eula.html
     *
     * @param eulaId - Identifier for the eulaId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEula(eulaId, account, region, partition) {
        return this.on(`arn:${partition || Nimble.defaultPartition}:nimble:${region || '*'}:${account || '*'}:eula/${eulaId}`);
    }
    /**
     * Adds a resource of type eula-acceptance to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_EulaAcceptance.html
     *
     * @param eulaAcceptanceId - Identifier for the eulaAcceptanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifStudioId()
     */
    onEulaAcceptance(eulaAcceptanceId, account, region, partition) {
        return this.on(`arn:${partition || Nimble.defaultPartition}:nimble:${region || '*'}:${account || '*'}:eula-acceptance/${eulaAcceptanceId}`);
    }
    /**
     * Filters access by the createdBy request parameter or the ID of the creator of the resource
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListStreamingSessions()
     *
     * Applies to resource types:
     * - streaming-session
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreatedBy(value, operator) {
        return this.if(`createdBy`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ownedBy request parameter or the ID of the owner of the resource
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListStreamingSessions()
     *
     * Applies to resource types:
     * - streaming-session
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOwnedBy(value, operator) {
        return this.if(`ownedBy`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the principalId request parameter
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListLaunchProfiles()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPrincipalId(value, operator) {
        return this.if(`principalId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ID of the logged in user
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toCreateStreamingSessionStream()
     * - .toDeleteStreamingSession()
     * - .toGetStreamingSession()
     * - .toGetStreamingSessionStream()
     * - .toListLaunchProfiles()
     * - .toListStreamingSessions()
     * - .toStartStreamingSession()
     * - .toStopStreamingSession()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRequesterPrincipalId(value, operator) {
        return this.if(`requesterPrincipalId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a specific studio
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to resource types:
     * - studio
     * - streaming-image
     * - studio-component
     * - launch-profile
     * - eula-acceptance
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifStudioId(value, operator) {
        return this.if(`studioId`, value, operator || 'ArnLike');
    }
}
exports.Nimble = Nimble;
_a = JSII_RTTI_SYMBOL_1;
Nimble[_a] = { fqn: "iam-floyd.Nimble", version: "0.457.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmltYmxlc3R1ZGlvLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibmltYmxlc3R1ZGlvLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esc0NBQXNEO0FBRXREOzs7O0dBSUc7QUFDSCxNQUFhLE1BQU8sU0FBUSx3QkFBZTtJQUd6Qzs7OztPQUlHO0lBQ0gsWUFBWSxHQUFZO1FBQ3RCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQVJOLGtCQUFhLEdBQUcsUUFBUSxDQUFDO1FBcXJCdEIsb0JBQWUsR0FBb0I7WUFDM0MsS0FBSyxFQUFFO2dCQUNMLGFBQWE7Z0JBQ2IscUJBQXFCO2dCQUNyQixzQkFBc0I7Z0JBQ3RCLHdCQUF3QjtnQkFDeEIsOEJBQThCO2dCQUM5QixjQUFjO2dCQUNkLHVCQUF1QjtnQkFDdkIscUJBQXFCO2dCQUNyQiwyQkFBMkI7Z0JBQzNCLHNCQUFzQjtnQkFDdEIsd0JBQXdCO2dCQUN4QixjQUFjO2dCQUNkLHVCQUF1QjtnQkFDdkIsb0JBQW9CO2dCQUNwQix5QkFBeUI7Z0JBQ3pCLG9CQUFvQjtnQkFDcEIsa0JBQWtCO2dCQUNsQix1QkFBdUI7Z0JBQ3ZCLG1DQUFtQztnQkFDbkMsc0JBQXNCO2dCQUN0QixxQkFBcUI7Z0JBQ3JCLDJCQUEyQjtnQkFDM0Isc0JBQXNCO2dCQUN0QixjQUFjO2dCQUNkLHVCQUF1QjthQUN4QjtZQUNELElBQUksRUFBRTtnQkFDSixTQUFTO2dCQUNULGVBQWU7Z0JBQ2Ysa0JBQWtCO2dCQUNsQix5QkFBeUI7Z0JBQ3pCLGdDQUFnQztnQkFDaEMsd0JBQXdCO2dCQUN4QixtQkFBbUI7Z0JBQ25CLHFCQUFxQjtnQkFDckIsMkJBQTJCO2dCQUMzQixXQUFXO2dCQUNYLG9CQUFvQjtnQkFDcEIsaUJBQWlCO2dCQUNqQixxQkFBcUI7Z0JBQ3JCLFdBQVc7Z0JBQ1gsMEJBQTBCO2dCQUMxQixvQkFBb0I7Z0JBQ3BCLHFCQUFxQjtnQkFDckIsdUJBQXVCO2dCQUN2QixzQkFBc0I7Z0JBQ3RCLG1CQUFtQjtnQkFDbkIsYUFBYTtnQkFDYixxQkFBcUI7YUFDdEI7WUFDRCxPQUFPLEVBQUU7Z0JBQ1AsYUFBYTtnQkFDYixlQUFlO2FBQ2hCO1NBQ0YsQ0FBQztJQXB1QkYsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7OztPQW1CRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7O09BaUJHO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7T0FpQkc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLDhCQUE4QjtRQUNuQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsOEJBQThCLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7O09BY0c7SUFDSSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7O09BaUJHO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDJCQUEyQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksU0FBUztRQUNkLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM1QixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLGdDQUFnQztRQUNyQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0JBQXdCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksV0FBVztRQUNoQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7O09BYUc7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxtQ0FBbUM7UUFDeEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1DQUFtQyxDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7O09BV0c7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7O09BYUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDJCQUEyQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7T0FhRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBNEREOzs7Ozs7Ozs7Ozs7Ozs7T0FlRztJQUNJLFFBQVEsQ0FBQyxRQUFnQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3JGLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxNQUFNLENBQUMsZ0JBQWlCLFdBQVksTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSxXQUFZLFFBQVMsRUFBRSxDQUFDLENBQUM7SUFDckksQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7Ozs7T0FlRztJQUNJLGdCQUFnQixDQUFDLGdCQUF3QixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3JHLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxNQUFNLENBQUMsZ0JBQWlCLFdBQVksTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSxvQkFBcUIsZ0JBQWlCLEVBQUUsQ0FBQyxDQUFDO0lBQ3RKLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7O09BZUc7SUFDSSxpQkFBaUIsQ0FBQyxpQkFBeUIsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUN2RyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksTUFBTSxDQUFDLGdCQUFpQixXQUFZLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUkscUJBQXNCLGlCQUFrQixFQUFFLENBQUMsQ0FBQztJQUN4SixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7OztPQWVHO0lBQ0ksZUFBZSxDQUFDLGVBQXVCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDbkcsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLE1BQU0sQ0FBQyxnQkFBaUIsV0FBWSxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLG1CQUFvQixlQUFnQixFQUFFLENBQUMsQ0FBQztJQUNwSixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7T0FnQkc7SUFDSSxrQkFBa0IsQ0FBQyxrQkFBMEIsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUN6RyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksTUFBTSxDQUFDLGdCQUFpQixXQUFZLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUksc0JBQXVCLGtCQUFtQixFQUFFLENBQUMsQ0FBQztJQUMxSixDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksTUFBTSxDQUFDLE1BQWMsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUNqRixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksTUFBTSxDQUFDLGdCQUFpQixXQUFZLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUksU0FBVSxNQUFPLEVBQUUsQ0FBQyxDQUFDO0lBQ2pJLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxnQkFBZ0IsQ0FBQyxnQkFBd0IsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUNyRyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksTUFBTSxDQUFDLGdCQUFpQixXQUFZLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUksb0JBQXFCLGdCQUFpQixFQUFFLENBQUMsQ0FBQztJQUN0SixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7T0FhRztJQUNJLFdBQVcsQ0FBQyxLQUF3QixFQUFFLFFBQTRCO1FBQ3ZFLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSSxZQUFZLENBQUMsQ0FBQztJQUMvRCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7T0FhRztJQUNJLFNBQVMsQ0FBQyxLQUF3QixFQUFFLFFBQTRCO1FBQ3JFLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSSxZQUFZLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGFBQWEsQ0FBQyxLQUF3QixFQUFFLFFBQTRCO1FBQ3pFLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSSxZQUFZLENBQUMsQ0FBQztJQUNqRSxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7O09BaUJHO0lBQ0ksc0JBQXNCLENBQUMsS0FBd0IsRUFBRSxRQUE0QjtRQUNsRixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSSxZQUFZLENBQUMsQ0FBQztJQUMxRSxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7O09BY0c7SUFDSSxVQUFVLENBQUMsS0FBd0IsRUFBRSxRQUE0QjtRQUN0RSxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxFQUFFLEtBQUssRUFBRSxRQUFRLElBQUksU0FBUyxDQUFDLENBQUM7SUFDM0QsQ0FBQzs7QUE5OEJILHdCQSs4QkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tICcuLi9zaGFyZWQvYWNjZXNzLWxldmVsJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCwgT3BlcmF0b3IgfSBmcm9tICcuLi9zaGFyZWQnO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbbmltYmxlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hbWF6b25uaW1ibGVzdHVkaW8uaHRtbCkuXG4gKlxuICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBOaW1ibGUgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICduaW1ibGUnO1xuXG4gIC8qKlxuICAgKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW25pbWJsZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9ubmltYmxlc3R1ZGlvLmh0bWwpLlxuICAgKlxuICAgKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAgICovXG4gIGNvbnN0cnVjdG9yKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gYWNjZXB0IEVVTEFzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQWNjZXB0RXVsYXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQWNjZXB0RXVsYXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0FjY2VwdEV1bGFzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgbGF1bmNoIHByb2ZpbGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBlYzI6Q3JlYXRlTmV0d29ya0ludGVyZmFjZVxuICAgKiAtIGVjMjpEZXNjcmliZU5hdEdhdGV3YXlzXG4gICAqIC0gZWMyOkRlc2NyaWJlTmV0d29ya0FjbHNcbiAgICogLSBlYzI6RGVzY3JpYmVSb3V0ZVRhYmxlc1xuICAgKiAtIGVjMjpEZXNjcmliZVN1Ym5ldHNcbiAgICogLSBlYzI6RGVzY3JpYmVWcGNFbmRwb2ludHNcbiAgICogLSBlYzI6UnVuSW5zdGFuY2VzXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZUxhdW5jaFByb2ZpbGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlTGF1bmNoUHJvZmlsZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlTGF1bmNoUHJvZmlsZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIHN0cmVhbWluZyBpbWFnZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGVjMjpEZXNjcmliZUltYWdlc1xuICAgKiAtIGVjMjpEZXNjcmliZVNuYXBzaG90c1xuICAgKiAtIGVjMjpNb2RpZnlJbnN0YW5jZUF0dHJpYnV0ZVxuICAgKiAtIGVjMjpNb2RpZnlTbmFwc2hvdEF0dHJpYnV0ZVxuICAgKiAtIGVjMjpSZWdpc3RlckltYWdlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZVN0cmVhbWluZ0ltYWdlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVN0cmVhbWluZ0ltYWdlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVTdHJlYW1pbmdJbWFnZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIHN0cmVhbWluZyBzZXNzaW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gZWMyOkNyZWF0ZU5ldHdvcmtJbnRlcmZhY2VcbiAgICogLSBlYzI6Q3JlYXRlTmV0d29ya0ludGVyZmFjZVBlcm1pc3Npb25cbiAgICogLSBuaW1ibGU6R2V0TGF1bmNoUHJvZmlsZVxuICAgKiAtIG5pbWJsZTpHZXRMYXVuY2hQcm9maWxlSW5pdGlhbGl6YXRpb25cbiAgICogLSBuaW1ibGU6TGlzdEV1bGFBY2NlcHRhbmNlc1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVTdHJlYW1pbmdTZXNzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVN0cmVhbWluZ1Nlc3Npb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVN0cmVhbWluZ1Nlc3Npb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBTdHJlYW1pbmdTZXNzaW9uU3RyZWFtXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZSZXF1ZXN0ZXJQcmluY2lwYWxJZCgpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZVN0cmVhbWluZ1Nlc3Npb25TdHJlYW0uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlU3RyZWFtaW5nU2Vzc2lvblN0cmVhbSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlU3RyZWFtaW5nU2Vzc2lvblN0cmVhbScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIHN0dWRpb1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGlhbTpQYXNzUm9sZVxuICAgKiAtIHNzbzpDcmVhdGVNYW5hZ2VkQXBwbGljYXRpb25JbnN0YW5jZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVTdHVkaW8uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlU3R1ZGlvKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVTdHVkaW8nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBzdHVkaW8gY29tcG9uZW50LiBBIHN0dWRpbyBjb21wb25lbnQgZGVzaWduYXRlcyBhIG5ldHdvcmsgcmVzb3VyY2UgdG8gd2hpY2ggYSBsYXVuY2ggcHJvZmlsZSB3aWxsIHByb3ZpZGUgYWNjZXNzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gZHM6QXV0aG9yaXplQXBwbGljYXRpb25cbiAgICogLSBkczpEZXNjcmliZURpcmVjdG9yaWVzXG4gICAqIC0gZWMyOkRlc2NyaWJlU2VjdXJpdHlHcm91cHNcbiAgICogLSBmc3g6RGVzY3JpYmVGaWxlU3lzdGVtc1xuICAgKiAtIGlhbTpQYXNzUm9sZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVTdHVkaW9Db21wb25lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlU3R1ZGlvQ29tcG9uZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVTdHVkaW9Db21wb25lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSBsYXVuY2ggcHJvZmlsZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZUxhdW5jaFByb2ZpbGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlTGF1bmNoUHJvZmlsZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlTGF1bmNoUHJvZmlsZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIGxhdW5jaCBwcm9maWxlIG1lbWJlclxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZUxhdW5jaFByb2ZpbGVNZW1iZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlTGF1bmNoUHJvZmlsZU1lbWJlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlTGF1bmNoUHJvZmlsZU1lbWJlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIHN0cmVhbWluZyBpbWFnZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGVjMjpEZWxldGVTbmFwc2hvdFxuICAgKiAtIGVjMjpEZXJlZ2lzdGVySW1hZ2VcbiAgICogLSBlYzI6TW9kaWZ5SW5zdGFuY2VBdHRyaWJ1dGVcbiAgICogLSBlYzI6TW9kaWZ5U25hcHNob3RBdHRyaWJ1dGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlU3RyZWFtaW5nSW1hZ2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlU3RyZWFtaW5nSW1hZ2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVN0cmVhbWluZ0ltYWdlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgc3RyZWFtaW5nIHNlc3Npb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZlJlcXVlc3RlclByaW5jaXBhbElkKClcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gZWMyOkRlbGV0ZU5ldHdvcmtJbnRlcmZhY2VcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlU3RyZWFtaW5nU2Vzc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVTdHJlYW1pbmdTZXNzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVTdHJlYW1pbmdTZXNzaW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgc3R1ZGlvXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gc3NvOkRlbGV0ZU1hbmFnZWRBcHBsaWNhdGlvbkluc3RhbmNlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZVN0dWRpby5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVTdHVkaW8oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVN0dWRpbycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIHN0dWRpbyBjb21wb25lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBkczpVbmF1dGhvcml6ZUFwcGxpY2F0aW9uXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZVN0dWRpb0NvbXBvbmVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVTdHVkaW9Db21wb25lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVN0dWRpb0NvbXBvbmVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIHN0dWRpbyBtZW1iZXJcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVTdHVkaW9NZW1iZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlU3R1ZGlvTWVtYmVyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVTdHVkaW9NZW1iZXInKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgYSBFVUxBXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRFdWxhLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEV1bGEoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEV1bGEnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBhbGxvdyBOaW1ibGUgU3R1ZGlvIHBvcnRhbCB0byBzaG93IHRoZSBhcHByb3ByaWF0ZSBmZWF0dXJlcyBmb3IgdGhpcyBhY2NvdW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvdXNlcmd1aWRlL3NlY3VyaXR5LWlhbS1zZXJ2aWNlLXdpdGgtaWFtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEZlYXR1cmVNYXAoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEZlYXR1cmVNYXAnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgYSBsYXVuY2ggcHJvZmlsZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0TGF1bmNoUHJvZmlsZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRMYXVuY2hQcm9maWxlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRMYXVuY2hQcm9maWxlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGEgbGF1bmNoIHByb2ZpbGUncyBkZXRhaWxzLCB3aGljaCBpbmNsdWRlcyB0aGUgc3VtbWFyeSBvZiBzdHVkaW8gY29tcG9uZW50cyBhbmQgc3RyZWFtaW5nIGltYWdlcyB1c2VkIGJ5IHRoZSBsYXVuY2ggcHJvZmlsZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0TGF1bmNoUHJvZmlsZURldGFpbHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0TGF1bmNoUHJvZmlsZURldGFpbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldExhdW5jaFByb2ZpbGVEZXRhaWxzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGEgbGF1bmNoIHByb2ZpbGUgaW5pdGlhbGl6YXRpb24uIEEgbGF1bmNoIHByb2ZpbGUgaW5pdGlhbGl6YXRpb24gaXMgYSBkZXJlZmVyZW5jZWQgdmVyc2lvbiBvZiBhIGxhdW5jaCBwcm9maWxlLCBpbmNsdWRpbmcgYXR0YWNoZWQgc3R1ZGlvIGNvbXBvbmVudCBjb25uZWN0aW9uIGluZm9ybWF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBkczpEZXNjcmliZURpcmVjdG9yaWVzXG4gICAqIC0gZWMyOkRlc2NyaWJlU2VjdXJpdHlHcm91cHNcbiAgICogLSBmc3g6RGVzY3JpYmVGaWxlU3lzdGVtc1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRMYXVuY2hQcm9maWxlSW5pdGlhbGl6YXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0TGF1bmNoUHJvZmlsZUluaXRpYWxpemF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRMYXVuY2hQcm9maWxlSW5pdGlhbGl6YXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgYSBsYXVuY2ggcHJvZmlsZSBtZW1iZXJcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldExhdW5jaFByb2ZpbGVNZW1iZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0TGF1bmNoUHJvZmlsZU1lbWJlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0TGF1bmNoUHJvZmlsZU1lbWJlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBhIHN0cmVhbWluZyBpbWFnZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0U3RyZWFtaW5nSW1hZ2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0U3RyZWFtaW5nSW1hZ2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFN0cmVhbWluZ0ltYWdlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGEgc3RyZWFtaW5nIHNlc3Npb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmUmVxdWVzdGVyUHJpbmNpcGFsSWQoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRTdHJlYW1pbmdTZXNzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFN0cmVhbWluZ1Nlc3Npb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFN0cmVhbWluZ1Nlc3Npb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgYSBzdHJlYW1pbmcgc2Vzc2lvbiBzdHJlYW1cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmUmVxdWVzdGVyUHJpbmNpcGFsSWQoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRTdHJlYW1pbmdTZXNzaW9uU3RyZWFtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFN0cmVhbWluZ1Nlc3Npb25TdHJlYW0oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFN0cmVhbWluZ1Nlc3Npb25TdHJlYW0nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgYSBzdHVkaW9cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFN0dWRpby5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTdHVkaW8oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFN0dWRpbycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBhIHN0dWRpbyBjb21wb25lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFN0dWRpb0NvbXBvbmVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTdHVkaW9Db21wb25lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFN0dWRpb0NvbXBvbmVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBhIHN0dWRpbyBtZW1iZXJcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFN0dWRpb01lbWJlci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTdHVkaW9NZW1iZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFN0dWRpb01lbWJlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgRVVMQSBhY2NlcHRhbmNlc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdEV1bGFBY2NlcHRhbmNlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RXVsYUFjY2VwdGFuY2VzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RXVsYUFjY2VwdGFuY2VzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBFVUxBc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdEV1bGFzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RFdWxhcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEV1bGFzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBsYXVuY2ggcHJvZmlsZSBtZW1iZXJzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0TGF1bmNoUHJvZmlsZU1lbWJlcnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdExhdW5jaFByb2ZpbGVNZW1iZXJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TGF1bmNoUHJvZmlsZU1lbWJlcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGxhdW5jaCBwcm9maWxlc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZQcmluY2lwYWxJZCgpXG4gICAqIC0gLmlmUmVxdWVzdGVyUHJpbmNpcGFsSWQoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0TGF1bmNoUHJvZmlsZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdExhdW5jaFByb2ZpbGVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TGF1bmNoUHJvZmlsZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHN0cmVhbWluZyBpbWFnZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RTdHJlYW1pbmdJbWFnZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFN0cmVhbWluZ0ltYWdlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFN0cmVhbWluZ0ltYWdlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3Qgc3RyZWFtaW5nIHNlc3Npb25zXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkNyZWF0ZWRCeSgpXG4gICAqIC0gLmlmT3duZWRCeSgpXG4gICAqIC0gLmlmUmVxdWVzdGVyUHJpbmNpcGFsSWQoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0U3RyZWFtaW5nU2Vzc2lvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFN0cmVhbWluZ1Nlc3Npb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0U3RyZWFtaW5nU2Vzc2lvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHN0dWRpbyBjb21wb25lbnRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0U3R1ZGlvQ29tcG9uZW50cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0U3R1ZGlvQ29tcG9uZW50cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFN0dWRpb0NvbXBvbmVudHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHN0dWRpbyBtZW1iZXJzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0U3R1ZGlvTWVtYmVycy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0U3R1ZGlvTWVtYmVycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFN0dWRpb01lbWJlcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGFsbCBzdHVkaW9zXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0U3R1ZGlvcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0U3R1ZGlvcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFN0dWRpb3MnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGFsbCB0YWdzIG9uIGEgTmltYmxlIFN0dWRpbyByZXNvdXJjZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFRhZ3NGb3JSZXNvdXJjZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VGFnc0ZvclJlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0VGFnc0ZvclJlc291cmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gYWRkL3VwZGF0ZSBsYXVuY2ggcHJvZmlsZSBtZW1iZXJzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gc3NvLWRpcmVjdG9yeTpEZXNjcmliZVVzZXJzXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1B1dExhdW5jaFByb2ZpbGVNZW1iZXJzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1B1dExhdW5jaFByb2ZpbGVNZW1iZXJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdQdXRMYXVuY2hQcm9maWxlTWVtYmVycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJlcG9ydCBtZXRyaWNzIGFuZCBsb2dzIGZvciB0aGUgTmltYmxlIFN0dWRpbyBwb3J0YWwgdG8gbW9uaXRvciBhcHBsaWNhdGlvbiBoZWFsdGhcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvdXNlcmd1aWRlL3NlY3VyaXR5LWlhbS1zZXJ2aWNlLXdpdGgtaWFtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1B1dFN0dWRpb0xvZ0V2ZW50cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnUHV0U3R1ZGlvTG9nRXZlbnRzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gYWRkL3VwZGF0ZSBzdHVkaW8gbWVtYmVyc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIHNzby1kaXJlY3Rvcnk6RGVzY3JpYmVVc2Vyc1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9QdXRTdHVkaW9NZW1iZXJzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1B1dFN0dWRpb01lbWJlcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1B1dFN0dWRpb01lbWJlcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzdGFydCBhIHN0cmVhbWluZyBzZXNzaW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZSZXF1ZXN0ZXJQcmluY2lwYWxJZCgpXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIG5pbWJsZTpHZXRMYXVuY2hQcm9maWxlXG4gICAqIC0gbmltYmxlOkdldExhdW5jaFByb2ZpbGVNZW1iZXJcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfU3RhcnRTdHJlYW1pbmdTZXNzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0YXJ0U3RyZWFtaW5nU2Vzc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU3RhcnRTdHJlYW1pbmdTZXNzaW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmVwYWlyIHRoZSBzdHVkaW8ncyBBV1MgSUFNIElkZW50aXR5IENlbnRlciBjb25maWd1cmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gc3NvOkNyZWF0ZU1hbmFnZWRBcHBsaWNhdGlvbkluc3RhbmNlXG4gICAqIC0gc3NvOkdldE1hbmFnZWRBcHBsaWNhdGlvbkluc3RhbmNlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1N0YXJ0U3R1ZGlvU1NPQ29uZmlndXJhdGlvblJlcGFpci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdGFydFN0dWRpb1NTT0NvbmZpZ3VyYXRpb25SZXBhaXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0YXJ0U3R1ZGlvU1NPQ29uZmlndXJhdGlvblJlcGFpcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHN0b3AgYSBzdHJlYW1pbmcgc2Vzc2lvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmUmVxdWVzdGVyUHJpbmNpcGFsSWQoKVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBuaW1ibGU6R2V0TGF1bmNoUHJvZmlsZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TdG9wU3RyZWFtaW5nU2Vzc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdG9wU3RyZWFtaW5nU2Vzc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU3RvcFN0cmVhbWluZ1Nlc3Npb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBhZGQgb3Igb3ZlcndyaXRlIG9uZSBvciBtb3JlIHRhZ3MgZm9yIHRoZSBzcGVjaWZpZWQgTmltYmxlIFN0dWRpbyByZXNvdXJjZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1RhZ1Jlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1RhZ1Jlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdUYWdSZXNvdXJjZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRpc2Fzc29jaWF0ZSBvbmUgb3IgbW9yZSB0YWdzIGZyb20gdGhlIHNwZWNpZmllZCBOaW1ibGUgU3R1ZGlvIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VbnRhZ1Jlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VudGFnUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VudGFnUmVzb3VyY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSBsYXVuY2ggcHJvZmlsZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGVjMjpEZXNjcmliZU5hdEdhdGV3YXlzXG4gICAqIC0gZWMyOkRlc2NyaWJlTmV0d29ya0FjbHNcbiAgICogLSBlYzI6RGVzY3JpYmVSb3V0ZVRhYmxlc1xuICAgKiAtIGVjMjpEZXNjcmliZVN1Ym5ldHNcbiAgICogLSBlYzI6RGVzY3JpYmVWcGNFbmRwb2ludHNcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlTGF1bmNoUHJvZmlsZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVMYXVuY2hQcm9maWxlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVMYXVuY2hQcm9maWxlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgbGF1bmNoIHByb2ZpbGUgbWVtYmVyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlTGF1bmNoUHJvZmlsZU1lbWJlci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVMYXVuY2hQcm9maWxlTWVtYmVyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVMYXVuY2hQcm9maWxlTWVtYmVyJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgc3RyZWFtaW5nIGltYWdlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlU3RyZWFtaW5nSW1hZ2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlU3RyZWFtaW5nSW1hZ2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVN0cmVhbWluZ0ltYWdlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgc3R1ZGlvXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gaWFtOlBhc3NSb2xlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZVN0dWRpby5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVTdHVkaW8oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVN0dWRpbycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhIHN0dWRpbyBjb21wb25lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBkczpBdXRob3JpemVBcHBsaWNhdGlvblxuICAgKiAtIGRzOkRlc2NyaWJlRGlyZWN0b3JpZXNcbiAgICogLSBlYzI6RGVzY3JpYmVTZWN1cml0eUdyb3Vwc1xuICAgKiAtIGZzeDpEZXNjcmliZUZpbGVTeXN0ZW1zXG4gICAqIC0gaWFtOlBhc3NSb2xlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZVN0dWRpb0NvbXBvbmVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVTdHVkaW9Db21wb25lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVN0dWRpb0NvbXBvbmVudCcpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFjY2Vzc0xldmVsTGlzdDogQWNjZXNzTGV2ZWxMaXN0ID0ge1xuICAgIFdyaXRlOiBbXG4gICAgICAnQWNjZXB0RXVsYXMnLFxuICAgICAgJ0NyZWF0ZUxhdW5jaFByb2ZpbGUnLFxuICAgICAgJ0NyZWF0ZVN0cmVhbWluZ0ltYWdlJyxcbiAgICAgICdDcmVhdGVTdHJlYW1pbmdTZXNzaW9uJyxcbiAgICAgICdDcmVhdGVTdHJlYW1pbmdTZXNzaW9uU3RyZWFtJyxcbiAgICAgICdDcmVhdGVTdHVkaW8nLFxuICAgICAgJ0NyZWF0ZVN0dWRpb0NvbXBvbmVudCcsXG4gICAgICAnRGVsZXRlTGF1bmNoUHJvZmlsZScsXG4gICAgICAnRGVsZXRlTGF1bmNoUHJvZmlsZU1lbWJlcicsXG4gICAgICAnRGVsZXRlU3RyZWFtaW5nSW1hZ2UnLFxuICAgICAgJ0RlbGV0ZVN0cmVhbWluZ1Nlc3Npb24nLFxuICAgICAgJ0RlbGV0ZVN0dWRpbycsXG4gICAgICAnRGVsZXRlU3R1ZGlvQ29tcG9uZW50JyxcbiAgICAgICdEZWxldGVTdHVkaW9NZW1iZXInLFxuICAgICAgJ1B1dExhdW5jaFByb2ZpbGVNZW1iZXJzJyxcbiAgICAgICdQdXRTdHVkaW9Mb2dFdmVudHMnLFxuICAgICAgJ1B1dFN0dWRpb01lbWJlcnMnLFxuICAgICAgJ1N0YXJ0U3RyZWFtaW5nU2Vzc2lvbicsXG4gICAgICAnU3RhcnRTdHVkaW9TU09Db25maWd1cmF0aW9uUmVwYWlyJyxcbiAgICAgICdTdG9wU3RyZWFtaW5nU2Vzc2lvbicsXG4gICAgICAnVXBkYXRlTGF1bmNoUHJvZmlsZScsXG4gICAgICAnVXBkYXRlTGF1bmNoUHJvZmlsZU1lbWJlcicsXG4gICAgICAnVXBkYXRlU3RyZWFtaW5nSW1hZ2UnLFxuICAgICAgJ1VwZGF0ZVN0dWRpbycsXG4gICAgICAnVXBkYXRlU3R1ZGlvQ29tcG9uZW50J1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0dldEV1bGEnLFxuICAgICAgJ0dldEZlYXR1cmVNYXAnLFxuICAgICAgJ0dldExhdW5jaFByb2ZpbGUnLFxuICAgICAgJ0dldExhdW5jaFByb2ZpbGVEZXRhaWxzJyxcbiAgICAgICdHZXRMYXVuY2hQcm9maWxlSW5pdGlhbGl6YXRpb24nLFxuICAgICAgJ0dldExhdW5jaFByb2ZpbGVNZW1iZXInLFxuICAgICAgJ0dldFN0cmVhbWluZ0ltYWdlJyxcbiAgICAgICdHZXRTdHJlYW1pbmdTZXNzaW9uJyxcbiAgICAgICdHZXRTdHJlYW1pbmdTZXNzaW9uU3RyZWFtJyxcbiAgICAgICdHZXRTdHVkaW8nLFxuICAgICAgJ0dldFN0dWRpb0NvbXBvbmVudCcsXG4gICAgICAnR2V0U3R1ZGlvTWVtYmVyJyxcbiAgICAgICdMaXN0RXVsYUFjY2VwdGFuY2VzJyxcbiAgICAgICdMaXN0RXVsYXMnLFxuICAgICAgJ0xpc3RMYXVuY2hQcm9maWxlTWVtYmVycycsXG4gICAgICAnTGlzdExhdW5jaFByb2ZpbGVzJyxcbiAgICAgICdMaXN0U3RyZWFtaW5nSW1hZ2VzJyxcbiAgICAgICdMaXN0U3RyZWFtaW5nU2Vzc2lvbnMnLFxuICAgICAgJ0xpc3RTdHVkaW9Db21wb25lbnRzJyxcbiAgICAgICdMaXN0U3R1ZGlvTWVtYmVycycsXG4gICAgICAnTGlzdFN0dWRpb3MnLFxuICAgICAgJ0xpc3RUYWdzRm9yUmVzb3VyY2UnXG4gICAgXSxcbiAgICBUYWdnaW5nOiBbXG4gICAgICAnVGFnUmVzb3VyY2UnLFxuICAgICAgJ1VudGFnUmVzb3VyY2UnXG4gICAgXVxuICB9O1xuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBzdHVkaW8gdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TdHVkaW8uaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gc3R1ZGlvSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgc3R1ZGlvSWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmU3R1ZGlvSWQoKVxuICAgKi9cbiAgcHVibGljIG9uU3R1ZGlvKHN0dWRpb0lkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgTmltYmxlLmRlZmF1bHRQYXJ0aXRpb24gfTpuaW1ibGU6JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06c3R1ZGlvLyR7IHN0dWRpb0lkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBzdHJlYW1pbmctaW1hZ2UgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TdHJlYW1pbmdJbWFnZS5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBzdHJlYW1pbmdJbWFnZUlkIC0gSWRlbnRpZmllciBmb3IgdGhlIHN0cmVhbWluZ0ltYWdlSWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmU3R1ZGlvSWQoKVxuICAgKi9cbiAgcHVibGljIG9uU3RyZWFtaW5nSW1hZ2Uoc3RyZWFtaW5nSW1hZ2VJZDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8IE5pbWJsZS5kZWZhdWx0UGFydGl0aW9uIH06bmltYmxlOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OnN0cmVhbWluZy1pbWFnZS8keyBzdHJlYW1pbmdJbWFnZUlkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBzdHVkaW8tY29tcG9uZW50IHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfU3R1ZGlvQ29tcG9uZW50Lmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHN0dWRpb0NvbXBvbmVudElkIC0gSWRlbnRpZmllciBmb3IgdGhlIHN0dWRpb0NvbXBvbmVudElkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZlN0dWRpb0lkKClcbiAgICovXG4gIHB1YmxpYyBvblN0dWRpb0NvbXBvbmVudChzdHVkaW9Db21wb25lbnRJZDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8IE5pbWJsZS5kZWZhdWx0UGFydGl0aW9uIH06bmltYmxlOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OnN0dWRpby1jb21wb25lbnQvJHsgc3R1ZGlvQ29tcG9uZW50SWQgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGxhdW5jaC1wcm9maWxlIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGF1bmNoUHJvZmlsZS5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBsYXVuY2hQcm9maWxlSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgbGF1bmNoUHJvZmlsZUlkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZlN0dWRpb0lkKClcbiAgICovXG4gIHB1YmxpYyBvbkxhdW5jaFByb2ZpbGUobGF1bmNoUHJvZmlsZUlkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgTmltYmxlLmRlZmF1bHRQYXJ0aXRpb24gfTpuaW1ibGU6JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06bGF1bmNoLXByb2ZpbGUvJHsgbGF1bmNoUHJvZmlsZUlkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBzdHJlYW1pbmctc2Vzc2lvbiB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1N0cmVhbWluZ1Nlc3Npb24uaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gc3RyZWFtaW5nU2Vzc2lvbklkIC0gSWRlbnRpZmllciBmb3IgdGhlIHN0cmVhbWluZ1Nlc3Npb25JZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZDcmVhdGVkQnkoKVxuICAgKiAtIC5pZk93bmVkQnkoKVxuICAgKi9cbiAgcHVibGljIG9uU3RyZWFtaW5nU2Vzc2lvbihzdHJlYW1pbmdTZXNzaW9uSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBOaW1ibGUuZGVmYXVsdFBhcnRpdGlvbiB9Om5pbWJsZTokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTpzdHJlYW1pbmctc2Vzc2lvbi8keyBzdHJlYW1pbmdTZXNzaW9uSWQgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGV1bGEgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FdWxhLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIGV1bGFJZCAtIElkZW50aWZpZXIgZm9yIHRoZSBldWxhSWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICovXG4gIHB1YmxpYyBvbkV1bGEoZXVsYUlkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgTmltYmxlLmRlZmF1bHRQYXJ0aXRpb24gfTpuaW1ibGU6JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06ZXVsYS8keyBldWxhSWQgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGV1bGEtYWNjZXB0YW5jZSB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0V1bGFBY2NlcHRhbmNlLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIGV1bGFBY2NlcHRhbmNlSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgZXVsYUFjY2VwdGFuY2VJZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZlN0dWRpb0lkKClcbiAgICovXG4gIHB1YmxpYyBvbkV1bGFBY2NlcHRhbmNlKGV1bGFBY2NlcHRhbmNlSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBOaW1ibGUuZGVmYXVsdFBhcnRpdGlvbiB9Om5pbWJsZTokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTpldWxhLWFjY2VwdGFuY2UvJHsgZXVsYUFjY2VwdGFuY2VJZCB9YCk7XG4gIH1cblxuICAvKipcbiAgICogRmlsdGVycyBhY2Nlc3MgYnkgdGhlIGNyZWF0ZWRCeSByZXF1ZXN0IHBhcmFtZXRlciBvciB0aGUgSUQgb2YgdGhlIGNyZWF0b3Igb2YgdGhlIHJlc291cmNlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uaW1ibGUtc3R1ZGlvL2xhdGVzdC91c2VyZ3VpZGUvc2VjdXJpdHktaWFtLXNlcnZpY2Utd2l0aC1pYW0uaHRtbFxuICAgKlxuICAgKiBBcHBsaWVzIHRvIGFjdGlvbnM6XG4gICAqIC0gLnRvTGlzdFN0cmVhbWluZ1Nlc3Npb25zKClcbiAgICpcbiAgICogQXBwbGllcyB0byByZXNvdXJjZSB0eXBlczpcbiAgICogLSBzdHJlYW1pbmctc2Vzc2lvblxuICAgKlxuICAgKiBAcGFyYW0gdmFsdWUgVGhlIHZhbHVlKHMpIHRvIGNoZWNrXG4gICAqIEBwYXJhbSBvcGVyYXRvciBXb3JrcyB3aXRoIFtzdHJpbmcgb3BlcmF0b3JzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX2NvbmRpdGlvbl9vcGVyYXRvcnMuaHRtbCNDb25kaXRpb25zX1N0cmluZykuICoqRGVmYXVsdDoqKiBgU3RyaW5nTGlrZWBcbiAgICovXG4gIHB1YmxpYyBpZkNyZWF0ZWRCeSh2YWx1ZTogc3RyaW5nIHwgc3RyaW5nW10sIG9wZXJhdG9yPzogT3BlcmF0b3IgfCBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5pZihgY3JlYXRlZEJ5YCwgdmFsdWUsIG9wZXJhdG9yIHx8ICdTdHJpbmdMaWtlJyk7XG4gIH1cblxuICAvKipcbiAgICogRmlsdGVycyBhY2Nlc3MgYnkgdGhlIG93bmVkQnkgcmVxdWVzdCBwYXJhbWV0ZXIgb3IgdGhlIElEIG9mIHRoZSBvd25lciBvZiB0aGUgcmVzb3VyY2VcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25pbWJsZS1zdHVkaW8vbGF0ZXN0L3VzZXJndWlkZS9zZWN1cml0eS1pYW0tc2VydmljZS13aXRoLWlhbS5odG1sXG4gICAqXG4gICAqIEFwcGxpZXMgdG8gYWN0aW9uczpcbiAgICogLSAudG9MaXN0U3RyZWFtaW5nU2Vzc2lvbnMoKVxuICAgKlxuICAgKiBBcHBsaWVzIHRvIHJlc291cmNlIHR5cGVzOlxuICAgKiAtIHN0cmVhbWluZy1zZXNzaW9uXG4gICAqXG4gICAqIEBwYXJhbSB2YWx1ZSBUaGUgdmFsdWUocykgdG8gY2hlY2tcbiAgICogQHBhcmFtIG9wZXJhdG9yIFdvcmtzIHdpdGggW3N0cmluZyBvcGVyYXRvcnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfY29uZGl0aW9uX29wZXJhdG9ycy5odG1sI0NvbmRpdGlvbnNfU3RyaW5nKS4gKipEZWZhdWx0OioqIGBTdHJpbmdMaWtlYFxuICAgKi9cbiAgcHVibGljIGlmT3duZWRCeSh2YWx1ZTogc3RyaW5nIHwgc3RyaW5nW10sIG9wZXJhdG9yPzogT3BlcmF0b3IgfCBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5pZihgb3duZWRCeWAsIHZhbHVlLCBvcGVyYXRvciB8fCAnU3RyaW5nTGlrZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEZpbHRlcnMgYWNjZXNzIGJ5IHRoZSBwcmluY2lwYWxJZCByZXF1ZXN0IHBhcmFtZXRlclxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvdXNlcmd1aWRlL3NlY3VyaXR5LWlhbS1zZXJ2aWNlLXdpdGgtaWFtLmh0bWxcbiAgICpcbiAgICogQXBwbGllcyB0byBhY3Rpb25zOlxuICAgKiAtIC50b0xpc3RMYXVuY2hQcm9maWxlcygpXG4gICAqXG4gICAqIEBwYXJhbSB2YWx1ZSBUaGUgdmFsdWUocykgdG8gY2hlY2tcbiAgICogQHBhcmFtIG9wZXJhdG9yIFdvcmtzIHdpdGggW3N0cmluZyBvcGVyYXRvcnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfY29uZGl0aW9uX29wZXJhdG9ycy5odG1sI0NvbmRpdGlvbnNfU3RyaW5nKS4gKipEZWZhdWx0OioqIGBTdHJpbmdMaWtlYFxuICAgKi9cbiAgcHVibGljIGlmUHJpbmNpcGFsSWQodmFsdWU6IHN0cmluZyB8IHN0cmluZ1tdLCBvcGVyYXRvcj86IE9wZXJhdG9yIHwgc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMuaWYoYHByaW5jaXBhbElkYCwgdmFsdWUsIG9wZXJhdG9yIHx8ICdTdHJpbmdMaWtlJyk7XG4gIH1cblxuICAvKipcbiAgICogRmlsdGVycyBhY2Nlc3MgYnkgdGhlIElEIG9mIHRoZSBsb2dnZWQgaW4gdXNlclxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvdXNlcmd1aWRlL3NlY3VyaXR5LWlhbS1zZXJ2aWNlLXdpdGgtaWFtLmh0bWxcbiAgICpcbiAgICogQXBwbGllcyB0byBhY3Rpb25zOlxuICAgKiAtIC50b0NyZWF0ZVN0cmVhbWluZ1Nlc3Npb25TdHJlYW0oKVxuICAgKiAtIC50b0RlbGV0ZVN0cmVhbWluZ1Nlc3Npb24oKVxuICAgKiAtIC50b0dldFN0cmVhbWluZ1Nlc3Npb24oKVxuICAgKiAtIC50b0dldFN0cmVhbWluZ1Nlc3Npb25TdHJlYW0oKVxuICAgKiAtIC50b0xpc3RMYXVuY2hQcm9maWxlcygpXG4gICAqIC0gLnRvTGlzdFN0cmVhbWluZ1Nlc3Npb25zKClcbiAgICogLSAudG9TdGFydFN0cmVhbWluZ1Nlc3Npb24oKVxuICAgKiAtIC50b1N0b3BTdHJlYW1pbmdTZXNzaW9uKClcbiAgICpcbiAgICogQHBhcmFtIHZhbHVlIFRoZSB2YWx1ZShzKSB0byBjaGVja1xuICAgKiBAcGFyYW0gb3BlcmF0b3IgV29ya3Mgd2l0aCBbc3RyaW5nIG9wZXJhdG9yc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19jb25kaXRpb25fb3BlcmF0b3JzLmh0bWwjQ29uZGl0aW9uc19TdHJpbmcpLiAqKkRlZmF1bHQ6KiogYFN0cmluZ0xpa2VgXG4gICAqL1xuICBwdWJsaWMgaWZSZXF1ZXN0ZXJQcmluY2lwYWxJZCh2YWx1ZTogc3RyaW5nIHwgc3RyaW5nW10sIG9wZXJhdG9yPzogT3BlcmF0b3IgfCBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5pZihgcmVxdWVzdGVyUHJpbmNpcGFsSWRgLCB2YWx1ZSwgb3BlcmF0b3IgfHwgJ1N0cmluZ0xpa2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBGaWx0ZXJzIGFjY2VzcyBieSBhIHNwZWNpZmljIHN0dWRpb1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmltYmxlLXN0dWRpby9sYXRlc3QvdXNlcmd1aWRlL3NlY3VyaXR5LWlhbS1zZXJ2aWNlLXdpdGgtaWFtLmh0bWxcbiAgICpcbiAgICogQXBwbGllcyB0byByZXNvdXJjZSB0eXBlczpcbiAgICogLSBzdHVkaW9cbiAgICogLSBzdHJlYW1pbmctaW1hZ2VcbiAgICogLSBzdHVkaW8tY29tcG9uZW50XG4gICAqIC0gbGF1bmNoLXByb2ZpbGVcbiAgICogLSBldWxhLWFjY2VwdGFuY2VcbiAgICpcbiAgICogQHBhcmFtIHZhbHVlIFRoZSB2YWx1ZShzKSB0byBjaGVja1xuICAgKiBAcGFyYW0gb3BlcmF0b3IgV29ya3Mgd2l0aCBbYXJuIG9wZXJhdG9yc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19jb25kaXRpb25fb3BlcmF0b3JzLmh0bWwjQ29uZGl0aW9uc19BUk4pLiAqKkRlZmF1bHQ6KiogYEFybkxpa2VgXG4gICAqL1xuICBwdWJsaWMgaWZTdHVkaW9JZCh2YWx1ZTogc3RyaW5nIHwgc3RyaW5nW10sIG9wZXJhdG9yPzogT3BlcmF0b3IgfCBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5pZihgc3R1ZGlvSWRgLCB2YWx1ZSwgb3BlcmF0b3IgfHwgJ0Fybkxpa2UnKTtcbiAgfVxufVxuIl19