"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53domains = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Route53domains extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'route53domains';
        this.accessLevelList = {
            Write: [
                'AcceptDomainTransferFromAnotherAwsAccount',
                'CancelDomainTransferToAnotherAwsAccount',
                'DeleteDomain',
                'DisableDomainAutoRenew',
                'DisableDomainTransferLock',
                'EnableDomainAutoRenew',
                'EnableDomainTransferLock',
                'RegisterDomain',
                'RejectDomainTransferFromAnotherAwsAccount',
                'RenewDomain',
                'ResendContactReachabilityEmail',
                'RetrieveDomainAuthCode',
                'TransferDomain',
                'TransferDomainToAnotherAwsAccount',
                'UpdateDomainContact',
                'UpdateDomainContactPrivacy',
                'UpdateDomainNameservers'
            ],
            Read: [
                'CheckDomainAvailability',
                'CheckDomainTransferability',
                'GetContactReachabilityStatus',
                'GetDomainDetail',
                'GetDomainSuggestions',
                'GetOperationDetail',
                'ListTagsForDomain',
                'ViewBilling'
            ],
            Tagging: [
                'DeleteTagsForDomain',
                'UpdateTagsForDomain'
            ],
            List: [
                'ListDomains',
                'ListOperations',
                'ListPrices'
            ]
        };
    }
    /**
     * Grants permission to accept the transfer of a domain from another AWS account to the current AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html
     */
    toAcceptDomainTransferFromAnotherAwsAccount() {
        return this.to('AcceptDomainTransferFromAnotherAwsAccount');
    }
    /**
     * Grants permission to cancel the transfer of a domain from the current AWS account to another AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html
     */
    toCancelDomainTransferToAnotherAwsAccount() {
        return this.to('CancelDomainTransferToAnotherAwsAccount');
    }
    /**
     * Grants permission to check the availability of one domain name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainAvailability.html
     */
    toCheckDomainAvailability() {
        return this.to('CheckDomainAvailability');
    }
    /**
     * Grants permission to check whether a domain name can be transferred to Amazon Route 53
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainTransferability.html
     */
    toCheckDomainTransferability() {
        return this.to('CheckDomainTransferability');
    }
    /**
     * Grants permission to delete domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteDomain.html
     */
    toDeleteDomain() {
        return this.to('DeleteDomain');
    }
    /**
     * Grants permission to delete the specified tags for a domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteTagsForDomain.html
     */
    toDeleteTagsForDomain() {
        return this.to('DeleteTagsForDomain');
    }
    /**
     * Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     */
    toDisableDomainAutoRenew() {
        return this.to('DisableDomainAutoRenew');
    }
    /**
     * Grants permission to remove the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainTransferLock.html
     */
    toDisableDomainTransferLock() {
        return this.to('DisableDomainTransferLock');
    }
    /**
     * Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     */
    toEnableDomainAutoRenew() {
        return this.to('EnableDomainAutoRenew');
    }
    /**
     * Grants permission to set the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_EnableDomainTransferLock.html
     */
    toEnableDomainTransferLock() {
        return this.to('EnableDomainTransferLock');
    }
    /**
     * Grants permission to get information about whether the registrant contact has responded for operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetContactReachabilityStatus.html
     */
    toGetContactReachabilityStatus() {
        return this.to('GetContactReachabilityStatus');
    }
    /**
     * Grants permission to get detailed information about a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainDetail.html
     */
    toGetDomainDetail() {
        return this.to('GetDomainDetail');
    }
    /**
     * Grants permission to get a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainSuggestions.html
     */
    toGetDomainSuggestions() {
        return this.to('GetDomainSuggestions');
    }
    /**
     * Grants permission to get the current status of an operation that is not completed
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html
     */
    toGetOperationDetail() {
        return this.to('GetOperationDetail');
    }
    /**
     * Grants permission to list all the domain names registered with Amazon Route 53 for the current AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListDomains.html
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * Grants permission to list the operation IDs of operations that are not yet complete
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html
     */
    toListOperations() {
        return this.to('ListOperations');
    }
    /**
     * Grants permission to list the prices of operations for TLDs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListPrices.html
     */
    toListPrices() {
        return this.to('ListPrices');
    }
    /**
     * Grants permission to list all the tags that are associated with the specified domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListTagsForDomain.html
     */
    toListTagsForDomain() {
        return this.to('ListTagsForDomain');
    }
    /**
     * Grants permission to register domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RegisterDomain.html
     */
    toRegisterDomain() {
        return this.to('RegisterDomain');
    }
    /**
     * Grants permission to reject the transfer of a domain from another AWS account to the current AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html
     */
    toRejectDomainTransferFromAnotherAwsAccount() {
        return this.to('RejectDomainTransferFromAnotherAwsAccount');
    }
    /**
     * Grants permission to renew domains for the specified number of years
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RenewDomain.html
     */
    toRenewDomain() {
        return this.to('RenewDomain');
    }
    /**
     * Grants permission to resend the confirmation email to the current email address for the registrant contact for operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendContactReachabilityEmail.html
     */
    toResendContactReachabilityEmail() {
        return this.to('ResendContactReachabilityEmail');
    }
    /**
     * Grants permission to get the AuthCode for the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RetrieveDomainAuthCode.html
     */
    toRetrieveDomainAuthCode() {
        return this.to('RetrieveDomainAuthCode');
    }
    /**
     * Grants permission to transfer a domain from another registrar to Amazon Route 53
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomain.html
     */
    toTransferDomain() {
        return this.to('TransferDomain');
    }
    /**
     * Grants permission to transfer a domain from the current AWS account to another AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html
     */
    toTransferDomainToAnotherAwsAccount() {
        return this.to('TransferDomainToAnotherAwsAccount');
    }
    /**
     * Grants permission to update the contact information for domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContact.html
     */
    toUpdateDomainContact() {
        return this.to('UpdateDomainContact');
    }
    /**
     * Grants permission to update the domain contact privacy setting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContactPrivacy.html
     */
    toUpdateDomainContactPrivacy() {
        return this.to('UpdateDomainContactPrivacy');
    }
    /**
     * Grants permission to replace the current set of name servers for a domain with the specified set of name servers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html
     */
    toUpdateDomainNameservers() {
        return this.to('UpdateDomainNameservers');
    }
    /**
     * Grants permission to add or update tags for a specified domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateTagsForDomain.html
     */
    toUpdateTagsForDomain() {
        return this.to('UpdateTagsForDomain');
    }
    /**
     * Grants permission to get all the domain-related billing records for the current AWS account for a specified period
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ViewBilling.html
     */
    toViewBilling() {
        return this.to('ViewBilling');
    }
}
exports.Route53domains = Route53domains;
_a = JSII_RTTI_SYMBOL_1;
Route53domains[_a] = { fqn: "iam-floyd.Route53domains", version: "0.457.0" };
//# sourceMappingURL=data:application/json;base64,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