import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [tax](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstaxsettings.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Tax extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [tax](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstaxsettings.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to view tax exemptions data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toGetExemptions(): this;
    /**
     * Grants permission to retrieve tax interview data
     *
     * Access Level: Read
     */
    toGetTaxInterview(): this;
    /**
     * Grants permission to view tax registrations data
     *
     * Access Level: Read
     */
    toGetTaxRegistration(): this;
    /**
     * Grants permission to update tax interview data
     *
     * Access Level: Write
     */
    toPutTaxInterview(): this;
    /**
     * Grants permission to update tax registrations data
     *
     * Access Level: Write
     */
    toPutTaxRegistration(): this;
    /**
     * Grants permission to update tax exemptions data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toUpdateExemptions(): this;
    protected accessLevelList: AccessLevelList;
}
