"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Translate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Translate extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'translate';
        this.accessLevelList = {
            Write: [
                'CreateParallelData',
                'DeleteParallelData',
                'DeleteTerminology',
                'ImportTerminology',
                'StartTextTranslationJob',
                'StopTextTranslationJob',
                'UpdateParallelData'
            ],
            Read: [
                'DescribeTextTranslationJob',
                'GetParallelData',
                'GetTerminology',
                'ListTagsForResource',
                'TranslateText'
            ],
            List: [
                'ListLanguages',
                'ListParallelData',
                'ListTerminologies',
                'ListTextTranslationJobs'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create a Parallel Data
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_CreateParallelData.html
     */
    toCreateParallelData() {
        return this.to('CreateParallelData');
    }
    /**
     * Grants permission to delete a Parallel Data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_DeleteParallelData.html
     */
    toDeleteParallelData() {
        return this.to('DeleteParallelData');
    }
    /**
     * Grants permission to delete a terminology
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_DeleteTerminology.html
     */
    toDeleteTerminology() {
        return this.to('DeleteTerminology');
    }
    /**
     * Grants permission to get the properties associated with an asynchronous batch translation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_DescribeTextTranslationJob.html
     */
    toDescribeTextTranslationJob() {
        return this.to('DescribeTextTranslationJob');
    }
    /**
     * Grants permission to get a Parallel Data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_GetParallelData.html
     */
    toGetParallelData() {
        return this.to('GetParallelData');
    }
    /**
     * Grants permission to retrieve a terminology
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_GetTerminology.html
     */
    toGetTerminology() {
        return this.to('GetTerminology');
    }
    /**
     * Grants permission to create or update a terminology, depending on whether or not one already exists for the given terminology name
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_ImportTerminology.html
     */
    toImportTerminology() {
        return this.to('ImportTerminology');
    }
    /**
     * Grants permission to list supported languages
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_ListLanguages.html
     */
    toListLanguages() {
        return this.to('ListLanguages');
    }
    /**
     * Grants permission to list Parallel Data associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_ListParallelData.html
     */
    toListParallelData() {
        return this.to('ListParallelData');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list terminologies associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_ListTerminologies.html
     */
    toListTerminologies() {
        return this.to('ListTerminologies');
    }
    /**
     * Grants permission to list batch translation jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_ListTextTranslationJobs.html
     */
    toListTextTranslationJobs() {
        return this.to('ListTextTranslationJobs');
    }
    /**
     * Grants permission to start an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_StartTextTranslationJob.html
     */
    toStartTextTranslationJob() {
        return this.to('StartTextTranslationJob');
    }
    /**
     * Grants permission to stop an asynchronous batch translation job that is in progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_StopTextTranslationJob.html
     */
    toStopTextTranslationJob() {
        return this.to('StopTextTranslationJob');
    }
    /**
     * Grants permission to tag a resource with given key value pairs
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to translate text from a source language to a target language
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_TranslateText.html
     */
    toTranslateText() {
        return this.to('TranslateText');
    }
    /**
     * Grants permission to untag a resource with given key
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an existing Parallel Data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/APIReference/API_UpdateParallelData.html
     */
    toUpdateParallelData() {
        return this.to('UpdateParallelData');
    }
    /**
     * Adds a resource of type terminology to the statement
     *
     * https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTerminology(resourceName, account, region, partition) {
        return this.on(`arn:${partition || Translate.defaultPartition}:translate:${region || '*'}:${account || '*'}:terminology/${resourceName}`);
    }
    /**
     * Adds a resource of type parallel-data to the statement
     *
     * https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onParallelData(resourceName, account, region, partition) {
        return this.on(`arn:${partition || Translate.defaultPartition}:translate:${region || '*'}:${account || '*'}:parallel-data/${resourceName}`);
    }
}
exports.Translate = Translate;
_a = JSII_RTTI_SYMBOL_1;
Translate[_a] = { fqn: "iam-floyd.Translate", version: "0.457.0" };
//# sourceMappingURL=data:application/json;base64,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