# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2019-05-30 07:10
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.postgres.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Webhook',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True, db_index=True)),
                ('target_url', models.CharField(max_length=255)),
                ('is_active', models.BooleanField(default=True)),
                ('secret_key', models.CharField(blank=True, max_length=124, null=True)),
                ('event_type', models.CharField(max_length=124)),
                ('callback', models.CharField(blank=True, max_length=64, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='WebhookEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True, db_index=True)),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('request_payload', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('response_content', models.TextField()),
                ('response_http_status', models.IntegerField()),
                ('delivered', models.BooleanField(default=False)),
                ('request_datetimes', django.contrib.postgres.fields.ArrayField(base_field=models.DateTimeField(blank=True, null=True), default=list, size=None)),
                ('webhook', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='whisperer.Webhook')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AlterUniqueTogether(
            name='webhook',
            unique_together=set([('user', 'target_url', 'event_type')]),
        ),
    ]
