"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KafkaCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [kafka-cluster](https://docs.aws.amazon.com/service-authorization/latest/reference/list_apachekafkaapisforamazonmskclusters.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class KafkaCluster extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [kafka-cluster](https://docs.aws.amazon.com/service-authorization/latest/reference/list_apachekafkaapisforamazonmskclusters.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'kafka-cluster';
        this.accessLevelList = {
            Write: [
                'AlterCluster',
                'AlterClusterDynamicConfiguration',
                'AlterGroup',
                'AlterTopic',
                'AlterTopicDynamicConfiguration',
                'AlterTransactionalId',
                'Connect',
                'CreateTopic',
                'DeleteGroup',
                'DeleteTopic',
                'WriteData',
                'WriteDataIdempotently'
            ],
            List: [
                'DescribeCluster',
                'DescribeClusterDynamicConfiguration',
                'DescribeGroup',
                'DescribeTopic',
                'DescribeTopicDynamicConfiguration',
                'DescribeTransactionalId'
            ],
            Read: [
                'ReadData'
            ]
        };
    }
    /**
     * Grants permission to alter various aspects of the cluster, equivalent to Apache Kafka's ALTER CLUSTER ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeCluster
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterCluster() {
        return this.to('AlterCluster');
    }
    /**
     * Grants permission to alter the dynamic configuration of a cluster, equivalent to Apache Kafka's ALTER_CONFIGS CLUSTER ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeClusterDynamicConfiguration
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterClusterDynamicConfiguration() {
        return this.to('AlterClusterDynamicConfiguration');
    }
    /**
     * Grants permission to join groups on a cluster, equivalent to Apache Kafka's READ GROUP ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeGroup
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterGroup() {
        return this.to('AlterGroup');
    }
    /**
     * Grants permission to alter topics on a cluster, equivalent to Apache Kafka's ALTER TOPIC ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTopic
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterTopic() {
        return this.to('AlterTopic');
    }
    /**
     * Grants permission to alter the dynamic configuration of topics on a cluster, equivalent to Apache Kafka's ALTER_CONFIGS TOPIC ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTopicDynamicConfiguration
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterTopicDynamicConfiguration() {
        return this.to('AlterTopicDynamicConfiguration');
    }
    /**
     * Grants permission to alter transactional IDs on a cluster, equivalent to Apache Kafka's WRITE TRANSACTIONAL_ID ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTransactionalId
     * - kafka-cluster:WriteData
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toAlterTransactionalId() {
        return this.to('AlterTransactionalId');
    }
    /**
     * Grants permission to connect and authenticate to the cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toConnect() {
        return this.to('Connect');
    }
    /**
     * Grants permission to create topics on a cluster, equivalent to Apache Kafka's CREATE CLUSTER/TOPIC ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toCreateTopic() {
        return this.to('CreateTopic');
    }
    /**
     * Grants permission to delete groups on a cluster, equivalent to Apache Kafka's DELETE GROUP ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeGroup
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDeleteGroup() {
        return this.to('DeleteGroup');
    }
    /**
     * Grants permission to delete topics on a cluster, equivalent to Apache Kafka's DELETE TOPIC ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTopic
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDeleteTopic() {
        return this.to('DeleteTopic');
    }
    /**
     * Grants permission to describe various aspects of the cluster, equivalent to Apache Kafka's DESCRIBE CLUSTER ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeCluster() {
        return this.to('DescribeCluster');
    }
    /**
     * Grants permission to describe the dynamic configuration of a cluster, equivalent to Apache Kafka's DESCRIBE_CONFIGS CLUSTER ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeClusterDynamicConfiguration() {
        return this.to('DescribeClusterDynamicConfiguration');
    }
    /**
     * Grants permission to describe groups on a cluster, equivalent to Apache Kafka's DESCRIBE GROUP ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeGroup() {
        return this.to('DescribeGroup');
    }
    /**
     * Grants permission to describe topics on a cluster, equivalent to Apache Kafka's DESCRIBE TOPIC ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeTopic() {
        return this.to('DescribeTopic');
    }
    /**
     * Grants permission to describe the dynamic configuration of topics on a cluster, equivalent to Apache Kafka's DESCRIBE_CONFIGS TOPIC ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeTopicDynamicConfiguration() {
        return this.to('DescribeTopicDynamicConfiguration');
    }
    /**
     * Grants permission to describe transactional IDs on a cluster, equivalent to Apache Kafka's DESCRIBE TRANSACTIONAL_ID ACL
     *
     * Access Level: List
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toDescribeTransactionalId() {
        return this.to('DescribeTransactionalId');
    }
    /**
     * Grants permission to read data from topics on a cluster, equivalent to Apache Kafka's READ TOPIC ACL
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - kafka-cluster:AlterGroup
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTopic
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toReadData() {
        return this.to('ReadData');
    }
    /**
     * Grants permission to write data to topics on a cluster, equivalent to Apache Kafka's WRITE TOPIC ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:DescribeTopic
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toWriteData() {
        return this.to('WriteData');
    }
    /**
     * Grants permission to write data idempotently on a cluster, equivalent to Apache Kafka's IDEMPOTENT_WRITE CLUSTER ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kafka-cluster:Connect
     * - kafka-cluster:WriteData
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#actions
     */
    toWriteDataIdempotently() {
        return this.to('WriteDataIdempotently');
    }
    /**
     * Adds a resource of type cluster to the statement
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#msk-iam-resources
     *
     * @param clusterName - Identifier for the clusterName.
     * @param clusterUuid - Identifier for the clusterUuid.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCluster(clusterName, clusterUuid, account, region, partition) {
        return this.on(`arn:${partition || KafkaCluster.defaultPartition}:kafka:${region || '*'}:${account || '*'}:cluster/${clusterName}/${clusterUuid}`);
    }
    /**
     * Adds a resource of type topic to the statement
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#msk-iam-resources
     *
     * @param clusterName - Identifier for the clusterName.
     * @param clusterUuid - Identifier for the clusterUuid.
     * @param topicName - Identifier for the topicName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTopic(clusterName, clusterUuid, topicName, account, region, partition) {
        return this.on(`arn:${partition || KafkaCluster.defaultPartition}:kafka:${region || '*'}:${account || '*'}:topic/${clusterName}/${clusterUuid}/${topicName}`);
    }
    /**
     * Adds a resource of type group to the statement
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#msk-iam-resources
     *
     * @param clusterName - Identifier for the clusterName.
     * @param clusterUuid - Identifier for the clusterUuid.
     * @param groupName - Identifier for the groupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGroup(clusterName, clusterUuid, groupName, account, region, partition) {
        return this.on(`arn:${partition || KafkaCluster.defaultPartition}:kafka:${region || '*'}:${account || '*'}:group/${clusterName}/${clusterUuid}/${groupName}`);
    }
    /**
     * Adds a resource of type transactional-id to the statement
     *
     * https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html#msk-iam-resources
     *
     * @param clusterName - Identifier for the clusterName.
     * @param clusterUuid - Identifier for the clusterUuid.
     * @param transactionalId - Identifier for the transactionalId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTransactionalId(clusterName, clusterUuid, transactionalId, account, region, partition) {
        return this.on(`arn:${partition || KafkaCluster.defaultPartition}:kafka:${region || '*'}:${account || '*'}:transactional-id/${clusterName}/${clusterUuid}/${transactionalId}`);
    }
}
exports.KafkaCluster = KafkaCluster;
_a = JSII_RTTI_SYMBOL_1;
KafkaCluster[_a] = { fqn: "iam-floyd.KafkaCluster", version: "0.485.0" };
//# sourceMappingURL=data:application/json;base64,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