import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [artifact](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsartifact.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Artifact extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [artifact](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsartifact.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to accept an AWS agreement that has not yet been accepted by the customer account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/managing-agreements.html
     */
    toAcceptAgreement(): this;
    /**
     * Grants permission to download an AWS agreement that has not yet been accepted or a customer agreement that has been accepted by the customer account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/managing-agreements.html
     */
    toDownloadAgreement(): this;
    /**
     * Grants permission to download an AWS compliance report package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/getting-started.html
     */
    toGet(): this;
    /**
     * Grants permission to download a report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/getting-started.html
     */
    toGetReport(): this;
    /**
     * Grants permission to download metadata associated with a report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/getting-started.html
     */
    toGetReportMetadata(): this;
    /**
     * Grants permission to download a term associated with a report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/getting-started.html
     */
    toGetTermForReport(): this;
    /**
     * Grants permission to list reports in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/getting-started.html
     */
    toListReports(): this;
    /**
     * Grants permission to terminate a customer agreement that was previously accepted by the customer account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/managing-agreements.html
     */
    toTerminateAgreement(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type report-package to the statement
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/what-is-aws-artifact.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onReportPackage(resourceName: string, partition?: string): this;
    /**
     * Adds a resource of type customer-agreement to the statement
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/managing-agreements.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCustomerAgreement(resourceName: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type agreement to the statement
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/managing-agreements.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAgreement(resourceName: string, partition?: string): this;
    /**
     * Adds a resource of type report to the statement
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/what-is-aws-artifact.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onReport(resourceName: string, region?: string, partition?: string): this;
}
