import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [ec2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Ec2 extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [ec2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to accept an Elastic IP address transfer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptAddressTransfer.html
     */
    toAcceptAddressTransfer(): this;
    /**
     * Grants permission to accept a Convertible Reserved Instance exchange quote
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptReservedInstancesExchangeQuote.html
     */
    toAcceptReservedInstancesExchangeQuote(): this;
    /**
     * Grants permission to accept a request to associate subnets with a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptTransitGatewayMulticastDomainAssociations.html
     */
    toAcceptTransitGatewayMulticastDomainAssociations(): this;
    /**
     * Grants permission to accept a transit gateway peering attachment request
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptTransitGatewayPeeringAttachment.html
     */
    toAcceptTransitGatewayPeeringAttachment(): this;
    /**
     * Grants permission to accept a request to attach a VPC to a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptTransitGatewayVpcAttachment.html
     */
    toAcceptTransitGatewayVpcAttachment(): this;
    /**
     * Grants permission to accept one or more interface VPC endpoint connections to your VPC endpoint service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptVpcEndpointConnections.html
     */
    toAcceptVpcEndpointConnections(): this;
    /**
     * Grants permission to accept a VPC peering connection request
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptVpcPeeringConnection.html
     */
    toAcceptVpcPeeringConnection(): this;
    /**
     * Grants permission to advertise an IP address range that is provisioned for use in AWS through bring your own IP addresses (BYOIP)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html
     */
    toAdvertiseByoipCidr(): this;
    /**
     * Grants permission to allocate an Elastic IP address (EIP) to your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AllocateAddress.html
     */
    toAllocateAddress(): this;
    /**
     * Grants permission to allocate a Dedicated Host to your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AllocateHosts.html
     */
    toAllocateHosts(): this;
    /**
     * Grants permission to allocate a CIDR from an Amazon VPC IP Address Manager (IPAM) pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AllocateIpamPoolCidr.html
     */
    toAllocateIpamPoolCidr(): this;
    /**
     * Grants permission to apply a security group to the association between a Client VPN endpoint and a target network
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ApplySecurityGroupsToClientVpnTargetNetwork.html
     */
    toApplySecurityGroupsToClientVpnTargetNetwork(): this;
    /**
     * Grants permission to assign one or more IPv6 addresses to a network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssignIpv6Addresses.html
     */
    toAssignIpv6Addresses(): this;
    /**
     * Grants permission to assign one or more secondary private IP addresses to a network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssignPrivateIpAddresses.html
     */
    toAssignPrivateIpAddresses(): this;
    /**
     * Grants permission to associate an Elastic IP address (EIP) with an instance or a network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateAddress.html
     */
    toAssociateAddress(): this;
    /**
     * Grants permission to associate a target network with a Client VPN endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateClientVpnTargetNetwork.html
     */
    toAssociateClientVpnTargetNetwork(): this;
    /**
     * Grants permission to associate or disassociate a set of DHCP options with a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateDhcpOptions.html
     */
    toAssociateDhcpOptions(): this;
    /**
     * Grants permission to associate an ACM certificate with an IAM role to be used in an EC2 Enclave
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateEnclaveCertificateIamRole.html
     */
    toAssociateEnclaveCertificateIamRole(): this;
    /**
     * Grants permission to associate an IAM instance profile with a running or stopped instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html
     */
    toAssociateIamInstanceProfile(): this;
    /**
     * Grants permission to associate one or more targets with an event window
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateInstanceEventWindow.html
     */
    toAssociateInstanceEventWindow(): this;
    /**
     * Grants permission to associate an IPAM resource discovery with an Amazon VPC IPAM
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIpamResourceDiscovery.html
     */
    toAssociateIpamResourceDiscovery(): this;
    /**
     * Grants permission to associate a subnet or gateway with a route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateRouteTable.html
     */
    toAssociateRouteTable(): this;
    /**
     * Grants permission to associate a CIDR block with a subnet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateSubnetCidrBlock.html
     */
    toAssociateSubnetCidrBlock(): this;
    /**
     * Grants permission to associate an attachment and list of subnets with a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateTransitGatewayMulticastDomain.html
     */
    toAssociateTransitGatewayMulticastDomain(): this;
    /**
     * Grants permission to associate a policy table with a transit gateway attachment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateTransitGatewayPolicyTable.html
     */
    toAssociateTransitGatewayPolicyTable(): this;
    /**
     * Grants permission to associate an attachment with a transit gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateTransitGatewayRouteTable.html
     */
    toAssociateTransitGatewayRouteTable(): this;
    /**
     * Grants permission to associate a branch network interface with a trunk network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateTrunkInterface.html
     */
    toAssociateTrunkInterface(): this;
    /**
     * Grants permission to associate a CIDR block with a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateVpcCidrBlock.html
     */
    toAssociateVpcCidrBlock(): this;
    /**
     * Grants permission to link an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachClassicLinkVpc.html
     */
    toAttachClassicLinkVpc(): this;
    /**
     * Grants permission to attach an internet gateway to a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachInternetGateway.html
     */
    toAttachInternetGateway(): this;
    /**
     * Grants permission to attach a network interface to an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachNetworkInterface.html
     */
    toAttachNetworkInterface(): this;
    /**
     * Grants permission to attach a trust provider to a Verified Access instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachVerifiedAccessTrustProvider.html
     */
    toAttachVerifiedAccessTrustProvider(): this;
    /**
     * Grants permission to attach an EBS volume to a running or stopped instance and expose it to the instance with the specified device name
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachVolume.html
     */
    toAttachVolume(): this;
    /**
     * Grants permission to attach a virtual private gateway to a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachVpnGateway.html
     */
    toAttachVpnGateway(): this;
    /**
     * Grants permission to add an inbound authorization rule to a Client VPN endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AuthorizeClientVpnIngress.html
     */
    toAuthorizeClientVpnIngress(): this;
    /**
     * Grants permission to add one or more outbound rules to a VPC security group. Policies using the security-group-rule resource-level permission are only enforced when the API request includes TagSpecifications
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AuthorizeSecurityGroupEgress.html
     */
    toAuthorizeSecurityGroupEgress(): this;
    /**
     * Grants permission to add one or more inbound rules to a VPC security group. Policies using the security-group-rule resource-level permission are only enforced when the API request includes TagSpecifications
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AuthorizeSecurityGroupIngress.html
     */
    toAuthorizeSecurityGroupIngress(): this;
    /**
     * Grants permission to bundle an instance store-backed Windows instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BundleInstance.html
     */
    toBundleInstance(): this;
    /**
     * Grants permission to cancel a bundling operation
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelBundleTask.html
     */
    toCancelBundleTask(): this;
    /**
     * Grants permission to cancel a Capacity Reservation and release the reserved capacity
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelCapacityReservation.html
     */
    toCancelCapacityReservation(): this;
    /**
     * Grants permission to cancel one or more Capacity Reservation Fleets
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelCapacityReservationFleets.html
     */
    toCancelCapacityReservationFleets(): this;
    /**
     * Grants permission to cancel an active conversion task
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelConversionTask.html
     */
    toCancelConversionTask(): this;
    /**
     * Grants permission to cancel an active export task
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelExportTask.html
     */
    toCancelExportTask(): this;
    /**
     * Grants permission to remove your AWS account from the launch permissions for the specified AMI
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelImageLaunchPermission.html
     */
    toCancelImageLaunchPermission(): this;
    /**
     * Grants permission to cancel an in-process import virtual machine or import snapshot task
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelImportTask.html
     */
    toCancelImportTask(): this;
    /**
     * Grants permission to cancel a Reserved Instance listing on the Reserved Instance Marketplace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelReservedInstancesListing.html
     */
    toCancelReservedInstancesListing(): this;
    /**
     * Grants permission to cancel one or more Spot Fleet requests
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests.html
     */
    toCancelSpotFleetRequests(): this;
    /**
     * Grants permission to cancel one or more Spot Instance requests
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotInstanceRequests.html
     */
    toCancelSpotInstanceRequests(): this;
    /**
     * Grants permission to determine whether an owned product code is associated with an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ConfirmProductInstance.html
     */
    toConfirmProductInstance(): this;
    /**
     * Grants permission to copy a source Amazon FPGA image (AFI) to the current Region. Resource-level permissions specified for this action apply to the new AFI only. They do not apply to the source AFI
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopyFpgaImage.html
     */
    toCopyFpgaImage(): this;
    /**
     * Grants permission to copy an Amazon Machine Image (AMI) from a source Region to the current Region. Resource-level permissions specified for this action apply to the new AMI only. They do not apply to the source AMI
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopyImage.html
     */
    toCopyImage(): this;
    /**
     * Grants permission to copy a point-in-time snapshot of an EBS volume and store it in Amazon S3. Resource-level permissions specified for this action apply to the new snapshot only. They do not apply to the source snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html
     */
    toCopySnapshot(): this;
    /**
     * Grants permission to create a Capacity Reservation
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCapacityReservation.html
     */
    toCreateCapacityReservation(): this;
    /**
     * Grants permission to create a Capacity Reservation Fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCapacityReservationFleet.html
     */
    toCreateCapacityReservationFleet(): this;
    /**
     * Grants permission to create a carrier gateway and provides CSP connectivity to VPC customers
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCarrierGateway.html
     */
    toCreateCarrierGateway(): this;
    /**
     * Grants permission to create a Client VPN endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateClientVpnEndpoint.html
     */
    toCreateClientVpnEndpoint(): this;
    /**
     * Grants permission to add a network route to a Client VPN endpoint's route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateClientVpnRoute.html
     */
    toCreateClientVpnRoute(): this;
    /**
     * Grants permission to create a range of customer-owned IP (CoIP) addresses
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCoipCidr.html
     */
    toCreateCoipCidr(): this;
    /**
     * Grants permission to create a pool of customer-owned IP (CoIP) addresses
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCoipPool.html
     */
    toCreateCoipPool(): this;
    /**
     * Grants permission to allow a service to access a customer-owned IP (CoIP) pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/identity-access-management.html
     */
    toCreateCoipPoolPermission(): this;
    /**
     * Grants permission to create a customer gateway, which provides information to AWS about your customer gateway device
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCustomerGateway.html
     */
    toCreateCustomerGateway(): this;
    /**
     * Grants permission to create a default subnet in a specified Availability Zone in a default VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateDefaultSubnet.html
     */
    toCreateDefaultSubnet(): this;
    /**
     * Grants permission to create a default VPC with a default subnet in each Availability Zone
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateDefaultVpc.html
     */
    toCreateDefaultVpc(): this;
    /**
     * Grants permission to create a set of DHCP options for a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateDhcpOptions.html
     */
    toCreateDhcpOptions(): this;
    /**
     * Grants permission to create an egress-only internet gateway for a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateEgressOnlyInternetGateway.html
     */
    toCreateEgressOnlyInternetGateway(): this;
    /**
     * Grants permission to launch an EC2 Fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet.html
     */
    toCreateFleet(): this;
    /**
     * Grants permission to create one or more flow logs to capture IP traffic for a network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFlowLogs.html
     */
    toCreateFlowLogs(): this;
    /**
     * Grants permission to create an Amazon FPGA Image (AFI) from a design checkpoint (DCP)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFpgaImage.html
     */
    toCreateFpgaImage(): this;
    /**
     * Grants permission to create an Amazon EBS-backed AMI from a stopped or running Amazon EBS-backed instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html
     */
    toCreateImage(): this;
    /**
     * Grants permission to create an event window in which scheduled events for the associated Amazon EC2 instances can run
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateInstanceEventWindow.html
     */
    toCreateInstanceEventWindow(): this;
    /**
     * Grants permission to export a running or stopped instance to an Amazon S3 bucket
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateInstanceExportTask.html
     */
    toCreateInstanceExportTask(): this;
    /**
     * Grants permission to create an internet gateway for a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateInternetGateway.html
     */
    toCreateInternetGateway(): this;
    /**
     * Grants permission to create an Amazon VPC IP Address Manager (IPAM)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateIpam.html
     */
    toCreateIpam(): this;
    /**
     * Grants permission to create an IP address pool for Amazon VPC IP Address Manager (IPAM), which is a collection of contiguous IP address CIDRs
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateIpamPool.html
     */
    toCreateIpamPool(): this;
    /**
     * Grants permission to create an IPAM resource discovery
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateIpamResourceDiscovery.html
     */
    toCreateIpamResourceDiscovery(): this;
    /**
     * Grants permission to create an Amazon VPC IP Address Manager (IPAM) scope, which is the highest-level container within IPAM
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateIpamScope.html
     */
    toCreateIpamScope(): this;
    /**
     * Grants permission to create a 2048-bit RSA key pair
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html
     */
    toCreateKeyPair(): this;
    /**
     * Grants permission to create a launch template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html
     */
    toCreateLaunchTemplate(): this;
    /**
     * Grants permission to create a new version of a launch template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html
     */
    toCreateLaunchTemplateVersion(): this;
    /**
     * Grants permission to create a static route for a local gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLocalGatewayRoute.html
     */
    toCreateLocalGatewayRoute(): this;
    /**
     * Grants permission to create a local gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLocalGatewayRouteTable.html
     */
    toCreateLocalGatewayRouteTable(): this;
    /**
     * Grants permission to allow a service to access a local gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/identity-access-management.html
     */
    toCreateLocalGatewayRouteTablePermission(): this;
    /**
     * Grants permission to create a local gateway route table virtual interface group association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation.html
     */
    toCreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation(): this;
    /**
     * Grants permission to associate a VPC with a local gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLocalGatewayRouteTableVpcAssociation.html
     */
    toCreateLocalGatewayRouteTableVpcAssociation(): this;
    /**
     * Grants permission to create a managed prefix list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateManagedPrefixList.html
     */
    toCreateManagedPrefixList(): this;
    /**
     * Grants permission to create a NAT gateway in a subnet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNatGateway.html
     */
    toCreateNatGateway(): this;
    /**
     * Grants permission to create a network ACL in a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAcl.html
     */
    toCreateNetworkAcl(): this;
    /**
     * Grants permission to create a numbered entry (a rule) in a network ACL
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAclEntry.html
     */
    toCreateNetworkAclEntry(): this;
    /**
     * Grants permission to create a Network Access Scope
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInsightsAccessScope.html
     */
    toCreateNetworkInsightsAccessScope(): this;
    /**
     * Grants permission to create a path to analyze for reachability
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInsightsPath.html
     */
    toCreateNetworkInsightsPath(): this;
    /**
     * Grants permission to create a network interface in a subnet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html
     */
    toCreateNetworkInterface(): this;
    /**
     * Grants permission to create a permission for an AWS-authorized user to perform certain operations on a network interface
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterfacePermission.html
     */
    toCreateNetworkInterfacePermission(): this;
    /**
     * Grants permission to create a placement group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreatePlacementGroup.html
     */
    toCreatePlacementGroup(): this;
    /**
     * Grants permission to create a public IPv4 address pool for public IPv4 CIDRs that you own and bring to Amazon to manage with Amazon VPC IP Address Manager (IPAM)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreatePublicIpv4Pool.html
     */
    toCreatePublicIpv4Pool(): this;
    /**
     * Grants permission to create a root volume replacement task
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateReplaceRootVolumeTask.html
     */
    toCreateReplaceRootVolumeTask(): this;
    /**
     * Grants permission to create a listing for Standard Reserved Instances to be sold in the Reserved Instance Marketplace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateReservedInstancesListing.html
     */
    toCreateReservedInstancesListing(): this;
    /**
     * Grants permission to start a task that restores an AMI from an S3 object previously created by using CreateStoreImageTask
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRestoreImageTask.html
     */
    toCreateRestoreImageTask(): this;
    /**
     * Grants permission to create a route in a VPC route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRoute.html
     */
    toCreateRoute(): this;
    /**
     * Grants permission to create a route table for a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRouteTable.html
     */
    toCreateRouteTable(): this;
    /**
     * Grants permission to create a security group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html
     */
    toCreateSecurityGroup(): this;
    /**
     * Grants permission to create a snapshot of an EBS volume and store it in Amazon S3
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshot.html
     */
    toCreateSnapshot(): this;
    /**
     * Grants permission to create crash-consistent snapshots of multiple EBS volumes and store them in Amazon S3
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html
     */
    toCreateSnapshots(): this;
    /**
     * Grants permission to create a data feed for Spot Instances to view Spot Instance usage logs
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSpotDatafeedSubscription.html
     */
    toCreateSpotDatafeedSubscription(): this;
    /**
     * Grants permission to store an AMI as a single object in an S3 bucket
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html
     */
    toCreateStoreImageTask(): this;
    /**
     * Grants permission to create a subnet in a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSubnet.html
     */
    toCreateSubnet(): this;
    /**
     * Grants permission to create a subnet CIDR reservation
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSubnetCidrReservation.html
     */
    toCreateSubnetCidrReservation(): this;
    /**
     * Grants permission to add or overwrite one or more tags for Amazon EC2 resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifCreateAction()
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
     */
    toCreateTags(): this;
    /**
     * Grants permission to create a traffic mirror filter
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.html
     */
    toCreateTrafficMirrorFilter(): this;
    /**
     * Grants permission to create a traffic mirror filter rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.html
     */
    toCreateTrafficMirrorFilterRule(): this;
    /**
     * Grants permission to create a traffic mirror session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.html
     */
    toCreateTrafficMirrorSession(): this;
    /**
     * Grants permission to create a traffic mirror target
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorTarget.html
     */
    toCreateTrafficMirrorTarget(): this;
    /**
     * Grants permission to create a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGateway.html
     */
    toCreateTransitGateway(): this;
    /**
     * Grants permission to create a Connect attachment from a specified transit gateway attachment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayConnect.html
     */
    toCreateTransitGatewayConnect(): this;
    /**
     * Grants permission to create a Connect peer between a transit gateway and an appliance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayConnectPeer.html
     */
    toCreateTransitGatewayConnectPeer(): this;
    /**
     * Grants permission to create a multicast domain for a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayMulticastDomain.html
     */
    toCreateTransitGatewayMulticastDomain(): this;
    /**
     * Grants permission to request a transit gateway peering attachment between a requester and accepter transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayPeeringAttachment.html
     */
    toCreateTransitGatewayPeeringAttachment(): this;
    /**
     * Grants permission to create a transit gateway policy table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayPolicyTable.html
     */
    toCreateTransitGatewayPolicyTable(): this;
    /**
     * Grants permission to create a transit gateway prefix list reference
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayPrefixListReference.html
     */
    toCreateTransitGatewayPrefixListReference(): this;
    /**
     * Grants permission to create a static route for a transit gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayRoute.html
     */
    toCreateTransitGatewayRoute(): this;
    /**
     * Grants permission to create a route table for a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayRouteTable.html
     */
    toCreateTransitGatewayRouteTable(): this;
    /**
     * Grants permission to create an announcement for a transit gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayRouteTableAnnouncement.html
     */
    toCreateTransitGatewayRouteTableAnnouncement(): this;
    /**
     * Grants permission to attach a VPC to a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayVpcAttachment.html
     */
    toCreateTransitGatewayVpcAttachment(): this;
    /**
     * Grants permission to create a Verified Access endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVerifiedAccessEndpoint.html
     */
    toCreateVerifiedAccessEndpoint(): this;
    /**
     * Grants permission to create a Verified Access group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVerifiedAccessGroup.html
     */
    toCreateVerifiedAccessGroup(): this;
    /**
     * Grants permission to create a Verified Access instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVerifiedAccessInstance.html
     */
    toCreateVerifiedAccessInstance(): this;
    /**
     * Grants permission to create a verified trust provider
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVerifiedAccessTrustProvider.html
     */
    toCreateVerifiedAccessTrustProvider(): this;
    /**
     * Grants permission to create an EBS volume
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html
     */
    toCreateVolume(): this;
    /**
     * Grants permission to create a VPC with a specified CIDR block
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpc.html
     */
    toCreateVpc(): this;
    /**
     * Grants permission to create a VPC endpoint for an AWS service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     * - route53:AssociateVPCWithHostedZone
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpoint.html
     */
    toCreateVpcEndpoint(): this;
    /**
     * Grants permission to create a connection notification for a VPC endpoint or VPC endpoint service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html
     */
    toCreateVpcEndpointConnectionNotification(): this;
    /**
     * Grants permission to create a VPC endpoint service configuration to which service consumers (AWS accounts, IAM users, and IAM roles) can connect
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointServiceConfiguration.html
     */
    toCreateVpcEndpointServiceConfiguration(): this;
    /**
     * Grants permission to request a VPC peering connection between two VPCs
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcPeeringConnection.html
     */
    toCreateVpcPeeringConnection(): this;
    /**
     * Grants permission to create a VPN connection between a virtual private gateway or transit gateway and a customer gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpnConnection.html
     */
    toCreateVpnConnection(): this;
    /**
     * Grants permission to create a static route for a VPN connection between a virtual private gateway and a customer gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpnConnectionRoute.html
     */
    toCreateVpnConnectionRoute(): this;
    /**
     * Grants permission to create a virtual private gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpnGateway.html
     */
    toCreateVpnGateway(): this;
    /**
     * Grants permission to delete a carrier gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteCarrierGateway.html
     */
    toDeleteCarrierGateway(): this;
    /**
     * Grants permission to delete a Client VPN endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteClientVpnEndpoint.html
     */
    toDeleteClientVpnEndpoint(): this;
    /**
     * Grants permission to delete a route from a Client VPN endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteClientVpnRoute.html
     */
    toDeleteClientVpnRoute(): this;
    /**
     * Grants permission to delete a range of customer-owned IP (CoIP) addresses
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteCoipCidr.html
     */
    toDeleteCoipCidr(): this;
    /**
     * Grants permission to delete a pool of customer-owned IP (CoIP) addresses
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteCoipPool.html
     */
    toDeleteCoipPool(): this;
    /**
     * Grants permission to deny a service from accessing a customer-owned IP (CoIP) pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/identity-access-management.html
     */
    toDeleteCoipPoolPermission(): this;
    /**
     * Grants permission to delete a customer gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteCustomerGateway.html
     */
    toDeleteCustomerGateway(): this;
    /**
     * Grants permission to delete a set of DHCP options
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteDhcpOptions.html
     */
    toDeleteDhcpOptions(): this;
    /**
     * Grants permission to delete an egress-only internet gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteEgressOnlyInternetGateway.html
     */
    toDeleteEgressOnlyInternetGateway(): this;
    /**
     * Grants permission to delete one or more EC2 Fleets
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteFleets.html
     */
    toDeleteFleets(): this;
    /**
     * Grants permission to delete one or more flow logs
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteFlowLogs.html
     */
    toDeleteFlowLogs(): this;
    /**
     * Grants permission to delete an Amazon FPGA Image (AFI)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteFpgaImage.html
     */
    toDeleteFpgaImage(): this;
    /**
     * Grants permission to delete the specified event window
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteInstanceEventWindow.html
     */
    toDeleteInstanceEventWindow(): this;
    /**
     * Grants permission to delete an internet gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteInternetGateway.html
     */
    toDeleteInternetGateway(): this;
    /**
     * Grants permission to delete an Amazon VPC IP Address Manager (IPAM) and remove all monitored data associated with the IPAM including the historical data for CIDRs
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteIpam.html
     */
    toDeleteIpam(): this;
    /**
     * Grants permission to delete an Amazon VPC IP Address Manager (IPAM) pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteIpamPool.html
     */
    toDeleteIpamPool(): this;
    /**
     * Grants permission to delete an IPAM resource discovery
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteIpamResourceDiscovery.html
     */
    toDeleteIpamResourceDiscovery(): this;
    /**
     * Grants permission to delete the scope for an Amazon VPC IP Address Manager (IPAM)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteIpamScope.html
     */
    toDeleteIpamScope(): this;
    /**
     * Grants permission to delete a key pair by removing the public key from Amazon EC2
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteKeyPair.html
     */
    toDeleteKeyPair(): this;
    /**
     * Grants permission to delete a launch template and its associated versions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLaunchTemplate.html
     */
    toDeleteLaunchTemplate(): this;
    /**
     * Grants permission to delete one or more versions of a launch template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLaunchTemplateVersions.html
     */
    toDeleteLaunchTemplateVersions(): this;
    /**
     * Grants permission to delete a route from a local gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLocalGatewayRoute.html
     */
    toDeleteLocalGatewayRoute(): this;
    /**
     * Grants permission to delete a local gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLocalGatewayRouteTable.html
     */
    toDeleteLocalGatewayRouteTable(): this;
    /**
     * Grants permission to deny a service from accessing a local gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/identity-access-management.html
     */
    toDeleteLocalGatewayRouteTablePermission(): this;
    /**
     * Grants permission to delete a local gateway route table virtual interface group association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation.html
     */
    toDeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation(): this;
    /**
     * Grants permission to delete an association between a VPC and local gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLocalGatewayRouteTableVpcAssociation.html
     */
    toDeleteLocalGatewayRouteTableVpcAssociation(): this;
    /**
     * Grants permission to delete a managed prefix list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteManagedPrefixList.html
     */
    toDeleteManagedPrefixList(): this;
    /**
     * Grants permission to delete a NAT gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNatGateway.html
     */
    toDeleteNatGateway(): this;
    /**
     * Grants permission to delete a network ACL
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkAcl.html
     */
    toDeleteNetworkAcl(): this;
    /**
     * Grants permission to delete an inbound or outbound entry (rule) from a network ACL
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkAclEntry.html
     */
    toDeleteNetworkAclEntry(): this;
    /**
     * Grants permission to delete a Network Access Scope
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInsightsAccessScope.html
     */
    toDeleteNetworkInsightsAccessScope(): this;
    /**
     * Grants permission to delete a Network Access Scope analysis
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInsightsAccessScopeAnalysis.html
     */
    toDeleteNetworkInsightsAccessScopeAnalysis(): this;
    /**
     * Grants permission to delete a network insights analysis
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInsightsAnalysis.html
     */
    toDeleteNetworkInsightsAnalysis(): this;
    /**
     * Grants permission to delete a network insights path
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInsightsPath.html
     */
    toDeleteNetworkInsightsPath(): this;
    /**
     * Grants permission to delete a detached network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInterface.html
     */
    toDeleteNetworkInterface(): this;
    /**
     * Grants permission to delete a permission that is associated with a network interface
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInterfacePermission.html
     */
    toDeleteNetworkInterfacePermission(): this;
    /**
     * Grants permission to delete a placement group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeletePlacementGroup.html
     */
    toDeletePlacementGroup(): this;
    /**
     * Grants permission to delete a public IPv4 address pool for public IPv4 CIDRs that you own and brought to Amazon to manage with Amazon VPC IP Address Manager (IPAM)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeletePublicIpv4Pool.html
     */
    toDeletePublicIpv4Pool(): this;
    /**
     * Grants permission to delete the queued purchases for the specified Reserved Instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteQueuedReservedInstances.html
     */
    toDeleteQueuedReservedInstances(): this;
    /**
     * Grants permission to remove an IAM policy that enables cross-account sharing from a resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/vpc/latest/ipam/share-pool-ipam.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete a route from a route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html
     */
    toDeleteRoute(): this;
    /**
     * Grants permission to delete a route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRouteTable.html
     */
    toDeleteRouteTable(): this;
    /**
     * Grants permission to delete a security group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSecurityGroup.html
     */
    toDeleteSecurityGroup(): this;
    /**
     * Grants permission to delete a snapshot of an EBS volume
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html
     */
    toDeleteSnapshot(): this;
    /**
     * Grants permission to delete a data feed for Spot Instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSpotDatafeedSubscription.html
     */
    toDeleteSpotDatafeedSubscription(): this;
    /**
     * Grants permission to delete a subnet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSubnet.html
     */
    toDeleteSubnet(): this;
    /**
     * Grants permission to delete a subnet CIDR reservation
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSubnetCidrReservation.html
     */
    toDeleteSubnetCidrReservation(): this;
    /**
     * Grants permission to delete one or more tags from Amazon EC2 resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTags.html
     */
    toDeleteTags(): this;
    /**
     * Grants permission to delete a traffic mirror filter
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorFilter.html
     */
    toDeleteTrafficMirrorFilter(): this;
    /**
     * Grants permission to delete a traffic mirror filter rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorFilterRule.html
     */
    toDeleteTrafficMirrorFilterRule(): this;
    /**
     * Grants permission to delete a traffic mirror session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorSession.html
     */
    toDeleteTrafficMirrorSession(): this;
    /**
     * Grants permission to delete a traffic mirror target
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorTarget.html
     */
    toDeleteTrafficMirrorTarget(): this;
    /**
     * Grants permission to delete a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGateway.html
     */
    toDeleteTransitGateway(): this;
    /**
     * Grants permission to delete a transit gateway connect attachment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayConnect.html
     */
    toDeleteTransitGatewayConnect(): this;
    /**
     * Grants permission to delete a transit gateway connect peer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayConnectPeer.html
     */
    toDeleteTransitGatewayConnectPeer(): this;
    /**
     * Grants permission to delete a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayMulticastDomain.html
     */
    toDeleteTransitGatewayMulticastDomain(): this;
    /**
     * Grants permission to delete a peering attachment from a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayPeeringAttachment.html
     */
    toDeleteTransitGatewayPeeringAttachment(): this;
    /**
     * Grants permission to delete a transit gateway policy table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayPolicyTable.html
     */
    toDeleteTransitGatewayPolicyTable(): this;
    /**
     * Grants permission to delete a transit gateway prefix list reference
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayPrefixListReference.html
     */
    toDeleteTransitGatewayPrefixListReference(): this;
    /**
     * Grants permission to delete a route from a transit gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayRoute.html
     */
    toDeleteTransitGatewayRoute(): this;
    /**
     * Grants permission to delete a transit gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayRouteTable.html
     */
    toDeleteTransitGatewayRouteTable(): this;
    /**
     * Grants permission to delete a transit gateway route table announcement
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayRouteTableAnnouncement.html
     */
    toDeleteTransitGatewayRouteTableAnnouncement(): this;
    /**
     * Grants permission to delete a VPC attachment from a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayVpcAttachment.html
     */
    toDeleteTransitGatewayVpcAttachment(): this;
    /**
     * Grants permission to delete a Verified Access endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVerifiedAccessEndpoint.html
     */
    toDeleteVerifiedAccessEndpoint(): this;
    /**
     * Grants permission to delete a Verified Access group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVerifiedAccessGroup.html
     */
    toDeleteVerifiedAccessGroup(): this;
    /**
     * Grants permission to delete a Verified Access instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVerifiedAccessInstance.html
     */
    toDeleteVerifiedAccessInstance(): this;
    /**
     * Grants permission to delete a verified trust provider
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVerifiedAccessTrustProvider.html
     */
    toDeleteVerifiedAccessTrustProvider(): this;
    /**
     * Grants permission to delete an EBS volume
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVolume.html
     */
    toDeleteVolume(): this;
    /**
     * Grants permission to delete a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpc.html
     */
    toDeleteVpc(): this;
    /**
     * Grants permission to delete one or more VPC endpoint connection notifications
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcEndpointConnectionNotifications.html
     */
    toDeleteVpcEndpointConnectionNotifications(): this;
    /**
     * Grants permission to delete one or more VPC endpoint service configurations
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcEndpointServiceConfigurations.html
     */
    toDeleteVpcEndpointServiceConfigurations(): this;
    /**
     * Grants permission to delete one or more VPC endpoints
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcEndpoints.html
     */
    toDeleteVpcEndpoints(): this;
    /**
     * Grants permission to delete a VPC peering connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcPeeringConnection.html
     */
    toDeleteVpcPeeringConnection(): this;
    /**
     * Grants permission to delete a VPN connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpnConnection.html
     */
    toDeleteVpnConnection(): this;
    /**
     * Grants permission to delete a static route for a VPN connection between a virtual private gateway and a customer gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpnConnectionRoute.html
     */
    toDeleteVpnConnectionRoute(): this;
    /**
     * Grants permission to delete a virtual private gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpnGateway.html
     */
    toDeleteVpnGateway(): this;
    /**
     * Grants permission to release an IP address range that was provisioned through bring your own IP addresses (BYOIP), and to delete the corresponding address pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionByoipCidr.html
     */
    toDeprovisionByoipCidr(): this;
    /**
     * Grants permission to deprovision a CIDR provisioned from an Amazon VPC IP Address Manager (IPAM) pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html
     */
    toDeprovisionIpamPoolCidr(): this;
    /**
     * Grants permission to deprovision a CIDR from a public IPv4 pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionPublicIpv4PoolCidr.html
     */
    toDeprovisionPublicIpv4PoolCidr(): this;
    /**
     * Grants permission to deregister an Amazon Machine Image (AMI)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterImage.html
     */
    toDeregisterImage(): this;
    /**
     * Grants permission to remove tags from the set of tags to include in notifications about scheduled events for your instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterInstanceEventNotificationAttributes.html
     */
    toDeregisterInstanceEventNotificationAttributes(): this;
    /**
     * Grants permission to deregister one or more network interface members from a group IP address in a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterTransitGatewayMulticastGroupMembers.html
     */
    toDeregisterTransitGatewayMulticastGroupMembers(): this;
    /**
     * Grants permission to deregister one or more network interface sources from a group IP address in a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterTransitGatewayMulticastGroupSources.html
     */
    toDeregisterTransitGatewayMulticastGroupSources(): this;
    /**
     * Grants permission to describe the attributes of the AWS account
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAccountAttributes.html
     */
    toDescribeAccountAttributes(): this;
    /**
     * Grants permission to describe an Elastic IP address transfer
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddressTransfers.html
     */
    toDescribeAddressTransfers(): this;
    /**
     * Grants permission to describe one or more Elastic IP addresses
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html
     */
    toDescribeAddresses(): this;
    /**
     * Grants permission to describe the attributes of the specified Elastic IP addresses
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddressesAttribute.html
     */
    toDescribeAddressesAttribute(): this;
    /**
     * Grants permission to describe the longer ID format settings for all resource types
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAggregateIdFormat.html
     */
    toDescribeAggregateIdFormat(): this;
    /**
     * Grants permission to describe one or more of the Availability Zones that are available to you
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html
     */
    toDescribeAvailabilityZones(): this;
    /**
     * Grants permission to describe the current infrastructure performance metric subscriptions
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAwsNetworkPerformanceMetricSubscriptions.html
     */
    toDescribeAwsNetworkPerformanceMetricSubscriptions(): this;
    /**
     * Grants permission to describe one or more bundling tasks
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeBundleTasks.html
     */
    toDescribeBundleTasks(): this;
    /**
     * Grants permission to describe the IP address ranges that were provisioned through bring your own IP addresses (BYOIP)
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html
     */
    toDescribeByoipCidrs(): this;
    /**
     * Grants permission to describe one or more Capacity Reservation Fleets
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCapacityReservationFleets.html
     */
    toDescribeCapacityReservationFleets(): this;
    /**
     * Grants permission to describe one or more Capacity Reservations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCapacityReservations.html
     */
    toDescribeCapacityReservations(): this;
    /**
     * Grants permission to describe one or more Carrier Gateways
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCarrierGateways.html
     */
    toDescribeCarrierGateways(): this;
    /**
     * Grants permission to describe one or more linked EC2-Classic instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClassicLinkInstances.html
     */
    toDescribeClassicLinkInstances(): this;
    /**
     * Grants permission to describe the authorization rules for a Client VPN endpoint
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnAuthorizationRules.html
     */
    toDescribeClientVpnAuthorizationRules(): this;
    /**
     * Grants permission to describe active client connections and connections that have been terminated within the last 60 minutes for a Client VPN endpoint
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnConnections.html
     */
    toDescribeClientVpnConnections(): this;
    /**
     * Grants permission to describe one or more Client VPN endpoints
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnEndpoints.html
     */
    toDescribeClientVpnEndpoints(): this;
    /**
     * Grants permission to describe the routes for a Client VPN endpoint
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnRoutes.html
     */
    toDescribeClientVpnRoutes(): this;
    /**
     * Grants permission to describe the target networks that are associated with a Client VPN endpoint
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnTargetNetworks.html
     */
    toDescribeClientVpnTargetNetworks(): this;
    /**
     * Grants permission to describe the specified customer-owned address pools or all of your customer-owned address pools
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCoipPools.html
     */
    toDescribeCoipPools(): this;
    /**
     * Grants permission to describe one or more conversion tasks
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeConversionTasks.html
     */
    toDescribeConversionTasks(): this;
    /**
     * Grants permission to describe one or more customer gateways
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
     */
    toDescribeCustomerGateways(): this;
    /**
     * Grants permission to describe one or more DHCP options sets
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeDhcpOptions.html
     */
    toDescribeDhcpOptions(): this;
    /**
     * Grants permission to describe one or more egress-only internet gateways
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeEgressOnlyInternetGateways.html
     */
    toDescribeEgressOnlyInternetGateways(): this;
    /**
     * Grants permission to describe an Elastic Graphics accelerator that is associated with an instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeElasticGpus.html
     */
    toDescribeElasticGpus(): this;
    /**
     * Grants permission to describe one or more export image tasks
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeExportImageTasks.html
     */
    toDescribeExportImageTasks(): this;
    /**
     * Grants permission to describe one or more export instance tasks
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeExportTasks.html
     */
    toDescribeExportTasks(): this;
    /**
     * Grants permission to describe fast-launch enabled Windows AMIs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFastLaunchImages.html
     */
    toDescribeFastLaunchImages(): this;
    /**
     * Grants permission to describe the state of fast snapshot restores for snapshots
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFastSnapshotRestores.html
     */
    toDescribeFastSnapshotRestores(): this;
    /**
     * Grants permission to describe the events for an EC2 Fleet during a specified time
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFleetHistory.html
     */
    toDescribeFleetHistory(): this;
    /**
     * Grants permission to describe the running instances for an EC2 Fleet
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFleetInstances.html
     */
    toDescribeFleetInstances(): this;
    /**
     * Grants permission to describe one or more EC2 Fleets
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFleets.html
     */
    toDescribeFleets(): this;
    /**
     * Grants permission to describe one or more flow logs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFlowLogs.html
     */
    toDescribeFlowLogs(): this;
    /**
     * Grants permission to describe the attributes of an Amazon FPGA Image (AFI)
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFpgaImageAttribute.html
     */
    toDescribeFpgaImageAttribute(): this;
    /**
     * Grants permission to describe one or more Amazon FPGA Images (AFIs)
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFpgaImages.html
     */
    toDescribeFpgaImages(): this;
    /**
     * Grants permission to describe the Dedicated Host Reservations that are available to purchase
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeHostReservationOfferings.html
     */
    toDescribeHostReservationOfferings(): this;
    /**
     * Grants permission to describe the Dedicated Host Reservations that are associated with Dedicated Hosts in the AWS account
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeHostReservations.html
     */
    toDescribeHostReservations(): this;
    /**
     * Grants permission to describe one or more Dedicated Hosts
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeHosts.html
     */
    toDescribeHosts(): this;
    /**
     * Grants permission to describe the IAM instance profile associations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIamInstanceProfileAssociations.html
     */
    toDescribeIamInstanceProfileAssociations(): this;
    /**
     * Grants permission to describe the ID format settings for resources
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIdFormat.html
     */
    toDescribeIdFormat(): this;
    /**
     * Grants permission to describe the ID format settings for resources for an IAM user, IAM role, or root user
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIdentityIdFormat.html
     */
    toDescribeIdentityIdFormat(): this;
    /**
     * Grants permission to describe an attribute of an Amazon Machine Image (AMI)
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html
     */
    toDescribeImageAttribute(): this;
    /**
     * Grants permission to describe one or more images (AMIs, AKIs, and ARIs)
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html
     */
    toDescribeImages(): this;
    /**
     * Grants permission to describe import virtual machine or import snapshot tasks
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImportImageTasks.html
     */
    toDescribeImportImageTasks(): this;
    /**
     * Grants permission to describe import snapshot tasks
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImportSnapshotTasks.html
     */
    toDescribeImportSnapshotTasks(): this;
    /**
     * Grants permission to describe the attributes of an instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceAttribute.html
     */
    toDescribeInstanceAttribute(): this;
    /**
     * Grants permission to describe the credit option for CPU usage of one or more burstable performance instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceCreditSpecifications.html
     */
    toDescribeInstanceCreditSpecifications(): this;
    /**
     * Grants permission to describe the set of tags to include in notifications about scheduled events for your instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceEventNotificationAttributes.html
     */
    toDescribeInstanceEventNotificationAttributes(): this;
    /**
     * Grants permission to describe the specified event windows or all event windows
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceEventWindows.html
     */
    toDescribeInstanceEventWindows(): this;
    /**
     * Grants permission to describe the status of one or more instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceStatus.html
     */
    toDescribeInstanceStatus(): this;
    /**
     * Grants permission to describe the set of instance types that are offered in a location
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html
     */
    toDescribeInstanceTypeOfferings(): this;
    /**
     * Grants permission to describe the details of instance types that are offered in a location
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html
     */
    toDescribeInstanceTypes(): this;
    /**
     * Grants permission to describe one or more instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html
     */
    toDescribeInstances(): this;
    /**
     * Grants permission to describe one or more internet gateways
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInternetGateways.html
     */
    toDescribeInternetGateways(): this;
    /**
     * Grants permission to describe Amazon VPC IP Address Manager (IPAM) pools
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIpamPools.html
     */
    toDescribeIpamPools(): this;
    /**
     * Grants permission to describe IPAM resource discoveries
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIpamResourceDiscoveries.html
     */
    toDescribeIpamResourceDiscoveries(): this;
    /**
     * Grants permission to describe resource discovery associations with an Amazon VPC IPAM
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIpamResourceDiscoveryAssociations.html
     */
    toDescribeIpamResourceDiscoveryAssociations(): this;
    /**
     * Grants permission to describe Amazon VPC IP Address Manager (IPAM) scopes
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIpamScopes.html
     */
    toDescribeIpamScopes(): this;
    /**
     * Grants permission to describe an Amazon VPC IP Address Manager (IPAM)
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIpams.html
     */
    toDescribeIpams(): this;
    /**
     * Grants permission to describe one or more IPv6 address pools
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIpv6Pools.html
     */
    toDescribeIpv6Pools(): this;
    /**
     * Grants permission to describe one or more key pairs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeKeyPairs.html
     */
    toDescribeKeyPairs(): this;
    /**
     * Grants permission to describe one or more launch template versions
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html
     */
    toDescribeLaunchTemplateVersions(): this;
    /**
     * Grants permission to describe one or more launch templates
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html
     */
    toDescribeLaunchTemplates(): this;
    /**
     * Grants permission to allow a service to describe local gateway route table permissions
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/identity-access-management.html
     */
    toDescribeLocalGatewayRouteTablePermissions(): this;
    /**
     * Grants permission to describe the associations between virtual interface groups and local gateway route tables
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations.html
     */
    toDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(): this;
    /**
     * Grants permission to describe an association between VPCs and local gateway route tables
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayRouteTableVpcAssociations.html
     */
    toDescribeLocalGatewayRouteTableVpcAssociations(): this;
    /**
     * Grants permission to describe one or more local gateway route tables
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayRouteTables.html
     */
    toDescribeLocalGatewayRouteTables(): this;
    /**
     * Grants permission to describe local gateway virtual interface groups
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html
     */
    toDescribeLocalGatewayVirtualInterfaceGroups(): this;
    /**
     * Grants permission to describe local gateway virtual interfaces
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html
     */
    toDescribeLocalGatewayVirtualInterfaces(): this;
    /**
     * Grants permission to describe one or more local gateways
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGateways.html
     */
    toDescribeLocalGateways(): this;
    /**
     * Grants permission to describe your managed prefix lists and any AWS-managed prefix lists
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeManagedPrefixLists.html
     */
    toDescribeManagedPrefixLists(): this;
    /**
     * Grants permission to describe Elastic IP addresses that are being moved to the EC2-VPC platform
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeMovingAddresses.html
     */
    toDescribeMovingAddresses(): this;
    /**
     * Grants permission to describe one or more NAT gateways
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNatGateways.html
     */
    toDescribeNatGateways(): this;
    /**
     * Grants permission to describe one or more network ACLs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkAcls.html
     */
    toDescribeNetworkAcls(): this;
    /**
     * Grants permission to describe one or more Network Access Scope analyses
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInsightsAccessScopeAnalyses.html
     */
    toDescribeNetworkInsightsAccessScopeAnalyses(): this;
    /**
     * Grants permission to describe the Network Access Scopes
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInsightsAccessScopes.html
     */
    toDescribeNetworkInsightsAccessScopes(): this;
    /**
     * Grants permission to describe one or more network insights analyses
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInsightsAnalyses.html
     */
    toDescribeNetworkInsightsAnalyses(): this;
    /**
     * Grants permission to describe one or more network insights paths
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInsightsPaths.html
     */
    toDescribeNetworkInsightsPaths(): this;
    /**
     * Grants permission to describe a network interface attribute
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInterfaceAttribute.html
     */
    toDescribeNetworkInterfaceAttribute(): this;
    /**
     * Grants permission to describe the permissions that are associated with a network interface
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInterfacePermissions.html
     */
    toDescribeNetworkInterfacePermissions(): this;
    /**
     * Grants permission to describe one or more network interfaces
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInterfaces.html
     */
    toDescribeNetworkInterfaces(): this;
    /**
     * Grants permission to describe one or more placement groups
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePlacementGroups.html
     */
    toDescribePlacementGroups(): this;
    /**
     * Grants permission to describe available AWS services in a prefix list format
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePrefixLists.html
     */
    toDescribePrefixLists(): this;
    /**
     * Grants permission to describe the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified a longer ID (17-character ID) preference
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePrincipalIdFormat.html
     */
    toDescribePrincipalIdFormat(): this;
    /**
     * Grants permission to describe one or more IPv4 address pools
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html
     */
    toDescribePublicIpv4Pools(): this;
    /**
     * Grants permission to describe one or more AWS Regions that are currently available in your account
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html
     */
    toDescribeRegions(): this;
    /**
     * Grants permission to describe a root volume replacement task
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReplaceRootVolumeTasks.html
     */
    toDescribeReplaceRootVolumeTasks(): this;
    /**
     * Grants permission to describe one or more purchased Reserved Instances in your account
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstances.html
     */
    toDescribeReservedInstances(): this;
    /**
     * Grants permission to describe your account's Reserved Instance listings in the Reserved Instance Marketplace
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesListings.html
     */
    toDescribeReservedInstancesListings(): this;
    /**
     * Grants permission to describe the modifications made to one or more Reserved Instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesModifications.html
     */
    toDescribeReservedInstancesModifications(): this;
    /**
     * Grants permission to describe the Reserved Instance offerings that are available for purchase
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesOfferings.html
     */
    toDescribeReservedInstancesOfferings(): this;
    /**
     * Grants permission to describe one or more route tables
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRouteTables.html
     */
    toDescribeRouteTables(): this;
    /**
     * Grants permission to find available schedules for Scheduled Instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeScheduledInstanceAvailability.html
     */
    toDescribeScheduledInstanceAvailability(): this;
    /**
     * Grants permission to describe one or more Scheduled Instances in your account
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeScheduledInstances.html
     */
    toDescribeScheduledInstances(): this;
    /**
     * Grants permission to describe the VPCs on the other side of a VPC peering connection that are referencing specified VPC security groups
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroupReferences.html
     */
    toDescribeSecurityGroupReferences(): this;
    /**
     * Grants permission to describe one or more of your security group rules
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroupRules.html
     */
    toDescribeSecurityGroupRules(): this;
    /**
     * Grants permission to describe one or more security groups
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html
     */
    toDescribeSecurityGroups(): this;
    /**
     * Grants permission to describe an attribute of a snapshot
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshotAttribute.html
     */
    toDescribeSnapshotAttribute(): this;
    /**
     * Grants permission to describe the storage tier status for Amazon EBS snapshots
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshotTierStatus.html
     */
    toDescribeSnapshotTierStatus(): this;
    /**
     * Grants permission to describe one or more EBS snapshots
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html
     */
    toDescribeSnapshots(): this;
    /**
     * Grants permission to describe the data feed for Spot Instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotDatafeedSubscription.html
     */
    toDescribeSpotDatafeedSubscription(): this;
    /**
     * Grants permission to describe the running instances for a Spot Fleet
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotFleetInstances.html
     */
    toDescribeSpotFleetInstances(): this;
    /**
     * Grants permission to describe the events for a Spot Fleet request during a specified time
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotFleetRequestHistory.html
     */
    toDescribeSpotFleetRequestHistory(): this;
    /**
     * Grants permission to describe one or more Spot Fleet requests
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotFleetRequests.html
     */
    toDescribeSpotFleetRequests(): this;
    /**
     * Grants permission to describe one or more Spot Instance requests
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotInstanceRequests.html
     */
    toDescribeSpotInstanceRequests(): this;
    /**
     * Grants permission to describe the Spot Instance price history
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html
     */
    toDescribeSpotPriceHistory(): this;
    /**
     * Grants permission to describe the stale security group rules for security groups in a specified VPC
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeStaleSecurityGroups.html
     */
    toDescribeStaleSecurityGroups(): this;
    /**
     * Grants permission to describe the progress of the AMI store tasks
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeStoreImageTasks.html
     */
    toDescribeStoreImageTasks(): this;
    /**
     * Grants permission to describe one or more subnets
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSubnets.html
     */
    toDescribeSubnets(): this;
    /**
     * Grants permission to describe one or more tags for an Amazon EC2 resource
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTags.html
     */
    toDescribeTags(): this;
    /**
     * Grants permission to describe one or more traffic mirror filters
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTrafficMirrorFilters.html
     */
    toDescribeTrafficMirrorFilters(): this;
    /**
     * Grants permission to describe one or more traffic mirror sessions
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTrafficMirrorSessions.html
     */
    toDescribeTrafficMirrorSessions(): this;
    /**
     * Grants permission to describe one or more traffic mirror targets
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTrafficMirrorTargets.html
     */
    toDescribeTrafficMirrorTargets(): this;
    /**
     * Grants permission to describe one or more attachments between resources and transit gateways
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html
     */
    toDescribeTransitGatewayAttachments(): this;
    /**
     * Grants permission to describe one or more transit gateway connect peers
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayConnectPeers.html
     */
    toDescribeTransitGatewayConnectPeers(): this;
    /**
     * Grants permission to describe one or more transit gateway connect attachments
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayConnects.html
     */
    toDescribeTransitGatewayConnects(): this;
    /**
     * Grants permission to describe one or more transit gateway multicast domains
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayMulticastDomains.html
     */
    toDescribeTransitGatewayMulticastDomains(): this;
    /**
     * Grants permission to describe one or more transit gateway peering attachments
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayPeeringAttachments.html
     */
    toDescribeTransitGatewayPeeringAttachments(): this;
    /**
     * Grants permission to describe a transit gateway policy table
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayPolicyTables.html
     */
    toDescribeTransitGatewayPolicyTables(): this;
    /**
     * Grants permission to describe a transit gateway route table announcement
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayRouteTableAnnouncements.html
     */
    toDescribeTransitGatewayRouteTableAnnouncements(): this;
    /**
     * Grants permission to describe one or more transit gateway route tables
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayRouteTables.html
     */
    toDescribeTransitGatewayRouteTables(): this;
    /**
     * Grants permission to describe one or more VPC attachments on a transit gateway
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayVpcAttachments.html
     */
    toDescribeTransitGatewayVpcAttachments(): this;
    /**
     * Grants permission to describe one or more transit gateways
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html
     */
    toDescribeTransitGateways(): this;
    /**
     * Grants permission to describe one or more network interface trunk associations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTrunkInterfaceAssociations.html
     */
    toDescribeTrunkInterfaceAssociations(): this;
    /**
     * Grants permission to describe the specified Verified Access endpoints or all Verified Access endpoints
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVerifiedAccessEndpoints.html
     */
    toDescribeVerifiedAccessEndpoints(): this;
    /**
     * Grants permission to describe the specified Verified Access groups or all Verified Access groups
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVerifiedAccessGroups.html
     */
    toDescribeVerifiedAccessGroups(): this;
    /**
     * Grants permission to describe the current logging configuration for the Verified Access instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVerifiedAccessInstanceLoggingConfigurations.html
     */
    toDescribeVerifiedAccessInstanceLoggingConfigurations(): this;
    /**
     * Grants permission to describe the specified Verified Access instances or all Verified Access instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVerifiedAccessInstances.html
     */
    toDescribeVerifiedAccessInstances(): this;
    /**
     * Grants permission to describe details of existing Verified Access trust providers
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVerifiedAccessTrustProviders.html
     */
    toDescribeVerifiedAccessTrustProviders(): this;
    /**
     * Grants permission to describe an attribute of an EBS volume
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumeAttribute.html
     */
    toDescribeVolumeAttribute(): this;
    /**
     * Grants permission to describe the status of one or more EBS volumes
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumeStatus.html
     */
    toDescribeVolumeStatus(): this;
    /**
     * Grants permission to describe one or more EBS volumes
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumes.html
     */
    toDescribeVolumes(): this;
    /**
     * Grants permission to describe the current modification status of one or more EBS volumes
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumesModifications.html
     */
    toDescribeVolumesModifications(): this;
    /**
     * Grants permission to describe an attribute of a VPC
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcAttribute.html
     */
    toDescribeVpcAttribute(): this;
    /**
     * Grants permission to describe the ClassicLink status of one or more VPCs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcClassicLink.html
     */
    toDescribeVpcClassicLink(): this;
    /**
     * Grants permission to describe the ClassicLink DNS support status of one or more VPCs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcClassicLinkDnsSupport.html
     */
    toDescribeVpcClassicLinkDnsSupport(): this;
    /**
     * Grants permission to describe the connection notifications for VPC endpoints and VPC endpoint services
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointConnectionNotifications.html
     */
    toDescribeVpcEndpointConnectionNotifications(): this;
    /**
     * Grants permission to describe the VPC endpoint connections to your VPC endpoint services
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointConnections.html
     */
    toDescribeVpcEndpointConnections(): this;
    /**
     * Grants permission to describe VPC endpoint service configurations (your services)
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointServiceConfigurations.html
     */
    toDescribeVpcEndpointServiceConfigurations(): this;
    /**
     * Grants permission to describe the principals (service consumers) that are permitted to discover your VPC endpoint service
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointServicePermissions.html
     */
    toDescribeVpcEndpointServicePermissions(): this;
    /**
     * Grants permission to describe all supported AWS services that can be specified when creating a VPC endpoint
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointServices.html
     */
    toDescribeVpcEndpointServices(): this;
    /**
     * Grants permission to describe one or more VPC endpoints
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpoints.html
     */
    toDescribeVpcEndpoints(): this;
    /**
     * Grants permission to describe one or more VPC peering connections
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcPeeringConnections.html
     */
    toDescribeVpcPeeringConnections(): this;
    /**
     * Grants permission to describe one or more VPCs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
     */
    toDescribeVpcs(): this;
    /**
     * Grants permission to describe one or more VPN connections
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html
     */
    toDescribeVpnConnections(): this;
    /**
     * Grants permission to describe one or more virtual private gateways
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnGateways.html
     */
    toDescribeVpnGateways(): this;
    /**
     * Grants permission to unlink (detach) a linked EC2-Classic instance from a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachClassicLinkVpc.html
     */
    toDetachClassicLinkVpc(): this;
    /**
     * Grants permission to detach an internet gateway from a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachInternetGateway.html
     */
    toDetachInternetGateway(): this;
    /**
     * Grants permission to detach a network interface from an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachNetworkInterface.html
     */
    toDetachNetworkInterface(): this;
    /**
     * Grants permission to detach a trust provider from a Verified Access instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachVerifiedAccessTrustProvider.html
     */
    toDetachVerifiedAccessTrustProvider(): this;
    /**
     * Grants permission to detach an EBS volume from an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachVolume.html
     */
    toDetachVolume(): this;
    /**
     * Grants permission to detach a virtual private gateway from a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachVpnGateway.html
     */
    toDetachVpnGateway(): this;
    /**
     * Grants permission to disable Elastic IP address transfer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableAddressTransfer.html
     */
    toDisableAddressTransfer(): this;
    /**
     * Grants permission to disable infrastructure performance metric subscriptions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableAwsNetworkPerformanceMetricSubscription.html
     */
    toDisableAwsNetworkPerformanceMetricSubscription(): this;
    /**
     * Grants permission to disable EBS encryption by default for your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableEbsEncryptionByDefault.html
     */
    toDisableEbsEncryptionByDefault(): this;
    /**
     * Grants permission to disable faster launching for Windows AMIs
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableFastLaunch.html
     */
    toDisableFastLaunch(): this;
    /**
     * Grants permission to disable fast snapshot restores for one or more snapshots in specified Availability Zones
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableFastSnapshotRestores.html
     */
    toDisableFastSnapshotRestores(): this;
    /**
     * Grants permission to cancel the deprecation of the specified AMI
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableImageDeprecation.html
     */
    toDisableImageDeprecation(): this;
    /**
     * Grants permission to disable an AWS Organizations member account as an Amazon VPC IP Address Manager (IPAM) admin account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * Dependent actions:
     * - organizations:DeregisterDelegatedAdministrator
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableIpamOrganizationAdminAccount.html
     */
    toDisableIpamOrganizationAdminAccount(): this;
    /**
     * Grants permission to disable access to the EC2 serial console of all instances for your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableSerialConsoleAccess.html
     */
    toDisableSerialConsoleAccess(): this;
    /**
     * Grants permission to disable a resource attachment from propagating routes to the specified propagation route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableTransitGatewayRouteTablePropagation.html
     */
    toDisableTransitGatewayRouteTablePropagation(): this;
    /**
     * Grants permission to disable a virtual private gateway from propagating routes to a specified route table of a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableVgwRoutePropagation.html
     */
    toDisableVgwRoutePropagation(): this;
    /**
     * Grants permission to disable ClassicLink for a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableVpcClassicLink.html
     */
    toDisableVpcClassicLink(): this;
    /**
     * Grants permission to disable ClassicLink DNS support for a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableVpcClassicLinkDnsSupport.html
     */
    toDisableVpcClassicLinkDnsSupport(): this;
    /**
     * Grants permission to disassociate an Elastic IP address from an instance or network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateAddress.html
     */
    toDisassociateAddress(): this;
    /**
     * Grants permission to disassociate a target network from a Client VPN endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateClientVpnTargetNetwork.html
     */
    toDisassociateClientVpnTargetNetwork(): this;
    /**
     * Grants permission to disassociate an ACM certificate from a IAM role
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateEnclaveCertificateIamRole.html
     */
    toDisassociateEnclaveCertificateIamRole(): this;
    /**
     * Grants permission to disassociate an IAM instance profile from a running or stopped instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html
     */
    toDisassociateIamInstanceProfile(): this;
    /**
     * Grants permission to disassociate one or more targets from an event window
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateInstanceEventWindow.html
     */
    toDisassociateInstanceEventWindow(): this;
    /**
     * Grants permission to disassociate a resource discovery from an Amazon VPC IPAM
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIpamResourceDiscovery.html
     */
    toDisassociateIpamResourceDiscovery(): this;
    /**
     * Grants permission to disassociate a subnet from a route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateRouteTable.html
     */
    toDisassociateRouteTable(): this;
    /**
     * Grants permission to disassociate a CIDR block from a subnet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateSubnetCidrBlock.html
     */
    toDisassociateSubnetCidrBlock(): this;
    /**
     * Grants permission to disassociate one or more subnets from a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateTransitGatewayMulticastDomain.html
     */
    toDisassociateTransitGatewayMulticastDomain(): this;
    /**
     * Grants permission to disassociate a policy table from a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateTransitGatewayPolicyTable.html
     */
    toDisassociateTransitGatewayPolicyTable(): this;
    /**
     * Grants permission to disassociate a resource attachment from a transit gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateTransitGatewayRouteTable.html
     */
    toDisassociateTransitGatewayRouteTable(): this;
    /**
     * Grants permission to disassociate a branch network interface to a trunk network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateTrunkInterface.html
     */
    toDisassociateTrunkInterface(): this;
    /**
     * Grants permission to disassociate a CIDR block from a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateVpcCidrBlock.html
     */
    toDisassociateVpcCidrBlock(): this;
    /**
     * Grants permission to enable Elastic IP address transfer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableAddressTransfer.html
     */
    toEnableAddressTransfer(): this;
    /**
     * Grants permission to enable infrastructure performance subscriptions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableAwsNetworkPerformanceMetricSubscription.html
     */
    toEnableAwsNetworkPerformanceMetricSubscription(): this;
    /**
     * Grants permission to enable EBS encryption by default for your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableEbsEncryptionByDefault.html
     */
    toEnableEbsEncryptionByDefault(): this;
    /**
     * Grants permission to enable faster launching for Windows AMIs
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableFastLaunch.html
     */
    toEnableFastLaunch(): this;
    /**
     * Grants permission to enable fast snapshot restores for one or more snapshots in specified Availability Zones
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableFastSnapshotRestores.html
     */
    toEnableFastSnapshotRestores(): this;
    /**
     * Grants permission to enable deprecation of the specified AMI at the specified date and time
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableImageDeprecation.html
     */
    toEnableImageDeprecation(): this;
    /**
     * Grants permission to enable an AWS Organizations member account as an Amazon VPC IP Address Manager (IPAM) admin account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - organizations:EnableAWSServiceAccess
     * - organizations:RegisterDelegatedAdministrator
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableIpamOrganizationAdminAccount.html
     */
    toEnableIpamOrganizationAdminAccount(): this;
    /**
     * Grants permission to enable organization sharing of reachability analyzer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - organizations:EnableAWSServiceAccess
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableReachabilityAnalyzerOrganizationSharing.html
     */
    toEnableReachabilityAnalyzerOrganizationSharing(): this;
    /**
     * Grants permission to enable access to the EC2 serial console of all instances for your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableSerialConsoleAccess.html
     */
    toEnableSerialConsoleAccess(): this;
    /**
     * Grants permission to enable an attachment to propagate routes to a propagation route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableTransitGatewayRouteTablePropagation.html
     */
    toEnableTransitGatewayRouteTablePropagation(): this;
    /**
     * Grants permission to enable a virtual private gateway to propagate routes to a VPC route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVgwRoutePropagation.html
     */
    toEnableVgwRoutePropagation(): this;
    /**
     * Grants permission to enable I/O operations for a volume that had I/O operations disabled
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVolumeIO.html
     */
    toEnableVolumeIO(): this;
    /**
     * Grants permission to enable a VPC for ClassicLink
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVpcClassicLink.html
     */
    toEnableVpcClassicLink(): this;
    /**
     * Grants permission to enable a VPC to support DNS hostname resolution for ClassicLink
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVpcClassicLinkDnsSupport.html
     */
    toEnableVpcClassicLinkDnsSupport(): this;
    /**
     * Grants permission to download the client certificate revocation list for a Client VPN endpoint
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportClientVpnClientCertificateRevocationList.html
     */
    toExportClientVpnClientCertificateRevocationList(): this;
    /**
     * Grants permission to download the contents of the Client VPN endpoint configuration file for a Client VPN endpoint
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportClientVpnClientConfiguration.html
     */
    toExportClientVpnClientConfiguration(): this;
    /**
     * Grants permission to export an Amazon Machine Image (AMI) to a VM file
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportImage.html
     */
    toExportImage(): this;
    /**
     * Grants permission to export routes from a transit gateway route table to an Amazon S3 bucket
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportTransitGatewayRoutes.html
     */
    toExportTransitGatewayRoutes(): this;
    /**
     * Grants permission to get the list of roles associated with an ACM certificate
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetAssociatedEnclaveCertificateIamRoles.html
     */
    toGetAssociatedEnclaveCertificateIamRoles(): this;
    /**
     * Grants permission to get information about the IPv6 CIDR block associations for a specified IPv6 address pool
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetAssociatedIpv6PoolCidrs.html
     */
    toGetAssociatedIpv6PoolCidrs(): this;
    /**
     * Grants permission to get network performance data
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetAwsNetworkPerformanceData.html
     */
    toGetAwsNetworkPerformanceData(): this;
    /**
     * Grants permission to get usage information about a Capacity Reservation
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetCapacityReservationUsage.html
     */
    toGetCapacityReservationUsage(): this;
    /**
     * Grants permission to describe the allocations from the specified customer-owned address pool
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetCoipPoolUsage.html
     */
    toGetCoipPoolUsage(): this;
    /**
     * Grants permission to get the console output for an instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetConsoleOutput.html
     */
    toGetConsoleOutput(): this;
    /**
     * Grants permission to retrieve a JPG-format screenshot of a running instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetConsoleScreenshot.html
     */
    toGetConsoleScreenshot(): this;
    /**
     * Grants permission to get the default credit option for CPU usage of a burstable performance instance family
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetDefaultCreditSpecification.html
     */
    toGetDefaultCreditSpecification(): this;
    /**
     * Grants permission to get the ID of the default customer master key (CMK) for EBS encryption by default
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetEbsDefaultKmsKeyId.html
     */
    toGetEbsDefaultKmsKeyId(): this;
    /**
     * Grants permission to describe whether EBS encryption by default is enabled for your account
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetEbsEncryptionByDefault.html
     */
    toGetEbsEncryptionByDefault(): this;
    /**
     * Grants permission to generate a CloudFormation template to streamline the integration of VPC flow logs with Amazon Athena
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetFlowLogsIntegrationTemplate.html
     */
    toGetFlowLogsIntegrationTemplate(): this;
    /**
     * Grants permission to list the resource groups to which a Capacity Reservation has been added
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetGroupsForCapacityReservation.html
     */
    toGetGroupsForCapacityReservation(): this;
    /**
     * Grants permission to preview a reservation purchase with configurations that match those of a Dedicated Host
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetHostReservationPurchasePreview.html
     */
    toGetHostReservationPurchasePreview(): this;
    /**
     * Grants permission to view a list of instance types with specified instance attributes
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html
     */
    toGetInstanceTypesFromInstanceRequirements(): this;
    /**
     * Grants permission to retrieve the binary representation of the UEFI variable store
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData.html
     */
    toGetInstanceUefiData(): this;
    /**
     * Grants permission to retrieve historical information about a CIDR within an Amazon VPC IP Address Manager (IPAM) scope
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetIpamAddressHistory.html
     */
    toGetIpamAddressHistory(): this;
    /**
     * Grants permission to retrieve IPAM discovered accounts
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetIpamDiscoveredAccounts.html
     */
    toGetIpamDiscoveredAccounts(): this;
    /**
     * Grants permission to retrieve the resource CIDRs that are monitored as part of a resource discovery
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetIpamDiscoveredResourceCidrs.html
     */
    toGetIpamDiscoveredResourceCidrs(): this;
    /**
     * Grants permission to get a list of all the CIDR allocations in an Amazon VPC IP Address Manager (IPAM) pool
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetIpamPoolAllocations.html
     */
    toGetIpamPoolAllocations(): this;
    /**
     * Grants permission to get the CIDRs provisioned to an Amazon VPC IP Address Manager (IPAM) pool
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetIpamPoolCidrs.html
     */
    toGetIpamPoolCidrs(): this;
    /**
     * Grants permission to get information about the resources in an Amazon VPC IP Address Manager (IPAM) scope
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetIpamResourceCidrs.html
     */
    toGetIpamResourceCidrs(): this;
    /**
     * Grants permission to get the configuration data of the specified instance for use with a new launch template or launch template version
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetLaunchTemplateData.html
     */
    toGetLaunchTemplateData(): this;
    /**
     * Grants permission to get information about the resources that are associated with the specified managed prefix list
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetManagedPrefixListAssociations.html
     */
    toGetManagedPrefixListAssociations(): this;
    /**
     * Grants permission to get information about the entries for a specified managed prefix list
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetManagedPrefixListEntries.html
     */
    toGetManagedPrefixListEntries(): this;
    /**
     * Grants permission to get the findings for one or more Network Access Scope analyses
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetNetworkInsightsAccessScopeAnalysisFindings.html
     */
    toGetNetworkInsightsAccessScopeAnalysisFindings(): this;
    /**
     * Grants permission to get the content for a specified Network Access Scope
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetNetworkInsightsAccessScopeContent.html
     */
    toGetNetworkInsightsAccessScopeContent(): this;
    /**
     * Grants permission to retrieve the encrypted administrator password for a running Windows instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html
     */
    toGetPasswordData(): this;
    /**
     * Grants permission to return a quote and exchange information for exchanging one or more Convertible Reserved Instances for a new Convertible Reserved Instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetReservedInstancesExchangeQuote.html
     */
    toGetReservedInstancesExchangeQuote(): this;
    /**
     * Grants permission to describe an IAM policy that enables cross-account sharing
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/vpc/latest/ipam/share-pool-ipam.html
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to retrieve the access status of your account to the EC2 serial console of all instances
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSerialConsoleAccessStatus.html
     */
    toGetSerialConsoleAccessStatus(): this;
    /**
     * Grants permission to calculate the Spot placement score for a Region or Availability Zone based on the specified target capacity and compute requirements
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html
     */
    toGetSpotPlacementScores(): this;
    /**
     * Grants permission to retrieve information about the subnet CIDR reservations
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSubnetCidrReservations.html
     */
    toGetSubnetCidrReservations(): this;
    /**
     * Grants permission to list the route tables to which a resource attachment propagates routes
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayAttachmentPropagations.html
     */
    toGetTransitGatewayAttachmentPropagations(): this;
    /**
     * Grants permission to get information about the associations for a transit gateway multicast domain
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayMulticastDomainAssociations.html
     */
    toGetTransitGatewayMulticastDomainAssociations(): this;
    /**
     * Grants permission to get information about associations for a transit gateway policy table
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayPolicyTableAssociations.html
     */
    toGetTransitGatewayPolicyTableAssociations(): this;
    /**
     * Grants permission to get information about associations for a transit gateway policy table entry
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayPolicyTableEntries.html
     */
    toGetTransitGatewayPolicyTableEntries(): this;
    /**
     * Grants permission to get information about prefix list references for a transit gateway route table
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayPrefixListReferences.html
     */
    toGetTransitGatewayPrefixListReferences(): this;
    /**
     * Grants permission to get information about associations for a transit gateway route table
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayRouteTableAssociations.html
     */
    toGetTransitGatewayRouteTableAssociations(): this;
    /**
     * Grants permission to get information about the route table propagations for a transit gateway route table
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayRouteTablePropagations.html
     */
    toGetTransitGatewayRouteTablePropagations(): this;
    /**
     * Grants permission to show the Verified Access policy associated with the endpoint
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetVerifiedAccessEndpointPolicy.html
     */
    toGetVerifiedAccessEndpointPolicy(): this;
    /**
     * Grants permission to show the contents of the Verified Access policy associated with the group
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetVerifiedAccessGroupPolicy.html
     */
    toGetVerifiedAccessGroupPolicy(): this;
    /**
     * Grants permission to download an AWS-provided sample configuration file to be used with the customer gateway device
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetVpnConnectionDeviceSampleConfiguration.html
     */
    toGetVpnConnectionDeviceSampleConfiguration(): this;
    /**
     * Grants permission to obtain a list of customer gateway devices for which sample configuration files can be provided
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetVpnConnectionDeviceTypes.html
     */
    toGetVpnConnectionDeviceTypes(): this;
    /**
     * Grants permission to upload a client certificate revocation list to a Client VPN endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportClientVpnClientCertificateRevocationList.html
     */
    toImportClientVpnClientCertificateRevocationList(): this;
    /**
     * Grants permission to import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html
     */
    toImportImage(): this;
    /**
     * Grants permission to create an import instance task using metadata from a disk image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html
     */
    toImportInstance(): this;
    /**
     * Grants permission to import a public key from an RSA key pair that was created with a third-party tool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html
     */
    toImportKeyPair(): this;
    /**
     * Grants permission to import a disk into an EBS snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportSnapshot.html
     */
    toImportSnapshot(): this;
    /**
     * Grants permission to create an import volume task using metadata from a disk image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportVolume.html
     */
    toImportVolume(): this;
    /**
     * Grants permission to list Amazon Machine Images (AMIs) that are currently in the Recycle Bin
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ListImagesInRecycleBin.html
     */
    toListImagesInRecycleBin(): this;
    /**
     * Grants permission to list the Amazon EBS snapshots that are currently in the Recycle Bin
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ListSnapshotsInRecycleBin.html
     */
    toListSnapshotsInRecycleBin(): this;
    /**
     * Grants permission to modify an attribute of the specified Elastic IP address
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyAddressAttribute.html
     */
    toModifyAddressAttribute(): this;
    /**
     * Grants permission to modify the opt-in status of the Local Zone and Wavelength Zone group for your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyAvailabilityZoneGroup.html
     */
    toModifyAvailabilityZoneGroup(): this;
    /**
     * Grants permission to modify a Capacity Reservation's capacity and the conditions under which it is to be released
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyCapacityReservation.html
     */
    toModifyCapacityReservation(): this;
    /**
     * Grants permission to modify a Capacity Reservation Fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyCapacityReservationFleet.html
     */
    toModifyCapacityReservationFleet(): this;
    /**
     * Grants permission to modify a Client VPN endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyClientVpnEndpoint.html
     */
    toModifyClientVpnEndpoint(): this;
    /**
     * Grants permission to change the account level default credit option for CPU usage of burstable performance instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyDefaultCreditSpecification.html
     */
    toModifyDefaultCreditSpecification(): this;
    /**
     * Grants permission to change the default customer master key (CMK) for EBS encryption by default for your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html
     */
    toModifyEbsDefaultKmsKeyId(): this;
    /**
     * Grants permission to modify an EC2 Fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyFleet.html
     */
    toModifyFleet(): this;
    /**
     * Grants permission to modify an attribute of an Amazon FPGA Image (AFI)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyFpgaImageAttribute.html
     */
    toModifyFpgaImageAttribute(): this;
    /**
     * Grants permission to modify a Dedicated Host
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyHosts.html
     */
    toModifyHosts(): this;
    /**
     * Grants permission to modify the ID format for a resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIdFormat.html
     */
    toModifyIdFormat(): this;
    /**
     * Grants permission to modify the ID format of a resource for a specific principal in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIdentityIdFormat.html
     */
    toModifyIdentityIdFormat(): this;
    /**
     * Grants permission to modify an attribute of an Amazon Machine Image (AMI)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html
     */
    toModifyImageAttribute(): this;
    /**
     * Grants permission to modify an attribute of an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html
     */
    toModifyInstanceAttribute(): this;
    /**
     * Grants permission to modify the Capacity Reservation settings for a stopped instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCapacityReservationAttributes.html
     */
    toModifyInstanceCapacityReservationAttributes(): this;
    /**
     * Grants permission to modify the credit option for CPU usage on an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html
     */
    toModifyInstanceCreditSpecification(): this;
    /**
     * Grants permission to modify the start time for a scheduled EC2 instance event
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceEventStartTime.html
     */
    toModifyInstanceEventStartTime(): this;
    /**
     * Grants permission to modify the specified event window
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceEventWindow.html
     */
    toModifyInstanceEventWindow(): this;
    /**
     * Grants permission to modify the recovery behaviour for an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceMaintenanceOptions.html
     */
    toModifyInstanceMaintenanceOptions(): this;
    /**
     * Grants permission to modify the metadata options for an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceMetadataOptions.html
     */
    toModifyInstanceMetadataOptions(): this;
    /**
     * Grants permission to modify the placement attributes for an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstancePlacement.html
     */
    toModifyInstancePlacement(): this;
    /**
     * Grants permission to modify the configurations of an Amazon VPC IP Address Manager (IPAM)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIpam.html
     */
    toModifyIpam(): this;
    /**
     * Grants permission to modify the configurations of an Amazon VPC IP Address Manager (IPAM) pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIpamPool.html
     */
    toModifyIpamPool(): this;
    /**
     * Grants permission to modify the configurations of an Amazon VPC IP Address Manager (IPAM) resource CIDR
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIpamResourceCidr.html
     */
    toModifyIpamResourceCidr(): this;
    /**
     * Grants permission to modify a resource discovery
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIpamResourceDiscovery.html
     */
    toModifyIpamResourceDiscovery(): this;
    /**
     * Grants permission to modify the configurations of an Amazon VPC IP Address Manager (IPAM) scope
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIpamScope.html
     */
    toModifyIpamScope(): this;
    /**
     * Grants permission to modify a launch template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyLaunchTemplate.html
     */
    toModifyLaunchTemplate(): this;
    /**
     * Grants permission to modify a local gateway route
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyLocalGatewayRoute.html
     */
    toModifyLocalGatewayRoute(): this;
    /**
     * Grants permission to modify a managed prefix list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyManagedPrefixList.html
     */
    toModifyManagedPrefixList(): this;
    /**
     * Grants permission to modify an attribute of a network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyNetworkInterfaceAttribute.html
     */
    toModifyNetworkInterfaceAttribute(): this;
    /**
     * Grants permission to modify the options for instance hostnames for the specified instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyPrivateDnsNameOptions.html
     */
    toModifyPrivateDnsNameOptions(): this;
    /**
     * Grants permission to modify attributes of one or more Reserved Instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyReservedInstances.html
     */
    toModifyReservedInstances(): this;
    /**
     * Grants permission to modify the rules of a security group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySecurityGroupRules.html
     */
    toModifySecurityGroupRules(): this;
    /**
     * Grants permission to add or remove permission settings for a snapshot
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySnapshotAttribute.html
     */
    toModifySnapshotAttribute(): this;
    /**
     * Grants permission to archive Amazon EBS snapshots
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySnapshotTier.html
     */
    toModifySnapshotTier(): this;
    /**
     * Grants permission to modify a Spot Fleet request
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySpotFleetRequest.html
     */
    toModifySpotFleetRequest(): this;
    /**
     * Grants permission to modify an attribute of a subnet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySubnetAttribute.html
     */
    toModifySubnetAttribute(): this;
    /**
     * Grants permission to allow or restrict mirroring network services
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html
     */
    toModifyTrafficMirrorFilterNetworkServices(): this;
    /**
     * Grants permission to modify a traffic mirror rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterRule.html
     */
    toModifyTrafficMirrorFilterRule(): this;
    /**
     * Grants permission to modify a traffic mirror session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorSession.html
     */
    toModifyTrafficMirrorSession(): this;
    /**
     * Grants permission to modify a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGateway.html
     */
    toModifyTransitGateway(): this;
    /**
     * Grants permission to modify a transit gateway prefix list reference
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGatewayPrefixListReference.html
     */
    toModifyTransitGatewayPrefixListReference(): this;
    /**
     * Grants permission to modify a VPC attachment on a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGatewayVpcAttachment.html
     */
    toModifyTransitGatewayVpcAttachment(): this;
    /**
     * Grants permission to modify the configuration of a Verified Access endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVerifiedAccessEndpoint.html
     */
    toModifyVerifiedAccessEndpoint(): this;
    /**
     * Grants permission to modify the specified Verified Access endpoint policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVerifiedAccessEndpointPolicy.html
     */
    toModifyVerifiedAccessEndpointPolicy(): this;
    /**
     * Grants permission to modify the specified Verified Access Group configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVerifiedAccessGroup.html
     */
    toModifyVerifiedAccessGroup(): this;
    /**
     * Grants permission to modify the specified Verified Access group policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVerifiedAccessGroupPolicy.html
     */
    toModifyVerifiedAccessGroupPolicy(): this;
    /**
     * Grants permission to modify the configuration of the specified Verified Access instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVerifiedAccessInstance.html
     */
    toModifyVerifiedAccessInstance(): this;
    /**
     * Grants permission to modify the logging configuration for the specified Verified Access instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVerifiedAccessInstanceLoggingConfiguration.html
     */
    toModifyVerifiedAccessInstanceLoggingConfiguration(): this;
    /**
     * Grants permission to modify the configuration of the specified Verified Access trust provider
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVerifiedAccessTrustProvider.html
     */
    toModifyVerifiedAccessTrustProvider(): this;
    /**
     * Grants permission to modify the parameters of an EBS volume
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVolume.html
     */
    toModifyVolume(): this;
    /**
     * Grants permission to modify an attribute of a volume
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVolumeAttribute.html
     */
    toModifyVolumeAttribute(): this;
    /**
     * Grants permission to modify an attribute of a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcAttribute.html
     */
    toModifyVpcAttribute(): this;
    /**
     * Grants permission to modify an attribute of a VPC endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html
     */
    toModifyVpcEndpoint(): this;
    /**
     * Grants permission to modify a connection notification for a VPC endpoint or VPC endpoint service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpointConnectionNotification.html
     */
    toModifyVpcEndpointConnectionNotification(): this;
    /**
     * Grants permission to modify the attributes of a VPC endpoint service configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpointServiceConfiguration.html
     */
    toModifyVpcEndpointServiceConfiguration(): this;
    /**
     * Grants permission to modify the payer responsibility for a VPC endpoint service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpointServicePayerResponsibility.html
     */
    toModifyVpcEndpointServicePayerResponsibility(): this;
    /**
     * Grants permission to modify the permissions for a VPC endpoint service
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpointServicePermissions.html
     */
    toModifyVpcEndpointServicePermissions(): this;
    /**
     * Grants permission to modify the VPC peering connection options on one side of a VPC peering connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcPeeringConnectionOptions.html
     */
    toModifyVpcPeeringConnectionOptions(): this;
    /**
     * Grants permission to modify the instance tenancy attribute of a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcTenancy.html
     */
    toModifyVpcTenancy(): this;
    /**
     * Grants permission to modify the target gateway of a Site-to-Site VPN connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnConnection.html
     */
    toModifyVpnConnection(): this;
    /**
     * Grants permission to modify the connection options for your Site-to-Site VPN connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnConnectionOptions.html
     */
    toModifyVpnConnectionOptions(): this;
    /**
     * Grants permission to modify the certificate for a Site-to-Site VPN connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnTunnelCertificate.html
     */
    toModifyVpnTunnelCertificate(): this;
    /**
     * Grants permission to modify the options for a Site-to-Site VPN connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnTunnelOptions.html
     */
    toModifyVpnTunnelOptions(): this;
    /**
     * Grants permission to enable detailed monitoring for a running instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_MonitorInstances.html
     */
    toMonitorInstances(): this;
    /**
     * Grants permission to move an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_MoveAddressToVpc.html
     */
    toMoveAddressToVpc(): this;
    /**
     * Grants permission to move a BYOIP IPv4 CIDR to Amazon VPC IP Address Manager (IPAM) from a public IPv4 pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_MoveByoipCidrToIpam.html
     */
    toMoveByoipCidrToIpam(): this;
    /**
     * Grants permission to temporarily pause I/O operations for a target Amazon EBS volume
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html#ebs-actions-reference
     */
    toPauseVolumeIO(): this;
    /**
     * Grants permission to provision an address range for use in AWS through bring your own IP addresses (BYOIP), and to create a corresponding address pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ProvisionByoipCidr.html
     */
    toProvisionByoipCidr(): this;
    /**
     * Grants permission to provision a CIDR to an Amazon VPC IP Address Manager (IPAM) pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ProvisionIpamPoolCidr.html
     */
    toProvisionIpamPoolCidr(): this;
    /**
     * Grants permission to provision a CIDR to a public IPv4 pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ProvisionPublicIpv4PoolCidr.html
     */
    toProvisionPublicIpv4PoolCidr(): this;
    /**
     * Grants permission to purchase a reservation with configurations that match those of a Dedicated Host
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_PurchaseHostReservation.html
     */
    toPurchaseHostReservation(): this;
    /**
     * Grants permission to purchase a Reserved Instance offering
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_PurchaseReservedInstancesOffering.html
     */
    toPurchaseReservedInstancesOffering(): this;
    /**
     * Grants permission to purchase one or more Scheduled Instances with a specified schedule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_PurchaseScheduledInstances.html
     */
    toPurchaseScheduledInstances(): this;
    /**
     * Grants permission to attach an IAM policy that enables cross-account sharing to a resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/vpc/latest/ipam/share-pool-ipam.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to request a reboot of one or more instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RebootInstances.html
     */
    toRebootInstances(): this;
    /**
     * Grants permission to register an Amazon Machine Image (AMI)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterImage.html
     */
    toRegisterImage(): this;
    /**
     * Grants permission to add tags to the set of tags to include in notifications about scheduled events for your instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterInstanceEventNotificationAttributes.html
     */
    toRegisterInstanceEventNotificationAttributes(): this;
    /**
     * Grants permission to register one or more network interfaces as a member of a group IP address in a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterTransitGatewayMulticastGroupMembers.html
     */
    toRegisterTransitGatewayMulticastGroupMembers(): this;
    /**
     * Grants permission to register one or more network interfaces as a source of a group IP address in a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterTransitGatewayMulticastGroupSources.html
     */
    toRegisterTransitGatewayMulticastGroupSources(): this;
    /**
     * Grants permission to reject requests to associate cross-account subnets with a transit gateway multicast domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectTransitGatewayMulticastDomainAssociations.html
     */
    toRejectTransitGatewayMulticastDomainAssociations(): this;
    /**
     * Grants permission to reject a transit gateway peering attachment request
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectTransitGatewayPeeringAttachment.html
     */
    toRejectTransitGatewayPeeringAttachment(): this;
    /**
     * Grants permission to reject a request to attach a VPC to a transit gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectTransitGatewayVpcAttachment.html
     */
    toRejectTransitGatewayVpcAttachment(): this;
    /**
     * Grants permission to reject one or more VPC endpoint connection requests to a VPC endpoint service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectVpcEndpointConnections.html
     */
    toRejectVpcEndpointConnections(): this;
    /**
     * Grants permission to reject a VPC peering connection request
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectVpcPeeringConnection.html
     */
    toRejectVpcPeeringConnection(): this;
    /**
     * Grants permission to release an Elastic IP address
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseAddress.html
     */
    toReleaseAddress(): this;
    /**
     * Grants permission to release one or more On-Demand Dedicated Hosts
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseHosts.html
     */
    toReleaseHosts(): this;
    /**
     * Grants permission to release an allocation within an Amazon VPC IP Address Manager (IPAM) pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html
     */
    toReleaseIpamPoolAllocation(): this;
    /**
     * Grants permission to replace an IAM instance profile for an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceIamInstanceProfileAssociation.html
     */
    toReplaceIamInstanceProfileAssociation(): this;
    /**
     * Grants permission to change which network ACL a subnet is associated with
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceNetworkAclAssociation.html
     */
    toReplaceNetworkAclAssociation(): this;
    /**
     * Grants permission to replace an entry (rule) in a network ACL
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceNetworkAclEntry.html
     */
    toReplaceNetworkAclEntry(): this;
    /**
     * Grants permission to replace a route within a route table in a VPC
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceRoute.html
     */
    toReplaceRoute(): this;
    /**
     * Grants permission to change the route table that is associated with a subnet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceRouteTableAssociation.html
     */
    toReplaceRouteTableAssociation(): this;
    /**
     * Grants permission to replace a route in a transit gateway route table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceTransitGatewayRoute.html
     */
    toReplaceTransitGatewayRoute(): this;
    /**
     * Grants permission to submit feedback about the status of an instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReportInstanceStatus.html
     */
    toReportInstanceStatus(): this;
    /**
     * Grants permission to create a Spot Fleet request
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet.html
     */
    toRequestSpotFleet(): this;
    /**
     * Grants permission to create a Spot Instance request
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html
     */
    toRequestSpotInstances(): this;
    /**
     * Grants permission to reset the attribute of the specified IP address
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetAddressAttribute.html
     */
    toResetAddressAttribute(): this;
    /**
     * Grants permission to reset the default customer master key (CMK) for EBS encryption for your account to use the AWS-managed CMK for EBS
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetEbsDefaultKmsKeyId.html
     */
    toResetEbsDefaultKmsKeyId(): this;
    /**
     * Grants permission to reset an attribute of an Amazon FPGA Image (AFI) to its default value
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetFpgaImageAttribute.html
     */
    toResetFpgaImageAttribute(): this;
    /**
     * Grants permission to reset an attribute of an Amazon Machine Image (AMI) to its default value
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetImageAttribute.html
     */
    toResetImageAttribute(): this;
    /**
     * Grants permission to reset an attribute of an instance to its default value
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetInstanceAttribute.html
     */
    toResetInstanceAttribute(): this;
    /**
     * Grants permission to reset an attribute of a network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetNetworkInterfaceAttribute.html
     */
    toResetNetworkInterfaceAttribute(): this;
    /**
     * Grants permission to reset permission settings for a snapshot
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetSnapshotAttribute.html
     */
    toResetSnapshotAttribute(): this;
    /**
     * Grants permission to restore an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RestoreAddressToClassic.html
     */
    toRestoreAddressToClassic(): this;
    /**
     * Grants permission to restore an Amazon Machine Image (AMI) from the Recycle Bin
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RestoreImageFromRecycleBin.html
     */
    toRestoreImageFromRecycleBin(): this;
    /**
     * Grants permission to restore the entries from a previous version of a managed prefix list to a new version of the prefix list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RestoreManagedPrefixListVersion.html
     */
    toRestoreManagedPrefixListVersion(): this;
    /**
     * Grants permission to restore an Amazon EBS snapshot from the Recycle Bin
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RestoreSnapshotFromRecycleBin.html
     */
    toRestoreSnapshotFromRecycleBin(): this;
    /**
     * Grants permission to restore an archived Amazon EBS snapshot for use temporarily or permanently, or modify the restore period or restore type for a snapshot that was previously temporarily restored
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RestoreSnapshotTier.html
     */
    toRestoreSnapshotTier(): this;
    /**
     * Grants permission to remove an inbound authorization rule from a Client VPN endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeClientVpnIngress.html
     */
    toRevokeClientVpnIngress(): this;
    /**
     * Grants permission to remove one or more outbound rules from a VPC security group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeSecurityGroupEgress.html
     */
    toRevokeSecurityGroupEgress(): this;
    /**
     * Grants permission to remove one or more inbound rules from a security group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeSecurityGroupIngress.html
     */
    toRevokeSecurityGroupIngress(): this;
    /**
     * Grants permission to launch one or more instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html
     */
    toRunInstances(): this;
    /**
     * Grants permission to launch one or more Scheduled Instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunScheduledInstances.html
     */
    toRunScheduledInstances(): this;
    /**
     * Grants permission to search for routes in a local gateway route table
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchLocalGatewayRoutes.html
     */
    toSearchLocalGatewayRoutes(): this;
    /**
     * Grants permission to search for groups, sources, and members in a transit gateway multicast domain
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html
     */
    toSearchTransitGatewayMulticastGroups(): this;
    /**
     * Grants permission to search for routes in a transit gateway route table
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayRoutes.html
     */
    toSearchTransitGatewayRoutes(): this;
    /**
     * Grants permission to send a diagnostic interrupt to an Amazon EC2 instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SendDiagnosticInterrupt.html
     */
    toSendDiagnosticInterrupt(): this;
    /**
     * Grants permission to interrupt a Spot Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html#send-spot-instance-interruptions
     */
    toSendSpotInstanceInterruptions(): this;
    /**
     * Grants permission to start a stopped instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StartInstances.html
     */
    toStartInstances(): this;
    /**
     * Grants permission to start a Network Access Scope analysis
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StartNetworkInsightsAccessScopeAnalysis.html
     */
    toStartNetworkInsightsAccessScopeAnalysis(): this;
    /**
     * Grants permission to start analyzing a specified path
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     *
     * Dependent actions:
     * - ec2:CreateTags
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StartNetworkInsightsAnalysis.html
     */
    toStartNetworkInsightsAnalysis(): this;
    /**
     * Grants permission to start the private DNS verification process for a VPC endpoint service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StartVpcEndpointServicePrivateDnsVerification.html
     */
    toStartVpcEndpointServicePrivateDnsVerification(): this;
    /**
     * Grants permission to stop an Amazon EBS-backed instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StopInstances.html
     */
    toStopInstances(): this;
    /**
     * Grants permission to terminate active Client VPN endpoint connections
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateClientVpnConnections.html
     */
    toTerminateClientVpnConnections(): this;
    /**
     * Grants permission to shut down one or more instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html
     */
    toTerminateInstances(): this;
    /**
     * Grants permission to unassign one or more IPv6 addresses from a network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UnassignIpv6Addresses.html
     */
    toUnassignIpv6Addresses(): this;
    /**
     * Grants permission to unassign one or more secondary private IP addresses from a network interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UnassignPrivateIpAddresses.html
     */
    toUnassignPrivateIpAddresses(): this;
    /**
     * Grants permission to disable detailed monitoring for a running instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UnmonitorInstances.html
     */
    toUnmonitorInstances(): this;
    /**
     * Grants permission to update descriptions for one or more outbound rules in a VPC security group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UpdateSecurityGroupRuleDescriptionsEgress.html
     */
    toUpdateSecurityGroupRuleDescriptionsEgress(): this;
    /**
     * Grants permission to update descriptions for one or more inbound rules in a security group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UpdateSecurityGroupRuleDescriptionsIngress.html
     */
    toUpdateSecurityGroupRuleDescriptionsIngress(): this;
    /**
     * Grants permission to stop advertising an address range that was provisioned for use in AWS through bring your own IP addresses (BYOIP)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRegion()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_WithdrawByoipCidr.html
     */
    toWithdrawByoipCidr(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type elastic-ip to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
     *
     * @param allocationId - Identifier for the allocationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAllocationId()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifDomain()
     * - .ifPublicIpAddress()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onElasticIp(allocationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type capacity-reservation-fleet to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param capacityReservationFleetId - Identifier for the capacityReservationFleetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onCapacityReservationFleet(capacityReservationFleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type capacity-reservation to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html
     *
     * @param capacityReservationId - Identifier for the capacityReservationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifCapacityReservationFleet()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onCapacityReservation(capacityReservationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type carrier-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/Carrier_Gateway.html
     *
     * @param carrierGatewayId - Identifier for the carrierGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifTenancy()
     * - .ifVpc()
     */
    onCarrierGateway(carrierGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type certificate to the statement
     *
     * https://docs.aws.amazon.com/acm/latest/userguide/authen-overview.html#acm-resources-operations
     *
     * @param certificateId - Identifier for the certificateId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCertificate(certificateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type client-vpn-endpoint to the statement
     *
     * https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html
     *
     * @param clientVpnEndpointId - Identifier for the clientVpnEndpointId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifClientRootCertificateChainArn()
     * - .ifCloudwatchLogGroupArn()
     * - .ifCloudwatchLogStreamArn()
     * - .ifDirectoryArn()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifSamlProviderArn()
     * - .ifServerCertificateArn()
     */
    onClientVpnEndpoint(clientVpnEndpointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type customer-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
     *
     * @param customerGatewayId - Identifier for the customerGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onCustomerGateway(customerGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type dedicated-host to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html
     *
     * @param dedicatedHostId - Identifier for the dedicatedHostId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifAutoPlacement()
     * - .ifAvailabilityZone()
     * - .ifHostRecovery()
     * - .ifInstanceType()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifQuantity()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onDedicatedHost(dedicatedHostId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type dhcp-options to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
     *
     * @param dhcpOptionsId - Identifier for the dhcpOptionsId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifDhcpOptionsID()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onDhcpOptions(dhcpOptionsId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type egress-only-internet-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/egress-only-internet-gateway.html
     *
     * @param egressOnlyInternetGatewayId - Identifier for the egressOnlyInternetGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onEgressOnlyInternetGateway(egressOnlyInternetGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type elastic-gpu to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-gpus.html
     *
     * @param elasticGpuId - Identifier for the elasticGpuId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifElasticGpuType()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onElasticGpu(elasticGpuId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type elastic-inference to the statement
     *
     * https://docs.aws.amazon.com/elastic-inference/latest/developerguide/what-is-ei.html
     *
     * @param acceleratorId - Identifier for the acceleratorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onElasticInference(acceleratorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type export-image-task to the statement
     *
     * https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#export-vm-image
     *
     * @param exportImageTaskId - Identifier for the exportImageTaskId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onExportImageTask(exportImageTaskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type export-instance-task to the statement
     *
     * https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html
     *
     * @param exportTaskId - Identifier for the exportTaskId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onExportInstanceTask(exportTaskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type fleet to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html
     *
     * @param fleetId - Identifier for the fleetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onFleet(fleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type fpga-image to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param fpgaImageId - Identifier for the fpgaImageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifOwner()
     * - .ifPublic()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onFpgaImage(fpgaImageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type host-reservation to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param hostReservationId - Identifier for the hostReservationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onHostReservation(hostReservationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type image to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIs.html
     *
     * @param imageId - Identifier for the imageId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifImageID()
     * - .ifImageType()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifOwner()
     * - .ifPublic()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifRootDeviceType()
     */
    onImage(imageId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type import-image-task to the statement
     *
     * https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#import-vm-image
     *
     * @param importImageTaskId - Identifier for the importImageTaskId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onImportImageTask(importImageTaskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type import-snapshot-task to the statement
     *
     * https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-import-snapshot.html
     *
     * @param importSnapshotTaskId - Identifier for the importSnapshotTaskId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onImportSnapshotTask(importSnapshotTaskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type instance-event-window to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param instanceEventWindowId - Identifier for the instanceEventWindowId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onInstanceEventWindow(instanceEventWindowId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type instance to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Instances.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifAvailabilityZone()
     * - .ifEbsOptimized()
     * - .ifInstanceAutoRecovery()
     * - .ifInstanceID()
     * - .ifInstanceMarketType()
     * - .ifInstanceMetadataTags()
     * - .ifInstanceProfile()
     * - .ifInstanceType()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifMetadataHttpEndpoint()
     * - .ifMetadataHttpPutResponseHopLimit()
     * - .ifMetadataHttpTokens()
     * - .ifNewInstanceProfile()
     * - .ifPlacementGroup()
     * - .ifProductCode()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifRootDeviceType()
     * - .ifTenancy()
     */
    onInstance(instanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type internet-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html
     *
     * @param internetGatewayId - Identifier for the internetGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifInternetGatewayID()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onInternetGateway(internetGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ipam to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param ipamId - Identifier for the ipamId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onIpam(ipamId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type ipam-pool to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param ipamPoolId - Identifier for the ipamPoolId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onIpamPool(ipamPoolId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type ipam-resource-discovery-association to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param ipamResourceDiscoveryAssociationId - Identifier for the ipamResourceDiscoveryAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onIpamResourceDiscoveryAssociation(ipamResourceDiscoveryAssociationId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type ipam-resource-discovery to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param ipamResourceDiscoveryId - Identifier for the ipamResourceDiscoveryId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onIpamResourceDiscovery(ipamResourceDiscoveryId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type ipam-scope to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param ipamScopeId - Identifier for the ipamScopeId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onIpamScope(ipamScopeId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type coip-pool to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param ipv4PoolCoipId - Identifier for the ipv4PoolCoipId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onCoipPool(ipv4PoolCoipId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ipv4pool-ec2 to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#ip-addressing-eips
     *
     * @param ipv4PoolEc2Id - Identifier for the ipv4PoolEc2Id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onIpv4poolEc2(ipv4PoolEc2Id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ipv6pool-ec2 to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#ipv6-addressing
     *
     * @param ipv6PoolEc2Id - Identifier for the ipv6PoolEc2Id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onIpv6poolEc2(ipv6PoolEc2Id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type key-pair to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
     *
     * @param keyPairName - Identifier for the keyPairName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifIsLaunchTemplateResource()
     * - .ifKeyPairName()
     * - .ifKeyPairType()
     * - .ifLaunchTemplate()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onKeyPair(keyPairName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type launch-template to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html
     *
     * @param launchTemplateId - Identifier for the launchTemplateId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLaunchTemplate(launchTemplateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type license-configuration to the statement
     *
     * https://docs.aws.amazon.com/license-manager/latest/userguide/create-license-configuration.html
     *
     * @param licenseConfigurationId - Identifier for the licenseConfigurationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onLicenseConfiguration(licenseConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type local-gateway to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html#lgw
     *
     * @param localGatewayId - Identifier for the localGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGateway(localGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type local-gateway-route-table-virtual-interface-group-association to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayRouteTableVirtualInterfaceGroupAssociationId - Identifier for the localGatewayRouteTableVirtualInterfaceGroupAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGatewayRouteTableVirtualInterfaceGroupAssociation(localGatewayRouteTableVirtualInterfaceGroupAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type local-gateway-route-table-vpc-association to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html#vpc-associations
     *
     * @param localGatewayRouteTableVpcAssociationId - Identifier for the localGatewayRouteTableVpcAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGatewayRouteTableVpcAssociation(localGatewayRouteTableVpcAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type local-gateway-route-table to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html#route-tables
     *
     * @param localGatewayRoutetableId - Identifier for the localGatewayRoutetableId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGatewayRouteTable(localGatewayRoutetableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type local-gateway-virtual-interface-group to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayVirtualInterfaceGroupId - Identifier for the localGatewayVirtualInterfaceGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGatewayVirtualInterfaceGroup(localGatewayVirtualInterfaceGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type local-gateway-virtual-interface to the statement
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayVirtualInterfaceId - Identifier for the localGatewayVirtualInterfaceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onLocalGatewayVirtualInterface(localGatewayVirtualInterfaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type natgateway to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html
     *
     * @param natGatewayId - Identifier for the natGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onNatgateway(natGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-acl to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html
     *
     * @param naclId - Identifier for the naclId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifNetworkAclID()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVpc()
     */
    onNetworkAcl(naclId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-insights-access-scope-analysis to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param networkInsightsAccessScopeAnalysisId - Identifier for the networkInsightsAccessScopeAnalysisId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onNetworkInsightsAccessScopeAnalysis(networkInsightsAccessScopeAnalysisId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-insights-access-scope to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param networkInsightsAccessScopeId - Identifier for the networkInsightsAccessScopeId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onNetworkInsightsAccessScope(networkInsightsAccessScopeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-insights-analysis to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param networkInsightsAnalysisId - Identifier for the networkInsightsAnalysisId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onNetworkInsightsAnalysis(networkInsightsAnalysisId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-insights-path to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param networkInsightsPathId - Identifier for the networkInsightsPathId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onNetworkInsightsPath(networkInsightsPathId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-interface to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html
     *
     * @param networkInterfaceId - Identifier for the networkInterfaceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAssociatePublicIpAddress()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifAuthorizedService()
     * - .ifAuthorizedUser()
     * - .ifAvailabilityZone()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifNetworkInterfaceID()
     * - .ifPermission()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifSubnet()
     * - .ifVpc()
     */
    onNetworkInterface(networkInterfaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type placement-group to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
     *
     * @param placementGroupName - Identifier for the placementGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifPlacementGroupName()
     * - .ifPlacementGroupStrategy()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onPlacementGroup(placementGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type prefix-list to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html
     *
     * @param prefixListId - Identifier for the prefixListId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onPrefixList(prefixListId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type replace-root-volume-task to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html
     *
     * @param replaceRootVolumeTaskId - Identifier for the replaceRootVolumeTaskId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onReplaceRootVolumeTask(replaceRootVolumeTaskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type reserved-instances to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-reserved-instances.html
     *
     * @param reservationId - Identifier for the reservationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifAvailabilityZone()
     * - .ifInstanceType()
     * - .ifRegion()
     * - .ifReservedInstancesOfferingType()
     * - .ifResourceTag()
     * - .ifTenancy()
     */
    onReservedInstances(reservationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type group to the statement
     *
     * https://docs.aws.amazon.com/ARG/latest/userguide/resource-groups.html
     *
     * @param groupName - Identifier for the groupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGroup(groupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type role to the statement
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html
     *
     * @param roleNameWithPath - Identifier for the roleNameWithPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRole(roleNameWithPath: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type route-table to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
     *
     * @param routeTableId - Identifier for the routeTableId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifRouteTableID()
     * - .ifVpc()
     */
    onRouteTable(routeTableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type security-group to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-security-groups.html
     *
     * @param securityGroupId - Identifier for the securityGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifSecurityGroupID()
     * - .ifVpc()
     */
    onSecurityGroup(securityGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type security-group-rule to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param securityGroupRuleId - Identifier for the securityGroupRuleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onSecurityGroupRule(securityGroupRuleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type snapshot to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html
     *
     * @param snapshotId - Identifier for the snapshotId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAddGroup()
     * - .ifAddUserId()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifAvailabilityZone()
     * - .ifEncrypted()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifOutpostArn()
     * - .ifOwner()
     * - .ifParentVolume()
     * - .ifRegion()
     * - .ifRemoveGroup()
     * - .ifRemoveUserId()
     * - .ifResourceTag()
     * - .ifSnapshotID()
     * - .ifSnapshotTime()
     * - .ifSourceOutpostArn()
     * - .ifVolumeSize()
     */
    onSnapshot(snapshotId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type spot-fleet-request to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param spotFleetRequestId - Identifier for the spotFleetRequestId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onSpotFleetRequest(spotFleetRequestId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type spot-instances-request to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html
     *
     * @param spotInstanceRequestId - Identifier for the spotInstanceRequestId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onSpotInstancesRequest(spotInstanceRequestId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type subnet-cidr-reservation to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html
     *
     * @param subnetCidrReservationId - Identifier for the subnetCidrReservationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onSubnetCidrReservation(subnetCidrReservationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type subnet to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
     *
     * @param subnetId - Identifier for the subnetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifAvailabilityZone()
     * - .ifIsLaunchTemplateResource()
     * - .ifLaunchTemplate()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifSubnetID()
     * - .ifVpc()
     */
    onSubnet(subnetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type traffic-mirror-filter to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-filter.html
     *
     * @param trafficMirrorFilterId - Identifier for the trafficMirrorFilterId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTrafficMirrorFilter(trafficMirrorFilterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type traffic-mirror-filter-rule to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-filter.html
     *
     * @param trafficMirrorFilterRuleId - Identifier for the trafficMirrorFilterRuleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     */
    onTrafficMirrorFilterRule(trafficMirrorFilterRuleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type traffic-mirror-session to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-session.html
     *
     * @param trafficMirrorSessionId - Identifier for the trafficMirrorSessionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTrafficMirrorSession(trafficMirrorSessionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type traffic-mirror-target to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-target.html
     *
     * @param trafficMirrorTargetId - Identifier for the trafficMirrorTargetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTrafficMirrorTarget(trafficMirrorTargetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type transit-gateway-attachment to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/how-transit-gateways-work.html
     *
     * @param transitGatewayAttachmentId - Identifier for the transitGatewayAttachmentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGatewayAttachment(transitGatewayAttachmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type transit-gateway-connect-peer to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param transitGatewayConnectPeerId - Identifier for the transitGatewayConnectPeerId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGatewayConnectPeer(transitGatewayConnectPeerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type transit-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/how-transit-gateways-work.html
     *
     * @param transitGatewayId - Identifier for the transitGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGateway(transitGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type transit-gateway-multicast-domain to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/tgw-multicast-overview.html
     *
     * @param transitGatewayMulticastDomainId - Identifier for the transitGatewayMulticastDomainId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGatewayMulticastDomain(transitGatewayMulticastDomainId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type transit-gateway-policy-table to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param transitGatewayPolicyTableId - Identifier for the transitGatewayPolicyTableId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGatewayPolicyTable(transitGatewayPolicyTableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type transit-gateway-route-table-announcement to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param transitGatewayRouteTableAnnouncementId - Identifier for the transitGatewayRouteTableAnnouncementId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGatewayRouteTableAnnouncement(transitGatewayRouteTableAnnouncementId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type transit-gateway-route-table to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/how-transit-gateways-work.html
     *
     * @param transitGatewayRouteTableId - Identifier for the transitGatewayRouteTableId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onTransitGatewayRouteTable(transitGatewayRouteTableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type verified-access-endpoint to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param verifiedAccessEndpointId - Identifier for the verifiedAccessEndpointId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifDomainCertificateArn()
     * - .ifLoadBalancerArn()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onVerifiedAccessEndpoint(verifiedAccessEndpointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type verified-access-group to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param verifiedAccessGroupId - Identifier for the verifiedAccessGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onVerifiedAccessGroup(verifiedAccessGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type verified-access-instance to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param verifiedAccessInstanceId - Identifier for the verifiedAccessInstanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onVerifiedAccessInstance(verifiedAccessInstanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type verified-access-policy to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param verifiedAccessPolicyId - Identifier for the verifiedAccessPolicyId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onVerifiedAccessPolicy(verifiedAccessPolicyId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type verified-access-trust-provider to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param verifiedAccessTrustProviderId - Identifier for the verifiedAccessTrustProviderId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onVerifiedAccessTrustProvider(verifiedAccessTrustProviderId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type volume to the statement
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes.html
     *
     * @param volumeId - Identifier for the volumeId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifAvailabilityZone()
     * - .ifEncrypted()
     * - .ifIsLaunchTemplateResource()
     * - .ifKmsKeyId()
     * - .ifLaunchTemplate()
     * - .ifParentSnapshot()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVolumeID()
     * - .ifVolumeIops()
     * - .ifVolumeSize()
     * - .ifVolumeThroughput()
     * - .ifVolumeType()
     */
    onVolume(volumeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpc-endpoint-connection to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-overview.html
     *
     * @param vpcEndpointConnectionId - Identifier for the vpcEndpointConnectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onVpcEndpointConnection(vpcEndpointConnectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpc-endpoint to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-overview.html
     *
     * @param vpcEndpointId - Identifier for the vpcEndpointId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVpceServiceName()
     * - .ifVpceServiceOwner()
     */
    onVpcEndpoint(vpcEndpointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpc-endpoint-service to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-overview.html
     *
     * @param vpcEndpointServiceId - Identifier for the vpcEndpointServiceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifVpceServicePrivateDnsName()
     */
    onVpcEndpointService(vpcEndpointServiceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpc-endpoint-service-permission to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/privatelink/vpc-endpoints-access.html#vpc-endpoint-policies
     *
     * @param vpcEndpointServicePermissionId - Identifier for the vpcEndpointServicePermissionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onVpcEndpointServicePermission(vpcEndpointServicePermissionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpc-flow-log to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html
     *
     * @param vpcFlowLogId - Identifier for the vpcFlowLogId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onVpcFlowLog(vpcFlowLogId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpc to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
     *
     * @param vpcId - Identifier for the vpcId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifIpv4IpamPoolId()
     * - .ifIpv6IpamPoolId()
     * - .ifRegion()
     * - .ifResourceTag()
     * - .ifTenancy()
     * - .ifVpcID()
     */
    onVpc(vpcId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpc-peering-connection to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html
     *
     * @param vpcPeeringConnectionId - Identifier for the vpcPeeringConnectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAccepterVpc()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifRegion()
     * - .ifRequesterVpc()
     * - .ifResourceTag()
     * - .ifVpcPeeringConnectionID()
     */
    onVpcPeeringConnection(vpcPeeringConnectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpn-connection-device-type to the statement
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
     *
     * @param vpnConnectionDeviceTypeId - Identifier for the vpnConnectionDeviceTypeId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifRegion()
     */
    onVpnConnectionDeviceType(vpnConnectionDeviceTypeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpn-connection to the statement
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
     *
     * @param vpnConnectionId - Identifier for the vpnConnectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAttribute()
     * - .ifAttribute()
     * - .ifAuthenticationType()
     * - .ifDPDTimeoutSeconds()
     * - .ifGatewayType()
     * - .ifIKEVersions()
     * - .ifInsideTunnelCidr()
     * - .ifInsideTunnelIpv6Cidr()
     * - .ifPhase1DHGroup()
     * - .ifPhase1EncryptionAlgorithms()
     * - .ifPhase1IntegrityAlgorithms()
     * - .ifPhase1LifetimeSeconds()
     * - .ifPhase2DHGroup()
     * - .ifPhase2EncryptionAlgorithms()
     * - .ifPhase2IntegrityAlgorithms()
     * - .ifPhase2LifetimeSeconds()
     * - .ifPreSharedKeys()
     * - .ifRegion()
     * - .ifRekeyFuzzPercentage()
     * - .ifRekeyMarginTimeSeconds()
     * - .ifReplayWindowSizePackets()
     * - .ifResourceTag()
     * - .ifRoutingType()
     */
    onVpnConnection(vpnConnectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpn-gateway to the statement
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
     *
     * @param vpnGatewayId - Identifier for the vpnGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifRegion()
     * - .ifResourceTag()
     */
    onVpnGateway(vpnGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the ARN of an accepter VPC in a VPC peering connection
     *
     * https://docs.aws.amazon.com/vpc/latest/peering/security-iam.html
     *
     * Applies to actions:
     * - .toAcceptVpcPeeringConnection()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateTags()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteVpcPeeringConnection()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toRejectVpcPeeringConnection()
     *
     * Applies to resource types:
     * - vpc-peering-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifAccepterVpc(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the group being added to a snapshot
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toModifySnapshotAttribute()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAddGroup(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the account id being added to a snapshot
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toModifySnapshotAttribute()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAddUserId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the allocation ID of the Elastic IP address
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptAddressTransfer()
     * - .toAssociateAddress()
     * - .toCreateNatGateway()
     * - .toCreateTags()
     * - .toDescribeAddressesAttribute()
     * - .toDisableAddressTransfer()
     * - .toDisassociateAddress()
     * - .toEnableAddressTransfer()
     * - .toModifyAddressAttribute()
     * - .toReleaseAddress()
     * - .toResetAddressAttribute()
     *
     * Applies to resource types:
     * - elastic-ip
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAllocationId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether the user wants to associate a public IP address with the instance
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateTags()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toDeleteNetworkInterfacePermission()
     * - .toModifyFleet()
     * - .toModifyLocalGatewayRoute()
     * - .toRequestSpotInstances()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifAssociatePublicIpAddress(value?: boolean): this;
    /**
     * Filters access by an attribute of a resource
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toModifyAddressAttribute()
     * - .toModifyCapacityReservation()
     * - .toModifyCapacityReservationFleet()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyFleet()
     * - .toModifyFpgaImageAttribute()
     * - .toModifyHosts()
     * - .toModifyImageAttribute()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyIpam()
     * - .toModifyIpamPool()
     * - .toModifyIpamResourceCidr()
     * - .toModifyIpamScope()
     * - .toModifyLaunchTemplate()
     * - .toModifyManagedPrefixList()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toModifyReservedInstances()
     * - .toModifySecurityGroupRules()
     * - .toModifySnapshotAttribute()
     * - .toModifySnapshotTier()
     * - .toModifySpotFleetRequest()
     * - .toModifySubnetAttribute()
     * - .toModifyTrafficMirrorFilterNetworkServices()
     * - .toModifyTrafficMirrorFilterRule()
     * - .toModifyTrafficMirrorSession()
     * - .toModifyTransitGateway()
     * - .toModifyTransitGatewayPrefixListReference()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toModifyVpcAttribute()
     * - .toModifyVpcEndpoint()
     * - .toModifyVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServicePayerResponsibility()
     * - .toModifyVpcEndpointServicePermissions()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toModifyVpcTenancy()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toResetAddressAttribute()
     * - .toResetFpgaImageAttribute()
     * - .toResetImageAttribute()
     * - .toResetSnapshotAttribute()
     *
     * Applies to resource types:
     * - elastic-ip
     * - capacity-reservation-fleet
     * - capacity-reservation
     * - client-vpn-endpoint
     * - dedicated-host
     * - fleet
     * - fpga-image
     * - image
     * - instance
     * - ipam
     * - ipam-pool
     * - ipam-scope
     * - launch-template
     * - network-interface
     * - prefix-list
     * - reserved-instances
     * - security-group
     * - snapshot
     * - spot-fleet-request
     * - subnet
     * - traffic-mirror-filter
     * - traffic-mirror-filter-rule
     * - traffic-mirror-session
     * - transit-gateway-attachment
     * - transit-gateway
     * - transit-gateway-route-table
     * - volume
     * - vpc-endpoint
     * - vpc-endpoint-service
     * - vpc
     * - vpc-peering-connection
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAttributeExists(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by an attribute being set on a resource
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toModifyAddressAttribute()
     * - .toModifyCapacityReservation()
     * - .toModifyCapacityReservationFleet()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyFleet()
     * - .toModifyFpgaImageAttribute()
     * - .toModifyHosts()
     * - .toModifyImageAttribute()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyIpam()
     * - .toModifyIpamPool()
     * - .toModifyIpamResourceCidr()
     * - .toModifyIpamScope()
     * - .toModifyLaunchTemplate()
     * - .toModifyManagedPrefixList()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toModifyReservedInstances()
     * - .toModifySecurityGroupRules()
     * - .toModifySnapshotAttribute()
     * - .toModifySnapshotTier()
     * - .toModifySpotFleetRequest()
     * - .toModifySubnetAttribute()
     * - .toModifyTrafficMirrorFilterNetworkServices()
     * - .toModifyTrafficMirrorFilterRule()
     * - .toModifyTrafficMirrorSession()
     * - .toModifyTransitGateway()
     * - .toModifyTransitGatewayPrefixListReference()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toModifyVpcAttribute()
     * - .toModifyVpcEndpoint()
     * - .toModifyVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServicePayerResponsibility()
     * - .toModifyVpcEndpointServicePermissions()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toModifyVpcTenancy()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toResetAddressAttribute()
     * - .toResetFpgaImageAttribute()
     * - .toResetImageAttribute()
     * - .toResetSnapshotAttribute()
     *
     * Applies to resource types:
     * - elastic-ip
     * - capacity-reservation-fleet
     * - capacity-reservation
     * - client-vpn-endpoint
     * - dedicated-host
     * - fleet
     * - fpga-image
     * - image
     * - instance
     * - ipam
     * - ipam-pool
     * - ipam-scope
     * - launch-template
     * - network-interface
     * - prefix-list
     * - reserved-instances
     * - security-group
     * - snapshot
     * - spot-fleet-request
     * - subnet
     * - traffic-mirror-filter
     * - traffic-mirror-filter-rule
     * - traffic-mirror-session
     * - transit-gateway-attachment
     * - transit-gateway
     * - transit-gateway-route-table
     * - volume
     * - vpc-endpoint
     * - vpc-endpoint-service
     * - vpc
     * - vpc-peering-connection
     * - vpn-connection
     *
     * @param attributeName The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAttribute(attributeName: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the authentication type for the VPN tunnel endpoints
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAuthenticationType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the AWS service that has permission to use a resource
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateTags()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toDeleteNetworkInterfacePermission()
     * - .toModifyFleet()
     * - .toModifyLocalGatewayRoute()
     * - .toRequestSpotInstances()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAuthorizedService(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by an IAM principal that has permission to use a resource
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateTags()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toModifyLocalGatewayRoute()
     * - .toRequestSpotInstances()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAuthorizedUser(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the Auto Placement properties of a Dedicated Host
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAllocateHosts()
     * - .toCreateTags()
     *
     * Applies to resource types:
     * - dedicated-host
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAutoPlacement(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the name of an Availability Zone in an AWS Region
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAllocateHosts()
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAssociateRouteTable()
     * - .toAssociateSubnetCidrBlock()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateLocalGatewayRoute()
     * - .toCreateNatGateway()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toCreateVolume()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteNetworkInterface()
     * - .toDeleteNetworkInterfacePermission()
     * - .toDeleteSubnet()
     * - .toDeleteVolume()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDescribeInstanceAttribute()
     * - .toDescribeSnapshotAttribute()
     * - .toDescribeVolumeAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisableFastSnapshotRestores()
     * - .toDisassociateAddress()
     * - .toDisassociateIamInstanceProfile()
     * - .toDisassociateRouteTable()
     * - .toDisassociateSubnetCidrBlock()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableVolumeIO()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toImportInstance()
     * - .toImportVolume()
     * - .toListSnapshotsInRecycleBin()
     * - .toModifyFleet()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyLocalGatewayRoute()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toModifyReservedInstances()
     * - .toModifySnapshotTier()
     * - .toModifySpotFleetRequest()
     * - .toModifySubnetAttribute()
     * - .toModifyVerifiedAccessEndpoint()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceNetworkAclAssociation()
     * - .toReplaceRouteTableAssociation()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetInstanceAttribute()
     * - .toResetNetworkInterfaceAttribute()
     * - .toRestoreSnapshotFromRecycleBin()
     * - .toRestoreSnapshotTier()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - dedicated-host
     * - instance
     * - network-interface
     * - reserved-instances
     * - snapshot
     * - subnet
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAvailabilityZone(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the Capacity Reservation Fleet
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCancelCapacityReservation()
     * - .toCreateCapacityReservation()
     * - .toGetCapacityReservationUsage()
     * - .toGetGroupsForCapacityReservation()
     * - .toModifyCapacityReservation()
     *
     * Applies to resource types:
     * - capacity-reservation
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifCapacityReservationFleet(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the client root certificate chain
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDescribeClientVpnConnections()
     * - .toDescribeClientVpnEndpoints()
     * - .toDescribeClientVpnRoutes()
     * - .toDescribeClientVpnTargetNetworks()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifClientRootCertificateChainArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the CloudWatch Logs log group
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDescribeClientVpnConnections()
     * - .toDescribeClientVpnEndpoints()
     * - .toDescribeClientVpnRoutes()
     * - .toDescribeClientVpnTargetNetworks()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifCloudwatchLogGroupArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the CloudWatch Logs log stream
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDescribeClientVpnConnections()
     * - .toDescribeClientVpnEndpoints()
     * - .toDescribeClientVpnRoutes()
     * - .toDescribeClientVpnTargetNetworks()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifCloudwatchLogStreamArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the name of a resource-creating API action
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/supported-iam-actions-tagging.html
     *
     * Applies to actions:
     * - .toCreateTags()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreateAction(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the duration after which DPD timeout occurs on a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifDPDTimeoutSeconds(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a dynamic host configuration protocol (DHCP) options set
     *
     * Applies to actions:
     * - .toAssociateDhcpOptions()
     * - .toCreateDhcpOptions()
     * - .toCreateTags()
     * - .toDeleteDhcpOptions()
     *
     * Applies to resource types:
     * - dhcp-options
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDhcpOptionsID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the directory
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDescribeClientVpnConnections()
     * - .toDescribeClientVpnEndpoints()
     * - .toDescribeClientVpnRoutes()
     * - .toDescribeClientVpnTargetNetworks()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifDirectoryArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the domain of the Elastic IP address
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptAddressTransfer()
     * - .toAssociateAddress()
     * - .toCreateNatGateway()
     * - .toCreateTags()
     * - .toDescribeAddressesAttribute()
     * - .toDisableAddressTransfer()
     * - .toDisassociateAddress()
     * - .toEnableAddressTransfer()
     * - .toModifyAddressAttribute()
     * - .toReleaseAddress()
     * - .toResetAddressAttribute()
     *
     * Applies to resource types:
     * - elastic-ip
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDomain(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of an Amazon Certificate Manager certificate
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toDeleteVerifiedAccessEndpoint()
     * - .toGetVerifiedAccessEndpointPolicy()
     * - .toModifyVerifiedAccessEndpoint()
     * - .toModifyVerifiedAccessEndpointPolicy()
     *
     * Applies to resource types:
     * - verified-access-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifDomainCertificateArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether the instance is enabled for EBS optimization
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifEbsOptimized(value?: boolean): this;
    /**
     * Filters access by the type of Elastic Graphics accelerator
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - elastic-gpu
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifElasticGpuType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether the EBS volume is encrypted
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDescribeSnapshotAttribute()
     * - .toDescribeVolumeAttribute()
     * - .toDetachVolume()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableVolumeIO()
     * - .toImportInstance()
     * - .toImportVolume()
     * - .toListSnapshotsInRecycleBin()
     * - .toModifyInstanceAttribute()
     * - .toModifySnapshotTier()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toPauseVolumeIO()
     * - .toRestoreSnapshotFromRecycleBin()
     * - .toRestoreSnapshotTier()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - snapshot
     * - volume
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifEncrypted(value?: boolean): this;
    /**
     * Filters access by the gateway type for a VPN endpoint on the AWS side of a VPN connection
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifGatewayType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether host recovery is enabled for a Dedicated Host
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAllocateHosts()
     * - .toCreateTags()
     *
     * Applies to resource types:
     * - dedicated-host
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifHostRecovery(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the internet key exchange (IKE) versions that are permitted for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIKEVersions(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of an image
     *
     * Applies to actions:
     * - .toCancelImageLaunchPermission()
     * - .toCopyImage()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateRestoreImageTask()
     * - .toCreateStoreImageTask()
     * - .toCreateTags()
     * - .toDeregisterImage()
     * - .toDescribeFastLaunchImages()
     * - .toDescribeImageAttribute()
     * - .toDisableFastLaunch()
     * - .toDisableImageDeprecation()
     * - .toEnableFastLaunch()
     * - .toEnableImageDeprecation()
     * - .toExportImage()
     * - .toImportImage()
     * - .toListImagesInRecycleBin()
     * - .toModifyFleet()
     * - .toModifyImageAttribute()
     * - .toRegisterImage()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetImageAttribute()
     * - .toRestoreImageFromRecycleBin()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - image
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifImageID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the type of image (machine, aki, or ari)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCancelImageLaunchPermission()
     * - .toCreateFleet()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateStoreImageTask()
     * - .toCreateTags()
     * - .toDeregisterImage()
     * - .toDescribeFastLaunchImages()
     * - .toDescribeImageAttribute()
     * - .toDisableFastLaunch()
     * - .toDisableImageDeprecation()
     * - .toEnableFastLaunch()
     * - .toEnableImageDeprecation()
     * - .toExportImage()
     * - .toImportImage()
     * - .toListImagesInRecycleBin()
     * - .toModifyFleet()
     * - .toModifyImageAttribute()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetImageAttribute()
     * - .toRestoreImageFromRecycleBin()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - image
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifImageType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the range of inside IP addresses for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInsideTunnelCidr(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a range of inside IPv6 addresses for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInsideTunnelIpv6Cidr(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether the instance type supports auto recovery
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachNetworkInterface()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachNetworkInterface()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceAutoRecovery(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of an instance
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toImportInstance()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the market or purchasing option of an instance (on-demand or spot)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceMarketType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether the instance allows access to instance tags from the instance metadata
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachNetworkInterface()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachNetworkInterface()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceMetadataTags(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of an instance profile
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifInstanceProfile(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the type of instance
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAllocateHosts()
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toModifyReservedInstances()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - dedicated-host
     * - instance
     * - reserved-instances
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of an internet gateway
     *
     * Applies to actions:
     * - .toAssociateRouteTable()
     * - .toAttachInternetGateway()
     * - .toCreateInternetGateway()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateTags()
     * - .toDeleteInternetGateway()
     * - .toDetachInternetGateway()
     * - .toDisassociateRouteTable()
     *
     * Applies to resource types:
     * - internet-gateway
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInternetGatewayID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of an IPAM pool provided for IPv4 CIDR block allocation
     *
     * Applies to actions:
     * - .toAssociateVpcCidrBlock()
     * - .toCreateVpc()
     *
     * Applies to resource types:
     * - vpc
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIpv4IpamPoolId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of an IPAM pool provided for IPv6 CIDR block allocation
     *
     * Applies to actions:
     * - .toAssociateVpcCidrBlock()
     * - .toCreateVpc()
     *
     * Applies to resource types:
     * - vpc
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIpv6IpamPoolId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether users are able to override resources that are specified in the launch template
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - capacity-reservation
     * - dedicated-host
     * - elastic-gpu
     * - image
     * - instance
     * - key-pair
     * - launch-template
     * - network-interface
     * - placement-group
     * - security-group
     * - snapshot
     * - subnet
     * - volume
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifIsLaunchTemplateResource(value?: boolean): this;
    /**
     * Filters access by the name of a key pair
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreateTags()
     * - .toDeleteKeyPair()
     * - .toModifyFleet()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - key-pair
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifKeyPairName(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the type of a key pair
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreateKeyPair()
     * - .toCreateTags()
     * - .toDeleteKeyPair()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - key-pair
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifKeyPairType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of an AWS KMS key
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreateVolume()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifKmsKeyId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of a launch template
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - capacity-reservation
     * - dedicated-host
     * - elastic-gpu
     * - image
     * - instance
     * - key-pair
     * - launch-template
     * - network-interface
     * - placement-group
     * - security-group
     * - snapshot
     * - subnet
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifLaunchTemplate(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of an Elastic Load Balancer
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toDeleteVerifiedAccessEndpoint()
     * - .toGetVerifiedAccessEndpointPolicy()
     * - .toModifyVerifiedAccessEndpoint()
     * - .toModifyVerifiedAccessEndpointPolicy()
     *
     * Applies to resource types:
     * - verified-access-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifLoadBalancerArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether the HTTP endpoint is enabled for the instance metadata service
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifMetadataHttpEndpoint(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the allowed number of hops when calling the instance metadata service
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifMetadataHttpPutResponseHopLimit(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by whether tokens are required when calling the instance metadata service (optional or required)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifMetadataHttpTokens(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a network access control list (ACL)
     *
     * Applies to actions:
     * - .toCreateNetworkAcl()
     * - .toCreateNetworkAclEntry()
     * - .toCreateTags()
     * - .toDeleteNetworkAcl()
     * - .toDeleteNetworkAclEntry()
     * - .toReplaceNetworkAclAssociation()
     * - .toReplaceNetworkAclEntry()
     *
     * Applies to resource types:
     * - network-acl
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifNetworkAclID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of an elastic network interface
     *
     * Applies to actions:
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAttachNetworkInterface()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateLocalGatewayRoute()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toDeleteNetworkInterface()
     * - .toDeleteNetworkInterfacePermission()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachNetworkInterface()
     * - .toDisassociateAddress()
     * - .toModifyFleet()
     * - .toModifyLocalGatewayRoute()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toRequestSpotInstances()
     * - .toResetNetworkInterfaceAttribute()
     * - .toRunInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifNetworkInterfaceID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the instance profile being attached
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateIamInstanceProfile()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toModifyPrivateDnsNameOptions()
     * - .toReplaceIamInstanceProfileAssociation()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifNewInstanceProfile(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the Outpost
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCopySnapshot()
     * - .toCreateImage()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toDeleteSnapshot()
     * - .toDescribeSnapshotAttribute()
     * - .toRegisterImage()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifOutpostArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the owner of the resource (amazon, aws-marketplace, or an AWS account ID)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCancelImageLaunchPermission()
     * - .toCopyFpgaImage()
     * - .toCopyImage()
     * - .toCreateFleet()
     * - .toCreateFpgaImage()
     * - .toCreateImage()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateRestoreImageTask()
     * - .toCreateStoreImageTask()
     * - .toCreateTags()
     * - .toDeleteFpgaImage()
     * - .toDeleteSnapshot()
     * - .toDeregisterImage()
     * - .toDescribeFastLaunchImages()
     * - .toDescribeFpgaImageAttribute()
     * - .toDescribeImageAttribute()
     * - .toDescribeSnapshotAttribute()
     * - .toDisableFastLaunch()
     * - .toDisableFastSnapshotRestores()
     * - .toDisableImageDeprecation()
     * - .toEnableFastLaunch()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableImageDeprecation()
     * - .toExportImage()
     * - .toImportImage()
     * - .toImportSnapshot()
     * - .toListImagesInRecycleBin()
     * - .toListSnapshotsInRecycleBin()
     * - .toModifyFleet()
     * - .toModifyFpgaImageAttribute()
     * - .toModifyImageAttribute()
     * - .toModifySnapshotAttribute()
     * - .toModifySnapshotTier()
     * - .toRegisterImage()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetFpgaImageAttribute()
     * - .toResetImageAttribute()
     * - .toResetSnapshotAttribute()
     * - .toRestoreImageFromRecycleBin()
     * - .toRestoreSnapshotFromRecycleBin()
     * - .toRestoreSnapshotTier()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - fpga-image
     * - image
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOwner(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the parent snapshot
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDescribeVolumeAttribute()
     * - .toDetachVolume()
     * - .toEnableVolumeIO()
     * - .toImportInstance()
     * - .toImportVolume()
     * - .toModifyInstanceAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toPauseVolumeIO()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifParentSnapshot(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the parent volume from which the snapshot was created
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDeleteSnapshot()
     * - .toDescribeSnapshotAttribute()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toImportImage()
     * - .toImportSnapshot()
     * - .toListSnapshotsInRecycleBin()
     * - .toModifyFleet()
     * - .toModifySnapshotAttribute()
     * - .toModifySnapshotTier()
     * - .toRegisterImage()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetSnapshotAttribute()
     * - .toRestoreSnapshotFromRecycleBin()
     * - .toRestoreSnapshotTier()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifParentVolume(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the type of permission for a resource (INSTANCE-ATTACH or EIP-ASSOCIATE)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateTags()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toModifyLocalGatewayRoute()
     * - .toRequestSpotInstances()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPermission(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the Diffie-Hellman group numbers that are permitted for a VPN tunnel for the phase 1 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPhase1DHGroup(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the encryption algorithms that are permitted for a VPN tunnel for the phase 1 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPhase1EncryptionAlgorithms(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the integrity algorithms that are permitted for a VPN tunnel for the phase 1 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPhase1IntegrityAlgorithms(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the lifetime in seconds for phase 1 of the IKE negotiations for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifPhase1LifetimeSeconds(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the Diffie-Hellman group numbers that are permitted for a VPN tunnel for the phase 2 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPhase2DHGroup(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the encryption algorithms that are permitted for a VPN tunnel for the phase 2 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPhase2EncryptionAlgorithms(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the integrity algorithms that are permitted for a VPN tunnel for the phase 2 IKE negotiations
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPhase2IntegrityAlgorithms(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the lifetime in seconds for phase 2 of the IKE negotiations for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifPhase2LifetimeSeconds(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the placement group
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRunInstances()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifPlacementGroup(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the name of a placement group
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreatePlacementGroup()
     * - .toCreateTags()
     * - .toDeletePlacementGroup()
     * - .toDeleteResourcePolicy()
     * - .toGetResourcePolicy()
     * - .toModifyInstancePlacement()
     * - .toPutResourcePolicy()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - placement-group
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPlacementGroupName(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the instance placement strategy used by the placement group (cluster, spread, or partition)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreatePlacementGroup()
     * - .toCreateTags()
     * - .toDeletePlacementGroup()
     * - .toDeleteResourcePolicy()
     * - .toGetResourcePolicy()
     * - .toModifyInstancePlacement()
     * - .toPutResourcePolicy()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - placement-group
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPlacementGroupStrategy(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the pre-shared key (PSK) used to establish the initial IKE security association between a virtual private gateway and a customer gateway
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPreSharedKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the product code that is associated with the AMI
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateTags()
     * - .toDescribeInstanceAttribute()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProductCode(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether the image has public launch permissions
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCancelImageLaunchPermission()
     * - .toCreateFleet()
     * - .toCreateFpgaImage()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateStoreImageTask()
     * - .toCreateTags()
     * - .toDeleteFpgaImage()
     * - .toDeregisterImage()
     * - .toDescribeFastLaunchImages()
     * - .toDescribeImageAttribute()
     * - .toDisableFastLaunch()
     * - .toDisableImageDeprecation()
     * - .toEnableFastLaunch()
     * - .toEnableImageDeprecation()
     * - .toExportImage()
     * - .toImportImage()
     * - .toListImagesInRecycleBin()
     * - .toModifyFleet()
     * - .toModifyFpgaImageAttribute()
     * - .toModifyImageAttribute()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetFpgaImageAttribute()
     * - .toResetImageAttribute()
     * - .toRestoreImageFromRecycleBin()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - fpga-image
     * - image
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifPublic(value?: boolean): this;
    /**
     * Filters access by a public IP address
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptAddressTransfer()
     * - .toAssociateAddress()
     * - .toCreateNatGateway()
     * - .toCreateTags()
     * - .toDescribeAddressesAttribute()
     * - .toDisableAddressTransfer()
     * - .toDisassociateAddress()
     * - .toEnableAddressTransfer()
     * - .toModifyAddressAttribute()
     * - .toReleaseAddress()
     * - .toResetAddressAttribute()
     *
     * Applies to resource types:
     * - elastic-ip
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPublicIpAddress(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the number of Dedicated Hosts in a request
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAllocateHosts()
     * - .toCreateTags()
     *
     * Applies to resource types:
     * - dedicated-host
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifQuantity(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the name of the AWS Region
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptAddressTransfer()
     * - .toAcceptReservedInstancesExchangeQuote()
     * - .toAcceptTransitGatewayMulticastDomainAssociations()
     * - .toAcceptTransitGatewayPeeringAttachment()
     * - .toAcceptTransitGatewayVpcAttachment()
     * - .toAcceptVpcEndpointConnections()
     * - .toAcceptVpcPeeringConnection()
     * - .toAdvertiseByoipCidr()
     * - .toAllocateAddress()
     * - .toAllocateHosts()
     * - .toAllocateIpamPoolCidr()
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAssociateDhcpOptions()
     * - .toAssociateEnclaveCertificateIamRole()
     * - .toAssociateIamInstanceProfile()
     * - .toAssociateInstanceEventWindow()
     * - .toAssociateIpamResourceDiscovery()
     * - .toAssociateRouteTable()
     * - .toAssociateSubnetCidrBlock()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toAssociateTransitGatewayPolicyTable()
     * - .toAssociateTransitGatewayRouteTable()
     * - .toAssociateTrunkInterface()
     * - .toAssociateVpcCidrBlock()
     * - .toAttachClassicLinkVpc()
     * - .toAttachInternetGateway()
     * - .toAttachNetworkInterface()
     * - .toAttachVerifiedAccessTrustProvider()
     * - .toAttachVolume()
     * - .toAttachVpnGateway()
     * - .toAuthorizeClientVpnIngress()
     * - .toAuthorizeSecurityGroupEgress()
     * - .toAuthorizeSecurityGroupIngress()
     * - .toBundleInstance()
     * - .toCancelBundleTask()
     * - .toCancelCapacityReservation()
     * - .toCancelCapacityReservationFleets()
     * - .toCancelConversionTask()
     * - .toCancelExportTask()
     * - .toCancelImageLaunchPermission()
     * - .toCancelImportTask()
     * - .toCancelReservedInstancesListing()
     * - .toCancelSpotFleetRequests()
     * - .toCancelSpotInstanceRequests()
     * - .toConfirmProductInstance()
     * - .toCopyFpgaImage()
     * - .toCopyImage()
     * - .toCopySnapshot()
     * - .toCreateCapacityReservation()
     * - .toCreateCapacityReservationFleet()
     * - .toCreateCarrierGateway()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateCoipCidr()
     * - .toCreateCoipPool()
     * - .toCreateCoipPoolPermission()
     * - .toCreateCustomerGateway()
     * - .toCreateDefaultSubnet()
     * - .toCreateDefaultVpc()
     * - .toCreateDhcpOptions()
     * - .toCreateEgressOnlyInternetGateway()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateFpgaImage()
     * - .toCreateImage()
     * - .toCreateInstanceEventWindow()
     * - .toCreateInstanceExportTask()
     * - .toCreateInternetGateway()
     * - .toCreateIpam()
     * - .toCreateIpamPool()
     * - .toCreateIpamResourceDiscovery()
     * - .toCreateIpamScope()
     * - .toCreateKeyPair()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateLocalGatewayRoute()
     * - .toCreateLocalGatewayRouteTable()
     * - .toCreateLocalGatewayRouteTablePermission()
     * - .toCreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation()
     * - .toCreateLocalGatewayRouteTableVpcAssociation()
     * - .toCreateManagedPrefixList()
     * - .toCreateNatGateway()
     * - .toCreateNetworkAcl()
     * - .toCreateNetworkAclEntry()
     * - .toCreateNetworkInsightsAccessScope()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreatePlacementGroup()
     * - .toCreatePublicIpv4Pool()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateReservedInstancesListing()
     * - .toCreateRestoreImageTask()
     * - .toCreateRoute()
     * - .toCreateRouteTable()
     * - .toCreateSecurityGroup()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateSpotDatafeedSubscription()
     * - .toCreateStoreImageTask()
     * - .toCreateSubnet()
     * - .toCreateSubnetCidrReservation()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorFilter()
     * - .toCreateTrafficMirrorFilterRule()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateTransitGateway()
     * - .toCreateTransitGatewayConnect()
     * - .toCreateTransitGatewayConnectPeer()
     * - .toCreateTransitGatewayMulticastDomain()
     * - .toCreateTransitGatewayPeeringAttachment()
     * - .toCreateTransitGatewayPolicyTable()
     * - .toCreateTransitGatewayPrefixListReference()
     * - .toCreateTransitGatewayRoute()
     * - .toCreateTransitGatewayRouteTable()
     * - .toCreateTransitGatewayRouteTableAnnouncement()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toCreateVerifiedAccessGroup()
     * - .toCreateVerifiedAccessInstance()
     * - .toCreateVerifiedAccessTrustProvider()
     * - .toCreateVolume()
     * - .toCreateVpc()
     * - .toCreateVpcEndpoint()
     * - .toCreateVpcEndpointConnectionNotification()
     * - .toCreateVpcEndpointServiceConfiguration()
     * - .toCreateVpcPeeringConnection()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toCreateVpnGateway()
     * - .toDeleteCarrierGateway()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteCoipCidr()
     * - .toDeleteCoipPool()
     * - .toDeleteCoipPoolPermission()
     * - .toDeleteCustomerGateway()
     * - .toDeleteDhcpOptions()
     * - .toDeleteEgressOnlyInternetGateway()
     * - .toDeleteFleets()
     * - .toDeleteFlowLogs()
     * - .toDeleteFpgaImage()
     * - .toDeleteInstanceEventWindow()
     * - .toDeleteInternetGateway()
     * - .toDeleteIpam()
     * - .toDeleteIpamPool()
     * - .toDeleteIpamResourceDiscovery()
     * - .toDeleteIpamScope()
     * - .toDeleteKeyPair()
     * - .toDeleteLaunchTemplate()
     * - .toDeleteLaunchTemplateVersions()
     * - .toDeleteLocalGatewayRoute()
     * - .toDeleteLocalGatewayRouteTable()
     * - .toDeleteLocalGatewayRouteTablePermission()
     * - .toDeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation()
     * - .toDeleteLocalGatewayRouteTableVpcAssociation()
     * - .toDeleteManagedPrefixList()
     * - .toDeleteNatGateway()
     * - .toDeleteNetworkAcl()
     * - .toDeleteNetworkAclEntry()
     * - .toDeleteNetworkInsightsAccessScope()
     * - .toDeleteNetworkInsightsAccessScopeAnalysis()
     * - .toDeleteNetworkInsightsAnalysis()
     * - .toDeleteNetworkInsightsPath()
     * - .toDeleteNetworkInterface()
     * - .toDeleteNetworkInterfacePermission()
     * - .toDeletePlacementGroup()
     * - .toDeletePublicIpv4Pool()
     * - .toDeleteQueuedReservedInstances()
     * - .toDeleteResourcePolicy()
     * - .toDeleteRoute()
     * - .toDeleteRouteTable()
     * - .toDeleteSecurityGroup()
     * - .toDeleteSnapshot()
     * - .toDeleteSpotDatafeedSubscription()
     * - .toDeleteSubnet()
     * - .toDeleteSubnetCidrReservation()
     * - .toDeleteTags()
     * - .toDeleteTrafficMirrorFilter()
     * - .toDeleteTrafficMirrorFilterRule()
     * - .toDeleteTrafficMirrorSession()
     * - .toDeleteTrafficMirrorTarget()
     * - .toDeleteTransitGateway()
     * - .toDeleteTransitGatewayConnect()
     * - .toDeleteTransitGatewayConnectPeer()
     * - .toDeleteTransitGatewayMulticastDomain()
     * - .toDeleteTransitGatewayPeeringAttachment()
     * - .toDeleteTransitGatewayPolicyTable()
     * - .toDeleteTransitGatewayPrefixListReference()
     * - .toDeleteTransitGatewayRoute()
     * - .toDeleteTransitGatewayRouteTable()
     * - .toDeleteTransitGatewayRouteTableAnnouncement()
     * - .toDeleteTransitGatewayVpcAttachment()
     * - .toDeleteVerifiedAccessEndpoint()
     * - .toDeleteVerifiedAccessGroup()
     * - .toDeleteVerifiedAccessInstance()
     * - .toDeleteVerifiedAccessTrustProvider()
     * - .toDeleteVolume()
     * - .toDeleteVpc()
     * - .toDeleteVpcEndpointConnectionNotifications()
     * - .toDeleteVpcEndpointServiceConfigurations()
     * - .toDeleteVpcEndpoints()
     * - .toDeleteVpcPeeringConnection()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toDeleteVpnGateway()
     * - .toDeprovisionByoipCidr()
     * - .toDeprovisionIpamPoolCidr()
     * - .toDeprovisionPublicIpv4PoolCidr()
     * - .toDeregisterImage()
     * - .toDeregisterInstanceEventNotificationAttributes()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDescribeAccountAttributes()
     * - .toDescribeAddressTransfers()
     * - .toDescribeAddresses()
     * - .toDescribeAddressesAttribute()
     * - .toDescribeAggregateIdFormat()
     * - .toDescribeAvailabilityZones()
     * - .toDescribeAwsNetworkPerformanceMetricSubscriptions()
     * - .toDescribeBundleTasks()
     * - .toDescribeByoipCidrs()
     * - .toDescribeCapacityReservationFleets()
     * - .toDescribeCapacityReservations()
     * - .toDescribeCarrierGateways()
     * - .toDescribeClassicLinkInstances()
     * - .toDescribeClientVpnAuthorizationRules()
     * - .toDescribeClientVpnConnections()
     * - .toDescribeClientVpnEndpoints()
     * - .toDescribeClientVpnRoutes()
     * - .toDescribeClientVpnTargetNetworks()
     * - .toDescribeCoipPools()
     * - .toDescribeConversionTasks()
     * - .toDescribeCustomerGateways()
     * - .toDescribeDhcpOptions()
     * - .toDescribeEgressOnlyInternetGateways()
     * - .toDescribeElasticGpus()
     * - .toDescribeExportImageTasks()
     * - .toDescribeExportTasks()
     * - .toDescribeFastLaunchImages()
     * - .toDescribeFastSnapshotRestores()
     * - .toDescribeFleetHistory()
     * - .toDescribeFleetInstances()
     * - .toDescribeFleets()
     * - .toDescribeFlowLogs()
     * - .toDescribeFpgaImageAttribute()
     * - .toDescribeFpgaImages()
     * - .toDescribeHostReservationOfferings()
     * - .toDescribeHostReservations()
     * - .toDescribeHosts()
     * - .toDescribeIamInstanceProfileAssociations()
     * - .toDescribeIdFormat()
     * - .toDescribeIdentityIdFormat()
     * - .toDescribeImageAttribute()
     * - .toDescribeImages()
     * - .toDescribeImportImageTasks()
     * - .toDescribeImportSnapshotTasks()
     * - .toDescribeInstanceAttribute()
     * - .toDescribeInstanceCreditSpecifications()
     * - .toDescribeInstanceEventNotificationAttributes()
     * - .toDescribeInstanceEventWindows()
     * - .toDescribeInstanceStatus()
     * - .toDescribeInstanceTypeOfferings()
     * - .toDescribeInstanceTypes()
     * - .toDescribeInstances()
     * - .toDescribeInternetGateways()
     * - .toDescribeIpamPools()
     * - .toDescribeIpamResourceDiscoveries()
     * - .toDescribeIpamResourceDiscoveryAssociations()
     * - .toDescribeIpamScopes()
     * - .toDescribeIpams()
     * - .toDescribeIpv6Pools()
     * - .toDescribeKeyPairs()
     * - .toDescribeLaunchTemplateVersions()
     * - .toDescribeLaunchTemplates()
     * - .toDescribeLocalGatewayRouteTablePermissions()
     * - .toDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations()
     * - .toDescribeLocalGatewayRouteTableVpcAssociations()
     * - .toDescribeLocalGatewayRouteTables()
     * - .toDescribeLocalGatewayVirtualInterfaceGroups()
     * - .toDescribeLocalGatewayVirtualInterfaces()
     * - .toDescribeLocalGateways()
     * - .toDescribeManagedPrefixLists()
     * - .toDescribeMovingAddresses()
     * - .toDescribeNatGateways()
     * - .toDescribeNetworkAcls()
     * - .toDescribeNetworkInsightsAccessScopeAnalyses()
     * - .toDescribeNetworkInsightsAccessScopes()
     * - .toDescribeNetworkInsightsAnalyses()
     * - .toDescribeNetworkInsightsPaths()
     * - .toDescribeNetworkInterfaceAttribute()
     * - .toDescribeNetworkInterfacePermissions()
     * - .toDescribeNetworkInterfaces()
     * - .toDescribePlacementGroups()
     * - .toDescribePrefixLists()
     * - .toDescribePrincipalIdFormat()
     * - .toDescribePublicIpv4Pools()
     * - .toDescribeRegions()
     * - .toDescribeReplaceRootVolumeTasks()
     * - .toDescribeReservedInstances()
     * - .toDescribeReservedInstancesListings()
     * - .toDescribeReservedInstancesModifications()
     * - .toDescribeReservedInstancesOfferings()
     * - .toDescribeRouteTables()
     * - .toDescribeScheduledInstanceAvailability()
     * - .toDescribeScheduledInstances()
     * - .toDescribeSecurityGroupReferences()
     * - .toDescribeSecurityGroupRules()
     * - .toDescribeSecurityGroups()
     * - .toDescribeSnapshotAttribute()
     * - .toDescribeSnapshotTierStatus()
     * - .toDescribeSnapshots()
     * - .toDescribeSpotDatafeedSubscription()
     * - .toDescribeSpotFleetInstances()
     * - .toDescribeSpotFleetRequestHistory()
     * - .toDescribeSpotFleetRequests()
     * - .toDescribeSpotInstanceRequests()
     * - .toDescribeSpotPriceHistory()
     * - .toDescribeStaleSecurityGroups()
     * - .toDescribeStoreImageTasks()
     * - .toDescribeSubnets()
     * - .toDescribeTags()
     * - .toDescribeTrafficMirrorFilters()
     * - .toDescribeTrafficMirrorSessions()
     * - .toDescribeTrafficMirrorTargets()
     * - .toDescribeTransitGatewayAttachments()
     * - .toDescribeTransitGatewayConnectPeers()
     * - .toDescribeTransitGatewayConnects()
     * - .toDescribeTransitGatewayMulticastDomains()
     * - .toDescribeTransitGatewayPeeringAttachments()
     * - .toDescribeTransitGatewayPolicyTables()
     * - .toDescribeTransitGatewayRouteTableAnnouncements()
     * - .toDescribeTransitGatewayRouteTables()
     * - .toDescribeTransitGatewayVpcAttachments()
     * - .toDescribeTransitGateways()
     * - .toDescribeTrunkInterfaceAssociations()
     * - .toDescribeVerifiedAccessEndpoints()
     * - .toDescribeVerifiedAccessGroups()
     * - .toDescribeVerifiedAccessInstanceLoggingConfigurations()
     * - .toDescribeVerifiedAccessInstances()
     * - .toDescribeVerifiedAccessTrustProviders()
     * - .toDescribeVolumeAttribute()
     * - .toDescribeVolumeStatus()
     * - .toDescribeVolumes()
     * - .toDescribeVolumesModifications()
     * - .toDescribeVpcAttribute()
     * - .toDescribeVpcClassicLink()
     * - .toDescribeVpcClassicLinkDnsSupport()
     * - .toDescribeVpcEndpointConnectionNotifications()
     * - .toDescribeVpcEndpointConnections()
     * - .toDescribeVpcEndpointServiceConfigurations()
     * - .toDescribeVpcEndpointServicePermissions()
     * - .toDescribeVpcEndpointServices()
     * - .toDescribeVpcEndpoints()
     * - .toDescribeVpcPeeringConnections()
     * - .toDescribeVpcs()
     * - .toDescribeVpnConnections()
     * - .toDescribeVpnGateways()
     * - .toDetachClassicLinkVpc()
     * - .toDetachInternetGateway()
     * - .toDetachNetworkInterface()
     * - .toDetachVerifiedAccessTrustProvider()
     * - .toDetachVolume()
     * - .toDetachVpnGateway()
     * - .toDisableAddressTransfer()
     * - .toDisableAwsNetworkPerformanceMetricSubscription()
     * - .toDisableEbsEncryptionByDefault()
     * - .toDisableFastLaunch()
     * - .toDisableFastSnapshotRestores()
     * - .toDisableImageDeprecation()
     * - .toDisableIpamOrganizationAdminAccount()
     * - .toDisableSerialConsoleAccess()
     * - .toDisableTransitGatewayRouteTablePropagation()
     * - .toDisableVgwRoutePropagation()
     * - .toDisableVpcClassicLink()
     * - .toDisableVpcClassicLinkDnsSupport()
     * - .toDisassociateAddress()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toDisassociateEnclaveCertificateIamRole()
     * - .toDisassociateIamInstanceProfile()
     * - .toDisassociateInstanceEventWindow()
     * - .toDisassociateIpamResourceDiscovery()
     * - .toDisassociateRouteTable()
     * - .toDisassociateSubnetCidrBlock()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toDisassociateTransitGatewayPolicyTable()
     * - .toDisassociateTransitGatewayRouteTable()
     * - .toDisassociateTrunkInterface()
     * - .toDisassociateVpcCidrBlock()
     * - .toEnableAddressTransfer()
     * - .toEnableAwsNetworkPerformanceMetricSubscription()
     * - .toEnableEbsEncryptionByDefault()
     * - .toEnableFastLaunch()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableImageDeprecation()
     * - .toEnableIpamOrganizationAdminAccount()
     * - .toEnableReachabilityAnalyzerOrganizationSharing()
     * - .toEnableSerialConsoleAccess()
     * - .toEnableTransitGatewayRouteTablePropagation()
     * - .toEnableVgwRoutePropagation()
     * - .toEnableVolumeIO()
     * - .toEnableVpcClassicLink()
     * - .toEnableVpcClassicLinkDnsSupport()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toExportImage()
     * - .toExportTransitGatewayRoutes()
     * - .toGetAssociatedEnclaveCertificateIamRoles()
     * - .toGetAssociatedIpv6PoolCidrs()
     * - .toGetAwsNetworkPerformanceData()
     * - .toGetCapacityReservationUsage()
     * - .toGetCoipPoolUsage()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetDefaultCreditSpecification()
     * - .toGetEbsDefaultKmsKeyId()
     * - .toGetEbsEncryptionByDefault()
     * - .toGetFlowLogsIntegrationTemplate()
     * - .toGetGroupsForCapacityReservation()
     * - .toGetHostReservationPurchasePreview()
     * - .toGetInstanceTypesFromInstanceRequirements()
     * - .toGetInstanceUefiData()
     * - .toGetIpamAddressHistory()
     * - .toGetIpamDiscoveredAccounts()
     * - .toGetIpamDiscoveredResourceCidrs()
     * - .toGetIpamPoolAllocations()
     * - .toGetIpamPoolCidrs()
     * - .toGetIpamResourceCidrs()
     * - .toGetLaunchTemplateData()
     * - .toGetManagedPrefixListAssociations()
     * - .toGetManagedPrefixListEntries()
     * - .toGetNetworkInsightsAccessScopeAnalysisFindings()
     * - .toGetNetworkInsightsAccessScopeContent()
     * - .toGetPasswordData()
     * - .toGetReservedInstancesExchangeQuote()
     * - .toGetResourcePolicy()
     * - .toGetSerialConsoleAccessStatus()
     * - .toGetSpotPlacementScores()
     * - .toGetSubnetCidrReservations()
     * - .toGetTransitGatewayAttachmentPropagations()
     * - .toGetTransitGatewayMulticastDomainAssociations()
     * - .toGetTransitGatewayPolicyTableAssociations()
     * - .toGetTransitGatewayPolicyTableEntries()
     * - .toGetTransitGatewayPrefixListReferences()
     * - .toGetTransitGatewayRouteTableAssociations()
     * - .toGetTransitGatewayRouteTablePropagations()
     * - .toGetVerifiedAccessEndpointPolicy()
     * - .toGetVerifiedAccessGroupPolicy()
     * - .toGetVpnConnectionDeviceSampleConfiguration()
     * - .toGetVpnConnectionDeviceTypes()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toImportImage()
     * - .toImportInstance()
     * - .toImportKeyPair()
     * - .toImportSnapshot()
     * - .toImportVolume()
     * - .toListImagesInRecycleBin()
     * - .toListSnapshotsInRecycleBin()
     * - .toModifyAddressAttribute()
     * - .toModifyAvailabilityZoneGroup()
     * - .toModifyCapacityReservation()
     * - .toModifyCapacityReservationFleet()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyDefaultCreditSpecification()
     * - .toModifyEbsDefaultKmsKeyId()
     * - .toModifyFleet()
     * - .toModifyFpgaImageAttribute()
     * - .toModifyHosts()
     * - .toModifyIdFormat()
     * - .toModifyIdentityIdFormat()
     * - .toModifyImageAttribute()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceEventWindow()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyIpam()
     * - .toModifyIpamPool()
     * - .toModifyIpamResourceCidr()
     * - .toModifyIpamResourceDiscovery()
     * - .toModifyIpamScope()
     * - .toModifyLaunchTemplate()
     * - .toModifyLocalGatewayRoute()
     * - .toModifyManagedPrefixList()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toModifyReservedInstances()
     * - .toModifySecurityGroupRules()
     * - .toModifySnapshotAttribute()
     * - .toModifySnapshotTier()
     * - .toModifySpotFleetRequest()
     * - .toModifySubnetAttribute()
     * - .toModifyTrafficMirrorFilterNetworkServices()
     * - .toModifyTrafficMirrorFilterRule()
     * - .toModifyTrafficMirrorSession()
     * - .toModifyTransitGateway()
     * - .toModifyTransitGatewayPrefixListReference()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVerifiedAccessEndpoint()
     * - .toModifyVerifiedAccessEndpointPolicy()
     * - .toModifyVerifiedAccessGroup()
     * - .toModifyVerifiedAccessGroupPolicy()
     * - .toModifyVerifiedAccessInstance()
     * - .toModifyVerifiedAccessInstanceLoggingConfiguration()
     * - .toModifyVerifiedAccessTrustProvider()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toModifyVpcAttribute()
     * - .toModifyVpcEndpoint()
     * - .toModifyVpcEndpointConnectionNotification()
     * - .toModifyVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServicePayerResponsibility()
     * - .toModifyVpcEndpointServicePermissions()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toModifyVpcTenancy()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toMonitorInstances()
     * - .toMoveAddressToVpc()
     * - .toMoveByoipCidrToIpam()
     * - .toPauseVolumeIO()
     * - .toProvisionByoipCidr()
     * - .toProvisionIpamPoolCidr()
     * - .toProvisionPublicIpv4PoolCidr()
     * - .toPurchaseHostReservation()
     * - .toPurchaseReservedInstancesOffering()
     * - .toPurchaseScheduledInstances()
     * - .toPutResourcePolicy()
     * - .toRebootInstances()
     * - .toRegisterImage()
     * - .toRegisterInstanceEventNotificationAttributes()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toRejectTransitGatewayMulticastDomainAssociations()
     * - .toRejectTransitGatewayPeeringAttachment()
     * - .toRejectTransitGatewayVpcAttachment()
     * - .toRejectVpcEndpointConnections()
     * - .toRejectVpcPeeringConnection()
     * - .toReleaseAddress()
     * - .toReleaseHosts()
     * - .toReleaseIpamPoolAllocation()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceNetworkAclAssociation()
     * - .toReplaceNetworkAclEntry()
     * - .toReplaceRoute()
     * - .toReplaceRouteTableAssociation()
     * - .toReplaceTransitGatewayRoute()
     * - .toReportInstanceStatus()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetAddressAttribute()
     * - .toResetEbsDefaultKmsKeyId()
     * - .toResetFpgaImageAttribute()
     * - .toResetImageAttribute()
     * - .toResetInstanceAttribute()
     * - .toResetNetworkInterfaceAttribute()
     * - .toResetSnapshotAttribute()
     * - .toRestoreAddressToClassic()
     * - .toRestoreImageFromRecycleBin()
     * - .toRestoreManagedPrefixListVersion()
     * - .toRestoreSnapshotFromRecycleBin()
     * - .toRestoreSnapshotTier()
     * - .toRevokeClientVpnIngress()
     * - .toRevokeSecurityGroupEgress()
     * - .toRevokeSecurityGroupIngress()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     * - .toSearchLocalGatewayRoutes()
     * - .toSearchTransitGatewayMulticastGroups()
     * - .toSearchTransitGatewayRoutes()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toStartInstances()
     * - .toStartNetworkInsightsAccessScopeAnalysis()
     * - .toStartNetworkInsightsAnalysis()
     * - .toStartVpcEndpointServicePrivateDnsVerification()
     * - .toStopInstances()
     * - .toTerminateClientVpnConnections()
     * - .toTerminateInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     * - .toUnmonitorInstances()
     * - .toUpdateSecurityGroupRuleDescriptionsEgress()
     * - .toUpdateSecurityGroupRuleDescriptionsIngress()
     * - .toWithdrawByoipCidr()
     *
     * Applies to resource types:
     * - elastic-ip
     * - capacity-reservation-fleet
     * - capacity-reservation
     * - carrier-gateway
     * - client-vpn-endpoint
     * - customer-gateway
     * - dedicated-host
     * - dhcp-options
     * - egress-only-internet-gateway
     * - elastic-gpu
     * - export-image-task
     * - export-instance-task
     * - fleet
     * - fpga-image
     * - host-reservation
     * - image
     * - import-image-task
     * - import-snapshot-task
     * - instance-event-window
     * - instance
     * - internet-gateway
     * - ipam
     * - ipam-pool
     * - ipam-resource-discovery-association
     * - ipam-resource-discovery
     * - ipam-scope
     * - coip-pool
     * - ipv4pool-ec2
     * - ipv6pool-ec2
     * - key-pair
     * - launch-template
     * - local-gateway
     * - local-gateway-route-table-virtual-interface-group-association
     * - local-gateway-route-table-vpc-association
     * - local-gateway-route-table
     * - local-gateway-virtual-interface-group
     * - local-gateway-virtual-interface
     * - natgateway
     * - network-acl
     * - network-insights-access-scope-analysis
     * - network-insights-access-scope
     * - network-insights-analysis
     * - network-insights-path
     * - network-interface
     * - placement-group
     * - prefix-list
     * - replace-root-volume-task
     * - reserved-instances
     * - route-table
     * - security-group
     * - security-group-rule
     * - snapshot
     * - spot-fleet-request
     * - spot-instances-request
     * - subnet-cidr-reservation
     * - subnet
     * - traffic-mirror-filter
     * - traffic-mirror-filter-rule
     * - traffic-mirror-session
     * - traffic-mirror-target
     * - transit-gateway-attachment
     * - transit-gateway-connect-peer
     * - transit-gateway
     * - transit-gateway-multicast-domain
     * - transit-gateway-policy-table
     * - transit-gateway-route-table-announcement
     * - transit-gateway-route-table
     * - verified-access-endpoint
     * - verified-access-group
     * - verified-access-instance
     * - verified-access-policy
     * - verified-access-trust-provider
     * - volume
     * - vpc-endpoint-connection
     * - vpc-endpoint
     * - vpc-endpoint-service
     * - vpc-endpoint-service-permission
     * - vpc-flow-log
     * - vpc
     * - vpc-peering-connection
     * - vpn-connection-device-type
     * - vpn-connection
     * - vpn-gateway
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRegion(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the percentage of increase of the rekey window (determined by the rekey margin time) within which the rekey time is randomly selected for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifRekeyFuzzPercentage(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the margin time before the phase 2 lifetime expires for a VPN tunnel
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifRekeyMarginTimeSeconds(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the group being removed from a snapshot
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toModifySnapshotAttribute()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRemoveGroup(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the account id being removed from a snapshot
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toModifySnapshotAttribute()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRemoveUserId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the number of packets in an IKE replay window
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifReplayWindowSizePackets(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of a requester VPC in a VPC peering connection
     *
     * https://docs.aws.amazon.com/vpc/latest/peering/security-iam.html
     *
     * Applies to actions:
     * - .toAcceptVpcPeeringConnection()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateTags()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteVpcPeeringConnection()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toRejectVpcPeeringConnection()
     *
     * Applies to resource types:
     * - vpc-peering-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifRequesterVpc(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the payment option of the Reserved Instance offering (No Upfront, Partial Upfront, or All Upfront)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-reserved-instances.html#ri-payment-options
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toModifyReservedInstances()
     *
     * Applies to resource types:
     * - reserved-instances
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifReservedInstancesOfferingType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/control-access-with-tags.html
     *
     * Applies to actions:
     * - .toAcceptTransitGatewayMulticastDomainAssociations()
     * - .toAcceptTransitGatewayPeeringAttachment()
     * - .toAcceptTransitGatewayVpcAttachment()
     * - .toAcceptVpcEndpointConnections()
     * - .toAcceptVpcPeeringConnection()
     * - .toAllocateAddress()
     * - .toAllocateIpamPoolCidr()
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAssociateDhcpOptions()
     * - .toAssociateIamInstanceProfile()
     * - .toAssociateInstanceEventWindow()
     * - .toAssociateIpamResourceDiscovery()
     * - .toAssociateRouteTable()
     * - .toAssociateSubnetCidrBlock()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toAssociateTransitGatewayPolicyTable()
     * - .toAssociateTransitGatewayRouteTable()
     * - .toAssociateVpcCidrBlock()
     * - .toAttachClassicLinkVpc()
     * - .toAttachInternetGateway()
     * - .toAttachNetworkInterface()
     * - .toAttachVerifiedAccessTrustProvider()
     * - .toAttachVolume()
     * - .toAttachVpnGateway()
     * - .toAuthorizeClientVpnIngress()
     * - .toAuthorizeSecurityGroupEgress()
     * - .toAuthorizeSecurityGroupIngress()
     * - .toCancelCapacityReservation()
     * - .toCancelCapacityReservationFleets()
     * - .toCancelExportTask()
     * - .toCancelImageLaunchPermission()
     * - .toCancelImportTask()
     * - .toCancelSpotFleetRequests()
     * - .toCancelSpotInstanceRequests()
     * - .toCreateCarrierGateway()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateCoipCidr()
     * - .toCreateCoipPool()
     * - .toCreateCoipPoolPermission()
     * - .toCreateEgressOnlyInternetGateway()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateIpamPool()
     * - .toCreateIpamScope()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateLocalGatewayRoute()
     * - .toCreateLocalGatewayRouteTable()
     * - .toCreateLocalGatewayRouteTablePermission()
     * - .toCreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation()
     * - .toCreateLocalGatewayRouteTableVpcAssociation()
     * - .toCreateNatGateway()
     * - .toCreateNetworkAcl()
     * - .toCreateNetworkAclEntry()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateRoute()
     * - .toCreateRouteTable()
     * - .toCreateSecurityGroup()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateStoreImageTask()
     * - .toCreateSubnet()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorFilterRule()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateTransitGatewayConnectPeer()
     * - .toCreateTransitGatewayMulticastDomain()
     * - .toCreateTransitGatewayPeeringAttachment()
     * - .toCreateTransitGatewayPolicyTable()
     * - .toCreateTransitGatewayPrefixListReference()
     * - .toCreateTransitGatewayRoute()
     * - .toCreateTransitGatewayRouteTable()
     * - .toCreateTransitGatewayRouteTableAnnouncement()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toCreateVerifiedAccessGroup()
     * - .toCreateVpc()
     * - .toCreateVpcEndpoint()
     * - .toCreateVpcEndpointConnectionNotification()
     * - .toCreateVpcPeeringConnection()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteCarrierGateway()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteCoipCidr()
     * - .toDeleteCoipPool()
     * - .toDeleteCoipPoolPermission()
     * - .toDeleteCustomerGateway()
     * - .toDeleteDhcpOptions()
     * - .toDeleteEgressOnlyInternetGateway()
     * - .toDeleteFleets()
     * - .toDeleteFlowLogs()
     * - .toDeleteFpgaImage()
     * - .toDeleteInstanceEventWindow()
     * - .toDeleteInternetGateway()
     * - .toDeleteIpam()
     * - .toDeleteIpamPool()
     * - .toDeleteIpamResourceDiscovery()
     * - .toDeleteIpamScope()
     * - .toDeleteKeyPair()
     * - .toDeleteLaunchTemplate()
     * - .toDeleteLaunchTemplateVersions()
     * - .toDeleteLocalGatewayRoute()
     * - .toDeleteLocalGatewayRouteTable()
     * - .toDeleteLocalGatewayRouteTablePermission()
     * - .toDeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation()
     * - .toDeleteLocalGatewayRouteTableVpcAssociation()
     * - .toDeleteManagedPrefixList()
     * - .toDeleteNatGateway()
     * - .toDeleteNetworkAcl()
     * - .toDeleteNetworkAclEntry()
     * - .toDeleteNetworkInsightsAccessScope()
     * - .toDeleteNetworkInsightsAccessScopeAnalysis()
     * - .toDeleteNetworkInsightsAnalysis()
     * - .toDeleteNetworkInsightsPath()
     * - .toDeleteNetworkInterface()
     * - .toDeleteNetworkInterfacePermission()
     * - .toDeletePlacementGroup()
     * - .toDeletePublicIpv4Pool()
     * - .toDeleteResourcePolicy()
     * - .toDeleteRoute()
     * - .toDeleteRouteTable()
     * - .toDeleteSecurityGroup()
     * - .toDeleteSnapshot()
     * - .toDeleteSubnet()
     * - .toDeleteTags()
     * - .toDeleteTrafficMirrorFilter()
     * - .toDeleteTrafficMirrorFilterRule()
     * - .toDeleteTrafficMirrorSession()
     * - .toDeleteTrafficMirrorTarget()
     * - .toDeleteTransitGateway()
     * - .toDeleteTransitGatewayConnect()
     * - .toDeleteTransitGatewayConnectPeer()
     * - .toDeleteTransitGatewayMulticastDomain()
     * - .toDeleteTransitGatewayPeeringAttachment()
     * - .toDeleteTransitGatewayPolicyTable()
     * - .toDeleteTransitGatewayPrefixListReference()
     * - .toDeleteTransitGatewayRoute()
     * - .toDeleteTransitGatewayRouteTable()
     * - .toDeleteTransitGatewayRouteTableAnnouncement()
     * - .toDeleteTransitGatewayVpcAttachment()
     * - .toDeleteVerifiedAccessEndpoint()
     * - .toDeleteVerifiedAccessGroup()
     * - .toDeleteVerifiedAccessInstance()
     * - .toDeleteVerifiedAccessTrustProvider()
     * - .toDeleteVolume()
     * - .toDeleteVpc()
     * - .toDeleteVpcEndpointConnectionNotifications()
     * - .toDeleteVpcEndpointServiceConfigurations()
     * - .toDeleteVpcEndpoints()
     * - .toDeleteVpcPeeringConnection()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toDeleteVpnGateway()
     * - .toDeprovisionIpamPoolCidr()
     * - .toDeprovisionPublicIpv4PoolCidr()
     * - .toDeregisterImage()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDescribeAddressesAttribute()
     * - .toDescribeClientVpnAuthorizationRules()
     * - .toDescribeClientVpnConnections()
     * - .toDescribeClientVpnEndpoints()
     * - .toDescribeClientVpnRoutes()
     * - .toDescribeClientVpnTargetNetworks()
     * - .toDescribeFastLaunchImages()
     * - .toDescribeFleetHistory()
     * - .toDescribeFleetInstances()
     * - .toDescribeFpgaImageAttribute()
     * - .toDescribeImageAttribute()
     * - .toDescribeInstanceAttribute()
     * - .toDescribeSnapshotAttribute()
     * - .toDescribeSpotFleetInstances()
     * - .toDescribeSpotFleetRequestHistory()
     * - .toDescribeVolumeAttribute()
     * - .toDescribeVpcAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachInternetGateway()
     * - .toDetachNetworkInterface()
     * - .toDetachVerifiedAccessTrustProvider()
     * - .toDetachVolume()
     * - .toDetachVpnGateway()
     * - .toDisableAddressTransfer()
     * - .toDisableFastLaunch()
     * - .toDisableFastSnapshotRestores()
     * - .toDisableImageDeprecation()
     * - .toDisableTransitGatewayRouteTablePropagation()
     * - .toDisableVgwRoutePropagation()
     * - .toDisableVpcClassicLink()
     * - .toDisableVpcClassicLinkDnsSupport()
     * - .toDisassociateAddress()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toDisassociateIamInstanceProfile()
     * - .toDisassociateInstanceEventWindow()
     * - .toDisassociateIpamResourceDiscovery()
     * - .toDisassociateRouteTable()
     * - .toDisassociateSubnetCidrBlock()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toDisassociateTransitGatewayPolicyTable()
     * - .toDisassociateTransitGatewayRouteTable()
     * - .toDisassociateVpcCidrBlock()
     * - .toEnableAddressTransfer()
     * - .toEnableFastLaunch()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableImageDeprecation()
     * - .toEnableTransitGatewayRouteTablePropagation()
     * - .toEnableVgwRoutePropagation()
     * - .toEnableVolumeIO()
     * - .toEnableVpcClassicLink()
     * - .toEnableVpcClassicLinkDnsSupport()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toExportImage()
     * - .toGetCapacityReservationUsage()
     * - .toGetCoipPoolUsage()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetFlowLogsIntegrationTemplate()
     * - .toGetGroupsForCapacityReservation()
     * - .toGetInstanceUefiData()
     * - .toGetIpamAddressHistory()
     * - .toGetIpamDiscoveredAccounts()
     * - .toGetIpamDiscoveredResourceCidrs()
     * - .toGetIpamPoolAllocations()
     * - .toGetIpamPoolCidrs()
     * - .toGetIpamResourceCidrs()
     * - .toGetLaunchTemplateData()
     * - .toGetManagedPrefixListAssociations()
     * - .toGetManagedPrefixListEntries()
     * - .toGetPasswordData()
     * - .toGetResourcePolicy()
     * - .toGetTransitGatewayMulticastDomainAssociations()
     * - .toGetTransitGatewayPolicyTableAssociations()
     * - .toGetTransitGatewayPolicyTableEntries()
     * - .toGetVerifiedAccessEndpointPolicy()
     * - .toGetVerifiedAccessGroupPolicy()
     * - .toGetVpnConnectionDeviceSampleConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toImportImage()
     * - .toImportInstance()
     * - .toImportVolume()
     * - .toListImagesInRecycleBin()
     * - .toListSnapshotsInRecycleBin()
     * - .toModifyAddressAttribute()
     * - .toModifyCapacityReservation()
     * - .toModifyCapacityReservationFleet()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyFleet()
     * - .toModifyFpgaImageAttribute()
     * - .toModifyHosts()
     * - .toModifyImageAttribute()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceEventWindow()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyIpam()
     * - .toModifyIpamPool()
     * - .toModifyIpamResourceCidr()
     * - .toModifyIpamResourceDiscovery()
     * - .toModifyIpamScope()
     * - .toModifyLaunchTemplate()
     * - .toModifyLocalGatewayRoute()
     * - .toModifyManagedPrefixList()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toModifyReservedInstances()
     * - .toModifySecurityGroupRules()
     * - .toModifySnapshotAttribute()
     * - .toModifySnapshotTier()
     * - .toModifySpotFleetRequest()
     * - .toModifySubnetAttribute()
     * - .toModifyTrafficMirrorFilterNetworkServices()
     * - .toModifyTrafficMirrorFilterRule()
     * - .toModifyTrafficMirrorSession()
     * - .toModifyTransitGateway()
     * - .toModifyTransitGatewayPrefixListReference()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVerifiedAccessEndpoint()
     * - .toModifyVerifiedAccessEndpointPolicy()
     * - .toModifyVerifiedAccessGroup()
     * - .toModifyVerifiedAccessGroupPolicy()
     * - .toModifyVerifiedAccessInstance()
     * - .toModifyVerifiedAccessInstanceLoggingConfiguration()
     * - .toModifyVerifiedAccessTrustProvider()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toModifyVpcAttribute()
     * - .toModifyVpcEndpoint()
     * - .toModifyVpcEndpointConnectionNotification()
     * - .toModifyVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServicePayerResponsibility()
     * - .toModifyVpcEndpointServicePermissions()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toModifyVpcTenancy()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toMonitorInstances()
     * - .toMoveByoipCidrToIpam()
     * - .toPauseVolumeIO()
     * - .toProvisionIpamPoolCidr()
     * - .toProvisionPublicIpv4PoolCidr()
     * - .toPurchaseHostReservation()
     * - .toPutResourcePolicy()
     * - .toRebootInstances()
     * - .toRegisterImage()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toRejectTransitGatewayMulticastDomainAssociations()
     * - .toRejectTransitGatewayPeeringAttachment()
     * - .toRejectTransitGatewayVpcAttachment()
     * - .toRejectVpcEndpointConnections()
     * - .toRejectVpcPeeringConnection()
     * - .toReleaseAddress()
     * - .toReleaseHosts()
     * - .toReleaseIpamPoolAllocation()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceNetworkAclAssociation()
     * - .toReplaceNetworkAclEntry()
     * - .toReplaceRoute()
     * - .toReplaceRouteTableAssociation()
     * - .toReplaceTransitGatewayRoute()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetAddressAttribute()
     * - .toResetFpgaImageAttribute()
     * - .toResetImageAttribute()
     * - .toResetInstanceAttribute()
     * - .toResetNetworkInterfaceAttribute()
     * - .toResetSnapshotAttribute()
     * - .toRestoreImageFromRecycleBin()
     * - .toRestoreManagedPrefixListVersion()
     * - .toRestoreSnapshotFromRecycleBin()
     * - .toRestoreSnapshotTier()
     * - .toRevokeClientVpnIngress()
     * - .toRevokeSecurityGroupEgress()
     * - .toRevokeSecurityGroupIngress()
     * - .toRunInstances()
     * - .toSearchLocalGatewayRoutes()
     * - .toSearchTransitGatewayMulticastGroups()
     * - .toSearchTransitGatewayRoutes()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toStartInstances()
     * - .toStartNetworkInsightsAccessScopeAnalysis()
     * - .toStartNetworkInsightsAnalysis()
     * - .toStartVpcEndpointServicePrivateDnsVerification()
     * - .toStopInstances()
     * - .toTerminateClientVpnConnections()
     * - .toTerminateInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     * - .toUnmonitorInstances()
     * - .toUpdateSecurityGroupRuleDescriptionsEgress()
     * - .toUpdateSecurityGroupRuleDescriptionsIngress()
     *
     * Applies to resource types:
     * - elastic-ip
     * - capacity-reservation-fleet
     * - capacity-reservation
     * - carrier-gateway
     * - client-vpn-endpoint
     * - customer-gateway
     * - dedicated-host
     * - dhcp-options
     * - egress-only-internet-gateway
     * - elastic-gpu
     * - export-image-task
     * - export-instance-task
     * - fleet
     * - fpga-image
     * - host-reservation
     * - image
     * - import-image-task
     * - import-snapshot-task
     * - instance-event-window
     * - instance
     * - internet-gateway
     * - ipam
     * - ipam-pool
     * - ipam-resource-discovery-association
     * - ipam-resource-discovery
     * - ipam-scope
     * - coip-pool
     * - ipv4pool-ec2
     * - ipv6pool-ec2
     * - key-pair
     * - launch-template
     * - local-gateway
     * - local-gateway-route-table-virtual-interface-group-association
     * - local-gateway-route-table-vpc-association
     * - local-gateway-route-table
     * - local-gateway-virtual-interface-group
     * - local-gateway-virtual-interface
     * - natgateway
     * - network-acl
     * - network-insights-access-scope-analysis
     * - network-insights-access-scope
     * - network-insights-analysis
     * - network-insights-path
     * - network-interface
     * - placement-group
     * - prefix-list
     * - replace-root-volume-task
     * - reserved-instances
     * - route-table
     * - security-group
     * - security-group-rule
     * - snapshot
     * - spot-fleet-request
     * - spot-instances-request
     * - subnet-cidr-reservation
     * - subnet
     * - traffic-mirror-filter
     * - traffic-mirror-session
     * - traffic-mirror-target
     * - transit-gateway-attachment
     * - transit-gateway-connect-peer
     * - transit-gateway
     * - transit-gateway-multicast-domain
     * - transit-gateway-policy-table
     * - transit-gateway-route-table-announcement
     * - transit-gateway-route-table
     * - verified-access-endpoint
     * - verified-access-group
     * - verified-access-instance
     * - verified-access-policy
     * - verified-access-trust-provider
     * - volume
     * - vpc-endpoint-connection
     * - vpc-endpoint
     * - vpc-endpoint-service
     * - vpc-endpoint-service-permission
     * - vpc-flow-log
     * - vpc
     * - vpc-peering-connection
     * - vpn-connection
     * - vpn-gateway
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the version of the instance metadata service for retrieving IAM role credentials for EC2
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifRoleDelivery(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the root device type of the instance (ebs or instance-store)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toCancelImageLaunchPermission()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshots()
     * - .toCreateStoreImageTask()
     * - .toCreateTags()
     * - .toDeregisterImage()
     * - .toDescribeFastLaunchImages()
     * - .toDescribeImageAttribute()
     * - .toDescribeInstanceAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisableFastLaunch()
     * - .toDisableImageDeprecation()
     * - .toDisassociateIamInstanceProfile()
     * - .toEnableFastLaunch()
     * - .toEnableImageDeprecation()
     * - .toExportImage()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toImportImage()
     * - .toListImagesInRecycleBin()
     * - .toModifyFleet()
     * - .toModifyImageAttribute()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetImageAttribute()
     * - .toResetInstanceAttribute()
     * - .toRestoreImageFromRecycleBin()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - image
     * - instance
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRootDeviceType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a route table
     *
     * Applies to actions:
     * - .toAssociateRouteTable()
     * - .toCreateRoute()
     * - .toCreateRouteTable()
     * - .toCreateTags()
     * - .toCreateVpcEndpoint()
     * - .toDeleteRoute()
     * - .toDeleteRouteTable()
     * - .toDisableVgwRoutePropagation()
     * - .toDisassociateRouteTable()
     * - .toEnableVgwRoutePropagation()
     * - .toModifyVpcEndpoint()
     * - .toReplaceRoute()
     * - .toReplaceRouteTableAssociation()
     *
     * Applies to resource types:
     * - route-table
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRouteTableID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the routing type for the VPN connection
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toModifyVpnConnection()
     * - .toModifyVpnTunnelOptions()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRoutingType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the IAM SAML identity provider
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDescribeClientVpnConnections()
     * - .toDescribeClientVpnEndpoints()
     * - .toDescribeClientVpnRoutes()
     * - .toDescribeClientVpnTargetNetworks()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifSamlProviderArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a security group
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAttachClassicLinkVpc()
     * - .toAuthorizeSecurityGroupEgress()
     * - .toAuthorizeSecurityGroupIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateFleet()
     * - .toCreateNetworkInterface()
     * - .toCreateSecurityGroup()
     * - .toCreateTags()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toCreateVpcEndpoint()
     * - .toDeleteSecurityGroup()
     * - .toImportInstance()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyFleet()
     * - .toModifyInstanceAttribute()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifySecurityGroupRules()
     * - .toModifyVpcEndpoint()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toRevokeSecurityGroupEgress()
     * - .toRevokeSecurityGroupIngress()
     * - .toRunInstances()
     * - .toUpdateSecurityGroupRuleDescriptionsEgress()
     * - .toUpdateSecurityGroupRuleDescriptionsIngress()
     *
     * Applies to resource types:
     * - security-group
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSecurityGroupID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the server certificate
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDescribeClientVpnConnections()
     * - .toDescribeClientVpnEndpoints()
     * - .toDescribeClientVpnRoutes()
     * - .toDescribeClientVpnTargetNetworks()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifServerCertificateArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a snapshot
     *
     * Applies to actions:
     * - .toCopySnapshot()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDeleteSnapshot()
     * - .toDescribeSnapshotAttribute()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toImportImage()
     * - .toImportSnapshot()
     * - .toListSnapshotsInRecycleBin()
     * - .toModifyFleet()
     * - .toModifySnapshotAttribute()
     * - .toModifySnapshotTier()
     * - .toRegisterImage()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetSnapshotAttribute()
     * - .toRestoreSnapshotFromRecycleBin()
     * - .toRestoreSnapshotTier()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSnapshotID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the initiation time of a snapshot
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateTags()
     * - .toDeleteSnapshot()
     * - .toDescribeSnapshotAttribute()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toImportImage()
     * - .toImportSnapshot()
     * - .toListSnapshotsInRecycleBin()
     * - .toModifyFleet()
     * - .toModifySnapshotAttribute()
     * - .toModifySnapshotTier()
     * - .toRegisterImage()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetSnapshotAttribute()
     * - .toRestoreSnapshotFromRecycleBin()
     * - .toRestoreSnapshotTier()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [date operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Date). **Default:** `DateEquals`
     */
    ifSnapshotTime(value: Date | string | (Date | string)[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the instance from which the request originated
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifSourceInstanceARN(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the Outpost from which the request originated
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateImage()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toDeleteSnapshot()
     * - .toDescribeSnapshotAttribute()
     * - .toRegisterImage()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifSourceOutpostArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the subnet
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAttachNetworkInterface()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateLocalGatewayRoute()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateTags()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toDeleteNetworkInterface()
     * - .toDeleteNetworkInterfacePermission()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachNetworkInterface()
     * - .toDisassociateAddress()
     * - .toModifyFleet()
     * - .toModifyLocalGatewayRoute()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toRequestSpotInstances()
     * - .toResetNetworkInterfaceAttribute()
     * - .toRunInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifSubnet(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a subnet
     *
     * Applies to actions:
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAssociateRouteTable()
     * - .toAssociateSubnetCidrBlock()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toCreateClientVpnRoute()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateNatGateway()
     * - .toCreateNetworkInterface()
     * - .toCreateSubnet()
     * - .toCreateTags()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toCreateVpcEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteSubnet()
     * - .toDisassociateRouteTable()
     * - .toDisassociateSubnetCidrBlock()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toImportInstance()
     * - .toModifyFleet()
     * - .toModifySpotFleetRequest()
     * - .toModifySubnetAttribute()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVerifiedAccessEndpoint()
     * - .toModifyVpcEndpoint()
     * - .toReplaceNetworkAclAssociation()
     * - .toReplaceRouteTableAssociation()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - subnet
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSubnetID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tenancy of the VPC or instance (default, dedicated, or host)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptVpcPeeringConnection()
     * - .toAssociateAddress()
     * - .toAssociateDhcpOptions()
     * - .toAssociateIamInstanceProfile()
     * - .toAssociateVpcCidrBlock()
     * - .toAttachClassicLinkVpc()
     * - .toAttachInternetGateway()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toAttachVpnGateway()
     * - .toCreateCarrierGateway()
     * - .toCreateEgressOnlyInternetGateway()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateLocalGatewayRouteTableVpcAssociation()
     * - .toCreateNetworkAcl()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateRouteTable()
     * - .toCreateSecurityGroup()
     * - .toCreateSnapshots()
     * - .toCreateSubnet()
     * - .toCreateTags()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteVpc()
     * - .toDescribeInstanceAttribute()
     * - .toDescribeVpcAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachInternetGateway()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDetachVpnGateway()
     * - .toDisableVpcClassicLink()
     * - .toDisableVpcClassicLinkDnsSupport()
     * - .toDisassociateIamInstanceProfile()
     * - .toDisassociateVpcCidrBlock()
     * - .toEnableVpcClassicLink()
     * - .toEnableVpcClassicLinkDnsSupport()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetInstanceUefiData()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceMaintenanceOptions()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyPrivateDnsNameOptions()
     * - .toModifyReservedInstances()
     * - .toModifyVpcAttribute()
     * - .toModifyVpcTenancy()
     * - .toMonitorInstances()
     * - .toPauseVolumeIO()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toSendSpotInstanceInterruptions()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - carrier-gateway
     * - instance
     * - reserved-instances
     * - vpc
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTenancy(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a volume
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDescribeVolumeAttribute()
     * - .toDetachVolume()
     * - .toEnableVolumeIO()
     * - .toImportInstance()
     * - .toImportVolume()
     * - .toModifyInstanceAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toPauseVolumeIO()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVolumeID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the the number of input/output operations per second (IOPS) provisioned for the volume
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDescribeVolumeAttribute()
     * - .toDetachVolume()
     * - .toEnableVolumeIO()
     * - .toImportInstance()
     * - .toImportVolume()
     * - .toModifyInstanceAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toPauseVolumeIO()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifVolumeIops(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the size of the volume, in GiB
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateReplaceRootVolumeTask()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteSnapshot()
     * - .toDeleteVolume()
     * - .toDescribeSnapshotAttribute()
     * - .toDescribeVolumeAttribute()
     * - .toDetachVolume()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableVolumeIO()
     * - .toImportImage()
     * - .toImportInstance()
     * - .toImportSnapshot()
     * - .toImportVolume()
     * - .toListSnapshotsInRecycleBin()
     * - .toModifyFleet()
     * - .toModifyInstanceAttribute()
     * - .toModifySnapshotAttribute()
     * - .toModifySnapshotTier()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toPauseVolumeIO()
     * - .toRegisterImage()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetSnapshotAttribute()
     * - .toRestoreSnapshotFromRecycleBin()
     * - .toRestoreSnapshotTier()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - snapshot
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifVolumeSize(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the throughput of the volume, in MiBps
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDescribeVolumeAttribute()
     * - .toDetachVolume()
     * - .toEnableVolumeIO()
     * - .toImportInstance()
     * - .toImportVolume()
     * - .toModifyInstanceAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toPauseVolumeIO()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifVolumeThroughput(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by the type of volume (gp2, gp3, io1, io2, st1, sc1, or standard)
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toDescribeVolumeAttribute()
     * - .toDetachVolume()
     * - .toEnableVolumeIO()
     * - .toImportInstance()
     * - .toImportVolume()
     * - .toModifyInstanceAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toPauseVolumeIO()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVolumeType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the VPC
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAssociateRouteTable()
     * - .toAssociateSubnetCidrBlock()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAuthorizeSecurityGroupEgress()
     * - .toAuthorizeSecurityGroupIngress()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateLocalGatewayRoute()
     * - .toCreateNatGateway()
     * - .toCreateNetworkAclEntry()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateRoute()
     * - .toCreateTags()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVerifiedAccessEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteNetworkAcl()
     * - .toDeleteNetworkAclEntry()
     * - .toDeleteNetworkInterface()
     * - .toDeleteNetworkInterfacePermission()
     * - .toDeleteRoute()
     * - .toDeleteRouteTable()
     * - .toDeleteSecurityGroup()
     * - .toDeleteSubnet()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachNetworkInterface()
     * - .toDisableVgwRoutePropagation()
     * - .toDisassociateAddress()
     * - .toDisassociateRouteTable()
     * - .toDisassociateSubnetCidrBlock()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toEnableVgwRoutePropagation()
     * - .toImportInstance()
     * - .toModifyFleet()
     * - .toModifyInstanceAttribute()
     * - .toModifyLocalGatewayRoute()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifySecurityGroupRules()
     * - .toModifySpotFleetRequest()
     * - .toModifySubnetAttribute()
     * - .toModifyVerifiedAccessEndpoint()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toReplaceNetworkAclAssociation()
     * - .toReplaceNetworkAclEntry()
     * - .toReplaceRoute()
     * - .toReplaceRouteTableAssociation()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetNetworkInterfaceAttribute()
     * - .toRevokeSecurityGroupEgress()
     * - .toRevokeSecurityGroupIngress()
     * - .toRunInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     * - .toUpdateSecurityGroupRuleDescriptionsEgress()
     * - .toUpdateSecurityGroupRuleDescriptionsIngress()
     *
     * Applies to resource types:
     * - carrier-gateway
     * - network-acl
     * - network-interface
     * - route-table
     * - security-group
     * - subnet
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifVpc(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a virtual private cloud (VPC)
     *
     * Applies to actions:
     * - .toAcceptVpcPeeringConnection()
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateDhcpOptions()
     * - .toAssociateVpcCidrBlock()
     * - .toAttachClassicLinkVpc()
     * - .toAttachInternetGateway()
     * - .toAttachVpnGateway()
     * - .toCreateCarrierGateway()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateEgressOnlyInternetGateway()
     * - .toCreateFlowLogs()
     * - .toCreateLocalGatewayRouteTableVpcAssociation()
     * - .toCreateNetworkAcl()
     * - .toCreateRouteTable()
     * - .toCreateSecurityGroup()
     * - .toCreateSubnet()
     * - .toCreateTags()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVpc()
     * - .toCreateVpcEndpoint()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteVpc()
     * - .toDescribeVpcAttribute()
     * - .toDetachClassicLinkVpc()
     * - .toDetachInternetGateway()
     * - .toDetachVpnGateway()
     * - .toDisableVpcClassicLink()
     * - .toDisableVpcClassicLinkDnsSupport()
     * - .toDisassociateVpcCidrBlock()
     * - .toEnableVpcClassicLink()
     * - .toEnableVpcClassicLinkDnsSupport()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyVpcAttribute()
     * - .toModifyVpcTenancy()
     *
     * Applies to resource types:
     * - vpc
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a VPC peering connection
     *
     * Applies to actions:
     * - .toAcceptVpcPeeringConnection()
     * - .toCreateNetworkInsightsPath()
     * - .toCreateTags()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteVpcPeeringConnection()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toRejectVpcPeeringConnection()
     *
     * Applies to resource types:
     * - vpc-peering-connection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcPeeringConnectionID(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the name of the VPC endpoint service
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-iam.html
     *
     * Applies to actions:
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateVpcEndpoint()
     * - .toDeleteVpcEndpoints()
     *
     * Applies to resource types:
     * - vpc-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpceServiceName(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the service owner of the VPC endpoint service (amazon, aws-marketplace, or an AWS account ID)
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-iam.html
     *
     * Applies to actions:
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateVpcEndpoint()
     *
     * Applies to resource types:
     * - vpc-endpoint
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpceServiceOwner(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the private DNS name of the VPC endpoint service
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-iam.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServiceConfiguration()
     *
     * Applies to resource types:
     * - vpc-endpoint-service
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpceServicePrivateDnsName(value: string | string[], operator?: Operator | string): this;
}
