"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mediatailor = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [mediatailor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediatailor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mediatailor extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [mediatailor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediatailor.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'mediatailor';
        this.accessLevelList = {
            Write: [
                'ConfigureLogsForChannel',
                'ConfigureLogsForPlaybackConfiguration',
                'CreateChannel',
                'CreateLiveSource',
                'CreatePrefetchSchedule',
                'CreateProgram',
                'CreateSourceLocation',
                'CreateVodSource',
                'DeleteChannel',
                'DeleteLiveSource',
                'DeletePlaybackConfiguration',
                'DeletePrefetchSchedule',
                'DeleteProgram',
                'DeleteSourceLocation',
                'DeleteVodSource',
                'PutPlaybackConfiguration',
                'StartChannel',
                'StopChannel',
                'UpdateChannel',
                'UpdateLiveSource',
                'UpdateProgram',
                'UpdateSourceLocation',
                'UpdateVodSource'
            ],
            'Permissions management': [
                'DeleteChannelPolicy',
                'PutChannelPolicy'
            ],
            Read: [
                'DescribeChannel',
                'DescribeLiveSource',
                'DescribeProgram',
                'DescribeSourceLocation',
                'DescribeVodSource',
                'GetChannelPolicy',
                'GetChannelSchedule',
                'GetPlaybackConfiguration',
                'GetPrefetchSchedule',
                'ListAlerts',
                'ListChannels',
                'ListLiveSources',
                'ListSourceLocations',
                'ListTagsForResource',
                'ListVodSources'
            ],
            List: [
                'ListPlaybackConfigurations',
                'ListPrefetchSchedules'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to configure logs on the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/configurelogs-channel.html
     */
    toConfigureLogsForChannel() {
        return this.to('ConfigureLogsForChannel');
    }
    /**
     * Grants permission to configure logs for a playback configuration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/configurelogs-playbackconfiguration.html
     */
    toConfigureLogsForPlaybackConfiguration() {
        return this.to('ConfigureLogsForPlaybackConfiguration');
    }
    /**
     * Grants permission to create a new channel
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     */
    toCreateChannel() {
        return this.to('CreateChannel');
    }
    /**
     * Grants permission to create a new live source on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesource-livesourcename.html
     */
    toCreateLiveSource() {
        return this.to('CreateLiveSource');
    }
    /**
     * Grants permission to create a prefetch schedule for the playback configuration with the specified playback configuration name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/prefetchschedule-playbackconfigurationname-name.html
     */
    toCreatePrefetchSchedule() {
        return this.to('CreatePrefetchSchedule');
    }
    /**
     * Grants permission to create a new program on the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     */
    toCreateProgram() {
        return this.to('CreateProgram');
    }
    /**
     * Grants permission to create a new source location
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     */
    toCreateSourceLocation() {
        return this.to('CreateSourceLocation');
    }
    /**
     * Grants permission to create a new VOD source on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     */
    toCreateVodSource() {
        return this.to('CreateVodSource');
    }
    /**
     * Grants permission to delete the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     */
    toDeleteChannel() {
        return this.to('DeleteChannel');
    }
    /**
     * Grants permission to delete the IAM policy on the channel with the specified channel name
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-policy.html
     */
    toDeleteChannelPolicy() {
        return this.to('DeleteChannelPolicy');
    }
    /**
     * Grants permission to delete the live source with the specified live source name on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesource-livesourcename.html
     */
    toDeleteLiveSource() {
        return this.to('DeleteLiveSource');
    }
    /**
     * Grants permission to delete the specified playback configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration-name.html
     */
    toDeletePlaybackConfiguration() {
        return this.to('DeletePlaybackConfiguration');
    }
    /**
     * Grants permission to delete a prefetch schedule for a playback configuration with the specified prefetch schedule name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/prefetchschedule-playbackconfigurationname-name.html
     */
    toDeletePrefetchSchedule() {
        return this.to('DeletePrefetchSchedule');
    }
    /**
     * Grants permission to delete the program with the specified program name on the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     */
    toDeleteProgram() {
        return this.to('DeleteProgram');
    }
    /**
     * Grants permission to delete the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     */
    toDeleteSourceLocation() {
        return this.to('DeleteSourceLocation');
    }
    /**
     * Grants permission to delete the VOD source with the specified VOD source name on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     */
    toDeleteVodSource() {
        return this.to('DeleteVodSource');
    }
    /**
     * Grants permission to retrieve the channel with the specified channel name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     */
    toDescribeChannel() {
        return this.to('DescribeChannel');
    }
    /**
     * Grants permission to retrieve the live source with the specified live source name on the source location with the specified source location name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesource-livesourcename.html
     */
    toDescribeLiveSource() {
        return this.to('DescribeLiveSource');
    }
    /**
     * Grants permission to retrieve the program with the specified program name on the channel with the specified channel name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     */
    toDescribeProgram() {
        return this.to('DescribeProgram');
    }
    /**
     * Grants permission to retrieve the source location with the specified source location name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     */
    toDescribeSourceLocation() {
        return this.to('DescribeSourceLocation');
    }
    /**
     * Grants permission to retrieve the VOD source with the specified VOD source name on the source location with the specified source location name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     */
    toDescribeVodSource() {
        return this.to('DescribeVodSource');
    }
    /**
     * Grants permission to read the IAM policy on the channel with the specified channel name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-policy.html
     */
    toGetChannelPolicy() {
        return this.to('GetChannelPolicy');
    }
    /**
     * Grants permission to retrieve the schedule of programs on the channel with the specified channel name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-schedule.html
     */
    toGetChannelSchedule() {
        return this.to('GetChannelSchedule');
    }
    /**
     * Grants permission to retrieve the configuration for the specified name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration-name.html
     */
    toGetPlaybackConfiguration() {
        return this.to('GetPlaybackConfiguration');
    }
    /**
     * Grants permission to retrieve prefetch schedule for a playback configuration with the specified prefetch schedule name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/prefetchschedule-playbackconfigurationname-name.html
     */
    toGetPrefetchSchedule() {
        return this.to('GetPrefetchSchedule');
    }
    /**
     * Grants permission to retrieve the list of alerts on a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/alerts.html
     */
    toListAlerts() {
        return this.to('ListAlerts');
    }
    /**
     * Grants permission to retrieve the list of existing channels
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channels.html
     */
    toListChannels() {
        return this.to('ListChannels');
    }
    /**
     * Grants permission to retrieve the list of existing live sources on the source location with the specified source location name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesources.html
     */
    toListLiveSources() {
        return this.to('ListLiveSources');
    }
    /**
     * Grants permission to retrieve the list of available configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfigurations.html
     */
    toListPlaybackConfigurations() {
        return this.to('ListPlaybackConfigurations');
    }
    /**
     * Grants permission to retrieve the list of prefetch schedules for a playback configuration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/prefetchschedule-playbackconfigurationname.html
     */
    toListPrefetchSchedules() {
        return this.to('ListPrefetchSchedules');
    }
    /**
     * Grants permission to retrieve the list of existing source locations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocations.html
     */
    toListSourceLocations() {
        return this.to('ListSourceLocations');
    }
    /**
     * Grants permission to list the tags assigned to the specified playback configuration resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/tags-resourcearn.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to retrieve the list of existing VOD sources on the source location with the specified source location name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsources.html
     */
    toListVodSources() {
        return this.to('ListVodSources');
    }
    /**
     * Grants permission to set the IAM policy on the channel with the specified channel name
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-policy.html
     */
    toPutChannelPolicy() {
        return this.to('PutChannelPolicy');
    }
    /**
     * Grants permission to add a new configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration.html
     */
    toPutPlaybackConfiguration() {
        return this.to('PutPlaybackConfiguration');
    }
    /**
     * Grants permission to start the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-start.html
     */
    toStartChannel() {
        return this.to('StartChannel');
    }
    /**
     * Grants permission to stop the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-stop.html
     */
    toStopChannel() {
        return this.to('StopChannel');
    }
    /**
     * Grants permission to add tags to the specified playback configuration resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/tags-resourcearn.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from the specified playback configuration resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/tags-resourcearn.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     */
    toUpdateChannel() {
        return this.to('UpdateChannel');
    }
    /**
     * Grants permission to update the live source with the specified live source name on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesource-livesourcename.html
     */
    toUpdateLiveSource() {
        return this.to('UpdateLiveSource');
    }
    /**
     * Grants permission to update the program with the specified program name on the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     */
    toUpdateProgram() {
        return this.to('UpdateProgram');
    }
    /**
     * Grants permission to update the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     */
    toUpdateSourceLocation() {
        return this.to('UpdateSourceLocation');
    }
    /**
     * Grants permission to update the VOD source with the specified VOD source name on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     */
    toUpdateVodSource() {
        return this.to('UpdateVodSource');
    }
    /**
     * Adds a resource of type playbackConfiguration to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlaybackConfiguration(resourceId, account, region, partition) {
        return this.on(`arn:${partition || Mediatailor.defaultPartition}:mediatailor:${region || '*'}:${account || '*'}:playbackConfiguration/${resourceId}`);
    }
    /**
     * Adds a resource of type prefetchSchedule to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/prefetchschedule-playbackconfigurationname-name.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPrefetchSchedule(resourceId, account, region, partition) {
        return this.on(`arn:${partition || Mediatailor.defaultPartition}:mediatailor:${region || '*'}:${account || '*'}:prefetchSchedule/${resourceId}`);
    }
    /**
     * Adds a resource of type channel to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     *
     * @param channelName - Identifier for the channelName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChannel(channelName, account, region, partition) {
        return this.on(`arn:${partition || Mediatailor.defaultPartition}:mediatailor:${region || '*'}:${account || '*'}:channel/${channelName}`);
    }
    /**
     * Adds a resource of type program to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     *
     * @param channelName - Identifier for the channelName.
     * @param programName - Identifier for the programName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProgram(channelName, programName, account, region, partition) {
        return this.on(`arn:${partition || Mediatailor.defaultPartition}:mediatailor:${region || '*'}:${account || '*'}:program/${channelName}/${programName}`);
    }
    /**
     * Adds a resource of type sourceLocation to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     *
     * @param sourceLocationName - Identifier for the sourceLocationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSourceLocation(sourceLocationName, account, region, partition) {
        return this.on(`arn:${partition || Mediatailor.defaultPartition}:mediatailor:${region || '*'}:${account || '*'}:sourceLocation/${sourceLocationName}`);
    }
    /**
     * Adds a resource of type vodSource to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     *
     * @param sourceLocationName - Identifier for the sourceLocationName.
     * @param vodSourceName - Identifier for the vodSourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVodSource(sourceLocationName, vodSourceName, account, region, partition) {
        return this.on(`arn:${partition || Mediatailor.defaultPartition}:mediatailor:${region || '*'}:${account || '*'}:vodSource/${sourceLocationName}/${vodSourceName}`);
    }
    /**
     * Adds a resource of type liveSource to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesource-livesourcename.html
     *
     * @param sourceLocationName - Identifier for the sourceLocationName.
     * @param liveSourceName - Identifier for the liveSourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLiveSource(sourceLocationName, liveSourceName, account, region, partition) {
        return this.on(`arn:${partition || Mediatailor.defaultPartition}:mediatailor:${region || '*'}:${account || '*'}:liveSource/${sourceLocationName}/${liveSourceName}`);
    }
}
exports.Mediatailor = Mediatailor;
_a = JSII_RTTI_SYMBOL_1;
Mediatailor[_a] = { fqn: "iam-floyd.Mediatailor", version: "0.485.0" };
//# sourceMappingURL=data:application/json;base64,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