"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iotwireless = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iotwireless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotcoreforlorawan.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iotwireless extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iotwireless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotcoreforlorawan.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iotwireless';
        this.accessLevelList = {
            Write: [
                'AssociateAwsAccountWithPartnerAccount',
                'AssociateMulticastGroupWithFuotaTask',
                'AssociateWirelessDeviceWithFuotaTask',
                'AssociateWirelessDeviceWithMulticastGroup',
                'AssociateWirelessDeviceWithThing',
                'AssociateWirelessGatewayWithCertificate',
                'AssociateWirelessGatewayWithThing',
                'CancelMulticastGroupSession',
                'CreateDestination',
                'CreateDeviceProfile',
                'CreateFuotaTask',
                'CreateMulticastGroup',
                'CreateNetworkAnalyzerConfiguration',
                'CreateServiceProfile',
                'CreateWirelessDevice',
                'CreateWirelessGateway',
                'CreateWirelessGatewayTask',
                'CreateWirelessGatewayTaskDefinition',
                'DeleteDestination',
                'DeleteDeviceProfile',
                'DeleteFuotaTask',
                'DeleteMulticastGroup',
                'DeleteNetworkAnalyzerConfiguration',
                'DeleteQueuedMessages',
                'DeleteServiceProfile',
                'DeleteWirelessDevice',
                'DeleteWirelessGateway',
                'DeleteWirelessGatewayTask',
                'DeleteWirelessGatewayTaskDefinition',
                'DisassociateAwsAccountFromPartnerAccount',
                'DisassociateMulticastGroupFromFuotaTask',
                'DisassociateWirelessDeviceFromFuotaTask',
                'DisassociateWirelessDeviceFromMulticastGroup',
                'DisassociateWirelessDeviceFromThing',
                'DisassociateWirelessGatewayFromCertificate',
                'DisassociateWirelessGatewayFromThing',
                'PutPositionConfiguration',
                'PutResourceLogLevel',
                'ResetAllResourceLogLevels',
                'ResetResourceLogLevel',
                'SendDataToMulticastGroup',
                'SendDataToWirelessDevice',
                'StartBulkAssociateWirelessDeviceWithMulticastGroup',
                'StartBulkDisassociateWirelessDeviceFromMulticastGroup',
                'StartFuotaTask',
                'StartMulticastGroupSession',
                'StartNetworkAnalyzerStream',
                'TestWirelessDevice',
                'UpdateDestination',
                'UpdateEventConfigurationByResourceTypes',
                'UpdateFuotaTask',
                'UpdateLogLevelsByResourceTypes',
                'UpdateMulticastGroup',
                'UpdateNetworkAnalyzerConfiguration',
                'UpdatePartnerAccount',
                'UpdatePosition',
                'UpdateResourceEventConfiguration',
                'UpdateResourcePosition',
                'UpdateWirelessDevice',
                'UpdateWirelessGateway'
            ],
            Read: [
                'GetDestination',
                'GetDeviceProfile',
                'GetEventConfigurationByResourceTypes',
                'GetFuotaTask',
                'GetLogLevelsByResourceTypes',
                'GetMulticastGroup',
                'GetMulticastGroupSession',
                'GetNetworkAnalyzerConfiguration',
                'GetPartnerAccount',
                'GetPosition',
                'GetPositionConfiguration',
                'GetPositionEstimate',
                'GetResourceEventConfiguration',
                'GetResourceLogLevel',
                'GetResourcePosition',
                'GetServiceEndpoint',
                'GetServiceProfile',
                'GetWirelessDevice',
                'GetWirelessDeviceStatistics',
                'GetWirelessGateway',
                'GetWirelessGatewayCertificate',
                'GetWirelessGatewayFirmwareInformation',
                'GetWirelessGatewayStatistics',
                'GetWirelessGatewayTask',
                'GetWirelessGatewayTaskDefinition',
                'ListDestinations',
                'ListDeviceProfiles',
                'ListEventConfigurations',
                'ListFuotaTasks',
                'ListMulticastGroups',
                'ListMulticastGroupsByFuotaTask',
                'ListNetworkAnalyzerConfigurations',
                'ListPartnerAccounts',
                'ListPositionConfigurations',
                'ListQueuedMessages',
                'ListServiceProfiles',
                'ListTagsForResource',
                'ListWirelessDevices',
                'ListWirelessGatewayTaskDefinitions',
                'ListWirelessGateways'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to link partner accounts with AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateAwsAccountWithPartnerAccount.html
     */
    toAssociateAwsAccountWithPartnerAccount() {
        return this.to('AssociateAwsAccountWithPartnerAccount');
    }
    /**
     * Grants permission to associate the MulticastGroup with FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateMulticastGroupWithFuotaTask.html
     */
    toAssociateMulticastGroupWithFuotaTask() {
        return this.to('AssociateMulticastGroupWithFuotaTask');
    }
    /**
     * Grants permission to associate the wireless device with FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessDeviceWithFuotaTask.html
     */
    toAssociateWirelessDeviceWithFuotaTask() {
        return this.to('AssociateWirelessDeviceWithFuotaTask');
    }
    /**
     * Grants permission to associate the WirelessDevice with MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessDeviceWithMulticastGroup.html
     */
    toAssociateWirelessDeviceWithMulticastGroup() {
        return this.to('AssociateWirelessDeviceWithMulticastGroup');
    }
    /**
     * Grants permission to associate the wireless device with AWS IoT thing for a given wirelessDeviceId
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessDeviceWithThing.html
     */
    toAssociateWirelessDeviceWithThing() {
        return this.to('AssociateWirelessDeviceWithThing');
    }
    /**
     * Grants permission to associate a WirelessGateway with the IoT Core Identity certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessGatewayWithCertificate.html
     */
    toAssociateWirelessGatewayWithCertificate() {
        return this.to('AssociateWirelessGatewayWithCertificate');
    }
    /**
     * Grants permission to associate the wireless gateway with AWS IoT thing for a given wirelessGatewayId
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessGatewayWithThing.html
     */
    toAssociateWirelessGatewayWithThing() {
        return this.to('AssociateWirelessGatewayWithThing');
    }
    /**
     * Grants permission to cancel the MulticastGroup session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CancelMulticastGroupSession.html
     */
    toCancelMulticastGroupSession() {
        return this.to('CancelMulticastGroupSession');
    }
    /**
     * Grants permission to create a Destination resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDestination.html
     */
    toCreateDestination() {
        return this.to('CreateDestination');
    }
    /**
     * Grants permission to create a DeviceProfile resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDeviceProfile.html
     */
    toCreateDeviceProfile() {
        return this.to('CreateDeviceProfile');
    }
    /**
     * Grants permission to create a FuotaTask resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateFuotaTask.html
     */
    toCreateFuotaTask() {
        return this.to('CreateFuotaTask');
    }
    /**
     * Grants permission to create a MulticastGroup resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateMulticastGroup.html
     */
    toCreateMulticastGroup() {
        return this.to('CreateMulticastGroup');
    }
    /**
     * Grants permission to create a NetworkAnalyzerConfiguration resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateNetworkAnalyzerConfiguration.html
     */
    toCreateNetworkAnalyzerConfiguration() {
        return this.to('CreateNetworkAnalyzerConfiguration');
    }
    /**
     * Grants permission to create a ServiceProfile resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateServiceProfile.html
     */
    toCreateServiceProfile() {
        return this.to('CreateServiceProfile');
    }
    /**
     * Grants permission to create a WirelessDevice resource with given Destination
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessDevice.html
     */
    toCreateWirelessDevice() {
        return this.to('CreateWirelessDevice');
    }
    /**
     * Grants permission to create a WirelessGateway resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGateway.html
     */
    toCreateWirelessGateway() {
        return this.to('CreateWirelessGateway');
    }
    /**
     * Grants permission to create a task for a given WirelessGateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTask.html
     */
    toCreateWirelessGatewayTask() {
        return this.to('CreateWirelessGatewayTask');
    }
    /**
     * Grants permission to create a WirelessGateway task definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTaskDefinition.html
     */
    toCreateWirelessGatewayTaskDefinition() {
        return this.to('CreateWirelessGatewayTaskDefinition');
    }
    /**
     * Grants permission to delete a Destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteDestination.html
     */
    toDeleteDestination() {
        return this.to('DeleteDestination');
    }
    /**
     * Grants permission to delete a DeviceProfile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteDeviceProfile.html
     */
    toDeleteDeviceProfile() {
        return this.to('DeleteDeviceProfile');
    }
    /**
     * Grants permission to delete the FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteFuotaTask.html
     */
    toDeleteFuotaTask() {
        return this.to('DeleteFuotaTask');
    }
    /**
     * Grants permission to delete the MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteMulticastGroup.html
     */
    toDeleteMulticastGroup() {
        return this.to('DeleteMulticastGroup');
    }
    /**
     * Grants permission to delete the NetworkAnalyzerConfiguration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteNetworkAnalyzerConfiguration.html
     */
    toDeleteNetworkAnalyzerConfiguration() {
        return this.to('DeleteNetworkAnalyzerConfiguration');
    }
    /**
     * Grants permission to delete QueuedMessages
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteQueuedMessages.html
     */
    toDeleteQueuedMessages() {
        return this.to('DeleteQueuedMessages');
    }
    /**
     * Grants permission to delete a ServiceProfile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteServiceProfile.html
     */
    toDeleteServiceProfile() {
        return this.to('DeleteServiceProfile');
    }
    /**
     * Grants permission to delete a WirelessDevice
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessDevice.html
     */
    toDeleteWirelessDevice() {
        return this.to('DeleteWirelessDevice');
    }
    /**
     * Grants permission to delete a WirelessGateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGateway.html
     */
    toDeleteWirelessGateway() {
        return this.to('DeleteWirelessGateway');
    }
    /**
     * Grants permission to delete task for a given WirelessGateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGatewayTask.html
     */
    toDeleteWirelessGatewayTask() {
        return this.to('DeleteWirelessGatewayTask');
    }
    /**
     * Grants permission to delete a WirelessGateway task definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGatewayTaskDefinition.html
     */
    toDeleteWirelessGatewayTaskDefinition() {
        return this.to('DeleteWirelessGatewayTaskDefinition');
    }
    /**
     * Grants permission to disassociate an AWS account from a partner account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateAwsAccountFromPartnerAccount.html
     */
    toDisassociateAwsAccountFromPartnerAccount() {
        return this.to('DisassociateAwsAccountFromPartnerAccount');
    }
    /**
     * Grants permission to disassociate the MulticastGroup from FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateMulticastGroupFromFuotaTask.html
     */
    toDisassociateMulticastGroupFromFuotaTask() {
        return this.to('DisassociateMulticastGroupFromFuotaTask');
    }
    /**
     * Grants permission to disassociate the wireless device from FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessDeviceFromFuotaTask.html
     */
    toDisassociateWirelessDeviceFromFuotaTask() {
        return this.to('DisassociateWirelessDeviceFromFuotaTask');
    }
    /**
     * Grants permission to disassociate the wireless device from MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessDeviceFromMulticastGroup.html
     */
    toDisassociateWirelessDeviceFromMulticastGroup() {
        return this.to('DisassociateWirelessDeviceFromMulticastGroup');
    }
    /**
     * Grants permission to disassociate a wireless device from a AWS IoT thing
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessDeviceFromThing.html
     */
    toDisassociateWirelessDeviceFromThing() {
        return this.to('DisassociateWirelessDeviceFromThing');
    }
    /**
     * Grants permission to disassociate a WirelessGateway from a IoT Core Identity certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessGatewayFromCertificate.html
     */
    toDisassociateWirelessGatewayFromCertificate() {
        return this.to('DisassociateWirelessGatewayFromCertificate');
    }
    /**
     * Grants permission to disassociate a WirelessGateway from a IoT Core thing
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessGatewayFromThing.html
     */
    toDisassociateWirelessGatewayFromThing() {
        return this.to('DisassociateWirelessGatewayFromThing');
    }
    /**
     * Grants permission to get the Destination
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetDestination.html
     */
    toGetDestination() {
        return this.to('GetDestination');
    }
    /**
     * Grants permission to get the DeviceProfile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetDeviceProfile.html
     */
    toGetDeviceProfile() {
        return this.to('GetDeviceProfile');
    }
    /**
     * Grants permission to get event configuration by resource types
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetEventConfigurationByResourceTypes.html
     */
    toGetEventConfigurationByResourceTypes() {
        return this.to('GetEventConfigurationByResourceTypes');
    }
    /**
     * Grants permission to get the FuotaTask
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetFuotaTask.html
     */
    toGetFuotaTask() {
        return this.to('GetFuotaTask');
    }
    /**
     * Grants permission to get log levels by resource types
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetLogLevelsByResourceTypes.html
     */
    toGetLogLevelsByResourceTypes() {
        return this.to('GetLogLevelsByResourceTypes');
    }
    /**
     * Grants permission to get the MulticastGroup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetMulticastGroup.html
     */
    toGetMulticastGroup() {
        return this.to('GetMulticastGroup');
    }
    /**
     * Grants permission to get the MulticastGroup session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetMulticastGroupSession.html
     */
    toGetMulticastGroupSession() {
        return this.to('GetMulticastGroupSession');
    }
    /**
     * Grants permission to get the NetworkAnalyzerConfiguration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetNetworkAnalyzerConfiguration.html
     */
    toGetNetworkAnalyzerConfiguration() {
        return this.to('GetNetworkAnalyzerConfiguration');
    }
    /**
     * Grants permission to get the associated PartnerAccount
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetPartnerAccount.html
     */
    toGetPartnerAccount() {
        return this.to('GetPartnerAccount');
    }
    /**
     * Grants permission to get position for a given resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetPosition.html
     */
    toGetPosition() {
        return this.to('GetPosition');
    }
    /**
     * Grants permission to get position configuration for a given resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetPositionConfiguration.html
     */
    toGetPositionConfiguration() {
        return this.to('GetPositionConfiguration');
    }
    /**
     * Grants permission to get position estimate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetPositionEstimate.html
     */
    toGetPositionEstimate() {
        return this.to('GetPositionEstimate');
    }
    /**
     * Grants permission to get an event configuration for an identifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourceEventConfiguration.html
     */
    toGetResourceEventConfiguration() {
        return this.to('GetResourceEventConfiguration');
    }
    /**
     * Grants permission to get resource log level
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourceLogLevel.html
     */
    toGetResourceLogLevel() {
        return this.to('GetResourceLogLevel');
    }
    /**
     * Grants permission to get position for a given resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html
     */
    toGetResourcePosition() {
        return this.to('GetResourcePosition');
    }
    /**
     * Grants permission to retrieve the customer account specific endpoint for CUPS protocol connection or LoRaWAN Network Server (LNS) protocol connection, and optionally server trust certificate in PEM format
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetServiceEndpoint.html
     */
    toGetServiceEndpoint() {
        return this.to('GetServiceEndpoint');
    }
    /**
     * Grants permission to get the ServiceProfile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetServiceProfile.html
     */
    toGetServiceProfile() {
        return this.to('GetServiceProfile');
    }
    /**
     * Grants permission to get the WirelessDevice
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessDevice.html
     */
    toGetWirelessDevice() {
        return this.to('GetWirelessDevice');
    }
    /**
     * Grants permission to get statistics info for a given WirelessDevice
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessDeviceStatistics.html
     */
    toGetWirelessDeviceStatistics() {
        return this.to('GetWirelessDeviceStatistics');
    }
    /**
     * Grants permission to get the WirelessGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGateway.html
     */
    toGetWirelessGateway() {
        return this.to('GetWirelessGateway');
    }
    /**
     * Grants permission to get the IoT Core Identity certificate id associated with the WirelessGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayCertificate.html
     */
    toGetWirelessGatewayCertificate() {
        return this.to('GetWirelessGatewayCertificate');
    }
    /**
     * Grants permission to get Current firmware version and other information for the WirelessGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayFirmwareInformation.html
     */
    toGetWirelessGatewayFirmwareInformation() {
        return this.to('GetWirelessGatewayFirmwareInformation');
    }
    /**
     * Grants permission to get statistics info for a given WirelessGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayStatistics.html
     */
    toGetWirelessGatewayStatistics() {
        return this.to('GetWirelessGatewayStatistics');
    }
    /**
     * Grants permission to get the task for a given WirelessGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayTask.html
     */
    toGetWirelessGatewayTask() {
        return this.to('GetWirelessGatewayTask');
    }
    /**
     * Grants permission to get the given WirelessGateway task definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayTaskDefinition.html
     */
    toGetWirelessGatewayTaskDefinition() {
        return this.to('GetWirelessGatewayTaskDefinition');
    }
    /**
     * Grants permission to list information of available Destinations based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListDestinations.html
     */
    toListDestinations() {
        return this.to('ListDestinations');
    }
    /**
     * Grants permission to list information of available DeviceProfiles based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListDeviceProfiles.html
     */
    toListDeviceProfiles() {
        return this.to('ListDeviceProfiles');
    }
    /**
     * Grants permission to list information of available event configurations based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListEventConfigurations.html
     */
    toListEventConfigurations() {
        return this.to('ListEventConfigurations');
    }
    /**
     * Grants permission to list information of available FuotaTasks based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListFuotaTasks.html
     */
    toListFuotaTasks() {
        return this.to('ListFuotaTasks');
    }
    /**
     * Grants permission to list information of available MulticastGroups based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListMulticastGroups.html
     */
    toListMulticastGroups() {
        return this.to('ListMulticastGroups');
    }
    /**
     * Grants permission to list information of available MulticastGroups by FuotaTask based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListMulticastGroupsByFuotaTask.html
     */
    toListMulticastGroupsByFuotaTask() {
        return this.to('ListMulticastGroupsByFuotaTask');
    }
    /**
     * Grants permission to list information of available NetworkAnalyzerConfigurations based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListNetworkAnalyzerConfigurations.html
     */
    toListNetworkAnalyzerConfigurations() {
        return this.to('ListNetworkAnalyzerConfigurations');
    }
    /**
     * Grants permission to list the available partner accounts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListPartnerAccounts.html
     */
    toListPartnerAccounts() {
        return this.to('ListPartnerAccounts');
    }
    /**
     * Grants permission to list information of available position configurations based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListPositionConfigurations.html
     */
    toListPositionConfigurations() {
        return this.to('ListPositionConfigurations');
    }
    /**
     * Grants permission to list the Queued Messages
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListQueuedMessages.html
     */
    toListQueuedMessages() {
        return this.to('ListQueuedMessages');
    }
    /**
     * Grants permission to list information of available ServiceProfiles based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListServiceProfiles.html
     */
    toListServiceProfiles() {
        return this.to('ListServiceProfiles');
    }
    /**
     * Grants permission to list all tags for a given resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list information of available WirelessDevices based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessDevices.html
     */
    toListWirelessDevices() {
        return this.to('ListWirelessDevices');
    }
    /**
     * Grants permission to list information of available WirelessGateway task definitions based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessGatewayTaskDefinitions.html
     */
    toListWirelessGatewayTaskDefinitions() {
        return this.to('ListWirelessGatewayTaskDefinitions');
    }
    /**
     * Grants permission to list information of available WirelessGateways based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessGateways.html
     */
    toListWirelessGateways() {
        return this.to('ListWirelessGateways');
    }
    /**
     * Grants permission to put position configuration for a given resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_PutPositionConfiguration.html
     */
    toPutPositionConfiguration() {
        return this.to('PutPositionConfiguration');
    }
    /**
     * Grants permission to put resource log level
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_PutResourceLogLevel.html
     */
    toPutResourceLogLevel() {
        return this.to('PutResourceLogLevel');
    }
    /**
     * Grants permission to reset all resource log levels
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ResetAllResourceLogLevels.html
     */
    toResetAllResourceLogLevels() {
        return this.to('ResetAllResourceLogLevels');
    }
    /**
     * Grants permission to reset resource log level
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ResetResourceLogLevel.html
     */
    toResetResourceLogLevel() {
        return this.to('ResetResourceLogLevel');
    }
    /**
     * Grants permission to send data to the MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_SendDataToMulticastGroup.html
     */
    toSendDataToMulticastGroup() {
        return this.to('SendDataToMulticastGroup');
    }
    /**
     * Grants permission to send the decrypted application data frame to the target device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_SendDataToWirelessDevice.html
     */
    toSendDataToWirelessDevice() {
        return this.to('SendDataToWirelessDevice');
    }
    /**
     * Grants permission to associate the WirelessDevices with MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartBulkAssociateWirelessDeviceWithMulticastGroup.html
     */
    toStartBulkAssociateWirelessDeviceWithMulticastGroup() {
        return this.to('StartBulkAssociateWirelessDeviceWithMulticastGroup');
    }
    /**
     * Grants permission to bulk disassociate the WirelessDevices from MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartBulkDisassociateWirelessDeviceFromMulticastGroup.html
     */
    toStartBulkDisassociateWirelessDeviceFromMulticastGroup() {
        return this.to('StartBulkDisassociateWirelessDeviceFromMulticastGroup');
    }
    /**
     * Grants permission to start the FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartFuotaTask.html
     */
    toStartFuotaTask() {
        return this.to('StartFuotaTask');
    }
    /**
     * Grants permission to start the MulticastGroup session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartMulticastGroupSession.html
     */
    toStartMulticastGroupSession() {
        return this.to('StartMulticastGroupSession');
    }
    /**
     * Grants permission to start NetworkAnalyzer stream
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/connect-iot-lorawan-network-analyzer-api.html
     */
    toStartNetworkAnalyzerStream() {
        return this.to('StartNetworkAnalyzerStream');
    }
    /**
     * Grants permission to tag a given resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to simulate a provisioned device to send an uplink data with payload of 'Hello'
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_TestWirelessDevice.html
     */
    toTestWirelessDevice() {
        return this.to('TestWirelessDevice');
    }
    /**
     * Grants permission to remove the given tags from the resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a Destination resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateDestination.html
     */
    toUpdateDestination() {
        return this.to('UpdateDestination');
    }
    /**
     * Grants permission to update event configuration by resource types
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateEventConfigurationByResourceTypes.html
     */
    toUpdateEventConfigurationByResourceTypes() {
        return this.to('UpdateEventConfigurationByResourceTypes');
    }
    /**
     * Grants permission to update the FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateFuotaTask.html
     */
    toUpdateFuotaTask() {
        return this.to('UpdateFuotaTask');
    }
    /**
     * Grants permission to update log levels by resource types
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateLogLevelsByResourceTypes.html
     */
    toUpdateLogLevelsByResourceTypes() {
        return this.to('UpdateLogLevelsByResourceTypes');
    }
    /**
     * Grants permission to update the MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateMulticastGroup.html
     */
    toUpdateMulticastGroup() {
        return this.to('UpdateMulticastGroup');
    }
    /**
     * Grants permission to update the NetworkAnalyzerConfiguration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateNetworkAnalyzerConfiguration.html
     */
    toUpdateNetworkAnalyzerConfiguration() {
        return this.to('UpdateNetworkAnalyzerConfiguration');
    }
    /**
     * Grants permission to update a partner account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdatePartnerAccount.html
     */
    toUpdatePartnerAccount() {
        return this.to('UpdatePartnerAccount');
    }
    /**
     * Grants permission to update position for a given resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdatePosition.html
     */
    toUpdatePosition() {
        return this.to('UpdatePosition');
    }
    /**
     * Grants permission to update an event configuration for an identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourceEventConfiguration.html
     */
    toUpdateResourceEventConfiguration() {
        return this.to('UpdateResourceEventConfiguration');
    }
    /**
     * Grants permission to update position for a given resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html
     */
    toUpdateResourcePosition() {
        return this.to('UpdateResourcePosition');
    }
    /**
     * Grants permission to update a WirelessDevice resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateWirelessDevice.html
     */
    toUpdateWirelessDevice() {
        return this.to('UpdateWirelessDevice');
    }
    /**
     * Grants permission to update a WirelessGateway resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateWirelessGateway.html
     */
    toUpdateWirelessGateway() {
        return this.to('UpdateWirelessGateway');
    }
    /**
     * Adds a resource of type WirelessDevice to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessDevice.html
     *
     * @param wirelessDeviceId - Identifier for the wirelessDeviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWirelessDevice(wirelessDeviceId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:WirelessDevice/${wirelessDeviceId}`);
    }
    /**
     * Adds a resource of type WirelessGateway to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGateway.html
     *
     * @param wirelessGatewayId - Identifier for the wirelessGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWirelessGateway(wirelessGatewayId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:WirelessGateway/${wirelessGatewayId}`);
    }
    /**
     * Adds a resource of type DeviceProfile to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDeviceProfile.html
     *
     * @param deviceProfileId - Identifier for the deviceProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDeviceProfile(deviceProfileId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:DeviceProfile/${deviceProfileId}`);
    }
    /**
     * Adds a resource of type ServiceProfile to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateServiceProfile.html
     *
     * @param serviceProfileId - Identifier for the serviceProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceProfile(serviceProfileId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:ServiceProfile/${serviceProfileId}`);
    }
    /**
     * Adds a resource of type Destination to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDestination.html
     *
     * @param destinationName - Identifier for the destinationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDestination(destinationName, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:Destination/${destinationName}`);
    }
    /**
     * Adds a resource of type SidewalkAccount to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateAwsAccountWithPartnerAccount.html
     *
     * @param sidewalkAccountId - Identifier for the sidewalkAccountId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSidewalkAccount(sidewalkAccountId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:SidewalkAccount/${sidewalkAccountId}`);
    }
    /**
     * Adds a resource of type WirelessGatewayTaskDefinition to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTaskDefinition.html
     *
     * @param wirelessGatewayTaskDefinitionId - Identifier for the wirelessGatewayTaskDefinitionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWirelessGatewayTaskDefinition(wirelessGatewayTaskDefinitionId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:WirelessGatewayTaskDefinition/${wirelessGatewayTaskDefinitionId}`);
    }
    /**
     * Adds a resource of type FuotaTask to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateFuotaTask.html
     *
     * @param fuotaTaskId - Identifier for the fuotaTaskId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFuotaTask(fuotaTaskId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:FuotaTask/${fuotaTaskId}`);
    }
    /**
     * Adds a resource of type MulticastGroup to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateMulticastGroup.html
     *
     * @param multicastGroupId - Identifier for the multicastGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMulticastGroup(multicastGroupId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:MulticastGroup/${multicastGroupId}`);
    }
    /**
     * Adds a resource of type NetworkAnalyzerConfiguration to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateNetworkAnalyzerConfiguration.html
     *
     * @param networkAnalyzerConfigurationName - Identifier for the networkAnalyzerConfigurationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkAnalyzerConfiguration(networkAnalyzerConfigurationName, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:NetworkAnalyzerConfiguration/${networkAnalyzerConfigurationName}`);
    }
    /**
     * Adds a resource of type thing to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onThing(thingName, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iot:${region || '*'}:${account || '*'}:thing/${thingName}`);
    }
    /**
     * Adds a resource of type cert to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html
     *
     * @param certificate - Identifier for the certificate.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCert(certificate, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iot:${region || '*'}:${account || '*'}:cert/${certificate}`);
    }
}
exports.Iotwireless = Iotwireless;
_a = JSII_RTTI_SYMBOL_1;
Iotwireless[_a] = { fqn: "iam-floyd.Iotwireless", version: "0.485.0" };
//# sourceMappingURL=data:application/json;base64,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