"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LicenseManagerUserSubscriptions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [license-manager-user-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslicensemanagerusersubscriptions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class LicenseManagerUserSubscriptions extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [license-manager-user-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslicensemanagerusersubscriptions.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'license-manager-user-subscriptions';
        this.accessLevelList = {
            Write: [
                'AssociateUser',
                'DeregisterIdentityProvider',
                'DisassociateUser',
                'RegisterIdentityProvider',
                'StartProductSubscription',
                'StopProductSubscription',
                'UpdateIdentityProviderSettings'
            ],
            List: [
                'ListIdentityProviders',
                'ListInstances',
                'ListProductSubscriptions',
                'ListUserAssociations'
            ]
        };
    }
    /**
     * Grants permission to associate a subscribed user to an instance launched with license manager user subscriptions products
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_AssociateUser.html
     */
    toAssociateUser() {
        return this.to('AssociateUser');
    }
    /**
     * Grants permission to deregister Microsoft Active Directory with license-manager-user-subscriptions for a product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_DeregisterIdentityProvider.html
     */
    toDeregisterIdentityProvider() {
        return this.to('DeregisterIdentityProvider');
    }
    /**
     * Grants permission to disassociate a subscribed user from an instance launched with license manager user subscriptions products
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_DisassociateUser.html
     */
    toDisassociateUser() {
        return this.to('DisassociateUser');
    }
    /**
     * Grants permission to list all the identity providers on license manager user subscriptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_ListIdentityProviders.html
     */
    toListIdentityProviders() {
        return this.to('ListIdentityProviders');
    }
    /**
     * Grants permission to list all the instances launched with license manager user subscription products
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_ListInstances.html
     */
    toListInstances() {
        return this.to('ListInstances');
    }
    /**
     * Grants permission to lists all the product subscriptions for a product and identity provider
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_ListProductSubscriptions.html
     */
    toListProductSubscriptions() {
        return this.to('ListProductSubscriptions');
    }
    /**
     * Grants permission to list all the users associated to an instance launched for a product
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_ListUserAssociations.html
     */
    toListUserAssociations() {
        return this.to('ListUserAssociations');
    }
    /**
     * Grants permission to registers Microsoft Active Directory with license-manager-user-subscriptions for a product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_RegisterIdentityProvider.html
     */
    toRegisterIdentityProvider() {
        return this.to('RegisterIdentityProvider');
    }
    /**
     * Grants permission to start product subscription for a user on a registered active directory for a product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_StartProductSubscription.html
     */
    toStartProductSubscription() {
        return this.to('StartProductSubscription');
    }
    /**
     * Grants permission to stop product subscription for a user on a registered active directory for a product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_StopProductSubscription.html
     */
    toStopProductSubscription() {
        return this.to('StopProductSubscription');
    }
    /**
     * Grants permission to update the identity provider configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_UpdateIdentityProviderSettings.html
     */
    toUpdateIdentityProviderSettings() {
        return this.to('UpdateIdentityProviderSettings');
    }
}
exports.LicenseManagerUserSubscriptions = LicenseManagerUserSubscriptions;
_a = JSII_RTTI_SYMBOL_1;
LicenseManagerUserSubscriptions[_a] = { fqn: "iam-floyd.LicenseManagerUserSubscriptions", version: "0.485.0" };
//# sourceMappingURL=data:application/json;base64,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