'''
# IAM Floyd

[![Source](https://img.shields.io/github/stars/udondan/iam-floyd?logo=github&label=GitHub%20Stars)](https://github.com/udondan/iam-floyd)
[![iam-floyd](https://img.shields.io/github/v/release/udondan/iam-floyd)](https://github.com/udondan/iam-floyd)
[![Mastodon](https://badgen.net/badge/Mastodon/iamfloyd@awscommunity.social/blue)](https://awscommunity.social/@iamfloyd)
[![libraries.io](https://img.shields.io/badge/packages-libraries.io-yellow)](https://libraries.io/search?q=iam-floyd)
[![Documentation](https://img.shields.io/badge/Documentation-Read%20the%20Docs-orange)](https://iam-floyd.readthedocs.io/en/latest/)
[![GitHub](https://img.shields.io/github/license/udondan/iam-floyd)](https://github.com/udondan/iam-floyd/blob/main/LICENSE)

<!-- put back - when we actually have tests
[![Test Coverage](https://api.codeclimate.com/v1/badges/cdb84b5646c6805b1a23/test_coverage)](https://codeclimate.com/github/udondan/iam-floyd/test_coverage)
-->

**AWS [IAM policy statement](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_statement.html) generator with fluent interface.**

<!-- stats -->

Support for:

* 352 Services
* 13948 Actions
* 1479 Resource Types
* 1469 Condition keys

<!-- /stats -->

![EXPERIMENTAL](https://img.shields.io/badge/stability-experimantal-orange?style=for-the-badge)**<br>This is an early version of the package. The API will change while I implement new features. Therefore make sure you use an exact version in your `package.json` before it reaches 1.0.0.**

## Documentation

Find the documentation at [Read the Docs](https://iam-floyd.readthedocs.io/en/latest/).

[![Auto completion demo](https://raw.githubusercontent.com/udondan/iam-floyd/main/docs/movie-preview.png)](https://www.youtube.com/watch?v=4dHY8qPHbKA)

## Packages

There are two different package variants available:

* **iam-floyd**: Can be used in AWS SDK, Boto 3 or for whatever you need an IAM policy statement for <br>[![npm](https://img.shields.io/npm/dt/iam-floyd?label=npm&color=blueviolet)](https://www.npmjs.com/package/iam-floyd)
  [![PyPI](https://img.shields.io/pypi/dm/iam-floyd?label=pypi&color=blueviolet)](https://pypi.org/project/iam-floyd/)
* **cdk-iam-floyd**: Integrates into [AWS CDK](https://aws.amazon.com/cdk/) and extends [`iam.PolicyStatement`](https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-iam.PolicyStatement.html)<br>[![npm](https://img.shields.io/npm/dt/cdk-iam-floyd?label=npm&color=orange)](https://www.npmjs.com/package/cdk-iam-floyd)
  [![PyPI](https://img.shields.io/pypi/dm/cdk-iam-floyd?label=pypi&color=orange)](https://pypi.org/project/cdk-iam-floyd/)

  **Starting with version 0.300.0, the packages are compatible with CDK v2.** For CDK v1 you can use any version up to:<br>
  [![npm CDK v1](https://img.shields.io/badge/npm-0.286.0-yellow)](https://www.npmjs.com/package/cdk-iam-floyd/v/0.286.0)
  [![PyPI CDK v1](https://img.shields.io/badge/pypi-0.286.0-yellow)](https://pypi.org/project/cdk-iam-floyd/0.286.0/)

  Find them all on [libraries.io](https://libraries.io/search?q=iam-floyd).

## CDK Compatibility Matrix

| CDK        | cdk-iam-floyd              |
| ---------- | -------------              |
| <= 1.151.0 | <= 0.285.0                 |
| >= 1.152.0 | 0.286.0                    |
| >= 1.158.0 | **No compatible version!** |
| >= 2.0.0   | >= 0.300.0                 |
| >= 2.20.0  | >= 0.351.0                 |
| >= 2.26.0  | >= 0.377.0                 |
| 2.29.x     | **No compatible version!** |
| >= 2.30.0  | >= 0.391.0                 |

---


## Legal

The code contained in the [lib/generated](https://github.com/udondan/iam-floyd/tree/main/lib/generated) folder is generated from the [AWS documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html). The class- and function-names and their description therefore are property of AWS.

AWS and their services are trademarks, registered trademarks or trade dress of AWS in the U.S. and/or other countries.

This project is not affiliated, funded, or in any way associated with AWS.

IAM Floyd is licensed under [Apache License 2.0](https://github.com/udondan/iam-floyd/blob/main/LICENSE). Dependencies might be released under different licenses. Especially the bundled packages [regex-parser](https://www.npmjs.com/package/regex-parser) and [common-substrings](https://www.npmjs.com/package/common-substrings) are released under the MIT License.
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *


@jsii.data_type(
    jsii_type="iam-floyd.AccessLevelList",
    jsii_struct_bases=[],
    name_mapping={},
)
class AccessLevelList:
    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        self._values: typing.Dict[builtins.str, typing.Any] = {}

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AccessLevelList(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Collection(metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Collection"):
    '''
    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="allowEc2InstanceDeleteByOwner")
    def allow_ec2_instance_delete_by_owner(self) -> typing.List["Ec2"]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List["Ec2"], jsii.invoke(self, "allowEc2InstanceDeleteByOwner", []))


@jsii.data_type(
    jsii_type="iam-floyd.Conditions",
    jsii_struct_bases=[],
    name_mapping={},
)
class Conditions:
    def __init__(self) -> None:
        '''(experimental) A collection of Condition's.

        :stability: experimental
        '''
        self._values: typing.Dict[builtins.str, typing.Any] = {}

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Conditions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="iam-floyd.Effect")
class Effect(enum.Enum):
    '''(experimental) Policy effects.

    :stability: experimental
    '''

    ALLOW = "ALLOW"
    '''
    :stability: experimental
    '''
    DENY = "DENY"
    '''
    :stability: experimental
    '''


class Operator(metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Operator"):
    '''(experimental) Use condition operators in the ``Condition`` element to match the condition key and value in the policy against values in the request context.

    For more information about the ``Condition`` element, see `IAM JSON Policy Elements: Condition <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html>`_.

    The condition operator that you can use in a policy depends on the condition key you choose. You can choose a global condition key or a service-specific condition key. To learn which condition operator you can use for a global condition key, see `AWS Global Condition Context Keys <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html>`_. To learn which condition operator you can use for a service-specific condition key, see `Actions, Resources, and Condition Keys for AWS Services <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html>`_ and choose the service that you want to view.

    https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="arnEquals")
    def arn_equals(self) -> "Operator":
        '''(experimental) Match of the ARN, case sensitive.

        Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``).

        ``ArnEquals`` and ``ArnLike`` behave identical.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "arnEquals", []))

    @jsii.member(jsii_name="arnLike")
    def arn_like(self) -> "Operator":
        '''(experimental) Match of the ARN, case sensitive.

        Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``).

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "arnLike", []))

    @jsii.member(jsii_name="arnNotEquals")
    def arn_not_equals(self) -> "Operator":
        '''(experimental) Negated match of the ARN, case sensitive.

        Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``).

        ``ArnNotEquals`` and ``ArnNotLike`` behave identical.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "arnNotEquals", []))

    @jsii.member(jsii_name="arnNotLike")
    def arn_not_like(self) -> "Operator":
        '''(experimental) Negated match of the ARN, case sensitive.

        Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``).

        ``ArnNotEquals`` and ``ArnNotLike`` behave identical.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "arnNotLike", []))

    @jsii.member(jsii_name="binaryEquals")
    def binary_equals(self) -> "Operator":
        '''(experimental) The BinaryEquals condition operator lets you construct Condition elements that test key values that are in binary format.

        It compares the value of the specified key byte for byte against a `base-64 <https://en.wikipedia.org/wiki/Base64>`_ encoded representation of the binary value in the policy.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "binaryEquals", []))

    @jsii.member(jsii_name="bool")
    def bool(self) -> "Operator":
        '''(experimental) Boolean match.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "bool", []))

    @jsii.member(jsii_name="dateEquals")
    def date_equals(self) -> "Operator":
        '''(experimental) Match a specific date: ``=``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "dateEquals", []))

    @jsii.member(jsii_name="dateGreaterThan")
    def date_greater_than(self) -> "Operator":
        '''(experimental) Match after a specific a date and time: ``>``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "dateGreaterThan", []))

    @jsii.member(jsii_name="dateGreaterThanEquals")
    def date_greater_than_equals(self) -> "Operator":
        '''(experimental) Match at or after a specific date and time: ``>=``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "dateGreaterThanEquals", []))

    @jsii.member(jsii_name="dateLessThan")
    def date_less_than(self) -> "Operator":
        '''(experimental) Match before a specific date and time: ``<``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "dateLessThan", []))

    @jsii.member(jsii_name="dateLessThanEquals")
    def date_less_than_equals(self) -> "Operator":
        '''(experimental) Match at or before a specific date and time: ``<=``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "dateLessThanEquals", []))

    @jsii.member(jsii_name="dateNotEquals")
    def date_not_equals(self) -> "Operator":
        '''(experimental) Negated match for a specific date: ``!=``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "dateNotEquals", []))

    @jsii.member(jsii_name="forAllValues")
    def for_all_values(self) -> "Operator":
        '''(experimental) Tests whether the value of every member of the request set is a subset of the condition key set.

        The condition returns true if every key value in the request matches at least one value in the policy. It also returns true if there are no keys in the request, or if the key values resolve to a null data set, such as an empty string.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "forAllValues", []))

    @jsii.member(jsii_name="forAnyValue")
    def for_any_value(self) -> "Operator":
        '''(experimental) Tests whether at least one member of the set of request values matches at least one member of the set of condition key values.

        The condition returns true if any one of the key values in the request matches any one of the condition values in the policy. For no matching key or a null dataset, the condition returns false.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "forAnyValue", []))

    @jsii.member(jsii_name="ifExists")
    def if_exists(self) -> "Operator":
        '''(experimental) You can add ``IfExists`` to the end of any condition operator name except the ``Null`` condition.

        For example, ``StringLikeIfExists``. You do this to say "If the policy key is present in the context of the request, process the key as specified in the policy. If the key is not present, evaluate the condition element as true." Other condition elements in the statement can still result in a nonmatch, but not a missing key when checked with ``...IfExists``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "ifExists", []))

    @jsii.member(jsii_name="ipAddress")
    def ip_address(self) -> "Operator":
        '''(experimental) Match an IP address or range: ``=``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "ipAddress", []))

    @jsii.member(jsii_name="notIpAddress")
    def not_ip_address(self) -> "Operator":
        '''(experimental) All IP addresses except the specified IP address or range ``!=``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "notIpAddress", []))

    @jsii.member(jsii_name="null")
    def null(self) -> "Operator":
        '''(experimental) Check if a key is present at the time of authorization.

        In the policy statement, use either true (the key doesn't exist — it is null) or false (the key exists and its value is not null).

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "null", []))

    @jsii.member(jsii_name="numericEquals")
    def numeric_equals(self) -> "Operator":
        '''(experimental) Exact match.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "numericEquals", []))

    @jsii.member(jsii_name="numericGreaterThan")
    def numeric_greater_than(self) -> "Operator":
        '''(experimental) Match numbers higher than value: ``>``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "numericGreaterThan", []))

    @jsii.member(jsii_name="numericGreaterThanEquals")
    def numeric_greater_than_equals(self) -> "Operator":
        '''(experimental) Match numbers higher or equal value: ``>=``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "numericGreaterThanEquals", []))

    @jsii.member(jsii_name="numericLessThan")
    def numeric_less_than(self) -> "Operator":
        '''(experimental) Match numbers lower than value: ``<``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "numericLessThan", []))

    @jsii.member(jsii_name="numericLessThanEquals")
    def numeric_less_than_equals(self) -> "Operator":
        '''(experimental) Match numbers lower or equal to value: ``<=``.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "numericLessThanEquals", []))

    @jsii.member(jsii_name="numericNotEquals")
    def numeric_not_equals(self) -> "Operator":
        '''(experimental) Negated exact match.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "numericNotEquals", []))

    @jsii.member(jsii_name="stringEquals")
    def string_equals(self) -> "Operator":
        '''(experimental) Exact match, case sensitive.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "stringEquals", []))

    @jsii.member(jsii_name="stringEqualsIgnoreCase")
    def string_equals_ignore_case(self) -> "Operator":
        '''(experimental) Exact match, ignore case.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "stringEqualsIgnoreCase", []))

    @jsii.member(jsii_name="stringLike")
    def string_like(self) -> "Operator":
        '''(experimental) Case-sensitive match.

        The values can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``) anywhere in the string.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "stringLike", []))

    @jsii.member(jsii_name="stringNotEquals")
    def string_not_equals(self) -> "Operator":
        '''(experimental) Negated exact match, case sensitive.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "stringNotEquals", []))

    @jsii.member(jsii_name="stringNotEqualsIgnoreCase")
    def string_not_equals_ignore_case(self) -> "Operator":
        '''(experimental) Exact exact match, ignore case.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "stringNotEqualsIgnoreCase", []))

    @jsii.member(jsii_name="stringNotLike")
    def string_not_like(self) -> "Operator":
        '''(experimental) Negated case-sensitive matching.

        The values can include a multi-character match wildcard (``*``) or a single-character match wildcard (``?``) anywhere in the string.

        :stability: experimental
        '''
        return typing.cast("Operator", jsii.invoke(self, "stringNotLike", []))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))


class PolicyStatementBase(
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementBase",
):
    '''(experimental) Base class for the Policy Statement.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''
        :param sid: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__72d37775c42581cdbb670fd68b7157d8318000dbfa4394e5d115eb6834d7e5e1)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        '''(experimental) JSON-ify the policy statement.

        Used when JSON.stringify() is called

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toJSON", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="defaultPartition")
    def DEFAULT_PARTITION(cls) -> builtins.str:
        '''(experimental) The default partition for ARNs (such as one of [aws, aws-us-gov, aws-cn]).

        In
        CDK applications, this is a reference to the current partition, otherwise, 'aws'.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "defaultPartition"))

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4142de54e87055936d594b8dbdb0981ee88ec5912bbdb2b62595d24464705d6d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)

    @builtins.property
    @jsii.member(jsii_name="sid")
    def sid(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "sid"))

    @sid.setter
    def sid(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__182d7f96c5a7e153de558514fc854a34b0fa0ab607426a14d00e60bc309ed64e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "sid", value)


class PolicyStatementWithCondition(
    PolicyStatementBase,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementWithCondition",
):
    '''(experimental) Adds "condition" functionality to the Policy Statement.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''
        :param sid: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e2b547f6cec706e0492b2d84c3e2a59b5c7e6e266c223abca5022d896b6d45ab)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="freeze")
    def freeze(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "freeze", []))

    @jsii.member(jsii_name="hasConditions")
    def has_conditions(self) -> builtins.bool:
        '''(experimental) Checks weather a condition was applied to the policy.

        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.invoke(self, "hasConditions", []))

    @jsii.member(jsii_name="if")
    def if_(
        self,
        key: builtins.str,
        value: typing.Any,
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Adds a condition to the statement.

        :param key: The key of the condition.
        :param value: The value(s) to check for.
        :param operator: `Operator <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html>`_ of the condition. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f869ce9e35996c3eab103799b2e032789f86ae7f0fca53de5044fbbbdc995c36)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "if", [key, value, operator]))

    @jsii.member(jsii_name="ifAwsCalledVia")
    def if_aws_called_via(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the services with the services that made requests on behalf of the IAM principal (user or role).

        When a principal makes a request to an AWS service, that service might use the principal's credentials to make subsequent requests to other services.

        The ``aws:CalledVia`` key contains an ordered list of each service in the chain that made requests on the principal's behalf.

        **Availability:** This key is present in the request when a service that supports aws:CalledVia uses the credentials of an IAM principal to make a request to another service. This key is not present if the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf. This key is also not present when the principal makes the call directly.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-calledvia

        :param value: The service(s) to check for.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``ForAnyValue:StringEquals``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__92877fa5ca833dff290c39fc6287324425022283060b299d280fe90639ea08b7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsCalledVia", [value, operator]))

    @jsii.member(jsii_name="ifAwsCalledViaFirst")
    def if_aws_called_via_first(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the services with the first service that made a request on behalf of the IAM principal (user or role).

        For more information, see `aws:CalledVia <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-calledvia>`_.

        **Availability:** This key is present in the request when a service that supports aws:CalledVia uses the credentials of an IAM principal to make a request to another service. This key is not present if the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf. This key is also not present when the principal makes the call directly.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-calledviafirst

        :param value: The service(s) to check for.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eaf39c85f2af81b764537224bdc27b53b6b7eb05ee0c6a2d7816d86eba47e18c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsCalledViaFirst", [value, operator]))

    @jsii.member(jsii_name="ifAwsCalledViaLast")
    def if_aws_called_via_last(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the services with the last service that made a request on behalf of the IAM principal (user or role).

        For more information, see `aws:CalledVia <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-calledvia>`_.

        **Availability:** This key is present in the request when a service that supports aws:CalledVia uses the credentials of an IAM principal to make a request to another service. This key is not present if the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf. This key is also not present when the principal makes the call directly.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-calledvialast

        :param value: The service(s) to check for.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7fe33c2e7fb3c3fd22d15722d5ce596f6b2601c1d5e002406a7a6a09c40b6ce)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsCalledViaLast", [value, operator]))

    @jsii.member(jsii_name="ifAwsCurrentTime")
    def if_aws_current_time(
        self,
        value: typing.Union[builtins.str, datetime.datetime, typing.Sequence[typing.Union[builtins.str, datetime.datetime]]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the date and time of the request with the date and time that you specify.

        To view an example policy that uses this condition key, see `AWS: Allows Access Within Specific Dates <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_examples_aws-dates.html>`_.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-currenttime

        :param value: The date and time to check for. Can be a string in one of the `W3C implementations of the ISO 8601 date <https://www.w3.org/TR/NOTE-datetime>`_ (e.g. ``2020-04-01T00:00:00Z``) or in epoch (UNIX) time or a ``Date()`` object (JavaScript only)
        :param operator: Works with `date operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Date>`_. **Default:** ``DateLessThanEquals``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ad874f1f9d0783c902570b6b453a20a6db9c31a395ef6c6f602e3671ca279fc6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsCurrentTime", [value, operator]))

    @jsii.member(jsii_name="ifAwsEpochTime")
    def if_aws_epoch_time(
        self,
        value: typing.Union[builtins.str, jsii.Number, datetime.datetime, typing.Sequence[typing.Union[builtins.str, jsii.Number, datetime.datetime]]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the date and time of the request in epoch or Unix time with the value that you specify.

        This key also accepts the number of seconds since January 1, 1970.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-epochtime

        :param value: The date and time to check for. Can be a string in one of the `W3C implementations of the ISO 8601 date <https://www.w3.org/TR/NOTE-datetime>`_ (e.g. ``2020-04-01T00:00:00Z``) or in epoch (UNIX) time or a ``Date()`` object (JavaScript only)
        :param operator: Works with `date <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Date>`_ and `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``DateLessThanEquals``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6df58998c25fe88b23c9591832eb9bf231dd2e9c2941198bdbc8a1be5d6fb8cd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsEpochTime", [value, operator]))

    @jsii.member(jsii_name="ifAwsMultiFactorAuthAge")
    def if_aws_multi_factor_auth_age(
        self,
        value: typing.Union[jsii.Number, typing.Sequence[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the number of seconds since the requesting principal was authorized using MFA with the number that you specify.

        For more information about MFA, see `Using Multi-Factor Authentication (MFA) in AWS <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa.html>`_.

        **Availability:** This key is included in the request context only if the principal was authenticated using MFA. If MFA was not used, this key is not present.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-multifactorauthage

        :param value: Number of seconds.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericLessThan``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__04a0c7ee05c314ea9c0e46853f4c0ff61b41601c4a8ca24f9d6593c4a0625359)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsMultiFactorAuthAge", [value, operator]))

    @jsii.member(jsii_name="ifAwsMultiFactorAuthPresent")
    def if_aws_multi_factor_auth_present(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Check whether multi-factor authentication (MFA) was used to validate the temporary security credentials that made the request.

        **Availability:** This key is included in the request context only when the principal uses temporary credentials to make the request. The key is not present in AWS CLI, AWS API, or AWS SDK requests that are made using long-term credentials.

        Temporary credentials are used to authenticate IAM roles, federated users, IAM users with temporary tokens from ``sts:GetSessionToken``, and users of the AWS Management Console. IAM users in the AWS Management Console unknowingly use temporary credentials. Users sign into the console using their user name and password, which are long-term credentials. However, in the background, the console generates temporary credentials on behalf of the user. To learn which services support using temporary credentials, see `AWS Services That Work with IAM <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html>`_.

        The ``aws:MultiFactorAuthPresent`` key is not present when an API or CLI command is called with long-term credentials, such as user access key pairs. Therefore we recommend that when you check for this key that you use the `...IfExists <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_IfExists>`_ versions of the condition operators.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-multifactorauthpresent

        :param value: Weather the MFA should be present or absent. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__91973e1fda06329f6c5c65a85fe4fa1c18c2cceef60940a73c75748aa7037e9a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsMultiFactorAuthPresent", [value]))

    @jsii.member(jsii_name="ifAwsPrincipalAccount")
    def if_aws_principal_account(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the account to which the requesting principal belongs with the account identifier that you specify.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalaccount

        :param value: Account identifier(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1cb0683c53cc71b6f4ba8cf3556245efa880c21db413846110499f17878d04a7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsPrincipalAccount", [value, operator]))

    @jsii.member(jsii_name="ifAwsPrincipalArn")
    def if_aws_principal_arn(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the `Amazon Resource Name <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns>`_ (ARN) of the principal that made the request with the ARN that you specify.

        For IAM roles, the request context returns the ARN of the role, not the ARN of the user that assumed the role. To learn which types of principals you can specify in this condition key, see `Specifying a Principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying>`_.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalarn

        :param value: Principle ARN(s).
        :param operator: Works with `ARN operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_ and `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``ArnLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c886ae886d3725fae853f688db984847230ab912e415988123b0afbf06017e7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsPrincipalArn", [value, operator]))

    @jsii.member(jsii_name="ifAwsPrincipalIsAWSService")
    def if_aws_principal_is_aws_service(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Check whether the call to your resource is being made directly by an AWS `service principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services>`_. For example, AWS CloudTrail uses the service principal ``cloudtrail.amazonaws.com`` to write logs to your Amazon S3 bucket. The request context key is set to true when a service uses a service principal to perform a direct action on your resources. The context key is set to false if the service uses the credentials of an IAM principal to make a request on the principal's behalf. It is also set to false if the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf.

        **Availability:** This key is present in the request context for all signed API requests that use AWS credentials.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalisawsservice

        :param value: Weather the call to your resource is being made directly by an AWS service principal. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e4cb513803791882cb775de121cc7542289b474eaa4b1d45b41e6e85f7046cf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsPrincipalIsAWSService", [value]))

    @jsii.member(jsii_name="ifAwsPrincipalOrgID")
    def if_aws_principal_org_id(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the identifier of the organization in AWS Organizations to which the requesting principal belongs with the identifier you specify.

        **Availability:** This key is included in the request context only if the principal is a member of an organization.

        This global key provides an alternative to listing all the account IDs for all AWS accounts in an organization. You can use this condition key to simplify specifying the ``Principal`` element in a resource-based policy. You can specify the organization ID in the condition element. When you add and remove accounts, policies that include the ``aws:PrincipalOrgID`` key automatically include the correct accounts and don't require manual updating.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalorgid

        :param value: Organization ID(s) in format ``o-xxxxxxxxxxx``.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a14ef324ec25bb000cc61c92f34edff4fa6e68e248fcad3fc600bf916f69ec7c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsPrincipalOrgID", [value, operator]))

    @jsii.member(jsii_name="ifAwsPrincipalOrgPaths")
    def if_aws_principal_org_paths(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the AWS Organizations path for the principal who is making the request to the path you provide.

        That principal can be an IAM user, IAM role, federated user, or AWS account root user.

        This condition ensures that the requester is an account member within the specified organization root or organizational units (OUs) in AWS Organizations. An AWS Organizations path is a text representation of the structure of an Organizations entity. For more information about using and understanding paths, see Understand the `AWS Organizations Entity Path <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor-view-data-orgs.html#access_policies_access-advisor-viewing-orgs-entity-path>`_.

        **Availability:** This key is included in the request context only if the principal is a member of an organization.

        **Note:** Organization IDs are globally unique but OU IDs and root IDs are unique only within an organization. This means that no two organizations share the same organization ID. However, another organization might have an OU or root with the same ID as yours. We recommend that you always include the organization ID when you specify an OU or root.

        ``aws:PrincipalOrgPaths`` is a multivalued condition key. Multivalued keys include one or more values in a list format. The result is a logical ``OR``. When you use multiple values with the ``ForAnyValue:`` condition operator, the principal's path must match one of the paths provided. For policies that include multiple values for a single key, you must enclose the conditions within brackets like an array (``"Key":["Value1", "Value2"]``). You should also include these brackets when there is a single value. For more information about multivalued condition keys, see `Creating a Condition with Multiple Keys or Values <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_multi-value-conditions.html>`_.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalorgpaths

        :param value: Organization path(s) in the format of ``o-xxxxxxxxxxx/r-xxxxxxxxxx/ou-xxxx-xxxxxxxx/ou-xxxx-xxxxxxxx/``.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringEquals``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__951bfd260e8386e5e0f7fc828f074a10c32515575fcaa11ceaedd6b989a9be45)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsPrincipalOrgPaths", [value, operator]))

    @jsii.member(jsii_name="ifAwsPrincipalServiceName")
    def if_aws_principal_service_name(
        self,
        value: builtins.str,
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the `service principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services>`_ name in the policy with the service principal that is making requests to your resources. You can use this key to check whether this call is made by a specific service principal. When a service principal makes a direct request to your resource, the ``aws:PrincipalServiceName`` key contains the name of the service principal. For example, the AWS CloudTrail service principal name is ``cloudtrail.amazonaws.com``.

        **Availability:** This key is present in the request when the call is made by an AWS service principal. This key is not present in any other situation, including the following:

        - If the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf.
        - If the service uses the credentials of an IAM principal to make a request on the principal's behalf.
        - If the call is made directly by an IAM principal.

        You can use this condition key to limit access to your trusted identities and expected network locations, while safely granting access to an AWS service.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalservicename

        :param value: AWS service name, e.g. ``cloudtrail.amazonaws.com``.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b6188068715614948a82ee9db6a69e469e37780b6028885ef8302dda0e0d2079)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsPrincipalServiceName", [value, operator]))

    @jsii.member(jsii_name="ifAwsPrincipalServiceNamesList")
    def if_aws_principal_service_names_list(
        self,
        value: typing.Sequence[builtins.str],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) This key provides a list of all `service principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services>`_ names that belong to the service. This is an advanced condition key. You can use it to restrict the service from accessing your resource from a specific Region only. Some services may create Regional service principals to indicate a particular instance of the service within a specific Region. You can limit access to a resource to a particular instance of the service. When a service principal makes a direct request to your resource, the ``aws:PrincipalServiceNamesList`` contains an unordered list of all service principal names associated with the Regional instance of the service.

        **Availability:** This key is present in the request when the call is made by an AWS service principal. This key is not present in any other situation, including the following:

        - If the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf.
        - If the service uses the credentials of an IAM principal to make a request on the principal's behalf.
        - If the call is made directly by an IAM principal.

        ``aws:PrincipalServiceNamesList`` is a multivalued condition key. Multivalued keys include one or more values in a list format. The result is a logical ``OR``. You must use the ``ForAnyValue`` or ``ForAllValues`` set operators with the ``StringLike`` `condition operator <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_ when you use this key. For policies that include multiple values for a single key, you must enclose the conditions within brackets like an array, such as ``("Key":["Value1", "Value2"])``. You should also include these brackets when there is a single value. For more information about multivalued condition keys, see `Using multiple keys and values <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_multi-value-conditions.html#reference_policies_multi-key-or-value-conditions>`_.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalservicenameslist

        :param value: AWS service name list.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``ForAnyValue:StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ac8258373923b2923766e5c412c7cf0643549db886d63ef9c4e9ecccf0b31fdb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsPrincipalServiceNamesList", [value, operator]))

    @jsii.member(jsii_name="ifAwsPrincipalTag")
    def if_aws_principal_tag(
        self,
        key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the tag attached to the principal making the request with the tag that you specify.

        If the principal has more than one tag attached, the request context includes one aws:PrincipalTag key for each attached tag key.

        **Availability:** This key is included in the request context if the principal is using an IAM user with attached tags. It is included for a principal using an IAM role with attached tags or `session tags <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html>`_.

        You can add custom attributes to a user or role in the form of a key-value pair. For more information about IAM tags, see `Tagging IAM Users and Roles <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html>`_. You can use ``aws:PrincipalTag`` to `control access <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html#access_iam-tags_control-resources>`_ for AWS principals.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principaltag

        :param key: The tag key to check.
        :param value: The tag value(s) to check against.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__67808cdafa295eb10f078c24f43054eba2f5cabab0a5cd0cd089ce976f16a405)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsPrincipalTag", [key, value, operator]))

    @jsii.member(jsii_name="ifAwsPrincipalType")
    def if_aws_principal_type(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the type of principal making the request with the principal type that you specify.

        For details about how the information appears in the request context for different principals, see `Specifying a Principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying>`_.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principaltype

        :param value: The principal type(s). Any of ``Account``, ``User``, ``FederatedUser``, ``AssumedRole``, ``Anonymous``
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringEquals``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2f1f303a488b7caa7d1592314e1b5af8f4ec07ea31fa0ede2bbdd3f079c4309)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsPrincipalType", [value, operator]))

    @jsii.member(jsii_name="ifAwsReferer")
    def if_aws_referer(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare who referred the request in the client browser with the referer that you specify.

        The ``aws:referer`` request context value is provided by the caller in an HTTP header.

        **Availability:** This key is included in the request context only if the request was invoked using a URL in the browser.

        For example, you can call `Amazon S3 API operations directly using a web browser <https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-4>`_. This means that you can view S3 objects, such as images and documents, directly through a web browser. The ``aws:referer`` condition allows you to restrict access to specific values in the HTTP or HTTPS request based on the value of the referrer header.

        **Warning:** This condition should be used carefully. It is dangerous to include a publicly known referer header value. Unauthorized parties can use modified or custom browsers to provide any ``aws:referer`` value that they choose. As a result, ``aws:referer`` should not be used to prevent unauthorized parties from making direct AWS requests. It is offered only to allow customers to protect their digital content, such as content stored in Amazon S3, from being referenced on unauthorized third-party sites.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-referer

        :param value: The referer url(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c814044424dc09802ab8a20e1b196186835511c3f7689b71cd873c3a79900b2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsReferer", [value, operator]))

    @jsii.member(jsii_name="ifAwsRequestedRegion")
    def if_aws_requested_region(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the AWS Region that was called in the request with the Region that you specify.

        You can use this global condition key to control which Regions can be requested. To view the AWS Regions for each service, see `Service endpoints and quotas <https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html>`_ in the Amazon Web Services General Reference.

        **Availability:** This key is always included in the request context.

        Some global services, such as IAM, have a single endpoint. Because this endpoint is physically located in the US East (N. Virginia) Region, IAM calls are always made to the us-east-1 Region. For example, if you create a policy that denies access to all services if the requested Region is not us-west-2, then IAM calls always fail. To view an example of how to work around this, see `NotAction with Deny <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html>`_.

        **Note:** The ``aws:RequestedRegion`` condition key allows you to control which endpoint of a service is invoked but does not control the impact of the operation. Some services have cross-Region impacts. For example, Amazon S3 has API operations that control cross-Region replication. You can invoke ``s3:PutBucketReplication`` in one Region (which is affected by the ``aws:RequestedRegion`` condition key), but other Regions are affected based on the replications configuration settings.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requestedregion

        :param value: The region(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringEquals``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fa825264744a110a82c5dc1c66b258a8e9133ce01b5d7aec53ad0f8ade6d5afc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsRequestedRegion", [value, operator]))

    @jsii.member(jsii_name="ifAwsRequestTag")
    def if_aws_request_tag(
        self,
        key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the tag key-value pair that was passed in the request with the tag pair that you specify.

        For example, you could check whether the request includes the tag key ``Dept`` and that it has the value ``Accounting``. For more information, see `Controlling Access During AWS Requests <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html#access_tags_control-requests>`_.

        **Availability:** This key is included in the request context when tags are passed in the request. When multiple tags are passed in the request, there is one context key for each tag key-value pair.

        Because you can include multiple tag key-value pairs in a request, the request content could be a multivalued request. In this case, you should consider using the ``ForAllValues`` or ``ForAnyValue`` set operators. For more information, see `Using Multiple Keys and Values <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_multi-value-conditions.html#reference_policies_multi-key-or-value-conditions>`_.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag

        :param key: The tag key to check.
        :param value: The tag value(s) to check against.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d5b81ad2b642de83d2311aca2dc2036d8e29d647786967a04cc3a20217b68e46)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsRequestTag", [key, value, operator]))

    @jsii.member(jsii_name="ifAwsResourceTag")
    def if_aws_resource_tag(
        self,
        key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the tag key-value pair that you specify with the key-value pair that is attached to the resource.

        For example, you could require that access to a resource is allowed only if the resource has the attached tag key ``Dept`` with the value ``Marketing``. For more information, see `Controlling Access to AWS Resources <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html#access_tags_control-resources>`_.

        **Availability:** This key is included in the request context when the requested resource already has attached tags. This key is returned only for resources that `support authorization based on tags <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html>`_. There is one context key for each tag key-value pair.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag

        :param key: The tag key to check.
        :param value: The tag value(s) to check against.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__141746fd17b652e11b2c73b6317d24ae7d324a9901b14fce43386d64f7707c54)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsResourceTag", [key, value, operator]))

    @jsii.member(jsii_name="ifAwsSecureTransport")
    def if_aws_secure_transport(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Check whether the request was sent using SSL.

        The request context returns ``true`` or ``false``. In a policy, you can allow specific actions only if the request is sent using SSL.

        **Availability:** This key is always included in the request context.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-securetransport

        :param value: Weather request was sent using SSL. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f55d5a2e4666b33d273577cd0f5db4493133bf556a3d9ec173cf432b664a5548)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsSecureTransport", [value]))

    @jsii.member(jsii_name="ifAwsSourceAccount")
    def if_aws_source_account(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the account ID of the resource making a service-to-service request with the account ID that you specify.

        **Availability:** This key is included in the request context only if accessing a resource triggers an AWS service to call another service on behalf of the resource owner. The calling service must pass the resource ARN of the source to the called service. This ARN includes the source account ID.

        You can use this condition key to check that Amazon S3 is not being used as a `confused deputy <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html#confused-deputy>`_. For example, when an Amazon S3 bucket update triggers an Amazon SNS topic post, the Amazon S3 service invokes the ``sns:Publish`` API operation. The bucket is considered the source of the SNS request and the value of the key is the account ID from the bucket's ARN.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount

        :param value: The account ID(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4eaa633410511f81090082df61a822592a05855c120fc21292c8380c73fa7f74)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsSourceAccount", [value, operator]))

    @jsii.member(jsii_name="ifAwsSourceArn")
    def if_aws_source_arn(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the `Amazon Resource Name (ARN) <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns>`_ of the resource making a service-to-service request with the ARN that you specify.

        This key does not work with the ARN of the principal making the request. Instead, use `aws:PrincipalArn <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-principalarn>`_. The source's ARN includes the account ID, so it is not necessary to use ``aws:SourceAccount`` with ``aws:SourceArn``.

        **Availability:** This key is included in the request context only if accessing a resource triggers an AWS service to call another service on behalf of the resource owner. The calling service must pass the ARN of the original resource to the called service.

        You can use this condition key to check that Amazon S3 is not being used as a `confused deputy <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html#confused-deputy>`_. For example, when an Amazon S3 bucket update triggers an Amazon SNS topic post, the Amazon S3 service invokes the ``sns:Publish`` API operation. The bucket is considered the source of the SNS request and the value of the key is the bucket's ARN.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn

        :param value: The source ARN(s).
        :param operator: Works with `ARN operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_ and `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``ArnLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bacc036d62f9cef7c873de6b00f5215910e3ff72382d19d601eb6f2b5dced128)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsSourceArn", [value, operator]))

    @jsii.member(jsii_name="ifAwsSourceIdentity")
    def if_aws_source_identity(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the source identity that was set by the principal with the source identity that you specify in the policy.

        **Availability:** This key is included in the request context after a source identity has been set when a role is assumed using any AWS STS assume-role CLI command, or AWS STS ``AssumeRole`` API operation.

        You can use this key in a policy to allow actions in AWS by principals that have set a source identity when assuming a role. Activity for the role's specified source identity appears in `AWS CloudTrail <https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html#cloudtrail-integration_signin-tempcreds>`_. This makes it easier for administrators to determine who or what performed actions with a role in AWS.

        Unlike `sts:RoleSessionName <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_rolesessionname>`_, after the source identity is set, the value cannot be changed. It is present in the request context for all actions taken by the role. The value persists into subsequent role sessions when you use the session credentials to assume another role. Assuming one role from another is called `role chaining <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-role-chaining>`_.

        The `sts:SourceIdentity <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_sourceidentity>`_ key is present in the request when the principal initially sets a source identity while assuming a role using any AWS STS assume-role CLI command, or AWS STS ``AssumeRole`` API operation. The ``aws:SourceIdentity`` key is present in the request for any actions that are taken with a role session that has a source identity set.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceidentity

        :param value: The source identity.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d407ee32015418e0e247b4105dd5ace34e3c830908739f643df3ee9b2c195f92)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsSourceIdentity", [value, operator]))

    @jsii.member(jsii_name="ifAwsSourceIp")
    def if_aws_source_ip(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the requester's IP address with the IP address that you specify.

        **Availability:** This key is included in the request context, except when the requester uses a VPC endpoint to make the request.

        The ``aws:SourceIp`` condition key can be used in a policy to allow principals to make requests only from within a specified IP range. However, this policy denies access if an AWS service makes calls on the principal's behalf. In this case, you can use ``aws:SourceIp`` with the `aws:ViaAWSService <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-viaawsservice>`_ key to ensure that the source IP restriction applies only to requests made directly by a principal.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceip

        :param value: The source IP(s).
        :param operator: Works with IP `address operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_IPAddress>`_. **Default:** ``IpAddress``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9584d23ab9608164ec626e741c1effc7ee2eeb752ddba7ce565b34199c49a376)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsSourceIp", [value, operator]))

    @jsii.member(jsii_name="ifAwsSourceVpc")
    def if_aws_source_vpc(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Check whether the request comes from the VPC that you specify.

        In a policy, you can use this condition to allow access to only a specific VPC. For more information, see `Restricting Access to a Specific VPC <https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies-vpc-endpoint.html#example-bucket-policies-restrict-access-vpc>`_ in the *Amazon Simple Storage Service Developer Guide*.

        **Availability:** This key is included in the request context only if the requester uses a VPC endpoint to make the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcevpc

        :param value: The VPS ID(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringEquals``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__26040638818240caee8d929c92f7c94c436e1cfd2db5e6b5b64c61576b83b659)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsSourceVpc", [value, operator]))

    @jsii.member(jsii_name="ifAwsSourceVpce")
    def if_aws_source_vpce(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the VPC endpoint identifier of the request with the endpoint ID that you specify.

        In a policy, you can use this condition to restrict access to a specific VPC endpoint. For more information, see `Restricting Access to a Specific VPC Endpoint <https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies-vpc-endpoint.html#example-bucket-policies-restrict-access-vpc-endpoint>`_ in the *Amazon Simple Storage Service Developer Guide*.

        **Availability:** This key is included in the request context only if the requester uses a VPC endpoint to make the request.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcevpce

        :param value: The VPC Endpoint ID(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ef8327bfdcd66662814c5334ae63d21ea2df82a97692d188933d79f329866dc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsSourceVpce", [value, operator]))

    @jsii.member(jsii_name="ifAwsTagKeys")
    def if_aws_tag_keys(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the tag keys in a request with the keys that you specify.

        As a best practice when you use policies to control access using tags, use the ``aws:TagKeys`` condition key to define what tag keys are allowed. For example policies and more information, see `Controlling Access Based on Tag Keys <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html#access_tags_control-tag-keys>`_.

        **Availability:** This key is included in the request context only if the operation supports attaching tags to resources.

        Because you can include multiple tag key-value pairs in a request, the request content could be a `multivalued <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_multi-value-conditions.html>`_ request. In this case, you should consider using the ``ForAllValues`` or ``ForAnyValue`` set operators. For more information, see Using Multiple Keys and Values.

        Some services support tagging with resource operations, such as creating, modifying, or deleting a resource. To allow tagging and operations as a single call, you must create a policy that includes both the tagging action and the resource-modifying action. You can then use the ``aws:TagKeys`` condition key to enforce using specific tag keys in the request. For example, to limit tags when someone creates an Amazon EC2 snapshot, you must include the ``ec2:CreateSnapshot`` creation action ***and*** the ``ec2:CreateTags`` tagging action in the policy. To view a policy for this scenario that uses ``aws:TagKeys``, see `Creating a Snapshot with Tags <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ExamplePolicies_EC2.html#iam-creating-snapshot-with-tags>`_ in the *Amazon EC2 User Guide for Linux Instances*.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys

        :param value: The tag key(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d95392644fec828e1cc941d232f83bca7047bcc3a3e82f3b058a536fa86bea41)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsTagKeys", [value, operator]))

    @jsii.member(jsii_name="ifAwsTokenIssueTime")
    def if_aws_token_issue_time(
        self,
        value: typing.Union[builtins.str, datetime.datetime],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the date and time that temporary security credentials were issued with the date and time that you specify.

        **Availability:** This key is included in the request context only when the principal uses temporary credentials to make the request. They key is not present in AWS CLI, AWS API, or AWS SDK requests that are made using access keys.

        To learn which services support using temporary credentials, see `AWS Services That Work with IAM <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html>`_.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tokenissuetime

        :param value: The date and time to check for. Can be a string in one of the `W3C implementations of the ISO 8601 date <https://www.w3.org/TR/NOTE-datetime>`_ (e.g. ``2020-04-01T00:00:00Z``) or in epoch (UNIX) time or a ``Date()`` object (JavaScript only)
        :param operator: Works with `date operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Date>`_. **Default:** ``DateGreaterThanEquals``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__738df271406b1f2b35a9978194656f9d48da9cfb1b44b4fbac3c7985d68d1ae3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsTokenIssueTime", [value, operator]))

    @jsii.member(jsii_name="ifAwsUserAgent")
    def if_aws_user_agent(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the requester's client application with the application that you specify.

        **Availability:** This key is always included in the request context.

        **Warning:** This key should be used carefully. Since the ``aws:UserAgent`` value is provided by the caller in an HTTP header, unauthorized parties can use modified or custom browsers to provide any ``aws:UserAgent`` value that they choose. As a result, ``aws:UserAgent`` should not be used to prevent unauthorized parties from making direct AWS requests. You can use it to allow only specific client applications, and only after testing your policy.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-useragent

        :param value: The User Agent string(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c548a90e633ac0af4601910e9ce787666ca4c1afdaf5f2e05ea43f9ea29e52ce)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsUserAgent", [value, operator]))

    @jsii.member(jsii_name="ifAwsUserid")
    def if_aws_userid(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the requester's principal identifier with the ID that you specify.

        For IAM users, the request context value is the user ID. For IAM roles, this value format can vary. For details about how the information appears for different principals, see `Specifying a Principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying>`_.

        **Availability:** This key is included in the request context for all signed requests. Anonymous requests do not include this key.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-userid

        :param value: The principal identifier(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c14032c0deddabeedd95074b4df64be980f756f8704ad5d7a9ef7c5693d63770)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsUserid", [value, operator]))

    @jsii.member(jsii_name="ifAwsUsername")
    def if_aws_username(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the requester's user name with the user name that you specify.

        For details about how the information appears for different principals, see `Specifying a Principal <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying>`_.

        **Availability:** This key is always included in the request context for IAM users. Anonymous requests and requests that are made using the AWS account root user or IAM roles do not include this key.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-username

        :param value: The user name(s).
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c497c2604db3b035f77d501996f9a0c8fb1fda191d301b88edb120660946a71c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsUsername", [value, operator]))

    @jsii.member(jsii_name="ifAwsViaAWSService")
    def if_aws_via_aws_service(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Check whether an AWS service makes a request to another service on your behalf.

        The request context key returns ``true`` when a service uses the credentials of an IAM principal to make a request on behalf of the principal. The context key returns ``false`` if the service uses a `service role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-role>`_ or `service-linked role <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role>`_ to make a call on the principal's behalf. The request context key also returns ``false`` when the principal makes the call directly.

        **Availability:** This key is always included in the request context for most services.

        The following services do not currently support ``aws:ViaAWSService``:

        - Amazon EC2
        - AWS Glue
        - AWS Lake Formation
        - AWS OpsWorks

        You can use this condition key to allow or deny access based on whether a request was made by a service. To view an example policy, see `AWS: Denies Access to AWS Based on the Source IP <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_examples_aws_deny-ip.html>`_.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-viaawsservice

        :param value: Whether a request was made by a service. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b9fde46ecc3d76d3a2a749d75929e8fbdea476b903151216fbf3266d74965ae4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsViaAWSService", [value]))

    @jsii.member(jsii_name="ifAwsVpcSourceIp")
    def if_aws_vpc_source_ip(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "PolicyStatementWithCondition":
        '''(experimental) Compare the IP address from which a request was made with the IP address that you specify.

        In a policy, the key matches only if the request originates from the specified IP address and it goes through a VPC endpoint.

        **Availability:** This key is included in the request context only if the request is made using a VPC endpoint.

        For more information, see `Controlling Access to Services with VPC Endpoints <https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html>`_ in the *Amazon VPC User Guide*.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-vpcsourceip

        :param value: The VPC source IP(s).
        :param operator: Works with IP `address operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_IPAddress>`_. **Default:** ``IpAddress``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a55d20a092f3bb4be0e35fb8b65bdd768ff283f7f34a741a09bd277e1d8bbf83)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("PolicyStatementWithCondition", jsii.invoke(self, "ifAwsVpcSourceIp", [value, operator]))

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        '''(experimental) Injects conditions into the statement.

        Only relevant for the main package. In CDK mode this only calls super.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toJSON", []))

    @jsii.member(jsii_name="toStatementJson")
    def to_statement_json(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toStatementJson", []))

    @builtins.property
    @jsii.member(jsii_name="floydConditions")
    def _floyd_conditions(self) -> Conditions:
        '''
        :stability: experimental
        '''
        return typing.cast(Conditions, jsii.get(self, "floydConditions"))

    @_floyd_conditions.setter
    def _floyd_conditions(self, value: Conditions) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__abaef68aa342dc89c1ebbb4ffb5fc88ebbc118aadb78f2db4f0d1b8aa84ec536)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "floydConditions", value)


@jsii.data_type(
    jsii_type="iam-floyd.Principals",
    jsii_struct_bases=[],
    name_mapping={},
)
class Principals:
    def __init__(self) -> None:
        '''(experimental) A collection of Principal's.

        :stability: experimental
        '''
        self._values: typing.Dict[builtins.str, typing.Any] = {}

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Principals(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="iam-floyd.ResourceTypes",
    jsii_struct_bases=[],
    name_mapping={},
)
class ResourceTypes:
    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        self._values: typing.Dict[builtins.str, typing.Any] = {}

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ResourceTypes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class PolicyStatementWithActions(
    PolicyStatementWithCondition,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementWithActions",
):
    '''(experimental) Adds "action" functionality to the Policy Statement.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''
        :param sid: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__093d23988cc4ea975381aa62cf894828b269ca1dec2f78c8f11bd47a174fc179)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="allActions")
    def all_actions(self) -> "PolicyStatementWithActions":
        '''(experimental) Adds all actions of the statement provider to the statement, e.g. ``actions: 'ec2:*'``.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithActions", jsii.invoke(self, "allActions", []))

    @jsii.member(jsii_name="allListActions")
    def all_list_actions(self) -> "PolicyStatementWithActions":
        '''(experimental) Adds all actions with `access level <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level>`_ LIST to the statement.

        Permission to list resources within the service to determine whether an object exists.

        Actions with this level of access can list objects but cannot see the contents of a resource.

        For example, the Amazon S3 action ``ListBucket`` has the List access level.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithActions", jsii.invoke(self, "allListActions", []))

    @jsii.member(jsii_name="allMatchingActions")
    def all_matching_actions(
        self,
        *expressions: builtins.str,
    ) -> "PolicyStatementWithActions":
        '''(experimental) Adds all actions that match one of the given regular expressions.

        :param expressions: One or more regular expressions. The regular expressions need to be in `Perl/JavaScript literal style <https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions>`_ and need to be passed as strings, For example:: allMatchingActions('/vpn/i')

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e661ada3b2bce9f47803c1fedb5fd7f294305c15395106cc09b9f2879946aa8)
            check_type(argname="argument expressions", value=expressions, expected_type=typing.Tuple[type_hints["expressions"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("PolicyStatementWithActions", jsii.invoke(self, "allMatchingActions", [*expressions]))

    @jsii.member(jsii_name="allPermissionManagementActions")
    def all_permission_management_actions(self) -> "PolicyStatementWithActions":
        '''(experimental) Adds all actions with `access level <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level>`_ PERMISSION MANAGEMENT to the statement.

        Permission to grant or modify resource permissions in the service.

        For example, most IAM and AWS Organizations actions, as well as actions like the Amazon S3 actions ``PutBucketPolicy`` and ``DeleteBucketPolicy`` have the Permissions management access level.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithActions", jsii.invoke(self, "allPermissionManagementActions", []))

    @jsii.member(jsii_name="allReadActions")
    def all_read_actions(self) -> "PolicyStatementWithActions":
        '''(experimental) Adds all actions with `access level <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level>`_ READ to the statement.

        Permission to read but not edit the contents and attributes of resources in the service.

        For example, the Amazon S3 actions ``GetObject`` and ``GetBucketLocation`` have the Read access level.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithActions", jsii.invoke(self, "allReadActions", []))

    @jsii.member(jsii_name="allTaggingActions")
    def all_tagging_actions(self) -> "PolicyStatementWithActions":
        '''(experimental) Adds all actions with `access level <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level>`_ TAGGING to the statement.

        Permission to perform actions that only change the state of resource tags.

        For example, the IAM actions ``TagRole`` and ``UntagRole`` have the Tagging access level because they allow only tagging or untagging a role. However, the ``CreateRole`` action allows tagging a role resource when you create that role. Because the action does not only add a tag, it has the Write access level.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithActions", jsii.invoke(self, "allTaggingActions", []))

    @jsii.member(jsii_name="allWriteActions")
    def all_write_actions(self) -> "PolicyStatementWithActions":
        '''(experimental) Adds all actions with `access level <https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level>`_ WRITE to the statement.

        Permission to create, delete, or modify resources in the service.

        For example, the Amazon S3 actions ``CreateBucket``, ``DeleteBucket`` and ``PutObject`` have the Write access level.

        Write actions might also allow modifying a resource tag. However, an action that allows only changes to tags has the Tagging access level.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithActions", jsii.invoke(self, "allWriteActions", []))

    @jsii.member(jsii_name="compact")
    def compact(self) -> "PolicyStatementWithActions":
        '''(experimental) Condense action list down to a list of patterns.

        Using this method can help to reduce the policy size.

        For example, all actions with access level ``list`` could be reduced to a small pattern ``List*``.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithActions", jsii.invoke(self, "compact", []))

    @jsii.member(jsii_name="freeze")
    def freeze(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "freeze", []))

    @jsii.member(jsii_name="hasActions")
    def has_actions(self) -> builtins.bool:
        '''(experimental) Checks weather actions have been applied to the policy.

        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.invoke(self, "hasActions", []))

    @jsii.member(jsii_name="notAction")
    def not_action(self) -> "PolicyStatementWithActions":
        '''(experimental) Switches the statement to use ```NotAction`` <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html>`_.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithActions", jsii.invoke(self, "notAction", []))

    @jsii.member(jsii_name="to")
    def to(self, action: builtins.str) -> "PolicyStatementWithActions":
        '''(experimental) Adds actions by name.

        Depending on the "mode", actions will be either added to the list of ```Actions`` <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html>`_ or ```NotAction`` <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html>`_.

        The mode can be switched by calling ``notAction()``.

        If the action does not contain a colon, the action will be prefixed with the service prefix of the class, e.g. ``ec2:``

        :param action: Actions that will be added to the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4bb088cb4d336ef7471f543ab978ff56b4dec26240ac0d6855c79f8304213e6e)
            check_type(argname="argument action", value=action, expected_type=type_hints["action"])
        return typing.cast("PolicyStatementWithActions", jsii.invoke(self, "to", [action]))

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        '''(experimental) Injects actions into the statement.

        Only relevant for the main package. In CDK mode this only calls super.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toJSON", []))

    @jsii.member(jsii_name="toStatementJson")
    def to_statement_json(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toStatementJson", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70bc750a316df6c18f2ef1b9639d5bee3924253038f53441ec16e0ad872ccb57)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="floydActions")
    def _floyd_actions(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "floydActions"))

    @_floyd_actions.setter
    def _floyd_actions(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__88771298f7f17a0d0acdf694dbed722afd6140718bc02cc6ef2e154b60feb663)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "floydActions", value)


class PolicyStatementWithResources(
    PolicyStatementWithActions,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementWithResources",
):
    '''(experimental) Adds "resource" functionality to the Policy Statement.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''
        :param sid: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71418682b5c967665f77f3b181e1c66f722c341d76aa545c6ce78362360697e7)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="freeze")
    def freeze(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "freeze", []))

    @jsii.member(jsii_name="hasResources")
    def has_resources(self) -> builtins.bool:
        '''(experimental) Checks weather any resource was applied to the policy.

        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.invoke(self, "hasResources", []))

    @jsii.member(jsii_name="notResource")
    def not_resource(self) -> "PolicyStatementWithResources":
        '''(experimental) Switches the statement to use ```NotResource`` <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html>`_.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithResources", jsii.invoke(self, "notResource", []))

    @jsii.member(jsii_name="on")
    def on(self, *arns: builtins.str) -> "PolicyStatementWithResources":
        '''(experimental) Limit statement to specified resources.

        To allow all resources, pass ``*``

        :param arns: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__289ffa51b0659b40c0a36d5a3eefc470307d1fe178d5dc6f89cc3e0aa6ff72ae)
            check_type(argname="argument arns", value=arns, expected_type=typing.Tuple[type_hints["arns"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("PolicyStatementWithResources", jsii.invoke(self, "on", [*arns]))

    @jsii.member(jsii_name="onAllResources")
    def on_all_resources(self) -> "PolicyStatementWithResources":
        '''(experimental) Add all resources (``*``) to the statement.

        This is the default behavior, unless the statement has principals.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithResources", jsii.invoke(self, "onAllResources", []))

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        '''(experimental) Injects resources into the statement.

        Only relevant for the main package. In CDK mode this only calls super.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toJSON", []))

    @jsii.member(jsii_name="toStatementJson")
    def to_statement_json(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toStatementJson", []))

    @builtins.property
    @jsii.member(jsii_name="floydResources")
    def _floyd_resources(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "floydResources"))

    @_floyd_resources.setter
    def _floyd_resources(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e34071d28c632daa6cd6a4c16a335070f5fc62110d1e3324fe697a18d76aea8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "floydResources", value)

    @builtins.property
    @jsii.member(jsii_name="skipAutoResource")
    def _skip_auto_resource(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "skipAutoResource"))

    @_skip_auto_resource.setter
    def _skip_auto_resource(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__845a5aa0ae395783f65395d684d175028e27e3a75b802ca3d9db219d736109cc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "skipAutoResource", value)


class PolicyStatementWithEffect(
    PolicyStatementWithResources,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementWithEffect",
):
    '''(experimental) Adds "effect" functionality to the Policy Statement.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''
        :param sid: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4465fee9053bdfe4b149fdc083264e021432dc42d93a3959546cd8bd1e0aa16b)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="allow")
    def allow(self) -> "PolicyStatementWithEffect":
        '''(experimental) Allow the actions in this statement.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithEffect", jsii.invoke(self, "allow", []))

    @jsii.member(jsii_name="deny")
    def deny(self) -> "PolicyStatementWithEffect":
        '''(experimental) Deny the actions in this statement.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithEffect", jsii.invoke(self, "deny", []))

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        '''(experimental) Injects effect into the statement.

        Only relevant for the main package. In CDK mode this only calls super.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toJSON", []))

    @builtins.property
    @jsii.member(jsii_name="effect")
    def effect(self) -> Effect:
        '''
        :stability: experimental
        '''
        return typing.cast(Effect, jsii.get(self, "effect"))

    @effect.setter
    def effect(self, value: Effect) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__94441803d0dbeb3dfea7eae55172786aa200b4c86b577219f659c77e12785cb1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "effect", value)


class PolicyStatementWithPrincipal(
    PolicyStatementWithEffect,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatementWithPrincipal",
):
    '''(experimental) Adds "principal" functionality to the Policy Statement.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''
        :param sid: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a3cff3121729641292e305bd0d07adb5b3b38720476d80db35c4e1fd9b9ff8f)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="addPrincipal")
    def _add_principal(
        self,
        prefix: builtins.str,
        principal: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds a principal to the statement.

        :param prefix: One of **AWS**, **Federated**, **CanonicalUser** or **Service**.
        :param principal: The principal string.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f43da71badcc29a12f8a9ee1b7f26b46fbfaf282916e4d10bc0ba7099d9d9f1)
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument principal", value=principal, expected_type=type_hints["principal"])
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "addPrincipal", [prefix, principal]))

    @jsii.member(jsii_name="cdkApplyPrincipals")
    def _cdk_apply_principals(self) -> None:
        '''
        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "cdkApplyPrincipals", []))

    @jsii.member(jsii_name="for")
    def for_(
        self,
        arn: builtins.str,
        prefix: typing.Optional[builtins.str] = None,
    ) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds any principal to the statement.

        :param arn: The ARN of the principal.
        :param prefix: One of **AWS**, **Federated**, **CanonicalUser** or **Service** - Default: **AWS**.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c6aa5866d7483abcba1edab3f1753719c023644bddc35894c623579a08b9f6e7)
            check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "for", [arn, prefix]))

    @jsii.member(jsii_name="forAccount")
    def for_account(self, *accounts: builtins.str) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds one or more account principals to the statement.

        :param accounts: ID of the AWS account.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__11f7611db3676293bae1562dfb78f937406ef384ea68773e9070c46deed9cb55)
            check_type(argname="argument accounts", value=accounts, expected_type=typing.Tuple[type_hints["accounts"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forAccount", [*accounts]))

    @jsii.member(jsii_name="forAssumedRoleSession")
    def for_assumed_role_session(
        self,
        account: builtins.str,
        role_name: builtins.str,
        *session_names: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds one or more specific assumed role session principals to the statement.

        :param account: ID of the AWS account.
        :param role_name: Name of the IAM role.
        :param session_names: Name of the session. You cannot use a wildcard (``*``) to mean *all sessions*. Principals must always name a specific session

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5177533b9df3edb2f58583f5b3da6024a5d7ff4e650d527ef4b6e9813bf399bf)
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument role_name", value=role_name, expected_type=type_hints["role_name"])
            check_type(argname="argument session_names", value=session_names, expected_type=typing.Tuple[type_hints["session_names"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forAssumedRoleSession", [account, role_name, *session_names]))

    @jsii.member(jsii_name="forCanonicalUser")
    def for_canonical_user(
        self,
        *user_i_ds: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds one or more canonical user principals to the statement.

        :param user_i_ds: The user ID. You can `find the canonical user ID <https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId>`_ for your AWS account in the AWS Management Console. The canonical user ID for an AWS account is specific to the account. You can retrieve the canonical user ID for your AWS account as either the root user or an IAM user.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46f209a44ea976f720f05020848956383e7c02a0ee28eaec9e6f0e26a4ef11f9)
            check_type(argname="argument user_i_ds", value=user_i_ds, expected_type=typing.Tuple[type_hints["user_i_ds"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forCanonicalUser", [*user_i_ds]))

    @jsii.member(jsii_name="forFederated")
    def for_federated(self, *providers: builtins.str) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds one or more `federated <https://aws.amazon.com/identity/federation/>`_ (web identity) principals to the statement.

        :param providers: ID of the AWS account.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a398adb2e076db82229943e33f593b9571a89fceddadbe48258788e64c88fcd5)
            check_type(argname="argument providers", value=providers, expected_type=typing.Tuple[type_hints["providers"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forFederated", [*providers]))

    @jsii.member(jsii_name="forFederatedAmazon")
    def for_federated_amazon(self) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds a federated `Amazon <https://login.amazon.com/>`_ principal to the statement.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forFederatedAmazon", []))

    @jsii.member(jsii_name="forFederatedCognito")
    def for_federated_cognito(self) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds a federated `AWS Cognito <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc_cognito.html>`_ principal to the statement.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forFederatedCognito", []))

    @jsii.member(jsii_name="forFederatedFacebook")
    def for_federated_facebook(self) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds a federated `Facebook <https://developers.facebook.com/docs/facebook-login>`_ principal to the statement.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forFederatedFacebook", []))

    @jsii.member(jsii_name="forFederatedGoogle")
    def for_federated_google(self) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds a federated `Google <https://developers.google.com/identity/protocols/oauth2/openid-connect>`_ principal to the statement.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forFederatedGoogle", []))

    @jsii.member(jsii_name="forPublic")
    def for_public(self) -> "PolicyStatementWithPrincipal":
        '''(experimental) Grants public asses.

        **EVERYONE IN THE WORLD HAS ACCESS**

        We strongly recommend that you do not use a wildcard in the Principal element in a role's trust policy unless you otherwise restrict access through a Condition element in the policy. Otherwise, any IAM user in any account in your partition can access the role.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forPublic", []))

    @jsii.member(jsii_name="forRole")
    def for_role(
        self,
        account: builtins.str,
        *roles: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds one or more IAM role principals to the statement.

        :param account: ID of the AWS account.
        :param roles: Name of the IAM role.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__52b4d0ac664eb61a852b4dcc26d9023f222abe7307e0f1a3983eaf871d2b05b0)
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument roles", value=roles, expected_type=typing.Tuple[type_hints["roles"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forRole", [account, *roles]))

    @jsii.member(jsii_name="forSaml")
    def for_saml(
        self,
        account: builtins.str,
        *provider_names: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds one or more federated SAML principals to the statement.

        :param account: ID of the AWS account.
        :param provider_names: Name of the SAML provider.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__98209c9cd4748c3e32123aa1c26a1a628553387024bb9eafd66c7e9be61ab55d)
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument provider_names", value=provider_names, expected_type=typing.Tuple[type_hints["provider_names"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forSaml", [account, *provider_names]))

    @jsii.member(jsii_name="forService")
    def for_service(self, *services: builtins.str) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds one or more service principals to the statement.

        :param services: Long version of the service name. Usually in the format: ``long_service-name.amazonaws.com``. The service principal is defined by the service. To learn the service principal for a service, see the documentation for that service. For some services, see `AWS Services That Work with IAM <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html>`_ and look for the services that have **Yes** in the **Service-Linked Role** column. Choose a **Yes** with a link to view the service-linked role documentation for that service. View the **Service-Linked Role Permissions** section for that service to view the service principal.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e17956887090b4bfb55fcf8ddc8caa37832e121a7a2f06ee5d1b50ef2c2727dc)
            check_type(argname="argument services", value=services, expected_type=typing.Tuple[type_hints["services"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forService", [*services]))

    @jsii.member(jsii_name="forUser")
    def for_user(
        self,
        account: builtins.str,
        *users: builtins.str,
    ) -> "PolicyStatementWithPrincipal":
        '''(experimental) Adds one or more IAM user principals to the statement.

        :param account: ID of the AWS account.
        :param users: Name of the IAM user.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fbbd754f3c05dc4e15cc9c7b3a99afcc314e434bf8c8ac4ea9d016c03509ff4f)
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument users", value=users, expected_type=typing.Tuple[type_hints["users"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "forUser", [account, *users]))

    @jsii.member(jsii_name="freeze")
    def freeze(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "freeze", []))

    @jsii.member(jsii_name="hasPrincipals")
    def has_principals(self) -> builtins.bool:
        '''(experimental) Checks weather a principal was applied to the policy.

        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.invoke(self, "hasPrincipals", []))

    @jsii.member(jsii_name="notPrincipal")
    def not_principal(self) -> "PolicyStatementWithPrincipal":
        '''(experimental) Switches the statement to use ```notPrincipal`` <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notprincipal.html>`_.

        :stability: experimental
        '''
        return typing.cast("PolicyStatementWithPrincipal", jsii.invoke(self, "notPrincipal", []))

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        '''(experimental) Injects principals into the statement.

        Only relevant for the main package. In CDK mode this only calls super.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toJSON", []))

    @jsii.member(jsii_name="toStatementJson")
    def to_statement_json(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toStatementJson", []))

    @builtins.property
    @jsii.member(jsii_name="myPrincipals")
    def _my_principals(self) -> Principals:
        '''
        :stability: experimental
        '''
        return typing.cast(Principals, jsii.get(self, "myPrincipals"))

    @_my_principals.setter
    def _my_principals(self, value: Principals) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__975d6c3b1ffe9cc28a898caebcec4a48a6e0205dceb7df1b9dbcafaa4caa92cd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "myPrincipals", value)

    @builtins.property
    @jsii.member(jsii_name="useNotPrincipal")
    def _use_not_principal(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "useNotPrincipal"))

    @_use_not_principal.setter
    def _use_not_principal(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0446e0f0791a09b6cb0e75e4afb14085c1f32aeca22b06564a6641a25a8dc48d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "useNotPrincipal", value)


class PolicyStatement(
    PolicyStatementWithPrincipal,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PolicyStatement",
):
    '''(experimental) Represents a statement in an IAM policy document.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''
        :param sid: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41bafffffee539105d25c03dc13e5d345febb0f4eaf59cb4132893d8763157dd)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        '''(experimental) JSON-ify the policy statement.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toJSON", []))

    @builtins.property
    @jsii.member(jsii_name="cdkApplied")
    def _cdk_applied(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "cdkApplied"))

    @_cdk_applied.setter
    def _cdk_applied(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d71f9438f8164fef39daa58b6e821bdef745c5794c99f571912c94dc5bcd942c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "cdkApplied", value)


class Polly(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Polly"):
    '''(experimental) Statement provider for service `polly <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpolly.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `polly <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpolly.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20b69a7493c8c6f609b89c4f159face2081504633fc70f61dc30c6914495f2e3)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onLexicon")
    def on_lexicon(
        self,
        lexicon_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Polly":
        '''(experimental) Adds a resource of type lexicon to the statement.

        https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html

        :param lexicon_name: - Identifier for the lexiconName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb7da2da458aba491da64d937f36a87bc1fb4f6a35eaa814d665a979902753b8)
            check_type(argname="argument lexicon_name", value=lexicon_name, expected_type=type_hints["lexicon_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Polly", jsii.invoke(self, "onLexicon", [lexicon_name, account, region, partition]))

    @jsii.member(jsii_name="toDeleteLexicon")
    def to_delete_lexicon(self) -> "Polly":
        '''(experimental) Grants permissions to delete the specified pronunciation lexicon stored in an AWS Region.

        Access Level: Write

        https://docs.aws.amazon.com/polly/latest/dg/API_DeleteLexicon.html

        :stability: experimental
        '''
        return typing.cast("Polly", jsii.invoke(self, "toDeleteLexicon", []))

    @jsii.member(jsii_name="toDescribeVoices")
    def to_describe_voices(self) -> "Polly":
        '''(experimental) Grants permissions to describe the list of voices that are available for use when requesting speech synthesis.

        Access Level: List

        https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html

        :stability: experimental
        '''
        return typing.cast("Polly", jsii.invoke(self, "toDescribeVoices", []))

    @jsii.member(jsii_name="toGetLexicon")
    def to_get_lexicon(self) -> "Polly":
        '''(experimental) Grants permissions to retrieve the content of the specified pronunciation lexicon stored in an AWS Region.

        Access Level: Read

        https://docs.aws.amazon.com/polly/latest/dg/API_GetLexicon.html

        :stability: experimental
        '''
        return typing.cast("Polly", jsii.invoke(self, "toGetLexicon", []))

    @jsii.member(jsii_name="toGetSpeechSynthesisTask")
    def to_get_speech_synthesis_task(self) -> "Polly":
        '''(experimental) Grants permissions to get information about specific speech synthesis task.

        Access Level: Read

        https://docs.aws.amazon.com/polly/latest/dg/API_GetSpeechSynthesisTask.html

        :stability: experimental
        '''
        return typing.cast("Polly", jsii.invoke(self, "toGetSpeechSynthesisTask", []))

    @jsii.member(jsii_name="toListLexicons")
    def to_list_lexicons(self) -> "Polly":
        '''(experimental) Grants permisions to list the pronunciation lexicons stored in an AWS Region.

        Access Level: List

        https://docs.aws.amazon.com/polly/latest/dg/API_ListLexicons.html

        :stability: experimental
        '''
        return typing.cast("Polly", jsii.invoke(self, "toListLexicons", []))

    @jsii.member(jsii_name="toListSpeechSynthesisTasks")
    def to_list_speech_synthesis_tasks(self) -> "Polly":
        '''(experimental) Grants permissions to list requested speech synthesis tasks.

        Access Level: List

        https://docs.aws.amazon.com/polly/latest/dg/API_ListSpeechSynthesisTasks.html

        :stability: experimental
        '''
        return typing.cast("Polly", jsii.invoke(self, "toListSpeechSynthesisTasks", []))

    @jsii.member(jsii_name="toPutLexicon")
    def to_put_lexicon(self) -> "Polly":
        '''(experimental) Grants permissions to store a pronunciation lexicon in an AWS Region.

        Access Level: Write

        https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html

        :stability: experimental
        '''
        return typing.cast("Polly", jsii.invoke(self, "toPutLexicon", []))

    @jsii.member(jsii_name="toStartSpeechSynthesisTask")
    def to_start_speech_synthesis_task(self) -> "Polly":
        '''(experimental) Grants permissions to synthesize long inputs to the provided S3 location.

        Access Level: Write

        Dependent actions:

        - s3:PutObject

        https://docs.aws.amazon.com/polly/latest/dg/API_StartSpeechSynthesisTask.html

        :stability: experimental
        '''
        return typing.cast("Polly", jsii.invoke(self, "toStartSpeechSynthesisTask", []))

    @jsii.member(jsii_name="toSynthesizeSpeech")
    def to_synthesize_speech(self) -> "Polly":
        '''(experimental) Grants permissions to synthesize speech.

        Access Level: Read

        https://docs.aws.amazon.com/polly/latest/dg/API_SynthesizeSpeech.html

        :stability: experimental
        '''
        return typing.cast("Polly", jsii.invoke(self, "toSynthesizeSpeech", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__85dbfdae27012d6f5e7725efc8a274ee01ee8d1ddd42dce7175ad9e040c16966)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fffd147f444775c264f07ca6ebb9b8f1b02ce6d6a595c539c3238891ee1331e5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Pricing(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Pricing"):
    '''(experimental) Statement provider for service `pricing <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspricelist.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `pricing <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspricelist.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4b0c9aff2ca48a23be2ef2fd56f4d823682698da291a78d4b6ca70417046ebc7)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="toDescribeServices")
    def to_describe_services(self) -> "Pricing":
        '''(experimental) Grants permission to retrieve service details for all (paginated) services (if serviceCode is not set) or service detail for a particular service (if given serviceCode).

        Access Level: Read

        https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_DescribeServices.html

        :stability: experimental
        '''
        return typing.cast("Pricing", jsii.invoke(self, "toDescribeServices", []))

    @jsii.member(jsii_name="toGetAttributeValues")
    def to_get_attribute_values(self) -> "Pricing":
        '''(experimental) Grants permission to retrieve all (paginated) possible values for a given attribute.

        Access Level: Read

        https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html

        :stability: experimental
        '''
        return typing.cast("Pricing", jsii.invoke(self, "toGetAttributeValues", []))

    @jsii.member(jsii_name="toGetProducts")
    def to_get_products(self) -> "Pricing":
        '''(experimental) Grants permission to retrieve all matching products with given search criteria.

        Access Level: Read

        https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetProducts.html

        :stability: experimental
        '''
        return typing.cast("Pricing", jsii.invoke(self, "toGetProducts", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b410851fc6dd6a5be90a3ac3510040d03363efac4412a16e2e752db488cb584)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8ff737b4ab33bfbf661818c732a7d9cbf2cb904f9847356e442ec135f7d87b3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class PrivateNetworks(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PrivateNetworks",
):
    '''(experimental) Statement provider for service `private-networks <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserviceprovidingmanagedprivatenetworks.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `private-networks <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserviceprovidingmanagedprivatenetworks.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__baccef44bf8dc7cfae1350b6d0c0287848d486387725dc69566dec5f0b83f6b4)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onDeviceIdentifier")
    def on_device_identifier(
        self,
        network_name: builtins.str,
        device_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "PrivateNetworks":
        '''(experimental) Adds a resource of type device-identifier to the statement.

        https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html

        :param network_name: - Identifier for the networkName.
        :param device_id: - Identifier for the deviceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8f673f1ba37433ce3f65d2654ff2f7b57c850769ba348dec778eac9ee88186ef)
            check_type(argname="argument network_name", value=network_name, expected_type=type_hints["network_name"])
            check_type(argname="argument device_id", value=device_id, expected_type=type_hints["device_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("PrivateNetworks", jsii.invoke(self, "onDeviceIdentifier", [network_name, device_id, account, region, partition]))

    @jsii.member(jsii_name="onNetwork")
    def on_network(
        self,
        network_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "PrivateNetworks":
        '''(experimental) Adds a resource of type network to the statement.

        https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html

        :param network_name: - Identifier for the networkName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__84b89780d71ba72dda333b6deab64b907536a908a1747f1112328e99b0c0bbe6)
            check_type(argname="argument network_name", value=network_name, expected_type=type_hints["network_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("PrivateNetworks", jsii.invoke(self, "onNetwork", [network_name, account, region, partition]))

    @jsii.member(jsii_name="onNetworkResource")
    def on_network_resource(
        self,
        network_name: builtins.str,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "PrivateNetworks":
        '''(experimental) Adds a resource of type network-resource to the statement.

        https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html

        :param network_name: - Identifier for the networkName.
        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a54334d8aec7668ec473d7c5169485e82ee39df5603b53f1de0d16335f37b564)
            check_type(argname="argument network_name", value=network_name, expected_type=type_hints["network_name"])
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("PrivateNetworks", jsii.invoke(self, "onNetworkResource", [network_name, resource_id, account, region, partition]))

    @jsii.member(jsii_name="onNetworkSite")
    def on_network_site(
        self,
        network_name: builtins.str,
        network_site_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "PrivateNetworks":
        '''(experimental) Adds a resource of type network-site to the statement.

        https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html

        :param network_name: - Identifier for the networkName.
        :param network_site_name: - Identifier for the networkSiteName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__24ba70bd44af487912a7feff466b6ae9ad6684a8c546affb2fb209624f99fbfe)
            check_type(argname="argument network_name", value=network_name, expected_type=type_hints["network_name"])
            check_type(argname="argument network_site_name", value=network_site_name, expected_type=type_hints["network_site_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("PrivateNetworks", jsii.invoke(self, "onNetworkSite", [network_name, network_site_name, account, region, partition]))

    @jsii.member(jsii_name="onOrder")
    def on_order(
        self,
        network_name: builtins.str,
        order_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "PrivateNetworks":
        '''(experimental) Adds a resource of type order to the statement.

        https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html

        :param network_name: - Identifier for the networkName.
        :param order_id: - Identifier for the orderId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6da6913535d67ef2f293d2eaba8b7efd8679f083be4ef8d8032265248ea4cedc)
            check_type(argname="argument network_name", value=network_name, expected_type=type_hints["network_name"])
            check_type(argname="argument order_id", value=order_id, expected_type=type_hints["order_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("PrivateNetworks", jsii.invoke(self, "onOrder", [network_name, order_id, account, region, partition]))

    @jsii.member(jsii_name="toAcknowledgeOrderReceipt")
    def to_acknowledge_order_receipt(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to acknowledge that an order has been received.

        Access Level: Write

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_AcknowledgeOrderReceipt.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toAcknowledgeOrderReceipt", []))

    @jsii.member(jsii_name="toActivateDeviceIdentifier")
    def to_activate_device_identifier(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to activate a device identifier.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ActivateDeviceIdentifier.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toActivateDeviceIdentifier", []))

    @jsii.member(jsii_name="toActivateNetworkSite")
    def to_activate_network_site(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to activate a network site.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ActivateNetworkSite.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toActivateNetworkSite", []))

    @jsii.member(jsii_name="toConfigureAccessPoint")
    def to_configure_access_point(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to configure an access point.

        Access Level: Write

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ConfigureAccessPoint.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toConfigureAccessPoint", []))

    @jsii.member(jsii_name="toCreateNetwork")
    def to_create_network(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to create a network.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_CreateNetwork.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toCreateNetwork", []))

    @jsii.member(jsii_name="toCreateNetworkSite")
    def to_create_network_site(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to create a network site.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_CreateNetworkSite.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toCreateNetworkSite", []))

    @jsii.member(jsii_name="toDeactivateDeviceIdentifier")
    def to_deactivate_device_identifier(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to deactivate a device identifier.

        Access Level: Write

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeactivateDeviceIdentifier.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toDeactivateDeviceIdentifier", []))

    @jsii.member(jsii_name="toDeleteNetwork")
    def to_delete_network(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to delete a network.

        Access Level: Write

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetwork.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toDeleteNetwork", []))

    @jsii.member(jsii_name="toDeleteNetworkSite")
    def to_delete_network_site(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to delete a network site.

        Access Level: Write

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetworkSite.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toDeleteNetworkSite", []))

    @jsii.member(jsii_name="toGetDeviceIdentifier")
    def to_get_device_identifier(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to get a device identifier.

        Access Level: Read

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetDeviceIdentifier.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toGetDeviceIdentifier", []))

    @jsii.member(jsii_name="toGetNetwork")
    def to_get_network(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to get a network.

        Access Level: Read

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetNetwork.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toGetNetwork", []))

    @jsii.member(jsii_name="toGetNetworkResource")
    def to_get_network_resource(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to get a network resource.

        Access Level: Read

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetNetworkResource.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toGetNetworkResource", []))

    @jsii.member(jsii_name="toGetNetworkSite")
    def to_get_network_site(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to get a network site.

        Access Level: Read

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetNetworkSite.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toGetNetworkSite", []))

    @jsii.member(jsii_name="toGetOrder")
    def to_get_order(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to get a network order.

        Access Level: Read

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetOrder.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toGetOrder", []))

    @jsii.member(jsii_name="toListDeviceIdentifiers")
    def to_list_device_identifiers(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to list device identifiers.

        Access Level: List

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListDeviceIdentifiers.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toListDeviceIdentifiers", []))

    @jsii.member(jsii_name="toListNetworkResources")
    def to_list_network_resources(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to list network resources.

        Access Level: List

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListNetworkResources.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toListNetworkResources", []))

    @jsii.member(jsii_name="toListNetworks")
    def to_list_networks(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to list networks.

        Access Level: List

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListNetworks.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toListNetworks", []))

    @jsii.member(jsii_name="toListNetworkSites")
    def to_list_network_sites(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to list network sites.

        Access Level: List

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListNetworkSites.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toListNetworkSites", []))

    @jsii.member(jsii_name="toListOrders")
    def to_list_orders(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to list network orders.

        Access Level: List

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListOrders.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toListOrders", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to return a list of tags for a resource.

        Access Level: List

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toPing")
    def to_ping(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to check the health of the service.

        Access Level: Read

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_Ping.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toPing", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to adds tags to the specified resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to removes tags from the specified resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateNetworkSite")
    def to_update_network_site(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to update a network site.

        Access Level: Write

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_UpdateNetworkSite.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toUpdateNetworkSite", []))

    @jsii.member(jsii_name="toUpdateNetworkSitePlan")
    def to_update_network_site_plan(self) -> "PrivateNetworks":
        '''(experimental) Grants permission to update a plan at a network site.

        Access Level: Write

        https://docs.aws.amazon.com/private-networks/latest/APIReference/API_UpdateNetworkSitePlan.html

        :stability: experimental
        '''
        return typing.cast("PrivateNetworks", jsii.invoke(self, "toUpdateNetworkSitePlan", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__51df11bf202a2eee7fc67df36023d6fec84f878797572f5a3687675805b602ee)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__23b8ddb356e5af6dd5785e81edd3fb367d3d23eef111c041864bc6bff20a2768)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Profile(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Profile"):
    '''(experimental) Statement provider for service `profile <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectcustomerprofiles.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `profile <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectcustomerprofiles.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__487679b6cc1ef2e8d7475001dd028d2e87e64dda04781923c0d0594192d77c75)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onDomains")
    def on_domains(
        self,
        domain_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Profile":
        '''(experimental) Adds a resource of type domains to the statement.

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/

        :param domain_name: - Identifier for the domainName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f847af9cf62aab87723898d2ae7a030051b64579aa7456e9e0b1ee46a249d74)
            check_type(argname="argument domain_name", value=domain_name, expected_type=type_hints["domain_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Profile", jsii.invoke(self, "onDomains", [domain_name, account, region, partition]))

    @jsii.member(jsii_name="onIntegrations")
    def on_integrations(
        self,
        domain_name: builtins.str,
        uri: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Profile":
        '''(experimental) Adds a resource of type integrations to the statement.

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/

        :param domain_name: - Identifier for the domainName.
        :param uri: - Identifier for the uri.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fe14e7266240222e4a843b36bd6b1d1973b9a57a6c3f2aa6a7f331c146ba78fc)
            check_type(argname="argument domain_name", value=domain_name, expected_type=type_hints["domain_name"])
            check_type(argname="argument uri", value=uri, expected_type=type_hints["uri"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Profile", jsii.invoke(self, "onIntegrations", [domain_name, uri, account, region, partition]))

    @jsii.member(jsii_name="onObjectTypes")
    def on_object_types(
        self,
        domain_name: builtins.str,
        object_type_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Profile":
        '''(experimental) Adds a resource of type object-types to the statement.

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/

        :param domain_name: - Identifier for the domainName.
        :param object_type_name: - Identifier for the objectTypeName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__410a2d4b5bed7d238a65b0afb4ac2f5dd673a14a55ccd7860caac9876e04686f)
            check_type(argname="argument domain_name", value=domain_name, expected_type=type_hints["domain_name"])
            check_type(argname="argument object_type_name", value=object_type_name, expected_type=type_hints["object_type_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Profile", jsii.invoke(self, "onObjectTypes", [domain_name, object_type_name, account, region, partition]))

    @jsii.member(jsii_name="toAddProfileKey")
    def to_add_profile_key(self) -> "Profile":
        '''(experimental) Grants permission to add a profile key.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_AddProfileKey.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toAddProfileKey", []))

    @jsii.member(jsii_name="toCreateDomain")
    def to_create_domain(self) -> "Profile":
        '''(experimental) Grants permission to create a Domain.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toCreateDomain", []))

    @jsii.member(jsii_name="toCreateIntegrationWorkflow")
    def to_create_integration_workflow(self) -> "Profile":
        '''(experimental) Grants permission to create an integration workflow in a domain.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateIntegrationWorkflow.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toCreateIntegrationWorkflow", []))

    @jsii.member(jsii_name="toCreateProfile")
    def to_create_profile(self) -> "Profile":
        '''(experimental) Grants permission to create a profile in the domain.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateProfile.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toCreateProfile", []))

    @jsii.member(jsii_name="toDeleteDomain")
    def to_delete_domain(self) -> "Profile":
        '''(experimental) Grants permission to delete a Domain.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteDomain.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toDeleteDomain", []))

    @jsii.member(jsii_name="toDeleteIntegration")
    def to_delete_integration(self) -> "Profile":
        '''(experimental) Grants permission to delete a integration in a domain.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteIntegration.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toDeleteIntegration", []))

    @jsii.member(jsii_name="toDeleteProfile")
    def to_delete_profile(self) -> "Profile":
        '''(experimental) Grants permission to delete a profile.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteProfile.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toDeleteProfile", []))

    @jsii.member(jsii_name="toDeleteProfileKey")
    def to_delete_profile_key(self) -> "Profile":
        '''(experimental) Grants permission to delete a profile key.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteProfileKey.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toDeleteProfileKey", []))

    @jsii.member(jsii_name="toDeleteProfileObject")
    def to_delete_profile_object(self) -> "Profile":
        '''(experimental) Grants permission to delete a profile object.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteProfileObject.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toDeleteProfileObject", []))

    @jsii.member(jsii_name="toDeleteProfileObjectType")
    def to_delete_profile_object_type(self) -> "Profile":
        '''(experimental) Grants permission to delete a specific profile object type in the domain.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteProfileObjectType.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toDeleteProfileObjectType", []))

    @jsii.member(jsii_name="toDeleteWorkflow")
    def to_delete_workflow(self) -> "Profile":
        '''(experimental) Grants permission to delete a workflow in a domain.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_DeleteWorkflow.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toDeleteWorkflow", []))

    @jsii.member(jsii_name="toGetAutoMergingPreview")
    def to_get_auto_merging_preview(self) -> "Profile":
        '''(experimental) Grants permission to get a preview of auto merging in a domain.

        Access Level: Read

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetAutoMergingPreview.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toGetAutoMergingPreview", []))

    @jsii.member(jsii_name="toGetDomain")
    def to_get_domain(self) -> "Profile":
        '''(experimental) Grants permission to get a specific domain in an account.

        Access Level: Read

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetDomain.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toGetDomain", []))

    @jsii.member(jsii_name="toGetIdentityResolutionJob")
    def to_get_identity_resolution_job(self) -> "Profile":
        '''(experimental) Grants permission to get an identity resolution job in a domain.

        Access Level: Read

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetIdentityResolutionJob.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toGetIdentityResolutionJob", []))

    @jsii.member(jsii_name="toGetIntegration")
    def to_get_integration(self) -> "Profile":
        '''(experimental) Grants permission to get a specific integrations in a domain.

        Access Level: Read

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetIntegration.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toGetIntegration", []))

    @jsii.member(jsii_name="toGetMatches")
    def to_get_matches(self) -> "Profile":
        '''(experimental) Grants permission to get profile matches in a domain.

        Access Level: List

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toGetMatches", []))

    @jsii.member(jsii_name="toGetProfileObjectType")
    def to_get_profile_object_type(self) -> "Profile":
        '''(experimental) Grants permission to get a specific profile object type in the domain.

        Access Level: Read

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetProfileObjectType.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toGetProfileObjectType", []))

    @jsii.member(jsii_name="toGetProfileObjectTypeTemplate")
    def to_get_profile_object_type_template(self) -> "Profile":
        '''(experimental) Grants permission to get a specific object type template.

        Access Level: Read

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetProfileObjectTypeTemplate.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toGetProfileObjectTypeTemplate", []))

    @jsii.member(jsii_name="toGetWorkflow")
    def to_get_workflow(self) -> "Profile":
        '''(experimental) Grants permission to get workflow details in a domain.

        Access Level: Read

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetWorkflow.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toGetWorkflow", []))

    @jsii.member(jsii_name="toGetWorkflowSteps")
    def to_get_workflow_steps(self) -> "Profile":
        '''(experimental) Grants permission to get workflow step details in a domain.

        Access Level: Read

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetWorkflowSteps.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toGetWorkflowSteps", []))

    @jsii.member(jsii_name="toListAccountIntegrations")
    def to_list_account_integrations(self) -> "Profile":
        '''(experimental) Grants permission to list all the integrations in the account.

        Access Level: List

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListAccountIntegrations.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toListAccountIntegrations", []))

    @jsii.member(jsii_name="toListDomains")
    def to_list_domains(self) -> "Profile":
        '''(experimental) Grants permission to list all the domains in an account.

        Access Level: List

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListDomains.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toListDomains", []))

    @jsii.member(jsii_name="toListIdentityResolutionJobs")
    def to_list_identity_resolution_jobs(self) -> "Profile":
        '''(experimental) Grants permission to list identity resolution jobs in a domain.

        Access Level: List

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListIdentityResolutionJobs.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toListIdentityResolutionJobs", []))

    @jsii.member(jsii_name="toListIntegrations")
    def to_list_integrations(self) -> "Profile":
        '''(experimental) Grants permission to list all the integrations in a specific domain.

        Access Level: List

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListIntegrations.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toListIntegrations", []))

    @jsii.member(jsii_name="toListProfileObjects")
    def to_list_profile_objects(self) -> "Profile":
        '''(experimental) Grants permission to list all the profile objects for a profile.

        Access Level: List

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListProfileObjects.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toListProfileObjects", []))

    @jsii.member(jsii_name="toListProfileObjectTypes")
    def to_list_profile_object_types(self) -> "Profile":
        '''(experimental) Grants permission to list all the profile object types in the domain.

        Access Level: List

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListProfileObjectTypes.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toListProfileObjectTypes", []))

    @jsii.member(jsii_name="toListProfileObjectTypeTemplates")
    def to_list_profile_object_type_templates(self) -> "Profile":
        '''(experimental) Grants permission to list all the profile object type templates in the account.

        Access Level: List

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListProfileObjectTypeTemplates.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toListProfileObjectTypeTemplates", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Profile":
        '''(experimental) Grants permission to list tags for a resource.

        Access Level: Read

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toListWorkflows")
    def to_list_workflows(self) -> "Profile":
        '''(experimental) Grants permission to list all the workflows in a specific domain.

        Access Level: List

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_ListWorkflows.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toListWorkflows", []))

    @jsii.member(jsii_name="toMergeProfiles")
    def to_merge_profiles(self) -> "Profile":
        '''(experimental) Grants permission to merge profiles in a domain.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_MergeProfiles.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toMergeProfiles", []))

    @jsii.member(jsii_name="toPutIntegration")
    def to_put_integration(self) -> "Profile":
        '''(experimental) Grants permission to put a integration in a domain.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_PutIntegration.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toPutIntegration", []))

    @jsii.member(jsii_name="toPutProfileObject")
    def to_put_profile_object(self) -> "Profile":
        '''(experimental) Grants permission to put an object for a profile.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_PutProfileObject.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toPutProfileObject", []))

    @jsii.member(jsii_name="toPutProfileObjectType")
    def to_put_profile_object_type(self) -> "Profile":
        '''(experimental) Grants permission to put a specific profile object type in the domain.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_PutProfileObjectType.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toPutProfileObjectType", []))

    @jsii.member(jsii_name="toSearchProfiles")
    def to_search_profiles(self) -> "Profile":
        '''(experimental) Grants permission to search for profiles in a domain.

        Access Level: Read

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toSearchProfiles", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Profile":
        '''(experimental) Grants permission to adds tags to a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Profile":
        '''(experimental) Grants permission to remove tags from a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateDomain")
    def to_update_domain(self) -> "Profile":
        '''(experimental) Grants permission to update a Domain.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toUpdateDomain", []))

    @jsii.member(jsii_name="toUpdateProfile")
    def to_update_profile(self) -> "Profile":
        '''(experimental) Grants permission to update a profile in the domain.

        Access Level: Write

        https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateProfile.html

        :stability: experimental
        '''
        return typing.cast("Profile", jsii.invoke(self, "toUpdateProfile", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8de96bf088ad2cdd56f1d21c7157755e743c135fafdecd7aacd5c6c4ab78d343)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc376c9fb3f9712d79afc10768d730afc00a2a6d3cd6be4bbe6ac08b057cc4ae)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Proton(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Proton"):
    '''(experimental) Statement provider for service `proton <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsproton.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `proton <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsproton.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da733e70a4a0a10536c0f8047bd23dd6ae98ac9a0f27e8feb682fb24558e2a0b)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="ifEnvironmentTemplate")
    def if_environment_template(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Proton":
        '''(experimental) Filters access by specified environment template related to resource.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html

        Applies to actions:

        - .toCancelEnvironmentDeployment()
        - .toCreateEnvironment()
        - .toDeleteEnvironment()
        - .toUpdateEnvironment()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__be7736f36cca90930baf87c7d52e2937052928cfd1aa3ec51e99441f5b6d7c04)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Proton", jsii.invoke(self, "ifEnvironmentTemplate", [value, operator]))

    @jsii.member(jsii_name="ifServiceTemplate")
    def if_service_template(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Proton":
        '''(experimental) Filters access by specified service template related to resource.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html

        Applies to actions:

        - .toCancelServiceInstanceDeployment()
        - .toCancelServicePipelineDeployment()
        - .toCreateService()
        - .toDeleteService()
        - .toUpdateService()
        - .toUpdateServiceInstance()
        - .toUpdateServicePipeline()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8eefc3c2db58084a8f6f8f4ee64cba3860fbb63fc0612d037dea70b83946c28e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Proton", jsii.invoke(self, "ifServiceTemplate", [value, operator]))

    @jsii.member(jsii_name="onComponent")
    def on_component(
        self,
        id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type component to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html

        :param id: - Identifier for the id.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d3d44f3d30515fe9165f4974d8304863fac8510b653e5d02610f03073a30d7ef)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onComponent", [id, account, region, partition]))

    @jsii.member(jsii_name="onEnvironment")
    def on_environment(
        self,
        name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type environment to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html

        :param name: - Identifier for the name.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4aca36f626e2a0310264fb01cd6ecc3758715d2bec0aeaf8362f645b2496ad9c)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onEnvironment", [name, account, region, partition]))

    @jsii.member(jsii_name="onEnvironmentAccountConnection")
    def on_environment_account_connection(
        self,
        id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type environment-account-connection to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html

        :param id: - Identifier for the id.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e2b54ea363fde1814fd37da12b5325dea3e41c9c9f248f2197d189a80660d0ab)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onEnvironmentAccountConnection", [id, account, region, partition]))

    @jsii.member(jsii_name="onEnvironmentTemplate")
    def on_environment_template(
        self,
        name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type environment-template to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html

        :param name: - Identifier for the name.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e8d551f8b2c9bff21b9d394e36754a6898ed64a862c1bc84da16cd6d9d5f868)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onEnvironmentTemplate", [name, account, region, partition]))

    @jsii.member(jsii_name="onEnvironmentTemplateMajorVersion")
    def on_environment_template_major_version(
        self,
        template_name: builtins.str,
        major_version_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type environment-template-major-version to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html

        :param template_name: - Identifier for the templateName.
        :param major_version_id: - Identifier for the majorVersionId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__23fa43f9708b3e612ec1f30219519aebd3ee321715f4631d31b24611266c637c)
            check_type(argname="argument template_name", value=template_name, expected_type=type_hints["template_name"])
            check_type(argname="argument major_version_id", value=major_version_id, expected_type=type_hints["major_version_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onEnvironmentTemplateMajorVersion", [template_name, major_version_id, account, region, partition]))

    @jsii.member(jsii_name="onEnvironmentTemplateMinorVersion")
    def on_environment_template_minor_version(
        self,
        template_name: builtins.str,
        major_version_id: builtins.str,
        minor_version_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type environment-template-minor-version to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html

        :param template_name: - Identifier for the templateName.
        :param major_version_id: - Identifier for the majorVersionId.
        :param minor_version_id: - Identifier for the minorVersionId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59ed0642dae84025ce09bfab1cf8669defd3fec2740c76f11bd318d51cfe7b1a)
            check_type(argname="argument template_name", value=template_name, expected_type=type_hints["template_name"])
            check_type(argname="argument major_version_id", value=major_version_id, expected_type=type_hints["major_version_id"])
            check_type(argname="argument minor_version_id", value=minor_version_id, expected_type=type_hints["minor_version_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onEnvironmentTemplateMinorVersion", [template_name, major_version_id, minor_version_id, account, region, partition]))

    @jsii.member(jsii_name="onEnvironmentTemplateVersion")
    def on_environment_template_version(
        self,
        template_name: builtins.str,
        major_version: builtins.str,
        minor_version: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type environment-template-version to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html

        :param template_name: - Identifier for the templateName.
        :param major_version: - Identifier for the majorVersion.
        :param minor_version: - Identifier for the minorVersion.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d15bd90109b94b8ddf415397f12086a685ff4845eea4b7d355128dfa510f5cd)
            check_type(argname="argument template_name", value=template_name, expected_type=type_hints["template_name"])
            check_type(argname="argument major_version", value=major_version, expected_type=type_hints["major_version"])
            check_type(argname="argument minor_version", value=minor_version, expected_type=type_hints["minor_version"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onEnvironmentTemplateVersion", [template_name, major_version, minor_version, account, region, partition]))

    @jsii.member(jsii_name="onRepository")
    def on_repository(
        self,
        provider: builtins.str,
        name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type repository to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/ag-repositories.html

        :param provider: - Identifier for the provider.
        :param name: - Identifier for the name.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a01052690b69d7777122b583d9650c9eb73318c833608f3f871d769a5183ae4)
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onRepository", [provider, name, account, region, partition]))

    @jsii.member(jsii_name="onService")
    def on_service(
        self,
        name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type service to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html

        :param name: - Identifier for the name.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f540a5856197c1ceb5e96b1b44d34e89510fb2046fe54673f4718d8806af0eff)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onService", [name, account, region, partition]))

    @jsii.member(jsii_name="onServiceInstance")
    def on_service_instance(
        self,
        service_name: builtins.str,
        name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type service-instance to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html

        :param service_name: - Identifier for the serviceName.
        :param name: - Identifier for the name.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__79a3763da14e4bfef0603fd97233cd4cfebc2ef539a026bdf42cb21472605a00)
            check_type(argname="argument service_name", value=service_name, expected_type=type_hints["service_name"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onServiceInstance", [service_name, name, account, region, partition]))

    @jsii.member(jsii_name="onServiceTemplate")
    def on_service_template(
        self,
        name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type service-template to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html

        :param name: - Identifier for the name.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__622a876e53d64a2a42e103a62ec303c762bd726ed0d2c788e582eb1708e37171)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onServiceTemplate", [name, account, region, partition]))

    @jsii.member(jsii_name="onServiceTemplateMajorVersion")
    def on_service_template_major_version(
        self,
        template_name: builtins.str,
        major_version_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type service-template-major-version to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html

        :param template_name: - Identifier for the templateName.
        :param major_version_id: - Identifier for the majorVersionId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cff747f8581e3b066f0bd127cdea7af3c22729d5c75422f663a27d6f0ba5d67e)
            check_type(argname="argument template_name", value=template_name, expected_type=type_hints["template_name"])
            check_type(argname="argument major_version_id", value=major_version_id, expected_type=type_hints["major_version_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onServiceTemplateMajorVersion", [template_name, major_version_id, account, region, partition]))

    @jsii.member(jsii_name="onServiceTemplateMinorVersion")
    def on_service_template_minor_version(
        self,
        template_name: builtins.str,
        major_version_id: builtins.str,
        minor_version_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type service-template-minor-version to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html

        :param template_name: - Identifier for the templateName.
        :param major_version_id: - Identifier for the majorVersionId.
        :param minor_version_id: - Identifier for the minorVersionId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__681bc8434a298a5aa7662ed6fdcececc138710a293a5b06c0098cf1d93ac2b1a)
            check_type(argname="argument template_name", value=template_name, expected_type=type_hints["template_name"])
            check_type(argname="argument major_version_id", value=major_version_id, expected_type=type_hints["major_version_id"])
            check_type(argname="argument minor_version_id", value=minor_version_id, expected_type=type_hints["minor_version_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onServiceTemplateMinorVersion", [template_name, major_version_id, minor_version_id, account, region, partition]))

    @jsii.member(jsii_name="onServiceTemplateVersion")
    def on_service_template_version(
        self,
        template_name: builtins.str,
        major_version: builtins.str,
        minor_version: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Proton":
        '''(experimental) Adds a resource of type service-template-version to the statement.

        https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html

        :param template_name: - Identifier for the templateName.
        :param major_version: - Identifier for the majorVersion.
        :param minor_version: - Identifier for the minorVersion.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e70a3757f3f0596fde80409352bea07e6c40e5499bd4dc96408e1a5a2ffe102f)
            check_type(argname="argument template_name", value=template_name, expected_type=type_hints["template_name"])
            check_type(argname="argument major_version", value=major_version, expected_type=type_hints["major_version"])
            check_type(argname="argument minor_version", value=minor_version, expected_type=type_hints["minor_version"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Proton", jsii.invoke(self, "onServiceTemplateVersion", [template_name, major_version, minor_version, account, region, partition]))

    @jsii.member(jsii_name="toAcceptEnvironmentAccountConnection")
    def to_accept_environment_account_connection(self) -> "Proton":
        '''(experimental) Grants permission to reject an environment account connection request from another environment account.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_AcceptEnvironmentAccountConnection.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toAcceptEnvironmentAccountConnection", []))

    @jsii.member(jsii_name="toCancelComponentDeployment")
    def to_cancel_component_deployment(self) -> "Proton":
        '''(experimental) Grants permission to cancel component deployment.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelComponentDeployment.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCancelComponentDeployment", []))

    @jsii.member(jsii_name="toCancelEnvironmentDeployment")
    def to_cancel_environment_deployment(self) -> "Proton":
        '''(experimental) Grants permission to cancel an environment deployment.

        Access Level: Write

        Possible conditions:

        - .ifEnvironmentTemplate()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelEnvironmentDeployment.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCancelEnvironmentDeployment", []))

    @jsii.member(jsii_name="toCancelServiceInstanceDeployment")
    def to_cancel_service_instance_deployment(self) -> "Proton":
        '''(experimental) Grants permission to cancel a service instance deployment.

        Access Level: Write

        Possible conditions:

        - .ifServiceTemplate()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelServiceInstanceDeployment.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCancelServiceInstanceDeployment", []))

    @jsii.member(jsii_name="toCancelServicePipelineDeployment")
    def to_cancel_service_pipeline_deployment(self) -> "Proton":
        '''(experimental) Grants permission to cancel a service pipeline deployment.

        Access Level: Write

        Possible conditions:

        - .ifServiceTemplate()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelServicePipelineDeployment.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCancelServicePipelineDeployment", []))

    @jsii.member(jsii_name="toCreateComponent")
    def to_create_component(self) -> "Proton":
        '''(experimental) Grants permission to create component.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateComponent.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateComponent", []))

    @jsii.member(jsii_name="toCreateEnvironment")
    def to_create_environment(self) -> "Proton":
        '''(experimental) Grants permission to create an environment.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()
        - .ifEnvironmentTemplate()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironment.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateEnvironment", []))

    @jsii.member(jsii_name="toCreateEnvironmentAccountConnection")
    def to_create_environment_account_connection(self) -> "Proton":
        '''(experimental) Grants permission to create an environment account connection.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentAccountConnection.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateEnvironmentAccountConnection", []))

    @jsii.member(jsii_name="toCreateEnvironmentTemplate")
    def to_create_environment_template(self) -> "Proton":
        '''(experimental) Grants permission to create an environment template.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplate.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateEnvironmentTemplate", []))

    @jsii.member(jsii_name="toCreateEnvironmentTemplateMajorVersion")
    def to_create_environment_template_major_version(self) -> "Proton":
        '''(experimental) Grants permission to create an environment template major version. DEPRECATED - use CreateEnvironmentTemplateVersion instead.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplateMajorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateEnvironmentTemplateMajorVersion", []))

    @jsii.member(jsii_name="toCreateEnvironmentTemplateMinorVersion")
    def to_create_environment_template_minor_version(self) -> "Proton":
        '''(experimental) Grants permission to create an environment template minor version. DEPRECATED - use CreateEnvironmentTemplateVersion instead.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplateMinorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateEnvironmentTemplateMinorVersion", []))

    @jsii.member(jsii_name="toCreateEnvironmentTemplateVersion")
    def to_create_environment_template_version(self) -> "Proton":
        '''(experimental) Grants permission to create an environment template version.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplateVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateEnvironmentTemplateVersion", []))

    @jsii.member(jsii_name="toCreateRepository")
    def to_create_repository(self) -> "Proton":
        '''(experimental) Grants permission to create a repository.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateRepository.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateRepository", []))

    @jsii.member(jsii_name="toCreateService")
    def to_create_service(self) -> "Proton":
        '''(experimental) Grants permission to create a service.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()
        - .ifServiceTemplate()

        Dependent actions:

        - codestar-connections:PassConnection

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateService.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateService", []))

    @jsii.member(jsii_name="toCreateServiceTemplate")
    def to_create_service_template(self) -> "Proton":
        '''(experimental) Grants permission to create a service template.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplate.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateServiceTemplate", []))

    @jsii.member(jsii_name="toCreateServiceTemplateMajorVersion")
    def to_create_service_template_major_version(self) -> "Proton":
        '''(experimental) Grants permission to create a service template major version. DEPRECATED - use CreateServiceTemplateVersion instead.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplateMajorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateServiceTemplateMajorVersion", []))

    @jsii.member(jsii_name="toCreateServiceTemplateMinorVersion")
    def to_create_service_template_minor_version(self) -> "Proton":
        '''(experimental) Grants permission to create a service template minor version. DEPRECATED - use CreateServiceTemplateVersion instead.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplateMinorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateServiceTemplateMinorVersion", []))

    @jsii.member(jsii_name="toCreateServiceTemplateVersion")
    def to_create_service_template_version(self) -> "Proton":
        '''(experimental) Grants permission to create a service template version.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplateVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateServiceTemplateVersion", []))

    @jsii.member(jsii_name="toCreateTemplateSyncConfig")
    def to_create_template_sync_config(self) -> "Proton":
        '''(experimental) Grants permission to create a template sync config.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateTemplateSyncConfig.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toCreateTemplateSyncConfig", []))

    @jsii.member(jsii_name="toDeleteAccountRoles")
    def to_delete_account_roles(self) -> "Proton":
        '''(experimental) Grants permission to delete account roles. DEPRECATED - use UpdateAccountSettings instead.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteAccountRoles.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteAccountRoles", []))

    @jsii.member(jsii_name="toDeleteComponent")
    def to_delete_component(self) -> "Proton":
        '''(experimental) Grants permission to delete component.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteComponent.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteComponent", []))

    @jsii.member(jsii_name="toDeleteEnvironment")
    def to_delete_environment(self) -> "Proton":
        '''(experimental) Grants permission to delete an environment.

        Access Level: Write

        Possible conditions:

        - .ifEnvironmentTemplate()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironment.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteEnvironment", []))

    @jsii.member(jsii_name="toDeleteEnvironmentAccountConnection")
    def to_delete_environment_account_connection(self) -> "Proton":
        '''(experimental) Grants permission to delete an environment account connection.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentAccountConnection.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteEnvironmentAccountConnection", []))

    @jsii.member(jsii_name="toDeleteEnvironmentTemplate")
    def to_delete_environment_template(self) -> "Proton":
        '''(experimental) Grants permission to delete an environment template.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplate.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteEnvironmentTemplate", []))

    @jsii.member(jsii_name="toDeleteEnvironmentTemplateMajorVersion")
    def to_delete_environment_template_major_version(self) -> "Proton":
        '''(experimental) Grants permission to delete an environment template major version. DEPRECATED - use DeleteEnvironmentTemplateVersion instead.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplateMajorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteEnvironmentTemplateMajorVersion", []))

    @jsii.member(jsii_name="toDeleteEnvironmentTemplateMinorVersion")
    def to_delete_environment_template_minor_version(self) -> "Proton":
        '''(experimental) Grants permission to delete an environment template minor version. DEPRECATED - use DeleteEnvironmentTemplateVersion instead.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplateMinorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteEnvironmentTemplateMinorVersion", []))

    @jsii.member(jsii_name="toDeleteEnvironmentTemplateVersion")
    def to_delete_environment_template_version(self) -> "Proton":
        '''(experimental) Grants permission to delete an environment template version.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplateVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteEnvironmentTemplateVersion", []))

    @jsii.member(jsii_name="toDeleteRepository")
    def to_delete_repository(self) -> "Proton":
        '''(experimental) Grants permission to delete a repository.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteRepository.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteRepository", []))

    @jsii.member(jsii_name="toDeleteService")
    def to_delete_service(self) -> "Proton":
        '''(experimental) Grants permission to delete a service.

        Access Level: Write

        Possible conditions:

        - .ifServiceTemplate()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteService.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteService", []))

    @jsii.member(jsii_name="toDeleteServiceTemplate")
    def to_delete_service_template(self) -> "Proton":
        '''(experimental) Grants permission to delete a service template.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplate.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteServiceTemplate", []))

    @jsii.member(jsii_name="toDeleteServiceTemplateMajorVersion")
    def to_delete_service_template_major_version(self) -> "Proton":
        '''(experimental) Grants permission to delete a service template major version. DEPRECATED - use DeleteServiceTemplateVersion instead.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplateMajorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteServiceTemplateMajorVersion", []))

    @jsii.member(jsii_name="toDeleteServiceTemplateMinorVersion")
    def to_delete_service_template_minor_version(self) -> "Proton":
        '''(experimental) Grants permission to delete a service template minor version. DEPRECATED - use DeleteServiceTemplateVersion instead.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplateMinorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteServiceTemplateMinorVersion", []))

    @jsii.member(jsii_name="toDeleteServiceTemplateVersion")
    def to_delete_service_template_version(self) -> "Proton":
        '''(experimental) Grants permission to delete a service template version.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplateVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteServiceTemplateVersion", []))

    @jsii.member(jsii_name="toDeleteTemplateSyncConfig")
    def to_delete_template_sync_config(self) -> "Proton":
        '''(experimental) Grants permission to delete a TemplateSyncConfig.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteTemplateSyncConfig.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toDeleteTemplateSyncConfig", []))

    @jsii.member(jsii_name="toGetAccountRoles")
    def to_get_account_roles(self) -> "Proton":
        '''(experimental) Grants permission to get account roles. DEPRECATED - use GetAccountSettings instead.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetAccountRoles.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetAccountRoles", []))

    @jsii.member(jsii_name="toGetAccountSettings")
    def to_get_account_settings(self) -> "Proton":
        '''(experimental) Grants permission to describe the account settings.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetAccountSettings.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetAccountSettings", []))

    @jsii.member(jsii_name="toGetComponent")
    def to_get_component(self) -> "Proton":
        '''(experimental) Grants permission to describe a component.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetComponent.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetComponent", []))

    @jsii.member(jsii_name="toGetEnvironment")
    def to_get_environment(self) -> "Proton":
        '''(experimental) Grants permission to describe an environment.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironment.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetEnvironment", []))

    @jsii.member(jsii_name="toGetEnvironmentAccountConnection")
    def to_get_environment_account_connection(self) -> "Proton":
        '''(experimental) Grants permission to describe an environment account connection.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentAccountConnection.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetEnvironmentAccountConnection", []))

    @jsii.member(jsii_name="toGetEnvironmentTemplate")
    def to_get_environment_template(self) -> "Proton":
        '''(experimental) Grants permission to describe an environment template.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplate.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetEnvironmentTemplate", []))

    @jsii.member(jsii_name="toGetEnvironmentTemplateMajorVersion")
    def to_get_environment_template_major_version(self) -> "Proton":
        '''(experimental) Grants permission to get an environment template major version. DEPRECATED - use GetEnvironmentTemplateVersion instead.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplateMajorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetEnvironmentTemplateMajorVersion", []))

    @jsii.member(jsii_name="toGetEnvironmentTemplateMinorVersion")
    def to_get_environment_template_minor_version(self) -> "Proton":
        '''(experimental) Grants permission to get an environment template minor version. DEPRECATED - use GetEnvironmentTemplateVersion instead.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplateMinorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetEnvironmentTemplateMinorVersion", []))

    @jsii.member(jsii_name="toGetEnvironmentTemplateVersion")
    def to_get_environment_template_version(self) -> "Proton":
        '''(experimental) Grants permission to describe an environment template version.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplateVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetEnvironmentTemplateVersion", []))

    @jsii.member(jsii_name="toGetRepository")
    def to_get_repository(self) -> "Proton":
        '''(experimental) Grants permission to describe a repository.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetRepository.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetRepository", []))

    @jsii.member(jsii_name="toGetRepositorySyncStatus")
    def to_get_repository_sync_status(self) -> "Proton":
        '''(experimental) Grants permission to get the latest sync status for a repository.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetRepositorySyncStatus.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetRepositorySyncStatus", []))

    @jsii.member(jsii_name="toGetResourcesSummary")
    def to_get_resources_summary(self) -> "Proton":
        '''(experimental) Grants permission to get resources summary.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetResourcesSummary.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetResourcesSummary", []))

    @jsii.member(jsii_name="toGetResourceTemplateVersionStatusCounts")
    def to_get_resource_template_version_status_counts(self) -> "Proton":
        '''(experimental) Grants permission to list resource template version status counts.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetResourceTemplateVersionStatusCounts.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetResourceTemplateVersionStatusCounts", []))

    @jsii.member(jsii_name="toGetService")
    def to_get_service(self) -> "Proton":
        '''(experimental) Grants permission to describe a service.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetService.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetService", []))

    @jsii.member(jsii_name="toGetServiceInstance")
    def to_get_service_instance(self) -> "Proton":
        '''(experimental) Grants permission to describe a service instance.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceInstance.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetServiceInstance", []))

    @jsii.member(jsii_name="toGetServiceTemplate")
    def to_get_service_template(self) -> "Proton":
        '''(experimental) Grants permission to describe a service template.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplate.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetServiceTemplate", []))

    @jsii.member(jsii_name="toGetServiceTemplateMajorVersion")
    def to_get_service_template_major_version(self) -> "Proton":
        '''(experimental) Grants permission to get a service template major version. DEPRECATED - use GetServiceTemplateVersion instead.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplateMajorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetServiceTemplateMajorVersion", []))

    @jsii.member(jsii_name="toGetServiceTemplateMinorVersion")
    def to_get_service_template_minor_version(self) -> "Proton":
        '''(experimental) Grants permission to get a service template minor version. DEPRECATED - use GetServiceTemplateVersion instead.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplateMinorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetServiceTemplateMinorVersion", []))

    @jsii.member(jsii_name="toGetServiceTemplateVersion")
    def to_get_service_template_version(self) -> "Proton":
        '''(experimental) Grants permission to describe a service template version.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplateVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetServiceTemplateVersion", []))

    @jsii.member(jsii_name="toGetTemplateSyncConfig")
    def to_get_template_sync_config(self) -> "Proton":
        '''(experimental) Grants permission to describe a TemplateSyncConfig.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetTemplateSyncConfig.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetTemplateSyncConfig", []))

    @jsii.member(jsii_name="toGetTemplateSyncStatus")
    def to_get_template_sync_status(self) -> "Proton":
        '''(experimental) Grants permission to describe the sync status of a template.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_GetTemplateSyncStatus.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toGetTemplateSyncStatus", []))

    @jsii.member(jsii_name="toListComponentOutputs")
    def to_list_component_outputs(self) -> "Proton":
        '''(experimental) Grants permission to list component outputs.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListComponentOutputs.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListComponentOutputs", []))

    @jsii.member(jsii_name="toListComponentProvisionedResources")
    def to_list_component_provisioned_resources(self) -> "Proton":
        '''(experimental) Grants permission to list component provisioned resources.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListComponentProvisionedResources.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListComponentProvisionedResources", []))

    @jsii.member(jsii_name="toListComponents")
    def to_list_components(self) -> "Proton":
        '''(experimental) Grants permission to list components.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListComponents.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListComponents", []))

    @jsii.member(jsii_name="toListEnvironmentAccountConnections")
    def to_list_environment_account_connections(self) -> "Proton":
        '''(experimental) Grants permission to list environment account connections.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentAccountConnections.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListEnvironmentAccountConnections", []))

    @jsii.member(jsii_name="toListEnvironmentOutputs")
    def to_list_environment_outputs(self) -> "Proton":
        '''(experimental) Grants permission to list environment outputs.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentOutputs.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListEnvironmentOutputs", []))

    @jsii.member(jsii_name="toListEnvironmentProvisionedResources")
    def to_list_environment_provisioned_resources(self) -> "Proton":
        '''(experimental) Grants permission to list environment provisioned resources.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentProvisionedResources.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListEnvironmentProvisionedResources", []))

    @jsii.member(jsii_name="toListEnvironments")
    def to_list_environments(self) -> "Proton":
        '''(experimental) Grants permission to list environments.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironments.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListEnvironments", []))

    @jsii.member(jsii_name="toListEnvironmentTemplateMajorVersions")
    def to_list_environment_template_major_versions(self) -> "Proton":
        '''(experimental) Grants permission to list environment template major versions. DEPRECATED - use ListEnvironmentTemplateVersions instead.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplateMajorVersions.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListEnvironmentTemplateMajorVersions", []))

    @jsii.member(jsii_name="toListEnvironmentTemplateMinorVersions")
    def to_list_environment_template_minor_versions(self) -> "Proton":
        '''(experimental) Grants permission to list an environment template minor versions. DEPRECATED - use ListEnvironmentTemplateVersions instead.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplateMinorVersions.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListEnvironmentTemplateMinorVersions", []))

    @jsii.member(jsii_name="toListEnvironmentTemplates")
    def to_list_environment_templates(self) -> "Proton":
        '''(experimental) Grants permission to list environment templates.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplates.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListEnvironmentTemplates", []))

    @jsii.member(jsii_name="toListEnvironmentTemplateVersions")
    def to_list_environment_template_versions(self) -> "Proton":
        '''(experimental) Grants permission to list environment template versions.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplateVersions.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListEnvironmentTemplateVersions", []))

    @jsii.member(jsii_name="toListRepositories")
    def to_list_repositories(self) -> "Proton":
        '''(experimental) Grants permission to list repositories.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListRepositories.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListRepositories", []))

    @jsii.member(jsii_name="toListRepositorySyncDefinitions")
    def to_list_repository_sync_definitions(self) -> "Proton":
        '''(experimental) Grants permission to list repository sync definitions.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListRepositorySyncDefinitions.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListRepositorySyncDefinitions", []))

    @jsii.member(jsii_name="toListServiceInstanceOutputs")
    def to_list_service_instance_outputs(self) -> "Proton":
        '''(experimental) Grants permission to list service instance outputs.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceInstanceOutputs.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListServiceInstanceOutputs", []))

    @jsii.member(jsii_name="toListServiceInstanceProvisionedResources")
    def to_list_service_instance_provisioned_resources(self) -> "Proton":
        '''(experimental) Grants permission to list service instance provisioned resources.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceInstanceProvisionedResources.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListServiceInstanceProvisionedResources", []))

    @jsii.member(jsii_name="toListServiceInstances")
    def to_list_service_instances(self) -> "Proton":
        '''(experimental) Grants permission to list service instances.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceInstances.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListServiceInstances", []))

    @jsii.member(jsii_name="toListServicePipelineOutputs")
    def to_list_service_pipeline_outputs(self) -> "Proton":
        '''(experimental) Grants permission to list service pipeline outputs.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServicePipelineOutputs.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListServicePipelineOutputs", []))

    @jsii.member(jsii_name="toListServicePipelineProvisionedResources")
    def to_list_service_pipeline_provisioned_resources(self) -> "Proton":
        '''(experimental) Grants permission to list service pipeline provisioned resources.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServicePipelineProvisionedResources.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListServicePipelineProvisionedResources", []))

    @jsii.member(jsii_name="toListServices")
    def to_list_services(self) -> "Proton":
        '''(experimental) Grants permission to list services.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServices.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListServices", []))

    @jsii.member(jsii_name="toListServiceTemplateMajorVersions")
    def to_list_service_template_major_versions(self) -> "Proton":
        '''(experimental) Grants permission to list service template major versions. DEPRECATED - use ListServiceTemplateVersions instead.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplateMajorVersions.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListServiceTemplateMajorVersions", []))

    @jsii.member(jsii_name="toListServiceTemplateMinorVersions")
    def to_list_service_template_minor_versions(self) -> "Proton":
        '''(experimental) Grants permission to list service template minor versions. DEPRECATED - use ListServiceTemplateVersions instead.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplateMinorVersions.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListServiceTemplateMinorVersions", []))

    @jsii.member(jsii_name="toListServiceTemplates")
    def to_list_service_templates(self) -> "Proton":
        '''(experimental) Grants permission to list service templates.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplates.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListServiceTemplates", []))

    @jsii.member(jsii_name="toListServiceTemplateVersions")
    def to_list_service_template_versions(self) -> "Proton":
        '''(experimental) Grants permission to list service template versions.

        Access Level: List

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplateVersions.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListServiceTemplateVersions", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Proton":
        '''(experimental) Grants permission to list tags of a resource.

        Access Level: Read

        https://docs.aws.amazon.com/proton/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toNotifyResourceDeploymentStatusChange")
    def to_notify_resource_deployment_status_change(self) -> "Proton":
        '''(experimental) Grants permission to notify Proton of resource deployment status changes.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_NotifyResourceDeploymentStatusChange.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toNotifyResourceDeploymentStatusChange", []))

    @jsii.member(jsii_name="toRejectEnvironmentAccountConnection")
    def to_reject_environment_account_connection(self) -> "Proton":
        '''(experimental) Grants permission to reject an environment account connection request from another environment account.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_RejectEnvironmentAccountConnection.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toRejectEnvironmentAccountConnection", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Proton":
        '''(experimental) Grants permission to add tags to a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Proton":
        '''(experimental) Grants permission to remove tags from a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateAccountRoles")
    def to_update_account_roles(self) -> "Proton":
        '''(experimental) Grants permission to update account roles. DEPRECATED - use UpdateAccountSettings instead.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateAccountRoles.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateAccountRoles", []))

    @jsii.member(jsii_name="toUpdateAccountSettings")
    def to_update_account_settings(self) -> "Proton":
        '''(experimental) Grants permission to update the account settings.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateAccountSettings.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateAccountSettings", []))

    @jsii.member(jsii_name="toUpdateComponent")
    def to_update_component(self) -> "Proton":
        '''(experimental) Grants permission to update component.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateComponent.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateComponent", []))

    @jsii.member(jsii_name="toUpdateEnvironment")
    def to_update_environment(self) -> "Proton":
        '''(experimental) Grants permission to update an environment.

        Access Level: Write

        Possible conditions:

        - .ifEnvironmentTemplate()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironment.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateEnvironment", []))

    @jsii.member(jsii_name="toUpdateEnvironmentAccountConnection")
    def to_update_environment_account_connection(self) -> "Proton":
        '''(experimental) Grants permission to update an environment account connection.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentAccountConnection.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateEnvironmentAccountConnection", []))

    @jsii.member(jsii_name="toUpdateEnvironmentTemplate")
    def to_update_environment_template(self) -> "Proton":
        '''(experimental) Grants permission to update an environment template.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplate.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateEnvironmentTemplate", []))

    @jsii.member(jsii_name="toUpdateEnvironmentTemplateMajorVersion")
    def to_update_environment_template_major_version(self) -> "Proton":
        '''(experimental) Grants permission to update an environment template major version. DEPRECATED - use UpdateEnvironmentTemplateVersion instead.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplateMajorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateEnvironmentTemplateMajorVersion", []))

    @jsii.member(jsii_name="toUpdateEnvironmentTemplateMinorVersion")
    def to_update_environment_template_minor_version(self) -> "Proton":
        '''(experimental) Grants permission to update an environment template minor version. DEPRECATED - use UpdateEnvironmentTemplateVersion instead.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplateMinorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateEnvironmentTemplateMinorVersion", []))

    @jsii.member(jsii_name="toUpdateEnvironmentTemplateVersion")
    def to_update_environment_template_version(self) -> "Proton":
        '''(experimental) Grants permission to update an environment template version.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplateVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateEnvironmentTemplateVersion", []))

    @jsii.member(jsii_name="toUpdateService")
    def to_update_service(self) -> "Proton":
        '''(experimental) Grants permission to update a service.

        Access Level: Write

        Possible conditions:

        - .ifServiceTemplate()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateService.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateService", []))

    @jsii.member(jsii_name="toUpdateServiceInstance")
    def to_update_service_instance(self) -> "Proton":
        '''(experimental) Grants permission to update a service instance.

        Access Level: Write

        Possible conditions:

        - .ifServiceTemplate()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceInstance.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateServiceInstance", []))

    @jsii.member(jsii_name="toUpdateServicePipeline")
    def to_update_service_pipeline(self) -> "Proton":
        '''(experimental) Grants permission to update a service pipeline.

        Access Level: Write

        Possible conditions:

        - .ifServiceTemplate()

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServicePipeline.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateServicePipeline", []))

    @jsii.member(jsii_name="toUpdateServiceTemplate")
    def to_update_service_template(self) -> "Proton":
        '''(experimental) Grants permission to update a service template.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplate.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateServiceTemplate", []))

    @jsii.member(jsii_name="toUpdateServiceTemplateMajorVersion")
    def to_update_service_template_major_version(self) -> "Proton":
        '''(experimental) Grants permission to update a service template major version. DEPRECATED - use UpdateServiceTemplateVersion instead.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplateMajorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateServiceTemplateMajorVersion", []))

    @jsii.member(jsii_name="toUpdateServiceTemplateMinorVersion")
    def to_update_service_template_minor_version(self) -> "Proton":
        '''(experimental) Grants permission to create a service template minor version. DEPRECATED - use UpdateServiceTemplateVersion instead.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplateMinorVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateServiceTemplateMinorVersion", []))

    @jsii.member(jsii_name="toUpdateServiceTemplateVersion")
    def to_update_service_template_version(self) -> "Proton":
        '''(experimental) Grants permission to update a service template version.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplateVersion.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateServiceTemplateVersion", []))

    @jsii.member(jsii_name="toUpdateTemplateSyncConfig")
    def to_update_template_sync_config(self) -> "Proton":
        '''(experimental) Grants permission to update a TemplateSyncConfig.

        Access Level: Write

        https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateTemplateSyncConfig.html

        :stability: experimental
        '''
        return typing.cast("Proton", jsii.invoke(self, "toUpdateTemplateSyncConfig", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f640ecdb5a51cacdd64ff56687850fc6fb4a2390a917406f55453b87d395d090)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bcd3df32ca3a946e1603394b45c7ad1d717cbf82473fe01a857965284ade29ce)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class PurchaseOrders(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.PurchaseOrders",
):
    '''(experimental) Statement provider for service `purchase-orders <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspurchaseordersconsole.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `purchase-orders <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspurchaseordersconsole.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0be9de5f32d9ffa6b31d1f77ba93ceef5666584191a68a546dc47752ba3fb6c7)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="toAddPurchaseOrder")
    def to_add_purchase_order(self) -> "PurchaseOrders":
        '''(experimental) Allow or deny IAM users permission to add a new purchase order.

        Access Level: Write

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        :stability: experimental
        '''
        return typing.cast("PurchaseOrders", jsii.invoke(self, "toAddPurchaseOrder", []))

    @jsii.member(jsii_name="toDeletePurchaseOrder")
    def to_delete_purchase_order(self) -> "PurchaseOrders":
        '''(experimental) Allow or deny IAM users permission to delete a purchase order.

        Access Level: Write

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        :stability: experimental
        '''
        return typing.cast("PurchaseOrders", jsii.invoke(self, "toDeletePurchaseOrder", []))

    @jsii.member(jsii_name="toGetPurchaseOrder")
    def to_get_purchase_order(self) -> "PurchaseOrders":
        '''(experimental) Allow or deny IAM users permission to get a purchase order.

        Access Level: Read

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        :stability: experimental
        '''
        return typing.cast("PurchaseOrders", jsii.invoke(self, "toGetPurchaseOrder", []))

    @jsii.member(jsii_name="toListPurchaseOrderInvoices")
    def to_list_purchase_order_invoices(self) -> "PurchaseOrders":
        '''(experimental) Allow or deny IAM users permission to list purchase order invoices.

        Access Level: List

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        :stability: experimental
        '''
        return typing.cast("PurchaseOrders", jsii.invoke(self, "toListPurchaseOrderInvoices", []))

    @jsii.member(jsii_name="toListPurchaseOrders")
    def to_list_purchase_orders(self) -> "PurchaseOrders":
        '''(experimental) Allow or deny IAM users permission to get all available purchase orders.

        Access Level: List

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        :stability: experimental
        '''
        return typing.cast("PurchaseOrders", jsii.invoke(self, "toListPurchaseOrders", []))

    @jsii.member(jsii_name="toModifyPurchaseOrders")
    def to_modify_purchase_orders(self) -> "PurchaseOrders":
        '''(experimental) Grants permission to modify purchase orders and details.

        Access Level: Write

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        :stability: experimental
        '''
        return typing.cast("PurchaseOrders", jsii.invoke(self, "toModifyPurchaseOrders", []))

    @jsii.member(jsii_name="toUpdatePurchaseOrder")
    def to_update_purchase_order(self) -> "PurchaseOrders":
        '''(experimental) Allow or deny IAM users permission to update an existing purchase order.

        Access Level: Write

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        :stability: experimental
        '''
        return typing.cast("PurchaseOrders", jsii.invoke(self, "toUpdatePurchaseOrder", []))

    @jsii.member(jsii_name="toUpdatePurchaseOrderStatus")
    def to_update_purchase_order_status(self) -> "PurchaseOrders":
        '''(experimental) Allow or deny IAM users permission to set purchase order status.

        Access Level: Write

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        :stability: experimental
        '''
        return typing.cast("PurchaseOrders", jsii.invoke(self, "toUpdatePurchaseOrderStatus", []))

    @jsii.member(jsii_name="toViewPurchaseOrders")
    def to_view_purchase_orders(self) -> "PurchaseOrders":
        '''(experimental) Grants permission to view purchase orders and details.

        Access Level: Read

        https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions

        :stability: experimental
        '''
        return typing.cast("PurchaseOrders", jsii.invoke(self, "toViewPurchaseOrders", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__820ae5d0e7afedf303efefe6fa87fe4ff1578cc365cb567a547b6ecf2e5bce32)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ef08f6d6514106f1f4df3b52180fb0751d57b3ab5f00ae3c043006ecf963ed8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Qldb(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Qldb"):
    '''(experimental) Statement provider for service `qldb <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqldb.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `qldb <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqldb.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__814f945d7e09888078e8031f9d9ec9fdebef7f7cc351eceeca8611a5cd8d6e2d)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="ifPurge")
    def if_purge(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Qldb":
        '''(experimental) Filters access by the value of purge that is specified in a PartiQL DROP statement.

        https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-purge

        Applies to actions:

        - .toPartiQLDropIndex()
        - .toPartiQLDropTable()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e4d6bbc88bcdb9f63fa218d2779e0daae3841f1e693cce053f8c295b00fd0427)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Qldb", jsii.invoke(self, "ifPurge", [value, operator]))

    @jsii.member(jsii_name="onCatalog")
    def on_catalog(
        self,
        ledger_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Qldb":
        '''(experimental) Adds a resource of type catalog to the statement.

        https://docs.aws.amazon.com/qldb/latest/developerguide/working.catalog.html

        :param ledger_name: - Identifier for the ledgerName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4d8426a9e7421554baff0b52f4ece371e5b61d013593b1993c5f6a88ed62f090)
            check_type(argname="argument ledger_name", value=ledger_name, expected_type=type_hints["ledger_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Qldb", jsii.invoke(self, "onCatalog", [ledger_name, account, region, partition]))

    @jsii.member(jsii_name="onLedger")
    def on_ledger(
        self,
        ledger_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Qldb":
        '''(experimental) Adds a resource of type ledger to the statement.

        https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-structure.html

        :param ledger_name: - Identifier for the ledgerName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__33e79725ffe0458181c113282c1c7506a163d022a78447ca77529ca62d8328b8)
            check_type(argname="argument ledger_name", value=ledger_name, expected_type=type_hints["ledger_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Qldb", jsii.invoke(self, "onLedger", [ledger_name, account, region, partition]))

    @jsii.member(jsii_name="onStream")
    def on_stream(
        self,
        ledger_name: builtins.str,
        stream_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Qldb":
        '''(experimental) Adds a resource of type stream to the statement.

        https://docs.aws.amazon.com/qldb/latest/developerguide/streams.html

        :param ledger_name: - Identifier for the ledgerName.
        :param stream_id: - Identifier for the streamId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__57a800b9336b69e72193b2c799165ace48f65639a98f658c84a7b5246e77c654)
            check_type(argname="argument ledger_name", value=ledger_name, expected_type=type_hints["ledger_name"])
            check_type(argname="argument stream_id", value=stream_id, expected_type=type_hints["stream_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Qldb", jsii.invoke(self, "onStream", [ledger_name, stream_id, account, region, partition]))

    @jsii.member(jsii_name="onTable")
    def on_table(
        self,
        ledger_name: builtins.str,
        table_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Qldb":
        '''(experimental) Adds a resource of type table to the statement.

        https://docs.aws.amazon.com/qldb/latest/developerguide/working.manage-tables.html

        :param ledger_name: - Identifier for the ledgerName.
        :param table_id: - Identifier for the tableId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c0882066580677062a821f19917c77490b17b2470d4e6d6c7e77a838722e68e5)
            check_type(argname="argument ledger_name", value=ledger_name, expected_type=type_hints["ledger_name"])
            check_type(argname="argument table_id", value=table_id, expected_type=type_hints["table_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Qldb", jsii.invoke(self, "onTable", [ledger_name, table_id, account, region, partition]))

    @jsii.member(jsii_name="toCancelJournalKinesisStream")
    def to_cancel_journal_kinesis_stream(self) -> "Qldb":
        '''(experimental) Grants permission to cancel a journal kinesis stream.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_CancelJournalKinesisStream.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toCancelJournalKinesisStream", []))

    @jsii.member(jsii_name="toCreateLedger")
    def to_create_ledger(self) -> "Qldb":
        '''(experimental) Grants permission to create a ledger.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_CreateLedger.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toCreateLedger", []))

    @jsii.member(jsii_name="toDeleteLedger")
    def to_delete_ledger(self) -> "Qldb":
        '''(experimental) Grants permission to delete a ledger.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_DeleteLedger.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toDeleteLedger", []))

    @jsii.member(jsii_name="toDescribeJournalKinesisStream")
    def to_describe_journal_kinesis_stream(self) -> "Qldb":
        '''(experimental) Grants permission to describe information about a journal kinesis stream.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_DescribeJournalKinesisStream.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toDescribeJournalKinesisStream", []))

    @jsii.member(jsii_name="toDescribeJournalS3Export")
    def to_describe_journal_s3_export(self) -> "Qldb":
        '''(experimental) Grants permission to describe information about a journal export job.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_DescribeJournalS3Export.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toDescribeJournalS3Export", []))

    @jsii.member(jsii_name="toDescribeLedger")
    def to_describe_ledger(self) -> "Qldb":
        '''(experimental) Grants permission to describe a ledger.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_DescribeLedger.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toDescribeLedger", []))

    @jsii.member(jsii_name="toExecuteStatement")
    def to_execute_statement(self) -> "Qldb":
        '''(experimental) Grants permission to send commands to a ledger via the console.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/console_QLDB.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toExecuteStatement", []))

    @jsii.member(jsii_name="toExportJournalToS3")
    def to_export_journal_to_s3(self) -> "Qldb":
        '''(experimental) Grants permission to export journal contents to an Amazon S3 bucket.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ExportJournalToS3.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toExportJournalToS3", []))

    @jsii.member(jsii_name="toGetBlock")
    def to_get_block(self) -> "Qldb":
        '''(experimental) Grants permission to retrieve a block from a ledger for a given BlockAddress.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_GetBlock.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toGetBlock", []))

    @jsii.member(jsii_name="toGetDigest")
    def to_get_digest(self) -> "Qldb":
        '''(experimental) Grants permission to retrieve a digest from a ledger for a given BlockAddress.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_GetDigest.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toGetDigest", []))

    @jsii.member(jsii_name="toGetRevision")
    def to_get_revision(self) -> "Qldb":
        '''(experimental) Grants permission to retrieve a revision for a given document ID and a given BlockAddress.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_GetRevision.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toGetRevision", []))

    @jsii.member(jsii_name="toInsertSampleData")
    def to_insert_sample_data(self) -> "Qldb":
        '''(experimental) Grants permission to insert sample application data via the console.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/console_QLDB.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toInsertSampleData", []))

    @jsii.member(jsii_name="toListJournalKinesisStreamsForLedger")
    def to_list_journal_kinesis_streams_for_ledger(self) -> "Qldb":
        '''(experimental) Grants permission to list journal kinesis streams for a specified ledger.

        Access Level: List

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListJournalKinesisStreamsForLedger.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toListJournalKinesisStreamsForLedger", []))

    @jsii.member(jsii_name="toListJournalS3Exports")
    def to_list_journal_s3_exports(self) -> "Qldb":
        '''(experimental) Grants permission to list journal export jobs for all ledgers.

        Access Level: List

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListJournalS3Exports.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toListJournalS3Exports", []))

    @jsii.member(jsii_name="toListJournalS3ExportsForLedger")
    def to_list_journal_s3_exports_for_ledger(self) -> "Qldb":
        '''(experimental) Grants permission to list journal export jobs for a specified ledger.

        Access Level: List

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListJournalS3ExportsForLedger.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toListJournalS3ExportsForLedger", []))

    @jsii.member(jsii_name="toListLedgers")
    def to_list_ledgers(self) -> "Qldb":
        '''(experimental) Grants permission to list existing ledgers.

        Access Level: List

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListLedgers.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toListLedgers", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Qldb":
        '''(experimental) Grants permission to list tags for a resource.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toPartiQLCreateIndex")
    def to_parti_ql_create_index(self) -> "Qldb":
        '''(experimental) Grants permission to create an index on a table.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.create-index.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLCreateIndex", []))

    @jsii.member(jsii_name="toPartiQLCreateTable")
    def to_parti_ql_create_table(self) -> "Qldb":
        '''(experimental) Grants permission to create a table.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.create-table.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLCreateTable", []))

    @jsii.member(jsii_name="toPartiQLDelete")
    def to_parti_ql_delete(self) -> "Qldb":
        '''(experimental) Grants permission to delete documents from a table.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.delete.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLDelete", []))

    @jsii.member(jsii_name="toPartiQLDropIndex")
    def to_parti_ql_drop_index(self) -> "Qldb":
        '''(experimental) Grants permission to drop an index from a table.

        Access Level: Write

        Possible conditions:

        - .ifPurge()

        https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.drop-index.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLDropIndex", []))

    @jsii.member(jsii_name="toPartiQLDropTable")
    def to_parti_ql_drop_table(self) -> "Qldb":
        '''(experimental) Grants permission to drop a table.

        Access Level: Write

        Possible conditions:

        - .ifPurge()

        https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.drop-table.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLDropTable", []))

    @jsii.member(jsii_name="toPartiQLHistoryFunction")
    def to_parti_ql_history_function(self) -> "Qldb":
        '''(experimental) Grants permission to use the history function on a table.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/working.history.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLHistoryFunction", []))

    @jsii.member(jsii_name="toPartiQLInsert")
    def to_parti_ql_insert(self) -> "Qldb":
        '''(experimental) Grants permission to insert documents into a table.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.insert.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLInsert", []))

    @jsii.member(jsii_name="toPartiQLRedact")
    def to_parti_ql_redact(self) -> "Qldb":
        '''(experimental) Grants permission to redact historic revisions.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/ql-stored-procedures.redact_revision.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLRedact", []))

    @jsii.member(jsii_name="toPartiQLSelect")
    def to_parti_ql_select(self) -> "Qldb":
        '''(experimental) Grants permission to select documents from a table.

        Access Level: Read

        https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.select.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLSelect", []))

    @jsii.member(jsii_name="toPartiQLUndropTable")
    def to_parti_ql_undrop_table(self) -> "Qldb":
        '''(experimental) Grants permission to undrop a table.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.undrop-table.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLUndropTable", []))

    @jsii.member(jsii_name="toPartiQLUpdate")
    def to_parti_ql_update(self) -> "Qldb":
        '''(experimental) Grants permission to update existing documents in a table.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.update.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toPartiQLUpdate", []))

    @jsii.member(jsii_name="toSendCommand")
    def to_send_command(self) -> "Qldb":
        '''(experimental) Grants permission to send commands to a ledger.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_QLDB-Session_SendCommand.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toSendCommand", []))

    @jsii.member(jsii_name="toShowCatalog")
    def to_show_catalog(self) -> "Qldb":
        '''(experimental) Grants permission to view a ledger's catalog via the console.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/console_QLDB.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toShowCatalog", []))

    @jsii.member(jsii_name="toStreamJournalToKinesis")
    def to_stream_journal_to_kinesis(self) -> "Qldb":
        '''(experimental) Grants permission to stream journal contents to a Kinesis Data Stream.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_StreamJournalToKinesis.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toStreamJournalToKinesis", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Qldb":
        '''(experimental) Grants permission to add one or more tags to a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Qldb":
        '''(experimental) Grants permission to remove one or more tags from a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateLedger")
    def to_update_ledger(self) -> "Qldb":
        '''(experimental) Grants permission to update properties on a ledger.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_UpdateLedger.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toUpdateLedger", []))

    @jsii.member(jsii_name="toUpdateLedgerPermissionsMode")
    def to_update_ledger_permissions_mode(self) -> "Qldb":
        '''(experimental) Grants permission to update the permissions mode on a ledger.

        Access Level: Write

        https://docs.aws.amazon.com/qldb/latest/developerguide/API_UpdateLedgerPermissionsMode.html

        :stability: experimental
        '''
        return typing.cast("Qldb", jsii.invoke(self, "toUpdateLedgerPermissionsMode", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2542c05856d7cab183f67aaa4cdba31400df231c40113801ff8f1a8c8fa81d61)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1648f958f666f37705c42f7516d337838532216c59187bf22c4f3e65e5d062c0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Quicksight(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Quicksight",
):
    '''(experimental) Statement provider for service `quicksight <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonquicksight.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `quicksight <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonquicksight.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f5b650ee63a5a86471675c8c85811a9081ed1f8d431fc90dbb6ea5a37a2ba19d)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="ifAllowedEmbeddingDomains")
    def if_allowed_embedding_domains(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Quicksight":
        '''(experimental) Filters access by the allowed embedding domains.

        https://docs.aws.amazon.com/quicksight/latest/user/embedded-dashboards-for-authenticated-users-step-1.html

        Applies to actions:

        - .toGenerateEmbedUrlForAnonymousUser()
        - .toGenerateEmbedUrlForRegisteredUser()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e15105889e506399c9bbe41b803f9cbef3a84046090a7feb6250b966c7ea92b3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Quicksight", jsii.invoke(self, "ifAllowedEmbeddingDomains", [value, operator]))

    @jsii.member(jsii_name="ifDirectoryType")
    def if_directory_type(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Quicksight":
        '''(experimental) Filters access by the user management options.

        https://docs.aws.amazon.com/quicksight/latest/user/security-scp.html

        Applies to actions:

        - .toSubscribe()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df6e6f7e00e6c782d9c80586e2aada3759860d7bd9efd24ec1ff5e0722f71ce3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Quicksight", jsii.invoke(self, "ifDirectoryType", [value, operator]))

    @jsii.member(jsii_name="ifEdition")
    def if_edition(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Quicksight":
        '''(experimental) Filters access by the edition of QuickSight.

        https://docs.aws.amazon.com/quicksight/latest/user/security-scp.html

        Applies to actions:

        - .toSubscribe()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d845619e5eda7075dfa0d6180e3d0a262030973594315dbe2d5586bf71a5a09)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Quicksight", jsii.invoke(self, "ifEdition", [value, operator]))

    @jsii.member(jsii_name="ifIamArn")
    def if_iam_arn(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Quicksight":
        '''(experimental) Filters access by IAM user or role ARN.

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        Applies to actions:

        - .toRegisterUser()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bd83b0771cfc687fd08724f78bfc7fce98802655ac3e8366cce9a9bb6dbc2ac3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Quicksight", jsii.invoke(self, "ifIamArn", [value, operator]))

    @jsii.member(jsii_name="ifSessionName")
    def if_session_name(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Quicksight":
        '''(experimental) Filters access by session name.

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        Applies to actions:

        - .toRegisterUser()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9b2d28e4b1f23675081bf1c15d8d4dee5f7881a8351525a7e15d7b9632fd9867)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Quicksight", jsii.invoke(self, "ifSessionName", [value, operator]))

    @jsii.member(jsii_name="ifUserName")
    def if_user_name(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Quicksight":
        '''(experimental) Filters access by user name.

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        Applies to actions:

        - .toCreateGroupMembership()
        - .toDeleteGroupMembership()
        - .toDescribeGroupMembership()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__36fa1b7d2b6d2e4f0eb3c5a3b41032f07e464577e43fd9de36de4782f94cbf7a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Quicksight", jsii.invoke(self, "ifUserName", [value, operator]))

    @jsii.member(jsii_name="onAccount")
    def on_account(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type account to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_AccountInfo.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ed20da5bd6f5048349cdeba0ee2a805fe4f0b7b0bae587c99163ece17aec1fd)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onAccount", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onAnalysis")
    def on_analysis(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type analysis to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Analysis.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99f18bd5a0a6b5644fc86ff73898cb2e1893f3659b4030f911cdb25c26ab5e64)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onAnalysis", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onAssignment")
    def on_assignment(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type assignment to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IAMPolicyAssignment.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49f52a58b130f567653510c488ecd96a3aa745753ad7dc4bea011ad17277bf5c)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onAssignment", [resource_id, account, partition]))

    @jsii.member(jsii_name="onCustomization")
    def on_customization(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type customization to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_AccountCustomization.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4cea98dbac9c8bf0ae15b4737838378b4205707b055adc10306a63a784f4a69)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onCustomization", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onDashboard")
    def on_dashboard(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type dashboard to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Dashboard.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__45a4e615ba763e8a5455f534204870042cbaf63a33d5ea561b41f83bcf4bf55b)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onDashboard", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onDataset")
    def on_dataset(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type dataset to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSet.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae931c1971aae55fe2fae041e61e99df03771921e3caab81837bd94ce887b5f6)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onDataset", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onDatasource")
    def on_datasource(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type datasource to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSource.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d815bffbc64a29c3f2939ef4b083faf8ed3377aad9d1e5e904c4247102f5eead)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onDatasource", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onEmailCustomizationTemplate")
    def on_email_customization_template(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type emailCustomizationTemplate to the statement.

        https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight-email-templates.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__56efff9ad5c3f6968b62b86b6649ae93fe0beae022e0e03c54b08fcb942bb05a)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onEmailCustomizationTemplate", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onFolder")
    def on_folder(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type folder to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Folder.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__21c800e5a0e79a750edc3389e68a2d0eac0161fd6758eb56dba737ac271b06ef)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onFolder", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onGroup")
    def on_group(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type group to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Group.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c72ea51c73a16409c0d85e2ac2ed686786f6705b78070222d45e87d36188bbf)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onGroup", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onIngestion")
    def on_ingestion(
        self,
        dataset_id: builtins.str,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type ingestion to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Ingestion.html

        :param dataset_id: - Identifier for the datasetId.
        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__43507e3343149fcf266bd3b3de5ad21d61627af515abc1284352bdfde46c83ad)
            check_type(argname="argument dataset_id", value=dataset_id, expected_type=type_hints["dataset_id"])
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onIngestion", [dataset_id, resource_id, account, region, partition]))

    @jsii.member(jsii_name="onNamespace")
    def on_namespace(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type namespace to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_NamespaceInfoV2.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c713d95abbd94adafc30660c77bdeaa49cfbb588b9d5d03bcbac0540726d136a)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onNamespace", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onTemplate")
    def on_template(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type template to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Template.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__422c86e0ed9c63ba4ee8a0dbad096f76d468838e5f3adcc524f9983647cee91f)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onTemplate", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onTheme")
    def on_theme(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type theme to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Theme.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d782750e2b0cce99f646a9d623bb35d11a88b7a5826c1fc3e8c5d007626001a8)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onTheme", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onTopic")
    def on_topic(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type topic to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Topic.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eea4b4d48d8d4685deeca3d13ccbf5573b6ff8b6c2ab9f8cf3fa752e1654ea70)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onTopic", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="onUser")
    def on_user(
        self,
        resource_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Quicksight":
        '''(experimental) Adds a resource of type user to the statement.

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_User.html

        :param resource_id: - Identifier for the resourceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f07f23e73ff9250c5ccc08fbb302b1145d0cfbab439a3f621bbc0c07cdd53db9)
            check_type(argname="argument resource_id", value=resource_id, expected_type=type_hints["resource_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Quicksight", jsii.invoke(self, "onUser", [resource_id, account, region, partition]))

    @jsii.member(jsii_name="toAccountConfigurations")
    def to_account_configurations(self) -> "Quicksight":
        '''(experimental) Grants permission to enable setting default access to AWS resources.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/accessing-data-sources.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toAccountConfigurations", []))

    @jsii.member(jsii_name="toCancelIngestion")
    def to_cancel_ingestion(self) -> "Quicksight":
        '''(experimental) Grants permission to cancel a SPICE ingestions on a dataset.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CancelIngestion.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCancelIngestion", []))

    @jsii.member(jsii_name="toCreateAccountCustomization")
    def to_create_account_customization(self) -> "Quicksight":
        '''(experimental) Grants permission to create an account customization for QuickSight account or namespace.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateAccountCustomization.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateAccountCustomization", []))

    @jsii.member(jsii_name="toCreateAccountSubscription")
    def to_create_account_subscription(self) -> "Quicksight":
        '''(experimental) Grants permission to subscribe to QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateAccountSubscription.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateAccountSubscription", []))

    @jsii.member(jsii_name="toCreateAdmin")
    def to_create_admin(self) -> "Quicksight":
        '''(experimental) Grants permission to provision Amazon QuickSight administrators, authors, and readers.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateAdmin", []))

    @jsii.member(jsii_name="toCreateAnalysis")
    def to_create_analysis(self) -> "Quicksight":
        '''(experimental) Grants permission to create an analysis from a template.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateAnalysis.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateAnalysis", []))

    @jsii.member(jsii_name="toCreateCustomPermissions")
    def to_create_custom_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to create a custom permissions resource for restricting user access.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateCustomPermissions", []))

    @jsii.member(jsii_name="toCreateDashboard")
    def to_create_dashboard(self) -> "Quicksight":
        '''(experimental) Grants permission to create a QuickSight Dashboard.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDashboard.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateDashboard", []))

    @jsii.member(jsii_name="toCreateDataSet")
    def to_create_data_set(self) -> "Quicksight":
        '''(experimental) Grants permission to create a dataset.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - quicksight:PassDataSource

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDataSet.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateDataSet", []))

    @jsii.member(jsii_name="toCreateDataSource")
    def to_create_data_source(self) -> "Quicksight":
        '''(experimental) Grants permission to create a data source.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDataSource.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateDataSource", []))

    @jsii.member(jsii_name="toCreateEmailCustomizationTemplate")
    def to_create_email_customization_template(self) -> "Quicksight":
        '''(experimental) Grants permission to create a QuickSight email customization template.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight-email-templates.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateEmailCustomizationTemplate", []))

    @jsii.member(jsii_name="toCreateFolder")
    def to_create_folder(self) -> "Quicksight":
        '''(experimental) Grants permission to create a QuickSight folder.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateFolder.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateFolder", []))

    @jsii.member(jsii_name="toCreateFolderMembership")
    def to_create_folder_membership(self) -> "Quicksight":
        '''(experimental) Grants permission to add a QuickSight Dashboard, Analysis or Dataset to a QuickSight Folder.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateFolderMembership.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateFolderMembership", []))

    @jsii.member(jsii_name="toCreateGroup")
    def to_create_group(self) -> "Quicksight":
        '''(experimental) Grants permission to create a QuickSight group.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateGroup.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateGroup", []))

    @jsii.member(jsii_name="toCreateGroupMembership")
    def to_create_group_membership(self) -> "Quicksight":
        '''(experimental) Grants permission to add a QuickSight user to a QuickSight group.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateGroupMembership.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateGroupMembership", []))

    @jsii.member(jsii_name="toCreateIAMPolicyAssignment")
    def to_create_iam_policy_assignment(self) -> "Quicksight":
        '''(experimental) Grants permission to create an assignment with one specified IAM Policy ARN that will be assigned to specified groups or users of QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateIAMPolicyAssignment.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateIAMPolicyAssignment", []))

    @jsii.member(jsii_name="toCreateIngestion")
    def to_create_ingestion(self) -> "Quicksight":
        '''(experimental) Grants permission to start a SPICE ingestion on a dataset.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateIngestion.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateIngestion", []))

    @jsii.member(jsii_name="toCreateNamespace")
    def to_create_namespace(self) -> "Quicksight":
        '''(experimental) Grants permission to create an QuickSight namespace.

        Access Level: Write

        Dependent actions:

        - ds:CreateIdentityPoolDirectory

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateNamespace.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateNamespace", []))

    @jsii.member(jsii_name="toCreateReader")
    def to_create_reader(self) -> "Quicksight":
        '''(experimental) Grants permission to provision Amazon QuickSight readers.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateReader", []))

    @jsii.member(jsii_name="toCreateTemplate")
    def to_create_template(self) -> "Quicksight":
        '''(experimental) Grants permission to create a template.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateTemplate", []))

    @jsii.member(jsii_name="toCreateTemplateAlias")
    def to_create_template_alias(self) -> "Quicksight":
        '''(experimental) Grants permission to create a template alias.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplateAlias.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateTemplateAlias", []))

    @jsii.member(jsii_name="toCreateTheme")
    def to_create_theme(self) -> "Quicksight":
        '''(experimental) Grants permission to create a theme.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTheme.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateTheme", []))

    @jsii.member(jsii_name="toCreateThemeAlias")
    def to_create_theme_alias(self) -> "Quicksight":
        '''(experimental) Grants permission to create an alias for a theme version.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateThemeAlias.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateThemeAlias", []))

    @jsii.member(jsii_name="toCreateUser")
    def to_create_user(self) -> "Quicksight":
        '''(experimental) Grants permission to provision Amazon QuickSight authors and readers.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateUser", []))

    @jsii.member(jsii_name="toCreateVPCConnection")
    def to_create_vpc_connection(self) -> "Quicksight":
        '''(experimental) Grants permission to create a VPC connection.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/vpc-creating-a-connection-in-quicksight.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toCreateVPCConnection", []))

    @jsii.member(jsii_name="toDeleteAccountCustomization")
    def to_delete_account_customization(self) -> "Quicksight":
        '''(experimental) Grants permission to delete an account customization for QuickSight account or namespace.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteAccountCustomization.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteAccountCustomization", []))

    @jsii.member(jsii_name="toDeleteAccountSubscription")
    def to_delete_account_subscription(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a QuickSight account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteAccountSubscription.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteAccountSubscription", []))

    @jsii.member(jsii_name="toDeleteAnalysis")
    def to_delete_analysis(self) -> "Quicksight":
        '''(experimental) Grants permission to delete an analysis.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteAnalysis.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteAnalysis", []))

    @jsii.member(jsii_name="toDeleteCustomPermissions")
    def to_delete_custom_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a custom permissions resource.

        Access Level: Permissions management

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteCustomPermissions", []))

    @jsii.member(jsii_name="toDeleteDashboard")
    def to_delete_dashboard(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a QuickSight Dashboard.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteDashboard.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteDashboard", []))

    @jsii.member(jsii_name="toDeleteDataSet")
    def to_delete_data_set(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a dataset.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteDataSet.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteDataSet", []))

    @jsii.member(jsii_name="toDeleteDataSource")
    def to_delete_data_source(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a data source.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteDataSource.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteDataSource", []))

    @jsii.member(jsii_name="toDeleteEmailCustomizationTemplate")
    def to_delete_email_customization_template(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a QuickSight email customization template.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight-email-templates.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteEmailCustomizationTemplate", []))

    @jsii.member(jsii_name="toDeleteFolder")
    def to_delete_folder(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a QuickSight Folder.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteFolder.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteFolder", []))

    @jsii.member(jsii_name="toDeleteFolderMembership")
    def to_delete_folder_membership(self) -> "Quicksight":
        '''(experimental) Grants permission to remove a QuickSight Dashboard, Analysis or Dataset from a QuickSight Folder.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteFolderMembership.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteFolderMembership", []))

    @jsii.member(jsii_name="toDeleteGroup")
    def to_delete_group(self) -> "Quicksight":
        '''(experimental) Grants permission to remove a user group from QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteGroup.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteGroup", []))

    @jsii.member(jsii_name="toDeleteGroupMembership")
    def to_delete_group_membership(self) -> "Quicksight":
        '''(experimental) Grants permission to remove a user from a group so that he/she is no longer a member of the group.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteGroupMembership.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteGroupMembership", []))

    @jsii.member(jsii_name="toDeleteIAMPolicyAssignment")
    def to_delete_iam_policy_assignment(self) -> "Quicksight":
        '''(experimental) Grants permission to update an existing assignment.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteIAMPolicyAssignment.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteIAMPolicyAssignment", []))

    @jsii.member(jsii_name="toDeleteNamespace")
    def to_delete_namespace(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a QuickSight namespace.

        Access Level: Write

        Dependent actions:

        - ds:DeleteDirectory

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteNamespace.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteNamespace", []))

    @jsii.member(jsii_name="toDeleteTemplate")
    def to_delete_template(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a template.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteTemplate.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteTemplate", []))

    @jsii.member(jsii_name="toDeleteTemplateAlias")
    def to_delete_template_alias(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a template alias.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteTemplateAlias.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteTemplateAlias", []))

    @jsii.member(jsii_name="toDeleteTheme")
    def to_delete_theme(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a theme.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteTheme.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteTheme", []))

    @jsii.member(jsii_name="toDeleteThemeAlias")
    def to_delete_theme_alias(self) -> "Quicksight":
        '''(experimental) Grants permission to delete the alias of a theme.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteThemeAlias.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteThemeAlias", []))

    @jsii.member(jsii_name="toDeleteUser")
    def to_delete_user(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a QuickSight user, given the user name.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteUser.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteUser", []))

    @jsii.member(jsii_name="toDeleteUserByPrincipalId")
    def to_delete_user_by_principal_id(self) -> "Quicksight":
        '''(experimental) Grants permission to deletes a user identified by its principal ID.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteUserByPrincipalId.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteUserByPrincipalId", []))

    @jsii.member(jsii_name="toDeleteVPCConnection")
    def to_delete_vpc_connection(self) -> "Quicksight":
        '''(experimental) Grants permission to delete a VPC connection.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/vpc-creating-a-connection-in-quicksight.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDeleteVPCConnection", []))

    @jsii.member(jsii_name="toDescribeAccountCustomization")
    def to_describe_account_customization(self) -> "Quicksight":
        '''(experimental) Grants permission to describe an account customization for QuickSight account or namespace.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAccountCustomization.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeAccountCustomization", []))

    @jsii.member(jsii_name="toDescribeAccountSettings")
    def to_describe_account_settings(self) -> "Quicksight":
        '''(experimental) Grants permission to describe the administrative account settings for QuickSight account.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAccountSettings.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeAccountSettings", []))

    @jsii.member(jsii_name="toDescribeAccountSubscription")
    def to_describe_account_subscription(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a QuickSight account.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAccountSubscription.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeAccountSubscription", []))

    @jsii.member(jsii_name="toDescribeAnalysis")
    def to_describe_analysis(self) -> "Quicksight":
        '''(experimental) Grants permission to describe an analysis.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeAnalysis", []))

    @jsii.member(jsii_name="toDescribeAnalysisPermissions")
    def to_describe_analysis_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to describe permissions for an analysis.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysisPermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeAnalysisPermissions", []))

    @jsii.member(jsii_name="toDescribeCustomPermissions")
    def to_describe_custom_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a custom permissions resource in a QuickSight account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeCustomPermissions", []))

    @jsii.member(jsii_name="toDescribeDashboard")
    def to_describe_dashboard(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a QuickSight Dashboard.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeDashboard", []))

    @jsii.member(jsii_name="toDescribeDashboardPermissions")
    def to_describe_dashboard_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to describe permissions for a QuickSight Dashboard.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboardPermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeDashboardPermissions", []))

    @jsii.member(jsii_name="toDescribeDataSet")
    def to_describe_data_set(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a dataset.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSet.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeDataSet", []))

    @jsii.member(jsii_name="toDescribeDataSetPermissions")
    def to_describe_data_set_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to describe the resource policy of a dataset.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSetPermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeDataSetPermissions", []))

    @jsii.member(jsii_name="toDescribeDataSource")
    def to_describe_data_source(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a data source.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSource.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeDataSource", []))

    @jsii.member(jsii_name="toDescribeDataSourcePermissions")
    def to_describe_data_source_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to describe the resource policy of a data source.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSourcePermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeDataSourcePermissions", []))

    @jsii.member(jsii_name="toDescribeEmailCustomizationTemplate")
    def to_describe_email_customization_template(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a QuickSight email customization template.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight-email-templates.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeEmailCustomizationTemplate", []))

    @jsii.member(jsii_name="toDescribeFolder")
    def to_describe_folder(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a QuickSight Folder.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeFolder.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeFolder", []))

    @jsii.member(jsii_name="toDescribeFolderPermissions")
    def to_describe_folder_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to describe permissions for a QuickSight Folder.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeFolderPermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeFolderPermissions", []))

    @jsii.member(jsii_name="toDescribeFolderResolvedPermissions")
    def to_describe_folder_resolved_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to describe resolved permissions for a QuickSight Folder.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeFolderResolvedPermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeFolderResolvedPermissions", []))

    @jsii.member(jsii_name="toDescribeGroup")
    def to_describe_group(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a QuickSight group.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeGroup.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeGroup", []))

    @jsii.member(jsii_name="toDescribeGroupMembership")
    def to_describe_group_membership(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a QuickSight group member.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeGroupMembership.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeGroupMembership", []))

    @jsii.member(jsii_name="toDescribeIAMPolicyAssignment")
    def to_describe_iam_policy_assignment(self) -> "Quicksight":
        '''(experimental) Grants permission to describe an existing assignment.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeIAMPolicyAssignment.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeIAMPolicyAssignment", []))

    @jsii.member(jsii_name="toDescribeIngestion")
    def to_describe_ingestion(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a SPICE ingestion on a dataset.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeIngestion.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeIngestion", []))

    @jsii.member(jsii_name="toDescribeIpRestriction")
    def to_describe_ip_restriction(self) -> "Quicksight":
        '''(experimental) Grants permission to describe the IP restrictions for QuickSight account.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeIpRestriction.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeIpRestriction", []))

    @jsii.member(jsii_name="toDescribeNamespace")
    def to_describe_namespace(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a QuickSight namespace.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeNamespace.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeNamespace", []))

    @jsii.member(jsii_name="toDescribeTemplate")
    def to_describe_template(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a template.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplate.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeTemplate", []))

    @jsii.member(jsii_name="toDescribeTemplateAlias")
    def to_describe_template_alias(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a template alias.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplateAlias.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeTemplateAlias", []))

    @jsii.member(jsii_name="toDescribeTemplatePermissions")
    def to_describe_template_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to describe permissions for a template.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplatePermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeTemplatePermissions", []))

    @jsii.member(jsii_name="toDescribeTheme")
    def to_describe_theme(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a theme.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTheme.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeTheme", []))

    @jsii.member(jsii_name="toDescribeThemeAlias")
    def to_describe_theme_alias(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a theme alias.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemeAlias.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeThemeAlias", []))

    @jsii.member(jsii_name="toDescribeThemePermissions")
    def to_describe_theme_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to describe permissions for a theme.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeThemePermissions", []))

    @jsii.member(jsii_name="toDescribeUser")
    def to_describe_user(self) -> "Quicksight":
        '''(experimental) Grants permission to describe a QuickSight user given the user name.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toDescribeUser", []))

    @jsii.member(jsii_name="toGenerateEmbedUrlForAnonymousUser")
    def to_generate_embed_url_for_anonymous_user(self) -> "Quicksight":
        '''(experimental) Grants permission to generate a URL used to embed a QuickSight Dashboard or Q Topic for a user not registered with QuickSight.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()
        - .ifAllowedEmbeddingDomains()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toGenerateEmbedUrlForAnonymousUser", []))

    @jsii.member(jsii_name="toGenerateEmbedUrlForRegisteredUser")
    def to_generate_embed_url_for_registered_user(self) -> "Quicksight":
        '''(experimental) Grants permission to generate a URL used to embed a QuickSight Dashboard for a user registered with QuickSight.

        Access Level: Write

        Possible conditions:

        - .ifAllowedEmbeddingDomains()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toGenerateEmbedUrlForRegisteredUser", []))

    @jsii.member(jsii_name="toGetAnonymousUserEmbedUrl")
    def to_get_anonymous_user_embed_url(self) -> "Quicksight":
        '''(experimental) Grants permission to get a URL used to embed a QuickSight Dashboard for a user not registered with QuickSight.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toGetAnonymousUserEmbedUrl", []))

    @jsii.member(jsii_name="toGetAuthCode")
    def to_get_auth_code(self) -> "Quicksight":
        '''(experimental) Grants permission to get an auth code representing a QuickSight user.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toGetAuthCode", []))

    @jsii.member(jsii_name="toGetDashboardEmbedUrl")
    def to_get_dashboard_embed_url(self) -> "Quicksight":
        '''(experimental) Grants permission to get a URL used to embed a QuickSight Dashboard.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toGetDashboardEmbedUrl", []))

    @jsii.member(jsii_name="toGetGroupMapping")
    def to_get_group_mapping(self) -> "Quicksight":
        '''(experimental) Grants permission to use Amazon QuickSight, in Enterprise edition, to identify and display the Microsoft Active Directory (Microsoft Active Directory) directory groups that are mapped to roles in Amazon QuickSight.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toGetGroupMapping", []))

    @jsii.member(jsii_name="toGetSessionEmbedUrl")
    def to_get_session_embed_url(self) -> "Quicksight":
        '''(experimental) Grants permission to get a URL to embed QuickSight console experience.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetSessionEmbedUrl.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toGetSessionEmbedUrl", []))

    @jsii.member(jsii_name="toListAnalyses")
    def to_list_analyses(self) -> "Quicksight":
        '''(experimental) Grants permission to list all analyses in an account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListAnalyses.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListAnalyses", []))

    @jsii.member(jsii_name="toListCustomPermissions")
    def to_list_custom_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to list custom permissions resources in QuickSight account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListCustomPermissions", []))

    @jsii.member(jsii_name="toListDashboards")
    def to_list_dashboards(self) -> "Quicksight":
        '''(experimental) Grants permission to list all Dashboards in a QuickSight Account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDashboards.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListDashboards", []))

    @jsii.member(jsii_name="toListDashboardVersions")
    def to_list_dashboard_versions(self) -> "Quicksight":
        '''(experimental) Grants permission to list all versions of a QuickSight Dashboard.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDashboardVersions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListDashboardVersions", []))

    @jsii.member(jsii_name="toListDataSets")
    def to_list_data_sets(self) -> "Quicksight":
        '''(experimental) Grants permission to list all datasets.

        Access Level: List

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDataSets.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListDataSets", []))

    @jsii.member(jsii_name="toListDataSources")
    def to_list_data_sources(self) -> "Quicksight":
        '''(experimental) Grants permission to list all data sources.

        Access Level: List

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDataSources.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListDataSources", []))

    @jsii.member(jsii_name="toListFolderMembers")
    def to_list_folder_members(self) -> "Quicksight":
        '''(experimental) Grants permission to list all members in a folder.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListFolderMembers.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListFolderMembers", []))

    @jsii.member(jsii_name="toListFolders")
    def to_list_folders(self) -> "Quicksight":
        '''(experimental) Grants permission to list all Folders in a QuickSight Account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListFolders.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListFolders", []))

    @jsii.member(jsii_name="toListGroupMemberships")
    def to_list_group_memberships(self) -> "Quicksight":
        '''(experimental) Grants permission to list member users in a group.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListGroupMemberships.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListGroupMemberships", []))

    @jsii.member(jsii_name="toListGroups")
    def to_list_groups(self) -> "Quicksight":
        '''(experimental) Grants permission to list all user groups in QuickSight.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListGroups.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListGroups", []))

    @jsii.member(jsii_name="toListIAMPolicyAssignments")
    def to_list_iam_policy_assignments(self) -> "Quicksight":
        '''(experimental) Grants permission to list all assignments in the current Amazon QuickSight account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListIAMPolicyAssignments.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListIAMPolicyAssignments", []))

    @jsii.member(jsii_name="toListIAMPolicyAssignmentsForUser")
    def to_list_iam_policy_assignments_for_user(self) -> "Quicksight":
        '''(experimental) Grants permission to list all assignments assigned to a user and the groups it belongs.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListIAMPolicyAssignmentsForUser.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListIAMPolicyAssignmentsForUser", []))

    @jsii.member(jsii_name="toListIngestions")
    def to_list_ingestions(self) -> "Quicksight":
        '''(experimental) Grants permission to list all SPICE ingestions on a dataset.

        Access Level: List

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListIngestions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListIngestions", []))

    @jsii.member(jsii_name="toListNamespaces")
    def to_list_namespaces(self) -> "Quicksight":
        '''(experimental) Grants permission to lists all namespaces in a QuickSight account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListNamespaces.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListNamespaces", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Quicksight":
        '''(experimental) Grants permission to list tags of a QuickSight resource.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toListTemplateAliases")
    def to_list_template_aliases(self) -> "Quicksight":
        '''(experimental) Grants permission to list all aliases for a template.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTemplateAliases.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListTemplateAliases", []))

    @jsii.member(jsii_name="toListTemplates")
    def to_list_templates(self) -> "Quicksight":
        '''(experimental) Grants permission to list all templates in a QuickSight account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTemplates.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListTemplates", []))

    @jsii.member(jsii_name="toListTemplateVersions")
    def to_list_template_versions(self) -> "Quicksight":
        '''(experimental) Grants permission to list all versions of a template.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTemplateVersions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListTemplateVersions", []))

    @jsii.member(jsii_name="toListThemeAliases")
    def to_list_theme_aliases(self) -> "Quicksight":
        '''(experimental) Grants permission to list all aliases of a theme.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListThemeAliases.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListThemeAliases", []))

    @jsii.member(jsii_name="toListThemes")
    def to_list_themes(self) -> "Quicksight":
        '''(experimental) Grants permission to list all themes in an account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListThemes.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListThemes", []))

    @jsii.member(jsii_name="toListThemeVersions")
    def to_list_theme_versions(self) -> "Quicksight":
        '''(experimental) Grants permission to list all versions of a theme.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListThemeVersions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListThemeVersions", []))

    @jsii.member(jsii_name="toListUserGroups")
    def to_list_user_groups(self) -> "Quicksight":
        '''(experimental) Grants permission to list groups that a given user is a member of.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListUserGroups.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListUserGroups", []))

    @jsii.member(jsii_name="toListUsers")
    def to_list_users(self) -> "Quicksight":
        '''(experimental) Grants permission to list all of the QuickSight users belonging to this account.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListUsers.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toListUsers", []))

    @jsii.member(jsii_name="toPassDataSet")
    def to_pass_data_set(self) -> "Quicksight":
        '''(experimental) Grants permission to use a dataset for a template.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/qs-api-overview.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toPassDataSet", []))

    @jsii.member(jsii_name="toPassDataSource")
    def to_pass_data_source(self) -> "Quicksight":
        '''(experimental) Grants permission to use a data source for a data set.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/qs-api-overview.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toPassDataSource", []))

    @jsii.member(jsii_name="toRegisterUser")
    def to_register_user(self) -> "Quicksight":
        '''(experimental) Grants permission to create a QuickSight user, whose identity is associated with the IAM identity/role specified in the request.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toRegisterUser", []))

    @jsii.member(jsii_name="toRestoreAnalysis")
    def to_restore_analysis(self) -> "Quicksight":
        '''(experimental) Grants permission to restore a deleted analysis.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RestoreAnalysis.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toRestoreAnalysis", []))

    @jsii.member(jsii_name="toScopeDownPolicy")
    def to_scope_down_policy(self) -> "Quicksight":
        '''(experimental) Grants permission to manage scoping policies for permissions to AWS resources.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/accessing-data-sources.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toScopeDownPolicy", []))

    @jsii.member(jsii_name="toSearchAnalyses")
    def to_search_analyses(self) -> "Quicksight":
        '''(experimental) Grants permission to search for a sub-set of analyses.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_SearchAnalyses.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toSearchAnalyses", []))

    @jsii.member(jsii_name="toSearchDashboards")
    def to_search_dashboards(self) -> "Quicksight":
        '''(experimental) Grants permission to search for a sub-set of QuickSight Dashboards.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_SearchDashboards.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toSearchDashboards", []))

    @jsii.member(jsii_name="toSearchDataSets")
    def to_search_data_sets(self) -> "Quicksight":
        '''(experimental) Grants permission to search for a sub-set of QuickSight DatSets.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_SearchDataSets.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toSearchDataSets", []))

    @jsii.member(jsii_name="toSearchDataSources")
    def to_search_data_sources(self) -> "Quicksight":
        '''(experimental) Grants permission to search for a sub-set of QuickSight Data Sources.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_SearchDataSources.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toSearchDataSources", []))

    @jsii.member(jsii_name="toSearchDirectoryGroups")
    def to_search_directory_groups(self) -> "Quicksight":
        '''(experimental) Grants permission to use Amazon QuickSight, in Enterprise edition, to display your Microsoft Active Directory directory groups so that you can choose which ones to map to roles in Amazon QuickSight.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toSearchDirectoryGroups", []))

    @jsii.member(jsii_name="toSearchFolders")
    def to_search_folders(self) -> "Quicksight":
        '''(experimental) Grants permission to search for a sub-set of QuickSight Folders.

        Access Level: Read

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_SearchFolders.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toSearchFolders", []))

    @jsii.member(jsii_name="toSearchGroups")
    def to_search_groups(self) -> "Quicksight":
        '''(experimental) Grants permission to search for a sub-set of QuickSight groups.

        Access Level: List

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_SearchGroups.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toSearchGroups", []))

    @jsii.member(jsii_name="toSetGroupMapping")
    def to_set_group_mapping(self) -> "Quicksight":
        '''(experimental) Grants permission to use Amazon QuickSight, in Enterprise edition, to display your Microsoft Active Directory directory groups so that you can choose which ones to map to roles in Amazon QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toSetGroupMapping", []))

    @jsii.member(jsii_name="toSubscribe")
    def to_subscribe(self) -> "Quicksight":
        '''(experimental) Grants permission to subscribe to Amazon QuickSight, and also to allow the user to upgrade the subscription to Enterprise edition.

        Access Level: Write

        Possible conditions:

        - .ifEdition()
        - .ifDirectoryType()

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toSubscribe", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Quicksight":
        '''(experimental) Grants permission to add tags to a QuickSight resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUnsubscribe")
    def to_unsubscribe(self) -> "Quicksight":
        '''(experimental) Grants permission to unsubscribe from Amazon QuickSight, which permanently deletes all users and their resources from Amazon QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUnsubscribe", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Quicksight":
        '''(experimental) Grants permission to remove tags from a QuickSight resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateAccountCustomization")
    def to_update_account_customization(self) -> "Quicksight":
        '''(experimental) Grants permission to update an account customization for QuickSight account or namespace.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAccountCustomization.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateAccountCustomization", []))

    @jsii.member(jsii_name="toUpdateAccountSettings")
    def to_update_account_settings(self) -> "Quicksight":
        '''(experimental) Grants permission to update the administrative account settings for QuickSight account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAccountSettings.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateAccountSettings", []))

    @jsii.member(jsii_name="toUpdateAnalysis")
    def to_update_analysis(self) -> "Quicksight":
        '''(experimental) Grants permission to update an analysis.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAnalysis.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateAnalysis", []))

    @jsii.member(jsii_name="toUpdateAnalysisPermissions")
    def to_update_analysis_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to update permissions for an analysis.

        Access Level: Permissions management

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAnalysisPermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateAnalysisPermissions", []))

    @jsii.member(jsii_name="toUpdateCustomPermissions")
    def to_update_custom_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to update a custom permissions resource.

        Access Level: Permissions management

        https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateCustomPermissions", []))

    @jsii.member(jsii_name="toUpdateDashboard")
    def to_update_dashboard(self) -> "Quicksight":
        '''(experimental) Grants permission to update a QuickSight Dashboard.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboard.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateDashboard", []))

    @jsii.member(jsii_name="toUpdateDashboardPermissions")
    def to_update_dashboard_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to update permissions for a QuickSight Dashboard.

        Access Level: Permissions management

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateDashboardPermissions", []))

    @jsii.member(jsii_name="toUpdateDashboardPublishedVersion")
    def to_update_dashboard_published_version(self) -> "Quicksight":
        '''(experimental) Grants permission to update a QuickSight Dashboard’s Published Version.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateDashboardPublishedVersion", []))

    @jsii.member(jsii_name="toUpdateDataSet")
    def to_update_data_set(self) -> "Quicksight":
        '''(experimental) Grants permission to update a dataset.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - quicksight:PassDataSource

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSet.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateDataSet", []))

    @jsii.member(jsii_name="toUpdateDataSetPermissions")
    def to_update_data_set_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to update the resource policy of a dataset.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSetPermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateDataSetPermissions", []))

    @jsii.member(jsii_name="toUpdateDataSource")
    def to_update_data_source(self) -> "Quicksight":
        '''(experimental) Grants permission to update a data source.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSource.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateDataSource", []))

    @jsii.member(jsii_name="toUpdateDataSourcePermissions")
    def to_update_data_source_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to update the resource policy of a data source.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSourcePermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateDataSourcePermissions", []))

    @jsii.member(jsii_name="toUpdateEmailCustomizationTemplate")
    def to_update_email_customization_template(self) -> "Quicksight":
        '''(experimental) Grants permission to update a QuickSight email customization template.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight-email-templates.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateEmailCustomizationTemplate", []))

    @jsii.member(jsii_name="toUpdateFolder")
    def to_update_folder(self) -> "Quicksight":
        '''(experimental) Grants permission to update a QuickSight Folder.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateFolder.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateFolder", []))

    @jsii.member(jsii_name="toUpdateFolderPermissions")
    def to_update_folder_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to update permissions for a QuickSight Folder.

        Access Level: Permissions management

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateFolderPermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateFolderPermissions", []))

    @jsii.member(jsii_name="toUpdateGroup")
    def to_update_group(self) -> "Quicksight":
        '''(experimental) Grants permission to change group description.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateGroup.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateGroup", []))

    @jsii.member(jsii_name="toUpdateIAMPolicyAssignment")
    def to_update_iam_policy_assignment(self) -> "Quicksight":
        '''(experimental) Grants permission to update an existing assignment.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateIAMPolicyAssignment.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateIAMPolicyAssignment", []))

    @jsii.member(jsii_name="toUpdateIpRestriction")
    def to_update_ip_restriction(self) -> "Quicksight":
        '''(experimental) Grants permission to update the IP restrictions for QuickSight account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateIpRestriction.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateIpRestriction", []))

    @jsii.member(jsii_name="toUpdatePublicSharingSettings")
    def to_update_public_sharing_settings(self) -> "Quicksight":
        '''(experimental) Grants permission to enable or disable public sharing on an account.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdatePublicSharingSettings", []))

    @jsii.member(jsii_name="toUpdateResourcePermissions")
    def to_update_resource_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to update resource-level permissions in QuickSight.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateResourcePermissions", []))

    @jsii.member(jsii_name="toUpdateTemplate")
    def to_update_template(self) -> "Quicksight":
        '''(experimental) Grants permission to update a template.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTemplate.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateTemplate", []))

    @jsii.member(jsii_name="toUpdateTemplateAlias")
    def to_update_template_alias(self) -> "Quicksight":
        '''(experimental) Grants permission to update a template alias.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTemplateAlias.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateTemplateAlias", []))

    @jsii.member(jsii_name="toUpdateTemplatePermissions")
    def to_update_template_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to update permissions for a template.

        Access Level: Permissions management

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTemplatePermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateTemplatePermissions", []))

    @jsii.member(jsii_name="toUpdateTheme")
    def to_update_theme(self) -> "Quicksight":
        '''(experimental) Grants permission to update a theme.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTheme.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateTheme", []))

    @jsii.member(jsii_name="toUpdateThemeAlias")
    def to_update_theme_alias(self) -> "Quicksight":
        '''(experimental) Grants permission to update the alias of a theme.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemeAlias.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateThemeAlias", []))

    @jsii.member(jsii_name="toUpdateThemePermissions")
    def to_update_theme_permissions(self) -> "Quicksight":
        '''(experimental) Grants permission to update permissions for a theme.

        Access Level: Permissions management

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateThemePermissions", []))

    @jsii.member(jsii_name="toUpdateUser")
    def to_update_user(self) -> "Quicksight":
        '''(experimental) Grants permission to update an Amazon QuickSight user.

        Access Level: Write

        https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html

        :stability: experimental
        '''
        return typing.cast("Quicksight", jsii.invoke(self, "toUpdateUser", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c9b76a2f9c030a872af251f3975fa13d7a54e3775d1103db2f8fac2dc687f62)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__98cbb69d70a258c1ec4720497c6f44b6b547d0a9611ddd416e8171da124f3633)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Ram(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Ram"):
    '''(experimental) Statement provider for service `ram <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceaccessmanager.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `ram <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceaccessmanager.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3822d1b4cc4a9f83f686273ef60a69c1983dc0422ac7028bb074e4b327ea5f4b)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="ifAllowsExternalPrincipals")
    def if_allows_external_principals(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Ram":
        '''(experimental) Filters access based on resource shares that allow or deny sharing with external principals.

        For example, specify true if the action can only be performed on resource shares that allow sharing with external principals. External principals are AWS accounts that are outside of its AWS organization

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceShare()
        - .toDeleteResourceShare()
        - .toDisassociateResourceShare()
        - .toListResourceSharePermissions()
        - .toUpdateResourceShare()

        Applies to resource types:

        - resource-share

        :param value: ``true`` or ``false``. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__edc29dc6472e888320b0f91ea51686478fd8c997393e73e2bc0c0f049bf5f8c2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Ram", jsii.invoke(self, "ifAllowsExternalPrincipals", [value]))

    @jsii.member(jsii_name="ifPermissionArn")
    def if_permission_arn(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Ram":
        '''(experimental) Filters access based on the specified Permission ARN.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toGetPermission()

        Applies to resource types:

        - permission

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d4b5740df16a20cce153a878124a1effc6abfc10ed78b3f9070e3ba63c655aa6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Ram", jsii.invoke(self, "ifPermissionArn", [value, operator]))

    @jsii.member(jsii_name="ifPermissionResourceType")
    def if_permission_resource_type(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Ram":
        '''(experimental) Filters access based on permissions of specified resource type.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to resource types:

        - permission

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__08beefe5aeaf1a60b6b87b30aae9fa69bde0e974fa06710ce7afd1376846e5d7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Ram", jsii.invoke(self, "ifPermissionResourceType", [value, operator]))

    @jsii.member(jsii_name="ifPrincipal")
    def if_principal(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Ram":
        '''(experimental) Filters access based on the format of the specified principal.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceShare()
        - .toCreateResourceShare()
        - .toDisassociateResourceShare()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c55db46eb4ef21c0d822f1502de918da1c09d752828c2ac48d53d9b3ebeb44d9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Ram", jsii.invoke(self, "ifPrincipal", [value, operator]))

    @jsii.member(jsii_name="ifRequestedAllowsExternalPrincipals")
    def if_requested_allows_external_principals(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Ram":
        '''(experimental) Filters access based on the specified value for 'allowExternalPrincipals'.

        External principals are AWS accounts that are outside of its AWS Organization

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toCreateResourceShare()
        - .toUpdateResourceShare()

        :param value: ``true`` or ``false``. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e1394f3939b98d541ae36ba308ecfbfd65a8c6ef02611f321b89d27b6dfc6bf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Ram", jsii.invoke(self, "ifRequestedAllowsExternalPrincipals", [value]))

    @jsii.member(jsii_name="ifRequestedResourceType")
    def if_requested_resource_type(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Ram":
        '''(experimental) Filters access based on the specified resource type.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceShare()
        - .toCreateResourceShare()
        - .toDisassociateResourceShare()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__30a9f30e15645205eb4130141d3304d032a65faa7d2f975853b16a8f67f8f3c4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Ram", jsii.invoke(self, "ifRequestedResourceType", [value, operator]))

    @jsii.member(jsii_name="ifResourceArn")
    def if_resource_arn(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Ram":
        '''(experimental) Filters access based on a resource with the specified ARN.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceShare()
        - .toCreateResourceShare()
        - .toDisassociateResourceShare()

        :param value: The value(s) to check.
        :param operator: Works with `arn operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN>`_. **Default:** ``ArnLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__19ef0498863dae5ce81fa07a03dc63f4ce88383f2b8477e6b60b2540f899ec08)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Ram", jsii.invoke(self, "ifResourceArn", [value, operator]))

    @jsii.member(jsii_name="ifResourceShareName")
    def if_resource_share_name(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Ram":
        '''(experimental) Filters access based on a resource share with the specified name.

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAssociateResourceShare()
        - .toDeleteResourceShare()
        - .toDisassociateResourceShare()
        - .toListResourceSharePermissions()
        - .toUpdateResourceShare()

        Applies to resource types:

        - resource-share

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29de824846fd33a5fcbb51fa4fa317df22e60bbd07c8c276e6667b237f708c8b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Ram", jsii.invoke(self, "ifResourceShareName", [value, operator]))

    @jsii.member(jsii_name="ifShareOwnerAccountId")
    def if_share_owner_account_id(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Ram":
        '''(experimental) Filters access based on resource shares owned by a specific account.

        For example, you can use this condition key to specify which resource share invitations can be accepted or rejected based on the resource share owner's account ID

        https://docs.aws.amazon.com/ram/latest/userguide/iam-policies.html#iam-policies-condition

        Applies to actions:

        - .toAcceptResourceShareInvitation()
        - .toRejectResourceShareInvitation()

        Applies to resource types:

        - resource-share-invitation

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5e66a5957ef77079a9549af022fa1a1721146af39fbe75fd03da9f252cd8dfe1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Ram", jsii.invoke(self, "ifShareOwnerAccountId", [value, operator]))

    @jsii.member(jsii_name="onPermission")
    def on_permission(
        self,
        resource_path: builtins.str,
        account: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Ram":
        '''(experimental) Adds a resource of type permission to the statement.

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ResourceSharePermissionDetail.html

        :param resource_path: - Identifier for the resourcePath.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifPermissionArn() - .ifPermissionResourceType()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae8f56f25edb2679a6332dd9d802fb0a889002377848344754308333e80e8f63)
            check_type(argname="argument resource_path", value=resource_path, expected_type=type_hints["resource_path"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Ram", jsii.invoke(self, "onPermission", [resource_path, account, partition]))

    @jsii.member(jsii_name="onResourceShare")
    def on_resource_share(
        self,
        resource_path: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Ram":
        '''(experimental) Adds a resource of type resource-share to the statement.

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ResourceShare.html

        :param resource_path: - Identifier for the resourcePath.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifAllowsExternalPrincipals() - .ifResourceShareName()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eab14802bb8bb4a68566c7a4f08f47e6518e5e3bb4ce0559c9be70a422a45747)
            check_type(argname="argument resource_path", value=resource_path, expected_type=type_hints["resource_path"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Ram", jsii.invoke(self, "onResourceShare", [resource_path, account, region, partition]))

    @jsii.member(jsii_name="onResourceShareInvitation")
    def on_resource_share_invitation(
        self,
        resource_path: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Ram":
        '''(experimental) Adds a resource of type resource-share-invitation to the statement.

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ResourceShareInvitation.html

        :param resource_path: - Identifier for the resourcePath.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifShareOwnerAccountId()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff49915dd987b331ad3209995f07e5fba49eba6e7cc1523a27ef44f2b545799e)
            check_type(argname="argument resource_path", value=resource_path, expected_type=type_hints["resource_path"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Ram", jsii.invoke(self, "onResourceShareInvitation", [resource_path, account, region, partition]))

    @jsii.member(jsii_name="toAcceptResourceShareInvitation")
    def to_accept_resource_share_invitation(self) -> "Ram":
        '''(experimental) Grants permission to accept the specified resource share invitation.

        Access Level: Write

        Possible conditions:

        - .ifShareOwnerAccountId()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toAcceptResourceShareInvitation", []))

    @jsii.member(jsii_name="toAssociateResourceShare")
    def to_associate_resource_share(self) -> "Ram":
        '''(experimental) Grants permission to associate resource(s) and/or principal(s) to a resource share.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifResourceShareName()
        - .ifAllowsExternalPrincipals()
        - .ifPrincipal()
        - .ifRequestedResourceType()
        - .ifResourceArn()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_AssociateResourceShare.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toAssociateResourceShare", []))

    @jsii.member(jsii_name="toAssociateResourceSharePermission")
    def to_associate_resource_share_permission(self) -> "Ram":
        '''(experimental) Grants permission to associate a Permission with a Resource Share.

        Access Level: Write

        https://docs.aws.amazon.com/ram/latest/APIReference/API_AssociateResourceSharePermission.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toAssociateResourceSharePermission", []))

    @jsii.member(jsii_name="toCreateResourceShare")
    def to_create_resource_share(self) -> "Ram":
        '''(experimental) Grants permission to create a resource share with provided resource(s) and/or principal(s).

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifRequestedResourceType()
        - .ifResourceArn()
        - .ifRequestedAllowsExternalPrincipals()
        - .ifPrincipal()

        Dependent actions:

        - ec2:CreateTags

        https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toCreateResourceShare", []))

    @jsii.member(jsii_name="toDeleteResourceShare")
    def to_delete_resource_share(self) -> "Ram":
        '''(experimental) Grants permission to delete resource share.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifResourceShareName()
        - .ifAllowsExternalPrincipals()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_DeleteResourceShare.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toDeleteResourceShare", []))

    @jsii.member(jsii_name="toDisassociateResourceShare")
    def to_disassociate_resource_share(self) -> "Ram":
        '''(experimental) Grants permission to disassociate resource(s) and/or principal(s) from a resource share.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifResourceShareName()
        - .ifAllowsExternalPrincipals()
        - .ifPrincipal()
        - .ifRequestedResourceType()
        - .ifResourceArn()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_DisassociateResourceShare.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toDisassociateResourceShare", []))

    @jsii.member(jsii_name="toDisassociateResourceSharePermission")
    def to_disassociate_resource_share_permission(self) -> "Ram":
        '''(experimental) Grants permission to disassociate a Permission from a Resource Share.

        Access Level: Write

        https://docs.aws.amazon.com/ram/latest/APIReference/API_DisassociateResourceSharePermission.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toDisassociateResourceSharePermission", []))

    @jsii.member(jsii_name="toEnableSharingWithAwsOrganization")
    def to_enable_sharing_with_aws_organization(self) -> "Ram":
        '''(experimental) Grants permission to access customer's organization and create a SLR in the customer's account.

        Access Level: Permissions management

        Dependent actions:

        - iam:CreateServiceLinkedRole
        - organizations:DescribeOrganization
        - organizations:EnableAWSServiceAccess

        https://docs.aws.amazon.com/ram/latest/APIReference/API_EnableSharingWithAwsOrganization.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toEnableSharingWithAwsOrganization", []))

    @jsii.member(jsii_name="toGetPermission")
    def to_get_permission(self) -> "Ram":
        '''(experimental) Grants permission to get the contents of an AWS RAM permission.

        Access Level: Read

        Possible conditions:

        - .ifPermissionArn()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_GetPermission.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toGetPermission", []))

    @jsii.member(jsii_name="toGetResourcePolicies")
    def to_get_resource_policies(self) -> "Ram":
        '''(experimental) Grants permission to get the policies for the specified resources that you own and have shared.

        Access Level: Read

        https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourcePolicies.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toGetResourcePolicies", []))

    @jsii.member(jsii_name="toGetResourceShareAssociations")
    def to_get_resource_share_associations(self) -> "Ram":
        '''(experimental) Grants permission to get a set of resource share associations from a provided list or with a specified status of the specified type.

        Access Level: Read

        https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareAssociations.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toGetResourceShareAssociations", []))

    @jsii.member(jsii_name="toGetResourceShareInvitations")
    def to_get_resource_share_invitations(self) -> "Ram":
        '''(experimental) Grants permission to get resource share invitations by the specified invitation arn or those for the resource share.

        Access Level: Read

        https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toGetResourceShareInvitations", []))

    @jsii.member(jsii_name="toGetResourceShares")
    def to_get_resource_shares(self) -> "Ram":
        '''(experimental) Grants permission to get a set of resource shares from a provided list or with a specified status.

        Access Level: Read

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShares.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toGetResourceShares", []))

    @jsii.member(jsii_name="toListPendingInvitationResources")
    def to_list_pending_invitation_resources(self) -> "Ram":
        '''(experimental) Grants permission to list the resources in a resource share that is shared with you but that the invitation is still pending for.

        Access Level: Read

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toListPendingInvitationResources", []))

    @jsii.member(jsii_name="toListPermissions")
    def to_list_permissions(self) -> "Ram":
        '''(experimental) Grants permission to list the AWS RAM permissions.

        Access Level: List

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPermissions.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toListPermissions", []))

    @jsii.member(jsii_name="toListPermissionVersions")
    def to_list_permission_versions(self) -> "Ram":
        '''(experimental) Grants permission to list the versions of an AWS RAM permission.

        Access Level: List

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPermissionVersions.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toListPermissionVersions", []))

    @jsii.member(jsii_name="toListPrincipals")
    def to_list_principals(self) -> "Ram":
        '''(experimental) Grants permission to list the principals that you have shared resources with or that have shared resources with you.

        Access Level: List

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPrincipals.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toListPrincipals", []))

    @jsii.member(jsii_name="toListResources")
    def to_list_resources(self) -> "Ram":
        '''(experimental) Grants permission to list the resources that you added to resource shares or the resources that are shared with you.

        Access Level: List

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListResources.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toListResources", []))

    @jsii.member(jsii_name="toListResourceSharePermissions")
    def to_list_resource_share_permissions(self) -> "Ram":
        '''(experimental) Grants permission to list the Permissions associated with a Resource Share.

        Access Level: List

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifResourceShareName()
        - .ifAllowsExternalPrincipals()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListResourceSharePermissions.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toListResourceSharePermissions", []))

    @jsii.member(jsii_name="toListResourceTypes")
    def to_list_resource_types(self) -> "Ram":
        '''(experimental) Grants permission to list the shareable resource types supported by AWS RAM.

        Access Level: List

        https://docs.aws.amazon.com/ram/latest/APIReference/API_ListResourceTypes.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toListResourceTypes", []))

    @jsii.member(jsii_name="toPromoteResourceShareCreatedFromPolicy")
    def to_promote_resource_share_created_from_policy(self) -> "Ram":
        '''(experimental) Grants permission to promote the specified resource share.

        Access Level: Write

        https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toPromoteResourceShareCreatedFromPolicy", []))

    @jsii.member(jsii_name="toRejectResourceShareInvitation")
    def to_reject_resource_share_invitation(self) -> "Ram":
        '''(experimental) Grants permission to reject the specified resource share invitation.

        Access Level: Write

        Possible conditions:

        - .ifShareOwnerAccountId()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_RejectResourceShareInvitation.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toRejectResourceShareInvitation", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Ram":
        '''(experimental) Grants permission to tag the specified resource share.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Ram":
        '''(experimental) Grants permission to untag the specified resource share.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateResourceShare")
    def to_update_resource_share(self) -> "Ram":
        '''(experimental) Grants permission to update attributes of the resource share.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifResourceShareName()
        - .ifAllowsExternalPrincipals()
        - .ifRequestedAllowsExternalPrincipals()

        https://docs.aws.amazon.com/ram/latest/APIReference/API_UpdateResourceShare.html

        :stability: experimental
        '''
        return typing.cast("Ram", jsii.invoke(self, "toUpdateResourceShare", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b06a45f23f47775400812762f9a90aa7813270ebf83cea2fa4df4448b1919493)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eaf46aa0b566aac65efa2222d41af08a2888aaa9c384ac7f491926180d02314f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Rbin(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Rbin"):
    '''(experimental) Statement provider for service `rbin <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsrecyclebin.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `rbin <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsrecyclebin.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1486f9cc41f1f5bff928a4d3df8168339ac3ca60bc62b962d034e27ab9fcbf35)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="ifAttributeResourceType")
    def if_attribute_resource_type(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rbin":
        '''(experimental) Filters access by the resource type of the existing rule.

        https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-perms.html#rbin-condition-keys

        Applies to actions:

        - .toDeleteRule()
        - .toGetRule()
        - .toListTagsForResource()
        - .toLockRule()
        - .toTagResource()
        - .toUnlockRule()
        - .toUntagResource()
        - .toUpdateRule()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d42b9dc9e2b4471c2e3c2f3bbd6aa9d38fbd975bbeae0669800fe7005ddd1ba)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rbin", jsii.invoke(self, "ifAttributeResourceType", [value, operator]))

    @jsii.member(jsii_name="ifRequestResourceType")
    def if_request_resource_type(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rbin":
        '''(experimental) Filters access by the resource type in a request.

        https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-perms.html#rbin-condition-keys

        Applies to actions:

        - .toCreateRule()
        - .toListRules()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3dc90fde4b73e7da33177c3f72d7ccf8240f226c31750ab626b76607a585dc57)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rbin", jsii.invoke(self, "ifRequestResourceType", [value, operator]))

    @jsii.member(jsii_name="onRule")
    def on_rule(
        self,
        resource_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rbin":
        '''(experimental) Adds a resource of type rule to the statement.

        https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-recycle-bin.html#recycle-bin-concepts

        :param resource_name: - Identifier for the resourceName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ee598b2dd198e3f75f23fe52aa36876c48aef8bb26ef018047a30c117ffd1e90)
            check_type(argname="argument resource_name", value=resource_name, expected_type=type_hints["resource_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rbin", jsii.invoke(self, "onRule", [resource_name, account, region, partition]))

    @jsii.member(jsii_name="toCreateRule")
    def to_create_rule(self) -> "Rbin":
        '''(experimental) Grants permission to create a Recycle Bin retention rule.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifRequestResourceType()

        https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_CreateRule.html

        :stability: experimental
        '''
        return typing.cast("Rbin", jsii.invoke(self, "toCreateRule", []))

    @jsii.member(jsii_name="toDeleteRule")
    def to_delete_rule(self) -> "Rbin":
        '''(experimental) Grants permission to delete a Recycle Bin retention rule.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAttributeResourceType()

        https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_DeleteRule.html

        :stability: experimental
        '''
        return typing.cast("Rbin", jsii.invoke(self, "toDeleteRule", []))

    @jsii.member(jsii_name="toGetRule")
    def to_get_rule(self) -> "Rbin":
        '''(experimental) Grants permission to get detailed information about a Recycle Bin retention rule.

        Access Level: Read

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAttributeResourceType()

        https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_GetRule.html

        :stability: experimental
        '''
        return typing.cast("Rbin", jsii.invoke(self, "toGetRule", []))

    @jsii.member(jsii_name="toListRules")
    def to_list_rules(self) -> "Rbin":
        '''(experimental) Grants permission to list the Recycle Bin retention rules in the Region.

        Access Level: Read

        Possible conditions:

        - .ifRequestResourceType()

        https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_ListRules.html

        :stability: experimental
        '''
        return typing.cast("Rbin", jsii.invoke(self, "toListRules", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Rbin":
        '''(experimental) Grants permission to list the tags associated with a resource.

        Access Level: Read

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAttributeResourceType()

        https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("Rbin", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toLockRule")
    def to_lock_rule(self) -> "Rbin":
        '''(experimental) Grants permission to lock an existing Recycle Bin retention rule.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAttributeResourceType()

        https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_LockRule.html

        :stability: experimental
        '''
        return typing.cast("Rbin", jsii.invoke(self, "toLockRule", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Rbin":
        '''(experimental) Grants permission to add or update tags of a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsResourceTag()
        - .ifAwsTagKeys()
        - .ifAttributeResourceType()

        https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("Rbin", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUnlockRule")
    def to_unlock_rule(self) -> "Rbin":
        '''(experimental) Grants permission to unlock an existing Recycle Bin retention rule.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAttributeResourceType()

        https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_UnlockRule.html

        :stability: experimental
        '''
        return typing.cast("Rbin", jsii.invoke(self, "toUnlockRule", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Rbin":
        '''(experimental) Grants permission to remove tags associated with a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAwsTagKeys()
        - .ifAttributeResourceType()

        https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("Rbin", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateRule")
    def to_update_rule(self) -> "Rbin":
        '''(experimental) Grants permission to update an existing Recycle Bin retention rule.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAttributeResourceType()

        https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_UpdateRule.html

        :stability: experimental
        '''
        return typing.cast("Rbin", jsii.invoke(self, "toUpdateRule", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8086a2dc6ceb80228d6e78481fa70541388de317a80d3cf8552f0d0f029b8f54)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4b1c354f50488609029035641f684c68550703113af13465c3999d2eb5642fb0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Rds(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Rds"):
    '''(experimental) Statement provider for service `rds <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrds.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `rds <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrds.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7636c7610b67a46cc205ee185ac20840292e31ea7e1f6ae1438a1302d18cb8d3)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="ifBackupTarget")
    def if_backup_target(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the type of backup target. One of: REGION, OUTPOSTS.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateDBInstance()
        - .toCreateDBSnapshot()
        - .toRestoreDBInstanceFromDBSnapshot()
        - .toRestoreDBInstanceToPointInTime()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3ab3000f6eeae99280359a85ca8bd42b1ad99f906b46c6bf65c163fda195b311)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifBackupTarget", [value, operator]))

    @jsii.member(jsii_name="ifClusterPgTag")
    def if_cluster_pg_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to a DB cluster parameter group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()

        Applies to resource types:

        - cluster-pg

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a253608cf4e7826cd7af909fbf9334f347e3bd2a27fba6408e058d46395a7a4a)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifClusterPgTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifClusterSnapshotTag")
    def if_cluster_snapshot_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to a DB cluster snapshot.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - cluster-snapshot

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__937e42469632c2901d47608bd47a36b34debef19c6936aff4d95b44fc0c6b5da)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifClusterSnapshotTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifClusterTag")
    def if_cluster_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to a DB cluster.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()

        Applies to resource types:

        - cluster

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__425e6e8696b48a751150a3b1781d9a56909cc9cc11c816c6ff802846b3f6bbb4)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifClusterTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifCopyOptionGroup")
    def if_copy_option_group(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the value that specifies whether the CopyDBSnapshot action requires copying the DB option group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCopyDBSnapshot()

        :param value: ``true`` or ``false``. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b41bb04381e5c500622c998047ed3581ed1fbea242f242ed630ae0f47de3e0e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Rds", jsii.invoke(self, "ifCopyOptionGroup", [value]))

    @jsii.member(jsii_name="ifDatabaseClass")
    def if_database_class(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the type of DB instance class.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()
        - .toCreateDBCluster()
        - .toModifyDBCluster()
        - .toRestoreDBClusterFromSnapshot()
        - .toRestoreDBClusterToPointInTime()

        Applies to resource types:

        - db

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__904e44a881682bf5233765b57dc3bd91ccc72318dbb3d9899f14abb79da2098d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifDatabaseClass", [value, operator]))

    @jsii.member(jsii_name="ifDatabaseEngine")
    def if_database_engine(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the database engine. For possible values refer to the engine parameter in CreateDBInstance API.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()
        - .toCreateDBCluster()
        - .toRestoreDBClusterFromS3()

        Applies to resource types:

        - db

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b37d8177ecc1aee46e9c20a608d7256d803a462d9d7cf48e6fa268438a70acda)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifDatabaseEngine", [value, operator]))

    @jsii.member(jsii_name="ifDatabaseName")
    def if_database_name(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the user-defined name of the database on the DB instance.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()
        - .toCreateDBCluster()
        - .toRestoreDBClusterFromS3()

        Applies to resource types:

        - db

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b5db3d253745c3e30570a1cf00b3aab26c70a7f9cb500ffbb655072c4c00f28)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifDatabaseName", [value, operator]))

    @jsii.member(jsii_name="ifDbTag")
    def if_db_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to a DB instance.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()

        Applies to resource types:

        - db

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a8e31a6f7b197aff8ff896883985b2832087b1fce226fa794e77d3a0fea2d65)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifDbTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifEndpointType")
    def if_endpoint_type(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the type of the endpoint. One of: READER, WRITER, CUSTOM.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateDBClusterEndpoint()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9df5f72cb1251a39e75f0b838a038bd4ef9569c090b5f31612ebc3e20d5f1cd2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifEndpointType", [value, operator]))

    @jsii.member(jsii_name="ifEsTag")
    def if_es_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to an event subscription.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - es

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__834b80e9fd553b9c58ea4a872e2bfe4f0736a2af8cdfb672d00c248b13f00700)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifEsTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifManageMasterUserPassword")
    def if_manage_master_user_password(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the value that specifies whether RDS manages master user password in AWS Secrets Manager for the DB instance or cluster.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateDBCluster()
        - .toCreateDBInstance()
        - .toModifyDBCluster()
        - .toModifyDBInstance()
        - .toRestoreDBClusterFromS3()
        - .toRestoreDBInstanceFromS3()

        :param value: ``true`` or ``false``. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cbc12ce971413a37a4d8a3345d7c73181168073c6c86c261b5ce4f508443faf1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Rds", jsii.invoke(self, "ifManageMasterUserPassword", [value]))

    @jsii.member(jsii_name="ifMultiAz")
    def if_multi_az(self, value: typing.Optional[builtins.bool] = None) -> "Rds":
        '''(experimental) Filters access by the value that specifies whether the DB instance runs in multiple Availability Zones.

        To indicate that the DB instance is using Multi-AZ, specify true

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()

        Applies to resource types:

        - db

        :param value: ``true`` or ``false``. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b6cc6588260d4ca9cb732759e1f68c4410431abfa06651c0972ba93ab6a3e7f7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Rds", jsii.invoke(self, "ifMultiAz", [value]))

    @jsii.member(jsii_name="ifOgTag")
    def if_og_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to a DB option group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - og

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__57fe25efc8106d3ea75bc7ddb7f9de9c4804a87c3c19ae247bd4f633a327beef)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifOgTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifPgTag")
    def if_pg_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to a DB parameter group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()

        Applies to resource types:

        - pg

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5986517914b9b386eca46770322bea7d5dc3e42e74a965138d6a43c91be2946a)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifPgTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifPiops")
    def if_piops(
        self,
        value: typing.Union[jsii.Number, typing.Sequence[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the value that contains the number of Provisioned IOPS (PIOPS) that the instance supports.

        To indicate a DB instance that does not have PIOPS enabled, specify 0

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()
        - .toCreateDBCluster()
        - .toModifyDBCluster()
        - .toRestoreDBClusterFromSnapshot()
        - .toRestoreDBClusterToPointInTime()

        Applies to resource types:

        - db

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e58c252f84180070489f38e64dddb5a20b90dbe392bd768dfeb3a7707e48f4b6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifPiops", [value, operator]))

    @jsii.member(jsii_name="ifReqTag")
    def if_req_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the set of tag keys and values that can be used to tag a resource.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toAddTagsToResource()
        - .toCreateBlueGreenDeployment()
        - .toCreateDBCluster()
        - .toCreateDBClusterParameterGroup()
        - .toCreateDBClusterSnapshot()
        - .toCreateDBInstance()
        - .toCreateDBInstanceReadReplica()
        - .toCreateDBParameterGroup()
        - .toCreateDBSecurityGroup()
        - .toCreateDBSnapshot()
        - .toCreateDBSubnetGroup()
        - .toCreateEventSubscription()
        - .toCreateOptionGroup()
        - .toDeleteBlueGreenDeployment()
        - .toRemoveTagsFromResource()
        - .toRestoreDBClusterFromS3()
        - .toRestoreDBClusterFromSnapshot()
        - .toRestoreDBClusterToPointInTime()
        - .toRestoreDBInstanceFromDBSnapshot()
        - .toRestoreDBInstanceFromS3()
        - .toRestoreDBInstanceToPointInTime()
        - .toSwitchoverBlueGreenDeployment()

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a2012c53b46afa2e72f7e694b30d7bdece323525e0d3c8b218786c0917954cb2)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifReqTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifRiTag")
    def if_ri_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to a reserved DB instance.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - ri

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71890cb61a5e334ed6bf74806e7ddcb37e2f5f7e37ad8d08c5747dd4d624c98c)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifRiTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifSecgrpTag")
    def if_secgrp_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to a DB security group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - secgrp

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e17ebdc6f35db16ebfc7eed058d426dbc7de6a8f9d27b9c4bba63c57ce0d8d3e)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifSecgrpTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifSnapshotTag")
    def if_snapshot_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to a DB snapshot.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - snapshot

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e27a364cfd3d6812b5b06b70776d8309c1996eac904fd26f8bf094bbf247094c)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifSnapshotTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifStorageEncrypted")
    def if_storage_encrypted(
        self,
        value: typing.Optional[builtins.bool] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the value that specifies whether the DB instance storage should be encrypted.

        To enforce storage encryption, specify true

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()
        - .toCreateDBCluster()
        - .toRestoreDBClusterFromS3()

        Applies to resource types:

        - db

        :param value: ``true`` or ``false``. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9726eab763c238f6cacc47eb2c4a1a46406e2a14ae3c9368dc62209237996acc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Rds", jsii.invoke(self, "ifStorageEncrypted", [value]))

    @jsii.member(jsii_name="ifStorageSize")
    def if_storage_size(
        self,
        value: typing.Union[jsii.Number, typing.Sequence[jsii.Number]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the storage volume size (in GB).

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()
        - .toCreateDBCluster()
        - .toModifyDBCluster()
        - .toRestoreDBClusterFromSnapshot()
        - .toRestoreDBClusterToPointInTime()

        Applies to resource types:

        - db

        :param value: The value(s) to check.
        :param operator: Works with `numeric operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric>`_. **Default:** ``NumericEquals``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63fa097f46dfa3accfdff9650adc3bb2d1b49070682a837a1cb0e12751835db4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifStorageSize", [value, operator]))

    @jsii.member(jsii_name="ifSubgrpTag")
    def if_subgrp_tag(
        self,
        tag_key: builtins.str,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Rds":
        '''(experimental) Filters access by the tag attached to a DB subnet group.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to resource types:

        - subgrp

        :param tag_key: The tag key to check.
        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59401e703abd303033d7148588e2719653eb05d0a46c7afcfc488455ae17e8cb)
            check_type(argname="argument tag_key", value=tag_key, expected_type=type_hints["tag_key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Rds", jsii.invoke(self, "ifSubgrpTag", [tag_key, value, operator]))

    @jsii.member(jsii_name="ifVpc")
    def if_vpc(self, value: typing.Optional[builtins.bool] = None) -> "Rds":
        '''(experimental) Filters access by the value that specifies whether the DB instance runs in an Amazon Virtual Private Cloud (Amazon VPC).

        To indicate that the DB instance runs in an Amazon VPC, specify true

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        Applies to actions:

        - .toCreateBlueGreenDeployment()

        Applies to resource types:

        - db

        :param value: ``true`` or ``false``. **Default:** ``true``

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47aaceaf6b257109bb64b9730a4f7f17f898b59ff7509356ee20291725502e31)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Rds", jsii.invoke(self, "ifVpc", [value]))

    @jsii.member(jsii_name="onCev")
    def on_cev(
        self,
        engine: builtins.str,
        engine_version: builtins.str,
        custom_db_engine_version_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type cev to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html

        :param engine: - Identifier for the engine.
        :param engine_version: - Identifier for the engineVersion.
        :param custom_db_engine_version_id: - Identifier for the customDbEngineVersionId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b447f32cb32f12a93e6ebde89bb22b0a66aa2c660135d307398b237e38d50f00)
            check_type(argname="argument engine", value=engine, expected_type=type_hints["engine"])
            check_type(argname="argument engine_version", value=engine_version, expected_type=type_hints["engine_version"])
            check_type(argname="argument custom_db_engine_version_id", value=custom_db_engine_version_id, expected_type=type_hints["custom_db_engine_version_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onCev", [engine, engine_version, custom_db_engine_version_id, account, region, partition]))

    @jsii.member(jsii_name="onCluster")
    def on_cluster(
        self,
        db_cluster_instance_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type cluster to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Aurora.html

        :param db_cluster_instance_name: - Identifier for the dbClusterInstanceName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifClusterTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c753bc15111843fb9b839d1bd2fbf23d7a123dcb3bdca2b6f4e279afa3413bb)
            check_type(argname="argument db_cluster_instance_name", value=db_cluster_instance_name, expected_type=type_hints["db_cluster_instance_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onCluster", [db_cluster_instance_name, account, region, partition]))

    @jsii.member(jsii_name="onClusterEndpoint")
    def on_cluster_endpoint(
        self,
        db_cluster_endpoint: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type cluster-endpoint to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.Endpoints.html

        :param db_cluster_endpoint: - Identifier for the dbClusterEndpoint.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c7eb63d7b4f879cce6ccfd80f14c782c5b4e34b6ed6bf1302d0cbc5201c0a576)
            check_type(argname="argument db_cluster_endpoint", value=db_cluster_endpoint, expected_type=type_hints["db_cluster_endpoint"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onClusterEndpoint", [db_cluster_endpoint, account, region, partition]))

    @jsii.member(jsii_name="onClusterPg")
    def on_cluster_pg(
        self,
        cluster_parameter_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type cluster-pg to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html

        :param cluster_parameter_group_name: - Identifier for the clusterParameterGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifClusterPgTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6c490c31dbd2447d92402c8cc914e72d00c424f4dff8901e6deaa949ac8b7619)
            check_type(argname="argument cluster_parameter_group_name", value=cluster_parameter_group_name, expected_type=type_hints["cluster_parameter_group_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onClusterPg", [cluster_parameter_group_name, account, region, partition]))

    @jsii.member(jsii_name="onClusterSnapshot")
    def on_cluster_snapshot(
        self,
        cluster_snapshot_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type cluster-snapshot to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html

        :param cluster_snapshot_name: - Identifier for the clusterSnapshotName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifClusterSnapshotTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3bdbfdebf219e9af1a9e85e694a0978c89567ec24afe5ef4da8a11204f0cb67b)
            check_type(argname="argument cluster_snapshot_name", value=cluster_snapshot_name, expected_type=type_hints["cluster_snapshot_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onClusterSnapshot", [cluster_snapshot_name, account, region, partition]))

    @jsii.member(jsii_name="onDb")
    def on_db(
        self,
        db_instance_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type db to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.html

        :param db_instance_name: - Identifier for the dbInstanceName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifDatabaseClass() - .ifDatabaseEngine() - .ifDatabaseName() - .ifMultiAz() - .ifPiops() - .ifStorageEncrypted() - .ifStorageSize() - .ifVpc() - .ifDbTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__213e2c6d9767fc433dc45f567123efa6604cf2d4f3ddf0f68f79ab67c81831ec)
            check_type(argname="argument db_instance_name", value=db_instance_name, expected_type=type_hints["db_instance_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onDb", [db_instance_name, account, region, partition]))

    @jsii.member(jsii_name="onDeployment")
    def on_deployment(
        self,
        blue_green_deployment_identifier: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type deployment to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html

        :param blue_green_deployment_identifier: - Identifier for the blueGreenDeploymentIdentifier.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b4f600006871a45c1710df72018aa2a7ce6de4236038ed5a0aad56dc5dae66d1)
            check_type(argname="argument blue_green_deployment_identifier", value=blue_green_deployment_identifier, expected_type=type_hints["blue_green_deployment_identifier"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onDeployment", [blue_green_deployment_identifier, account, region, partition]))

    @jsii.member(jsii_name="onEs")
    def on_es(
        self,
        subscription_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type es to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html

        :param subscription_name: - Identifier for the subscriptionName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifEsTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__928e08473a4dfef632b767dba0b0a082d709f04be264ffba9fedbdd8ccf25c6e)
            check_type(argname="argument subscription_name", value=subscription_name, expected_type=type_hints["subscription_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onEs", [subscription_name, account, region, partition]))

    @jsii.member(jsii_name="onGlobalCluster")
    def on_global_cluster(
        self,
        global_cluster: builtins.str,
        account: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type global-cluster to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html

        :param global_cluster: - Identifier for the globalCluster.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ec5c5704d4354b0589c96caa43a9d47d06cfccf9f761bca5e020349f566b242)
            check_type(argname="argument global_cluster", value=global_cluster, expected_type=type_hints["global_cluster"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onGlobalCluster", [global_cluster, account, partition]))

    @jsii.member(jsii_name="onOg")
    def on_og(
        self,
        option_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type og to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithOptionGroups.html

        :param option_group_name: - Identifier for the optionGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifOgTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed21f825311c0a8ce6bf6268b65a9446b2776c0f3fb31b168795a39b84819c2e)
            check_type(argname="argument option_group_name", value=option_group_name, expected_type=type_hints["option_group_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onOg", [option_group_name, account, region, partition]))

    @jsii.member(jsii_name="onPg")
    def on_pg(
        self,
        parameter_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type pg to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html

        :param parameter_group_name: - Identifier for the parameterGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifPgTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a66cb7ea4b02f26afedf51b2b874f87124a738f9bb7f37b30a9dc16350dd55a4)
            check_type(argname="argument parameter_group_name", value=parameter_group_name, expected_type=type_hints["parameter_group_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onPg", [parameter_group_name, account, region, partition]))

    @jsii.member(jsii_name="onProxy")
    def on_proxy(
        self,
        db_proxy_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type proxy to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html

        :param db_proxy_id: - Identifier for the dbProxyId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a1850b338bc995d7428d75bb87174606e3c8c21b93a2f9ed44e835d9b052b13d)
            check_type(argname="argument db_proxy_id", value=db_proxy_id, expected_type=type_hints["db_proxy_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onProxy", [db_proxy_id, account, region, partition]))

    @jsii.member(jsii_name="onProxyEndpoint")
    def on_proxy_endpoint(
        self,
        db_proxy_endpoint_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type proxy-endpoint to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html

        :param db_proxy_endpoint_id: - Identifier for the dbProxyEndpointId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cbf4dc2b6c68613fbe9ce82be99733ec0f5d942bd17598481feac10a5e381682)
            check_type(argname="argument db_proxy_endpoint_id", value=db_proxy_endpoint_id, expected_type=type_hints["db_proxy_endpoint_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onProxyEndpoint", [db_proxy_endpoint_id, account, region, partition]))

    @jsii.member(jsii_name="onRi")
    def on_ri(
        self,
        reserved_db_instance_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type ri to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithReservedDBInstances.html

        :param reserved_db_instance_name: - Identifier for the reservedDbInstanceName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifRiTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__83095a235a94abc5648818ab6be50465e4c217ea25341e144abbf3f26c083b24)
            check_type(argname="argument reserved_db_instance_name", value=reserved_db_instance_name, expected_type=type_hints["reserved_db_instance_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onRi", [reserved_db_instance_name, account, region, partition]))

    @jsii.member(jsii_name="onSecgrp")
    def on_secgrp(
        self,
        security_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type secgrp to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.RDSSecurityGroups.html

        :param security_group_name: - Identifier for the securityGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifSecgrpTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4028da83b0fdae72dddcefdbfc7359ec51a10ab4acee564644d9bff225f556d1)
            check_type(argname="argument security_group_name", value=security_group_name, expected_type=type_hints["security_group_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onSecgrp", [security_group_name, account, region, partition]))

    @jsii.member(jsii_name="onSnapshot")
    def on_snapshot(
        self,
        snapshot_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type snapshot to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html

        :param snapshot_name: - Identifier for the snapshotName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifSnapshotTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dcd3e75bf0e014b5cc6a5205895bcdac55582d929429f8b124c82c76fa78f1fc)
            check_type(argname="argument snapshot_name", value=snapshot_name, expected_type=type_hints["snapshot_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onSnapshot", [snapshot_name, account, region, partition]))

    @jsii.member(jsii_name="onSubgrp")
    def on_subgrp(
        self,
        subnet_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type subgrp to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Scenarios.html#USER_VPC.Scenario1

        :param subnet_group_name: - Identifier for the subnetGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifSubgrpTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__012c3416c0096070e9f64b29a9a8eb3e144ae9ea20ffda6c73de184c603eeab3)
            check_type(argname="argument subnet_group_name", value=subnet_group_name, expected_type=type_hints["subnet_group_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onSubgrp", [subnet_group_name, account, region, partition]))

    @jsii.member(jsii_name="onTarget")
    def on_target(
        self,
        target_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type target to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html

        :param target_id: - Identifier for the targetId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18861f76cbeaed7bb9265ca79387e115937170477acea58a1d312387ee4c25a2)
            check_type(argname="argument target_id", value=target_id, expected_type=type_hints["target_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onTarget", [target_id, account, region, partition]))

    @jsii.member(jsii_name="onTargetGroup")
    def on_target_group(
        self,
        target_group_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rds":
        '''(experimental) Adds a resource of type target-group to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html

        :param target_group_id: - Identifier for the targetGroupId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c312ff6b8109c43614d52baeaffa0d7152ddb1fea80a9860a6414d07b2c0791a)
            check_type(argname="argument target_group_id", value=target_group_id, expected_type=type_hints["target_group_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rds", jsii.invoke(self, "onTargetGroup", [target_group_id, account, region, partition]))

    @jsii.member(jsii_name="toAddRoleToDBCluster")
    def to_add_role_to_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to associate an Identity and Access Management (IAM) role from an Aurora DB cluster.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AddRoleToDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toAddRoleToDBCluster", []))

    @jsii.member(jsii_name="toAddRoleToDBInstance")
    def to_add_role_to_db_instance(self) -> "Rds":
        '''(experimental) Grants permission to associate an AWS Identity and Access Management (IAM) role with a DB instance.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AddRoleToDBInstance.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toAddRoleToDBInstance", []))

    @jsii.member(jsii_name="toAddSourceIdentifierToSubscription")
    def to_add_source_identifier_to_subscription(self) -> "Rds":
        '''(experimental) Grants permission to add a source identifier to an existing RDS event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AddSourceIdentifierToSubscription.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toAddSourceIdentifierToSubscription", []))

    @jsii.member(jsii_name="toAddTagsToResource")
    def to_add_tags_to_resource(self) -> "Rds":
        '''(experimental) Grants permission to add metadata tags to an Amazon RDS resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AddTagsToResource.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toAddTagsToResource", []))

    @jsii.member(jsii_name="toApplyPendingMaintenanceAction")
    def to_apply_pending_maintenance_action(self) -> "Rds":
        '''(experimental) Grants permission to apply a pending maintenance action to a resource.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ApplyPendingMaintenanceAction.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toApplyPendingMaintenanceAction", []))

    @jsii.member(jsii_name="toAuthorizeDBSecurityGroupIngress")
    def to_authorize_db_security_group_ingress(self) -> "Rds":
        '''(experimental) Grants permission to enable ingress to a DBSecurityGroup using one of two forms of authorization.

        Access Level: Permissions management

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AuthorizeDBSecurityGroupIngress.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toAuthorizeDBSecurityGroupIngress", []))

    @jsii.member(jsii_name="toBacktrackDBCluster")
    def to_backtrack_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to backtrack a DB cluster to a specific time, without creating a new DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_BacktrackDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toBacktrackDBCluster", []))

    @jsii.member(jsii_name="toCancelExportTask")
    def to_cancel_export_task(self) -> "Rds":
        '''(experimental) Grants permission to cancel an export task in progress.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CancelExportTask.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCancelExportTask", []))

    @jsii.member(jsii_name="toCopyDBClusterParameterGroup")
    def to_copy_db_cluster_parameter_group(self) -> "Rds":
        '''(experimental) Grants permission to copy the specified DB cluster parameter group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CopyDBClusterParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCopyDBClusterParameterGroup", []))

    @jsii.member(jsii_name="toCopyDBClusterSnapshot")
    def to_copy_db_cluster_snapshot(self) -> "Rds":
        '''(experimental) Grants permission to create a snapshot of a DB cluster.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CopyDBClusterSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCopyDBClusterSnapshot", []))

    @jsii.member(jsii_name="toCopyDBParameterGroup")
    def to_copy_db_parameter_group(self) -> "Rds":
        '''(experimental) Grants permission to copy the specified DB parameter group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CopyDBParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCopyDBParameterGroup", []))

    @jsii.member(jsii_name="toCopyDBSnapshot")
    def to_copy_db_snapshot(self) -> "Rds":
        '''(experimental) Grants permission to copy the specified DB snapshot.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifCopyOptionGroup()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CopyDBSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCopyDBSnapshot", []))

    @jsii.member(jsii_name="toCopyOptionGroup")
    def to_copy_option_group(self) -> "Rds":
        '''(experimental) Grants permission to copy the specified option group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CopyOptionGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCopyOptionGroup", []))

    @jsii.member(jsii_name="toCreateBlueGreenDeployment")
    def to_create_blue_green_deployment(self) -> "Rds":
        '''(experimental) Grants permission to create a blue-green deployment for a given source cluster or instance.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsResourceTag()
        - .ifAwsTagKeys()
        - .ifClusterTag()
        - .ifClusterPgTag()
        - .ifDbTag()
        - .ifPgTag()
        - .ifReqTag()
        - .ifDatabaseEngine()
        - .ifDatabaseName()
        - .ifStorageEncrypted()
        - .ifDatabaseClass()
        - .ifStorageSize()
        - .ifMultiAz()
        - .ifPiops()
        - .ifVpc()

        Dependent actions:

        - rds:AddTagsToResource
        - rds:CreateDBCluster
        - rds:CreateDBClusterEndpoint
        - rds:CreateDBInstance
        - rds:CreateDBInstanceReadReplica

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateBlueGreenDeployment.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateBlueGreenDeployment", []))

    @jsii.member(jsii_name="toCreateCustomDBEngineVersion")
    def to_create_custom_db_engine_version(self) -> "Rds":
        '''(experimental) Grants permission to create a custom engine version.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - iam:CreateServiceLinkedRole
        - mediaimport:CreateDatabaseBinarySnapshot
        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateCustomDBEngineVersion.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateCustomDBEngineVersion", []))

    @jsii.member(jsii_name="toCreateDBCluster")
    def to_create_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to create a new Amazon Aurora DB cluster.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()
        - .ifDatabaseEngine()
        - .ifDatabaseName()
        - .ifStorageEncrypted()
        - .ifDatabaseClass()
        - .ifStorageSize()
        - .ifPiops()
        - .ifManageMasterUserPassword()

        Dependent actions:

        - iam:PassRole
        - kms:CreateGrant
        - kms:Decrypt
        - kms:DescribeKey
        - kms:GenerateDataKey
        - rds:AddTagsToResource
        - rds:CreateDBInstance
        - secretsmanager:CreateSecret
        - secretsmanager:TagResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBCluster", []))

    @jsii.member(jsii_name="toCreateDBClusterEndpoint")
    def to_create_db_cluster_endpoint(self) -> "Rds":
        '''(experimental) Grants permission to create a new custom endpoint and associates it with an Amazon Aurora DB cluster.

        Access Level: Write

        Possible conditions:

        - .ifEndpointType()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBClusterEndpoint.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBClusterEndpoint", []))

    @jsii.member(jsii_name="toCreateDBClusterParameterGroup")
    def to_create_db_cluster_parameter_group(self) -> "Rds":
        '''(experimental) Grants permission to create a new DB cluster parameter group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBClusterParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBClusterParameterGroup", []))

    @jsii.member(jsii_name="toCreateDBClusterSnapshot")
    def to_create_db_cluster_snapshot(self) -> "Rds":
        '''(experimental) Grants permission to create a snapshot of a DB cluster.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBClusterSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBClusterSnapshot", []))

    @jsii.member(jsii_name="toCreateDBInstance")
    def to_create_db_instance(self) -> "Rds":
        '''(experimental) Grants permission to create a new DB instance.

        Access Level: Write

        Possible conditions:

        - .ifBackupTarget()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()
        - .ifManageMasterUserPassword()

        Dependent actions:

        - iam:PassRole
        - kms:CreateGrant
        - kms:Decrypt
        - kms:DescribeKey
        - kms:GenerateDataKey
        - rds:AddTagsToResource
        - secretsmanager:CreateSecret
        - secretsmanager:TagResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBInstance", []))

    @jsii.member(jsii_name="toCreateDBInstanceReadReplica")
    def to_create_db_instance_read_replica(self) -> "Rds":
        '''(experimental) Grants permission to create a DB instance that acts as a Read Replica of a source DB instance.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - iam:PassRole
        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstanceReadReplica.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBInstanceReadReplica", []))

    @jsii.member(jsii_name="toCreateDBParameterGroup")
    def to_create_db_parameter_group(self) -> "Rds":
        '''(experimental) Grants permission to create a new DB parameter group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBParameterGroup", []))

    @jsii.member(jsii_name="toCreateDBProxy")
    def to_create_db_proxy(self) -> "Rds":
        '''(experimental) Grants permission to create a database proxy.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBProxy.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBProxy", []))

    @jsii.member(jsii_name="toCreateDBProxyEndpoint")
    def to_create_db_proxy_endpoint(self) -> "Rds":
        '''(experimental) Grants permission to create a database proxy endpoint.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBProxyEndpoint.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBProxyEndpoint", []))

    @jsii.member(jsii_name="toCreateDBSecurityGroup")
    def to_create_db_security_group(self) -> "Rds":
        '''(experimental) Grants permission to create a new DB security group. DB security groups control access to a DB instance.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBSecurityGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBSecurityGroup", []))

    @jsii.member(jsii_name="toCreateDBSnapshot")
    def to_create_db_snapshot(self) -> "Rds":
        '''(experimental) Grants permission to create a DBSnapshot.

        Access Level: Write

        Possible conditions:

        - .ifBackupTarget()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBSnapshot", []))

    @jsii.member(jsii_name="toCreateDBSubnetGroup")
    def to_create_db_subnet_group(self) -> "Rds":
        '''(experimental) Grants permission to create a new DB subnet group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBSubnetGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateDBSubnetGroup", []))

    @jsii.member(jsii_name="toCreateEventSubscription")
    def to_create_event_subscription(self) -> "Rds":
        '''(experimental) Grants permission to create an RDS event notification subscription.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateEventSubscription.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateEventSubscription", []))

    @jsii.member(jsii_name="toCreateGlobalCluster")
    def to_create_global_cluster(self) -> "Rds":
        '''(experimental) Grants permission to create an Aurora global database spread across multiple regions.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateGlobalCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateGlobalCluster", []))

    @jsii.member(jsii_name="toCreateOptionGroup")
    def to_create_option_group(self) -> "Rds":
        '''(experimental) Grants permission to create a new option group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateOptionGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCreateOptionGroup", []))

    @jsii.member(jsii_name="toCrossRegionCommunication")
    def to_cross_region_communication(self) -> "Rds":
        '''(experimental) Grants permission to access a resource in the remote Region when executing cross-Region operations, such as cross-Region snapshot copy or cross-Region read replica creation.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/security_iam_service-with-iam.html#UsingWithRDS.IAM.Conditions

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toCrossRegionCommunication", []))

    @jsii.member(jsii_name="toDeleteBlueGreenDeployment")
    def to_delete_blue_green_deployment(self) -> "Rds":
        '''(experimental) Grants permission to delete blue green deployments.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsResourceTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - rds:DeleteDBCluster
        - rds:DeleteDBClusterEndpoint
        - rds:DeleteDBInstance

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteBlueGreenDeployment.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteBlueGreenDeployment", []))

    @jsii.member(jsii_name="toDeleteCustomDBEngineVersion")
    def to_delete_custom_db_engine_version(self) -> "Rds":
        '''(experimental) Grants permission to delete an existing custom engine version.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteCustomDBEngineVersion.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteCustomDBEngineVersion", []))

    @jsii.member(jsii_name="toDeleteDBCluster")
    def to_delete_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to delete a previously provisioned DB cluster.

        Access Level: Write

        Dependent actions:

        - rds:DeleteDBInstance

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBCluster", []))

    @jsii.member(jsii_name="toDeleteDBClusterEndpoint")
    def to_delete_db_cluster_endpoint(self) -> "Rds":
        '''(experimental) Grants permission to delete a custom endpoint and removes it from an Amazon Aurora DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBClusterEndpoint.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBClusterEndpoint", []))

    @jsii.member(jsii_name="toDeleteDBClusterParameterGroup")
    def to_delete_db_cluster_parameter_group(self) -> "Rds":
        '''(experimental) Grants permission to delete a specified DB cluster parameter group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBClusterParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBClusterParameterGroup", []))

    @jsii.member(jsii_name="toDeleteDBClusterSnapshot")
    def to_delete_db_cluster_snapshot(self) -> "Rds":
        '''(experimental) Grants permission to delete a DB cluster snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBClusterSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBClusterSnapshot", []))

    @jsii.member(jsii_name="toDeleteDBInstance")
    def to_delete_db_instance(self) -> "Rds":
        '''(experimental) Grants permission to delete a previously provisioned DB instance.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBInstance.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBInstance", []))

    @jsii.member(jsii_name="toDeleteDBInstanceAutomatedBackup")
    def to_delete_db_instance_automated_backup(self) -> "Rds":
        '''(experimental) Grants permission to deletes automated backups based on the source instance's DbiResourceId value or the restorable instance's resource ID.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBInstanceAutomatedBackup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBInstanceAutomatedBackup", []))

    @jsii.member(jsii_name="toDeleteDBParameterGroup")
    def to_delete_db_parameter_group(self) -> "Rds":
        '''(experimental) Grants permission to delete a specified DBParameterGroup.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBParameterGroup", []))

    @jsii.member(jsii_name="toDeleteDBProxy")
    def to_delete_db_proxy(self) -> "Rds":
        '''(experimental) Grants permission to delete a database proxy.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBProxy.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBProxy", []))

    @jsii.member(jsii_name="toDeleteDBProxyEndpoint")
    def to_delete_db_proxy_endpoint(self) -> "Rds":
        '''(experimental) Grants permission to delete a database proxy endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBProxyEndpoint.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBProxyEndpoint", []))

    @jsii.member(jsii_name="toDeleteDBSecurityGroup")
    def to_delete_db_security_group(self) -> "Rds":
        '''(experimental) Grants permission to delete a DB security group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBSecurityGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBSecurityGroup", []))

    @jsii.member(jsii_name="toDeleteDBSnapshot")
    def to_delete_db_snapshot(self) -> "Rds":
        '''(experimental) Grants permission to delete a DBSnapshot.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBSnapshot", []))

    @jsii.member(jsii_name="toDeleteDBSubnetGroup")
    def to_delete_db_subnet_group(self) -> "Rds":
        '''(experimental) Grants permission to delete a DB subnet group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteDBSubnetGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteDBSubnetGroup", []))

    @jsii.member(jsii_name="toDeleteEventSubscription")
    def to_delete_event_subscription(self) -> "Rds":
        '''(experimental) Grants permission to delete an RDS event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteEventSubscription.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteEventSubscription", []))

    @jsii.member(jsii_name="toDeleteGlobalCluster")
    def to_delete_global_cluster(self) -> "Rds":
        '''(experimental) Grants permission to delete a global database cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteGlobalCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteGlobalCluster", []))

    @jsii.member(jsii_name="toDeleteOptionGroup")
    def to_delete_option_group(self) -> "Rds":
        '''(experimental) Grants permission to delete an existing option group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeleteOptionGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeleteOptionGroup", []))

    @jsii.member(jsii_name="toDeregisterDBProxyTargets")
    def to_deregister_db_proxy_targets(self) -> "Rds":
        '''(experimental) Grants permission to remove targets from a database proxy target group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DeregisterDBProxyTargets.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDeregisterDBProxyTargets", []))

    @jsii.member(jsii_name="toDescribeAccountAttributes")
    def to_describe_account_attributes(self) -> "Rds":
        '''(experimental) Grants permission to list all of the attributes for a customer account.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeAccountAttributes.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeAccountAttributes", []))

    @jsii.member(jsii_name="toDescribeBlueGreenDeployments")
    def to_describe_blue_green_deployments(self) -> "Rds":
        '''(experimental) Grants permission to describe blue green deployments.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeBlueGreenDeployments.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeBlueGreenDeployments", []))

    @jsii.member(jsii_name="toDescribeCertificates")
    def to_describe_certificates(self) -> "Rds":
        '''(experimental) Grants permission to list the set of CA certificates provided by Amazon RDS for this AWS account.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeCertificates.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeCertificates", []))

    @jsii.member(jsii_name="toDescribeDBClusterBacktracks")
    def to_describe_db_cluster_backtracks(self) -> "Rds":
        '''(experimental) Grants permission to return information about backtracks for a DB cluster.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterBacktracks.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBClusterBacktracks", []))

    @jsii.member(jsii_name="toDescribeDBClusterEndpoints")
    def to_describe_db_cluster_endpoints(self) -> "Rds":
        '''(experimental) Grants permission to return information about endpoints for an Amazon Aurora DB cluster.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterEndpoints.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBClusterEndpoints", []))

    @jsii.member(jsii_name="toDescribeDBClusterParameterGroups")
    def to_describe_db_cluster_parameter_groups(self) -> "Rds":
        '''(experimental) Grants permission to return a list of DBClusterParameterGroup descriptions.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterParameterGroups.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBClusterParameterGroups", []))

    @jsii.member(jsii_name="toDescribeDBClusterParameters")
    def to_describe_db_cluster_parameters(self) -> "Rds":
        '''(experimental) Grants permission to return the detailed parameter list for a particular DB cluster parameter group.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterParameters.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBClusterParameters", []))

    @jsii.member(jsii_name="toDescribeDBClusters")
    def to_describe_db_clusters(self) -> "Rds":
        '''(experimental) Grants permission to return information about provisioned Aurora DB clusters.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBClusters", []))

    @jsii.member(jsii_name="toDescribeDBClusterSnapshotAttributes")
    def to_describe_db_cluster_snapshot_attributes(self) -> "Rds":
        '''(experimental) Grants permission to return a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterSnapshotAttributes.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBClusterSnapshotAttributes", []))

    @jsii.member(jsii_name="toDescribeDBClusterSnapshots")
    def to_describe_db_cluster_snapshots(self) -> "Rds":
        '''(experimental) Grants permission to return information about DB cluster snapshots.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusterSnapshots.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBClusterSnapshots", []))

    @jsii.member(jsii_name="toDescribeDBEngineVersions")
    def to_describe_db_engine_versions(self) -> "Rds":
        '''(experimental) Grants permission to return a list of the available DB engines.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBEngineVersions.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBEngineVersions", []))

    @jsii.member(jsii_name="toDescribeDBInstanceAutomatedBackups")
    def to_describe_db_instance_automated_backups(self) -> "Rds":
        '''(experimental) Grants permission to return a list of automated backups for both current and deleted instances.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstanceAutomatedBackups.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBInstanceAutomatedBackups", []))

    @jsii.member(jsii_name="toDescribeDBInstances")
    def to_describe_db_instances(self) -> "Rds":
        '''(experimental) Grants permission to return information about provisioned RDS instances.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBInstances", []))

    @jsii.member(jsii_name="toDescribeDBLogFiles")
    def to_describe_db_log_files(self) -> "Rds":
        '''(experimental) Grants permission to return a list of DB log files for the DB instance.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBLogFiles.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBLogFiles", []))

    @jsii.member(jsii_name="toDescribeDBParameterGroups")
    def to_describe_db_parameter_groups(self) -> "Rds":
        '''(experimental) Grants permission to return a list of DBParameterGroup descriptions.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBParameterGroups.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBParameterGroups", []))

    @jsii.member(jsii_name="toDescribeDBParameters")
    def to_describe_db_parameters(self) -> "Rds":
        '''(experimental) Grants permission to return the detailed parameter list for a particular DB parameter group.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBParameters.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBParameters", []))

    @jsii.member(jsii_name="toDescribeDBProxies")
    def to_describe_db_proxies(self) -> "Rds":
        '''(experimental) Grants permission to view proxies.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBProxies.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBProxies", []))

    @jsii.member(jsii_name="toDescribeDBProxyEndpoints")
    def to_describe_db_proxy_endpoints(self) -> "Rds":
        '''(experimental) Grants permission to view proxy endpoints.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBProxyEndpoints.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBProxyEndpoints", []))

    @jsii.member(jsii_name="toDescribeDBProxyTargetGroups")
    def to_describe_db_proxy_target_groups(self) -> "Rds":
        '''(experimental) Grants permission to view database proxy target group details.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBProxyTargetGroups.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBProxyTargetGroups", []))

    @jsii.member(jsii_name="toDescribeDBProxyTargets")
    def to_describe_db_proxy_targets(self) -> "Rds":
        '''(experimental) Grants permission to view database proxy target details.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBProxyTargets.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBProxyTargets", []))

    @jsii.member(jsii_name="toDescribeDBSecurityGroups")
    def to_describe_db_security_groups(self) -> "Rds":
        '''(experimental) Grants permission to return a list of DBSecurityGroup descriptions.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBSecurityGroups.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBSecurityGroups", []))

    @jsii.member(jsii_name="toDescribeDBSnapshotAttributes")
    def to_describe_db_snapshot_attributes(self) -> "Rds":
        '''(experimental) Grants permission to return a list of DB snapshot attribute names and values for a manual DB snapshot.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBSnapshotAttributes.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBSnapshotAttributes", []))

    @jsii.member(jsii_name="toDescribeDBSnapshots")
    def to_describe_db_snapshots(self) -> "Rds":
        '''(experimental) Grants permission to return information about DB snapshots.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBSnapshots.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBSnapshots", []))

    @jsii.member(jsii_name="toDescribeDBSubnetGroups")
    def to_describe_db_subnet_groups(self) -> "Rds":
        '''(experimental) Grants permission to return a list of DBSubnetGroup descriptions.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBSubnetGroups.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeDBSubnetGroups", []))

    @jsii.member(jsii_name="toDescribeEngineDefaultClusterParameters")
    def to_describe_engine_default_cluster_parameters(self) -> "Rds":
        '''(experimental) Grants permission to return the default engine and system parameter information for the cluster database engine.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEngineDefaultClusterParameters.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeEngineDefaultClusterParameters", []))

    @jsii.member(jsii_name="toDescribeEngineDefaultParameters")
    def to_describe_engine_default_parameters(self) -> "Rds":
        '''(experimental) Grants permission to return the default engine and system parameter information for the specified database engine.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEngineDefaultParameters.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeEngineDefaultParameters", []))

    @jsii.member(jsii_name="toDescribeEventCategories")
    def to_describe_event_categories(self) -> "Rds":
        '''(experimental) Grants permission to display a list of categories for all event source types, or, if specified, for a specified source type.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEventCategories.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeEventCategories", []))

    @jsii.member(jsii_name="toDescribeEvents")
    def to_describe_events(self) -> "Rds":
        '''(experimental) Grants permission to return events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14 days.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEvents.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeEvents", []))

    @jsii.member(jsii_name="toDescribeEventSubscriptions")
    def to_describe_event_subscriptions(self) -> "Rds":
        '''(experimental) Grants permission to list all the subscription descriptions for a customer account.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEventSubscriptions.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeEventSubscriptions", []))

    @jsii.member(jsii_name="toDescribeExportTasks")
    def to_describe_export_tasks(self) -> "Rds":
        '''(experimental) Grants permission to return information about the export tasks.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeExportTasks.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeExportTasks", []))

    @jsii.member(jsii_name="toDescribeGlobalClusters")
    def to_describe_global_clusters(self) -> "Rds":
        '''(experimental) Grants permission to return information about Aurora global database clusters.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeGlobalClusters.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeGlobalClusters", []))

    @jsii.member(jsii_name="toDescribeOptionGroupOptions")
    def to_describe_option_group_options(self) -> "Rds":
        '''(experimental) Grants permission to describe all available options.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeOptionGroupOptions.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeOptionGroupOptions", []))

    @jsii.member(jsii_name="toDescribeOptionGroups")
    def to_describe_option_groups(self) -> "Rds":
        '''(experimental) Grants permission to describe the available option groups.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeOptionGroups.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeOptionGroups", []))

    @jsii.member(jsii_name="toDescribeOrderableDBInstanceOptions")
    def to_describe_orderable_db_instance_options(self) -> "Rds":
        '''(experimental) Grants permission to return a list of orderable DB instance options for the specified engine.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeOrderableDBInstanceOptions.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeOrderableDBInstanceOptions", []))

    @jsii.member(jsii_name="toDescribePendingMaintenanceActions")
    def to_describe_pending_maintenance_actions(self) -> "Rds":
        '''(experimental) Grants permission to return a list of resources (for example, DB instances) that have at least one pending maintenance action.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribePendingMaintenanceActions.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribePendingMaintenanceActions", []))

    @jsii.member(jsii_name="toDescribeRecommendationGroups")
    def to_describe_recommendation_groups(self) -> "Rds":
        '''(experimental) Grants permission to return information about recommendation groups.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonRDS/latest/USER_Recommendations.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeRecommendationGroups", []))

    @jsii.member(jsii_name="toDescribeRecommendations")
    def to_describe_recommendations(self) -> "Rds":
        '''(experimental) Grants permission to return information about recommendations.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonRDS/latest/USER_Recommendations.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeRecommendations", []))

    @jsii.member(jsii_name="toDescribeReservedDBInstances")
    def to_describe_reserved_db_instances(self) -> "Rds":
        '''(experimental) Grants permission to return information about reserved DB instances for this account, or about a specified reserved DB instance.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeReservedDBInstances.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeReservedDBInstances", []))

    @jsii.member(jsii_name="toDescribeReservedDBInstancesOfferings")
    def to_describe_reserved_db_instances_offerings(self) -> "Rds":
        '''(experimental) Grants permission to list available reserved DB instance offerings.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeReservedDBInstancesOfferings.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeReservedDBInstancesOfferings", []))

    @jsii.member(jsii_name="toDescribeSourceRegions")
    def to_describe_source_regions(self) -> "Rds":
        '''(experimental) Grants permission to return a list of the source AWS Regions where the current AWS Region can create a Read Replica or copy a DB snapshot from.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeSourceRegions.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeSourceRegions", []))

    @jsii.member(jsii_name="toDescribeValidDBInstanceModifications")
    def to_describe_valid_db_instance_modifications(self) -> "Rds":
        '''(experimental) Grants permission to list available modifications you can make to your DB instance.

        Access Level: List

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeValidDBInstanceModifications.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDescribeValidDBInstanceModifications", []))

    @jsii.member(jsii_name="toDownloadCompleteDBLogFile")
    def to_download_complete_db_log_file(self) -> "Rds":
        '''(experimental) Grants permission to download specified log file.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonRDS/latest/USER_LogAccess.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDownloadCompleteDBLogFile", []))

    @jsii.member(jsii_name="toDownloadDBLogFilePortion")
    def to_download_db_log_file_portion(self) -> "Rds":
        '''(experimental) Grants permission to download all or a portion of the specified log file, up to 1 MB in size.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DownloadDBLogFilePortion.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toDownloadDBLogFilePortion", []))

    @jsii.member(jsii_name="toFailoverDBCluster")
    def to_failover_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to force a failover for a DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_FailoverDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toFailoverDBCluster", []))

    @jsii.member(jsii_name="toFailoverGlobalCluster")
    def to_failover_global_cluster(self) -> "Rds":
        '''(experimental) Grants permission to failover a global cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_FailoverGlobalCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toFailoverGlobalCluster", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Rds":
        '''(experimental) Grants permission to list all tags on an Amazon RDS resource.

        Access Level: Read

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toModifyActivityStream")
    def to_modify_activity_stream(self) -> "Rds":
        '''(experimental) Grants permission to modify a database activity stream.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyActivityStream.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyActivityStream", []))

    @jsii.member(jsii_name="toModifyCertificates")
    def to_modify_certificates(self) -> "Rds":
        '''(experimental) Grants permission to modify the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificate for Amazon RDS for new DB instances.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyCertificates.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyCertificates", []))

    @jsii.member(jsii_name="toModifyCurrentDBClusterCapacity")
    def to_modify_current_db_cluster_capacity(self) -> "Rds":
        '''(experimental) Grants permission to modify current cluster capacity for an Amazon Aurora Severless DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyCurrentDBClusterCapacity.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyCurrentDBClusterCapacity", []))

    @jsii.member(jsii_name="toModifyCustomDBEngineVersion")
    def to_modify_custom_db_engine_version(self) -> "Rds":
        '''(experimental) Grants permission to modify an existing custom engine version.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyCustomDBEngineVersion.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyCustomDBEngineVersion", []))

    @jsii.member(jsii_name="toModifyDBCluster")
    def to_modify_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to modify a setting for an Amazon Aurora DB cluster.

        Access Level: Write

        Possible conditions:

        - .ifDatabaseClass()
        - .ifStorageSize()
        - .ifPiops()
        - .ifManageMasterUserPassword()

        Dependent actions:

        - iam:PassRole
        - kms:CreateGrant
        - kms:Decrypt
        - kms:DescribeKey
        - kms:GenerateDataKey
        - rds:ModifyDBInstance
        - secretsmanager:CreateSecret
        - secretsmanager:RotateSecret
        - secretsmanager:TagResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBCluster", []))

    @jsii.member(jsii_name="toModifyDBClusterEndpoint")
    def to_modify_db_cluster_endpoint(self) -> "Rds":
        '''(experimental) Grants permission to modify the properties of an endpoint in an Amazon Aurora DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBClusterEndpoint.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBClusterEndpoint", []))

    @jsii.member(jsii_name="toModifyDBClusterParameterGroup")
    def to_modify_db_cluster_parameter_group(self) -> "Rds":
        '''(experimental) Grants permission to modify the parameters of a DB cluster parameter group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBClusterParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBClusterParameterGroup", []))

    @jsii.member(jsii_name="toModifyDBClusterSnapshotAttribute")
    def to_modify_db_cluster_snapshot_attribute(self) -> "Rds":
        '''(experimental) Grants permission to add an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBClusterSnapshotAttribute.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBClusterSnapshotAttribute", []))

    @jsii.member(jsii_name="toModifyDBInstance")
    def to_modify_db_instance(self) -> "Rds":
        '''(experimental) Grants permission to modify settings for a DB instance.

        Access Level: Write

        Possible conditions:

        - .ifManageMasterUserPassword()

        Dependent actions:

        - iam:PassRole
        - kms:CreateGrant
        - kms:Decrypt
        - kms:DescribeKey
        - kms:GenerateDataKey
        - secretsmanager:CreateSecret
        - secretsmanager:RotateSecret
        - secretsmanager:TagResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBInstance.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBInstance", []))

    @jsii.member(jsii_name="toModifyDBParameterGroup")
    def to_modify_db_parameter_group(self) -> "Rds":
        '''(experimental) Grants permission to modify the parameters of a DB parameter group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBParameterGroup", []))

    @jsii.member(jsii_name="toModifyDBProxy")
    def to_modify_db_proxy(self) -> "Rds":
        '''(experimental) Grants permission to modify database proxy.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBProxy.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBProxy", []))

    @jsii.member(jsii_name="toModifyDBProxyEndpoint")
    def to_modify_db_proxy_endpoint(self) -> "Rds":
        '''(experimental) Grants permission to modify database proxy endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBProxyEndpoint.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBProxyEndpoint", []))

    @jsii.member(jsii_name="toModifyDBProxyTargetGroup")
    def to_modify_db_proxy_target_group(self) -> "Rds":
        '''(experimental) Grants permission to modify target group for a database proxy.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBProxyTargetGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBProxyTargetGroup", []))

    @jsii.member(jsii_name="toModifyDBSnapshot")
    def to_modify_db_snapshot(self) -> "Rds":
        '''(experimental) Grants permission to update a manual DB snapshot, which can be encrypted or not encrypted, with a new engine version.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBSnapshot", []))

    @jsii.member(jsii_name="toModifyDBSnapshotAttribute")
    def to_modify_db_snapshot_attribute(self) -> "Rds":
        '''(experimental) Grants permission to add an attribute and values to, or removes an attribute and values from, a manual DB snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBSnapshotAttribute.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBSnapshotAttribute", []))

    @jsii.member(jsii_name="toModifyDBSubnetGroup")
    def to_modify_db_subnet_group(self) -> "Rds":
        '''(experimental) Grants permission to modify an existing DB subnet group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBSubnetGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyDBSubnetGroup", []))

    @jsii.member(jsii_name="toModifyEventSubscription")
    def to_modify_event_subscription(self) -> "Rds":
        '''(experimental) Grants permission to modify an existing RDS event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyEventSubscription.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyEventSubscription", []))

    @jsii.member(jsii_name="toModifyGlobalCluster")
    def to_modify_global_cluster(self) -> "Rds":
        '''(experimental) Grants permission to modify a setting for an Amazon Aurora global cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyGlobalCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyGlobalCluster", []))

    @jsii.member(jsii_name="toModifyOptionGroup")
    def to_modify_option_group(self) -> "Rds":
        '''(experimental) Grants permission to modify an existing option group.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyOptionGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyOptionGroup", []))

    @jsii.member(jsii_name="toModifyRecommendation")
    def to_modify_recommendation(self) -> "Rds":
        '''(experimental) Grants permission to modify recommendation.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/USER_Recommendations.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toModifyRecommendation", []))

    @jsii.member(jsii_name="toPromoteReadReplica")
    def to_promote_read_replica(self) -> "Rds":
        '''(experimental) Grants permission to promote a Read Replica DB instance to a standalone DB instance.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_PromoteReadReplica.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toPromoteReadReplica", []))

    @jsii.member(jsii_name="toPromoteReadReplicaDBCluster")
    def to_promote_read_replica_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to promote a Read Replica DB cluster to a standalone DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_PromoteReadReplicaDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toPromoteReadReplicaDBCluster", []))

    @jsii.member(jsii_name="toPurchaseReservedDBInstancesOffering")
    def to_purchase_reserved_db_instances_offering(self) -> "Rds":
        '''(experimental) Grants permission to purchase a reserved DB instance offering.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_PurchaseReservedDBInstancesOffering.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toPurchaseReservedDBInstancesOffering", []))

    @jsii.member(jsii_name="toRebootDBCluster")
    def to_reboot_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to reboot a previously provisioned DB cluster.

        Access Level: Write

        Dependent actions:

        - rds:RebootDBInstance

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RebootDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRebootDBCluster", []))

    @jsii.member(jsii_name="toRebootDBInstance")
    def to_reboot_db_instance(self) -> "Rds":
        '''(experimental) Grants permission to restart the database engine service.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RebootDBInstance.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRebootDBInstance", []))

    @jsii.member(jsii_name="toRegisterDBProxyTargets")
    def to_register_db_proxy_targets(self) -> "Rds":
        '''(experimental) Grants permission to add targets to a database proxy target group.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RegisterDBProxyTargets.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRegisterDBProxyTargets", []))

    @jsii.member(jsii_name="toRemoveFromGlobalCluster")
    def to_remove_from_global_cluster(self) -> "Rds":
        '''(experimental) Grants permission to detach an Aurora secondary cluster from an Aurora global database cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RemoveFromGlobalCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRemoveFromGlobalCluster", []))

    @jsii.member(jsii_name="toRemoveRoleFromDBCluster")
    def to_remove_role_from_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to disassociate an AWS Identity and Access Management (IAM) role from an Amazon Aurora DB cluster.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RemoveRoleFromDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRemoveRoleFromDBCluster", []))

    @jsii.member(jsii_name="toRemoveRoleFromDBInstance")
    def to_remove_role_from_db_instance(self) -> "Rds":
        '''(experimental) Grants permission to disassociate an AWS Identity and Access Management (IAM) role from a DB instance.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RemoveRoleFromDBInstance.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRemoveRoleFromDBInstance", []))

    @jsii.member(jsii_name="toRemoveSourceIdentifierFromSubscription")
    def to_remove_source_identifier_from_subscription(self) -> "Rds":
        '''(experimental) Grants permission to remove a source identifier from an existing RDS event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RemoveSourceIdentifierFromSubscription.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRemoveSourceIdentifierFromSubscription", []))

    @jsii.member(jsii_name="toRemoveTagsFromResource")
    def to_remove_tags_from_resource(self) -> "Rds":
        '''(experimental) Grants permission to remove metadata tags from an Amazon RDS resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RemoveTagsFromResource.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRemoveTagsFromResource", []))

    @jsii.member(jsii_name="toResetDBClusterParameterGroup")
    def to_reset_db_cluster_parameter_group(self) -> "Rds":
        '''(experimental) Grants permission to modify the parameters of a DB cluster parameter group to the default value.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ResetDBClusterParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toResetDBClusterParameterGroup", []))

    @jsii.member(jsii_name="toResetDBParameterGroup")
    def to_reset_db_parameter_group(self) -> "Rds":
        '''(experimental) Grants permission to modify the parameters of a DB parameter group to the engine/system default value.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ResetDBParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toResetDBParameterGroup", []))

    @jsii.member(jsii_name="toRestoreDBClusterFromS3")
    def to_restore_db_cluster_from_s3(self) -> "Rds":
        '''(experimental) Grants permission to create an Amazon Aurora DB cluster from data stored in an Amazon S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()
        - .ifDatabaseEngine()
        - .ifDatabaseName()
        - .ifStorageEncrypted()
        - .ifManageMasterUserPassword()

        Dependent actions:

        - iam:PassRole
        - kms:CreateGrant
        - kms:Decrypt
        - kms:DescribeKey
        - kms:GenerateDataKey
        - rds:AddTagsToResource
        - secretsmanager:CreateSecret
        - secretsmanager:TagResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBClusterFromS3.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRestoreDBClusterFromS3", []))

    @jsii.member(jsii_name="toRestoreDBClusterFromSnapshot")
    def to_restore_db_cluster_from_snapshot(self) -> "Rds":
        '''(experimental) Grants permission to create a new DB cluster from a DB cluster snapshot.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()
        - .ifDatabaseClass()
        - .ifStorageSize()
        - .ifPiops()

        Dependent actions:

        - iam:PassRole
        - rds:AddTagsToResource
        - rds:CreateDBInstance

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBClusterFromSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRestoreDBClusterFromSnapshot", []))

    @jsii.member(jsii_name="toRestoreDBClusterToPointInTime")
    def to_restore_db_cluster_to_point_in_time(self) -> "Rds":
        '''(experimental) Grants permission to restore a DB cluster to an arbitrary point in time.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()
        - .ifDatabaseClass()
        - .ifStorageSize()
        - .ifPiops()

        Dependent actions:

        - iam:PassRole
        - rds:AddTagsToResource
        - rds:CreateDBInstance

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBClusterToPointInTime.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRestoreDBClusterToPointInTime", []))

    @jsii.member(jsii_name="toRestoreDBInstanceFromDBSnapshot")
    def to_restore_db_instance_from_db_snapshot(self) -> "Rds":
        '''(experimental) Grants permission to create a new DB instance from a DB snapshot.

        Access Level: Write

        Possible conditions:

        - .ifBackupTarget()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - iam:PassRole
        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromDBSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRestoreDBInstanceFromDBSnapshot", []))

    @jsii.member(jsii_name="toRestoreDBInstanceFromS3")
    def to_restore_db_instance_from_s3(self) -> "Rds":
        '''(experimental) Grants permission to create a new DB instance from an Amazon S3 bucket.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()
        - .ifManageMasterUserPassword()

        Dependent actions:

        - iam:PassRole
        - kms:CreateGrant
        - kms:Decrypt
        - kms:DescribeKey
        - kms:GenerateDataKey
        - rds:AddTagsToResource
        - secretsmanager:CreateSecret
        - secretsmanager:TagResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromS3.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRestoreDBInstanceFromS3", []))

    @jsii.member(jsii_name="toRestoreDBInstanceToPointInTime")
    def to_restore_db_instance_to_point_in_time(self) -> "Rds":
        '''(experimental) Grants permission to restore a DB instance to an arbitrary point in time.

        Access Level: Write

        Possible conditions:

        - .ifBackupTarget()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - iam:PassRole
        - rds:AddTagsToResource

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceToPointInTime.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRestoreDBInstanceToPointInTime", []))

    @jsii.member(jsii_name="toRevokeDBSecurityGroupIngress")
    def to_revoke_db_security_group_ingress(self) -> "Rds":
        '''(experimental) Grants permission to revoke ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC Security Groups.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RevokeDBSecurityGroupIngress.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toRevokeDBSecurityGroupIngress", []))

    @jsii.member(jsii_name="toStartActivityStream")
    def to_start_activity_stream(self) -> "Rds":
        '''(experimental) Grants permission to start Activity Stream.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartActivityStream.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toStartActivityStream", []))

    @jsii.member(jsii_name="toStartDBCluster")
    def to_start_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to start the DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toStartDBCluster", []))

    @jsii.member(jsii_name="toStartDBInstance")
    def to_start_db_instance(self) -> "Rds":
        '''(experimental) Grants permission to start the DB instance.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBInstance.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toStartDBInstance", []))

    @jsii.member(jsii_name="toStartDBInstanceAutomatedBackupsReplication")
    def to_start_db_instance_automated_backups_replication(self) -> "Rds":
        '''(experimental) Grants permission to start replication of automated backups to a different AWS Region.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBInstanceAutomatedBackupsReplication.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toStartDBInstanceAutomatedBackupsReplication", []))

    @jsii.member(jsii_name="toStartExportTask")
    def to_start_export_task(self) -> "Rds":
        '''(experimental) Grants permission to start a new Export task for a DB snapshot.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toStartExportTask", []))

    @jsii.member(jsii_name="toStopActivityStream")
    def to_stop_activity_stream(self) -> "Rds":
        '''(experimental) Grants permission to stop Activity Stream.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StopActivityStream.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toStopActivityStream", []))

    @jsii.member(jsii_name="toStopDBCluster")
    def to_stop_db_cluster(self) -> "Rds":
        '''(experimental) Grants permission to stop the DB cluster.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StopDBCluster.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toStopDBCluster", []))

    @jsii.member(jsii_name="toStopDBInstance")
    def to_stop_db_instance(self) -> "Rds":
        '''(experimental) Grants permission to stop the DB instance.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StopDBInstance.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toStopDBInstance", []))

    @jsii.member(jsii_name="toStopDBInstanceAutomatedBackupsReplication")
    def to_stop_db_instance_automated_backups_replication(self) -> "Rds":
        '''(experimental) Grants permission to stop automated backup replication for a DB instance.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StopDBInstanceAutomatedBackupsReplication.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toStopDBInstanceAutomatedBackupsReplication", []))

    @jsii.member(jsii_name="toSwitchoverBlueGreenDeployment")
    def to_switchover_blue_green_deployment(self) -> "Rds":
        '''(experimental) Grants permission to switch a blue-green deployment from source instance or cluster to target.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsResourceTag()
        - .ifAwsTagKeys()
        - .ifReqTag()

        Dependent actions:

        - rds:ModifyDBCluster
        - rds:ModifyDBInstance
        - rds:PromoteReadReplica
        - rds:PromoteReadReplicaDBCluster

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_SwitchoverBlueGreenDeployment.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toSwitchoverBlueGreenDeployment", []))

    @jsii.member(jsii_name="toSwitchoverReadReplica")
    def to_switchover_read_replica(self) -> "Rds":
        '''(experimental) Grants permission to switch over a read replica, making it the new primary database.

        Access Level: Write

        https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_SwitchoverReadReplica.html

        :stability: experimental
        '''
        return typing.cast("Rds", jsii.invoke(self, "toSwitchoverReadReplica", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46400253108e0da2702ceb4549475c5e628f0684a21b5e4a1bb321dc064b099f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da0da3c0f59be85e2bdbdb75a293978f7792a12a9099e3632c47ec89f3e3d929)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class RdsData(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.RdsData"):
    '''(experimental) Statement provider for service `rds-data <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrdsdataapi.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `rds-data <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrdsdataapi.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7adc06ab1947d33dc5128d3c0a38b99b455b354afaee4f044205dd8fdb794ef6)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onCluster")
    def on_cluster(
        self,
        db_cluster_instance_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RdsData":
        '''(experimental) Adds a resource of type cluster to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html

        :param db_cluster_instance_name: - Identifier for the dbClusterInstanceName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifAwsTagKeys()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0fc03183d7a01221a12dca10aee0925e8bc5d89f8782608447d74cda602f0473)
            check_type(argname="argument db_cluster_instance_name", value=db_cluster_instance_name, expected_type=type_hints["db_cluster_instance_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RdsData", jsii.invoke(self, "onCluster", [db_cluster_instance_name, account, region, partition]))

    @jsii.member(jsii_name="toBatchExecuteStatement")
    def to_batch_execute_statement(self) -> "RdsData":
        '''(experimental) Grants permission to run a batch SQL statement over an array of data.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BatchExecuteStatement.html

        :stability: experimental
        '''
        return typing.cast("RdsData", jsii.invoke(self, "toBatchExecuteStatement", []))

    @jsii.member(jsii_name="toBeginTransaction")
    def to_begin_transaction(self) -> "RdsData":
        '''(experimental) Grants permission to start a SQL transaction.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BeginTransaction.html

        :stability: experimental
        '''
        return typing.cast("RdsData", jsii.invoke(self, "toBeginTransaction", []))

    @jsii.member(jsii_name="toCommitTransaction")
    def to_commit_transaction(self) -> "RdsData":
        '''(experimental) Grants permission to end a SQL transaction started with the BeginTransaction operation and commits the changes.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - rds-data:BeginTransaction

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_CommitTransaction.html

        :stability: experimental
        '''
        return typing.cast("RdsData", jsii.invoke(self, "toCommitTransaction", []))

    @jsii.member(jsii_name="toExecuteSql")
    def to_execute_sql(self) -> "RdsData":
        '''(experimental) Grants permission to run one or more SQL statements. This operation is deprecated. Use the BatchExecuteStatement or ExecuteStatement operation.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteSql.html

        :stability: experimental
        '''
        return typing.cast("RdsData", jsii.invoke(self, "toExecuteSql", []))

    @jsii.member(jsii_name="toExecuteStatement")
    def to_execute_statement(self) -> "RdsData":
        '''(experimental) Grants permission to run a SQL statement against a database.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteStatement.html

        :stability: experimental
        '''
        return typing.cast("RdsData", jsii.invoke(self, "toExecuteStatement", []))

    @jsii.member(jsii_name="toRollbackTransaction")
    def to_rollback_transaction(self) -> "RdsData":
        '''(experimental) Grants permission to perform a rollback of a transaction. Rolling back a transaction cancels its changes.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - rds-data:BeginTransaction

        https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_RollbackTransaction.html

        :stability: experimental
        '''
        return typing.cast("RdsData", jsii.invoke(self, "toRollbackTransaction", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9661ab517242cb588d73541bf3d54dc9aeeb15df5fb59035ae0d456285c2254a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bdce333773fc1bbcf36a883a074fd7447dd14c1cea8a595de208ac27278e83bf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class RdsDb(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.RdsDb"):
    '''(experimental) Statement provider for service `rds-db <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrdsiamauthentication.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `rds-db <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrdsiamauthentication.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0df314513029c9e2715b49f9200ccdc31543e7a04e6117a1652629eee98f7174)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onDbUser")
    def on_db_user(
        self,
        dbi_resource_id: builtins.str,
        db_user_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RdsDb":
        '''(experimental) Adds a resource of type db-user to the statement.

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.DBAccounts.html

        :param dbi_resource_id: - Identifier for the dbiResourceId.
        :param db_user_name: - Identifier for the dbUserName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2bdcd98a53068976e2a153493580bbd366d565d95273bb83207d72491fafab95)
            check_type(argname="argument dbi_resource_id", value=dbi_resource_id, expected_type=type_hints["dbi_resource_id"])
            check_type(argname="argument db_user_name", value=db_user_name, expected_type=type_hints["db_user_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RdsDb", jsii.invoke(self, "onDbUser", [dbi_resource_id, db_user_name, account, region, partition]))

    @jsii.member(jsii_name="toConnect")
    def to_connect(self) -> "RdsDb":
        '''(experimental) Allows IAM role or user to connect to RDS database.

        Access Level: Permissions management

        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.IAMPolicy.html

        :stability: experimental
        '''
        return typing.cast("RdsDb", jsii.invoke(self, "toConnect", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d58a25c6aa1e84f256c8f4898207f5435522fa03337731c7833a7c9d7f9cdc9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__88f8483a30f023533dd46da4dd7706d7ffdc930aeafd08703739225c5fc3f2ed)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Redshift(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Redshift",
):
    '''(experimental) Statement provider for service `redshift <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshift.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `redshift <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshift.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1cc19c9b003a0b272b79f64842a1f81e627c04b29e6d7a9fc184cfb03b8b10a)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="ifConsumerArn")
    def if_consumer_arn(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Redshift":
        '''(experimental) Filters access by the datashare consumer arn.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions

        Applies to actions:

        - .toAssociateDataShareConsumer()
        - .toDisassociateDataShareConsumer()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41c04dbc164f31012c86f4ee582c1b2e590c7c4e18666120276686c616865701)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Redshift", jsii.invoke(self, "ifConsumerArn", [value, operator]))

    @jsii.member(jsii_name="ifConsumerIdentifier")
    def if_consumer_identifier(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Redshift":
        '''(experimental) Filters access by the datashare consumer.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions

        Applies to actions:

        - .toAuthorizeDataShare()
        - .toDeauthorizeDataShare()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__476fa7ab9eebe86e6cef1dcbd1461fdfc7b62b28e3ce9352f23d489aaf202848)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Redshift", jsii.invoke(self, "ifConsumerIdentifier", [value, operator]))

    @jsii.member(jsii_name="ifDbName")
    def if_db_name(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Redshift":
        '''(experimental) Filters access by the database name.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions

        Applies to actions:

        - .toGetClusterCredentials()
        - .toGetClusterCredentialsWithIAM()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__711b45d0742b8200d43850142f31107832286ba400dd833bba2186c8d5288305)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Redshift", jsii.invoke(self, "ifDbName", [value, operator]))

    @jsii.member(jsii_name="ifDbUser")
    def if_db_user(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Redshift":
        '''(experimental) Filters access by the database user name.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions

        Applies to actions:

        - .toCreateClusterUser()
        - .toGetClusterCredentials()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__43403c3b5d60689b406e21a5e8bfff89fc114fec1b57041fc89d1d36963d4253)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Redshift", jsii.invoke(self, "ifDbUser", [value, operator]))

    @jsii.member(jsii_name="ifDurationSeconds")
    def if_duration_seconds(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "Redshift":
        '''(experimental) Filters access by the number of seconds until a temporary credential set expires.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions

        Applies to actions:

        - .toGetClusterCredentials()
        - .toGetClusterCredentialsWithIAM()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__94302136f3d371ba25685d0edda7bf08685210a0476a0b02780a5762394b821a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("Redshift", jsii.invoke(self, "ifDurationSeconds", [value, operator]))

    @jsii.member(jsii_name="onCluster")
    def on_cluster(
        self,
        cluster_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type cluster to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html

        :param cluster_name: - Identifier for the clusterName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ceeaadd289f00bbc22c986c40d4531961652e8d45a44ded453551c5ab20526e)
            check_type(argname="argument cluster_name", value=cluster_name, expected_type=type_hints["cluster_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onCluster", [cluster_name, account, region, partition]))

    @jsii.member(jsii_name="onDatashare")
    def on_datashare(
        self,
        producer_cluster_namespace: builtins.str,
        data_share_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type datashare to the statement.

        https://docs.aws.amazon.com/redshift/latest/dg/datashare-overview.html

        :param producer_cluster_namespace: - Identifier for the producerClusterNamespace.
        :param data_share_name: - Identifier for the dataShareName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d790593b5b3023f1f8c3492136fee821a2b1cd656d596d264b34066c93c1befc)
            check_type(argname="argument producer_cluster_namespace", value=producer_cluster_namespace, expected_type=type_hints["producer_cluster_namespace"])
            check_type(argname="argument data_share_name", value=data_share_name, expected_type=type_hints["data_share_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onDatashare", [producer_cluster_namespace, data_share_name, account, region, partition]))

    @jsii.member(jsii_name="onDbgroup")
    def on_dbgroup(
        self,
        cluster_name: builtins.str,
        db_group: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type dbgroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_GROUP.html

        :param cluster_name: - Identifier for the clusterName.
        :param db_group: - Identifier for the dbGroup.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c370d4e128063c9475605cc3141fe7b11524bd1cf50fd9e7c15371b2cec41615)
            check_type(argname="argument cluster_name", value=cluster_name, expected_type=type_hints["cluster_name"])
            check_type(argname="argument db_group", value=db_group, expected_type=type_hints["db_group"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onDbgroup", [cluster_name, db_group, account, region, partition]))

    @jsii.member(jsii_name="onDbname")
    def on_dbname(
        self,
        cluster_name: builtins.str,
        db_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type dbname to the statement.

        https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html

        :param cluster_name: - Identifier for the clusterName.
        :param db_name: - Identifier for the dbName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b3dbfce38d1e659e6b1cce333d78e105df3c5faf6565daae5cc47a675e4bd2e)
            check_type(argname="argument cluster_name", value=cluster_name, expected_type=type_hints["cluster_name"])
            check_type(argname="argument db_name", value=db_name, expected_type=type_hints["db_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onDbname", [cluster_name, db_name, account, region, partition]))

    @jsii.member(jsii_name="onDbuser")
    def on_dbuser(
        self,
        cluster_name: builtins.str,
        db_user: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type dbuser to the statement.

        https://docs.aws.amazon.com/redshift/latest/dg/r_Users.html

        :param cluster_name: - Identifier for the clusterName.
        :param db_user: - Identifier for the dbUser.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b0205a0b47edaa3c331c99d54621ff8a52fe906b63dde393e4078864478527c)
            check_type(argname="argument cluster_name", value=cluster_name, expected_type=type_hints["cluster_name"])
            check_type(argname="argument db_user", value=db_user, expected_type=type_hints["db_user"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onDbuser", [cluster_name, db_user, account, region, partition]))

    @jsii.member(jsii_name="onEventsubscription")
    def on_eventsubscription(
        self,
        event_subscription_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type eventsubscription to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-events.html

        :param event_subscription_name: - Identifier for the eventSubscriptionName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b81035e540eccfd8aee1f87cab5b3bbc2acb8673007063bc20ec822203b28aca)
            check_type(argname="argument event_subscription_name", value=event_subscription_name, expected_type=type_hints["event_subscription_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onEventsubscription", [event_subscription_name, account, region, partition]))

    @jsii.member(jsii_name="onHsmclientcertificate")
    def on_hsmclientcertificate(
        self,
        h_sm_client_certificate_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type hsmclientcertificate to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM

        :param h_sm_client_certificate_id: - Identifier for the hSMClientCertificateId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ee50a592616498a2ae9a6faa57c4d08aa649e4a4d159009fb4c1af9485b90310)
            check_type(argname="argument h_sm_client_certificate_id", value=h_sm_client_certificate_id, expected_type=type_hints["h_sm_client_certificate_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onHsmclientcertificate", [h_sm_client_certificate_id, account, region, partition]))

    @jsii.member(jsii_name="onHsmconfiguration")
    def on_hsmconfiguration(
        self,
        h_sm_configuration_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type hsmconfiguration to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM

        :param h_sm_configuration_id: - Identifier for the hSMConfigurationId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78557a6bb0333245df392c4a27b21631f069ab5cfd03e55ad3cd7fe1ac14154e)
            check_type(argname="argument h_sm_configuration_id", value=h_sm_configuration_id, expected_type=type_hints["h_sm_configuration_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onHsmconfiguration", [h_sm_configuration_id, account, region, partition]))

    @jsii.member(jsii_name="onNamespace")
    def on_namespace(
        self,
        producer_cluster_namespace: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type namespace to the statement.

        https://docs.aws.amazon.com/redshift/latest/dg/concepts.html

        :param producer_cluster_namespace: - Identifier for the producerClusterNamespace.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d836326f1e8f3665341fcc0ce277e4e0ed5a0b4625cb5f0a0940a74982fd023)
            check_type(argname="argument producer_cluster_namespace", value=producer_cluster_namespace, expected_type=type_hints["producer_cluster_namespace"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onNamespace", [producer_cluster_namespace, account, region, partition]))

    @jsii.member(jsii_name="onParametergroup")
    def on_parametergroup(
        self,
        parameter_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type parametergroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html

        :param parameter_group_name: - Identifier for the parameterGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__101ed9c9e36db19cdb50838d12b97d3563696d31da123d7fb159bf898e05ec02)
            check_type(argname="argument parameter_group_name", value=parameter_group_name, expected_type=type_hints["parameter_group_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onParametergroup", [parameter_group_name, account, region, partition]))

    @jsii.member(jsii_name="onSecuritygroup")
    def on_securitygroup(
        self,
        security_group_name: builtins.str,
        owner: builtins.str,
        ec2_security_group_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type securitygroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html

        :param security_group_name: - Identifier for the securityGroupName.
        :param owner: - Identifier for the owner.
        :param ec2_security_group_id: - Identifier for the ec2SecurityGroupId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8effb3eaa5357dbfe09cd91c30376108ac9b9e4bcfeeee94fc3163ab21db8d27)
            check_type(argname="argument security_group_name", value=security_group_name, expected_type=type_hints["security_group_name"])
            check_type(argname="argument owner", value=owner, expected_type=type_hints["owner"])
            check_type(argname="argument ec2_security_group_id", value=ec2_security_group_id, expected_type=type_hints["ec2_security_group_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onSecuritygroup", [security_group_name, owner, ec2_security_group_id, account, region, partition]))

    @jsii.member(jsii_name="onSecuritygroupingressCidr")
    def on_securitygroupingress_cidr(
        self,
        security_group_name: builtins.str,
        ip_range: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type securitygroupingress-cidr to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html

        :param security_group_name: - Identifier for the securityGroupName.
        :param ip_range: - Identifier for the ipRange.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__84c8c7bd11b405684f7ad931ef45129c77d20fbf31b8aa5ce3921c09b9c5286e)
            check_type(argname="argument security_group_name", value=security_group_name, expected_type=type_hints["security_group_name"])
            check_type(argname="argument ip_range", value=ip_range, expected_type=type_hints["ip_range"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onSecuritygroupingressCidr", [security_group_name, ip_range, account, region, partition]))

    @jsii.member(jsii_name="onSecuritygroupingressEc2securitygroup")
    def on_securitygroupingress_ec2securitygroup(
        self,
        security_group_name: builtins.str,
        owner: builtins.str,
        ece2_securitygroup_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type securitygroupingress-ec2securitygroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html

        :param security_group_name: - Identifier for the securityGroupName.
        :param owner: - Identifier for the owner.
        :param ece2_securitygroup_id: - Identifier for the ece2SecuritygroupId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b618ab42d0d9a88510de49e689b1c202bfdb75db1098c20b2dc789643b8a3d5)
            check_type(argname="argument security_group_name", value=security_group_name, expected_type=type_hints["security_group_name"])
            check_type(argname="argument owner", value=owner, expected_type=type_hints["owner"])
            check_type(argname="argument ece2_securitygroup_id", value=ece2_securitygroup_id, expected_type=type_hints["ece2_securitygroup_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onSecuritygroupingressEc2securitygroup", [security_group_name, owner, ece2_securitygroup_id, account, region, partition]))

    @jsii.member(jsii_name="onSnapshot")
    def on_snapshot(
        self,
        cluster_name: builtins.str,
        snapshot_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type snapshot to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html

        :param cluster_name: - Identifier for the clusterName.
        :param snapshot_name: - Identifier for the snapshotName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__414e2e19ccebac929c6aa3a1df94e77ee9d6b063ecdf41641f8bb33db71b70f7)
            check_type(argname="argument cluster_name", value=cluster_name, expected_type=type_hints["cluster_name"])
            check_type(argname="argument snapshot_name", value=snapshot_name, expected_type=type_hints["snapshot_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onSnapshot", [cluster_name, snapshot_name, account, region, partition]))

    @jsii.member(jsii_name="onSnapshotcopygrant")
    def on_snapshotcopygrant(
        self,
        snapshot_copy_grant_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type snapshotcopygrant to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#configure-snapshot-copy-grant

        :param snapshot_copy_grant_name: - Identifier for the snapshotCopyGrantName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7a129f339e2b37776d1fda57911e63e9e58c28d0971a0fffa2caf473df3cd664)
            check_type(argname="argument snapshot_copy_grant_name", value=snapshot_copy_grant_name, expected_type=type_hints["snapshot_copy_grant_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onSnapshotcopygrant", [snapshot_copy_grant_name, account, region, partition]))

    @jsii.member(jsii_name="onSnapshotschedule")
    def on_snapshotschedule(
        self,
        parameter_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type snapshotschedule to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html

        :param parameter_group_name: - Identifier for the parameterGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c119fad2680520883b0f0ac155d029855b57d09a2f081a44a8a53f78943a1ae)
            check_type(argname="argument parameter_group_name", value=parameter_group_name, expected_type=type_hints["parameter_group_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onSnapshotschedule", [parameter_group_name, account, region, partition]))

    @jsii.member(jsii_name="onSubnetgroup")
    def on_subnetgroup(
        self,
        subnet_group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type subnetgroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html

        :param subnet_group_name: - Identifier for the subnetGroupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e3db32d050245bf6b3c90fdd03eb1fba9e10f3d29b6e10146c148eb1007b4e5)
            check_type(argname="argument subnet_group_name", value=subnet_group_name, expected_type=type_hints["subnet_group_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onSubnetgroup", [subnet_group_name, account, region, partition]))

    @jsii.member(jsii_name="onUsagelimit")
    def on_usagelimit(
        self,
        usage_limit_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Redshift":
        '''(experimental) Adds a resource of type usagelimit to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/managing-cluster-usage-limits.html

        :param usage_limit_id: - Identifier for the usageLimitId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__de105e3fd0a7848a2368922330ac5e9d41bf787fad6a4007a16534a47c23865b)
            check_type(argname="argument usage_limit_id", value=usage_limit_id, expected_type=type_hints["usage_limit_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Redshift", jsii.invoke(self, "onUsagelimit", [usage_limit_id, account, region, partition]))

    @jsii.member(jsii_name="toAcceptReservedNodeExchange")
    def to_accept_reserved_node_exchange(self) -> "Redshift":
        '''(experimental) Grants permission to exchange a DC1 reserved node for a DC2 reserved node with no changes to the configuration.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_AcceptReservedNodeExchange.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toAcceptReservedNodeExchange", []))

    @jsii.member(jsii_name="toAddPartner")
    def to_add_partner(self) -> "Redshift":
        '''(experimental) Grants permission to add a partner integration to a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_AddPartner.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toAddPartner", []))

    @jsii.member(jsii_name="toAssociateDataShareConsumer")
    def to_associate_data_share_consumer(self) -> "Redshift":
        '''(experimental) Grants permission to associate a consumer to a datashare.

        Access Level: Write

        Possible conditions:

        - .ifConsumerArn()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_AssociateDataShareConsumer.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toAssociateDataShareConsumer", []))

    @jsii.member(jsii_name="toAuthorizeClusterSecurityGroupIngress")
    def to_authorize_cluster_security_group_ingress(self) -> "Redshift":
        '''(experimental) Grants permission to add an inbound (ingress) rule to an Amazon Redshift security group.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_AuthorizeClusterSecurityGroupIngress.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toAuthorizeClusterSecurityGroupIngress", []))

    @jsii.member(jsii_name="toAuthorizeDataShare")
    def to_authorize_data_share(self) -> "Redshift":
        '''(experimental) Grants permission to authorize the specified datashare consumer to consume a datashare.

        Access Level: Permissions management

        Possible conditions:

        - .ifConsumerIdentifier()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_AuthorizeDataShare.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toAuthorizeDataShare", []))

    @jsii.member(jsii_name="toAuthorizeEndpointAccess")
    def to_authorize_endpoint_access(self) -> "Redshift":
        '''(experimental) Grants permission to authorize endpoint related activities for redshift-managed vpc endpoint.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_AuthorizeEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toAuthorizeEndpointAccess", []))

    @jsii.member(jsii_name="toAuthorizeSnapshotAccess")
    def to_authorize_snapshot_access(self) -> "Redshift":
        '''(experimental) Grants permission to the specified AWS account to restore a snapshot.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_AuthorizeSnapshotAccess.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toAuthorizeSnapshotAccess", []))

    @jsii.member(jsii_name="toBatchDeleteClusterSnapshots")
    def to_batch_delete_cluster_snapshots(self) -> "Redshift":
        '''(experimental) Grants permission to delete snapshots in a batch of size upto 100.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_BatchDeleteClusterSnapshots.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toBatchDeleteClusterSnapshots", []))

    @jsii.member(jsii_name="toBatchModifyClusterSnapshots")
    def to_batch_modify_cluster_snapshots(self) -> "Redshift":
        '''(experimental) Grants permission to modify settings for a list of snapshots.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_BatchModifyClusterSnapshots.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toBatchModifyClusterSnapshots", []))

    @jsii.member(jsii_name="toCancelQuery")
    def to_cancel_query(self) -> "Redshift":
        '''(experimental) Grants permission to cancel a query through the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCancelQuery", []))

    @jsii.member(jsii_name="toCancelQuerySession")
    def to_cancel_query_session(self) -> "Redshift":
        '''(experimental) Grants permission to see queries in the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCancelQuerySession", []))

    @jsii.member(jsii_name="toCancelResize")
    def to_cancel_resize(self) -> "Redshift":
        '''(experimental) Grants permission to cancel a resize operation.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CancelResize.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCancelResize", []))

    @jsii.member(jsii_name="toCopyClusterSnapshot")
    def to_copy_cluster_snapshot(self) -> "Redshift":
        '''(experimental) Grants permission to copy a cluster snapshot.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CopyClusterSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCopyClusterSnapshot", []))

    @jsii.member(jsii_name="toCreateAuthenticationProfile")
    def to_create_authentication_profile(self) -> "Redshift":
        '''(experimental) Grants permission to create an Amazon Redshift authentication profile.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateAuthenticationProfile.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateAuthenticationProfile", []))

    @jsii.member(jsii_name="toCreateCluster")
    def to_create_cluster(self) -> "Redshift":
        '''(experimental) Grants permission to create a cluster.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateCluster.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateCluster", []))

    @jsii.member(jsii_name="toCreateClusterParameterGroup")
    def to_create_cluster_parameter_group(self) -> "Redshift":
        '''(experimental) Grants permission to create an Amazon Redshift parameter group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateClusterParameterGroup", []))

    @jsii.member(jsii_name="toCreateClusterSecurityGroup")
    def to_create_cluster_security_group(self) -> "Redshift":
        '''(experimental) Grants permission to create an Amazon Redshift security group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSecurityGroup.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateClusterSecurityGroup", []))

    @jsii.member(jsii_name="toCreateClusterSnapshot")
    def to_create_cluster_snapshot(self) -> "Redshift":
        '''(experimental) Grants permission to create a manual snapshot of the specified cluster.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateClusterSnapshot", []))

    @jsii.member(jsii_name="toCreateClusterSubnetGroup")
    def to_create_cluster_subnet_group(self) -> "Redshift":
        '''(experimental) Grants permission to create an Amazon Redshift subnet group.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSubnetGroup.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateClusterSubnetGroup", []))

    @jsii.member(jsii_name="toCreateClusterUser")
    def to_create_cluster_user(self) -> "Redshift":
        '''(experimental) Grants permission to automatically create the specified Amazon Redshift user if it does not exist.

        Access Level: Permissions management

        Possible conditions:

        - .ifDbUser()

        https://docs.aws.amazon.com/redshift/latest/mgmt/generating-iam-credentials-role-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateClusterUser", []))

    @jsii.member(jsii_name="toCreateEndpointAccess")
    def to_create_endpoint_access(self) -> "Redshift":
        '''(experimental) Grants permission to create a redshift-managed vpc endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateEndpointAccess", []))

    @jsii.member(jsii_name="toCreateEventSubscription")
    def to_create_event_subscription(self) -> "Redshift":
        '''(experimental) Grants permission to create an Amazon Redshift event notification subscription.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateEventSubscription.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateEventSubscription", []))

    @jsii.member(jsii_name="toCreateHsmClientCertificate")
    def to_create_hsm_client_certificate(self) -> "Redshift":
        '''(experimental) Grants permission to create an HSM client certificate that a cluster uses to connect to an HSM.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateHsmClientCertificate.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateHsmClientCertificate", []))

    @jsii.member(jsii_name="toCreateHsmConfiguration")
    def to_create_hsm_configuration(self) -> "Redshift":
        '''(experimental) Grants permission to create an HSM configuration that contains information required by a cluster to store and use database encryption keys in a hardware security module (HSM).

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateHsmConfiguration.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateHsmConfiguration", []))

    @jsii.member(jsii_name="toCreateSavedQuery")
    def to_create_saved_query(self) -> "Redshift":
        '''(experimental) Grants permission to create saved SQL queries through the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateSavedQuery", []))

    @jsii.member(jsii_name="toCreateScheduledAction")
    def to_create_scheduled_action(self) -> "Redshift":
        '''(experimental) Grants permission to create an Amazon Redshift scheduled action.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateScheduledAction.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateScheduledAction", []))

    @jsii.member(jsii_name="toCreateSnapshotCopyGrant")
    def to_create_snapshot_copy_grant(self) -> "Redshift":
        '''(experimental) Grants permission to create a snapshot copy grant and encrypt copied snapshots in a destination AWS Region.

        Access Level: Permissions management

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateSnapshotCopyGrant.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateSnapshotCopyGrant", []))

    @jsii.member(jsii_name="toCreateSnapshotSchedule")
    def to_create_snapshot_schedule(self) -> "Redshift":
        '''(experimental) Grants permission to create a snapshot schedule.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateSnapshotSchedule.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateSnapshotSchedule", []))

    @jsii.member(jsii_name="toCreateTags")
    def to_create_tags(self) -> "Redshift":
        '''(experimental) Grants permission to add one or more tags to a specified resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateTags.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateTags", []))

    @jsii.member(jsii_name="toCreateUsageLimit")
    def to_create_usage_limit(self) -> "Redshift":
        '''(experimental) Grants permission to create a usage limit.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateUsageLimit.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toCreateUsageLimit", []))

    @jsii.member(jsii_name="toDeauthorizeDataShare")
    def to_deauthorize_data_share(self) -> "Redshift":
        '''(experimental) Grants permission to remove permission from the specified datashare consumer to consume a datashare.

        Access Level: Permissions management

        Possible conditions:

        - .ifConsumerIdentifier()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeauthorizeDataShare.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeauthorizeDataShare", []))

    @jsii.member(jsii_name="toDeleteAuthenticationProfile")
    def to_delete_authentication_profile(self) -> "Redshift":
        '''(experimental) Grants permission to delete an Amazon Redshift authentication profile.

        Access Level: Write

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteAuthenticationProfile", []))

    @jsii.member(jsii_name="toDeleteCluster")
    def to_delete_cluster(self) -> "Redshift":
        '''(experimental) Grants permission to delete a previously provisioned cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteCluster.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteCluster", []))

    @jsii.member(jsii_name="toDeleteClusterParameterGroup")
    def to_delete_cluster_parameter_group(self) -> "Redshift":
        '''(experimental) Grants permission to delete an Amazon Redshift parameter group.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteClusterParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteClusterParameterGroup", []))

    @jsii.member(jsii_name="toDeleteClusterSecurityGroup")
    def to_delete_cluster_security_group(self) -> "Redshift":
        '''(experimental) Grants permission to delete an Amazon Redshift security group.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteClusterSecurityGroup.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteClusterSecurityGroup", []))

    @jsii.member(jsii_name="toDeleteClusterSnapshot")
    def to_delete_cluster_snapshot(self) -> "Redshift":
        '''(experimental) Grants permission to delete a manual snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteClusterSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteClusterSnapshot", []))

    @jsii.member(jsii_name="toDeleteClusterSubnetGroup")
    def to_delete_cluster_subnet_group(self) -> "Redshift":
        '''(experimental) Grants permission to delete a cluster subnet group.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteClusterSubnetGroup.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteClusterSubnetGroup", []))

    @jsii.member(jsii_name="toDeleteEndpointAccess")
    def to_delete_endpoint_access(self) -> "Redshift":
        '''(experimental) Grants permission to delete a redshift-managed vpc endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteEndpointAccess", []))

    @jsii.member(jsii_name="toDeleteEventSubscription")
    def to_delete_event_subscription(self) -> "Redshift":
        '''(experimental) Grants permission to delete an Amazon Redshift event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteEventSubscription.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteEventSubscription", []))

    @jsii.member(jsii_name="toDeleteHsmClientCertificate")
    def to_delete_hsm_client_certificate(self) -> "Redshift":
        '''(experimental) Grants permission to delete an HSM client certificate.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteHsmClientCertificate.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteHsmClientCertificate", []))

    @jsii.member(jsii_name="toDeleteHsmConfiguration")
    def to_delete_hsm_configuration(self) -> "Redshift":
        '''(experimental) Grants permission to delete an Amazon Redshift HSM configuration.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteHsmConfiguration.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteHsmConfiguration", []))

    @jsii.member(jsii_name="toDeletePartner")
    def to_delete_partner(self) -> "Redshift":
        '''(experimental) Grants permission to delete a partner integration from a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeletePartner.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeletePartner", []))

    @jsii.member(jsii_name="toDeleteSavedQueries")
    def to_delete_saved_queries(self) -> "Redshift":
        '''(experimental) Grants permission to delete saved SQL queries through the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteSavedQueries", []))

    @jsii.member(jsii_name="toDeleteScheduledAction")
    def to_delete_scheduled_action(self) -> "Redshift":
        '''(experimental) Grants permission to delete an Amazon Redshift scheduled action.

        Access Level: Write

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteScheduledAction", []))

    @jsii.member(jsii_name="toDeleteSnapshotCopyGrant")
    def to_delete_snapshot_copy_grant(self) -> "Redshift":
        '''(experimental) Grants permission to delete a snapshot copy grant.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteSnapshotCopyGrant.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteSnapshotCopyGrant", []))

    @jsii.member(jsii_name="toDeleteSnapshotSchedule")
    def to_delete_snapshot_schedule(self) -> "Redshift":
        '''(experimental) Grants permission to delete a snapshot schedule.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteSnapshotSchedule.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteSnapshotSchedule", []))

    @jsii.member(jsii_name="toDeleteTags")
    def to_delete_tags(self) -> "Redshift":
        '''(experimental) Grants permission to delete a tag or tags from a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteTags.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteTags", []))

    @jsii.member(jsii_name="toDeleteUsageLimit")
    def to_delete_usage_limit(self) -> "Redshift":
        '''(experimental) Grants permission to delete a usage limit.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DeleteUsageLimit.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDeleteUsageLimit", []))

    @jsii.member(jsii_name="toDescribeAccountAttributes")
    def to_describe_account_attributes(self) -> "Redshift":
        '''(experimental) Grants permission to describe attributes attached to the specified AWS account.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeAccountAttributes.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeAccountAttributes", []))

    @jsii.member(jsii_name="toDescribeAuthenticationProfiles")
    def to_describe_authentication_profiles(self) -> "Redshift":
        '''(experimental) Grants permission to describe created Amazon Redshift authentication profiles.

        Access Level: Read

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeAuthenticationProfiles", []))

    @jsii.member(jsii_name="toDescribeClusterDbRevisions")
    def to_describe_cluster_db_revisions(self) -> "Redshift":
        '''(experimental) Grants permission to describe database revisions for a cluster.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterDbRevisions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeClusterDbRevisions", []))

    @jsii.member(jsii_name="toDescribeClusterParameterGroups")
    def to_describe_cluster_parameter_groups(self) -> "Redshift":
        '''(experimental) Grants permission to describe Amazon Redshift parameter groups, including parameter groups you created and the default parameter group.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterParameterGroups.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeClusterParameterGroups", []))

    @jsii.member(jsii_name="toDescribeClusterParameters")
    def to_describe_cluster_parameters(self) -> "Redshift":
        '''(experimental) Grants permission to describe parameters contained within an Amazon Redshift parameter group.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterParameters.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeClusterParameters", []))

    @jsii.member(jsii_name="toDescribeClusters")
    def to_describe_clusters(self) -> "Redshift":
        '''(experimental) Grants permission to describe properties of provisioned clusters.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusters.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeClusters", []))

    @jsii.member(jsii_name="toDescribeClusterSecurityGroups")
    def to_describe_cluster_security_groups(self) -> "Redshift":
        '''(experimental) Grants permission to describe Amazon Redshift security groups.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterSecurityGroups.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeClusterSecurityGroups", []))

    @jsii.member(jsii_name="toDescribeClusterSnapshots")
    def to_describe_cluster_snapshots(self) -> "Redshift":
        '''(experimental) Grants permission to describe one or more snapshot objects, which contain metadata about your cluster snapshots.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterSnapshots.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeClusterSnapshots", []))

    @jsii.member(jsii_name="toDescribeClusterSubnetGroups")
    def to_describe_cluster_subnet_groups(self) -> "Redshift":
        '''(experimental) Grants permission to describe one or more cluster subnet group objects, which contain metadata about your cluster subnet groups.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterSubnetGroups.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeClusterSubnetGroups", []))

    @jsii.member(jsii_name="toDescribeClusterTracks")
    def to_describe_cluster_tracks(self) -> "Redshift":
        '''(experimental) Grants permission to describe available maintenance tracks.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterTracks.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeClusterTracks", []))

    @jsii.member(jsii_name="toDescribeClusterVersions")
    def to_describe_cluster_versions(self) -> "Redshift":
        '''(experimental) Grants permission to describe available Amazon Redshift cluster versions.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeClusterVersions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeClusterVersions", []))

    @jsii.member(jsii_name="toDescribeDataShares")
    def to_describe_data_shares(self) -> "Redshift":
        '''(experimental) Grants permission to describe datashares created and consumed by your clusters.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeDataShares.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeDataShares", []))

    @jsii.member(jsii_name="toDescribeDataSharesForConsumer")
    def to_describe_data_shares_for_consumer(self) -> "Redshift":
        '''(experimental) Grants permission to describe only datashares consumed by your clusters.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeDataSharesForConsumer.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeDataSharesForConsumer", []))

    @jsii.member(jsii_name="toDescribeDataSharesForProducer")
    def to_describe_data_shares_for_producer(self) -> "Redshift":
        '''(experimental) Grants permission to describe only datashares created by your clusters.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeDataSharesForProducer.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeDataSharesForProducer", []))

    @jsii.member(jsii_name="toDescribeDefaultClusterParameters")
    def to_describe_default_cluster_parameters(self) -> "Redshift":
        '''(experimental) Grants permission to describe parameter settings for a parameter group family.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeDefaultClusterParameters.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeDefaultClusterParameters", []))

    @jsii.member(jsii_name="toDescribeEndpointAccess")
    def to_describe_endpoint_access(self) -> "Redshift":
        '''(experimental) Grants permission to describe redshift-managed vpc endpoints.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeEndpointAccess", []))

    @jsii.member(jsii_name="toDescribeEndpointAuthorization")
    def to_describe_endpoint_authorization(self) -> "Redshift":
        '''(experimental) Grants permission to authorize describe activity for redshift-managed vpc endpoint.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeEndpointAuthorization.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeEndpointAuthorization", []))

    @jsii.member(jsii_name="toDescribeEventCategories")
    def to_describe_event_categories(self) -> "Redshift":
        '''(experimental) Grants permission to describe event categories for all event source types, or for a specified source type.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeEventCategories.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeEventCategories", []))

    @jsii.member(jsii_name="toDescribeEvents")
    def to_describe_events(self) -> "Redshift":
        '''(experimental) Grants permission to describe events related to clusters, security groups, snapshots, and parameter groups for the past 14 days.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeEvents.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeEvents", []))

    @jsii.member(jsii_name="toDescribeEventSubscriptions")
    def to_describe_event_subscriptions(self) -> "Redshift":
        '''(experimental) Grants permission to describe Amazon Redshift event notification subscriptions for the specified AWS account.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeEventSubscriptions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeEventSubscriptions", []))

    @jsii.member(jsii_name="toDescribeHsmClientCertificates")
    def to_describe_hsm_client_certificates(self) -> "Redshift":
        '''(experimental) Grants permission to describe HSM client certificates.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeHsmClientCertificates.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeHsmClientCertificates", []))

    @jsii.member(jsii_name="toDescribeHsmConfigurations")
    def to_describe_hsm_configurations(self) -> "Redshift":
        '''(experimental) Grants permission to describe Amazon Redshift HSM configurations.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeHsmConfigurations.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeHsmConfigurations", []))

    @jsii.member(jsii_name="toDescribeLoggingStatus")
    def to_describe_logging_status(self) -> "Redshift":
        '''(experimental) Grants permission to describe whether information, such as queries and connection attempts, is being logged for a cluster.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeLoggingStatus.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeLoggingStatus", []))

    @jsii.member(jsii_name="toDescribeNodeConfigurationOptions")
    def to_describe_node_configuration_options(self) -> "Redshift":
        '''(experimental) Grants permission to describe properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeNodeConfigurationOptions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeNodeConfigurationOptions", []))

    @jsii.member(jsii_name="toDescribeOrderableClusterOptions")
    def to_describe_orderable_cluster_options(self) -> "Redshift":
        '''(experimental) Grants permission to describe orderable cluster options.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeOrderableClusterOptions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeOrderableClusterOptions", []))

    @jsii.member(jsii_name="toDescribePartners")
    def to_describe_partners(self) -> "Redshift":
        '''(experimental) Grants permission to retrieve information about the partner integrations defined for a cluster.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribePartners.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribePartners", []))

    @jsii.member(jsii_name="toDescribeQuery")
    def to_describe_query(self) -> "Redshift":
        '''(experimental) Grants permission to describe a query through the Amazon Redshift console.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeQuery", []))

    @jsii.member(jsii_name="toDescribeReservedNodeExchangeStatus")
    def to_describe_reserved_node_exchange_status(self) -> "Redshift":
        '''(experimental) Grants permission to describe exchange status details and associated metadata for a reserved-node exchange.

        Statuses include such values as in progress and requested

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeReservedNodeExchangeStatus.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeReservedNodeExchangeStatus", []))

    @jsii.member(jsii_name="toDescribeReservedNodeOfferings")
    def to_describe_reserved_node_offerings(self) -> "Redshift":
        '''(experimental) Grants permission to describe available reserved node offerings by Amazon Redshift.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeReservedNodeOfferings.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeReservedNodeOfferings", []))

    @jsii.member(jsii_name="toDescribeReservedNodes")
    def to_describe_reserved_nodes(self) -> "Redshift":
        '''(experimental) Grants permission to describe the reserved nodes.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeReservedNodes.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeReservedNodes", []))

    @jsii.member(jsii_name="toDescribeResize")
    def to_describe_resize(self) -> "Redshift":
        '''(experimental) Grants permission to describe the last resize operation for a cluster.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeResize.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeResize", []))

    @jsii.member(jsii_name="toDescribeSavedQueries")
    def to_describe_saved_queries(self) -> "Redshift":
        '''(experimental) Grants permission to describe saved queries through the Amazon Redshift console.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeSavedQueries", []))

    @jsii.member(jsii_name="toDescribeScheduledActions")
    def to_describe_scheduled_actions(self) -> "Redshift":
        '''(experimental) Grants permission to describe created Amazon Redshift scheduled actions.

        Access Level: Read

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeScheduledActions", []))

    @jsii.member(jsii_name="toDescribeSnapshotCopyGrants")
    def to_describe_snapshot_copy_grants(self) -> "Redshift":
        '''(experimental) Grants permission to describe snapshot copy grants owned by the specified AWS account in the destination AWS Region.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeSnapshotCopyGrants.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeSnapshotCopyGrants", []))

    @jsii.member(jsii_name="toDescribeSnapshotSchedules")
    def to_describe_snapshot_schedules(self) -> "Redshift":
        '''(experimental) Grants permission to describe snapshot schedules.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeSnapshotSchedules.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeSnapshotSchedules", []))

    @jsii.member(jsii_name="toDescribeStorage")
    def to_describe_storage(self) -> "Redshift":
        '''(experimental) Grants permission to describe account level backups storage size and provisional storage.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeStorage.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeStorage", []))

    @jsii.member(jsii_name="toDescribeTable")
    def to_describe_table(self) -> "Redshift":
        '''(experimental) Grants permission to describe a table through the Amazon Redshift console.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeTable", []))

    @jsii.member(jsii_name="toDescribeTableRestoreStatus")
    def to_describe_table_restore_status(self) -> "Redshift":
        '''(experimental) Grants permission to describe status of one or more table restore requests made using the RestoreTableFromClusterSnapshot API action.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeTableRestoreStatus.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeTableRestoreStatus", []))

    @jsii.member(jsii_name="toDescribeTags")
    def to_describe_tags(self) -> "Redshift":
        '''(experimental) Grants permission to describe tags.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeTags.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeTags", []))

    @jsii.member(jsii_name="toDescribeUsageLimits")
    def to_describe_usage_limits(self) -> "Redshift":
        '''(experimental) Grants permission to describe usage limits.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DescribeUsageLimits.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDescribeUsageLimits", []))

    @jsii.member(jsii_name="toDisableLogging")
    def to_disable_logging(self) -> "Redshift":
        '''(experimental) Grants permission to disable logging information, such as queries and connection attempts, for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DisableLogging.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDisableLogging", []))

    @jsii.member(jsii_name="toDisableSnapshotCopy")
    def to_disable_snapshot_copy(self) -> "Redshift":
        '''(experimental) Grants permission to disable the automatic copy of snapshots for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DisableSnapshotCopy.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDisableSnapshotCopy", []))

    @jsii.member(jsii_name="toDisassociateDataShareConsumer")
    def to_disassociate_data_share_consumer(self) -> "Redshift":
        '''(experimental) Grants permission to disassociate a consumer from a datashare.

        Access Level: Write

        Possible conditions:

        - .ifConsumerArn()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_DisassociateDataShareConsumer.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toDisassociateDataShareConsumer", []))

    @jsii.member(jsii_name="toEnableLogging")
    def to_enable_logging(self) -> "Redshift":
        '''(experimental) Grants permission to enable logging information, such as queries and connection attempts, for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_EnableLogging.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toEnableLogging", []))

    @jsii.member(jsii_name="toEnableSnapshotCopy")
    def to_enable_snapshot_copy(self) -> "Redshift":
        '''(experimental) Grants permission to enable the automatic copy of snapshots for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_EnableSnapshotCopy.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toEnableSnapshotCopy", []))

    @jsii.member(jsii_name="toExecuteQuery")
    def to_execute_query(self) -> "Redshift":
        '''(experimental) Grants permission to execute a query through the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toExecuteQuery", []))

    @jsii.member(jsii_name="toFetchResults")
    def to_fetch_results(self) -> "Redshift":
        '''(experimental) Grants permission to fetch query results through the Amazon Redshift console.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toFetchResults", []))

    @jsii.member(jsii_name="toGetClusterCredentials")
    def to_get_cluster_credentials(self) -> "Redshift":
        '''(experimental) Grants permission to get temporary credentials to access an Amazon Redshift database by the specified AWS account.

        Access Level: Write

        Possible conditions:

        - .ifDbName()
        - .ifDbUser()
        - .ifDurationSeconds()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetClusterCredentials.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toGetClusterCredentials", []))

    @jsii.member(jsii_name="toGetClusterCredentialsWithIAM")
    def to_get_cluster_credentials_with_iam(self) -> "Redshift":
        '''(experimental) Grants permission to get enhanced temporary credentials to access an Amazon Redshift database by the specified AWS account.

        Access Level: Write

        Possible conditions:

        - .ifDbName()
        - .ifDurationSeconds()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetClusterCredentialsWithIAM.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toGetClusterCredentialsWithIAM", []))

    @jsii.member(jsii_name="toGetReservedNodeExchangeConfigurationOptions")
    def to_get_reserved_node_exchange_configuration_options(self) -> "Redshift":
        '''(experimental) Grants permission to get the configuration options for the reserved-node exchange.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetReservedNodeExchangeConfigurationOptions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toGetReservedNodeExchangeConfigurationOptions", []))

    @jsii.member(jsii_name="toGetReservedNodeExchangeOfferings")
    def to_get_reserved_node_exchange_offerings(self) -> "Redshift":
        '''(experimental) Grants permission to get an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given DC1 reserved node.

        Access Level: Read

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetReservedNodeExchangeOfferings.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toGetReservedNodeExchangeOfferings", []))

    @jsii.member(jsii_name="toJoinGroup")
    def to_join_group(self) -> "Redshift":
        '''(experimental) Grants permission to join the specified Amazon Redshift group.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetClusterCredentials.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toJoinGroup", []))

    @jsii.member(jsii_name="toListDatabases")
    def to_list_databases(self) -> "Redshift":
        '''(experimental) Grants permission to list databases through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toListDatabases", []))

    @jsii.member(jsii_name="toListSavedQueries")
    def to_list_saved_queries(self) -> "Redshift":
        '''(experimental) Grants permission to list saved queries through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toListSavedQueries", []))

    @jsii.member(jsii_name="toListSchemas")
    def to_list_schemas(self) -> "Redshift":
        '''(experimental) Grants permission to list schemas through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toListSchemas", []))

    @jsii.member(jsii_name="toListTables")
    def to_list_tables(self) -> "Redshift":
        '''(experimental) Grants permission to list tables through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toListTables", []))

    @jsii.member(jsii_name="toModifyAquaConfiguration")
    def to_modify_aqua_configuration(self) -> "Redshift":
        '''(experimental) Grants permission to modify the AQUA configuration of a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyAquaConfiguration.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyAquaConfiguration", []))

    @jsii.member(jsii_name="toModifyAuthenticationProfile")
    def to_modify_authentication_profile(self) -> "Redshift":
        '''(experimental) Grants permission to modify an existing Amazon Redshift authentication profile.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyAuthenticationProfile.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyAuthenticationProfile", []))

    @jsii.member(jsii_name="toModifyCluster")
    def to_modify_cluster(self) -> "Redshift":
        '''(experimental) Grants permission to modify the settings of a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyCluster.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyCluster", []))

    @jsii.member(jsii_name="toModifyClusterDbRevision")
    def to_modify_cluster_db_revision(self) -> "Redshift":
        '''(experimental) Grants permission to modify the database revision of a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterDbRevision.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyClusterDbRevision", []))

    @jsii.member(jsii_name="toModifyClusterIamRoles")
    def to_modify_cluster_iam_roles(self) -> "Redshift":
        '''(experimental) Grants permission to modify the list of AWS Identity and Access Management (IAM) roles that can be used by a cluster to access other AWS services.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterIamRoles.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyClusterIamRoles", []))

    @jsii.member(jsii_name="toModifyClusterMaintenance")
    def to_modify_cluster_maintenance(self) -> "Redshift":
        '''(experimental) Grants permission to modify the maintenance settings of a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterMaintenance.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyClusterMaintenance", []))

    @jsii.member(jsii_name="toModifyClusterParameterGroup")
    def to_modify_cluster_parameter_group(self) -> "Redshift":
        '''(experimental) Grants permission to modify the parameters of a parameter group.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyClusterParameterGroup", []))

    @jsii.member(jsii_name="toModifyClusterSnapshot")
    def to_modify_cluster_snapshot(self) -> "Redshift":
        '''(experimental) Grants permission to modify the settings of a snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyClusterSnapshot", []))

    @jsii.member(jsii_name="toModifyClusterSnapshotSchedule")
    def to_modify_cluster_snapshot_schedule(self) -> "Redshift":
        '''(experimental) Grants permission to modify a snapshot schedule for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterSnapshotSchedule.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyClusterSnapshotSchedule", []))

    @jsii.member(jsii_name="toModifyClusterSubnetGroup")
    def to_modify_cluster_subnet_group(self) -> "Redshift":
        '''(experimental) Grants permission to modify a cluster subnet group to include the specified list of VPC subnets.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyClusterSubnetGroup.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyClusterSubnetGroup", []))

    @jsii.member(jsii_name="toModifyEndpointAccess")
    def to_modify_endpoint_access(self) -> "Redshift":
        '''(experimental) Grants permission to modify a redshift-managed vpc endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyEndpointAccess", []))

    @jsii.member(jsii_name="toModifyEventSubscription")
    def to_modify_event_subscription(self) -> "Redshift":
        '''(experimental) Grants permission to modify an existing Amazon Redshift event notification subscription.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyEventSubscription.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyEventSubscription", []))

    @jsii.member(jsii_name="toModifySavedQuery")
    def to_modify_saved_query(self) -> "Redshift":
        '''(experimental) Grants permission to modify an existing saved query through the Amazon Redshift console.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifySavedQuery", []))

    @jsii.member(jsii_name="toModifyScheduledAction")
    def to_modify_scheduled_action(self) -> "Redshift":
        '''(experimental) Grants permission to modify an existing Amazon Redshift scheduled action.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyScheduledAction.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyScheduledAction", []))

    @jsii.member(jsii_name="toModifySnapshotCopyRetentionPeriod")
    def to_modify_snapshot_copy_retention_period(self) -> "Redshift":
        '''(experimental) Grants permission to modify the number of days to retain snapshots in the destination AWS Region after they are copied from the source AWS Region.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifySnapshotCopyRetentionPeriod.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifySnapshotCopyRetentionPeriod", []))

    @jsii.member(jsii_name="toModifySnapshotSchedule")
    def to_modify_snapshot_schedule(self) -> "Redshift":
        '''(experimental) Grants permission to modify a snapshot schedule.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifySnapshotSchedule.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifySnapshotSchedule", []))

    @jsii.member(jsii_name="toModifyUsageLimit")
    def to_modify_usage_limit(self) -> "Redshift":
        '''(experimental) Grants permission to modify a usage limit.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ModifyUsageLimit.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toModifyUsageLimit", []))

    @jsii.member(jsii_name="toPauseCluster")
    def to_pause_cluster(self) -> "Redshift":
        '''(experimental) Grants permission to pause a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_PauseCluster.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toPauseCluster", []))

    @jsii.member(jsii_name="toPurchaseReservedNodeOffering")
    def to_purchase_reserved_node_offering(self) -> "Redshift":
        '''(experimental) Grants permission to purchase a reserved node.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_PurchaseReservedNodeOffering.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toPurchaseReservedNodeOffering", []))

    @jsii.member(jsii_name="toRebootCluster")
    def to_reboot_cluster(self) -> "Redshift":
        '''(experimental) Grants permission to reboot a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RebootCluster.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toRebootCluster", []))

    @jsii.member(jsii_name="toRejectDataShare")
    def to_reject_data_share(self) -> "Redshift":
        '''(experimental) Grants permission to decline a datashare shared from another account.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RejectDataShare.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toRejectDataShare", []))

    @jsii.member(jsii_name="toResetClusterParameterGroup")
    def to_reset_cluster_parameter_group(self) -> "Redshift":
        '''(experimental) Grants permission to set one or more parameters of a parameter group to their default values and set the source values of the parameters to "engine-default".

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ResetClusterParameterGroup.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toResetClusterParameterGroup", []))

    @jsii.member(jsii_name="toResizeCluster")
    def to_resize_cluster(self) -> "Redshift":
        '''(experimental) Grants permission to change the size of a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ResizeCluster.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toResizeCluster", []))

    @jsii.member(jsii_name="toRestoreFromClusterSnapshot")
    def to_restore_from_cluster_snapshot(self) -> "Redshift":
        '''(experimental) Grants permission to create a cluster from a snapshot.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RestoreFromClusterSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toRestoreFromClusterSnapshot", []))

    @jsii.member(jsii_name="toRestoreTableFromClusterSnapshot")
    def to_restore_table_from_cluster_snapshot(self) -> "Redshift":
        '''(experimental) Grants permission to create a table from a table in an Amazon Redshift cluster snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RestoreTableFromClusterSnapshot.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toRestoreTableFromClusterSnapshot", []))

    @jsii.member(jsii_name="toResumeCluster")
    def to_resume_cluster(self) -> "Redshift":
        '''(experimental) Grants permission to resume a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_ResumeCluster.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toResumeCluster", []))

    @jsii.member(jsii_name="toRevokeClusterSecurityGroupIngress")
    def to_revoke_cluster_security_group_ingress(self) -> "Redshift":
        '''(experimental) Grants permission to revoke an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2 security group.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RevokeClusterSecurityGroupIngress.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toRevokeClusterSecurityGroupIngress", []))

    @jsii.member(jsii_name="toRevokeEndpointAccess")
    def to_revoke_endpoint_access(self) -> "Redshift":
        '''(experimental) Grants permission to revoke access for endpoint related activities for redshift-managed vpc endpoint.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RevokeEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toRevokeEndpointAccess", []))

    @jsii.member(jsii_name="toRevokeSnapshotAccess")
    def to_revoke_snapshot_access(self) -> "Redshift":
        '''(experimental) Grants permission to revoke access from the specified AWS account to restore a snapshot.

        Access Level: Permissions management

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RevokeSnapshotAccess.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toRevokeSnapshotAccess", []))

    @jsii.member(jsii_name="toRotateEncryptionKey")
    def to_rotate_encryption_key(self) -> "Redshift":
        '''(experimental) Grants permission to rotate an encryption key for a cluster.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_RotateEncryptionKey.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toRotateEncryptionKey", []))

    @jsii.member(jsii_name="toUpdatePartnerStatus")
    def to_update_partner_status(self) -> "Redshift":
        '''(experimental) Grants permission to update the status of a partner integration.

        Access Level: Write

        https://docs.aws.amazon.com/redshift/latest/APIReference/API_UpdatePartnerStatus.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toUpdatePartnerStatus", []))

    @jsii.member(jsii_name="toViewQueriesFromConsole")
    def to_view_queries_from_console(self) -> "Redshift":
        '''(experimental) Grants permission to view query results through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toViewQueriesFromConsole", []))

    @jsii.member(jsii_name="toViewQueriesInConsole")
    def to_view_queries_in_console(self) -> "Redshift":
        '''(experimental) Grants permission to terminate running queries and loads through the Amazon Redshift console.

        Access Level: List

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :stability: experimental
        '''
        return typing.cast("Redshift", jsii.invoke(self, "toViewQueriesInConsole", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f28f29ae8a037b92bd049cdee3c5cd137092e09fa0230257c152d1dace685ffd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__14bf5f7ce9fe4589eff2d5505245262db2b74d365314703627e896bf9de9425f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class RedshiftData(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.RedshiftData",
):
    '''(experimental) Statement provider for service `redshift-data <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftdataapi.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `redshift-data <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftdataapi.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01b16e1aca1d430dedca398915fdc46c452e5f2df3aee33b8f2a471717e77451)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="ifStatementOwnerIamUserid")
    def if_statement_owner_iam_userid(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RedshiftData":
        '''(experimental) Filters access by statement owner iam userid.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions

        Applies to actions:

        - .toCancelStatement()
        - .toDescribeStatement()
        - .toGetStatementResult()
        - .toListStatements()

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7d1679a6c1112c48116e86fa276c3a1db260456ce8edc7159102f2afb09c79e7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RedshiftData", jsii.invoke(self, "ifStatementOwnerIamUserid", [value, operator]))

    @jsii.member(jsii_name="onCluster")
    def on_cluster(
        self,
        cluster_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RedshiftData":
        '''(experimental) Adds a resource of type cluster to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html

        :param cluster_name: - Identifier for the clusterName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__be4162736a3b1a9bf2c47ed5dd4368eaa722b36b3db3ea39fb80de60797e73a3)
            check_type(argname="argument cluster_name", value=cluster_name, expected_type=type_hints["cluster_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RedshiftData", jsii.invoke(self, "onCluster", [cluster_name, account, region, partition]))

    @jsii.member(jsii_name="onWorkgroup")
    def on_workgroup(
        self,
        workgroup_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RedshiftData":
        '''(experimental) Adds a resource of type workgroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-serverless.html

        :param workgroup_id: - Identifier for the workgroupId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8f84f4115084e2ae53830236725c2326c31c27cc0974541ed0578e8da318204e)
            check_type(argname="argument workgroup_id", value=workgroup_id, expected_type=type_hints["workgroup_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RedshiftData", jsii.invoke(self, "onWorkgroup", [workgroup_id, account, region, partition]))

    @jsii.member(jsii_name="toBatchExecuteStatement")
    def to_batch_execute_statement(self) -> "RedshiftData":
        '''(experimental) Grants permission to execute multiple queries under a single connection.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_BatchExecuteStatement.html

        :stability: experimental
        '''
        return typing.cast("RedshiftData", jsii.invoke(self, "toBatchExecuteStatement", []))

    @jsii.member(jsii_name="toCancelStatement")
    def to_cancel_statement(self) -> "RedshiftData":
        '''(experimental) Grants permission to cancel a running query.

        Access Level: Write

        Possible conditions:

        - .ifStatementOwnerIamUserid()

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_CancelStatement.html

        :stability: experimental
        '''
        return typing.cast("RedshiftData", jsii.invoke(self, "toCancelStatement", []))

    @jsii.member(jsii_name="toDescribeStatement")
    def to_describe_statement(self) -> "RedshiftData":
        '''(experimental) Grants permission to retrieve detailed information about a statement execution.

        Access Level: Read

        Possible conditions:

        - .ifStatementOwnerIamUserid()

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_DescribeStatement.html

        :stability: experimental
        '''
        return typing.cast("RedshiftData", jsii.invoke(self, "toDescribeStatement", []))

    @jsii.member(jsii_name="toDescribeTable")
    def to_describe_table(self) -> "RedshiftData":
        '''(experimental) Grants permission to retrieve metadata about a particular table.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_DescribeTable.html

        :stability: experimental
        '''
        return typing.cast("RedshiftData", jsii.invoke(self, "toDescribeTable", []))

    @jsii.member(jsii_name="toExecuteStatement")
    def to_execute_statement(self) -> "RedshiftData":
        '''(experimental) Grants permission to execute a query.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ExecuteStatement.html

        :stability: experimental
        '''
        return typing.cast("RedshiftData", jsii.invoke(self, "toExecuteStatement", []))

    @jsii.member(jsii_name="toGetStatementResult")
    def to_get_statement_result(self) -> "RedshiftData":
        '''(experimental) Grants permission to fetch the result of a query.

        Access Level: Read

        Possible conditions:

        - .ifStatementOwnerIamUserid()

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_GetStatementResult.html

        :stability: experimental
        '''
        return typing.cast("RedshiftData", jsii.invoke(self, "toGetStatementResult", []))

    @jsii.member(jsii_name="toListDatabases")
    def to_list_databases(self) -> "RedshiftData":
        '''(experimental) Grants permission to list databases for a given cluster.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListDatabases.html

        :stability: experimental
        '''
        return typing.cast("RedshiftData", jsii.invoke(self, "toListDatabases", []))

    @jsii.member(jsii_name="toListSchemas")
    def to_list_schemas(self) -> "RedshiftData":
        '''(experimental) Grants permission to list schemas for a given cluster.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListSchemas.html

        :stability: experimental
        '''
        return typing.cast("RedshiftData", jsii.invoke(self, "toListSchemas", []))

    @jsii.member(jsii_name="toListStatements")
    def to_list_statements(self) -> "RedshiftData":
        '''(experimental) Grants permission to list queries for a given principal.

        Access Level: List

        Possible conditions:

        - .ifStatementOwnerIamUserid()

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListStatements.html

        :stability: experimental
        '''
        return typing.cast("RedshiftData", jsii.invoke(self, "toListStatements", []))

    @jsii.member(jsii_name="toListTables")
    def to_list_tables(self) -> "RedshiftData":
        '''(experimental) Grants permission to list tables for a given cluster.

        Access Level: List

        https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListTables.html

        :stability: experimental
        '''
        return typing.cast("RedshiftData", jsii.invoke(self, "toListTables", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9d15f7aade048017622f7527799fb04a5f54aab6e3b7bd139e6143c48dacc77)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__935dd7c7e3a5e47476c5e77af1619cce090bdb8e986d90407cc0a16422d815a3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class RedshiftServerless(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.RedshiftServerless",
):
    '''(experimental) Statement provider for service `redshift-serverless <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftserverless.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `redshift-serverless <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftserverless.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__358d961e21363adae8e7ac62c80a5e5dc217d1cdf5ce6de73c56608f9b29e8d4)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="ifEndpointAccessId")
    def if_endpoint_access_id(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Filters access by the endpoint access identifier.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e249add0d94f77948c435215528bb54484ae9dddb942ad7a7c7fc26b9ef5d70)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "ifEndpointAccessId", [value, operator]))

    @jsii.member(jsii_name="ifNamespaceId")
    def if_namespace_id(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Filters access by the namespace identifier.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c2ecacc5770ad5883f6867cd7b11a0c137ae610ed86cd391bb17cd9140b757a2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "ifNamespaceId", [value, operator]))

    @jsii.member(jsii_name="ifRecoveryPointId")
    def if_recovery_point_id(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Filters access by the recovery point identifier.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4dc7132ac640f8b7abd41dffc0f8ee008f54e96ad2541dc9935ba9c6d677eca5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "ifRecoveryPointId", [value, operator]))

    @jsii.member(jsii_name="ifSnapshotId")
    def if_snapshot_id(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Filters access by the snapshot identifier.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a35910cdccc6cd2505fade1e6ad491cfcc7d93f4c74ae7e83219905356d5ffa3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "ifSnapshotId", [value, operator]))

    @jsii.member(jsii_name="ifTableRestoreRequestId")
    def if_table_restore_request_id(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Filters access by the table restore request identifier.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bef6db18470b302c2135b22fa7cea094358d37abbdc5324f9a8c19804a4c61bb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "ifTableRestoreRequestId", [value, operator]))

    @jsii.member(jsii_name="ifWorkgroupId")
    def if_workgroup_id(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Filters access by the workgroup identifier.

        https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71923bd8aa91daae263c79838ecef22b1748117b16a405ef52d1e98611a535d0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "ifWorkgroupId", [value, operator]))

    @jsii.member(jsii_name="onEndpointAccess")
    def on_endpoint_access(
        self,
        endpoint_access_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Adds a resource of type endpointAccess to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-connecting.html

        :param endpoint_access_id: - Identifier for the endpointAccessId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b6968ae9337e326b390d442d64826cd6730ab56e167f836afd10d1108559e6d1)
            check_type(argname="argument endpoint_access_id", value=endpoint_access_id, expected_type=type_hints["endpoint_access_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "onEndpointAccess", [endpoint_access_id, account, region, partition]))

    @jsii.member(jsii_name="onNamespace")
    def on_namespace(
        self,
        namespace_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Adds a resource of type namespace to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-workgroup-namespace.html

        :param namespace_id: - Identifier for the namespaceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7316156c1851a8eef0272cc210af8697e5fafe5d69c24e10c388f2315c9be0c5)
            check_type(argname="argument namespace_id", value=namespace_id, expected_type=type_hints["namespace_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "onNamespace", [namespace_id, account, region, partition]))

    @jsii.member(jsii_name="onRecoveryPoint")
    def on_recovery_point(
        self,
        recovery_point_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Adds a resource of type recoveryPoint to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html

        :param recovery_point_id: - Identifier for the recoveryPointId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df8227b107b02b1c522285372025625294fc13f5d95efc8ed75eeaeca115b3ea)
            check_type(argname="argument recovery_point_id", value=recovery_point_id, expected_type=type_hints["recovery_point_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "onRecoveryPoint", [recovery_point_id, account, region, partition]))

    @jsii.member(jsii_name="onSnapshot")
    def on_snapshot(
        self,
        snapshot_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Adds a resource of type snapshot to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html

        :param snapshot_id: - Identifier for the snapshotId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01e05d2a84e7e3ee734299af05dd2cd93c09b99cb76af5fd6b12881d60f876d2)
            check_type(argname="argument snapshot_id", value=snapshot_id, expected_type=type_hints["snapshot_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "onSnapshot", [snapshot_id, account, region, partition]))

    @jsii.member(jsii_name="onWorkgroup")
    def on_workgroup(
        self,
        workgroup_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RedshiftServerless":
        '''(experimental) Adds a resource of type workgroup to the statement.

        https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-workgroup-namespace.html

        :param workgroup_id: - Identifier for the workgroupId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c4e5ea105e06d8ac92c73745854dcf1923aafe0381335fcea406493e7fbecdf7)
            check_type(argname="argument workgroup_id", value=workgroup_id, expected_type=type_hints["workgroup_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RedshiftServerless", jsii.invoke(self, "onWorkgroup", [workgroup_id, account, region, partition]))

    @jsii.member(jsii_name="toConvertRecoveryPointToSnapshot")
    def to_convert_recovery_point_to_snapshot(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to convert a recovery point to a snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ConvertRecoveryPointToSnapshot.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toConvertRecoveryPointToSnapshot", []))

    @jsii.member(jsii_name="toCreateEndpointAccess")
    def to_create_endpoint_access(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to create an Amazon Redshift Serverless managed VPC endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toCreateEndpointAccess", []))

    @jsii.member(jsii_name="toCreateNamespace")
    def to_create_namespace(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to create an Amazon Redshift Serverless namespace.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateNamespace.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toCreateNamespace", []))

    @jsii.member(jsii_name="toCreateSnapshot")
    def to_create_snapshot(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to create a snapshot of all databases in a namespace.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateSnapshot.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toCreateSnapshot", []))

    @jsii.member(jsii_name="toCreateUsageLimit")
    def to_create_usage_limit(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to create a usage limit for a specified Amazon Redshift Serverless usage type.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateUsageLimit.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toCreateUsageLimit", []))

    @jsii.member(jsii_name="toCreateWorkgroup")
    def to_create_workgroup(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to create a workgroup in Amazon Redshift Serverless.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateWorkgroup.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toCreateWorkgroup", []))

    @jsii.member(jsii_name="toDeleteEndpointAccess")
    def to_delete_endpoint_access(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to delete an Amazon Redshift Serverless managed VPC endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toDeleteEndpointAccess", []))

    @jsii.member(jsii_name="toDeleteNamespace")
    def to_delete_namespace(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to delete a namespace from Amazon Redshift Serverless.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteNamespace.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toDeleteNamespace", []))

    @jsii.member(jsii_name="toDeleteResourcePolicy")
    def to_delete_resource_policy(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to delete the specified resource policy.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteResourcePolicy.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toDeleteResourcePolicy", []))

    @jsii.member(jsii_name="toDeleteSnapshot")
    def to_delete_snapshot(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to delete a snapshot from Amazon Redshift Serverless.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteSnapshot.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toDeleteSnapshot", []))

    @jsii.member(jsii_name="toDeleteUsageLimit")
    def to_delete_usage_limit(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to delete a usage limit from Amazon Redshift Serverless.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteUsageLimit.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toDeleteUsageLimit", []))

    @jsii.member(jsii_name="toDeleteWorkgroup")
    def to_delete_workgroup(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to delete a workgroup.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteWorkgroup.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toDeleteWorkgroup", []))

    @jsii.member(jsii_name="toGetCredentials")
    def to_get_credentials(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to get a database user name and temporary password with temporary authorization to log on to Amazon Redshift Serverless.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetCredentials.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toGetCredentials", []))

    @jsii.member(jsii_name="toGetEndpointAccess")
    def to_get_endpoint_access(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to create an Amazon Redshift Serverless managed VPC endpoint.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toGetEndpointAccess", []))

    @jsii.member(jsii_name="toGetNamespace")
    def to_get_namespace(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to get information about a namespace in Amazon Redshift Serverless.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetNamespace.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toGetNamespace", []))

    @jsii.member(jsii_name="toGetRecoveryPoint")
    def to_get_recovery_point(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to get information about a recovery point.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetRecoveryPoint.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toGetRecoveryPoint", []))

    @jsii.member(jsii_name="toGetResourcePolicy")
    def to_get_resource_policy(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to get a resource policy.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetResourcePolicy.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toGetResourcePolicy", []))

    @jsii.member(jsii_name="toGetSnapshot")
    def to_get_snapshot(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to get information about a specific snapshot.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetSnapshot.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toGetSnapshot", []))

    @jsii.member(jsii_name="toGetTableRestoreStatus")
    def to_get_table_restore_status(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to get table restore status about a specific snapshot.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetTableRestoreStatus.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toGetTableRestoreStatus", []))

    @jsii.member(jsii_name="toGetUsageLimit")
    def to_get_usage_limit(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to get information about a usage limit in Amazon Redshift Serverless.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetUsageLimit.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toGetUsageLimit", []))

    @jsii.member(jsii_name="toGetWorkgroup")
    def to_get_workgroup(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to get information about a specific workgroup.

        Access Level: Read

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetWorkgroup.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toGetWorkgroup", []))

    @jsii.member(jsii_name="toListEndpointAccess")
    def to_list_endpoint_access(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to list EndpointAccess objects and relevant information.

        Access Level: List

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toListEndpointAccess", []))

    @jsii.member(jsii_name="toListNamespaces")
    def to_list_namespaces(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to list namespaces in Amazon Redshift Serverless.

        Access Level: List

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListNamespaces.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toListNamespaces", []))

    @jsii.member(jsii_name="toListRecoveryPoints")
    def to_list_recovery_points(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to list an array of recovery points.

        Access Level: List

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListRecoveryPoints.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toListRecoveryPoints", []))

    @jsii.member(jsii_name="toListSnapshots")
    def to_list_snapshots(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to list snapshots.

        Access Level: List

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListSnapshots.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toListSnapshots", []))

    @jsii.member(jsii_name="toListTableRestoreStatus")
    def to_list_table_restore_status(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to list table restore status.

        Access Level: List

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListTableRestoreStatus.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toListTableRestoreStatus", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to list the tags assigned to a resource.

        Access Level: List

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toListUsageLimits")
    def to_list_usage_limits(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to list all usage limits within Amazon Redshift Serverless.

        Access Level: List

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListUsageLimits.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toListUsageLimits", []))

    @jsii.member(jsii_name="toListWorkgroups")
    def to_list_workgroups(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to list workgroups in Amazon Redshift Serverless.

        Access Level: List

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListWorkgroups.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toListWorkgroups", []))

    @jsii.member(jsii_name="toPutResourcePolicy")
    def to_put_resource_policy(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to create or update a resource policy.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_PutResourcePolicy.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toPutResourcePolicy", []))

    @jsii.member(jsii_name="toRestoreFromRecoveryPoint")
    def to_restore_from_recovery_point(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to restore the data from a recovery point.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_RestoreFromRecoveryPoint.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toRestoreFromRecoveryPoint", []))

    @jsii.member(jsii_name="toRestoreFromSnapshot")
    def to_restore_from_snapshot(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to restore a namespace from a snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_RestoreFromSnapshot.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toRestoreFromSnapshot", []))

    @jsii.member(jsii_name="toRestoreTableFromSnapshot")
    def to_restore_table_from_snapshot(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to restore a table from a snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_RestoreTableFromSnapshot.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toRestoreTableFromSnapshot", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to assign one or more tags to a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()
        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to remove a tag or set of tags from a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateEndpointAccess")
    def to_update_endpoint_access(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to update an Amazon Redshift Serverless managed VPC endpoint.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UpdateEndpointAccess.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toUpdateEndpointAccess", []))

    @jsii.member(jsii_name="toUpdateNamespace")
    def to_update_namespace(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to update a namespace with the specified configuration settings.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UpdateNamespace.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toUpdateNamespace", []))

    @jsii.member(jsii_name="toUpdateSnapshot")
    def to_update_snapshot(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to update a snapshot.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UpdateSnapshot.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toUpdateSnapshot", []))

    @jsii.member(jsii_name="toUpdateUsageLimit")
    def to_update_usage_limit(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to update a usage limit in Amazon Redshift Serverless.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UpdateUsageLimit.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toUpdateUsageLimit", []))

    @jsii.member(jsii_name="toUpdateWorkgroup")
    def to_update_workgroup(self) -> "RedshiftServerless":
        '''(experimental) Grants permission to update an Amazon Redshift Serverless workgroup with the specified configuration settings.

        Access Level: Write

        https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UpdateWorkgroup.html

        :stability: experimental
        '''
        return typing.cast("RedshiftServerless", jsii.invoke(self, "toUpdateWorkgroup", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1deb17852c187880950221bdbc2ea522bc5bc2072fc42d3c821251d061deb0b9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74b8a5e5de499a48ba8d14ac46c69f651cc4dfb17203471407fad252e777c12b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class RefactorSpaces(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.RefactorSpaces",
):
    '''(experimental) Statement provider for service `refactor-spaces <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubrefactorspaces.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `refactor-spaces <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubrefactorspaces.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__854a934cfdb73247f8e90f506eaf5fb5ec41bfe9f253da0fdd941a3255e2ff1a)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="ifApplicationCreatedByAccount")
    def if_application_created_by_account(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RefactorSpaces":
        '''(experimental) Filters access by restricting the action to only those accounts that created the application within an environment.

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys

        Applies to actions:

        - .toCreateApplication()
        - .toCreateRoute()
        - .toCreateService()
        - .toDeleteApplication()
        - .toDeleteRoute()
        - .toDeleteService()
        - .toGetApplication()
        - .toGetRoute()
        - .toGetService()
        - .toTagResource()
        - .toUntagResource()
        - .toUpdateRoute()

        Applies to resource types:

        - application
        - service
        - route

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b4532fbacba325b4e9dc78e0638f285e4e40ea0221da61b65e239c13053e277f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RefactorSpaces", jsii.invoke(self, "ifApplicationCreatedByAccount", [value, operator]))

    @jsii.member(jsii_name="ifCreatedByAccountIds")
    def if_created_by_account_ids(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RefactorSpaces":
        '''(experimental) Filters access by the accounts that created the resource.

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys

        Applies to actions:

        - .toCreateApplication()
        - .toCreateRoute()
        - .toCreateService()
        - .toDeleteApplication()
        - .toDeleteRoute()
        - .toDeleteService()
        - .toGetApplication()
        - .toGetRoute()
        - .toGetService()
        - .toTagResource()
        - .toUntagResource()
        - .toUpdateRoute()

        Applies to resource types:

        - application
        - service
        - route

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e03ed697099ac70d72bb4bfd65e17c45f99ae4ad43d1b213d2911a79cc73c3dc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RefactorSpaces", jsii.invoke(self, "ifCreatedByAccountIds", [value, operator]))

    @jsii.member(jsii_name="ifRouteCreatedByAccount")
    def if_route_created_by_account(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RefactorSpaces":
        '''(experimental) Filters access by restricting the action to only those accounts that created the route within an application.

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys

        Applies to actions:

        - .toCreateRoute()
        - .toDeleteRoute()
        - .toGetRoute()
        - .toTagResource()
        - .toUntagResource()
        - .toUpdateRoute()

        Applies to resource types:

        - route

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__69770b64be2ace592c90b62b2d5c541c2981cb6b387ac59963b596f5539500de)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RefactorSpaces", jsii.invoke(self, "ifRouteCreatedByAccount", [value, operator]))

    @jsii.member(jsii_name="ifServiceCreatedByAccount")
    def if_service_created_by_account(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RefactorSpaces":
        '''(experimental) Filters access by restricting the action to only those accounts that created the service within an application.

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys

        Applies to actions:

        - .toCreateRoute()
        - .toCreateService()
        - .toDeleteRoute()
        - .toDeleteService()
        - .toGetRoute()
        - .toGetService()
        - .toTagResource()
        - .toUntagResource()
        - .toUpdateRoute()

        Applies to resource types:

        - service
        - route

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__205a974a40572c29a1133ce70f6e3e4c4fe97d0bdaf9fdc58fd1b43f029ddb46)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RefactorSpaces", jsii.invoke(self, "ifServiceCreatedByAccount", [value, operator]))

    @jsii.member(jsii_name="ifSourcePath")
    def if_source_path(
        self,
        value: typing.Union[builtins.str, typing.Sequence[builtins.str]],
        operator: typing.Optional[typing.Union[builtins.str, Operator]] = None,
    ) -> "RefactorSpaces":
        '''(experimental) Filters access by the path of the route.

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys

        Applies to actions:

        - .toCreateRoute()
        - .toDeleteRoute()
        - .toGetRoute()
        - .toTagResource()
        - .toUntagResource()
        - .toUpdateRoute()

        Applies to resource types:

        - route

        :param value: The value(s) to check.
        :param operator: Works with `string operators <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String>`_. **Default:** ``StringLike``.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8f18a143a2b47c0483c36214e269ddd3687ec8c61cb4a0e21aeb77fa05896369)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
        return typing.cast("RefactorSpaces", jsii.invoke(self, "ifSourcePath", [value, operator]))

    @jsii.member(jsii_name="onApplication")
    def on_application(
        self,
        environment_id: builtins.str,
        application_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RefactorSpaces":
        '''(experimental) Adds a resource of type application to the statement.

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources

        :param environment_id: - Identifier for the environmentId.
        :param application_id: - Identifier for the applicationId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifApplicationCreatedByAccount() - .ifCreatedByAccountIds()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__754a7da14fd2f9f19adee64fd048e6d479bb2856da6394ace5200c1e6be98cb4)
            check_type(argname="argument environment_id", value=environment_id, expected_type=type_hints["environment_id"])
            check_type(argname="argument application_id", value=application_id, expected_type=type_hints["application_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RefactorSpaces", jsii.invoke(self, "onApplication", [environment_id, application_id, account, region, partition]))

    @jsii.member(jsii_name="onEnvironment")
    def on_environment(
        self,
        environment_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RefactorSpaces":
        '''(experimental) Adds a resource of type environment to the statement.

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources

        :param environment_id: - Identifier for the environmentId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f84d4717d9c36c5615b4334e6edc50c3172fcec55602449f6091acd5f3ff84f8)
            check_type(argname="argument environment_id", value=environment_id, expected_type=type_hints["environment_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RefactorSpaces", jsii.invoke(self, "onEnvironment", [environment_id, account, region, partition]))

    @jsii.member(jsii_name="onRoute")
    def on_route(
        self,
        environment_id: builtins.str,
        application_id: builtins.str,
        route_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RefactorSpaces":
        '''(experimental) Adds a resource of type route to the statement.

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources

        :param environment_id: - Identifier for the environmentId.
        :param application_id: - Identifier for the applicationId.
        :param route_id: - Identifier for the routeId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifApplicationCreatedByAccount() - .ifCreatedByAccountIds() - .ifRouteCreatedByAccount() - .ifServiceCreatedByAccount() - .ifSourcePath()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59eaddf66b2beb99457c80e8e438a7e35b27ba269358f23c560a0e55eb555407)
            check_type(argname="argument environment_id", value=environment_id, expected_type=type_hints["environment_id"])
            check_type(argname="argument application_id", value=application_id, expected_type=type_hints["application_id"])
            check_type(argname="argument route_id", value=route_id, expected_type=type_hints["route_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RefactorSpaces", jsii.invoke(self, "onRoute", [environment_id, application_id, route_id, account, region, partition]))

    @jsii.member(jsii_name="onService")
    def on_service(
        self,
        environment_id: builtins.str,
        application_id: builtins.str,
        service_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "RefactorSpaces":
        '''(experimental) Adds a resource of type service to the statement.

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources

        :param environment_id: - Identifier for the environmentId.
        :param application_id: - Identifier for the applicationId.
        :param service_id: - Identifier for the serviceId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag() - .ifApplicationCreatedByAccount() - .ifCreatedByAccountIds() - .ifServiceCreatedByAccount()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b2b9c11e7b42d64f38a16dbb2213b91744b4ed859bc32759beef94edd215f9c)
            check_type(argname="argument environment_id", value=environment_id, expected_type=type_hints["environment_id"])
            check_type(argname="argument application_id", value=application_id, expected_type=type_hints["application_id"])
            check_type(argname="argument service_id", value=service_id, expected_type=type_hints["service_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("RefactorSpaces", jsii.invoke(self, "onService", [environment_id, application_id, service_id, account, region, partition]))

    @jsii.member(jsii_name="toCreateApplication")
    def to_create_application(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to create an application within an environment.

        Access Level: Write

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateApplication.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toCreateApplication", []))

    @jsii.member(jsii_name="toCreateEnvironment")
    def to_create_environment(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to create an environment.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateEnvironment.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toCreateEnvironment", []))

    @jsii.member(jsii_name="toCreateRoute")
    def to_create_route(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to create a route within an application.

        Access Level: Write

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifServiceCreatedByAccount()
        - .ifRouteCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifSourcePath()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateRoute.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toCreateRoute", []))

    @jsii.member(jsii_name="toCreateService")
    def to_create_service(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to create a service within an application.

        Access Level: Write

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifServiceCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateService.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toCreateService", []))

    @jsii.member(jsii_name="toDeleteApplication")
    def to_delete_application(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to delete an application from an environment.

        Access Level: Write

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_DeleteApplication.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toDeleteApplication", []))

    @jsii.member(jsii_name="toDeleteEnvironment")
    def to_delete_environment(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to delete an environment.

        Access Level: Write

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_DeleteEnvironment.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toDeleteEnvironment", []))

    @jsii.member(jsii_name="toDeleteResourcePolicy")
    def to_delete_resource_policy(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to delete a resource policy.

        Access Level: Write

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_DeleteResourcePolicy.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toDeleteResourcePolicy", []))

    @jsii.member(jsii_name="toDeleteRoute")
    def to_delete_route(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to delete a route from an application.

        Access Level: Write

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifServiceCreatedByAccount()
        - .ifRouteCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifSourcePath()
        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_DeleteRoute.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toDeleteRoute", []))

    @jsii.member(jsii_name="toDeleteService")
    def to_delete_service(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to delete a service from an application.

        Access Level: Write

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifServiceCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_DeleteService.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toDeleteService", []))

    @jsii.member(jsii_name="toGetApplication")
    def to_get_application(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to get more information about an application.

        Access Level: Read

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_GetApplication.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toGetApplication", []))

    @jsii.member(jsii_name="toGetEnvironment")
    def to_get_environment(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to get more information for an environment.

        Access Level: Read

        Possible conditions:

        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_GetEnvironment.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toGetEnvironment", []))

    @jsii.member(jsii_name="toGetResourcePolicy")
    def to_get_resource_policy(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to get the details about a resource policy.

        Access Level: Read

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_GetResourcePolicy.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toGetResourcePolicy", []))

    @jsii.member(jsii_name="toGetRoute")
    def to_get_route(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to get more information about a route.

        Access Level: Read

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifServiceCreatedByAccount()
        - .ifRouteCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifSourcePath()
        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_GetRoute.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toGetRoute", []))

    @jsii.member(jsii_name="toGetService")
    def to_get_service(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to get more information about a service.

        Access Level: Read

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifServiceCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_GetService.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toGetService", []))

    @jsii.member(jsii_name="toListApplications")
    def to_list_applications(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to list all the applications in an environment.

        Access Level: Read

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_ListApplications.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toListApplications", []))

    @jsii.member(jsii_name="toListEnvironments")
    def to_list_environments(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to list all environments.

        Access Level: Read

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_ListEnvironments.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toListEnvironments", []))

    @jsii.member(jsii_name="toListEnvironmentVpcs")
    def to_list_environment_vpcs(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to list all the VPCs for the environment.

        Access Level: Read

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_ListEnvironmentVpcs.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toListEnvironmentVpcs", []))

    @jsii.member(jsii_name="toListRoutes")
    def to_list_routes(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to list all the routes in an application.

        Access Level: Read

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_ListRoutes.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toListRoutes", []))

    @jsii.member(jsii_name="toListServices")
    def to_list_services(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to list all the services in an environment.

        Access Level: Read

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_ListServices.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toListServices", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to list all the tags for a given resource.

        Access Level: Read

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toPutResourcePolicy")
    def to_put_resource_policy(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to add a resource policy.

        Access Level: Write

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_PutResourcePolicy.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toPutResourcePolicy", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to tag a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifServiceCreatedByAccount()
        - .ifRouteCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifSourcePath()
        - .ifAwsTagKeys()
        - .ifAwsRequestTag()
        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to remove a tag from a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifServiceCreatedByAccount()
        - .ifRouteCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifSourcePath()
        - .ifAwsTagKeys()
        - .ifAwsRequestTag()
        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateRoute")
    def to_update_route(self) -> "RefactorSpaces":
        '''(experimental) Grants permission to update a route from an application.

        Access Level: Write

        Possible conditions:

        - .ifApplicationCreatedByAccount()
        - .ifServiceCreatedByAccount()
        - .ifRouteCreatedByAccount()
        - .ifCreatedByAccountIds()
        - .ifSourcePath()
        - .ifAwsResourceTag()

        https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_UpdateRoute.html

        :stability: experimental
        '''
        return typing.cast("RefactorSpaces", jsii.invoke(self, "toUpdateRoute", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5cb3c976e58628525dbadc56cbebd62db90603b9d8af00e659e42408c7e2eeea)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__449746669f9fce40e5d293c9262444795d0bc86d05dcf5f41004009a88f7aeea)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Rekognition(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Rekognition",
):
    '''(experimental) Statement provider for service `rekognition <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrekognition.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `rekognition <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrekognition.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1841891799190e920d73bc734030bf5a06299205c248cb3ca6b471c1a00fc54b)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onCollection")
    def on_collection(
        self,
        collection_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rekognition":
        '''(experimental) Adds a resource of type collection to the statement.

        https://docs.aws.amazon.com/rekognition/latest/dg/collections.html

        :param collection_id: - Identifier for the collectionId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74432c007be534094ac5e01b546cd6348d1694fcaf76919e87d2b93d80cf3423)
            check_type(argname="argument collection_id", value=collection_id, expected_type=type_hints["collection_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rekognition", jsii.invoke(self, "onCollection", [collection_id, account, region, partition]))

    @jsii.member(jsii_name="onDataset")
    def on_dataset(
        self,
        project_name: builtins.str,
        dataset_type: builtins.str,
        creation_timestamp: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rekognition":
        '''(experimental) Adds a resource of type dataset to the statement.

        https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/creating-datasets.html

        :param project_name: - Identifier for the projectName.
        :param dataset_type: - Identifier for the datasetType.
        :param creation_timestamp: - Identifier for the creationTimestamp.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8d5d5b0b99b75f7bc1665613b56ecc8383accbe20585c9a94c8b2b23418b5c3)
            check_type(argname="argument project_name", value=project_name, expected_type=type_hints["project_name"])
            check_type(argname="argument dataset_type", value=dataset_type, expected_type=type_hints["dataset_type"])
            check_type(argname="argument creation_timestamp", value=creation_timestamp, expected_type=type_hints["creation_timestamp"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rekognition", jsii.invoke(self, "onDataset", [project_name, dataset_type, creation_timestamp, account, region, partition]))

    @jsii.member(jsii_name="onProject")
    def on_project(
        self,
        project_name: builtins.str,
        creation_timestamp: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rekognition":
        '''(experimental) Adds a resource of type project to the statement.

        https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/mp-create-project.html

        :param project_name: - Identifier for the projectName.
        :param creation_timestamp: - Identifier for the creationTimestamp.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e371b3130deb575d899292278fe9d2dd5929fd7b5d279b339bf3b7e78fdf457d)
            check_type(argname="argument project_name", value=project_name, expected_type=type_hints["project_name"])
            check_type(argname="argument creation_timestamp", value=creation_timestamp, expected_type=type_hints["creation_timestamp"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rekognition", jsii.invoke(self, "onProject", [project_name, creation_timestamp, account, region, partition]))

    @jsii.member(jsii_name="onProjectversion")
    def on_projectversion(
        self,
        project_name: builtins.str,
        version_name: builtins.str,
        creation_timestamp: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rekognition":
        '''(experimental) Adds a resource of type projectversion to the statement.

        https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/training-model.html

        :param project_name: - Identifier for the projectName.
        :param version_name: - Identifier for the versionName.
        :param creation_timestamp: - Identifier for the creationTimestamp.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1699089d4bd5249a4491fa0eef7fcd437df4db88962642cb330fcb0abff2a634)
            check_type(argname="argument project_name", value=project_name, expected_type=type_hints["project_name"])
            check_type(argname="argument version_name", value=version_name, expected_type=type_hints["version_name"])
            check_type(argname="argument creation_timestamp", value=creation_timestamp, expected_type=type_hints["creation_timestamp"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rekognition", jsii.invoke(self, "onProjectversion", [project_name, version_name, creation_timestamp, account, region, partition]))

    @jsii.member(jsii_name="onStreamprocessor")
    def on_streamprocessor(
        self,
        streamprocessor_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rekognition":
        '''(experimental) Adds a resource of type streamprocessor to the statement.

        https://docs.aws.amazon.com/rekognition/latest/dg/streaming-video.html

        :param streamprocessor_id: - Identifier for the streamprocessorId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ecffc1329d65e1918fa85a5b6a91cc8bfc5c91e5b369bc0e493eaaa4c816c017)
            check_type(argname="argument streamprocessor_id", value=streamprocessor_id, expected_type=type_hints["streamprocessor_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rekognition", jsii.invoke(self, "onStreamprocessor", [streamprocessor_id, account, region, partition]))

    @jsii.member(jsii_name="toCompareFaces")
    def to_compare_faces(self) -> "Rekognition":
        '''(experimental) Grants permission to compare faces in the source input image with each face detected in the target input image.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CompareFaces.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toCompareFaces", []))

    @jsii.member(jsii_name="toCopyProjectVersion")
    def to_copy_project_version(self) -> "Rekognition":
        '''(experimental) Grants permission to copy an existing model version to a new model version.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CopyProjectVersion.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toCopyProjectVersion", []))

    @jsii.member(jsii_name="toCreateCollection")
    def to_create_collection(self) -> "Rekognition":
        '''(experimental) Grants permission to create a collection in an AWS Region.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateCollection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toCreateCollection", []))

    @jsii.member(jsii_name="toCreateDataset")
    def to_create_dataset(self) -> "Rekognition":
        '''(experimental) Grants permission to create a new Amazon Rekognition Custom Labels dataset.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateDataset.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toCreateDataset", []))

    @jsii.member(jsii_name="toCreateProject")
    def to_create_project(self) -> "Rekognition":
        '''(experimental) Grants permission to create an Amazon Rekognition Custom Labels project.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateProject.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toCreateProject", []))

    @jsii.member(jsii_name="toCreateProjectVersion")
    def to_create_project_version(self) -> "Rekognition":
        '''(experimental) Grants permission to begin training a new version of a model.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateProjectVersion.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toCreateProjectVersion", []))

    @jsii.member(jsii_name="toCreateStreamProcessor")
    def to_create_stream_processor(self) -> "Rekognition":
        '''(experimental) Grants permission to create an Amazon Rekognition stream processor.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toCreateStreamProcessor", []))

    @jsii.member(jsii_name="toDeleteCollection")
    def to_delete_collection(self) -> "Rekognition":
        '''(experimental) Grants permission to delete the specified collection.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteCollection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDeleteCollection", []))

    @jsii.member(jsii_name="toDeleteDataset")
    def to_delete_dataset(self) -> "Rekognition":
        '''(experimental) Grants permission to delete an existing Amazon Rekognition Custom Labels dataset.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteDataset.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDeleteDataset", []))

    @jsii.member(jsii_name="toDeleteFaces")
    def to_delete_faces(self) -> "Rekognition":
        '''(experimental) Grants permission to delete faces from a collection.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteFaces.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDeleteFaces", []))

    @jsii.member(jsii_name="toDeleteProject")
    def to_delete_project(self) -> "Rekognition":
        '''(experimental) Grants permission to delete a project.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteProject.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDeleteProject", []))

    @jsii.member(jsii_name="toDeleteProjectPolicy")
    def to_delete_project_policy(self) -> "Rekognition":
        '''(experimental) Grants permission to delete a resource policy attached to a project.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteProjectPolicy.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDeleteProjectPolicy", []))

    @jsii.member(jsii_name="toDeleteProjectVersion")
    def to_delete_project_version(self) -> "Rekognition":
        '''(experimental) Grants permission to delete a model.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteProjectVersion.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDeleteProjectVersion", []))

    @jsii.member(jsii_name="toDeleteStreamProcessor")
    def to_delete_stream_processor(self) -> "Rekognition":
        '''(experimental) Grants permission to delete the specified stream processor.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteStreamProcessor.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDeleteStreamProcessor", []))

    @jsii.member(jsii_name="toDescribeCollection")
    def to_describe_collection(self) -> "Rekognition":
        '''(experimental) Grants permission to read details about a collection.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DescribeCollection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDescribeCollection", []))

    @jsii.member(jsii_name="toDescribeDataset")
    def to_describe_dataset(self) -> "Rekognition":
        '''(experimental) Grants permission to describe an Amazon Rekognition Custom Labels dataset.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DescribeDataset.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDescribeDataset", []))

    @jsii.member(jsii_name="toDescribeProjects")
    def to_describe_projects(self) -> "Rekognition":
        '''(experimental) Grants permission to list Amazon Rekognition Custom Labels projects.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DescribeProjects.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDescribeProjects", []))

    @jsii.member(jsii_name="toDescribeProjectVersions")
    def to_describe_project_versions(self) -> "Rekognition":
        '''(experimental) Grants permission to list the versions of a model in an Amazon Rekognition Custom Labels project.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DescribeProjectVersions.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDescribeProjectVersions", []))

    @jsii.member(jsii_name="toDescribeStreamProcessor")
    def to_describe_stream_processor(self) -> "Rekognition":
        '''(experimental) Grants permission to get information about the specified stream processor.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DescribeStreamProcessor.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDescribeStreamProcessor", []))

    @jsii.member(jsii_name="toDetectCustomLabels")
    def to_detect_custom_labels(self) -> "Rekognition":
        '''(experimental) Grants permission to detect custom labels in a supplied image.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectCustomLabels.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDetectCustomLabels", []))

    @jsii.member(jsii_name="toDetectFaces")
    def to_detect_faces(self) -> "Rekognition":
        '''(experimental) Grants permission to detect human faces within an image provided as input.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectFaces.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDetectFaces", []))

    @jsii.member(jsii_name="toDetectLabels")
    def to_detect_labels(self) -> "Rekognition":
        '''(experimental) Grants permission to detect instances of real-world labels within an image provided as input.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectLabels.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDetectLabels", []))

    @jsii.member(jsii_name="toDetectModerationLabels")
    def to_detect_moderation_labels(self) -> "Rekognition":
        '''(experimental) Grants permission to detect moderation labels within the input image.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectModerationLabels.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDetectModerationLabels", []))

    @jsii.member(jsii_name="toDetectProtectiveEquipment")
    def to_detect_protective_equipment(self) -> "Rekognition":
        '''(experimental) Grants permission to detect Personal Protective Equipment in the input image.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectProtectiveEquipment.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDetectProtectiveEquipment", []))

    @jsii.member(jsii_name="toDetectText")
    def to_detect_text(self) -> "Rekognition":
        '''(experimental) Grants permission to detect text in the input image and convert it into machine-readable text.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectText.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDetectText", []))

    @jsii.member(jsii_name="toDistributeDatasetEntries")
    def to_distribute_dataset_entries(self) -> "Rekognition":
        '''(experimental) Grants permission to distribute the entries in a training dataset across the training dataset and the test dataset for a project.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DistributeDatasetEntries.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toDistributeDatasetEntries", []))

    @jsii.member(jsii_name="toGetCelebrityInfo")
    def to_get_celebrity_info(self) -> "Rekognition":
        '''(experimental) Grants permission to read the name, and additional information, of a celebrity.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetCelebrityInfo.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toGetCelebrityInfo", []))

    @jsii.member(jsii_name="toGetCelebrityRecognition")
    def to_get_celebrity_recognition(self) -> "Rekognition":
        '''(experimental) Grants permission to read the celebrity recognition results found in a stored video by an asynchronous celebrity recognition job.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetCelebrityRecognition.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toGetCelebrityRecognition", []))

    @jsii.member(jsii_name="toGetContentModeration")
    def to_get_content_moderation(self) -> "Rekognition":
        '''(experimental) Grants permission to read the content moderation analysis results found in a stored video by an asynchronous content moderation job.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetContentModeration.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toGetContentModeration", []))

    @jsii.member(jsii_name="toGetFaceDetection")
    def to_get_face_detection(self) -> "Rekognition":
        '''(experimental) Grants permission to read the faces detection results found in a stored video by an asynchronous face detection job.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetFaceDetection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toGetFaceDetection", []))

    @jsii.member(jsii_name="toGetFaceSearch")
    def to_get_face_search(self) -> "Rekognition":
        '''(experimental) Grants permission to read the matching collection faces found in a stored video by an asynchronous face search job.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetFaceSearch.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toGetFaceSearch", []))

    @jsii.member(jsii_name="toGetLabelDetection")
    def to_get_label_detection(self) -> "Rekognition":
        '''(experimental) Grants permission to read the label detected resuls found in a stored video by an asynchronous label detection job.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetLabelDetection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toGetLabelDetection", []))

    @jsii.member(jsii_name="toGetPersonTracking")
    def to_get_person_tracking(self) -> "Rekognition":
        '''(experimental) Grants permission to read the list of persons detected in a stored video by an asynchronous person tracking job.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetPersonTracking.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toGetPersonTracking", []))

    @jsii.member(jsii_name="toGetSegmentDetection")
    def to_get_segment_detection(self) -> "Rekognition":
        '''(experimental) Grants permission to get the vdeo segments found in a stored video by an asynchronous segment detection job.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetSegmentDetection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toGetSegmentDetection", []))

    @jsii.member(jsii_name="toGetTextDetection")
    def to_get_text_detection(self) -> "Rekognition":
        '''(experimental) Grants permission to get the text found in a stored video by an asynchronous text detection job.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetTextDetection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toGetTextDetection", []))

    @jsii.member(jsii_name="toIndexFaces")
    def to_index_faces(self) -> "Rekognition":
        '''(experimental) Grants permission to update an existing collection with faces detected in the input image.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_IndexFaces.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toIndexFaces", []))

    @jsii.member(jsii_name="toListCollections")
    def to_list_collections(self) -> "Rekognition":
        '''(experimental) Grants permission to read the collection Id's in your account.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListCollections.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toListCollections", []))

    @jsii.member(jsii_name="toListDatasetEntries")
    def to_list_dataset_entries(self) -> "Rekognition":
        '''(experimental) Grants permission to list the dataset entries in an existing Amazon Rekognition Custom Labels dataset.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListDatasetEntries.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toListDatasetEntries", []))

    @jsii.member(jsii_name="toListDatasetLabels")
    def to_list_dataset_labels(self) -> "Rekognition":
        '''(experimental) Grants permission to list the labels in a dataset.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListDatasetLabels.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toListDatasetLabels", []))

    @jsii.member(jsii_name="toListFaces")
    def to_list_faces(self) -> "Rekognition":
        '''(experimental) Grants permission to read metadata for faces in the specificed collection.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListFaces.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toListFaces", []))

    @jsii.member(jsii_name="toListProjectPolicies")
    def to_list_project_policies(self) -> "Rekognition":
        '''(experimental) Grants permission to list the resource policies attached to a project.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListProjectPolicies.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toListProjectPolicies", []))

    @jsii.member(jsii_name="toListStreamProcessors")
    def to_list_stream_processors(self) -> "Rekognition":
        '''(experimental) Grants permission to get a list of your stream processors.

        Access Level: List

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListStreamProcessors.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toListStreamProcessors", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Rekognition":
        '''(experimental) Grants permission to return a list of tags associated with a resource.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toPutProjectPolicy")
    def to_put_project_policy(self) -> "Rekognition":
        '''(experimental) Grants permission to attach a resource policy to a project.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_PutProjectPolicy.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toPutProjectPolicy", []))

    @jsii.member(jsii_name="toRecognizeCelebrities")
    def to_recognize_celebrities(self) -> "Rekognition":
        '''(experimental) Grants permission to detect celebrities in the input image.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RecognizeCelebrities.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toRecognizeCelebrities", []))

    @jsii.member(jsii_name="toSearchFaces")
    def to_search_faces(self) -> "Rekognition":
        '''(experimental) Grants permission to search the specificed collection for the supplied face ID.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_SearchFaces.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toSearchFaces", []))

    @jsii.member(jsii_name="toSearchFacesByImage")
    def to_search_faces_by_image(self) -> "Rekognition":
        '''(experimental) Grants permission to search the specificed collection for the largest face in the input image.

        Access Level: Read

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_SearchFacesByImage.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toSearchFacesByImage", []))

    @jsii.member(jsii_name="toStartCelebrityRecognition")
    def to_start_celebrity_recognition(self) -> "Rekognition":
        '''(experimental) Grants permission to start the asynchronous recognition of celebrities in a stored video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartCelebrityRecognition.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStartCelebrityRecognition", []))

    @jsii.member(jsii_name="toStartContentModeration")
    def to_start_content_moderation(self) -> "Rekognition":
        '''(experimental) Grants permission to start asynchronous detection of explicit or suggestive adult content in a stored video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartContentModeration.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStartContentModeration", []))

    @jsii.member(jsii_name="toStartFaceDetection")
    def to_start_face_detection(self) -> "Rekognition":
        '''(experimental) Grants permission to start asynchronous detection of faces in a stored video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartFaceDetection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStartFaceDetection", []))

    @jsii.member(jsii_name="toStartFaceSearch")
    def to_start_face_search(self) -> "Rekognition":
        '''(experimental) Grants permission to start an asynchronous search for faces in a collection that match the faces of persons detected in a stored video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartFaceSearch.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStartFaceSearch", []))

    @jsii.member(jsii_name="toStartLabelDetection")
    def to_start_label_detection(self) -> "Rekognition":
        '''(experimental) Grants permission to start asynchronous detection of labels in a stored video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartLabelDetection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStartLabelDetection", []))

    @jsii.member(jsii_name="toStartPersonTracking")
    def to_start_person_tracking(self) -> "Rekognition":
        '''(experimental) Grants permission to start the asynchronous tracking of persons in a stored video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartPersonTracking.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStartPersonTracking", []))

    @jsii.member(jsii_name="toStartProjectVersion")
    def to_start_project_version(self) -> "Rekognition":
        '''(experimental) Grants permission to start running a model version.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartProjectVersion.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStartProjectVersion", []))

    @jsii.member(jsii_name="toStartSegmentDetection")
    def to_start_segment_detection(self) -> "Rekognition":
        '''(experimental) Grants permission to start the asynchronous detection of segments in a stored video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartSegmentDetection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStartSegmentDetection", []))

    @jsii.member(jsii_name="toStartStreamProcessor")
    def to_start_stream_processor(self) -> "Rekognition":
        '''(experimental) Grants permission to start running a stream processor.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartStreamProcessor.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStartStreamProcessor", []))

    @jsii.member(jsii_name="toStartTextDetection")
    def to_start_text_detection(self) -> "Rekognition":
        '''(experimental) Grants permission to start the asynchronous detection of text in a stored video.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartTextDetection.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStartTextDetection", []))

    @jsii.member(jsii_name="toStopProjectVersion")
    def to_stop_project_version(self) -> "Rekognition":
        '''(experimental) Grants permission to stop a running model version.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StopProjectVersion.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStopProjectVersion", []))

    @jsii.member(jsii_name="toStopStreamProcessor")
    def to_stop_stream_processor(self) -> "Rekognition":
        '''(experimental) Grants permission to stop a running stream processor.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StopStreamProcessor.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toStopStreamProcessor", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Rekognition":
        '''(experimental) Grants permission to add one or more tags to a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Rekognition":
        '''(experimental) Grants permission to remove one or more tags from a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateDatasetEntries")
    def to_update_dataset_entries(self) -> "Rekognition":
        '''(experimental) Grants permission to add or update one or more JSON Lines (entries) in a dataset.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_UpdateDatasetEntries.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toUpdateDatasetEntries", []))

    @jsii.member(jsii_name="toUpdateStreamProcessor")
    def to_update_stream_processor(self) -> "Rekognition":
        '''(experimental) Grants permission to modify properties for a stream processor.

        Access Level: Write

        https://docs.aws.amazon.com/rekognition/latest/APIReference/API_UpdateStreamProcessor.html

        :stability: experimental
        '''
        return typing.cast("Rekognition", jsii.invoke(self, "toUpdateStreamProcessor", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c9b88152714cf0853b143b864ec1874958a872bb90d95de550cb11614b45d63e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__137b91340982eba80838094e6d5543f92389d5c1df2936cd7dcbc1ea38fe3442)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Resiliencehub(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Resiliencehub",
):
    '''(experimental) Statement provider for service `resiliencehub <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresiliencehubservice.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `resiliencehub <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresiliencehubservice.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ccc6564bd955878e893e467943a784b479683f56588c6361c1296cecbc1147a)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onAppAssessment")
    def on_app_assessment(
        self,
        app_assessment_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Resiliencehub":
        '''(experimental) Adds a resource of type app-assessment to the statement.

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_AppAssessment.html

        :param app_assessment_id: - Identifier for the appAssessmentId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__84ad352677a2ceaf551975e74e750ee8e5ebfe303c2613dc2325115a6343003a)
            check_type(argname="argument app_assessment_id", value=app_assessment_id, expected_type=type_hints["app_assessment_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Resiliencehub", jsii.invoke(self, "onAppAssessment", [app_assessment_id, account, region, partition]))

    @jsii.member(jsii_name="onApplication")
    def on_application(
        self,
        app_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Resiliencehub":
        '''(experimental) Adds a resource of type application to the statement.

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_App.html

        :param app_id: - Identifier for the appId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__12bddb5aaf190bbec30fcdd2b9cc2379a605f48175a5d978be17f0b72ebf88b2)
            check_type(argname="argument app_id", value=app_id, expected_type=type_hints["app_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Resiliencehub", jsii.invoke(self, "onApplication", [app_id, account, region, partition]))

    @jsii.member(jsii_name="onRecommendationTemplate")
    def on_recommendation_template(
        self,
        recommendation_template_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Resiliencehub":
        '''(experimental) Adds a resource of type recommendation-template to the statement.

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_RecommendationTemplate.html

        :param recommendation_template_id: - Identifier for the recommendationTemplateId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7f87d4228c884f3a24dfed7cc0aeb7ebe1f6662256acbba65d824bdf1fd46b35)
            check_type(argname="argument recommendation_template_id", value=recommendation_template_id, expected_type=type_hints["recommendation_template_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Resiliencehub", jsii.invoke(self, "onRecommendationTemplate", [recommendation_template_id, account, region, partition]))

    @jsii.member(jsii_name="onResiliencyPolicy")
    def on_resiliency_policy(
        self,
        resiliency_policy_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Resiliencehub":
        '''(experimental) Adds a resource of type resiliency-policy to the statement.

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ResiliencyPolicy.html

        :param resiliency_policy_id: - Identifier for the resiliencyPolicyId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8848449db0f4daa8ac39918d199d05d8a5d500ef249db18322b21cd5e29bdd26)
            check_type(argname="argument resiliency_policy_id", value=resiliency_policy_id, expected_type=type_hints["resiliency_policy_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Resiliencehub", jsii.invoke(self, "onResiliencyPolicy", [resiliency_policy_id, account, region, partition]))

    @jsii.member(jsii_name="toAddDraftAppVersionResourceMappings")
    def to_add_draft_app_version_resource_mappings(self) -> "Resiliencehub":
        '''(experimental) Grants permission to add draft application version resource mappings.

        Access Level: Write

        Dependent actions:

        - cloudformation:DescribeStacks
        - cloudformation:ListStackResources
        - resource-groups:GetGroup
        - resource-groups:ListGroupResources
        - servicecatalog:GetApplication
        - servicecatalog:ListAssociatedResources

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_AddDraftAppVersionResourceMappings.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toAddDraftAppVersionResourceMappings", []))

    @jsii.member(jsii_name="toCreateApp")
    def to_create_app(self) -> "Resiliencehub":
        '''(experimental) Grants permission to create application.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateApp.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toCreateApp", []))

    @jsii.member(jsii_name="toCreateAppVersionAppComponent")
    def to_create_app_version_app_component(self) -> "Resiliencehub":
        '''(experimental) Grants permission to create application app component.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateAppVersionAppComponent.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toCreateAppVersionAppComponent", []))

    @jsii.member(jsii_name="toCreateAppVersionResource")
    def to_create_app_version_resource(self) -> "Resiliencehub":
        '''(experimental) Grants permission to create application resource.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateAppVersionResource.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toCreateAppVersionResource", []))

    @jsii.member(jsii_name="toCreateRecommendationTemplate")
    def to_create_recommendation_template(self) -> "Resiliencehub":
        '''(experimental) Grants permission to create recommendation template.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - s3:CreateBucket
        - s3:ListBucket
        - s3:PutObject

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateRecommendationTemplate.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toCreateRecommendationTemplate", []))

    @jsii.member(jsii_name="toCreateResiliencyPolicy")
    def to_create_resiliency_policy(self) -> "Resiliencehub":
        '''(experimental) Grants permission to create resiliency policy.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateResiliencyPolicy.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toCreateResiliencyPolicy", []))

    @jsii.member(jsii_name="toDeleteApp")
    def to_delete_app(self) -> "Resiliencehub":
        '''(experimental) Grants permission to batch delete application.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteApp.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDeleteApp", []))

    @jsii.member(jsii_name="toDeleteAppAssessment")
    def to_delete_app_assessment(self) -> "Resiliencehub":
        '''(experimental) Grants permission to batch delete application assessment.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteAppAssessment.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDeleteAppAssessment", []))

    @jsii.member(jsii_name="toDeleteAppInputSource")
    def to_delete_app_input_source(self) -> "Resiliencehub":
        '''(experimental) Grants permission to remove application input source.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteAppInputSource.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDeleteAppInputSource", []))

    @jsii.member(jsii_name="toDeleteAppVersionAppComponent")
    def to_delete_app_version_app_component(self) -> "Resiliencehub":
        '''(experimental) Grants permission to delete application app component.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteAppVersionAppComponent.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDeleteAppVersionAppComponent", []))

    @jsii.member(jsii_name="toDeleteAppVersionResource")
    def to_delete_app_version_resource(self) -> "Resiliencehub":
        '''(experimental) Grants permission to delete application resource.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteAppVersionResource.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDeleteAppVersionResource", []))

    @jsii.member(jsii_name="toDeleteRecommendationTemplate")
    def to_delete_recommendation_template(self) -> "Resiliencehub":
        '''(experimental) Grants permission to batch delete recommendation template.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteRecommendationTemplate.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDeleteRecommendationTemplate", []))

    @jsii.member(jsii_name="toDeleteResiliencyPolicy")
    def to_delete_resiliency_policy(self) -> "Resiliencehub":
        '''(experimental) Grants permission to batch delete resiliency policy.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteResiliencyPolicy.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDeleteResiliencyPolicy", []))

    @jsii.member(jsii_name="toDescribeApp")
    def to_describe_app(self) -> "Resiliencehub":
        '''(experimental) Grants permission to describe application.

        Access Level: Read

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeApp.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDescribeApp", []))

    @jsii.member(jsii_name="toDescribeAppAssessment")
    def to_describe_app_assessment(self) -> "Resiliencehub":
        '''(experimental) Grants permission to describe application assessment.

        Access Level: Read

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppAssessment.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDescribeAppAssessment", []))

    @jsii.member(jsii_name="toDescribeAppVersion")
    def to_describe_app_version(self) -> "Resiliencehub":
        '''(experimental) Grants permission to describe application version.

        Access Level: Read

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersion.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDescribeAppVersion", []))

    @jsii.member(jsii_name="toDescribeAppVersionAppComponent")
    def to_describe_app_version_app_component(self) -> "Resiliencehub":
        '''(experimental) Grants permission to describe application version app component.

        Access Level: Read

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionAppComponent.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDescribeAppVersionAppComponent", []))

    @jsii.member(jsii_name="toDescribeAppVersionResource")
    def to_describe_app_version_resource(self) -> "Resiliencehub":
        '''(experimental) Grants permission to describe application version resource.

        Access Level: Read

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionResource.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDescribeAppVersionResource", []))

    @jsii.member(jsii_name="toDescribeAppVersionResourcesResolutionStatus")
    def to_describe_app_version_resources_resolution_status(self) -> "Resiliencehub":
        '''(experimental) Grants permission to describe application resolution.

        Access Level: Read

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionResourcesResolutionStatus.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDescribeAppVersionResourcesResolutionStatus", []))

    @jsii.member(jsii_name="toDescribeAppVersionTemplate")
    def to_describe_app_version_template(self) -> "Resiliencehub":
        '''(experimental) Grants permission to describe application version template.

        Access Level: Read

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionTemplate.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDescribeAppVersionTemplate", []))

    @jsii.member(jsii_name="toDescribeDraftAppVersionResourcesImportStatus")
    def to_describe_draft_app_version_resources_import_status(self) -> "Resiliencehub":
        '''(experimental) Grants permission to describe draft application version resources import status.

        Access Level: Read

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeDraftAppVersionResourcesImportStatus.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDescribeDraftAppVersionResourcesImportStatus", []))

    @jsii.member(jsii_name="toDescribeResiliencyPolicy")
    def to_describe_resiliency_policy(self) -> "Resiliencehub":
        '''(experimental) Grants permission to describe resiliency policy.

        Access Level: Read

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeResiliencyPolicy.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toDescribeResiliencyPolicy", []))

    @jsii.member(jsii_name="toImportResourcesToDraftAppVersion")
    def to_import_resources_to_draft_app_version(self) -> "Resiliencehub":
        '''(experimental) Grants permission to import resources to draft application version.

        Access Level: Write

        Dependent actions:

        - cloudformation:DescribeStacks
        - cloudformation:ListStackResources
        - resource-groups:GetGroup
        - resource-groups:ListGroupResources
        - servicecatalog:GetApplication
        - servicecatalog:ListAssociatedResources

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ImportResourcesToDraftAppVersion.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toImportResourcesToDraftAppVersion", []))

    @jsii.member(jsii_name="toListAlarmRecommendations")
    def to_list_alarm_recommendations(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list alarm recommendation.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAlarmRecommendations.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListAlarmRecommendations", []))

    @jsii.member(jsii_name="toListAppAssessments")
    def to_list_app_assessments(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list application assessment.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppAssessments.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListAppAssessments", []))

    @jsii.member(jsii_name="toListAppComponentCompliances")
    def to_list_app_component_compliances(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list app component compliances.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppComponentCompliances.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListAppComponentCompliances", []))

    @jsii.member(jsii_name="toListAppComponentRecommendations")
    def to_list_app_component_recommendations(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list app component recommendations.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppComponentRecommendations.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListAppComponentRecommendations", []))

    @jsii.member(jsii_name="toListAppInputSources")
    def to_list_app_input_sources(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list application input sources.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppInputSources.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListAppInputSources", []))

    @jsii.member(jsii_name="toListApps")
    def to_list_apps(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list applications.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListApps.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListApps", []))

    @jsii.member(jsii_name="toListAppVersionAppComponents")
    def to_list_app_version_app_components(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list application version app components.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionAppComponents.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListAppVersionAppComponents", []))

    @jsii.member(jsii_name="toListAppVersionResourceMappings")
    def to_list_app_version_resource_mappings(self) -> "Resiliencehub":
        '''(experimental) Grants permission to application version resource mappings.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionResourceMappings.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListAppVersionResourceMappings", []))

    @jsii.member(jsii_name="toListAppVersionResources")
    def to_list_app_version_resources(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list application resources.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionResources.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListAppVersionResources", []))

    @jsii.member(jsii_name="toListAppVersions")
    def to_list_app_versions(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list application version.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersions.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListAppVersions", []))

    @jsii.member(jsii_name="toListRecommendationTemplates")
    def to_list_recommendation_templates(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list recommendation templates.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListRecommendationTemplates.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListRecommendationTemplates", []))

    @jsii.member(jsii_name="toListResiliencyPolicies")
    def to_list_resiliency_policies(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list resiliency policies.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListResiliencyPolicies.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListResiliencyPolicies", []))

    @jsii.member(jsii_name="toListSopRecommendations")
    def to_list_sop_recommendations(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list SOP recommendations.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListSopRecommendations.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListSopRecommendations", []))

    @jsii.member(jsii_name="toListSuggestedResiliencyPolicies")
    def to_list_suggested_resiliency_policies(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list suggested resiliency policies.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListSuggestedResiliencyPolicies.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListSuggestedResiliencyPolicies", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list tags for a resource.

        Access Level: Read

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toListTestRecommendations")
    def to_list_test_recommendations(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list test recommendations.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListTestRecommendations.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListTestRecommendations", []))

    @jsii.member(jsii_name="toListUnsupportedAppVersionResources")
    def to_list_unsupported_app_version_resources(self) -> "Resiliencehub":
        '''(experimental) Grants permission to list unsupported application version resources.

        Access Level: List

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListUnsupportedAppVersionResources.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toListUnsupportedAppVersionResources", []))

    @jsii.member(jsii_name="toPublishAppVersion")
    def to_publish_app_version(self) -> "Resiliencehub":
        '''(experimental) Grants permission to publish application version.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_PublishAppVersion.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toPublishAppVersion", []))

    @jsii.member(jsii_name="toPutDraftAppVersionTemplate")
    def to_put_draft_app_version_template(self) -> "Resiliencehub":
        '''(experimental) Grants permission to put draft application version template.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_PutDraftAppVersionTemplate.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toPutDraftAppVersionTemplate", []))

    @jsii.member(jsii_name="toRemoveDraftAppVersionResourceMappings")
    def to_remove_draft_app_version_resource_mappings(self) -> "Resiliencehub":
        '''(experimental) Grants permission to remove draft application version mappings.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_RemoveDraftAppVersionResourceMappings.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toRemoveDraftAppVersionResourceMappings", []))

    @jsii.member(jsii_name="toResolveAppVersionResources")
    def to_resolve_app_version_resources(self) -> "Resiliencehub":
        '''(experimental) Grants permission to resolve application version resources.

        Access Level: Write

        Dependent actions:

        - cloudformation:DescribeStacks
        - cloudformation:ListStackResources
        - resource-groups:GetGroup
        - resource-groups:ListGroupResources
        - servicecatalog:GetApplication
        - servicecatalog:ListAssociatedResources

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ResolveAppVersionResources.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toResolveAppVersionResources", []))

    @jsii.member(jsii_name="toStartAppAssessment")
    def to_start_app_assessment(self) -> "Resiliencehub":
        '''(experimental) Grants permission to create application assessment.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - cloudformation:DescribeStacks
        - cloudformation:ListStackResources
        - cloudwatch:DescribeAlarms
        - cloudwatch:GetMetricData
        - cloudwatch:GetMetricStatistics
        - cloudwatch:PutMetricData
        - ec2:DescribeRegions
        - fis:GetExperimentTemplate
        - fis:ListExperimentTemplates
        - fis:ListExperiments
        - resource-groups:GetGroup
        - resource-groups:ListGroupResources
        - servicecatalog:GetApplication
        - servicecatalog:ListAssociatedResources
        - ssm:GetParametersByPath

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_StartAppAssessment.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toStartAppAssessment", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Resiliencehub":
        '''(experimental) Grants permission to assign a resource tag.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Resiliencehub":
        '''(experimental) Grants permission to untag a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateApp")
    def to_update_app(self) -> "Resiliencehub":
        '''(experimental) Grants permission to update application.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateApp.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toUpdateApp", []))

    @jsii.member(jsii_name="toUpdateAppVersion")
    def to_update_app_version(self) -> "Resiliencehub":
        '''(experimental) Grants permission to update application version.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateAppVersion.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toUpdateAppVersion", []))

    @jsii.member(jsii_name="toUpdateAppVersionAppComponent")
    def to_update_app_version_app_component(self) -> "Resiliencehub":
        '''(experimental) Grants permission to update application app component.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateAppVersionAppComponent.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toUpdateAppVersionAppComponent", []))

    @jsii.member(jsii_name="toUpdateAppVersionResource")
    def to_update_app_version_resource(self) -> "Resiliencehub":
        '''(experimental) Grants permission to update application resource.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateAppVersionResource.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toUpdateAppVersionResource", []))

    @jsii.member(jsii_name="toUpdateResiliencyPolicy")
    def to_update_resiliency_policy(self) -> "Resiliencehub":
        '''(experimental) Grants permission to update resiliency policy.

        Access Level: Write

        https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateResiliencyPolicy.html

        :stability: experimental
        '''
        return typing.cast("Resiliencehub", jsii.invoke(self, "toUpdateResiliencyPolicy", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb5ac232a61d1b0b1c25ec3d5a05e6d24c0f055020ddade66070b62bf01dba34)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60ca2c759bb71961c52713a4ac62f1e5ce6454f493276239c1f764861dbd9c29)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class ResourceExplorer(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.ResourceExplorer",
):
    '''(experimental) Statement provider for service `resource-explorer <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstageditor.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `resource-explorer <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstageditor.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9555de3612f3e7ca2c63c2633bfe0096280d705d78e69807a3d61169c1765a5)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="toListResources")
    def to_list_resources(self) -> "ResourceExplorer":
        '''(experimental) Grants permission to retrieve the identifiers of the resources in the AWS account.

        Access Level: List

        https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer", jsii.invoke(self, "toListResources", []))

    @jsii.member(jsii_name="toListResourceTypes")
    def to_list_resource_types(self) -> "ResourceExplorer":
        '''(experimental) Grants permission to retrieve the resource types currently supported by Tag Editor.

        Access Level: List

        https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer", jsii.invoke(self, "toListResourceTypes", []))

    @jsii.member(jsii_name="toListTags")
    def to_list_tags(self) -> "ResourceExplorer":
        '''(experimental) Grants permission to retrieve the tags attached to the specified resource identifiers.

        Access Level: Read

        Dependent actions:

        - tag:GetResources

        https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer", jsii.invoke(self, "toListTags", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__609c90c8a71ea25fe7e9f0aea1ef43a27edf440eb8847ae1bd94bea457d61505)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e9f63681845c076d3e9c75d3e3062813c02b914d36f6600de34f97466e88950f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class ResourceExplorer2(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.ResourceExplorer2",
):
    '''(experimental) Statement provider for service `resource-explorer-2 <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceexplorer.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `resource-explorer-2 <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceexplorer.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__12ba79db4a84211eda9c47c1c159e0bb069d2cbe17426d9864afd1e8299f7877)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onIndex")
    def on_index(
        self,
        index_uuid: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "ResourceExplorer2":
        '''(experimental) Adds a resource of type index to the statement.

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_Index.html

        :param index_uuid: - Identifier for the indexUuid.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__899d978dec65391999f3157cb8be10136fc6616451070a5602c4a98bc045c5ec)
            check_type(argname="argument index_uuid", value=index_uuid, expected_type=type_hints["index_uuid"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "onIndex", [index_uuid, account, region, partition]))

    @jsii.member(jsii_name="onView")
    def on_view(
        self,
        view_name: builtins.str,
        view_uuid: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "ResourceExplorer2":
        '''(experimental) Adds a resource of type view to the statement.

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_View.html

        :param view_name: - Identifier for the viewName.
        :param view_uuid: - Identifier for the viewUuid.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6bfc1200edb218e8258a69ae4a1d6a8a895cee091ba00d6fc0856ffc124390e1)
            check_type(argname="argument view_name", value=view_name, expected_type=type_hints["view_name"])
            check_type(argname="argument view_uuid", value=view_uuid, expected_type=type_hints["view_uuid"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "onView", [view_name, view_uuid, account, region, partition]))

    @jsii.member(jsii_name="toAssociateDefaultView")
    def to_associate_default_view(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to set the specified view as the default for this AWS Region in this AWS account.

        Access Level: Write

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_AssociateDefaultView.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toAssociateDefaultView", []))

    @jsii.member(jsii_name="toBatchGetView")
    def to_batch_get_view(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to retrieve details about views that you specify by a list of ARNs.

        Access Level: Read

        Dependent actions:

        - resource-explorer-2:GetView

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_BatchGetView.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toBatchGetView", []))

    @jsii.member(jsii_name="toCreateIndex")
    def to_create_index(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to turn on Resource Explorer in the AWS Region in which you called this operation by creating an index.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_CreateIndex.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toCreateIndex", []))

    @jsii.member(jsii_name="toCreateView")
    def to_create_view(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to create a view that users can query.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_CreateView.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toCreateView", []))

    @jsii.member(jsii_name="toDeleteIndex")
    def to_delete_index(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to turn off Resource Explorer in the specified AWS Region by deleting the index.

        Access Level: Write

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_DeleteIndex.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toDeleteIndex", []))

    @jsii.member(jsii_name="toDeleteView")
    def to_delete_view(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to delete a view.

        Access Level: Write

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_DeleteView.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toDeleteView", []))

    @jsii.member(jsii_name="toDisassociateDefaultView")
    def to_disassociate_default_view(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to remove the default view for the AWS Region in which you call this operation.

        Access Level: Write

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_DisassociateDefaultView.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toDisassociateDefaultView", []))

    @jsii.member(jsii_name="toGetDefaultView")
    def to_get_default_view(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to retrieve the Amazon resource name (ARN) of the view that is the default for the AWS Region in which you call this operation.

        Access Level: Read

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetDefaultView.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toGetDefaultView", []))

    @jsii.member(jsii_name="toGetIndex")
    def to_get_index(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to retrieve information about the index in the AWS Region in which you call this operation.

        Access Level: Read

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetIndex.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toGetIndex", []))

    @jsii.member(jsii_name="toGetView")
    def to_get_view(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to retrieve information about the specified view.

        Access Level: Read

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetView.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toGetView", []))

    @jsii.member(jsii_name="toListIndexes")
    def to_list_indexes(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to list the indexes in all AWS Regions.

        Access Level: List

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListIndexes.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toListIndexes", []))

    @jsii.member(jsii_name="toListSupportedResourceTypes")
    def to_list_supported_resource_types(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to retrieve a list of all resource types currently supported by Resource Explorer.

        Access Level: List

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListSupportedResourceTypes.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toListSupportedResourceTypes", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to list the tags that are attached to the specified resource.

        Access Level: Read

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toListViews")
    def to_list_views(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to list the Amazon resource names (ARNs) of all of the views available in the AWS Region in which you call this operation.

        Access Level: List

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListViews.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toListViews", []))

    @jsii.member(jsii_name="toSearch")
    def to_search(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to search for resources and display details about all resources that match the specified criteria.

        Access Level: Read

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_Search.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toSearch", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to add one or more tag key and value pairs to the specified resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to remove one or more tag key and value pairs from the specified resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateIndexType")
    def to_update_index_type(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to change the type of the index from LOCAL to AGGREGATOR or back.

        Access Level: Write

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_UpdateIndexType.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toUpdateIndexType", []))

    @jsii.member(jsii_name="toUpdateView")
    def to_update_view(self) -> "ResourceExplorer2":
        '''(experimental) Grants permission to modify some of the details of a view.

        Access Level: Write

        https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_UpdateView.html

        :stability: experimental
        '''
        return typing.cast("ResourceExplorer2", jsii.invoke(self, "toUpdateView", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__85ec51b149d06bfe41d58beac6a0bec4039d328b6d2d7119cc9a9ae6d2466698)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b8fb1a7656f6cfbc40ed21b11ae2664dea22463ccbf3154add78635778871a49)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class ResourceGroups(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.ResourceGroups",
):
    '''(experimental) Statement provider for service `resource-groups <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourcegroups.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `resource-groups <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourcegroups.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eb95bd2bc4554839bd13dc5f8c205957caf135452a06648ad1c37b20ea96d52e)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onGroup")
    def on_group(
        self,
        group_name: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "ResourceGroups":
        '''(experimental) Adds a resource of type group to the statement.

        https://docs.aws.amazon.com/ARG/latest/userguide/resource-groups.html

        :param group_name: - Identifier for the groupName.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__143d37c1dcbe5a552a00d407dd532a97845024720015816e443c9f3529e1bb00)
            check_type(argname="argument group_name", value=group_name, expected_type=type_hints["group_name"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("ResourceGroups", jsii.invoke(self, "onGroup", [group_name, account, region, partition]))

    @jsii.member(jsii_name="toCreateGroup")
    def to_create_group(self) -> "ResourceGroups":
        '''(experimental) Grants permission to create a resource group with a specified name, description, and resource query.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_CreateGroup.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toCreateGroup", []))

    @jsii.member(jsii_name="toDeleteGroup")
    def to_delete_group(self) -> "ResourceGroups":
        '''(experimental) Grants permission to delete a specified resource group.

        Access Level: Write

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_DeleteGroup.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toDeleteGroup", []))

    @jsii.member(jsii_name="toGetAccountSettings")
    def to_get_account_settings(self) -> "ResourceGroups":
        '''(experimental) Grants permission to get the current status of optional features in Resource Groups.

        Access Level: Read

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetAccountSettings.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toGetAccountSettings", []))

    @jsii.member(jsii_name="toGetGroup")
    def to_get_group(self) -> "ResourceGroups":
        '''(experimental) Grants permission to get information of a specified resource group.

        Access Level: Read

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetGroup.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toGetGroup", []))

    @jsii.member(jsii_name="toGetGroupConfiguration")
    def to_get_group_configuration(self) -> "ResourceGroups":
        '''(experimental) Grants permission to get the service configuration associated with the specified resource group.

        Access Level: Read

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetGroupConfiguration.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toGetGroupConfiguration", []))

    @jsii.member(jsii_name="toGetGroupQuery")
    def to_get_group_query(self) -> "ResourceGroups":
        '''(experimental) Grants permission to get the query associated with a specified resource group.

        Access Level: Read

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetGroupQuery.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toGetGroupQuery", []))

    @jsii.member(jsii_name="toGetTags")
    def to_get_tags(self) -> "ResourceGroups":
        '''(experimental) Grants permission to get the tags associated with a specified resource group.

        Access Level: Read

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetTags.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toGetTags", []))

    @jsii.member(jsii_name="toGroupResources")
    def to_group_resources(self) -> "ResourceGroups":
        '''(experimental) Grants permission to add the specified resources to the specified group.

        Access Level: Write

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_GroupResources.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toGroupResources", []))

    @jsii.member(jsii_name="toListGroupResources")
    def to_list_group_resources(self) -> "ResourceGroups":
        '''(experimental) Grants permission to list the resources that are members of a specified resource group.

        Access Level: List

        Dependent actions:

        - cloudformation:DescribeStacks
        - cloudformation:ListStackResources
        - tag:GetResources

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_ListGroupResources.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toListGroupResources", []))

    @jsii.member(jsii_name="toListGroups")
    def to_list_groups(self) -> "ResourceGroups":
        '''(experimental) Grants permission to list all resource groups in your account.

        Access Level: List

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_ListGroups.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toListGroups", []))

    @jsii.member(jsii_name="toPutGroupConfiguration")
    def to_put_group_configuration(self) -> "ResourceGroups":
        '''(experimental) Grants permission to put the service configuration associated with the specified resource group.

        Access Level: Write

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_PutGroupConfiguration.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toPutGroupConfiguration", []))

    @jsii.member(jsii_name="toPutGroupPolicy")
    def to_put_group_policy(self) -> "ResourceGroups":
        '''(experimental) Grants permission to add a resource-based policy for the specified group.

        Access Level: Write

        https://docs.aws.amazon.com/license-manager/latest/userguide/management-role.html#service-linked-role-permissions-management-role

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toPutGroupPolicy", []))

    @jsii.member(jsii_name="toSearchResources")
    def to_search_resources(self) -> "ResourceGroups":
        '''(experimental) Grants permission to search for AWS resources matching the given query.

        Access Level: List

        Dependent actions:

        - cloudformation:DescribeStacks
        - cloudformation:ListStackResources
        - tag:GetResources

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_SearchResources.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toSearchResources", []))

    @jsii.member(jsii_name="toTag")
    def to_tag(self) -> "ResourceGroups":
        '''(experimental) Grants permission to tag a specified resource group.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_Tag.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toTag", []))

    @jsii.member(jsii_name="toUngroupResources")
    def to_ungroup_resources(self) -> "ResourceGroups":
        '''(experimental) Grants permission to remove the specified resources from the specified group.

        Access Level: Write

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_UngroupResources.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toUngroupResources", []))

    @jsii.member(jsii_name="toUntag")
    def to_untag(self) -> "ResourceGroups":
        '''(experimental) Grants permission to remove tags associated with a specified resource group.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_Untag.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toUntag", []))

    @jsii.member(jsii_name="toUpdateAccountSettings")
    def to_update_account_settings(self) -> "ResourceGroups":
        '''(experimental) Grants permission to update optional features in Resource Groups.

        Access Level: Write

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_UpdateAccountSettings.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toUpdateAccountSettings", []))

    @jsii.member(jsii_name="toUpdateGroup")
    def to_update_group(self) -> "ResourceGroups":
        '''(experimental) Grants permission to update a specified resource group.

        Access Level: Write

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_UpdateGroup.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toUpdateGroup", []))

    @jsii.member(jsii_name="toUpdateGroupQuery")
    def to_update_group_query(self) -> "ResourceGroups":
        '''(experimental) Grants permission to update the query associated with a specified resource group.

        Access Level: Write

        https://docs.aws.amazon.com/ARG/latest/APIReference/API_UpdateGroupQuery.html

        :stability: experimental
        '''
        return typing.cast("ResourceGroups", jsii.invoke(self, "toUpdateGroupQuery", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a38521a1796ad59d2e01361aad1c5da5a47f159cb8af3087d0bb1e5ec7c7f6b3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af936c72ce1c802281b6483144d22f78336eaf2eef03dd269349aa655a81650b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Rhelkb(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Rhelkb"):
    '''(experimental) Statement provider for service `rhelkb <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrhelknowledgebaseportal.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `rhelkb <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrhelknowledgebaseportal.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d599ed12ef977cba5b19170843b2c0fdba8b93d6c9a5f1e60ac4020947bcbd09)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="toGetRhelURL")
    def to_get_rhel_url(self) -> "Rhelkb":
        '''(experimental) Grants permission to access the Red Hat Knowledgebase portal.

        Access Level: Read

        https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-rhel.html

        :stability: experimental
        '''
        return typing.cast("Rhelkb", jsii.invoke(self, "toGetRhelURL", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b9913f702c2864624aa05b1faf1eda08ccd6c3c915ce35f41ca5563f8a30a45b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6ecdcc4695e39179b9396d9169f67178cbdefc09de4bc90aef77bd33ab0eed3b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Robomaker(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Robomaker",
):
    '''(experimental) Statement provider for service `robomaker <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsrobomaker.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `robomaker <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsrobomaker.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf1058d56947ac68fc710c2ca40cabff6e03ba8165b9f9c015a863e939dde123)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onDeploymentFleet")
    def on_deployment_fleet(
        self,
        fleet_name: builtins.str,
        created_on_epoch: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type deploymentFleet to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/managing-simulation-applications.html

        :param fleet_name: - Identifier for the fleetName.
        :param created_on_epoch: - Identifier for the createdOnEpoch.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8481f45070fbdba79c5e44e02381ec5b195e683c6f82b3ee6bbd996c79b58249)
            check_type(argname="argument fleet_name", value=fleet_name, expected_type=type_hints["fleet_name"])
            check_type(argname="argument created_on_epoch", value=created_on_epoch, expected_type=type_hints["created_on_epoch"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onDeploymentFleet", [fleet_name, created_on_epoch, account, region, partition]))

    @jsii.member(jsii_name="onDeploymentJob")
    def on_deployment_job(
        self,
        deployment_job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type deploymentJob to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/deployment.html

        :param deployment_job_id: - Identifier for the deploymentJobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c25ea7be575688f4882a53c7bd1d20f3b9b8cddf834758877ff8de38b11c4613)
            check_type(argname="argument deployment_job_id", value=deployment_job_id, expected_type=type_hints["deployment_job_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onDeploymentJob", [deployment_job_id, account, region, partition]))

    @jsii.member(jsii_name="onRobot")
    def on_robot(
        self,
        robot_name: builtins.str,
        created_on_epoch: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type robot to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html

        :param robot_name: - Identifier for the robotName.
        :param created_on_epoch: - Identifier for the createdOnEpoch.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e51238d4fbd0404910189633a75759645337ccb1d3273899203d2b6ce1591678)
            check_type(argname="argument robot_name", value=robot_name, expected_type=type_hints["robot_name"])
            check_type(argname="argument created_on_epoch", value=created_on_epoch, expected_type=type_hints["created_on_epoch"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onRobot", [robot_name, created_on_epoch, account, region, partition]))

    @jsii.member(jsii_name="onRobotApplication")
    def on_robot_application(
        self,
        application_name: builtins.str,
        created_on_epoch: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type robotApplication to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/managing-robot-applications.html

        :param application_name: - Identifier for the applicationName.
        :param created_on_epoch: - Identifier for the createdOnEpoch.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b7397c9824ba7cc60a78786c6257c020393da26718cb030b68688167b53de284)
            check_type(argname="argument application_name", value=application_name, expected_type=type_hints["application_name"])
            check_type(argname="argument created_on_epoch", value=created_on_epoch, expected_type=type_hints["created_on_epoch"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onRobotApplication", [application_name, created_on_epoch, account, region, partition]))

    @jsii.member(jsii_name="onSimulationApplication")
    def on_simulation_application(
        self,
        application_name: builtins.str,
        created_on_epoch: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type simulationApplication to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/managing-simulation-applications.html

        :param application_name: - Identifier for the applicationName.
        :param created_on_epoch: - Identifier for the createdOnEpoch.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8f944a56aa75867cafcfad9ad1beb4c7c62e0397055cb437ef3dfa513b4e36fb)
            check_type(argname="argument application_name", value=application_name, expected_type=type_hints["application_name"])
            check_type(argname="argument created_on_epoch", value=created_on_epoch, expected_type=type_hints["created_on_epoch"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onSimulationApplication", [application_name, created_on_epoch, account, region, partition]))

    @jsii.member(jsii_name="onSimulationJob")
    def on_simulation_job(
        self,
        simulation_job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type simulationJob to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/simulation.html

        :param simulation_job_id: - Identifier for the simulationJobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ad1081b9de391d348b5ef7df35936b550d00fb4af35f63c772a778a13541762f)
            check_type(argname="argument simulation_job_id", value=simulation_job_id, expected_type=type_hints["simulation_job_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onSimulationJob", [simulation_job_id, account, region, partition]))

    @jsii.member(jsii_name="onSimulationJobBatch")
    def on_simulation_job_batch(
        self,
        simulation_job_batch_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type simulationJobBatch to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/simulation-job-batch.html

        :param simulation_job_batch_id: - Identifier for the simulationJobBatchId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bfea4910abd64c9df238843d1d530082dc0a1ee8399aa03de7f43a197ea1866e)
            check_type(argname="argument simulation_job_batch_id", value=simulation_job_batch_id, expected_type=type_hints["simulation_job_batch_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onSimulationJobBatch", [simulation_job_batch_id, account, region, partition]))

    @jsii.member(jsii_name="onWorld")
    def on_world(
        self,
        world_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type world to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-generated-worlds.html

        :param world_id: - Identifier for the worldId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f18b9b21d2a2bee4a33e15086beda9357b3d03b8c88f966a4fd36181f804c91f)
            check_type(argname="argument world_id", value=world_id, expected_type=type_hints["world_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onWorld", [world_id, account, region, partition]))

    @jsii.member(jsii_name="onWorldExportJob")
    def on_world_export_job(
        self,
        world_export_job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type worldExportJob to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-export-jobs.html

        :param world_export_job_id: - Identifier for the worldExportJobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__933769643f38a7925204651030688b44902c0043d40a7ed3e02643bdb4ec6ea0)
            check_type(argname="argument world_export_job_id", value=world_export_job_id, expected_type=type_hints["world_export_job_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onWorldExportJob", [world_export_job_id, account, region, partition]))

    @jsii.member(jsii_name="onWorldGenerationJob")
    def on_world_generation_job(
        self,
        world_generation_job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type worldGenerationJob to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-generation-jobs.html

        :param world_generation_job_id: - Identifier for the worldGenerationJobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66a72473fa73ced243aa2aac8512c5301ce7727630314b8a73cda487b75cabb9)
            check_type(argname="argument world_generation_job_id", value=world_generation_job_id, expected_type=type_hints["world_generation_job_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onWorldGenerationJob", [world_generation_job_id, account, region, partition]))

    @jsii.member(jsii_name="onWorldTemplate")
    def on_world_template(
        self,
        world_template_job_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Robomaker":
        '''(experimental) Adds a resource of type worldTemplate to the statement.

        https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-simworld-templates.html

        :param world_template_job_id: - Identifier for the worldTemplateJobId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f392968549e746a1b2968902af0708f3f6d4114bea510d0b0445ad4a85f86bde)
            check_type(argname="argument world_template_job_id", value=world_template_job_id, expected_type=type_hints["world_template_job_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Robomaker", jsii.invoke(self, "onWorldTemplate", [world_template_job_id, account, region, partition]))

    @jsii.member(jsii_name="toBatchDeleteWorlds")
    def to_batch_delete_worlds(self) -> "Robomaker":
        '''(experimental) Delete one or more worlds in a batch operation.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_BatchDeleteWorlds.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toBatchDeleteWorlds", []))

    @jsii.member(jsii_name="toBatchDescribeSimulationJob")
    def to_batch_describe_simulation_job(self) -> "Robomaker":
        '''(experimental) Describe multiple simulation jobs.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_BatchDescribeSimulationJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toBatchDescribeSimulationJob", []))

    @jsii.member(jsii_name="toCancelDeploymentJob")
    def to_cancel_deployment_job(self) -> "Robomaker":
        '''(experimental) Cancel a deployment job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelDeploymentJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCancelDeploymentJob", []))

    @jsii.member(jsii_name="toCancelSimulationJob")
    def to_cancel_simulation_job(self) -> "Robomaker":
        '''(experimental) Cancel a simulation job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelSimulationJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCancelSimulationJob", []))

    @jsii.member(jsii_name="toCancelSimulationJobBatch")
    def to_cancel_simulation_job_batch(self) -> "Robomaker":
        '''(experimental) Cancel a simulation job batch.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelSimulationJobBatch.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCancelSimulationJobBatch", []))

    @jsii.member(jsii_name="toCancelWorldExportJob")
    def to_cancel_world_export_job(self) -> "Robomaker":
        '''(experimental) Cancel a world export job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelWorldExportJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCancelWorldExportJob", []))

    @jsii.member(jsii_name="toCancelWorldGenerationJob")
    def to_cancel_world_generation_job(self) -> "Robomaker":
        '''(experimental) Cancel a world generation job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelWorldGenerationJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCancelWorldGenerationJob", []))

    @jsii.member(jsii_name="toCreateDeploymentJob")
    def to_create_deployment_job(self) -> "Robomaker":
        '''(experimental) Create a deployment job.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        Dependent actions:

        - iam:CreateServiceLinkedRole

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateDeploymentJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateDeploymentJob", []))

    @jsii.member(jsii_name="toCreateFleet")
    def to_create_fleet(self) -> "Robomaker":
        '''(experimental) Create a deployment fleet that represents a logical group of robots running the same robot application.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateFleet.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateFleet", []))

    @jsii.member(jsii_name="toCreateRobot")
    def to_create_robot(self) -> "Robomaker":
        '''(experimental) Create a robot that can be registered to a fleet.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        Dependent actions:

        - iam:CreateServiceLinkedRole

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateRobot.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateRobot", []))

    @jsii.member(jsii_name="toCreateRobotApplication")
    def to_create_robot_application(self) -> "Robomaker":
        '''(experimental) Create a robot application.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateRobotApplication.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateRobotApplication", []))

    @jsii.member(jsii_name="toCreateRobotApplicationVersion")
    def to_create_robot_application_version(self) -> "Robomaker":
        '''(experimental) Create a snapshot of a robot application.

        Access Level: Write

        Dependent actions:

        - s3:GetObject

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateRobotApplicationVersion.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateRobotApplicationVersion", []))

    @jsii.member(jsii_name="toCreateSimulationApplication")
    def to_create_simulation_application(self) -> "Robomaker":
        '''(experimental) Create a simulation application.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateSimulationApplication.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateSimulationApplication", []))

    @jsii.member(jsii_name="toCreateSimulationApplicationVersion")
    def to_create_simulation_application_version(self) -> "Robomaker":
        '''(experimental) Create a snapshot of a simulation application.

        Access Level: Write

        Dependent actions:

        - s3:GetObject

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateSimulationApplicationVersion.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateSimulationApplicationVersion", []))

    @jsii.member(jsii_name="toCreateSimulationJob")
    def to_create_simulation_job(self) -> "Robomaker":
        '''(experimental) Create a simulation job.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        Dependent actions:

        - iam:CreateServiceLinkedRole

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateSimulationJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateSimulationJob", []))

    @jsii.member(jsii_name="toCreateWorldExportJob")
    def to_create_world_export_job(self) -> "Robomaker":
        '''(experimental) Create a world export job.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateWorldExportJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateWorldExportJob", []))

    @jsii.member(jsii_name="toCreateWorldGenerationJob")
    def to_create_world_generation_job(self) -> "Robomaker":
        '''(experimental) Create a world generation job.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateWorldGenerationJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateWorldGenerationJob", []))

    @jsii.member(jsii_name="toCreateWorldTemplate")
    def to_create_world_template(self) -> "Robomaker":
        '''(experimental) Create a world template.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateWorldTemplate.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toCreateWorldTemplate", []))

    @jsii.member(jsii_name="toDeleteFleet")
    def to_delete_fleet(self) -> "Robomaker":
        '''(experimental) Delete a deployment fleet.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteFleet.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDeleteFleet", []))

    @jsii.member(jsii_name="toDeleteRobot")
    def to_delete_robot(self) -> "Robomaker":
        '''(experimental) Delete a robot.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteRobot.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDeleteRobot", []))

    @jsii.member(jsii_name="toDeleteRobotApplication")
    def to_delete_robot_application(self) -> "Robomaker":
        '''(experimental) Delete a robot application.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteRobotApplication.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDeleteRobotApplication", []))

    @jsii.member(jsii_name="toDeleteSimulationApplication")
    def to_delete_simulation_application(self) -> "Robomaker":
        '''(experimental) Delete a simulation application.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteSimulationApplication.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDeleteSimulationApplication", []))

    @jsii.member(jsii_name="toDeleteWorldTemplate")
    def to_delete_world_template(self) -> "Robomaker":
        '''(experimental) Delete a world template.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteWorldTemplate.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDeleteWorldTemplate", []))

    @jsii.member(jsii_name="toDeregisterRobot")
    def to_deregister_robot(self) -> "Robomaker":
        '''(experimental) Deregister a robot from a fleet.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DeregisterRobot.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDeregisterRobot", []))

    @jsii.member(jsii_name="toDescribeDeploymentJob")
    def to_describe_deployment_job(self) -> "Robomaker":
        '''(experimental) Describe a deployment job.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeDeploymentJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeDeploymentJob", []))

    @jsii.member(jsii_name="toDescribeFleet")
    def to_describe_fleet(self) -> "Robomaker":
        '''(experimental) Describe a deployment fleet.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeFleet.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeFleet", []))

    @jsii.member(jsii_name="toDescribeRobot")
    def to_describe_robot(self) -> "Robomaker":
        '''(experimental) Describe a robot.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeRobot.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeRobot", []))

    @jsii.member(jsii_name="toDescribeRobotApplication")
    def to_describe_robot_application(self) -> "Robomaker":
        '''(experimental) Describe a robot application.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeRobotApplication.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeRobotApplication", []))

    @jsii.member(jsii_name="toDescribeSimulationApplication")
    def to_describe_simulation_application(self) -> "Robomaker":
        '''(experimental) Describe a simulation application.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeSimulationApplication.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeSimulationApplication", []))

    @jsii.member(jsii_name="toDescribeSimulationJob")
    def to_describe_simulation_job(self) -> "Robomaker":
        '''(experimental) Describe a simulation job.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeSimulationJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeSimulationJob", []))

    @jsii.member(jsii_name="toDescribeSimulationJobBatch")
    def to_describe_simulation_job_batch(self) -> "Robomaker":
        '''(experimental) Describe a simulation job batch.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeSimulationJobBatch.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeSimulationJobBatch", []))

    @jsii.member(jsii_name="toDescribeWorld")
    def to_describe_world(self) -> "Robomaker":
        '''(experimental) Describe a world.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorld.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeWorld", []))

    @jsii.member(jsii_name="toDescribeWorldExportJob")
    def to_describe_world_export_job(self) -> "Robomaker":
        '''(experimental) Describe a world export job.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorldExportJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeWorldExportJob", []))

    @jsii.member(jsii_name="toDescribeWorldGenerationJob")
    def to_describe_world_generation_job(self) -> "Robomaker":
        '''(experimental) Describe a world generation job.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorldGenerationJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeWorldGenerationJob", []))

    @jsii.member(jsii_name="toDescribeWorldTemplate")
    def to_describe_world_template(self) -> "Robomaker":
        '''(experimental) Describe a world template.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorldTemplate.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toDescribeWorldTemplate", []))

    @jsii.member(jsii_name="toGetWorldTemplateBody")
    def to_get_world_template_body(self) -> "Robomaker":
        '''(experimental) Get the body of a world template.

        Access Level: Read

        https://docs.aws.amazon.com/robomaker/latest/dg/API_GetWorldTemplateBody.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toGetWorldTemplateBody", []))

    @jsii.member(jsii_name="toListDeploymentJobs")
    def to_list_deployment_jobs(self) -> "Robomaker":
        '''(experimental) List deployment jobs.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListDeploymentJobs.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListDeploymentJobs", []))

    @jsii.member(jsii_name="toListFleets")
    def to_list_fleets(self) -> "Robomaker":
        '''(experimental) List fleets.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListFleets.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListFleets", []))

    @jsii.member(jsii_name="toListRobotApplications")
    def to_list_robot_applications(self) -> "Robomaker":
        '''(experimental) List robot applications.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListRobotApplications.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListRobotApplications", []))

    @jsii.member(jsii_name="toListRobots")
    def to_list_robots(self) -> "Robomaker":
        '''(experimental) List robots.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListRobots.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListRobots", []))

    @jsii.member(jsii_name="toListSimulationApplications")
    def to_list_simulation_applications(self) -> "Robomaker":
        '''(experimental) List simulation applications.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListSimulationApplications.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListSimulationApplications", []))

    @jsii.member(jsii_name="toListSimulationJobBatches")
    def to_list_simulation_job_batches(self) -> "Robomaker":
        '''(experimental) List simulation job batches.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListSimulationJobBatches.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListSimulationJobBatches", []))

    @jsii.member(jsii_name="toListSimulationJobs")
    def to_list_simulation_jobs(self) -> "Robomaker":
        '''(experimental) List simulation jobs.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListSimulationJobs.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListSimulationJobs", []))

    @jsii.member(jsii_name="toListSupportedAvailabilityZones")
    def to_list_supported_availability_zones(self) -> "Robomaker":
        '''(experimental) Lists supported availability zones.

        Access Level: List

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListSupportedAvailabilityZones", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Robomaker":
        '''(experimental) List tags for a RoboMaker resource.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toListWorldExportJobs")
    def to_list_world_export_jobs(self) -> "Robomaker":
        '''(experimental) List world export jobs.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorldExportJobs.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListWorldExportJobs", []))

    @jsii.member(jsii_name="toListWorldGenerationJobs")
    def to_list_world_generation_jobs(self) -> "Robomaker":
        '''(experimental) List world generation jobs.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorldGenerationJobs.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListWorldGenerationJobs", []))

    @jsii.member(jsii_name="toListWorlds")
    def to_list_worlds(self) -> "Robomaker":
        '''(experimental) List worlds.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorlds.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListWorlds", []))

    @jsii.member(jsii_name="toListWorldTemplates")
    def to_list_world_templates(self) -> "Robomaker":
        '''(experimental) List world templates.

        Access Level: List

        https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorldTemplates.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toListWorldTemplates", []))

    @jsii.member(jsii_name="toRegisterRobot")
    def to_register_robot(self) -> "Robomaker":
        '''(experimental) Register a robot to a fleet.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_RegisterRobot.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toRegisterRobot", []))

    @jsii.member(jsii_name="toRestartSimulationJob")
    def to_restart_simulation_job(self) -> "Robomaker":
        '''(experimental) Restart a running simulation job.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_RestartSimulationJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toRestartSimulationJob", []))

    @jsii.member(jsii_name="toStartSimulationJobBatch")
    def to_start_simulation_job_batch(self) -> "Robomaker":
        '''(experimental) Create a simulation job batch.

        Access Level: Write

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        Dependent actions:

        - iam:CreateServiceLinkedRole

        https://docs.aws.amazon.com/robomaker/latest/dg/API_StartSimulationJobBatch.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toStartSimulationJobBatch", []))

    @jsii.member(jsii_name="toSyncDeploymentJob")
    def to_sync_deployment_job(self) -> "Robomaker":
        '''(experimental) Ensures the most recently deployed robot application is deployed to all robots in the fleet.

        Access Level: Write

        Dependent actions:

        - iam:CreateServiceLinkedRole

        https://docs.aws.amazon.com/robomaker/latest/dg/API_SyncDeploymentJob.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toSyncDeploymentJob", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Robomaker":
        '''(experimental) Add tags to a RoboMaker resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()
        - .ifAwsRequestTag()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Robomaker":
        '''(experimental) Remove tags from a RoboMaker resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/robomaker/latest/dg/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateRobotApplication")
    def to_update_robot_application(self) -> "Robomaker":
        '''(experimental) Update a robot application.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_UpdateRobotApplication.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toUpdateRobotApplication", []))

    @jsii.member(jsii_name="toUpdateRobotDeployment")
    def to_update_robot_deployment(self) -> "Robomaker":
        '''(experimental) Report the deployment status for an individual robot.

        Access Level: Write

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toUpdateRobotDeployment", []))

    @jsii.member(jsii_name="toUpdateSimulationApplication")
    def to_update_simulation_application(self) -> "Robomaker":
        '''(experimental) Update a simulation application.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_UpdateSimulationApplication.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toUpdateSimulationApplication", []))

    @jsii.member(jsii_name="toUpdateWorldTemplate")
    def to_update_world_template(self) -> "Robomaker":
        '''(experimental) Update a world template.

        Access Level: Write

        https://docs.aws.amazon.com/robomaker/latest/dg/API_UpdateWorldTemplate.html

        :stability: experimental
        '''
        return typing.cast("Robomaker", jsii.invoke(self, "toUpdateWorldTemplate", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0df591d20b902eca9270c35c3e3492cbdcf6cfb886c1afccb7b8bdbf1972c5a4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b13eaccbfd240f8766527896d141d580d13c848cb92359015c2ea10a9d45b23)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Rolesanywhere(
    PolicyStatement,
    metaclass=jsii.JSIIMeta,
    jsii_type="iam-floyd.Rolesanywhere",
):
    '''(experimental) Statement provider for service `rolesanywhere <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentityandaccessmanagementrolesanywhere.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Statement provider for service `rolesanywhere <https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentityandaccessmanagementrolesanywhere.html>`_.

        :param sid: `SID <https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html>`_ of the statement.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__228b7755abbe8814f0422fa036b81606c8b737cf27d03dc412a30bad5c70ff1e)
            check_type(argname="argument sid", value=sid, expected_type=type_hints["sid"])
        jsii.create(self.__class__, self, [sid])

    @jsii.member(jsii_name="onCrl")
    def on_crl(
        self,
        crl_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rolesanywhere":
        '''(experimental) Adds a resource of type crl to the statement.

        https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user

        :param crl_id: - Identifier for the crlId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__10004a5c8a47b49bc6896b25e7267860323a07b57b494ccfc559a29d18b037f0)
            check_type(argname="argument crl_id", value=crl_id, expected_type=type_hints["crl_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rolesanywhere", jsii.invoke(self, "onCrl", [crl_id, account, region, partition]))

    @jsii.member(jsii_name="onProfile")
    def on_profile(
        self,
        profile_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rolesanywhere":
        '''(experimental) Adds a resource of type profile to the statement.

        https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user

        :param profile_id: - Identifier for the profileId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b972d321c1ea6202c4b5b586b49cef339aa26c293f15ac7faca7b99648616e92)
            check_type(argname="argument profile_id", value=profile_id, expected_type=type_hints["profile_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rolesanywhere", jsii.invoke(self, "onProfile", [profile_id, account, region, partition]))

    @jsii.member(jsii_name="onSubject")
    def on_subject(
        self,
        subject_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rolesanywhere":
        '''(experimental) Adds a resource of type subject to the statement.

        https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user

        :param subject_id: - Identifier for the subjectId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f36d64bec08d13a45240e2ff189f374bb021dc4239f0fe4332f2980afda15363)
            check_type(argname="argument subject_id", value=subject_id, expected_type=type_hints["subject_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rolesanywhere", jsii.invoke(self, "onSubject", [subject_id, account, region, partition]))

    @jsii.member(jsii_name="onTrustAnchor")
    def on_trust_anchor(
        self,
        trust_anchor_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        partition: typing.Optional[builtins.str] = None,
    ) -> "Rolesanywhere":
        '''(experimental) Adds a resource of type trust-anchor to the statement.

        https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user

        :param trust_anchor_id: - Identifier for the trustAnchorId.
        :param account: - Account of the resource; defaults to empty string: all accounts.
        :param region: - Region of the resource; defaults to empty string: all regions.
        :param partition: - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to ``aws``, unless using the CDK, where the default is the current Stack's partition. Possible conditions: - .ifAwsResourceTag()

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4fb1cc95f0219f5ef09527efca2bfd32eb831b58efece91ef8dc6efd43e72b12)
            check_type(argname="argument trust_anchor_id", value=trust_anchor_id, expected_type=type_hints["trust_anchor_id"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        return typing.cast("Rolesanywhere", jsii.invoke(self, "onTrustAnchor", [trust_anchor_id, account, region, partition]))

    @jsii.member(jsii_name="toCreateProfile")
    def to_create_profile(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to create a profile.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateProfile.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toCreateProfile", []))

    @jsii.member(jsii_name="toCreateTrustAnchor")
    def to_create_trust_anchor(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to create a trust anchor.

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateTrustAnchor.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toCreateTrustAnchor", []))

    @jsii.member(jsii_name="toDeleteCrl")
    def to_delete_crl(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to delete a certificate revocation list (crl).

        Access Level: Write

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteCrl.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toDeleteCrl", []))

    @jsii.member(jsii_name="toDeleteProfile")
    def to_delete_profile(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to delete a profile.

        Access Level: Write

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteProfile.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toDeleteProfile", []))

    @jsii.member(jsii_name="toDeleteTrustAnchor")
    def to_delete_trust_anchor(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to delete a trust anchor.

        Access Level: Write

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteTrustAnchor.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toDeleteTrustAnchor", []))

    @jsii.member(jsii_name="toDisableCrl")
    def to_disable_crl(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to disable a certificate revocation list (crl).

        Access Level: Write

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableCrl.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toDisableCrl", []))

    @jsii.member(jsii_name="toDisableProfile")
    def to_disable_profile(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to disable a profile.

        Access Level: Write

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableProfile.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toDisableProfile", []))

    @jsii.member(jsii_name="toDisableTrustAnchor")
    def to_disable_trust_anchor(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to disable a trust anchor.

        Access Level: Write

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableTrustAnchor.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toDisableTrustAnchor", []))

    @jsii.member(jsii_name="toEnableCrl")
    def to_enable_crl(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to enable a certificate revocation list (crl).

        Access Level: Write

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableCrl.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toEnableCrl", []))

    @jsii.member(jsii_name="toEnableProfile")
    def to_enable_profile(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to enable a profile.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableProfile.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toEnableProfile", []))

    @jsii.member(jsii_name="toEnableTrustAnchor")
    def to_enable_trust_anchor(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to enable a trust anchor.

        Access Level: Write

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableTrustAnchor.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toEnableTrustAnchor", []))

    @jsii.member(jsii_name="toGetCrl")
    def to_get_crl(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to get a certificate revocation list (crl).

        Access Level: Read

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetCrl.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toGetCrl", []))

    @jsii.member(jsii_name="toGetProfile")
    def to_get_profile(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to get a profile.

        Access Level: Read

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetProfile.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toGetProfile", []))

    @jsii.member(jsii_name="toGetSubject")
    def to_get_subject(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to get a subject.

        Access Level: Read

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetSubject.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toGetSubject", []))

    @jsii.member(jsii_name="toGetTrustAnchor")
    def to_get_trust_anchor(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to get a trust anchor.

        Access Level: Read

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetTrustAnchor.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toGetTrustAnchor", []))

    @jsii.member(jsii_name="toImportCrl")
    def to_import_crl(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to import a certificate revocation list (crl).

        Access Level: Write

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ImportCrl.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toImportCrl", []))

    @jsii.member(jsii_name="toListCrls")
    def to_list_crls(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to list certificate revocation lists (crls).

        Access Level: List

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListCrls.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toListCrls", []))

    @jsii.member(jsii_name="toListProfiles")
    def to_list_profiles(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to list profiles.

        Access Level: List

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListProfiles.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toListProfiles", []))

    @jsii.member(jsii_name="toListSubjects")
    def to_list_subjects(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to list subjects.

        Access Level: List

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListSubjects.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toListSubjects", []))

    @jsii.member(jsii_name="toListTagsForResource")
    def to_list_tags_for_resource(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to list tags for a resource.

        Access Level: List

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListTagsForResource.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toListTagsForResource", []))

    @jsii.member(jsii_name="toListTrustAnchors")
    def to_list_trust_anchors(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to list trust anchors.

        Access Level: List

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListTrustAnchors.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toListTrustAnchors", []))

    @jsii.member(jsii_name="toTagResource")
    def to_tag_resource(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to tag a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_TagResource.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toTagResource", []))

    @jsii.member(jsii_name="toUntagResource")
    def to_untag_resource(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to untag a resource.

        Access Level: Tagging

        Possible conditions:

        - .ifAwsRequestTag()
        - .ifAwsTagKeys()

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UntagResource.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toUntagResource", []))

    @jsii.member(jsii_name="toUpdateCrl")
    def to_update_crl(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to update a certificate revocation list (crl).

        Access Level: Write

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateCrl.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toUpdateCrl", []))

    @jsii.member(jsii_name="toUpdateProfile")
    def to_update_profile(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to update a profile.

        Access Level: Write

        Dependent actions:

        - iam:PassRole

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateProfile.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toUpdateProfile", []))

    @jsii.member(jsii_name="toUpdateTrustAnchor")
    def to_update_trust_anchor(self) -> "Rolesanywhere":
        '''(experimental) Grants permission to update a trust anchor.

        Access Level: Write

        https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateTrustAnchor.html

        :stability: experimental
        '''
        return typing.cast("Rolesanywhere", jsii.invoke(self, "toUpdateTrustAnchor", []))

    @builtins.property
    @jsii.member(jsii_name="accessLevelList")
    def _access_level_list(self) -> AccessLevelList:
        '''
        :stability: experimental
        '''
        return typing.cast(AccessLevelList, jsii.get(self, "accessLevelList"))

    @_access_level_list.setter
    def _access_level_list(self, value: AccessLevelList) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8b95b1d0c6c28a035b1a422f1f622d836210b1cb7edf4b48a49ae810f9d94076)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessLevelList", value)

    @builtins.property
    @jsii.member(jsii_name="servicePrefix")
    def service_prefix(self) -> builtins.str:
        '''(experimental) Holds the prefix of the service actions, e.g. ``ec2``.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "servicePrefix"))

    @service_prefix.setter
    def service_prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29c31406859440f572680e18a253e54ba8e606204aca8d2f4d554c08e72af32c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "servicePrefix", value)


class Route53(PolicyStatement, metaclass=jsii.JSIIMeta, jsii_type="iam-floyd.Route53"):
    '''(experimental) Statement provider for service `route53 <https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53.html>`_.

    :stability: experimental
    '''

    def __init__(self, sid: typing.Optional[builtins.str] = None) -> None:
        '''(exp