# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAwsPrivatelinkResult',
    'AwaitableGetAwsPrivatelinkResult',
    'get_aws_privatelink',
]

@pulumi.output_type
class GetAwsPrivatelinkResult:
    """
    A collection of values returned by getAwsPrivatelink.
    """
    def __init__(__self__, aws_service_id=None, aws_service_name=None, id=None, principals=None, project=None, service_name=None):
        if aws_service_id and not isinstance(aws_service_id, str):
            raise TypeError("Expected argument 'aws_service_id' to be a str")
        pulumi.set(__self__, "aws_service_id", aws_service_id)
        if aws_service_name and not isinstance(aws_service_name, str):
            raise TypeError("Expected argument 'aws_service_name' to be a str")
        pulumi.set(__self__, "aws_service_name", aws_service_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if principals and not isinstance(principals, list):
            raise TypeError("Expected argument 'principals' to be a list")
        pulumi.set(__self__, "principals", principals)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="awsServiceId")
    def aws_service_id(self) -> str:
        """
        AWS service ID.
        """
        return pulumi.get(self, "aws_service_id")

    @property
    @pulumi.getter(name="awsServiceName")
    def aws_service_name(self) -> str:
        """
        AWS service name.
        """
        return pulumi.get(self, "aws_service_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def principals(self) -> Optional[Sequence[str]]:
        """
        list of allowed principals
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")


class AwaitableGetAwsPrivatelinkResult(GetAwsPrivatelinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsPrivatelinkResult(
            aws_service_id=self.aws_service_id,
            aws_service_name=self.aws_service_name,
            id=self.id,
            principals=self.principals,
            project=self.project,
            service_name=self.service_name)


def get_aws_privatelink(aws_service_id: Optional[str] = None,
                        aws_service_name: Optional[str] = None,
                        principals: Optional[Sequence[str]] = None,
                        project: Optional[str] = None,
                        service_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsPrivatelinkResult:
    """
    ## # AWS Privatelink Data Source

    The AWS Privatelink resource allows the creation and management of Aiven AWS Privatelink for a services.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    foo = aiven.get_aws_privatelink(project=data["aiven_project"]["foo"]["project"],
        service_name=aiven_kafka["bar"]["service_name"])
    ```


    :param str aws_service_id: AWS service ID.
    :param str aws_service_name: AWS service name.
    :param Sequence[str] principals: list of allowed principals
    :param str project: identifies the project the service belongs to. To set up proper dependency between the project
           and the service, refer to the project as shown in the above example. Project cannot be changed later without
           destroying and re-creating the service.
    :param str service_name: specifies the actual name of the service. The name cannot be changed later without
           destroying and re-creating the service so name should be picked based on intended service usage rather than current
           attributes.
    """
    __args__ = dict()
    __args__['awsServiceId'] = aws_service_id
    __args__['awsServiceName'] = aws_service_name
    __args__['principals'] = principals
    __args__['project'] = project
    __args__['serviceName'] = service_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getAwsPrivatelink:getAwsPrivatelink', __args__, opts=opts, typ=GetAwsPrivatelinkResult).value

    return AwaitableGetAwsPrivatelinkResult(
        aws_service_id=__ret__.aws_service_id,
        aws_service_name=__ret__.aws_service_name,
        id=__ret__.id,
        principals=__ret__.principals,
        project=__ret__.project,
        service_name=__ret__.service_name)
