# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, account_id=None, available_credits=None, billing_address=None, billing_currency=None, billing_emails=None, billing_extra_text=None, billing_group=None, ca_cert=None, card_id=None, copy_from_project=None, country=None, country_code=None, default_cloud=None, estimated_balance=None, id=None, payment_method=None, project=None, technical_emails=None, use_source_project_billing_group=None, vat_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if available_credits and not isinstance(available_credits, str):
            raise TypeError("Expected argument 'available_credits' to be a str")
        pulumi.set(__self__, "available_credits", available_credits)
        if billing_address and not isinstance(billing_address, str):
            raise TypeError("Expected argument 'billing_address' to be a str")
        pulumi.set(__self__, "billing_address", billing_address)
        if billing_currency and not isinstance(billing_currency, str):
            raise TypeError("Expected argument 'billing_currency' to be a str")
        pulumi.set(__self__, "billing_currency", billing_currency)
        if billing_emails and not isinstance(billing_emails, list):
            raise TypeError("Expected argument 'billing_emails' to be a list")
        pulumi.set(__self__, "billing_emails", billing_emails)
        if billing_extra_text and not isinstance(billing_extra_text, str):
            raise TypeError("Expected argument 'billing_extra_text' to be a str")
        pulumi.set(__self__, "billing_extra_text", billing_extra_text)
        if billing_group and not isinstance(billing_group, str):
            raise TypeError("Expected argument 'billing_group' to be a str")
        pulumi.set(__self__, "billing_group", billing_group)
        if ca_cert and not isinstance(ca_cert, str):
            raise TypeError("Expected argument 'ca_cert' to be a str")
        pulumi.set(__self__, "ca_cert", ca_cert)
        if card_id and not isinstance(card_id, str):
            raise TypeError("Expected argument 'card_id' to be a str")
        pulumi.set(__self__, "card_id", card_id)
        if copy_from_project and not isinstance(copy_from_project, str):
            raise TypeError("Expected argument 'copy_from_project' to be a str")
        pulumi.set(__self__, "copy_from_project", copy_from_project)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if default_cloud and not isinstance(default_cloud, str):
            raise TypeError("Expected argument 'default_cloud' to be a str")
        pulumi.set(__self__, "default_cloud", default_cloud)
        if estimated_balance and not isinstance(estimated_balance, str):
            raise TypeError("Expected argument 'estimated_balance' to be a str")
        pulumi.set(__self__, "estimated_balance", estimated_balance)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if payment_method and not isinstance(payment_method, str):
            raise TypeError("Expected argument 'payment_method' to be a str")
        pulumi.set(__self__, "payment_method", payment_method)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if technical_emails and not isinstance(technical_emails, list):
            raise TypeError("Expected argument 'technical_emails' to be a list")
        pulumi.set(__self__, "technical_emails", technical_emails)
        if use_source_project_billing_group and not isinstance(use_source_project_billing_group, bool):
            raise TypeError("Expected argument 'use_source_project_billing_group' to be a bool")
        pulumi.set(__self__, "use_source_project_billing_group", use_source_project_billing_group)
        if vat_id and not isinstance(vat_id, str):
            raise TypeError("Expected argument 'vat_id' to be a str")
        pulumi.set(__self__, "vat_id", vat_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        is an optional property to link a project to already an existing account by 
        using account ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="availableCredits")
    def available_credits(self) -> str:
        """
        is a computed property returning the amount of platform credits available to
        the project. This could be your free trial or other promotional credits.
        """
        return pulumi.get(self, "available_credits")

    @property
    @pulumi.getter(name="billingAddress")
    def billing_address(self) -> Optional[str]:
        return pulumi.get(self, "billing_address")

    @property
    @pulumi.getter(name="billingCurrency")
    def billing_currency(self) -> Optional[str]:
        return pulumi.get(self, "billing_currency")

    @property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "billing_emails")

    @property
    @pulumi.getter(name="billingExtraText")
    def billing_extra_text(self) -> Optional[str]:
        return pulumi.get(self, "billing_extra_text")

    @property
    @pulumi.getter(name="billingGroup")
    def billing_group(self) -> Optional[str]:
        return pulumi.get(self, "billing_group")

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> str:
        """
        is a computed property that can be used to read the CA certificate of the
        project. This is required for configuring clients that connect to certain services like
        Kafka. This value cannot be set, only read.
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter(name="cardId")
    def card_id(self) -> Optional[str]:
        """
        is either the full card UUID or the last 4 digits of the card. As the full
        UUID is not shown in the UI it is typically easier to use the last 4 digits to identify
        the card. This can be omitted if `copy_from_project` is used to copy billing info from
        another project.
        """
        return pulumi.get(self, "card_id")

    @property
    @pulumi.getter(name="copyFromProject")
    def copy_from_project(self) -> Optional[str]:
        """
        is the name of another project used to copy billing information and
        some other project attributes like technical contacts from. This is mostly relevant when
        an existing project has billing type set to invoice and that needs to be copied over to a
        new project. (Setting billing is otherwise not allowed over the API.) This only has
        effect when the project is created.
        """
        return pulumi.get(self, "copy_from_project")

    @property
    @pulumi.getter
    def country(self) -> str:
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[str]:
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="defaultCloud")
    def default_cloud(self) -> Optional[str]:
        """
        defines the default cloud provider and region where services are
        hosted. This can be changed freely after the project is created. This will not affect existing
        services.
        """
        return pulumi.get(self, "default_cloud")

    @property
    @pulumi.getter(name="estimatedBalance")
    def estimated_balance(self) -> str:
        """
        is a computed property returning the current accumulated bill for this
        project in the current billing period.
        """
        return pulumi.get(self, "estimated_balance")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> str:
        """
        is a computed property returning the method of invoicing used for payments for
        this project, e.g. "card".
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> Optional[Sequence[str]]:
        """
        defines the email addresses that will receive alerts about
        upcoming maintenance updates or warnings about service instability. It is a good practice to keep
        this up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @property
    @pulumi.getter(name="useSourceProjectBillingGroup")
    def use_source_project_billing_group(self) -> Optional[bool]:
        return pulumi.get(self, "use_source_project_billing_group")

    @property
    @pulumi.getter(name="vatId")
    def vat_id(self) -> Optional[str]:
        return pulumi.get(self, "vat_id")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            account_id=self.account_id,
            available_credits=self.available_credits,
            billing_address=self.billing_address,
            billing_currency=self.billing_currency,
            billing_emails=self.billing_emails,
            billing_extra_text=self.billing_extra_text,
            billing_group=self.billing_group,
            ca_cert=self.ca_cert,
            card_id=self.card_id,
            copy_from_project=self.copy_from_project,
            country=self.country,
            country_code=self.country_code,
            default_cloud=self.default_cloud,
            estimated_balance=self.estimated_balance,
            id=self.id,
            payment_method=self.payment_method,
            project=self.project,
            technical_emails=self.technical_emails,
            use_source_project_billing_group=self.use_source_project_billing_group,
            vat_id=self.vat_id)


def get_project(account_id: Optional[str] = None,
                available_credits: Optional[str] = None,
                billing_address: Optional[str] = None,
                billing_currency: Optional[str] = None,
                billing_emails: Optional[Sequence[str]] = None,
                billing_extra_text: Optional[str] = None,
                billing_group: Optional[str] = None,
                ca_cert: Optional[str] = None,
                card_id: Optional[str] = None,
                copy_from_project: Optional[str] = None,
                country: Optional[str] = None,
                country_code: Optional[str] = None,
                default_cloud: Optional[str] = None,
                estimated_balance: Optional[str] = None,
                payment_method: Optional[str] = None,
                project: Optional[str] = None,
                technical_emails: Optional[Sequence[str]] = None,
                use_source_project_billing_group: Optional[bool] = None,
                vat_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    ## # Project Data Source

    The Project data source provides information about the existing Aiven Project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myproject = aiven.get_project(project="<PROJECT_NAME>")
    ```


    :param str account_id: is an optional property to link a project to already an existing account by 
           using account ID.
    :param str available_credits: is a computed property returning the amount of platform credits available to
           the project. This could be your free trial or other promotional credits.
    :param str ca_cert: is a computed property that can be used to read the CA certificate of the
           project. This is required for configuring clients that connect to certain services like
           Kafka. This value cannot be set, only read.
    :param str card_id: is either the full card UUID or the last 4 digits of the card. As the full
           UUID is not shown in the UI it is typically easier to use the last 4 digits to identify
           the card. This can be omitted if `copy_from_project` is used to copy billing info from
           another project.
    :param str copy_from_project: is the name of another project used to copy billing information and
           some other project attributes like technical contacts from. This is mostly relevant when
           an existing project has billing type set to invoice and that needs to be copied over to a
           new project. (Setting billing is otherwise not allowed over the API.) This only has
           effect when the project is created.
    :param str default_cloud: defines the default cloud provider and region where services are
           hosted. This can be changed freely after the project is created. This will not affect existing
           services.
    :param str estimated_balance: is a computed property returning the current accumulated bill for this
           project in the current billing period.
    :param str payment_method: is a computed property returning the method of invoicing used for payments for
           this project, e.g. "card".
    :param str project: defines the name of the project. Name must be globally unique (between all
           Aiven customers) and cannot be changed later without destroying and re-creating the
           project, including all sub-resources.
    :param Sequence[str] technical_emails: defines the email addresses that will receive alerts about
           upcoming maintenance updates or warnings about service instability. It is a good practice to keep
           this up-to-date to be aware of any potential issues with your project.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['availableCredits'] = available_credits
    __args__['billingAddress'] = billing_address
    __args__['billingCurrency'] = billing_currency
    __args__['billingEmails'] = billing_emails
    __args__['billingExtraText'] = billing_extra_text
    __args__['billingGroup'] = billing_group
    __args__['caCert'] = ca_cert
    __args__['cardId'] = card_id
    __args__['copyFromProject'] = copy_from_project
    __args__['country'] = country
    __args__['countryCode'] = country_code
    __args__['defaultCloud'] = default_cloud
    __args__['estimatedBalance'] = estimated_balance
    __args__['paymentMethod'] = payment_method
    __args__['project'] = project
    __args__['technicalEmails'] = technical_emails
    __args__['useSourceProjectBillingGroup'] = use_source_project_billing_group
    __args__['vatId'] = vat_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        account_id=__ret__.account_id,
        available_credits=__ret__.available_credits,
        billing_address=__ret__.billing_address,
        billing_currency=__ret__.billing_currency,
        billing_emails=__ret__.billing_emails,
        billing_extra_text=__ret__.billing_extra_text,
        billing_group=__ret__.billing_group,
        ca_cert=__ret__.ca_cert,
        card_id=__ret__.card_id,
        copy_from_project=__ret__.copy_from_project,
        country=__ret__.country,
        country_code=__ret__.country_code,
        default_cloud=__ret__.default_cloud,
        estimated_balance=__ret__.estimated_balance,
        id=__ret__.id,
        payment_method=__ret__.payment_method,
        project=__ret__.project,
        technical_emails=__ret__.technical_emails,
        use_source_project_billing_group=__ret__.use_source_project_billing_group,
        vat_id=__ret__.vat_id)
