# client
The OpenAPI definition of the Kinetic API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0-rc.9
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import client
from pprint import pprint
from client.api import account_api
from client.model.balance_response import BalanceResponse
from client.model.create_account_request import CreateAccountRequest
from client.model.history_response import HistoryResponse
from client.model.transaction import Transaction
# Defining the host is optional and defaults to http://localhost:3000
# See configuration.py for a list of all supported configuration parameters.
configuration = client.Configuration(
    host = "http://localhost:3000"
)



# Enter a context with an instance of the API client
with client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = account_api.AccountApi(api_client)
    create_account_request = CreateAccountRequest(
        commitment=Commitment("Confirmed"),
        environment="environment_example",
        index=1,
        last_valid_block_height=1,
        mint="mint_example",
        reference_id="reference_id_example",
        reference_type="reference_type_example",
        tx="tx_example",
    ) # CreateAccountRequest | 

    try:
        # 
        api_response = api_instance.create_account(create_account_request)
        pprint(api_response)
    except client.ApiException as e:
        print("Exception when calling AccountApi->create_account: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:3000*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**create_account**](docs/AccountApi.md#create_account) | **POST** /api/account/create | 
*AccountApi* | [**get_account_info**](docs/AccountApi.md#get_account_info) | **GET** /api/account/info/{environment}/{index}/{accountId} | 
*AccountApi* | [**get_balance**](docs/AccountApi.md#get_balance) | **GET** /api/account/balance/{environment}/{index}/{accountId} | 
*AccountApi* | [**get_history**](docs/AccountApi.md#get_history) | **GET** /api/account/history/{environment}/{index}/{accountId}/{mint} | 
*AccountApi* | [**get_token_accounts**](docs/AccountApi.md#get_token_accounts) | **GET** /api/account/token-accounts/{environment}/{index}/{accountId}/{mint} | 
*AirdropApi* | [**request_airdrop**](docs/AirdropApi.md#request_airdrop) | **POST** /api/airdrop | 
*AppApi* | [**get_app_config**](docs/AppApi.md#get_app_config) | **GET** /api/app/{environment}/{index}/config | 
*AppApi* | [**get_app_health**](docs/AppApi.md#get_app_health) | **GET** /api/app/{environment}/{index}/health | 
*TransactionApi* | [**get_latest_blockhash**](docs/TransactionApi.md#get_latest_blockhash) | **GET** /api/transaction/latest-blockhash/{environment}/{index} | 
*TransactionApi* | [**get_minimum_rent_exemption_balance**](docs/TransactionApi.md#get_minimum_rent_exemption_balance) | **GET** /api/transaction/minimum-rent-exemption-balance/{environment}/{index} | 
*TransactionApi* | [**get_transaction**](docs/TransactionApi.md#get_transaction) | **GET** /api/transaction/transaction/{environment}/{index}/{signature} | 
*TransactionApi* | [**make_transfer**](docs/TransactionApi.md#make_transfer) | **POST** /api/transaction/make-transfer | 


## Documentation For Models

 - [AppConfig](docs/AppConfig.md)
 - [AppConfigApi](docs/AppConfigApi.md)
 - [AppConfigApp](docs/AppConfigApp.md)
 - [AppConfigCluster](docs/AppConfigCluster.md)
 - [AppConfigEnvironment](docs/AppConfigEnvironment.md)
 - [AppConfigMint](docs/AppConfigMint.md)
 - [AppHealth](docs/AppHealth.md)
 - [BalanceResponse](docs/BalanceResponse.md)
 - [BalanceToken](docs/BalanceToken.md)
 - [ClusterType](docs/ClusterType.md)
 - [Commitment](docs/Commitment.md)
 - [CompiledInnerInstruction](docs/CompiledInnerInstruction.md)
 - [CompiledInstruction](docs/CompiledInstruction.md)
 - [ConfirmationStatus](docs/ConfirmationStatus.md)
 - [ConfirmedSignatureInfo](docs/ConfirmedSignatureInfo.md)
 - [ConfirmedTransactionMeta](docs/ConfirmedTransactionMeta.md)
 - [CreateAccountRequest](docs/CreateAccountRequest.md)
 - [GetTransactionResponse](docs/GetTransactionResponse.md)
 - [HistoryResponse](docs/HistoryResponse.md)
 - [LatestBlockhashResponse](docs/LatestBlockhashResponse.md)
 - [MakeTransferRequest](docs/MakeTransferRequest.md)
 - [MinimumRentExemptionBalanceResponse](docs/MinimumRentExemptionBalanceResponse.md)
 - [RequestAirdropRequest](docs/RequestAirdropRequest.md)
 - [RequestAirdropResponse](docs/RequestAirdropResponse.md)
 - [SignatureStatus](docs/SignatureStatus.md)
 - [TokenAmount](docs/TokenAmount.md)
 - [TokenBalance](docs/TokenBalance.md)
 - [Transaction](docs/Transaction.md)
 - [TransactionData](docs/TransactionData.md)
 - [TransactionError](docs/TransactionError.md)
 - [TransactionErrorType](docs/TransactionErrorType.md)
 - [TransactionResponse](docs/TransactionResponse.md)
 - [TransactionStatus](docs/TransactionStatus.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in client.apis and client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from client.api.default_api import DefaultApi`
- `from client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import client
from client.apis import *
from client.models import *
```

