# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnforcerGroupsArgs', 'EnforcerGroups']

@pulumi.input_type
class EnforcerGroupsArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[str],
                 orchestrators: pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsOrchestratorArgs']]],
                 type: pulumi.Input[str],
                 admission_control: Optional[pulumi.Input[bool]] = None,
                 allow_kube_enforcer_audit: Optional[pulumi.Input[bool]] = None,
                 allowed_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_registries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 antivirus_protection: Optional[pulumi.Input[bool]] = None,
                 audit_all: Optional[pulumi.Input[bool]] = None,
                 auto_copy_secrets: Optional[pulumi.Input[bool]] = None,
                 auto_discover_configure_registries: Optional[pulumi.Input[bool]] = None,
                 auto_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 auto_scan_discovered_images_running_containers: Optional[pulumi.Input[bool]] = None,
                 behavioral_engine: Optional[pulumi.Input[bool]] = None,
                 block_admission_control: Optional[pulumi.Input[bool]] = None,
                 container_activity_protection: Optional[pulumi.Input[bool]] = None,
                 container_antivirus_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 forensics: Optional[pulumi.Input[bool]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_assurance: Optional[pulumi.Input[bool]] = None,
                 host_behavioral_engine: Optional[pulumi.Input[bool]] = None,
                 host_forensics: Optional[pulumi.Input[bool]] = None,
                 host_network_protection: Optional[pulumi.Input[bool]] = None,
                 host_os: Optional[pulumi.Input[str]] = None,
                 host_protection: Optional[pulumi.Input[bool]] = None,
                 host_user_protection: Optional[pulumi.Input[bool]] = None,
                 image_assurance: Optional[pulumi.Input[bool]] = None,
                 kube_bench_image_name: Optional[pulumi.Input[str]] = None,
                 logical_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_certs_secrets_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_image_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_injection: Optional[pulumi.Input[bool]] = None,
                 micro_enforcer_secrets_name: Optional[pulumi.Input[str]] = None,
                 network_protection: Optional[pulumi.Input[bool]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 risk_explorer_auto_discovery: Optional[pulumi.Input[bool]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 sync_host_images: Optional[pulumi.Input[bool]] = None,
                 syscall_enabled: Optional[pulumi.Input[bool]] = None,
                 user_access_control: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a EnforcerGroups resource.
        :param pulumi.Input[str] group_id: The ID of the Enforcer group.
        :param pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsOrchestratorArgs']]] orchestrators: The orchestrator for which you are creating the Enforcer group.
        :param pulumi.Input[str] type: Enforcer Type.
        :param pulumi.Input[bool] admission_control: Selecting this option will allow the KubeEnforcer to block the deployment of container images that have failed any of these Container Runtime Policy controls:\\
               			* Block Non-Compliant Images\\
               			* Block Non-Compliant Workloads\\
               			* Block Unregistered Images\\
               			This functionality can work only when the KubeEnforcer is deployed in Enforce mode.
        :param pulumi.Input[bool] allow_kube_enforcer_audit: Allow kube enforcer audit.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_applications: List of application names to allow on the hosts. if provided, only containers of the listed applications will be allowed to run.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_labels: List of label names to allow on the hosts.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_registries: List of registry names to allow on the hosts.
        :param pulumi.Input[bool] antivirus_protection: This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Host Runtime policies.
        :param pulumi.Input[bool] audit_all: Agent will send extra audit messages to the server for success operations from inside the container (runtime).
        :param pulumi.Input[bool] auto_copy_secrets: This option is applicable only if `Enable Pod Enforcer injection` is selected. Select this option if you want Aqua Enterprise to copy the secrets defined above to the Pod Enforcer namespace and container. Otherwise, you can choose to copy these secrets by other means.
        :param pulumi.Input[bool] auto_discover_configure_registries: This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will add previously unknown image registries from the cluster to Aqua.
        :param pulumi.Input[bool] auto_discovery_enabled: When this option is selected, the KubeEnforcer will discover workloads on its cluster.
        :param pulumi.Input[bool] auto_scan_discovered_images_running_containers: This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will automatically register images running as workloads (and scan the discovered images for security issues).
        :param pulumi.Input[bool] behavioral_engine: Select Enabled to detect suspicious activity in your containers and display potential security threats in the Incidents and Audit pages.
        :param pulumi.Input[bool] block_admission_control: This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        :param pulumi.Input[bool] container_activity_protection: Set `True` to apply Container Runtime Policies, Image Profiles, and Firewall Policies to containers.
        :param pulumi.Input[bool] container_antivirus_protection: This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Container Runtime policies.
        :param pulumi.Input[str] description: A description of the Aqua Enforcer group.
        :param pulumi.Input[bool] enforce: Whether to enable enforce mode on the Enforcers, defaults to False.
        :param pulumi.Input[bool] forensics: Select Enabled to send activity logs in your containers to the Aqua Server for forensics purposes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: List of Aqua gateway IDs for the Enforcers.
        :param pulumi.Input[bool] host_assurance: Set `True` to enable host scanning and respective Host Assurance controls.
        :param pulumi.Input[bool] host_behavioral_engine: Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        :param pulumi.Input[bool] host_forensics: Select Enabled to send activity logs in your host to the Aqua Server for forensics purposes.
        :param pulumi.Input[bool] host_network_protection: Set `True` to apply Firewall Policies to hosts, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information
        :param pulumi.Input[str] host_os: The OS type for the host
        :param pulumi.Input[bool] host_protection: Set `True` to enable all Host Runtime Policy controls except for `OS Users and Groups Allowed` and `OS Users and Groups Blocked`.
        :param pulumi.Input[bool] host_user_protection: Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        :param pulumi.Input[bool] image_assurance: Set `True` to enable selected controls: Container Runtime Policy (`Block Non-Compliant Images`, `Block Unregistered Images`, and `Registries Allowed`) and Default Image Assurance Policy (`Images Blocked`).
        :param pulumi.Input[str] kube_bench_image_name: See https://docs.aquasec.com/docs/securing-kubernetes-applications#section-configuration-hardening, The KubeEnforcer can deploy the Aqua Security kube-bench open-source product to perform Kubernetes CIS benchmark testing of nodes.
               			This field specifies the path and file name of the kube-bench product image for the KubeEnforcer to deploy; it will be filled in automatically. You can optionally enter a different value.
        :param pulumi.Input[str] logical_name: Name for the batch install record.
        :param pulumi.Input[str] micro_enforcer_certs_secrets_name: This option is applicable only if `Enable Pod Enforcer injection` is selected.
        :param pulumi.Input[str] micro_enforcer_image_name: This option is applicable only if `Enable Pod Enforcer injection` is selected. This field specifies the path and file name of the KubeEnforcer product image to be deployed; it will be filled in automatically. You can optionally enter a different value.
        :param pulumi.Input[bool] micro_enforcer_injection: This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        :param pulumi.Input[str] micro_enforcer_secrets_name: You can specify the name of the secret (in the Aqua namespace) that Aqua copies into the Pod Enforcer namespace and kube-bench, allowing them access to the Pod Enforcer and kube-bench product images, respectively.
        :param pulumi.Input[bool] network_protection: Send true to apply Firewall Policies to containers, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information.
        :param pulumi.Input[str] permission: Permission Action
        :param pulumi.Input[bool] risk_explorer_auto_discovery: Set `True` to allow Enforcers to be discovered in the Risk Explorer.
        :param pulumi.Input[str] runtime_type: The container runtime environment.
        :param pulumi.Input[bool] sync_host_images: Set `True` to configure Enforcers to discover local host images. Discovered images will be listed under Images > Host Images, as well as under Infrastructure (in the Images tab for applicable hosts).
        :param pulumi.Input[bool] syscall_enabled: Set `True` will allow profiling and monitoring system calls made by running containers.
        :param pulumi.Input[bool] user_access_control: Set `True` to apply User Access Control Policies to containers. Note that Aqua Enforcers must be deployed with the AQUA*RUNC*INTERCEPTION environment variable set to 0 in order to use User Access Control Policies.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "orchestrators", orchestrators)
        pulumi.set(__self__, "type", type)
        if admission_control is not None:
            pulumi.set(__self__, "admission_control", admission_control)
        if allow_kube_enforcer_audit is not None:
            pulumi.set(__self__, "allow_kube_enforcer_audit", allow_kube_enforcer_audit)
        if allowed_applications is not None:
            pulumi.set(__self__, "allowed_applications", allowed_applications)
        if allowed_labels is not None:
            pulumi.set(__self__, "allowed_labels", allowed_labels)
        if allowed_registries is not None:
            pulumi.set(__self__, "allowed_registries", allowed_registries)
        if antivirus_protection is not None:
            pulumi.set(__self__, "antivirus_protection", antivirus_protection)
        if audit_all is not None:
            pulumi.set(__self__, "audit_all", audit_all)
        if auto_copy_secrets is not None:
            pulumi.set(__self__, "auto_copy_secrets", auto_copy_secrets)
        if auto_discover_configure_registries is not None:
            pulumi.set(__self__, "auto_discover_configure_registries", auto_discover_configure_registries)
        if auto_discovery_enabled is not None:
            pulumi.set(__self__, "auto_discovery_enabled", auto_discovery_enabled)
        if auto_scan_discovered_images_running_containers is not None:
            pulumi.set(__self__, "auto_scan_discovered_images_running_containers", auto_scan_discovered_images_running_containers)
        if behavioral_engine is not None:
            pulumi.set(__self__, "behavioral_engine", behavioral_engine)
        if block_admission_control is not None:
            pulumi.set(__self__, "block_admission_control", block_admission_control)
        if container_activity_protection is not None:
            pulumi.set(__self__, "container_activity_protection", container_activity_protection)
        if container_antivirus_protection is not None:
            pulumi.set(__self__, "container_antivirus_protection", container_antivirus_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if forensics is not None:
            pulumi.set(__self__, "forensics", forensics)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if host_assurance is not None:
            pulumi.set(__self__, "host_assurance", host_assurance)
        if host_behavioral_engine is not None:
            pulumi.set(__self__, "host_behavioral_engine", host_behavioral_engine)
        if host_forensics is not None:
            pulumi.set(__self__, "host_forensics", host_forensics)
        if host_network_protection is not None:
            pulumi.set(__self__, "host_network_protection", host_network_protection)
        if host_os is not None:
            pulumi.set(__self__, "host_os", host_os)
        if host_protection is not None:
            pulumi.set(__self__, "host_protection", host_protection)
        if host_user_protection is not None:
            pulumi.set(__self__, "host_user_protection", host_user_protection)
        if image_assurance is not None:
            pulumi.set(__self__, "image_assurance", image_assurance)
        if kube_bench_image_name is not None:
            pulumi.set(__self__, "kube_bench_image_name", kube_bench_image_name)
        if logical_name is not None:
            pulumi.set(__self__, "logical_name", logical_name)
        if micro_enforcer_certs_secrets_name is not None:
            pulumi.set(__self__, "micro_enforcer_certs_secrets_name", micro_enforcer_certs_secrets_name)
        if micro_enforcer_image_name is not None:
            pulumi.set(__self__, "micro_enforcer_image_name", micro_enforcer_image_name)
        if micro_enforcer_injection is not None:
            pulumi.set(__self__, "micro_enforcer_injection", micro_enforcer_injection)
        if micro_enforcer_secrets_name is not None:
            pulumi.set(__self__, "micro_enforcer_secrets_name", micro_enforcer_secrets_name)
        if network_protection is not None:
            pulumi.set(__self__, "network_protection", network_protection)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if risk_explorer_auto_discovery is not None:
            pulumi.set(__self__, "risk_explorer_auto_discovery", risk_explorer_auto_discovery)
        if runtime_type is not None:
            pulumi.set(__self__, "runtime_type", runtime_type)
        if sync_host_images is not None:
            pulumi.set(__self__, "sync_host_images", sync_host_images)
        if syscall_enabled is not None:
            pulumi.set(__self__, "syscall_enabled", syscall_enabled)
        if user_access_control is not None:
            pulumi.set(__self__, "user_access_control", user_access_control)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        The ID of the Enforcer group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def orchestrators(self) -> pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsOrchestratorArgs']]]:
        """
        The orchestrator for which you are creating the Enforcer group.
        """
        return pulumi.get(self, "orchestrators")

    @orchestrators.setter
    def orchestrators(self, value: pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsOrchestratorArgs']]]):
        pulumi.set(self, "orchestrators", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Enforcer Type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="admissionControl")
    def admission_control(self) -> Optional[pulumi.Input[bool]]:
        """
        Selecting this option will allow the KubeEnforcer to block the deployment of container images that have failed any of these Container Runtime Policy controls:\\
        			* Block Non-Compliant Images\\
        			* Block Non-Compliant Workloads\\
        			* Block Unregistered Images\\
        			This functionality can work only when the KubeEnforcer is deployed in Enforce mode.
        """
        return pulumi.get(self, "admission_control")

    @admission_control.setter
    def admission_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admission_control", value)

    @property
    @pulumi.getter(name="allowKubeEnforcerAudit")
    def allow_kube_enforcer_audit(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow kube enforcer audit.
        """
        return pulumi.get(self, "allow_kube_enforcer_audit")

    @allow_kube_enforcer_audit.setter
    def allow_kube_enforcer_audit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_kube_enforcer_audit", value)

    @property
    @pulumi.getter(name="allowedApplications")
    def allowed_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of application names to allow on the hosts. if provided, only containers of the listed applications will be allowed to run.
        """
        return pulumi.get(self, "allowed_applications")

    @allowed_applications.setter
    def allowed_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_applications", value)

    @property
    @pulumi.getter(name="allowedLabels")
    def allowed_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of label names to allow on the hosts.
        """
        return pulumi.get(self, "allowed_labels")

    @allowed_labels.setter
    def allowed_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_labels", value)

    @property
    @pulumi.getter(name="allowedRegistries")
    def allowed_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of registry names to allow on the hosts.
        """
        return pulumi.get(self, "allowed_registries")

    @allowed_registries.setter
    def allowed_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_registries", value)

    @property
    @pulumi.getter(name="antivirusProtection")
    def antivirus_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Host Runtime policies.
        """
        return pulumi.get(self, "antivirus_protection")

    @antivirus_protection.setter
    def antivirus_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "antivirus_protection", value)

    @property
    @pulumi.getter(name="auditAll")
    def audit_all(self) -> Optional[pulumi.Input[bool]]:
        """
        Agent will send extra audit messages to the server for success operations from inside the container (runtime).
        """
        return pulumi.get(self, "audit_all")

    @audit_all.setter
    def audit_all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_all", value)

    @property
    @pulumi.getter(name="autoCopySecrets")
    def auto_copy_secrets(self) -> Optional[pulumi.Input[bool]]:
        """
        This option is applicable only if `Enable Pod Enforcer injection` is selected. Select this option if you want Aqua Enterprise to copy the secrets defined above to the Pod Enforcer namespace and container. Otherwise, you can choose to copy these secrets by other means.
        """
        return pulumi.get(self, "auto_copy_secrets")

    @auto_copy_secrets.setter
    def auto_copy_secrets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_copy_secrets", value)

    @property
    @pulumi.getter(name="autoDiscoverConfigureRegistries")
    def auto_discover_configure_registries(self) -> Optional[pulumi.Input[bool]]:
        """
        This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will add previously unknown image registries from the cluster to Aqua.
        """
        return pulumi.get(self, "auto_discover_configure_registries")

    @auto_discover_configure_registries.setter
    def auto_discover_configure_registries(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_discover_configure_registries", value)

    @property
    @pulumi.getter(name="autoDiscoveryEnabled")
    def auto_discovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When this option is selected, the KubeEnforcer will discover workloads on its cluster.
        """
        return pulumi.get(self, "auto_discovery_enabled")

    @auto_discovery_enabled.setter
    def auto_discovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_discovery_enabled", value)

    @property
    @pulumi.getter(name="autoScanDiscoveredImagesRunningContainers")
    def auto_scan_discovered_images_running_containers(self) -> Optional[pulumi.Input[bool]]:
        """
        This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will automatically register images running as workloads (and scan the discovered images for security issues).
        """
        return pulumi.get(self, "auto_scan_discovered_images_running_containers")

    @auto_scan_discovered_images_running_containers.setter
    def auto_scan_discovered_images_running_containers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_scan_discovered_images_running_containers", value)

    @property
    @pulumi.getter(name="behavioralEngine")
    def behavioral_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        Select Enabled to detect suspicious activity in your containers and display potential security threats in the Incidents and Audit pages.
        """
        return pulumi.get(self, "behavioral_engine")

    @behavioral_engine.setter
    def behavioral_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "behavioral_engine", value)

    @property
    @pulumi.getter(name="blockAdmissionControl")
    def block_admission_control(self) -> Optional[pulumi.Input[bool]]:
        """
        This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        """
        return pulumi.get(self, "block_admission_control")

    @block_admission_control.setter
    def block_admission_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_admission_control", value)

    @property
    @pulumi.getter(name="containerActivityProtection")
    def container_activity_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to apply Container Runtime Policies, Image Profiles, and Firewall Policies to containers.
        """
        return pulumi.get(self, "container_activity_protection")

    @container_activity_protection.setter
    def container_activity_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "container_activity_protection", value)

    @property
    @pulumi.getter(name="containerAntivirusProtection")
    def container_antivirus_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Container Runtime policies.
        """
        return pulumi.get(self, "container_antivirus_protection")

    @container_antivirus_protection.setter
    def container_antivirus_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "container_antivirus_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the Aqua Enforcer group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable enforce mode on the Enforcers, defaults to False.
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce", value)

    @property
    @pulumi.getter
    def forensics(self) -> Optional[pulumi.Input[bool]]:
        """
        Select Enabled to send activity logs in your containers to the Aqua Server for forensics purposes.
        """
        return pulumi.get(self, "forensics")

    @forensics.setter
    def forensics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forensics", value)

    @property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Aqua gateway IDs for the Enforcers.
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateways", value)

    @property
    @pulumi.getter(name="hostAssurance")
    def host_assurance(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to enable host scanning and respective Host Assurance controls.
        """
        return pulumi.get(self, "host_assurance")

    @host_assurance.setter
    def host_assurance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_assurance", value)

    @property
    @pulumi.getter(name="hostBehavioralEngine")
    def host_behavioral_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        """
        return pulumi.get(self, "host_behavioral_engine")

    @host_behavioral_engine.setter
    def host_behavioral_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_behavioral_engine", value)

    @property
    @pulumi.getter(name="hostForensics")
    def host_forensics(self) -> Optional[pulumi.Input[bool]]:
        """
        Select Enabled to send activity logs in your host to the Aqua Server for forensics purposes.
        """
        return pulumi.get(self, "host_forensics")

    @host_forensics.setter
    def host_forensics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_forensics", value)

    @property
    @pulumi.getter(name="hostNetworkProtection")
    def host_network_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to apply Firewall Policies to hosts, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information
        """
        return pulumi.get(self, "host_network_protection")

    @host_network_protection.setter
    def host_network_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_network_protection", value)

    @property
    @pulumi.getter(name="hostOs")
    def host_os(self) -> Optional[pulumi.Input[str]]:
        """
        The OS type for the host
        """
        return pulumi.get(self, "host_os")

    @host_os.setter
    def host_os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_os", value)

    @property
    @pulumi.getter(name="hostProtection")
    def host_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to enable all Host Runtime Policy controls except for `OS Users and Groups Allowed` and `OS Users and Groups Blocked`.
        """
        return pulumi.get(self, "host_protection")

    @host_protection.setter
    def host_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_protection", value)

    @property
    @pulumi.getter(name="hostUserProtection")
    def host_user_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        """
        return pulumi.get(self, "host_user_protection")

    @host_user_protection.setter
    def host_user_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_user_protection", value)

    @property
    @pulumi.getter(name="imageAssurance")
    def image_assurance(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to enable selected controls: Container Runtime Policy (`Block Non-Compliant Images`, `Block Unregistered Images`, and `Registries Allowed`) and Default Image Assurance Policy (`Images Blocked`).
        """
        return pulumi.get(self, "image_assurance")

    @image_assurance.setter
    def image_assurance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "image_assurance", value)

    @property
    @pulumi.getter(name="kubeBenchImageName")
    def kube_bench_image_name(self) -> Optional[pulumi.Input[str]]:
        """
        See https://docs.aquasec.com/docs/securing-kubernetes-applications#section-configuration-hardening, The KubeEnforcer can deploy the Aqua Security kube-bench open-source product to perform Kubernetes CIS benchmark testing of nodes.
        			This field specifies the path and file name of the kube-bench product image for the KubeEnforcer to deploy; it will be filled in automatically. You can optionally enter a different value.
        """
        return pulumi.get(self, "kube_bench_image_name")

    @kube_bench_image_name.setter
    def kube_bench_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kube_bench_image_name", value)

    @property
    @pulumi.getter(name="logicalName")
    def logical_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the batch install record.
        """
        return pulumi.get(self, "logical_name")

    @logical_name.setter
    def logical_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical_name", value)

    @property
    @pulumi.getter(name="microEnforcerCertsSecretsName")
    def micro_enforcer_certs_secrets_name(self) -> Optional[pulumi.Input[str]]:
        """
        This option is applicable only if `Enable Pod Enforcer injection` is selected.
        """
        return pulumi.get(self, "micro_enforcer_certs_secrets_name")

    @micro_enforcer_certs_secrets_name.setter
    def micro_enforcer_certs_secrets_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "micro_enforcer_certs_secrets_name", value)

    @property
    @pulumi.getter(name="microEnforcerImageName")
    def micro_enforcer_image_name(self) -> Optional[pulumi.Input[str]]:
        """
        This option is applicable only if `Enable Pod Enforcer injection` is selected. This field specifies the path and file name of the KubeEnforcer product image to be deployed; it will be filled in automatically. You can optionally enter a different value.
        """
        return pulumi.get(self, "micro_enforcer_image_name")

    @micro_enforcer_image_name.setter
    def micro_enforcer_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "micro_enforcer_image_name", value)

    @property
    @pulumi.getter(name="microEnforcerInjection")
    def micro_enforcer_injection(self) -> Optional[pulumi.Input[bool]]:
        """
        This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        """
        return pulumi.get(self, "micro_enforcer_injection")

    @micro_enforcer_injection.setter
    def micro_enforcer_injection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "micro_enforcer_injection", value)

    @property
    @pulumi.getter(name="microEnforcerSecretsName")
    def micro_enforcer_secrets_name(self) -> Optional[pulumi.Input[str]]:
        """
        You can specify the name of the secret (in the Aqua namespace) that Aqua copies into the Pod Enforcer namespace and kube-bench, allowing them access to the Pod Enforcer and kube-bench product images, respectively.
        """
        return pulumi.get(self, "micro_enforcer_secrets_name")

    @micro_enforcer_secrets_name.setter
    def micro_enforcer_secrets_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "micro_enforcer_secrets_name", value)

    @property
    @pulumi.getter(name="networkProtection")
    def network_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Send true to apply Firewall Policies to containers, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information.
        """
        return pulumi.get(self, "network_protection")

    @network_protection.setter
    def network_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "network_protection", value)

    @property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[str]]:
        """
        Permission Action
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter(name="riskExplorerAutoDiscovery")
    def risk_explorer_auto_discovery(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to allow Enforcers to be discovered in the Risk Explorer.
        """
        return pulumi.get(self, "risk_explorer_auto_discovery")

    @risk_explorer_auto_discovery.setter
    def risk_explorer_auto_discovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "risk_explorer_auto_discovery", value)

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> Optional[pulumi.Input[str]]:
        """
        The container runtime environment.
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_type", value)

    @property
    @pulumi.getter(name="syncHostImages")
    def sync_host_images(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to configure Enforcers to discover local host images. Discovered images will be listed under Images > Host Images, as well as under Infrastructure (in the Images tab for applicable hosts).
        """
        return pulumi.get(self, "sync_host_images")

    @sync_host_images.setter
    def sync_host_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_host_images", value)

    @property
    @pulumi.getter(name="syscallEnabled")
    def syscall_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` will allow profiling and monitoring system calls made by running containers.
        """
        return pulumi.get(self, "syscall_enabled")

    @syscall_enabled.setter
    def syscall_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "syscall_enabled", value)

    @property
    @pulumi.getter(name="userAccessControl")
    def user_access_control(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to apply User Access Control Policies to containers. Note that Aqua Enforcers must be deployed with the AQUA*RUNC*INTERCEPTION environment variable set to 0 in order to use User Access Control Policies.
        """
        return pulumi.get(self, "user_access_control")

    @user_access_control.setter
    def user_access_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_access_control", value)


@pulumi.input_type
class _EnforcerGroupsState:
    def __init__(__self__, *,
                 admission_control: Optional[pulumi.Input[bool]] = None,
                 allow_kube_enforcer_audit: Optional[pulumi.Input[bool]] = None,
                 allowed_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_registries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 antivirus_protection: Optional[pulumi.Input[bool]] = None,
                 aqua_version: Optional[pulumi.Input[str]] = None,
                 audit_all: Optional[pulumi.Input[bool]] = None,
                 auto_copy_secrets: Optional[pulumi.Input[bool]] = None,
                 auto_discover_configure_registries: Optional[pulumi.Input[bool]] = None,
                 auto_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 auto_scan_discovered_images_running_containers: Optional[pulumi.Input[bool]] = None,
                 behavioral_engine: Optional[pulumi.Input[bool]] = None,
                 block_admission_control: Optional[pulumi.Input[bool]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsCommandArgs']]]] = None,
                 connected_count: Optional[pulumi.Input[int]] = None,
                 container_activity_protection: Optional[pulumi.Input[bool]] = None,
                 container_antivirus_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disconnected_count: Optional[pulumi.Input[int]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 enforcer_image_name: Optional[pulumi.Input[str]] = None,
                 forensics: Optional[pulumi.Input[bool]] = None,
                 gateway_address: Optional[pulumi.Input[str]] = None,
                 gateway_name: Optional[pulumi.Input[str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 high_vulns: Optional[pulumi.Input[int]] = None,
                 host_assurance: Optional[pulumi.Input[bool]] = None,
                 host_behavioral_engine: Optional[pulumi.Input[bool]] = None,
                 host_forensics: Optional[pulumi.Input[bool]] = None,
                 host_network_protection: Optional[pulumi.Input[bool]] = None,
                 host_os: Optional[pulumi.Input[str]] = None,
                 host_protection: Optional[pulumi.Input[bool]] = None,
                 host_user_protection: Optional[pulumi.Input[bool]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 hosts_count: Optional[pulumi.Input[int]] = None,
                 image_assurance: Optional[pulumi.Input[bool]] = None,
                 install_command: Optional[pulumi.Input[str]] = None,
                 kube_bench_image_name: Optional[pulumi.Input[str]] = None,
                 last_update: Optional[pulumi.Input[int]] = None,
                 logical_name: Optional[pulumi.Input[str]] = None,
                 low_vulns: Optional[pulumi.Input[int]] = None,
                 med_vulns: Optional[pulumi.Input[int]] = None,
                 micro_enforcer_certs_secrets_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_image_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_injection: Optional[pulumi.Input[bool]] = None,
                 micro_enforcer_secrets_name: Optional[pulumi.Input[str]] = None,
                 neg_vulns: Optional[pulumi.Input[int]] = None,
                 network_protection: Optional[pulumi.Input[bool]] = None,
                 orchestrators: Optional[pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsOrchestratorArgs']]]] = None,
                 pas_deployment_link: Optional[pulumi.Input[str]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 risk_explorer_auto_discovery: Optional[pulumi.Input[bool]] = None,
                 runtime_policy_name: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 sync_host_images: Optional[pulumi.Input[bool]] = None,
                 syscall_enabled: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_access_control: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering EnforcerGroups resources.
        :param pulumi.Input[bool] admission_control: Selecting this option will allow the KubeEnforcer to block the deployment of container images that have failed any of these Container Runtime Policy controls:\\
               			* Block Non-Compliant Images\\
               			* Block Non-Compliant Workloads\\
               			* Block Unregistered Images\\
               			This functionality can work only when the KubeEnforcer is deployed in Enforce mode.
        :param pulumi.Input[bool] allow_kube_enforcer_audit: Allow kube enforcer audit.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_applications: List of application names to allow on the hosts. if provided, only containers of the listed applications will be allowed to run.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_labels: List of label names to allow on the hosts.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_registries: List of registry names to allow on the hosts.
        :param pulumi.Input[bool] antivirus_protection: This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Host Runtime policies.
        :param pulumi.Input[str] aqua_version: Aqua server version
        :param pulumi.Input[bool] audit_all: Agent will send extra audit messages to the server for success operations from inside the container (runtime).
        :param pulumi.Input[bool] auto_copy_secrets: This option is applicable only if `Enable Pod Enforcer injection` is selected. Select this option if you want Aqua Enterprise to copy the secrets defined above to the Pod Enforcer namespace and container. Otherwise, you can choose to copy these secrets by other means.
        :param pulumi.Input[bool] auto_discover_configure_registries: This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will add previously unknown image registries from the cluster to Aqua.
        :param pulumi.Input[bool] auto_discovery_enabled: When this option is selected, the KubeEnforcer will discover workloads on its cluster.
        :param pulumi.Input[bool] auto_scan_discovered_images_running_containers: This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will automatically register images running as workloads (and scan the discovered images for security issues).
        :param pulumi.Input[bool] behavioral_engine: Select Enabled to detect suspicious activity in your containers and display potential security threats in the Incidents and Audit pages.
        :param pulumi.Input[bool] block_admission_control: This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        :param pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsCommandArgs']]] commands: The installation command.
        :param pulumi.Input[int] connected_count: Number of connected enforcers in the enforcer group.
        :param pulumi.Input[bool] container_activity_protection: Set `True` to apply Container Runtime Policies, Image Profiles, and Firewall Policies to containers.
        :param pulumi.Input[bool] container_antivirus_protection: This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Container Runtime policies.
        :param pulumi.Input[str] description: A description of the Aqua Enforcer group.
        :param pulumi.Input[int] disconnected_count: Number of disconnected enforcers in the enforcer group.
        :param pulumi.Input[bool] enforce: Whether to enable enforce mode on the Enforcers, defaults to False.
        :param pulumi.Input[str] enforcer_image_name: The specific Aqua Enforcer product image (with image tag) to be deployed.
        :param pulumi.Input[bool] forensics: Select Enabled to send activity logs in your containers to the Aqua Server for forensics purposes.
        :param pulumi.Input[str] gateway_address: Gateway Address
        :param pulumi.Input[str] gateway_name: Gateway Name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: List of Aqua gateway IDs for the Enforcers.
        :param pulumi.Input[str] group_id: The ID of the Enforcer group.
        :param pulumi.Input[int] high_vulns: Number of high vulnerabilities in the enforcers that in this enforcer group.
        :param pulumi.Input[bool] host_assurance: Set `True` to enable host scanning and respective Host Assurance controls.
        :param pulumi.Input[bool] host_behavioral_engine: Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        :param pulumi.Input[bool] host_forensics: Select Enabled to send activity logs in your host to the Aqua Server for forensics purposes.
        :param pulumi.Input[bool] host_network_protection: Set `True` to apply Firewall Policies to hosts, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information
        :param pulumi.Input[str] host_os: The OS type for the host
        :param pulumi.Input[bool] host_protection: Set `True` to enable all Host Runtime Policy controls except for `OS Users and Groups Allowed` and `OS Users and Groups Blocked`.
        :param pulumi.Input[bool] host_user_protection: Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        :param pulumi.Input[str] hostname: The hostname
        :param pulumi.Input[int] hosts_count: Number of enforcers in the enforcer group.
        :param pulumi.Input[bool] image_assurance: Set `True` to enable selected controls: Container Runtime Policy (`Block Non-Compliant Images`, `Block Unregistered Images`, and `Registries Allowed`) and Default Image Assurance Policy (`Images Blocked`).
        :param pulumi.Input[str] install_command: Enforcer install command
        :param pulumi.Input[str] kube_bench_image_name: See https://docs.aquasec.com/docs/securing-kubernetes-applications#section-configuration-hardening, The KubeEnforcer can deploy the Aqua Security kube-bench open-source product to perform Kubernetes CIS benchmark testing of nodes.
               			This field specifies the path and file name of the kube-bench product image for the KubeEnforcer to deploy; it will be filled in automatically. You can optionally enter a different value.
        :param pulumi.Input[int] last_update: The last date and time the batch token was updated in UNIX time.
        :param pulumi.Input[str] logical_name: Name for the batch install record.
        :param pulumi.Input[int] low_vulns: Number of low vulnerabilities in the enforcers that in this enforcer group.
        :param pulumi.Input[int] med_vulns: Number of medium vulnerabilities in the enforcers that in this enforcer group.
        :param pulumi.Input[str] micro_enforcer_certs_secrets_name: This option is applicable only if `Enable Pod Enforcer injection` is selected.
        :param pulumi.Input[str] micro_enforcer_image_name: This option is applicable only if `Enable Pod Enforcer injection` is selected. This field specifies the path and file name of the KubeEnforcer product image to be deployed; it will be filled in automatically. You can optionally enter a different value.
        :param pulumi.Input[bool] micro_enforcer_injection: This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        :param pulumi.Input[str] micro_enforcer_secrets_name: You can specify the name of the secret (in the Aqua namespace) that Aqua copies into the Pod Enforcer namespace and kube-bench, allowing them access to the Pod Enforcer and kube-bench product images, respectively.
        :param pulumi.Input[int] neg_vulns: Number of negligible vulnerabilities in the enforcers that in this enforcer group.
        :param pulumi.Input[bool] network_protection: Send true to apply Firewall Policies to containers, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information.
        :param pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsOrchestratorArgs']]] orchestrators: The orchestrator for which you are creating the Enforcer group.
        :param pulumi.Input[str] pas_deployment_link: pas deployment link
        :param pulumi.Input[str] permission: Permission Action
        :param pulumi.Input[bool] risk_explorer_auto_discovery: Set `True` to allow Enforcers to be discovered in the Risk Explorer.
        :param pulumi.Input[str] runtime_policy_name: Function Runtime Policy that will applay on the nano enforcer.
        :param pulumi.Input[str] runtime_type: The container runtime environment.
        :param pulumi.Input[bool] sync_host_images: Set `True` to configure Enforcers to discover local host images. Discovered images will be listed under Images > Host Images, as well as under Infrastructure (in the Images tab for applicable hosts).
        :param pulumi.Input[bool] syscall_enabled: Set `True` will allow profiling and monitoring system calls made by running containers.
        :param pulumi.Input[str] token: The batch install token.
        :param pulumi.Input[str] type: Enforcer Type.
        :param pulumi.Input[bool] user_access_control: Set `True` to apply User Access Control Policies to containers. Note that Aqua Enforcers must be deployed with the AQUA*RUNC*INTERCEPTION environment variable set to 0 in order to use User Access Control Policies.
        """
        if admission_control is not None:
            pulumi.set(__self__, "admission_control", admission_control)
        if allow_kube_enforcer_audit is not None:
            pulumi.set(__self__, "allow_kube_enforcer_audit", allow_kube_enforcer_audit)
        if allowed_applications is not None:
            pulumi.set(__self__, "allowed_applications", allowed_applications)
        if allowed_labels is not None:
            pulumi.set(__self__, "allowed_labels", allowed_labels)
        if allowed_registries is not None:
            pulumi.set(__self__, "allowed_registries", allowed_registries)
        if antivirus_protection is not None:
            pulumi.set(__self__, "antivirus_protection", antivirus_protection)
        if aqua_version is not None:
            pulumi.set(__self__, "aqua_version", aqua_version)
        if audit_all is not None:
            pulumi.set(__self__, "audit_all", audit_all)
        if auto_copy_secrets is not None:
            pulumi.set(__self__, "auto_copy_secrets", auto_copy_secrets)
        if auto_discover_configure_registries is not None:
            pulumi.set(__self__, "auto_discover_configure_registries", auto_discover_configure_registries)
        if auto_discovery_enabled is not None:
            pulumi.set(__self__, "auto_discovery_enabled", auto_discovery_enabled)
        if auto_scan_discovered_images_running_containers is not None:
            pulumi.set(__self__, "auto_scan_discovered_images_running_containers", auto_scan_discovered_images_running_containers)
        if behavioral_engine is not None:
            pulumi.set(__self__, "behavioral_engine", behavioral_engine)
        if block_admission_control is not None:
            pulumi.set(__self__, "block_admission_control", block_admission_control)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if connected_count is not None:
            pulumi.set(__self__, "connected_count", connected_count)
        if container_activity_protection is not None:
            pulumi.set(__self__, "container_activity_protection", container_activity_protection)
        if container_antivirus_protection is not None:
            pulumi.set(__self__, "container_antivirus_protection", container_antivirus_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disconnected_count is not None:
            pulumi.set(__self__, "disconnected_count", disconnected_count)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if enforcer_image_name is not None:
            pulumi.set(__self__, "enforcer_image_name", enforcer_image_name)
        if forensics is not None:
            pulumi.set(__self__, "forensics", forensics)
        if gateway_address is not None:
            pulumi.set(__self__, "gateway_address", gateway_address)
        if gateway_name is not None:
            pulumi.set(__self__, "gateway_name", gateway_name)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if high_vulns is not None:
            pulumi.set(__self__, "high_vulns", high_vulns)
        if host_assurance is not None:
            pulumi.set(__self__, "host_assurance", host_assurance)
        if host_behavioral_engine is not None:
            pulumi.set(__self__, "host_behavioral_engine", host_behavioral_engine)
        if host_forensics is not None:
            pulumi.set(__self__, "host_forensics", host_forensics)
        if host_network_protection is not None:
            pulumi.set(__self__, "host_network_protection", host_network_protection)
        if host_os is not None:
            pulumi.set(__self__, "host_os", host_os)
        if host_protection is not None:
            pulumi.set(__self__, "host_protection", host_protection)
        if host_user_protection is not None:
            pulumi.set(__self__, "host_user_protection", host_user_protection)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if hosts_count is not None:
            pulumi.set(__self__, "hosts_count", hosts_count)
        if image_assurance is not None:
            pulumi.set(__self__, "image_assurance", image_assurance)
        if install_command is not None:
            pulumi.set(__self__, "install_command", install_command)
        if kube_bench_image_name is not None:
            pulumi.set(__self__, "kube_bench_image_name", kube_bench_image_name)
        if last_update is not None:
            pulumi.set(__self__, "last_update", last_update)
        if logical_name is not None:
            pulumi.set(__self__, "logical_name", logical_name)
        if low_vulns is not None:
            pulumi.set(__self__, "low_vulns", low_vulns)
        if med_vulns is not None:
            pulumi.set(__self__, "med_vulns", med_vulns)
        if micro_enforcer_certs_secrets_name is not None:
            pulumi.set(__self__, "micro_enforcer_certs_secrets_name", micro_enforcer_certs_secrets_name)
        if micro_enforcer_image_name is not None:
            pulumi.set(__self__, "micro_enforcer_image_name", micro_enforcer_image_name)
        if micro_enforcer_injection is not None:
            pulumi.set(__self__, "micro_enforcer_injection", micro_enforcer_injection)
        if micro_enforcer_secrets_name is not None:
            pulumi.set(__self__, "micro_enforcer_secrets_name", micro_enforcer_secrets_name)
        if neg_vulns is not None:
            pulumi.set(__self__, "neg_vulns", neg_vulns)
        if network_protection is not None:
            pulumi.set(__self__, "network_protection", network_protection)
        if orchestrators is not None:
            pulumi.set(__self__, "orchestrators", orchestrators)
        if pas_deployment_link is not None:
            pulumi.set(__self__, "pas_deployment_link", pas_deployment_link)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if risk_explorer_auto_discovery is not None:
            pulumi.set(__self__, "risk_explorer_auto_discovery", risk_explorer_auto_discovery)
        if runtime_policy_name is not None:
            pulumi.set(__self__, "runtime_policy_name", runtime_policy_name)
        if runtime_type is not None:
            pulumi.set(__self__, "runtime_type", runtime_type)
        if sync_host_images is not None:
            pulumi.set(__self__, "sync_host_images", sync_host_images)
        if syscall_enabled is not None:
            pulumi.set(__self__, "syscall_enabled", syscall_enabled)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_access_control is not None:
            pulumi.set(__self__, "user_access_control", user_access_control)

    @property
    @pulumi.getter(name="admissionControl")
    def admission_control(self) -> Optional[pulumi.Input[bool]]:
        """
        Selecting this option will allow the KubeEnforcer to block the deployment of container images that have failed any of these Container Runtime Policy controls:\\
        			* Block Non-Compliant Images\\
        			* Block Non-Compliant Workloads\\
        			* Block Unregistered Images\\
        			This functionality can work only when the KubeEnforcer is deployed in Enforce mode.
        """
        return pulumi.get(self, "admission_control")

    @admission_control.setter
    def admission_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admission_control", value)

    @property
    @pulumi.getter(name="allowKubeEnforcerAudit")
    def allow_kube_enforcer_audit(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow kube enforcer audit.
        """
        return pulumi.get(self, "allow_kube_enforcer_audit")

    @allow_kube_enforcer_audit.setter
    def allow_kube_enforcer_audit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_kube_enforcer_audit", value)

    @property
    @pulumi.getter(name="allowedApplications")
    def allowed_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of application names to allow on the hosts. if provided, only containers of the listed applications will be allowed to run.
        """
        return pulumi.get(self, "allowed_applications")

    @allowed_applications.setter
    def allowed_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_applications", value)

    @property
    @pulumi.getter(name="allowedLabels")
    def allowed_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of label names to allow on the hosts.
        """
        return pulumi.get(self, "allowed_labels")

    @allowed_labels.setter
    def allowed_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_labels", value)

    @property
    @pulumi.getter(name="allowedRegistries")
    def allowed_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of registry names to allow on the hosts.
        """
        return pulumi.get(self, "allowed_registries")

    @allowed_registries.setter
    def allowed_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_registries", value)

    @property
    @pulumi.getter(name="antivirusProtection")
    def antivirus_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Host Runtime policies.
        """
        return pulumi.get(self, "antivirus_protection")

    @antivirus_protection.setter
    def antivirus_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "antivirus_protection", value)

    @property
    @pulumi.getter(name="aquaVersion")
    def aqua_version(self) -> Optional[pulumi.Input[str]]:
        """
        Aqua server version
        """
        return pulumi.get(self, "aqua_version")

    @aqua_version.setter
    def aqua_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aqua_version", value)

    @property
    @pulumi.getter(name="auditAll")
    def audit_all(self) -> Optional[pulumi.Input[bool]]:
        """
        Agent will send extra audit messages to the server for success operations from inside the container (runtime).
        """
        return pulumi.get(self, "audit_all")

    @audit_all.setter
    def audit_all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_all", value)

    @property
    @pulumi.getter(name="autoCopySecrets")
    def auto_copy_secrets(self) -> Optional[pulumi.Input[bool]]:
        """
        This option is applicable only if `Enable Pod Enforcer injection` is selected. Select this option if you want Aqua Enterprise to copy the secrets defined above to the Pod Enforcer namespace and container. Otherwise, you can choose to copy these secrets by other means.
        """
        return pulumi.get(self, "auto_copy_secrets")

    @auto_copy_secrets.setter
    def auto_copy_secrets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_copy_secrets", value)

    @property
    @pulumi.getter(name="autoDiscoverConfigureRegistries")
    def auto_discover_configure_registries(self) -> Optional[pulumi.Input[bool]]:
        """
        This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will add previously unknown image registries from the cluster to Aqua.
        """
        return pulumi.get(self, "auto_discover_configure_registries")

    @auto_discover_configure_registries.setter
    def auto_discover_configure_registries(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_discover_configure_registries", value)

    @property
    @pulumi.getter(name="autoDiscoveryEnabled")
    def auto_discovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When this option is selected, the KubeEnforcer will discover workloads on its cluster.
        """
        return pulumi.get(self, "auto_discovery_enabled")

    @auto_discovery_enabled.setter
    def auto_discovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_discovery_enabled", value)

    @property
    @pulumi.getter(name="autoScanDiscoveredImagesRunningContainers")
    def auto_scan_discovered_images_running_containers(self) -> Optional[pulumi.Input[bool]]:
        """
        This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will automatically register images running as workloads (and scan the discovered images for security issues).
        """
        return pulumi.get(self, "auto_scan_discovered_images_running_containers")

    @auto_scan_discovered_images_running_containers.setter
    def auto_scan_discovered_images_running_containers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_scan_discovered_images_running_containers", value)

    @property
    @pulumi.getter(name="behavioralEngine")
    def behavioral_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        Select Enabled to detect suspicious activity in your containers and display potential security threats in the Incidents and Audit pages.
        """
        return pulumi.get(self, "behavioral_engine")

    @behavioral_engine.setter
    def behavioral_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "behavioral_engine", value)

    @property
    @pulumi.getter(name="blockAdmissionControl")
    def block_admission_control(self) -> Optional[pulumi.Input[bool]]:
        """
        This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        """
        return pulumi.get(self, "block_admission_control")

    @block_admission_control.setter
    def block_admission_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_admission_control", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsCommandArgs']]]]:
        """
        The installation command.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsCommandArgs']]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="connectedCount")
    def connected_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of connected enforcers in the enforcer group.
        """
        return pulumi.get(self, "connected_count")

    @connected_count.setter
    def connected_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connected_count", value)

    @property
    @pulumi.getter(name="containerActivityProtection")
    def container_activity_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to apply Container Runtime Policies, Image Profiles, and Firewall Policies to containers.
        """
        return pulumi.get(self, "container_activity_protection")

    @container_activity_protection.setter
    def container_activity_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "container_activity_protection", value)

    @property
    @pulumi.getter(name="containerAntivirusProtection")
    def container_antivirus_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Container Runtime policies.
        """
        return pulumi.get(self, "container_antivirus_protection")

    @container_antivirus_protection.setter
    def container_antivirus_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "container_antivirus_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the Aqua Enforcer group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disconnectedCount")
    def disconnected_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of disconnected enforcers in the enforcer group.
        """
        return pulumi.get(self, "disconnected_count")

    @disconnected_count.setter
    def disconnected_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disconnected_count", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable enforce mode on the Enforcers, defaults to False.
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce", value)

    @property
    @pulumi.getter(name="enforcerImageName")
    def enforcer_image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The specific Aqua Enforcer product image (with image tag) to be deployed.
        """
        return pulumi.get(self, "enforcer_image_name")

    @enforcer_image_name.setter
    def enforcer_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enforcer_image_name", value)

    @property
    @pulumi.getter
    def forensics(self) -> Optional[pulumi.Input[bool]]:
        """
        Select Enabled to send activity logs in your containers to the Aqua Server for forensics purposes.
        """
        return pulumi.get(self, "forensics")

    @forensics.setter
    def forensics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forensics", value)

    @property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway Address
        """
        return pulumi.get(self, "gateway_address")

    @gateway_address.setter
    def gateway_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_address", value)

    @property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway Name
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_name", value)

    @property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Aqua gateway IDs for the Enforcers.
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gateways", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Enforcer group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="highVulns")
    def high_vulns(self) -> Optional[pulumi.Input[int]]:
        """
        Number of high vulnerabilities in the enforcers that in this enforcer group.
        """
        return pulumi.get(self, "high_vulns")

    @high_vulns.setter
    def high_vulns(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "high_vulns", value)

    @property
    @pulumi.getter(name="hostAssurance")
    def host_assurance(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to enable host scanning and respective Host Assurance controls.
        """
        return pulumi.get(self, "host_assurance")

    @host_assurance.setter
    def host_assurance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_assurance", value)

    @property
    @pulumi.getter(name="hostBehavioralEngine")
    def host_behavioral_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        """
        return pulumi.get(self, "host_behavioral_engine")

    @host_behavioral_engine.setter
    def host_behavioral_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_behavioral_engine", value)

    @property
    @pulumi.getter(name="hostForensics")
    def host_forensics(self) -> Optional[pulumi.Input[bool]]:
        """
        Select Enabled to send activity logs in your host to the Aqua Server for forensics purposes.
        """
        return pulumi.get(self, "host_forensics")

    @host_forensics.setter
    def host_forensics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_forensics", value)

    @property
    @pulumi.getter(name="hostNetworkProtection")
    def host_network_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to apply Firewall Policies to hosts, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information
        """
        return pulumi.get(self, "host_network_protection")

    @host_network_protection.setter
    def host_network_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_network_protection", value)

    @property
    @pulumi.getter(name="hostOs")
    def host_os(self) -> Optional[pulumi.Input[str]]:
        """
        The OS type for the host
        """
        return pulumi.get(self, "host_os")

    @host_os.setter
    def host_os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_os", value)

    @property
    @pulumi.getter(name="hostProtection")
    def host_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to enable all Host Runtime Policy controls except for `OS Users and Groups Allowed` and `OS Users and Groups Blocked`.
        """
        return pulumi.get(self, "host_protection")

    @host_protection.setter
    def host_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_protection", value)

    @property
    @pulumi.getter(name="hostUserProtection")
    def host_user_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        """
        return pulumi.get(self, "host_user_protection")

    @host_user_protection.setter
    def host_user_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_user_protection", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="hostsCount")
    def hosts_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of enforcers in the enforcer group.
        """
        return pulumi.get(self, "hosts_count")

    @hosts_count.setter
    def hosts_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hosts_count", value)

    @property
    @pulumi.getter(name="imageAssurance")
    def image_assurance(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to enable selected controls: Container Runtime Policy (`Block Non-Compliant Images`, `Block Unregistered Images`, and `Registries Allowed`) and Default Image Assurance Policy (`Images Blocked`).
        """
        return pulumi.get(self, "image_assurance")

    @image_assurance.setter
    def image_assurance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "image_assurance", value)

    @property
    @pulumi.getter(name="installCommand")
    def install_command(self) -> Optional[pulumi.Input[str]]:
        """
        Enforcer install command
        """
        return pulumi.get(self, "install_command")

    @install_command.setter
    def install_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "install_command", value)

    @property
    @pulumi.getter(name="kubeBenchImageName")
    def kube_bench_image_name(self) -> Optional[pulumi.Input[str]]:
        """
        See https://docs.aquasec.com/docs/securing-kubernetes-applications#section-configuration-hardening, The KubeEnforcer can deploy the Aqua Security kube-bench open-source product to perform Kubernetes CIS benchmark testing of nodes.
        			This field specifies the path and file name of the kube-bench product image for the KubeEnforcer to deploy; it will be filled in automatically. You can optionally enter a different value.
        """
        return pulumi.get(self, "kube_bench_image_name")

    @kube_bench_image_name.setter
    def kube_bench_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kube_bench_image_name", value)

    @property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> Optional[pulumi.Input[int]]:
        """
        The last date and time the batch token was updated in UNIX time.
        """
        return pulumi.get(self, "last_update")

    @last_update.setter
    def last_update(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "last_update", value)

    @property
    @pulumi.getter(name="logicalName")
    def logical_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the batch install record.
        """
        return pulumi.get(self, "logical_name")

    @logical_name.setter
    def logical_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical_name", value)

    @property
    @pulumi.getter(name="lowVulns")
    def low_vulns(self) -> Optional[pulumi.Input[int]]:
        """
        Number of low vulnerabilities in the enforcers that in this enforcer group.
        """
        return pulumi.get(self, "low_vulns")

    @low_vulns.setter
    def low_vulns(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "low_vulns", value)

    @property
    @pulumi.getter(name="medVulns")
    def med_vulns(self) -> Optional[pulumi.Input[int]]:
        """
        Number of medium vulnerabilities in the enforcers that in this enforcer group.
        """
        return pulumi.get(self, "med_vulns")

    @med_vulns.setter
    def med_vulns(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "med_vulns", value)

    @property
    @pulumi.getter(name="microEnforcerCertsSecretsName")
    def micro_enforcer_certs_secrets_name(self) -> Optional[pulumi.Input[str]]:
        """
        This option is applicable only if `Enable Pod Enforcer injection` is selected.
        """
        return pulumi.get(self, "micro_enforcer_certs_secrets_name")

    @micro_enforcer_certs_secrets_name.setter
    def micro_enforcer_certs_secrets_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "micro_enforcer_certs_secrets_name", value)

    @property
    @pulumi.getter(name="microEnforcerImageName")
    def micro_enforcer_image_name(self) -> Optional[pulumi.Input[str]]:
        """
        This option is applicable only if `Enable Pod Enforcer injection` is selected. This field specifies the path and file name of the KubeEnforcer product image to be deployed; it will be filled in automatically. You can optionally enter a different value.
        """
        return pulumi.get(self, "micro_enforcer_image_name")

    @micro_enforcer_image_name.setter
    def micro_enforcer_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "micro_enforcer_image_name", value)

    @property
    @pulumi.getter(name="microEnforcerInjection")
    def micro_enforcer_injection(self) -> Optional[pulumi.Input[bool]]:
        """
        This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        """
        return pulumi.get(self, "micro_enforcer_injection")

    @micro_enforcer_injection.setter
    def micro_enforcer_injection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "micro_enforcer_injection", value)

    @property
    @pulumi.getter(name="microEnforcerSecretsName")
    def micro_enforcer_secrets_name(self) -> Optional[pulumi.Input[str]]:
        """
        You can specify the name of the secret (in the Aqua namespace) that Aqua copies into the Pod Enforcer namespace and kube-bench, allowing them access to the Pod Enforcer and kube-bench product images, respectively.
        """
        return pulumi.get(self, "micro_enforcer_secrets_name")

    @micro_enforcer_secrets_name.setter
    def micro_enforcer_secrets_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "micro_enforcer_secrets_name", value)

    @property
    @pulumi.getter(name="negVulns")
    def neg_vulns(self) -> Optional[pulumi.Input[int]]:
        """
        Number of negligible vulnerabilities in the enforcers that in this enforcer group.
        """
        return pulumi.get(self, "neg_vulns")

    @neg_vulns.setter
    def neg_vulns(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "neg_vulns", value)

    @property
    @pulumi.getter(name="networkProtection")
    def network_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Send true to apply Firewall Policies to containers, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information.
        """
        return pulumi.get(self, "network_protection")

    @network_protection.setter
    def network_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "network_protection", value)

    @property
    @pulumi.getter
    def orchestrators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsOrchestratorArgs']]]]:
        """
        The orchestrator for which you are creating the Enforcer group.
        """
        return pulumi.get(self, "orchestrators")

    @orchestrators.setter
    def orchestrators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnforcerGroupsOrchestratorArgs']]]]):
        pulumi.set(self, "orchestrators", value)

    @property
    @pulumi.getter(name="pasDeploymentLink")
    def pas_deployment_link(self) -> Optional[pulumi.Input[str]]:
        """
        pas deployment link
        """
        return pulumi.get(self, "pas_deployment_link")

    @pas_deployment_link.setter
    def pas_deployment_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pas_deployment_link", value)

    @property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[str]]:
        """
        Permission Action
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter(name="riskExplorerAutoDiscovery")
    def risk_explorer_auto_discovery(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to allow Enforcers to be discovered in the Risk Explorer.
        """
        return pulumi.get(self, "risk_explorer_auto_discovery")

    @risk_explorer_auto_discovery.setter
    def risk_explorer_auto_discovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "risk_explorer_auto_discovery", value)

    @property
    @pulumi.getter(name="runtimePolicyName")
    def runtime_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Function Runtime Policy that will applay on the nano enforcer.
        """
        return pulumi.get(self, "runtime_policy_name")

    @runtime_policy_name.setter
    def runtime_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_policy_name", value)

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> Optional[pulumi.Input[str]]:
        """
        The container runtime environment.
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_type", value)

    @property
    @pulumi.getter(name="syncHostImages")
    def sync_host_images(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to configure Enforcers to discover local host images. Discovered images will be listed under Images > Host Images, as well as under Infrastructure (in the Images tab for applicable hosts).
        """
        return pulumi.get(self, "sync_host_images")

    @sync_host_images.setter
    def sync_host_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_host_images", value)

    @property
    @pulumi.getter(name="syscallEnabled")
    def syscall_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` will allow profiling and monitoring system calls made by running containers.
        """
        return pulumi.get(self, "syscall_enabled")

    @syscall_enabled.setter
    def syscall_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "syscall_enabled", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The batch install token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Enforcer Type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAccessControl")
    def user_access_control(self) -> Optional[pulumi.Input[bool]]:
        """
        Set `True` to apply User Access Control Policies to containers. Note that Aqua Enforcers must be deployed with the AQUA*RUNC*INTERCEPTION environment variable set to 0 in order to use User Access Control Policies.
        """
        return pulumi.get(self, "user_access_control")

    @user_access_control.setter
    def user_access_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_access_control", value)


class EnforcerGroups(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admission_control: Optional[pulumi.Input[bool]] = None,
                 allow_kube_enforcer_audit: Optional[pulumi.Input[bool]] = None,
                 allowed_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_registries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 antivirus_protection: Optional[pulumi.Input[bool]] = None,
                 audit_all: Optional[pulumi.Input[bool]] = None,
                 auto_copy_secrets: Optional[pulumi.Input[bool]] = None,
                 auto_discover_configure_registries: Optional[pulumi.Input[bool]] = None,
                 auto_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 auto_scan_discovered_images_running_containers: Optional[pulumi.Input[bool]] = None,
                 behavioral_engine: Optional[pulumi.Input[bool]] = None,
                 block_admission_control: Optional[pulumi.Input[bool]] = None,
                 container_activity_protection: Optional[pulumi.Input[bool]] = None,
                 container_antivirus_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 forensics: Optional[pulumi.Input[bool]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 host_assurance: Optional[pulumi.Input[bool]] = None,
                 host_behavioral_engine: Optional[pulumi.Input[bool]] = None,
                 host_forensics: Optional[pulumi.Input[bool]] = None,
                 host_network_protection: Optional[pulumi.Input[bool]] = None,
                 host_os: Optional[pulumi.Input[str]] = None,
                 host_protection: Optional[pulumi.Input[bool]] = None,
                 host_user_protection: Optional[pulumi.Input[bool]] = None,
                 image_assurance: Optional[pulumi.Input[bool]] = None,
                 kube_bench_image_name: Optional[pulumi.Input[str]] = None,
                 logical_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_certs_secrets_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_image_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_injection: Optional[pulumi.Input[bool]] = None,
                 micro_enforcer_secrets_name: Optional[pulumi.Input[str]] = None,
                 network_protection: Optional[pulumi.Input[bool]] = None,
                 orchestrators: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnforcerGroupsOrchestratorArgs']]]]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 risk_explorer_auto_discovery: Optional[pulumi.Input[bool]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 sync_host_images: Optional[pulumi.Input[bool]] = None,
                 syscall_enabled: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_access_control: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        group = aquasec.EnforcerGroups("group",
            antivirus_protection=True,
            container_activity_protection=True,
            container_antivirus_protection=True,
            enforce=True,
            forensics=True,
            group_id="tf-test-enforcer",
            host_assurance=True,
            host_forensics=True,
            host_network_protection=True,
            host_protection=True,
            image_assurance=True,
            network_protection=True,
            orchestrators=[aquasec.EnforcerGroupsOrchestratorArgs()],
            risk_explorer_auto_discovery=True,
            sync_host_images=True,
            type="agent")
        group_kube_enforcer = aquasec.EnforcerGroups("group-kubeEnforcer",
            admission_control=True,
            auto_copy_secrets=True,
            auto_discover_configure_registries=True,
            auto_discovery_enabled=True,
            auto_scan_discovered_images_running_containers=True,
            block_admission_control=True,
            enforce=True,
            group_id="tf-test-kube_enforcer",
            kube_bench_image_name="registry.aquasec.com/kube-bench:v0.6.5",
            micro_enforcer_secrets_name="aqua-registry",
            orchestrators=[aquasec.EnforcerGroupsOrchestratorArgs(
                namespace="aqua",
                type="kubernetes",
            )],
            type="kube_enforcer")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admission_control: Selecting this option will allow the KubeEnforcer to block the deployment of container images that have failed any of these Container Runtime Policy controls:\\
               			* Block Non-Compliant Images\\
               			* Block Non-Compliant Workloads\\
               			* Block Unregistered Images\\
               			This functionality can work only when the KubeEnforcer is deployed in Enforce mode.
        :param pulumi.Input[bool] allow_kube_enforcer_audit: Allow kube enforcer audit.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_applications: List of application names to allow on the hosts. if provided, only containers of the listed applications will be allowed to run.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_labels: List of label names to allow on the hosts.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_registries: List of registry names to allow on the hosts.
        :param pulumi.Input[bool] antivirus_protection: This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Host Runtime policies.
        :param pulumi.Input[bool] audit_all: Agent will send extra audit messages to the server for success operations from inside the container (runtime).
        :param pulumi.Input[bool] auto_copy_secrets: This option is applicable only if `Enable Pod Enforcer injection` is selected. Select this option if you want Aqua Enterprise to copy the secrets defined above to the Pod Enforcer namespace and container. Otherwise, you can choose to copy these secrets by other means.
        :param pulumi.Input[bool] auto_discover_configure_registries: This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will add previously unknown image registries from the cluster to Aqua.
        :param pulumi.Input[bool] auto_discovery_enabled: When this option is selected, the KubeEnforcer will discover workloads on its cluster.
        :param pulumi.Input[bool] auto_scan_discovered_images_running_containers: This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will automatically register images running as workloads (and scan the discovered images for security issues).
        :param pulumi.Input[bool] behavioral_engine: Select Enabled to detect suspicious activity in your containers and display potential security threats in the Incidents and Audit pages.
        :param pulumi.Input[bool] block_admission_control: This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        :param pulumi.Input[bool] container_activity_protection: Set `True` to apply Container Runtime Policies, Image Profiles, and Firewall Policies to containers.
        :param pulumi.Input[bool] container_antivirus_protection: This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Container Runtime policies.
        :param pulumi.Input[str] description: A description of the Aqua Enforcer group.
        :param pulumi.Input[bool] enforce: Whether to enable enforce mode on the Enforcers, defaults to False.
        :param pulumi.Input[bool] forensics: Select Enabled to send activity logs in your containers to the Aqua Server for forensics purposes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: List of Aqua gateway IDs for the Enforcers.
        :param pulumi.Input[str] group_id: The ID of the Enforcer group.
        :param pulumi.Input[bool] host_assurance: Set `True` to enable host scanning and respective Host Assurance controls.
        :param pulumi.Input[bool] host_behavioral_engine: Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        :param pulumi.Input[bool] host_forensics: Select Enabled to send activity logs in your host to the Aqua Server for forensics purposes.
        :param pulumi.Input[bool] host_network_protection: Set `True` to apply Firewall Policies to hosts, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information
        :param pulumi.Input[str] host_os: The OS type for the host
        :param pulumi.Input[bool] host_protection: Set `True` to enable all Host Runtime Policy controls except for `OS Users and Groups Allowed` and `OS Users and Groups Blocked`.
        :param pulumi.Input[bool] host_user_protection: Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        :param pulumi.Input[bool] image_assurance: Set `True` to enable selected controls: Container Runtime Policy (`Block Non-Compliant Images`, `Block Unregistered Images`, and `Registries Allowed`) and Default Image Assurance Policy (`Images Blocked`).
        :param pulumi.Input[str] kube_bench_image_name: See https://docs.aquasec.com/docs/securing-kubernetes-applications#section-configuration-hardening, The KubeEnforcer can deploy the Aqua Security kube-bench open-source product to perform Kubernetes CIS benchmark testing of nodes.
               			This field specifies the path and file name of the kube-bench product image for the KubeEnforcer to deploy; it will be filled in automatically. You can optionally enter a different value.
        :param pulumi.Input[str] logical_name: Name for the batch install record.
        :param pulumi.Input[str] micro_enforcer_certs_secrets_name: This option is applicable only if `Enable Pod Enforcer injection` is selected.
        :param pulumi.Input[str] micro_enforcer_image_name: This option is applicable only if `Enable Pod Enforcer injection` is selected. This field specifies the path and file name of the KubeEnforcer product image to be deployed; it will be filled in automatically. You can optionally enter a different value.
        :param pulumi.Input[bool] micro_enforcer_injection: This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        :param pulumi.Input[str] micro_enforcer_secrets_name: You can specify the name of the secret (in the Aqua namespace) that Aqua copies into the Pod Enforcer namespace and kube-bench, allowing them access to the Pod Enforcer and kube-bench product images, respectively.
        :param pulumi.Input[bool] network_protection: Send true to apply Firewall Policies to containers, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnforcerGroupsOrchestratorArgs']]]] orchestrators: The orchestrator for which you are creating the Enforcer group.
        :param pulumi.Input[str] permission: Permission Action
        :param pulumi.Input[bool] risk_explorer_auto_discovery: Set `True` to allow Enforcers to be discovered in the Risk Explorer.
        :param pulumi.Input[str] runtime_type: The container runtime environment.
        :param pulumi.Input[bool] sync_host_images: Set `True` to configure Enforcers to discover local host images. Discovered images will be listed under Images > Host Images, as well as under Infrastructure (in the Images tab for applicable hosts).
        :param pulumi.Input[bool] syscall_enabled: Set `True` will allow profiling and monitoring system calls made by running containers.
        :param pulumi.Input[str] type: Enforcer Type.
        :param pulumi.Input[bool] user_access_control: Set `True` to apply User Access Control Policies to containers. Note that Aqua Enforcers must be deployed with the AQUA*RUNC*INTERCEPTION environment variable set to 0 in order to use User Access Control Policies.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnforcerGroupsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        group = aquasec.EnforcerGroups("group",
            antivirus_protection=True,
            container_activity_protection=True,
            container_antivirus_protection=True,
            enforce=True,
            forensics=True,
            group_id="tf-test-enforcer",
            host_assurance=True,
            host_forensics=True,
            host_network_protection=True,
            host_protection=True,
            image_assurance=True,
            network_protection=True,
            orchestrators=[aquasec.EnforcerGroupsOrchestratorArgs()],
            risk_explorer_auto_discovery=True,
            sync_host_images=True,
            type="agent")
        group_kube_enforcer = aquasec.EnforcerGroups("group-kubeEnforcer",
            admission_control=True,
            auto_copy_secrets=True,
            auto_discover_configure_registries=True,
            auto_discovery_enabled=True,
            auto_scan_discovered_images_running_containers=True,
            block_admission_control=True,
            enforce=True,
            group_id="tf-test-kube_enforcer",
            kube_bench_image_name="registry.aquasec.com/kube-bench:v0.6.5",
            micro_enforcer_secrets_name="aqua-registry",
            orchestrators=[aquasec.EnforcerGroupsOrchestratorArgs(
                namespace="aqua",
                type="kubernetes",
            )],
            type="kube_enforcer")
        ```

        :param str resource_name: The name of the resource.
        :param EnforcerGroupsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnforcerGroupsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admission_control: Optional[pulumi.Input[bool]] = None,
                 allow_kube_enforcer_audit: Optional[pulumi.Input[bool]] = None,
                 allowed_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_registries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 antivirus_protection: Optional[pulumi.Input[bool]] = None,
                 audit_all: Optional[pulumi.Input[bool]] = None,
                 auto_copy_secrets: Optional[pulumi.Input[bool]] = None,
                 auto_discover_configure_registries: Optional[pulumi.Input[bool]] = None,
                 auto_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 auto_scan_discovered_images_running_containers: Optional[pulumi.Input[bool]] = None,
                 behavioral_engine: Optional[pulumi.Input[bool]] = None,
                 block_admission_control: Optional[pulumi.Input[bool]] = None,
                 container_activity_protection: Optional[pulumi.Input[bool]] = None,
                 container_antivirus_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 forensics: Optional[pulumi.Input[bool]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 host_assurance: Optional[pulumi.Input[bool]] = None,
                 host_behavioral_engine: Optional[pulumi.Input[bool]] = None,
                 host_forensics: Optional[pulumi.Input[bool]] = None,
                 host_network_protection: Optional[pulumi.Input[bool]] = None,
                 host_os: Optional[pulumi.Input[str]] = None,
                 host_protection: Optional[pulumi.Input[bool]] = None,
                 host_user_protection: Optional[pulumi.Input[bool]] = None,
                 image_assurance: Optional[pulumi.Input[bool]] = None,
                 kube_bench_image_name: Optional[pulumi.Input[str]] = None,
                 logical_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_certs_secrets_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_image_name: Optional[pulumi.Input[str]] = None,
                 micro_enforcer_injection: Optional[pulumi.Input[bool]] = None,
                 micro_enforcer_secrets_name: Optional[pulumi.Input[str]] = None,
                 network_protection: Optional[pulumi.Input[bool]] = None,
                 orchestrators: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnforcerGroupsOrchestratorArgs']]]]] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 risk_explorer_auto_discovery: Optional[pulumi.Input[bool]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 sync_host_images: Optional[pulumi.Input[bool]] = None,
                 syscall_enabled: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_access_control: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnforcerGroupsArgs.__new__(EnforcerGroupsArgs)

            __props__.__dict__["admission_control"] = admission_control
            __props__.__dict__["allow_kube_enforcer_audit"] = allow_kube_enforcer_audit
            __props__.__dict__["allowed_applications"] = allowed_applications
            __props__.__dict__["allowed_labels"] = allowed_labels
            __props__.__dict__["allowed_registries"] = allowed_registries
            __props__.__dict__["antivirus_protection"] = antivirus_protection
            __props__.__dict__["audit_all"] = audit_all
            __props__.__dict__["auto_copy_secrets"] = auto_copy_secrets
            __props__.__dict__["auto_discover_configure_registries"] = auto_discover_configure_registries
            __props__.__dict__["auto_discovery_enabled"] = auto_discovery_enabled
            __props__.__dict__["auto_scan_discovered_images_running_containers"] = auto_scan_discovered_images_running_containers
            __props__.__dict__["behavioral_engine"] = behavioral_engine
            __props__.__dict__["block_admission_control"] = block_admission_control
            __props__.__dict__["container_activity_protection"] = container_activity_protection
            __props__.__dict__["container_antivirus_protection"] = container_antivirus_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["enforce"] = enforce
            __props__.__dict__["forensics"] = forensics
            __props__.__dict__["gateways"] = gateways
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["host_assurance"] = host_assurance
            __props__.__dict__["host_behavioral_engine"] = host_behavioral_engine
            __props__.__dict__["host_forensics"] = host_forensics
            __props__.__dict__["host_network_protection"] = host_network_protection
            __props__.__dict__["host_os"] = host_os
            __props__.__dict__["host_protection"] = host_protection
            __props__.__dict__["host_user_protection"] = host_user_protection
            __props__.__dict__["image_assurance"] = image_assurance
            __props__.__dict__["kube_bench_image_name"] = kube_bench_image_name
            __props__.__dict__["logical_name"] = logical_name
            __props__.__dict__["micro_enforcer_certs_secrets_name"] = micro_enforcer_certs_secrets_name
            __props__.__dict__["micro_enforcer_image_name"] = micro_enforcer_image_name
            __props__.__dict__["micro_enforcer_injection"] = micro_enforcer_injection
            __props__.__dict__["micro_enforcer_secrets_name"] = micro_enforcer_secrets_name
            __props__.__dict__["network_protection"] = network_protection
            if orchestrators is None and not opts.urn:
                raise TypeError("Missing required property 'orchestrators'")
            __props__.__dict__["orchestrators"] = orchestrators
            __props__.__dict__["permission"] = permission
            __props__.__dict__["risk_explorer_auto_discovery"] = risk_explorer_auto_discovery
            __props__.__dict__["runtime_type"] = runtime_type
            __props__.__dict__["sync_host_images"] = sync_host_images
            __props__.__dict__["syscall_enabled"] = syscall_enabled
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["user_access_control"] = user_access_control
            __props__.__dict__["aqua_version"] = None
            __props__.__dict__["commands"] = None
            __props__.__dict__["connected_count"] = None
            __props__.__dict__["disconnected_count"] = None
            __props__.__dict__["enforcer_image_name"] = None
            __props__.__dict__["gateway_address"] = None
            __props__.__dict__["gateway_name"] = None
            __props__.__dict__["high_vulns"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["hosts_count"] = None
            __props__.__dict__["install_command"] = None
            __props__.__dict__["last_update"] = None
            __props__.__dict__["low_vulns"] = None
            __props__.__dict__["med_vulns"] = None
            __props__.__dict__["neg_vulns"] = None
            __props__.__dict__["pas_deployment_link"] = None
            __props__.__dict__["runtime_policy_name"] = None
            __props__.__dict__["token"] = None
        super(EnforcerGroups, __self__).__init__(
            'aquasec:index/enforcerGroups:EnforcerGroups',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admission_control: Optional[pulumi.Input[bool]] = None,
            allow_kube_enforcer_audit: Optional[pulumi.Input[bool]] = None,
            allowed_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_registries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            antivirus_protection: Optional[pulumi.Input[bool]] = None,
            aqua_version: Optional[pulumi.Input[str]] = None,
            audit_all: Optional[pulumi.Input[bool]] = None,
            auto_copy_secrets: Optional[pulumi.Input[bool]] = None,
            auto_discover_configure_registries: Optional[pulumi.Input[bool]] = None,
            auto_discovery_enabled: Optional[pulumi.Input[bool]] = None,
            auto_scan_discovered_images_running_containers: Optional[pulumi.Input[bool]] = None,
            behavioral_engine: Optional[pulumi.Input[bool]] = None,
            block_admission_control: Optional[pulumi.Input[bool]] = None,
            commands: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnforcerGroupsCommandArgs']]]]] = None,
            connected_count: Optional[pulumi.Input[int]] = None,
            container_activity_protection: Optional[pulumi.Input[bool]] = None,
            container_antivirus_protection: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disconnected_count: Optional[pulumi.Input[int]] = None,
            enforce: Optional[pulumi.Input[bool]] = None,
            enforcer_image_name: Optional[pulumi.Input[str]] = None,
            forensics: Optional[pulumi.Input[bool]] = None,
            gateway_address: Optional[pulumi.Input[str]] = None,
            gateway_name: Optional[pulumi.Input[str]] = None,
            gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            high_vulns: Optional[pulumi.Input[int]] = None,
            host_assurance: Optional[pulumi.Input[bool]] = None,
            host_behavioral_engine: Optional[pulumi.Input[bool]] = None,
            host_forensics: Optional[pulumi.Input[bool]] = None,
            host_network_protection: Optional[pulumi.Input[bool]] = None,
            host_os: Optional[pulumi.Input[str]] = None,
            host_protection: Optional[pulumi.Input[bool]] = None,
            host_user_protection: Optional[pulumi.Input[bool]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            hosts_count: Optional[pulumi.Input[int]] = None,
            image_assurance: Optional[pulumi.Input[bool]] = None,
            install_command: Optional[pulumi.Input[str]] = None,
            kube_bench_image_name: Optional[pulumi.Input[str]] = None,
            last_update: Optional[pulumi.Input[int]] = None,
            logical_name: Optional[pulumi.Input[str]] = None,
            low_vulns: Optional[pulumi.Input[int]] = None,
            med_vulns: Optional[pulumi.Input[int]] = None,
            micro_enforcer_certs_secrets_name: Optional[pulumi.Input[str]] = None,
            micro_enforcer_image_name: Optional[pulumi.Input[str]] = None,
            micro_enforcer_injection: Optional[pulumi.Input[bool]] = None,
            micro_enforcer_secrets_name: Optional[pulumi.Input[str]] = None,
            neg_vulns: Optional[pulumi.Input[int]] = None,
            network_protection: Optional[pulumi.Input[bool]] = None,
            orchestrators: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnforcerGroupsOrchestratorArgs']]]]] = None,
            pas_deployment_link: Optional[pulumi.Input[str]] = None,
            permission: Optional[pulumi.Input[str]] = None,
            risk_explorer_auto_discovery: Optional[pulumi.Input[bool]] = None,
            runtime_policy_name: Optional[pulumi.Input[str]] = None,
            runtime_type: Optional[pulumi.Input[str]] = None,
            sync_host_images: Optional[pulumi.Input[bool]] = None,
            syscall_enabled: Optional[pulumi.Input[bool]] = None,
            token: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_access_control: Optional[pulumi.Input[bool]] = None) -> 'EnforcerGroups':
        """
        Get an existing EnforcerGroups resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admission_control: Selecting this option will allow the KubeEnforcer to block the deployment of container images that have failed any of these Container Runtime Policy controls:\\
               			* Block Non-Compliant Images\\
               			* Block Non-Compliant Workloads\\
               			* Block Unregistered Images\\
               			This functionality can work only when the KubeEnforcer is deployed in Enforce mode.
        :param pulumi.Input[bool] allow_kube_enforcer_audit: Allow kube enforcer audit.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_applications: List of application names to allow on the hosts. if provided, only containers of the listed applications will be allowed to run.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_labels: List of label names to allow on the hosts.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_registries: List of registry names to allow on the hosts.
        :param pulumi.Input[bool] antivirus_protection: This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Host Runtime policies.
        :param pulumi.Input[str] aqua_version: Aqua server version
        :param pulumi.Input[bool] audit_all: Agent will send extra audit messages to the server for success operations from inside the container (runtime).
        :param pulumi.Input[bool] auto_copy_secrets: This option is applicable only if `Enable Pod Enforcer injection` is selected. Select this option if you want Aqua Enterprise to copy the secrets defined above to the Pod Enforcer namespace and container. Otherwise, you can choose to copy these secrets by other means.
        :param pulumi.Input[bool] auto_discover_configure_registries: This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will add previously unknown image registries from the cluster to Aqua.
        :param pulumi.Input[bool] auto_discovery_enabled: When this option is selected, the KubeEnforcer will discover workloads on its cluster.
        :param pulumi.Input[bool] auto_scan_discovered_images_running_containers: This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will automatically register images running as workloads (and scan the discovered images for security issues).
        :param pulumi.Input[bool] behavioral_engine: Select Enabled to detect suspicious activity in your containers and display potential security threats in the Incidents and Audit pages.
        :param pulumi.Input[bool] block_admission_control: This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnforcerGroupsCommandArgs']]]] commands: The installation command.
        :param pulumi.Input[int] connected_count: Number of connected enforcers in the enforcer group.
        :param pulumi.Input[bool] container_activity_protection: Set `True` to apply Container Runtime Policies, Image Profiles, and Firewall Policies to containers.
        :param pulumi.Input[bool] container_antivirus_protection: This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Container Runtime policies.
        :param pulumi.Input[str] description: A description of the Aqua Enforcer group.
        :param pulumi.Input[int] disconnected_count: Number of disconnected enforcers in the enforcer group.
        :param pulumi.Input[bool] enforce: Whether to enable enforce mode on the Enforcers, defaults to False.
        :param pulumi.Input[str] enforcer_image_name: The specific Aqua Enforcer product image (with image tag) to be deployed.
        :param pulumi.Input[bool] forensics: Select Enabled to send activity logs in your containers to the Aqua Server for forensics purposes.
        :param pulumi.Input[str] gateway_address: Gateway Address
        :param pulumi.Input[str] gateway_name: Gateway Name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gateways: List of Aqua gateway IDs for the Enforcers.
        :param pulumi.Input[str] group_id: The ID of the Enforcer group.
        :param pulumi.Input[int] high_vulns: Number of high vulnerabilities in the enforcers that in this enforcer group.
        :param pulumi.Input[bool] host_assurance: Set `True` to enable host scanning and respective Host Assurance controls.
        :param pulumi.Input[bool] host_behavioral_engine: Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        :param pulumi.Input[bool] host_forensics: Select Enabled to send activity logs in your host to the Aqua Server for forensics purposes.
        :param pulumi.Input[bool] host_network_protection: Set `True` to apply Firewall Policies to hosts, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information
        :param pulumi.Input[str] host_os: The OS type for the host
        :param pulumi.Input[bool] host_protection: Set `True` to enable all Host Runtime Policy controls except for `OS Users and Groups Allowed` and `OS Users and Groups Blocked`.
        :param pulumi.Input[bool] host_user_protection: Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        :param pulumi.Input[str] hostname: The hostname
        :param pulumi.Input[int] hosts_count: Number of enforcers in the enforcer group.
        :param pulumi.Input[bool] image_assurance: Set `True` to enable selected controls: Container Runtime Policy (`Block Non-Compliant Images`, `Block Unregistered Images`, and `Registries Allowed`) and Default Image Assurance Policy (`Images Blocked`).
        :param pulumi.Input[str] install_command: Enforcer install command
        :param pulumi.Input[str] kube_bench_image_name: See https://docs.aquasec.com/docs/securing-kubernetes-applications#section-configuration-hardening, The KubeEnforcer can deploy the Aqua Security kube-bench open-source product to perform Kubernetes CIS benchmark testing of nodes.
               			This field specifies the path and file name of the kube-bench product image for the KubeEnforcer to deploy; it will be filled in automatically. You can optionally enter a different value.
        :param pulumi.Input[int] last_update: The last date and time the batch token was updated in UNIX time.
        :param pulumi.Input[str] logical_name: Name for the batch install record.
        :param pulumi.Input[int] low_vulns: Number of low vulnerabilities in the enforcers that in this enforcer group.
        :param pulumi.Input[int] med_vulns: Number of medium vulnerabilities in the enforcers that in this enforcer group.
        :param pulumi.Input[str] micro_enforcer_certs_secrets_name: This option is applicable only if `Enable Pod Enforcer injection` is selected.
        :param pulumi.Input[str] micro_enforcer_image_name: This option is applicable only if `Enable Pod Enforcer injection` is selected. This field specifies the path and file name of the KubeEnforcer product image to be deployed; it will be filled in automatically. You can optionally enter a different value.
        :param pulumi.Input[bool] micro_enforcer_injection: This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        :param pulumi.Input[str] micro_enforcer_secrets_name: You can specify the name of the secret (in the Aqua namespace) that Aqua copies into the Pod Enforcer namespace and kube-bench, allowing them access to the Pod Enforcer and kube-bench product images, respectively.
        :param pulumi.Input[int] neg_vulns: Number of negligible vulnerabilities in the enforcers that in this enforcer group.
        :param pulumi.Input[bool] network_protection: Send true to apply Firewall Policies to containers, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnforcerGroupsOrchestratorArgs']]]] orchestrators: The orchestrator for which you are creating the Enforcer group.
        :param pulumi.Input[str] pas_deployment_link: pas deployment link
        :param pulumi.Input[str] permission: Permission Action
        :param pulumi.Input[bool] risk_explorer_auto_discovery: Set `True` to allow Enforcers to be discovered in the Risk Explorer.
        :param pulumi.Input[str] runtime_policy_name: Function Runtime Policy that will applay on the nano enforcer.
        :param pulumi.Input[str] runtime_type: The container runtime environment.
        :param pulumi.Input[bool] sync_host_images: Set `True` to configure Enforcers to discover local host images. Discovered images will be listed under Images > Host Images, as well as under Infrastructure (in the Images tab for applicable hosts).
        :param pulumi.Input[bool] syscall_enabled: Set `True` will allow profiling and monitoring system calls made by running containers.
        :param pulumi.Input[str] token: The batch install token.
        :param pulumi.Input[str] type: Enforcer Type.
        :param pulumi.Input[bool] user_access_control: Set `True` to apply User Access Control Policies to containers. Note that Aqua Enforcers must be deployed with the AQUA*RUNC*INTERCEPTION environment variable set to 0 in order to use User Access Control Policies.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnforcerGroupsState.__new__(_EnforcerGroupsState)

        __props__.__dict__["admission_control"] = admission_control
        __props__.__dict__["allow_kube_enforcer_audit"] = allow_kube_enforcer_audit
        __props__.__dict__["allowed_applications"] = allowed_applications
        __props__.__dict__["allowed_labels"] = allowed_labels
        __props__.__dict__["allowed_registries"] = allowed_registries
        __props__.__dict__["antivirus_protection"] = antivirus_protection
        __props__.__dict__["aqua_version"] = aqua_version
        __props__.__dict__["audit_all"] = audit_all
        __props__.__dict__["auto_copy_secrets"] = auto_copy_secrets
        __props__.__dict__["auto_discover_configure_registries"] = auto_discover_configure_registries
        __props__.__dict__["auto_discovery_enabled"] = auto_discovery_enabled
        __props__.__dict__["auto_scan_discovered_images_running_containers"] = auto_scan_discovered_images_running_containers
        __props__.__dict__["behavioral_engine"] = behavioral_engine
        __props__.__dict__["block_admission_control"] = block_admission_control
        __props__.__dict__["commands"] = commands
        __props__.__dict__["connected_count"] = connected_count
        __props__.__dict__["container_activity_protection"] = container_activity_protection
        __props__.__dict__["container_antivirus_protection"] = container_antivirus_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["disconnected_count"] = disconnected_count
        __props__.__dict__["enforce"] = enforce
        __props__.__dict__["enforcer_image_name"] = enforcer_image_name
        __props__.__dict__["forensics"] = forensics
        __props__.__dict__["gateway_address"] = gateway_address
        __props__.__dict__["gateway_name"] = gateway_name
        __props__.__dict__["gateways"] = gateways
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["high_vulns"] = high_vulns
        __props__.__dict__["host_assurance"] = host_assurance
        __props__.__dict__["host_behavioral_engine"] = host_behavioral_engine
        __props__.__dict__["host_forensics"] = host_forensics
        __props__.__dict__["host_network_protection"] = host_network_protection
        __props__.__dict__["host_os"] = host_os
        __props__.__dict__["host_protection"] = host_protection
        __props__.__dict__["host_user_protection"] = host_user_protection
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["hosts_count"] = hosts_count
        __props__.__dict__["image_assurance"] = image_assurance
        __props__.__dict__["install_command"] = install_command
        __props__.__dict__["kube_bench_image_name"] = kube_bench_image_name
        __props__.__dict__["last_update"] = last_update
        __props__.__dict__["logical_name"] = logical_name
        __props__.__dict__["low_vulns"] = low_vulns
        __props__.__dict__["med_vulns"] = med_vulns
        __props__.__dict__["micro_enforcer_certs_secrets_name"] = micro_enforcer_certs_secrets_name
        __props__.__dict__["micro_enforcer_image_name"] = micro_enforcer_image_name
        __props__.__dict__["micro_enforcer_injection"] = micro_enforcer_injection
        __props__.__dict__["micro_enforcer_secrets_name"] = micro_enforcer_secrets_name
        __props__.__dict__["neg_vulns"] = neg_vulns
        __props__.__dict__["network_protection"] = network_protection
        __props__.__dict__["orchestrators"] = orchestrators
        __props__.__dict__["pas_deployment_link"] = pas_deployment_link
        __props__.__dict__["permission"] = permission
        __props__.__dict__["risk_explorer_auto_discovery"] = risk_explorer_auto_discovery
        __props__.__dict__["runtime_policy_name"] = runtime_policy_name
        __props__.__dict__["runtime_type"] = runtime_type
        __props__.__dict__["sync_host_images"] = sync_host_images
        __props__.__dict__["syscall_enabled"] = syscall_enabled
        __props__.__dict__["token"] = token
        __props__.__dict__["type"] = type
        __props__.__dict__["user_access_control"] = user_access_control
        return EnforcerGroups(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="admissionControl")
    def admission_control(self) -> pulumi.Output[Optional[bool]]:
        """
        Selecting this option will allow the KubeEnforcer to block the deployment of container images that have failed any of these Container Runtime Policy controls:\\
        			* Block Non-Compliant Images\\
        			* Block Non-Compliant Workloads\\
        			* Block Unregistered Images\\
        			This functionality can work only when the KubeEnforcer is deployed in Enforce mode.
        """
        return pulumi.get(self, "admission_control")

    @property
    @pulumi.getter(name="allowKubeEnforcerAudit")
    def allow_kube_enforcer_audit(self) -> pulumi.Output[Optional[bool]]:
        """
        Allow kube enforcer audit.
        """
        return pulumi.get(self, "allow_kube_enforcer_audit")

    @property
    @pulumi.getter(name="allowedApplications")
    def allowed_applications(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of application names to allow on the hosts. if provided, only containers of the listed applications will be allowed to run.
        """
        return pulumi.get(self, "allowed_applications")

    @property
    @pulumi.getter(name="allowedLabels")
    def allowed_labels(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of label names to allow on the hosts.
        """
        return pulumi.get(self, "allowed_labels")

    @property
    @pulumi.getter(name="allowedRegistries")
    def allowed_registries(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of registry names to allow on the hosts.
        """
        return pulumi.get(self, "allowed_registries")

    @property
    @pulumi.getter(name="antivirusProtection")
    def antivirus_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Host Runtime policies.
        """
        return pulumi.get(self, "antivirus_protection")

    @property
    @pulumi.getter(name="aquaVersion")
    def aqua_version(self) -> pulumi.Output[str]:
        """
        Aqua server version
        """
        return pulumi.get(self, "aqua_version")

    @property
    @pulumi.getter(name="auditAll")
    def audit_all(self) -> pulumi.Output[Optional[bool]]:
        """
        Agent will send extra audit messages to the server for success operations from inside the container (runtime).
        """
        return pulumi.get(self, "audit_all")

    @property
    @pulumi.getter(name="autoCopySecrets")
    def auto_copy_secrets(self) -> pulumi.Output[bool]:
        """
        This option is applicable only if `Enable Pod Enforcer injection` is selected. Select this option if you want Aqua Enterprise to copy the secrets defined above to the Pod Enforcer namespace and container. Otherwise, you can choose to copy these secrets by other means.
        """
        return pulumi.get(self, "auto_copy_secrets")

    @property
    @pulumi.getter(name="autoDiscoverConfigureRegistries")
    def auto_discover_configure_registries(self) -> pulumi.Output[Optional[bool]]:
        """
        This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will add previously unknown image registries from the cluster to Aqua.
        """
        return pulumi.get(self, "auto_discover_configure_registries")

    @property
    @pulumi.getter(name="autoDiscoveryEnabled")
    def auto_discovery_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        When this option is selected, the KubeEnforcer will discover workloads on its cluster.
        """
        return pulumi.get(self, "auto_discovery_enabled")

    @property
    @pulumi.getter(name="autoScanDiscoveredImagesRunningContainers")
    def auto_scan_discovered_images_running_containers(self) -> pulumi.Output[Optional[bool]]:
        """
        This option is available only if `Enable workload discovery` is selected. If selected, the KubeEnforcer will automatically register images running as workloads (and scan the discovered images for security issues).
        """
        return pulumi.get(self, "auto_scan_discovered_images_running_containers")

    @property
    @pulumi.getter(name="behavioralEngine")
    def behavioral_engine(self) -> pulumi.Output[Optional[bool]]:
        """
        Select Enabled to detect suspicious activity in your containers and display potential security threats in the Incidents and Audit pages.
        """
        return pulumi.get(self, "behavioral_engine")

    @property
    @pulumi.getter(name="blockAdmissionControl")
    def block_admission_control(self) -> pulumi.Output[Optional[bool]]:
        """
        This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        """
        return pulumi.get(self, "block_admission_control")

    @property
    @pulumi.getter
    def commands(self) -> pulumi.Output[Sequence['outputs.EnforcerGroupsCommand']]:
        """
        The installation command.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="connectedCount")
    def connected_count(self) -> pulumi.Output[int]:
        """
        Number of connected enforcers in the enforcer group.
        """
        return pulumi.get(self, "connected_count")

    @property
    @pulumi.getter(name="containerActivityProtection")
    def container_activity_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` to apply Container Runtime Policies, Image Profiles, and Firewall Policies to containers.
        """
        return pulumi.get(self, "container_activity_protection")

    @property
    @pulumi.getter(name="containerAntivirusProtection")
    def container_antivirus_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        This setting is available only when you have license for `Advanced Malware Protection`. Send true to make use of the license and enable the `Real-time Malware Protection` control in the Container Runtime policies.
        """
        return pulumi.get(self, "container_antivirus_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the Aqua Enforcer group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disconnectedCount")
    def disconnected_count(self) -> pulumi.Output[int]:
        """
        Number of disconnected enforcers in the enforcer group.
        """
        return pulumi.get(self, "disconnected_count")

    @property
    @pulumi.getter
    def enforce(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable enforce mode on the Enforcers, defaults to False.
        """
        return pulumi.get(self, "enforce")

    @property
    @pulumi.getter(name="enforcerImageName")
    def enforcer_image_name(self) -> pulumi.Output[str]:
        """
        The specific Aqua Enforcer product image (with image tag) to be deployed.
        """
        return pulumi.get(self, "enforcer_image_name")

    @property
    @pulumi.getter
    def forensics(self) -> pulumi.Output[Optional[bool]]:
        """
        Select Enabled to send activity logs in your containers to the Aqua Server for forensics purposes.
        """
        return pulumi.get(self, "forensics")

    @property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> pulumi.Output[str]:
        """
        Gateway Address
        """
        return pulumi.get(self, "gateway_address")

    @property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Output[str]:
        """
        Gateway Name
        """
        return pulumi.get(self, "gateway_name")

    @property
    @pulumi.getter
    def gateways(self) -> pulumi.Output[Sequence[str]]:
        """
        List of Aqua gateway IDs for the Enforcers.
        """
        return pulumi.get(self, "gateways")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        The ID of the Enforcer group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="highVulns")
    def high_vulns(self) -> pulumi.Output[int]:
        """
        Number of high vulnerabilities in the enforcers that in this enforcer group.
        """
        return pulumi.get(self, "high_vulns")

    @property
    @pulumi.getter(name="hostAssurance")
    def host_assurance(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` to enable host scanning and respective Host Assurance controls.
        """
        return pulumi.get(self, "host_assurance")

    @property
    @pulumi.getter(name="hostBehavioralEngine")
    def host_behavioral_engine(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        """
        return pulumi.get(self, "host_behavioral_engine")

    @property
    @pulumi.getter(name="hostForensics")
    def host_forensics(self) -> pulumi.Output[Optional[bool]]:
        """
        Select Enabled to send activity logs in your host to the Aqua Server for forensics purposes.
        """
        return pulumi.get(self, "host_forensics")

    @property
    @pulumi.getter(name="hostNetworkProtection")
    def host_network_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` to apply Firewall Policies to hosts, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information
        """
        return pulumi.get(self, "host_network_protection")

    @property
    @pulumi.getter(name="hostOs")
    def host_os(self) -> pulumi.Output[str]:
        """
        The OS type for the host
        """
        return pulumi.get(self, "host_os")

    @property
    @pulumi.getter(name="hostProtection")
    def host_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` to enable all Host Runtime Policy controls except for `OS Users and Groups Allowed` and `OS Users and Groups Blocked`.
        """
        return pulumi.get(self, "host_protection")

    @property
    @pulumi.getter(name="hostUserProtection")
    def host_user_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` to enable these Host Runtime Policy controls: `OS Users and Groups Allowed` and `OS Users and Groups Blocked`
        """
        return pulumi.get(self, "host_user_protection")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The hostname
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="hostsCount")
    def hosts_count(self) -> pulumi.Output[int]:
        """
        Number of enforcers in the enforcer group.
        """
        return pulumi.get(self, "hosts_count")

    @property
    @pulumi.getter(name="imageAssurance")
    def image_assurance(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` to enable selected controls: Container Runtime Policy (`Block Non-Compliant Images`, `Block Unregistered Images`, and `Registries Allowed`) and Default Image Assurance Policy (`Images Blocked`).
        """
        return pulumi.get(self, "image_assurance")

    @property
    @pulumi.getter(name="installCommand")
    def install_command(self) -> pulumi.Output[str]:
        """
        Enforcer install command
        """
        return pulumi.get(self, "install_command")

    @property
    @pulumi.getter(name="kubeBenchImageName")
    def kube_bench_image_name(self) -> pulumi.Output[str]:
        """
        See https://docs.aquasec.com/docs/securing-kubernetes-applications#section-configuration-hardening, The KubeEnforcer can deploy the Aqua Security kube-bench open-source product to perform Kubernetes CIS benchmark testing of nodes.
        			This field specifies the path and file name of the kube-bench product image for the KubeEnforcer to deploy; it will be filled in automatically. You can optionally enter a different value.
        """
        return pulumi.get(self, "kube_bench_image_name")

    @property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> pulumi.Output[int]:
        """
        The last date and time the batch token was updated in UNIX time.
        """
        return pulumi.get(self, "last_update")

    @property
    @pulumi.getter(name="logicalName")
    def logical_name(self) -> pulumi.Output[str]:
        """
        Name for the batch install record.
        """
        return pulumi.get(self, "logical_name")

    @property
    @pulumi.getter(name="lowVulns")
    def low_vulns(self) -> pulumi.Output[int]:
        """
        Number of low vulnerabilities in the enforcers that in this enforcer group.
        """
        return pulumi.get(self, "low_vulns")

    @property
    @pulumi.getter(name="medVulns")
    def med_vulns(self) -> pulumi.Output[int]:
        """
        Number of medium vulnerabilities in the enforcers that in this enforcer group.
        """
        return pulumi.get(self, "med_vulns")

    @property
    @pulumi.getter(name="microEnforcerCertsSecretsName")
    def micro_enforcer_certs_secrets_name(self) -> pulumi.Output[Optional[str]]:
        """
        This option is applicable only if `Enable Pod Enforcer injection` is selected.
        """
        return pulumi.get(self, "micro_enforcer_certs_secrets_name")

    @property
    @pulumi.getter(name="microEnforcerImageName")
    def micro_enforcer_image_name(self) -> pulumi.Output[str]:
        """
        This option is applicable only if `Enable Pod Enforcer injection` is selected. This field specifies the path and file name of the KubeEnforcer product image to be deployed; it will be filled in automatically. You can optionally enter a different value.
        """
        return pulumi.get(self, "micro_enforcer_image_name")

    @property
    @pulumi.getter(name="microEnforcerInjection")
    def micro_enforcer_injection(self) -> pulumi.Output[Optional[bool]]:
        """
        This applies only if both `Enable admission control` and Enforce mode are set. This additional option must be selected for admission control to work if the KubeEnforcer is not connected to any Gateway. If this option is not selected, admission control will be disabled; this will have no effect on containers already running.
        """
        return pulumi.get(self, "micro_enforcer_injection")

    @property
    @pulumi.getter(name="microEnforcerSecretsName")
    def micro_enforcer_secrets_name(self) -> pulumi.Output[str]:
        """
        You can specify the name of the secret (in the Aqua namespace) that Aqua copies into the Pod Enforcer namespace and kube-bench, allowing them access to the Pod Enforcer and kube-bench product images, respectively.
        """
        return pulumi.get(self, "micro_enforcer_secrets_name")

    @property
    @pulumi.getter(name="negVulns")
    def neg_vulns(self) -> pulumi.Output[int]:
        """
        Number of negligible vulnerabilities in the enforcers that in this enforcer group.
        """
        return pulumi.get(self, "neg_vulns")

    @property
    @pulumi.getter(name="networkProtection")
    def network_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Send true to apply Firewall Policies to containers, and allow recording network maps for Aqua services. The Network Firewall setting must be disabled when deploying the Aqua Enforcer on a machine running Rocky Linux. See https://docs.aquasec.com/docs/platform-support-limitations-rocky-linux for further information.
        """
        return pulumi.get(self, "network_protection")

    @property
    @pulumi.getter
    def orchestrators(self) -> pulumi.Output[Sequence['outputs.EnforcerGroupsOrchestrator']]:
        """
        The orchestrator for which you are creating the Enforcer group.
        """
        return pulumi.get(self, "orchestrators")

    @property
    @pulumi.getter(name="pasDeploymentLink")
    def pas_deployment_link(self) -> pulumi.Output[str]:
        """
        pas deployment link
        """
        return pulumi.get(self, "pas_deployment_link")

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Output[Optional[str]]:
        """
        Permission Action
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter(name="riskExplorerAutoDiscovery")
    def risk_explorer_auto_discovery(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` to allow Enforcers to be discovered in the Risk Explorer.
        """
        return pulumi.get(self, "risk_explorer_auto_discovery")

    @property
    @pulumi.getter(name="runtimePolicyName")
    def runtime_policy_name(self) -> pulumi.Output[str]:
        """
        Function Runtime Policy that will applay on the nano enforcer.
        """
        return pulumi.get(self, "runtime_policy_name")

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> pulumi.Output[str]:
        """
        The container runtime environment.
        """
        return pulumi.get(self, "runtime_type")

    @property
    @pulumi.getter(name="syncHostImages")
    def sync_host_images(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` to configure Enforcers to discover local host images. Discovered images will be listed under Images > Host Images, as well as under Infrastructure (in the Images tab for applicable hosts).
        """
        return pulumi.get(self, "sync_host_images")

    @property
    @pulumi.getter(name="syscallEnabled")
    def syscall_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` will allow profiling and monitoring system calls made by running containers.
        """
        return pulumi.get(self, "syscall_enabled")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        The batch install token.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Enforcer Type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAccessControl")
    def user_access_control(self) -> pulumi.Output[Optional[bool]]:
        """
        Set `True` to apply User Access Control Policies to containers. Note that Aqua Enforcers must be deployed with the AQUA*RUNC*INTERCEPTION environment variable set to 0 in order to use User Access Control Policies.
        """
        return pulumi.get(self, "user_access_control")

