# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetGatewaysResult',
    'AwaitableGetGatewaysResult',
    'get_gateways',
]

@pulumi.output_type
class GetGatewaysResult:
    """
    A collection of values returned by getGateways.
    """
    def __init__(__self__, gateways=None, id=None):
        if gateways and not isinstance(gateways, list):
            raise TypeError("Expected argument 'gateways' to be a list")
        pulumi.set(__self__, "gateways", gateways)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def gateways(self) -> Sequence['outputs.GetGatewaysGatewayResult']:
        """
        A list of existing gateways' parameters.
        """
        return pulumi.get(self, "gateways")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetGatewaysResult(GetGatewaysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewaysResult(
            gateways=self.gateways,
            id=self.id)


def get_gateways(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewaysResult:
    """
    The data source _get_gateways_ provides a method to query all gateways within the Aqua

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aquasec as aquasec

    testgateway = aquasec.get_gateways()
    pulumi.export("gatewayData", testgateway)
    pulumi.export("gatewayName", testgateway.gateways[0].id)
    pulumi.export("gatewayStatus", testgateway.gateways[0].status)
    pulumi.export("gatewayDescription", testgateway.gateways[0].description)
    pulumi.export("gatewayVersion", testgateway.gateways[0].version)
    pulumi.export("gatewayHostname", testgateway.gateways[0].hostname)
    pulumi.export("gatewayGrpcAddress", testgateway.gateways[0].grpc_address)
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aquasec:index/getGateways:getGateways', __args__, opts=opts, typ=GetGatewaysResult).value

    return AwaitableGetGatewaysResult(
        gateways=__ret__.gateways,
        id=__ret__.id)
