# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoleMappingArgs', 'RoleMapping']

@pulumi.input_type
class RoleMappingArgs:
    def __init__(__self__, *,
                 ldap: Optional[pulumi.Input['RoleMappingLdapArgs']] = None,
                 oauth2: Optional[pulumi.Input['RoleMappingOauth2Args']] = None,
                 openid: Optional[pulumi.Input['RoleMappingOpenidArgs']] = None,
                 saml: Optional[pulumi.Input['RoleMappingSamlArgs']] = None):
        """
        The set of arguments for constructing a RoleMapping resource.
        :param pulumi.Input['RoleMappingLdapArgs'] ldap: LDAP Authentication
        :param pulumi.Input['RoleMappingOauth2Args'] oauth2: Oauth2 Authentication
        :param pulumi.Input['RoleMappingOpenidArgs'] openid: OpenId Authentication
        :param pulumi.Input['RoleMappingSamlArgs'] saml: SAML Authentication
        """
        if ldap is not None:
            pulumi.set(__self__, "ldap", ldap)
        if oauth2 is not None:
            pulumi.set(__self__, "oauth2", oauth2)
        if openid is not None:
            pulumi.set(__self__, "openid", openid)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)

    @property
    @pulumi.getter
    def ldap(self) -> Optional[pulumi.Input['RoleMappingLdapArgs']]:
        """
        LDAP Authentication
        """
        return pulumi.get(self, "ldap")

    @ldap.setter
    def ldap(self, value: Optional[pulumi.Input['RoleMappingLdapArgs']]):
        pulumi.set(self, "ldap", value)

    @property
    @pulumi.getter
    def oauth2(self) -> Optional[pulumi.Input['RoleMappingOauth2Args']]:
        """
        Oauth2 Authentication
        """
        return pulumi.get(self, "oauth2")

    @oauth2.setter
    def oauth2(self, value: Optional[pulumi.Input['RoleMappingOauth2Args']]):
        pulumi.set(self, "oauth2", value)

    @property
    @pulumi.getter
    def openid(self) -> Optional[pulumi.Input['RoleMappingOpenidArgs']]:
        """
        OpenId Authentication
        """
        return pulumi.get(self, "openid")

    @openid.setter
    def openid(self, value: Optional[pulumi.Input['RoleMappingOpenidArgs']]):
        pulumi.set(self, "openid", value)

    @property
    @pulumi.getter
    def saml(self) -> Optional[pulumi.Input['RoleMappingSamlArgs']]:
        """
        SAML Authentication
        """
        return pulumi.get(self, "saml")

    @saml.setter
    def saml(self, value: Optional[pulumi.Input['RoleMappingSamlArgs']]):
        pulumi.set(self, "saml", value)


@pulumi.input_type
class _RoleMappingState:
    def __init__(__self__, *,
                 ldap: Optional[pulumi.Input['RoleMappingLdapArgs']] = None,
                 oauth2: Optional[pulumi.Input['RoleMappingOauth2Args']] = None,
                 openid: Optional[pulumi.Input['RoleMappingOpenidArgs']] = None,
                 saml: Optional[pulumi.Input['RoleMappingSamlArgs']] = None):
        """
        Input properties used for looking up and filtering RoleMapping resources.
        :param pulumi.Input['RoleMappingLdapArgs'] ldap: LDAP Authentication
        :param pulumi.Input['RoleMappingOauth2Args'] oauth2: Oauth2 Authentication
        :param pulumi.Input['RoleMappingOpenidArgs'] openid: OpenId Authentication
        :param pulumi.Input['RoleMappingSamlArgs'] saml: SAML Authentication
        """
        if ldap is not None:
            pulumi.set(__self__, "ldap", ldap)
        if oauth2 is not None:
            pulumi.set(__self__, "oauth2", oauth2)
        if openid is not None:
            pulumi.set(__self__, "openid", openid)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)

    @property
    @pulumi.getter
    def ldap(self) -> Optional[pulumi.Input['RoleMappingLdapArgs']]:
        """
        LDAP Authentication
        """
        return pulumi.get(self, "ldap")

    @ldap.setter
    def ldap(self, value: Optional[pulumi.Input['RoleMappingLdapArgs']]):
        pulumi.set(self, "ldap", value)

    @property
    @pulumi.getter
    def oauth2(self) -> Optional[pulumi.Input['RoleMappingOauth2Args']]:
        """
        Oauth2 Authentication
        """
        return pulumi.get(self, "oauth2")

    @oauth2.setter
    def oauth2(self, value: Optional[pulumi.Input['RoleMappingOauth2Args']]):
        pulumi.set(self, "oauth2", value)

    @property
    @pulumi.getter
    def openid(self) -> Optional[pulumi.Input['RoleMappingOpenidArgs']]:
        """
        OpenId Authentication
        """
        return pulumi.get(self, "openid")

    @openid.setter
    def openid(self, value: Optional[pulumi.Input['RoleMappingOpenidArgs']]):
        pulumi.set(self, "openid", value)

    @property
    @pulumi.getter
    def saml(self) -> Optional[pulumi.Input['RoleMappingSamlArgs']]:
        """
        SAML Authentication
        """
        return pulumi.get(self, "saml")

    @saml.setter
    def saml(self, value: Optional[pulumi.Input['RoleMappingSamlArgs']]):
        pulumi.set(self, "saml", value)


class RoleMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ldap: Optional[pulumi.Input[pulumi.InputType['RoleMappingLdapArgs']]] = None,
                 oauth2: Optional[pulumi.Input[pulumi.InputType['RoleMappingOauth2Args']]] = None,
                 openid: Optional[pulumi.Input[pulumi.InputType['RoleMappingOpenidArgs']]] = None,
                 saml: Optional[pulumi.Input[pulumi.InputType['RoleMappingSamlArgs']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        role_mapping_role_mapping = aquasec.RoleMapping("roleMappingRoleMapping", saml=aquasec.RoleMappingSamlArgs(
            role_mapping={
                "Administrator": "group1",
            },
        ))
        pulumi.export("roleMapping", role_mapping_role_mapping)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['RoleMappingLdapArgs']] ldap: LDAP Authentication
        :param pulumi.Input[pulumi.InputType['RoleMappingOauth2Args']] oauth2: Oauth2 Authentication
        :param pulumi.Input[pulumi.InputType['RoleMappingOpenidArgs']] openid: OpenId Authentication
        :param pulumi.Input[pulumi.InputType['RoleMappingSamlArgs']] saml: SAML Authentication
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RoleMappingArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        role_mapping_role_mapping = aquasec.RoleMapping("roleMappingRoleMapping", saml=aquasec.RoleMappingSamlArgs(
            role_mapping={
                "Administrator": "group1",
            },
        ))
        pulumi.export("roleMapping", role_mapping_role_mapping)
        ```

        :param str resource_name: The name of the resource.
        :param RoleMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ldap: Optional[pulumi.Input[pulumi.InputType['RoleMappingLdapArgs']]] = None,
                 oauth2: Optional[pulumi.Input[pulumi.InputType['RoleMappingOauth2Args']]] = None,
                 openid: Optional[pulumi.Input[pulumi.InputType['RoleMappingOpenidArgs']]] = None,
                 saml: Optional[pulumi.Input[pulumi.InputType['RoleMappingSamlArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleMappingArgs.__new__(RoleMappingArgs)

            __props__.__dict__["ldap"] = ldap
            __props__.__dict__["oauth2"] = oauth2
            __props__.__dict__["openid"] = openid
            __props__.__dict__["saml"] = saml
        super(RoleMapping, __self__).__init__(
            'aquasec:index/roleMapping:RoleMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ldap: Optional[pulumi.Input[pulumi.InputType['RoleMappingLdapArgs']]] = None,
            oauth2: Optional[pulumi.Input[pulumi.InputType['RoleMappingOauth2Args']]] = None,
            openid: Optional[pulumi.Input[pulumi.InputType['RoleMappingOpenidArgs']]] = None,
            saml: Optional[pulumi.Input[pulumi.InputType['RoleMappingSamlArgs']]] = None) -> 'RoleMapping':
        """
        Get an existing RoleMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['RoleMappingLdapArgs']] ldap: LDAP Authentication
        :param pulumi.Input[pulumi.InputType['RoleMappingOauth2Args']] oauth2: Oauth2 Authentication
        :param pulumi.Input[pulumi.InputType['RoleMappingOpenidArgs']] openid: OpenId Authentication
        :param pulumi.Input[pulumi.InputType['RoleMappingSamlArgs']] saml: SAML Authentication
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleMappingState.__new__(_RoleMappingState)

        __props__.__dict__["ldap"] = ldap
        __props__.__dict__["oauth2"] = oauth2
        __props__.__dict__["openid"] = openid
        __props__.__dict__["saml"] = saml
        return RoleMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def ldap(self) -> pulumi.Output[Optional['outputs.RoleMappingLdap']]:
        """
        LDAP Authentication
        """
        return pulumi.get(self, "ldap")

    @property
    @pulumi.getter
    def oauth2(self) -> pulumi.Output[Optional['outputs.RoleMappingOauth2']]:
        """
        Oauth2 Authentication
        """
        return pulumi.get(self, "oauth2")

    @property
    @pulumi.getter
    def openid(self) -> pulumi.Output[Optional['outputs.RoleMappingOpenid']]:
        """
        OpenId Authentication
        """
        return pulumi.get(self, "openid")

    @property
    @pulumi.getter
    def saml(self) -> pulumi.Output[Optional['outputs.RoleMappingSaml']]:
        """
        SAML Authentication
        """
        return pulumi.get(self, "saml")

