"""Lexico-Semantic norms from EsPal."""
from enum import IntEnum


class LSNorm(IntEnum):
    """Enum for the LEXICOSEMANTIC_ESPAL indices."""

    CONCRETENESS = 0
    IMAGEABILITY = 1
    FAMILIARITY = 2


LEXICOSEMANTIC_ESPAL = {
    'abad': [6.187, 3.966, 2.6519999999999997],
    'abandonar': [4.218999999999999, 4.162, 6.047999999999999],
    'abandono': [3.452, 5.056, 4.89],
    'abanico': [6.0889999999999995, 5.728, 5.166],
    'abarcar': [2.951, 3.062, 3.917],
    'abastecimiento': [4.29, 4.0089999999999995, 5.115],
    'abeja': [6.417999999999999, 6.593, 5.635],
    'aberración': [4.177, 2.306, 3.905],
    'abertura': [4.19, 4.136, 4.061],
    'abismo': [3.86, 5.191, 4.614],
    'abnegación': [2.773, 2.016, 3.463],
    'abordar': [2.983, 4.044, 4.272],
    'aborto': [5.401, 4.824, 5.276],
    'abrazar': [4.783, 6.5, 5.664],
    'abrazo': [5.909, 6.209, 5.417000000000001],
    'abrigo': [4.9830000000000005, 6.72, 5.96],
    'abril': [5.894, 4.015, 6.284],
    'abrir': [4.19, 5.306, 6.472],
    'abrirse': [3.4330000000000003, 4.038, 5.471],
    'absolución': [3.208, 2.74, 3.747],
    'absorber': [4.103, 4.1819999999999995, 5.4639999999999995],
    'absorción': [3.863, 3.867, 4.101],
    'abstinencia': [3.758, 3.216, 4.05],
    'abstracción': [2.292, 2.461, 4.232],
    'absurdo': [2.7939999999999996, 2.5610000000000004, 5.246],
    'abuela': [6.292999999999999, 6.222, 6.732],
    'abuelita': [5.961, 6.143, 4.466],
    'abuelo': [6.485, 6.292999999999999, 5.8389999999999995],
    'abundancia': [3.895, 4.6930000000000005, 5.16],
    'aburrimiento': [4.478, 4.756, 5.871],
    'abuso': [4.061, 4.488, 6.105],
    'acabar': [3.971, 4.467, 6.199],
    'acacias': [5.282, 3.795, 2.398],
    'academia': [4.765, 5.377999999999999, 6.247000000000001],
    'académico': [4.245, 3.373, 6.0089999999999995],
    'acallar': [3.542, 2.117, 2.156],
    'acantilado': [5.629, 6.183, 4.369],
    'acariciar': [5.43, 6.555, 6.452000000000001],
    'acarrear': [3.3560000000000003, 2.864, 3.53],
    'acatar': [3.8110000000000004, 3.2260000000000004, 4.125],
    'acceder': [3.1519999999999997, 3.137, 5.126],
    'acceso': [4.167, 3.4589999999999996, 5.31],
    'accidente': [4.927, 5.8389999999999995, 6.329],
    'acción': [2.186, 3.957, 5.784],
    'acecho': [3.49, 3.5389999999999997, 4.567],
    'aceite': [5.801, 5.632000000000001, 6.268],
    'aceitunas': [6.428999999999999, 6.3629999999999995, 5.945],
    'aceleración': [4.928, 4.024, 4.81],
    'acelerador': [5.513999999999999, 5.329, 5.974],
    'acelerar': [4.9830000000000005, 4.862, 5.977],
    'acento': [4.94, 5.138999999999999, 5.742000000000001],
    'acentuar': [3.728, 3.108, 3.9219999999999997],
    'acepción': [3.0789999999999997, 2.3609999999999998, 2.8739999999999997],
    'aceptación': [3.7110000000000003, 2.7960000000000003, 4.649],
    'aceptar': [4.093999999999999, 3.844, 5.25],
    'acequia': [5.662000000000001, 4.176, 3.0989999999999998],
    'acera': [5.899, 5.836, 5.851],
    'acercamiento': [4.417, 3.988, 5.547999999999999],
    'acercar': [3.99, 4.013, 5.972],
    'acercarse': [5.401, 5.106, 6.082999999999999],
    'acero': [6.221, 4.886, 5.1080000000000005],
    'acertar': [4.43, 5.046, 6.478],
    'achaques': [3.833, 3.181, 4.46],
    'acidez': [4.003, 4.312, 3.815],
    'acierto': [4.312, 2.61, 5.9079999999999995],
    'aclaración': [3.611, 2.548, 4.309],
    'aclarado': [3.915, 4.013999999999999, 5.044],
    'aclarar': [3.543, 3.912, 6.3260000000000005],
    'acometer': [3.339, 2.406, 2.574],
    'acomodar': [3.9019999999999997, 3.429, 4.136],
    'acomodarse': [3.6189999999999998, 5.099, 5.928],
    'acomodo': [3.531, 3.262, 3.9819999999999998],
    'acompañamiento': [3.5439999999999996, 3.823, 4.998],
    'acompañante': [5.494, 5.77, 5.925],
    'acompañar': [4.163, 4.36, 5.875],
    'acontecer': [2.9389999999999996, 3.2060000000000004, 3.991],
    'acontecimiento': [2.485, 3.495, 5.365],
    'acordar': [3.655, 3.905, 5.032],
    'acorde': [3.88, 3.665, 4.287],
    'acordeón': [6.55, 5.109, 4.316],
    'acoso': [4.218, 3.6860000000000004, 4.4910000000000005],
    'acritud': [3.49, 2.295, 1.7919999999999998],
    'acta': [4.612, 4.406000000000001, 4.703],
    'actitud': [2.97, 2.141, 5.562],
    'activación': [4.23, 3.292, 3.86],
    'activadores': [3.22, 1.9869999999999999, 2.819],
    'actividad': [2.363, 3.405, 6.321000000000001],
    'activo': [4.382, 4.0, 6.053],
    'acto': [3.097, 3.366, 4.311],
    'actor': [5.622000000000001, 6.045, 5.641],
    'actriz': [6.01, 5.684, 6.122999999999999],
    'actuación': [4.495, 4.729, 5.657],
    'actualidad': [4.04, 4.145, 5.989],
    'actuar': [3.409, 3.9960000000000004, 6.129],
    'acuario': [5.9670000000000005, 6.557, 5.769],
    'acudir': [4.302, 4.337, 4.897],
    'acuerdo': [3.656, 3.714, 5.752999999999999],
    'acumulación': [3.236, 4.006, 4.832],
    'acumular': [3.878, 4.485, 6.082999999999999],
    'acusación': [4.6819999999999995, 4.386, 4.805],
    'acusado': [4.654, 4.012, 5.276],
    'acústica': [4.263, 2.75, 4.503],
    'adaptación': [3.676, 2.436, 5.675],
    'adaptar': [3.719, 3.0669999999999997, 4.936],
    'adaptarse': [3.3739999999999997, 2.767, 4.937],
    'adecuación': [3.228, 2.283, 4.33],
    'adelantar': [4.9, 4.359, 6.156000000000001],
    'adelanto': [4.154, 4.756, 5.903],
    'ademán': [3.31, 3.0660000000000003, 3.861],
    'adentrarse': [4.159, 4.192, 4.45],
    'adhesión': [3.647, 2.965, 3.1889999999999996],
    'adición': [3.696, 3.49, 5.093999999999999],
    'adictos': [4.218, 4.749, 4.82],
    'adivina': [4.409, 4.571000000000001, 4.626],
    'adivinaba': [4.169, 3.1189999999999998, 5.595],
    'adivinar': [3.8939999999999997, 3.092, 6.072],
    'adiós': [3.9619999999999997, 4.757, 6.906000000000001],
    'adjetivo': [4.571000000000001, 2.359, 5.4079999999999995],
    'administración': [3.574, 2.972, 4.395],
    'administrador': [5.331, 4.144, 4.105],
    'administrativa': [5.568, 4.55, 3.963],
    'administrativo': [5.297000000000001, 3.864, 5.558],
    'admiración': [3.69, 4.295, 5.946000000000001],
    'admirar': [3.57, 3.575, 5.818],
    'admitir': [3.927, 2.887, 6.05],
    'adolescencia': [4.064, 4.723, 6.644],
    'adolescente': [5.4479999999999995, 5.751, 6.417000000000001],
    'adopción': [3.478, 3.889, 5.003],
    'adoquines': [5.008, 5.657, 3.715],
    'adoración': [3.406, 4.154, 4.501],
    'adorno': [4.498, 5.437, 6.017],
    'adquirir': [3.596, 3.52, 5.501],
    'adquisición': [4.044, 3.386, 3.781],
    'aduana': [5.987, 5.562, 3.9819999999999998],
    'adulta': [4.913, 5.027, 5.782],
    'adulterio': [4.871, 4.387, 3.6860000000000004],
    'adulto': [5.308, 5.83, 6.501],
    'advenimiento': [3.031, 1.881, 3.217],
    'adversario': [5.136, 3.535, 4.611000000000001],
    'advertir': [3.338, 2.9339999999999997, 4.811],
    'aerobic': [5.903, 4.954, 4.803999999999999],
    'aeropuerto': [6.117999999999999, 6.356, 5.718999999999999],
    'afectada': [3.5060000000000002, 3.975, 4.747],
    'afectados': [3.665, 3.695, 5.102],
    'afectar': [3.717, 3.18, 6.077999999999999],
    'afecto': [4.341, 4.487, 5.422000000000001],
    'afeitar': [5.404, 5.846, 6.33],
    'afeitarse': [5.809, 6.415, 5.846],
    'aficionada': [4.2010000000000005, 3.9760000000000004, 5.542999999999999],
    'aficionado': [3.926, 4.06, 4.494],
    'afición': [3.2880000000000003, 4.063, 6.0089999999999995],
    'afinidades': [3.167, 2.379, 3.3169999999999997],
    'afirmación': [5.5329999999999995, 4.225, 4.974],
    'afirmar': [4.467, 3.306, 4.638],
    'afirmarse': [3.299, 2.8310000000000004, 5.34],
    'afluentes': [5.425, 4.681, 4.439],
    'africanas': [5.195, 5.693, 5.474],
    'africano': [5.379, 5.22, 5.939],
    'afrontar': [3.5810000000000004, 3.68, 5.711],
    'afueras': [4.33, 4.537, 6.011],
    'afán': [3.0460000000000003, 2.419, 5.006],
    'agencia': [4.35, 4.819, 5.215],
    'agenda': [5.626, 5.96, 6.216],
    'agente': [3.463, 4.51, 4.961],
    'agilidad': [4.371, 4.5, 5.914],
    'agitación': [4.034, 4.477, 5.118],
    'agobio': [3.7110000000000003, 4.629, 5.977],
    'agonía': [3.8939999999999997, 4.627, 3.605],
    'agosto': [5.981, 5.742999999999999, 6.292000000000001],
    'agotamiento': [4.673, 5.849, 6.135],
    'agradecer': [4.51, 3.763, 6.147],
    'agradecimiento': [3.4530000000000003, 3.884, 5.547000000000001],
    'agregar': [3.6860000000000004, 4.188, 4.999],
    'agresividad': [6.006, 5.31, 6.023],
    'agresión': [4.784, 4.993, 5.015],
    'agricultores': [6.403, 6.146, 6.109],
    'agricultura': [5.129, 4.5489999999999995, 5.752000000000001],
    'agruparse': [4.516, 4.428, 5.317],
    'agua': [6.1129999999999995, 6.39, 6.87],
    'aguacero': [4.979, 6.096, 5.197],
    'aguantar': [2.9219999999999997, 3.635, 6.497000000000001],
    'aguante': [3.2030000000000003, 3.188, 4.7780000000000005],
    'aguardar': [4.212, 1.588, 4.027],
    'aguardiente': [6.16, 4.226, 4.069],
    'agudeza': [3.1660000000000004, 2.861, 4.577],
    'aguijón': [6.233, 5.38, 4.401],
    'aguja': [5.875, 5.93, 6.085],
    'agujero': [4.897, 5.827000000000001, 6.1770000000000005],
    'ahorrar': [5.013999999999999, 4.131, 5.556],
    'ahorro': [4.223, 4.2139999999999995, 6.66],
    'aire': [4.936, 4.012, 5.837999999999999],
    'aislamiento': [3.865, 5.25, 4.321000000000001],
    'aislante': [4.03, 3.036, 4.909],
    'aislar': [3.648, 3.9589999999999996, 5.223],
    'ajedrez': [5.803999999999999, 5.318, 4.746],
    'ajetreo': [4.606, 3.7089999999999996, 4.874],
    'ajo': [5.77, 6.33, 5.605],
    'ajustar': [3.014, 3.1039999999999996, 5.641],
    'ajustarse': [3.293, 2.949, 5.874],
    'ala': [4.82, 6.05, 5.584],
    'alabanzas': [4.851, 3.2880000000000003, 4.677],
    'alacena': [5.667000000000001, 4.476, 3.003],
    'alameda': [4.862, 4.808, 6.164],
    'alarde': [3.998, 2.609, 3.612],
    'alargar': [3.7119999999999997, 4.0089999999999995, 5.999],
    'alargó': [3.625, 3.889, 4.727],
    'alaridos': [4.591, 4.989, 3.574],
    'alarma': [4.6160000000000005, 5.776, 6.245],
    'alba': [5.062, 4.274, 4.202],
    'albañil': [6.391, 5.962000000000001, 4.808],
    'albergar': [3.972, 3.617, 4.215],
    'albergue': [5.513999999999999, 6.406000000000001, 5.515],
    'albina': [5.657, 5.276, 3.7760000000000002],
    'albores': [2.931, 1.6740000000000002, 1.557],
    'alboroto': [4.107, 4.997, 5.497000000000001],
    'alborozo': [4.238, 3.574, 2.194],
    'albóndigas': [6.141, 5.861000000000001, 5.912000000000001],
    'alcalde': [6.2829999999999995, 5.832000000000001, 5.959],
    'alcance': [2.792, 2.923, 5.527],
    'alcanzar': [3.1189999999999998, 4.228, 5.965],
    'alcoba': [5.752999999999999, 5.946000000000001, 4.364],
    'alcohol': [5.5920000000000005, 6.09, 6.447],
    'aldea': [5.5, 5.365, 4.5760000000000005],
    'aldeanos': [6.176, 5.422000000000001, 4.867],
    'aleación': [3.6210000000000004, 2.915, 3.377],
    'alegoría': [4.175, 1.829, 3.6830000000000003],
    'alegría': [4.075, 4.899, 6.507000000000001],
    'alejamiento': [3.6260000000000003, 3.9530000000000003, 4.593],
    'alejar': [3.9410000000000003, 4.827, 5.039],
    'alejarse': [4.957, 4.805, 5.4479999999999995],
    'alemana': [5.5520000000000005, 5.2010000000000005, 5.968],
    'alemán': [5.145, 4.885, 4.706],
    'alergia': [4.963, 5.582999999999999, 5.27],
    'alerta': [3.96, 4.371, 4.066],
    'aleta': [4.966, 5.746, 4.455],
    'alfa': [4.291, 3.7889999999999997, 5.025],
    'alfabeto': [5.869, 5.506, 6.057],
    'alfiler': [6.337000000000001, 6.225, 6.093999999999999],
    'alfombra': [6.197, 5.987, 6.224],
    'algarabía': [3.818, 3.69, 3.215],
    'algas': [6.256, 5.877000000000001, 3.655],
    'algodón': [6.085, 6.351, 5.57],
    'aliado': [4.533, 3.728, 4.229],
    'alienación': [4.015, 4.33, 5.043],
    'aliento': [5.545, 4.75, 5.381],
    'alimañas': [3.6489999999999996, 3.397, 2.426],
    'alimentación': [4.971, 4.761, 6.598],
    'alimentar': [5.276, 5.143, 6.269],
    'alimentarse': [4.273, 4.85, 5.49],
    'aliviar': [3.292, 2.865, 5.728],
    'alivio': [3.779, 4.489, 6.085],
    'allegados': [3.977, 3.182, 4.69],
    'alma': [3.213, 4.565, 5.68],
    'almacenamiento': [3.759, 3.533, 4.8069999999999995],
    'almacén': [4.9, 6.21, 5.912999999999999],
    'almendra': [6.295, 6.0360000000000005, 6.122999999999999],
    'almendras': [6.1339999999999995, 5.774, 5.101],
    'almendros': [6.621, 5.118, 4.044],
    'almidón': [5.984, 4.46, 4.077],
    'almohada': [5.938, 6.587000000000001, 6.184],
    'almohadones': [5.394, 6.335, 4.9430000000000005],
    'almorzar': [5.718, 5.9479999999999995, 5.619],
    'almuerzo': [5.702000000000001, 5.486000000000001, 5.472],
    'alojamiento': [3.7739999999999996, 4.346, 4.592],
    'alpargatas': [6.202000000000001, 6.112, 4.157],
    'alquilar': [5.218, 3.228, 5.553],
    'alquiler': [4.334, 3.984, 5.495],
    'alrededores': [2.397, 3.675, 5.285],
    'altar': [5.704, 5.523, 5.598],
    'altavoz': [5.718, 5.962999999999999, 5.489],
    'alteración': [3.847, 4.002, 5.502999999999999],
    'alterar': [2.839, 2.483, 3.943],
    'altercado': [3.696, 3.957, 3.784],
    'alternancia': [2.864, 2.501, 4.334],
    'alternativa': [4.316, 3.27, 5.2379999999999995],
    'altura': [4.734, 5.421, 6.631],
    'alucinación': [4.762, 4.238, 5.831],
    'aludir': [2.825, 2.707, 3.1639999999999997],
    'alumbrado': [4.628, 5.5729999999999995, 4.31],
    'alumbrar': [4.412, 4.9510000000000005, 4.896],
    'aluminio': [6.1579999999999995, 5.354, 4.078],
    'alumna': [5.73, 6.108, 6.57],
    'alumno': [5.688, 5.9479999999999995, 6.58],
    'alusión': [3.4730000000000003, 2.6519999999999997, 4.186],
    'alzar': [3.8819999999999997, 4.773, 4.813],
    'alzarse': [3.935, 3.56, 5.061],
    'amabilidad': [4.172, 4.673, 5.272],
    'amador': [3.41, 3.641, 3.508],
    'amago': [3.572, 3.273, 3.835],
    'amanecer': [5.747000000000001, 6.031000000000001, 6.525],
    'amante': [4.962, 4.732, 4.229],
    'amapolas': [6.3420000000000005, 6.209, 5.525],
    'amar': [4.447, 5.553, 6.556],
    'amargura': [2.496, 5.166, 4.303],
    'ambición': [3.674, 3.5, 5.242000000000001],
    'ambiente': [3.739, 3.72, 5.251],
    'ambigüedad': [2.786, 2.522, 4.891],
    'amenaza': [4.596, 4.273, 5.532],
    'amenazar': [4.586, 4.582, 5.115],
    'americana': [5.018, 5.347, 6.0920000000000005],
    'americano': [5.432, 5.178999999999999, 5.896],
    'amiga': [5.712000000000001, 6.223, 6.678],
    'amigo': [5.853, 6.175, 6.781000000000001],
    'aminoácido': [5.33, 2.7569999999999997, 4.258],
    'amistad': [4.402, 4.092, 4.975],
    'amo': [3.682, 4.428, 4.163],
    'amor': [2.592, 4.898, 6.36],
    'amoríos': [4.439, 4.192, 5.257999999999999],
    'amparo': [3.259, 2.509, 2.8480000000000003],
    'ampliar': [4.019, 2.7, 4.379],
    'amplificador': [5.318, 4.871, 4.83],
    'amplitud': [3.398, 3.3110000000000004, 5.79],
    'analizar': [3.4939999999999998, 3.0439999999999996, 5.607],
    'analogía': [3.818, 2.505, 2.519],
    'analítica': [3.03, 2.7489999999999997, 3.655],
    'anatomía': [4.965, 4.981, 3.958],
    'anchura': [3.446, 3.721, 5.499],
    'anciana': [6.106, 5.97, 4.343999999999999],
    'anciano': [6.2379999999999995, 6.28, 6.0520000000000005],
    'ancla': [6.027, 5.706, 5.335],
    'andadura': [3.45, 2.86, 2.8989999999999996],
    'andaluz': [5.88, 4.736000000000001, 6.317],
    'andaluza': [5.869, 5.428, 4.883],
    'andanzas': [2.9539999999999997, 2.588, 3.642],
    'andar': [5.52, 5.791, 6.505],
    'andares': [4.0, 4.151, 3.633],
    'andén': [5.879, 5.671, 4.896],
    'anfibios': [5.22, 5.024, 4.257],
    'anfitrión': [5.353, 4.63, 4.827],
    'anglosajona': [5.555, 3.577, 4.564],
    'angustia': [3.4989999999999997, 4.711, 5.635],
    'anhelo': [2.8160000000000003, 3.8539999999999996, 4.496],
    'anillo': [5.952000000000001, 6.611000000000001, 6.122999999999999],
    'animación': [3.073, 4.218999999999999, 5.845],
    'animal': [4.13, 6.367999999999999, 6.667000000000001],
    'animar': [4.003, 4.566, 6.202000000000001],
    'aniversario': [4.716, 4.36, 5.711],
    'anochecer': [4.994, 6.122000000000001, 5.7989999999999995],
    'anonimato': [4.841, 3.635, 5.145],
    'anotar': [5.2170000000000005, 4.763, 5.611000000000001],
    'ansia': [3.6660000000000004, 3.932, 4.89],
    'antebrazo': [6.853, 5.167000000000001, 5.515],
    'antecedentes': [3.74, 2.6239999999999997, 4.124],
    'antecesor': [4.893, 2.8710000000000004, 3.852],
    'antena': [5.767, 6.577999999999999, 5.869],
    'anteojos': [6.303999999999999, 5.8420000000000005, 3.178],
    'antepasado': [5.125, 4.289, 4.988],
    'antesala': [4.599, 4.8660000000000005, 3.8560000000000003],
    'antibióticos': [5.496, 5.507999999999999, 5.676],
    'anticipación': [3.122, 2.226, 3.4810000000000003],
    'anticipo': [3.835, 3.5069999999999997, 3.822],
    'anticongelante': [5.763999999999999, 3.0839999999999996, 4.152],
    'anticuario': [5.575, 5.558, 5.072],
    'anticuerpo': [4.914, 3.47, 5.222],
    'antigüedad': [4.0569999999999995, 4.454, 5.535],
    'antojo': [4.332, 3.609, 5.193],
    'antología': [4.293, 2.748, 4.33],
    'antorcha': [6.51, 6.2, 4.553],
    'antropología': [4.895, 2.513, 4.082],
    'antropólogo': [5.3420000000000005, 4.1, 4.2],
    'antídoto': [4.917, 3.583, 4.905],
    'antígeno': [4.77, 2.597, 2.364],
    'anular': [3.59, 2.995, 4.058],
    'anunciar': [3.915, 3.7430000000000003, 5.859],
    'anuncio': [4.253, 5.571000000000001, 6.46],
    'análisis': [3.009, 4.159, 5.845],
    'anécdota': [4.004, 3.378, 5.122999999999999],
    'anís': [6.353, 6.001, 5.6160000000000005],
    'anónima': [4.966, 3.742, 5.5329999999999995],
    'apagar': [3.385, 4.857, 5.976],
    'apagarse': [3.411, 4.894, 5.602],
    'aparador': [4.102, 5.196000000000001, 4.19],
    'aparato': [3.048, 5.143, 6.428999999999999],
    'aparecer': [3.73, 4.16, 5.497000000000001],
    'aparecido': [3.556, 3.3110000000000004, 5.656000000000001],
    'aparentar': [3.9219999999999997, 2.872, 4.107],
    'aparición': [3.2060000000000004, 4.08, 4.819],
    'apariencia': [4.319, 3.659, 6.108],
    'apartado': [3.425, 3.892, 6.222],
    'apartamento': [5.795, 5.619, 5.228],
    'apartar': [3.372, 4.75, 5.632999999999999],
    'apartarse': [3.6319999999999997, 4.213, 5.341],
    'apelativo': [3.033, 2.44, 3.122],
    'apellido': [5.631, 4.459, 6.5489999999999995],
    'aperitivo': [6.205, 5.202999999999999, 5.621],
    'apertura': [3.549, 3.9939999999999998, 5.434],
    'apetencias': [2.985, 3.622, 3.91],
    'apetito': [4.49, 4.093, 4.157],
    'aplastar': [4.4239999999999995, 3.435, 4.93],
    'aplaudir': [6.099, 6.095, 6.237],
    'aplauso': [5.5089999999999995, 5.542999999999999, 6.222],
    'aplicación': [3.718, 2.513, 4.1530000000000005],
    'aplicar': [3.0589999999999997, 2.807, 4.925],
    'aplicarse': [3.326, 3.536, 4.772],
    'aplomo': [3.0010000000000003, 2.805, 2.6910000000000003],
    'apocalipsis': [2.904, 2.716, 3.51],
    'apoderado': [3.889, 3.31, 2.545],
    'apoderarse': [3.8539999999999996, 3.72, 4.811],
    'apodo': [4.468, 3.898, 5.287999999999999],
    'apogeo': [4.192, 3.6919999999999997, 4.541],
    'aportación': [2.806, 2.75, 3.928],
    'aportar': [4.008, 2.909, 4.319],
    'aporte': [2.957, 1.805, 3.431],
    'aposento': [4.656000000000001, 4.74, 3.505],
    'apoteosis': [3.637, 3.215, 3.822],
    'apoyar': [3.8110000000000004, 4.195, 5.2379999999999995],
    'apoyarse': [3.862, 4.771, 6.125],
    'apreciación': [3.175, 2.52, 4.768],
    'aprecio': [3.9939999999999998, 3.2439999999999998, 6.183],
    'aprender': [4.544, 4.342, 6.653],
    'aprendizaje': [4.058, 3.4360000000000004, 5.777],
    'apretar': [4.013, 4.93, 6.617999999999999],
    'apretón': [4.489, 5.216, 5.01],
    'aprovechamiento': [3.216, 2.608, 5.022],
    'aprovechar': [3.307, 2.616, 6.195],
    'aproximación': [3.984, 3.7239999999999998, 4.996],
    'aproximarse': [4.088, 4.263999999999999, 4.482],
    'aptitud': [3.2560000000000002, 2.908, 5.425],
    'aptitudes': [3.668, 2.798, 5.206],
    'apuesta': [4.442, 4.104, 4.738],
    'apuestas': [4.585, 4.292, 4.746],
    'apuntar': [3.395, 3.4419999999999997, 5.314],
    'apunte': [3.948, 5.627999999999999, 6.487],
    'apéndice': [4.279, 4.0969999999999995, 5.341],
    'apóstol': [5.494, 5.292999999999999, 4.648],
    'aragonés': [5.627999999999999, 3.9360000000000004, 4.659],
    'araña': [5.989, 6.143, 5.517],
    'arbustos': [5.013999999999999, 6.442, 5.287999999999999],
    'arca': [4.897, 4.908, 2.87],
    'archipiélago': [5.936, 6.071000000000001, 4.828],
    'archivo': [4.809, 5.641, 5.291],
    'arco': [5.404, 6.162999999999999, 5.754],
    'arder': [4.63, 5.513999999999999, 5.6579999999999995],
    'ardilla': [6.393, 5.872999999999999, 5.7989999999999995],
    'ardor': [3.988, 4.078, 3.355],
    'arenal': [5.521, 5.194, 4.458],
    'argentina': [5.75, 5.276, 5.184],
    'argentino': [5.756, 4.611000000000001, 5.291],
    'argot': [3.69, 2.984, 3.108],
    'argumentación': [4.149, 3.79, 4.301],
    'argumentar': [3.4139999999999997, 2.93, 5.0760000000000005],
    'argumento': [3.3939999999999997, 2.295, 5.063],
    'aristas': [5.412000000000001, 3.713, 4.74],
    'aristocracia': [4.351, 4.308, 4.601],
    'aristócrata': [5.0089999999999995, 5.4270000000000005, 4.919],
    'aritmética': [5.662999999999999, 3.9960000000000004, 5.206],
    'arma': [5.197, 6.152, 6.015],
    'armada': [4.096, 4.071000000000001, 3.682],
    'armadura': [5.268, 5.626, 4.361000000000001],
    'armar': [3.844, 3.555, 4.5],
    'armario': [6.239, 6.239, 6.337000000000001],
    'armazón': [4.654, 4.763999999999999, 3.85],
    'armonía': [3.525, 4.4030000000000005, 4.974],
    'aroma': [4.092, 4.338, 5.135],
    'arqueología': [5.372000000000001, 5.233, 5.031000000000001],
    'arquetipo': [3.265, 2.1830000000000003, 3.281],
    'arqueólogo': [6.053, 4.718, 5.324],
    'arquitecto': [5.959, 4.617, 4.724],
    'arquitectura': [5.477, 4.5680000000000005, 5.751],
    'arraigo': [3.648, 2.18, 3.115],
    'arrancar': [4.18, 4.41, 5.692],
    'arranque': [3.949, 3.3569999999999998, 5.127999999999999],
    'arrastrar': [5.003, 5.31, 6.324],
    'arrebatar': [3.819, 4.0569999999999995, 4.7410000000000005],
    'arrebato': [4.008, 4.367, 5.277],
    'arreglar': [3.783, 4.151, 6.41],
    'arreglo': [3.867, 3.3080000000000003, 5.558],
    'arrepentimiento': [4.421, 4.168, 5.457000000000001],
    'arriesgarse': [3.995, 3.395, 5.642],
    'arrobo': [3.839, 2.85, 1.51],
    'arrogancia': [4.779, 4.035, 4.56],
    'arrojar': [3.4160000000000004, 4.664, 3.483],
    'arrojarse': [4.0569999999999995, 5.013999999999999, 4.148],
    'arrojo': [3.033, 3.263, 4.727],
    'arroyo': [5.712000000000001, 5.685, 4.602],
    'arroz': [6.361000000000001, 5.443, 5.981],
    'arruga': [5.32, 5.2829999999999995, 5.223],
    'arruinar': [4.341, 2.9810000000000003, 6.011],
    'arsenal': [4.566, 3.873, 3.59],
    'arte': [3.0810000000000004, 4.609, 6.266],
    'artefacto': [3.681, 4.261, 4.851],
    'arterias': [5.632999999999999, 5.033, 4.58],
    'artesano': [4.357, 6.322, 3.964],
    'artesanos': [4.821000000000001, 4.633, 5.091],
    'articulación': [4.375, 4.007, 4.605],
    'articular': [3.075, 4.15, 3.742],
    'artificio': [3.221, 2.096, 2.701],
    'artista': [4.908, 5.439, 6.186],
    'artículo': [3.355, 4.216, 5.527],
    'arzobispo': [5.95, 5.065, 4.723],
    'asaltar': [4.25, 4.982, 4.638999999999999],
    'asalto': [4.857, 5.374, 5.327999999999999],
    'asamblea': [4.859, 5.038, 5.085],
    'ascendencia': [3.065, 3.0239999999999996, 5.38],
    'ascender': [3.957, 5.059, 5.335],
    'ascenso': [4.231, 4.067, 5.303],
    'ascensor': [6.46, 6.106, 7.0],
    'asco': [4.525, 5.162999999999999, 6.651],
    'ascética': [4.159, 2.0469999999999997, 3.923],
    'asedio': [4.047, 3.537, 3.655],
    'asegurado': [3.767, 3.3, 4.498],
    'asegurar': [4.3839999999999995, 2.958, 6.558],
    'asegurarse': [3.685, 2.158, 6.149],
    'asentamiento': [3.935, 3.5869999999999997, 4.039],
    'asentir': [4.9430000000000005, 4.07, 3.9530000000000003],
    'aseo': [5.1579999999999995, 5.875, 5.9],
    'asesina': [5.705, 4.445, 5.586],
    'asesinato': [5.59, 5.742000000000001, 5.694],
    'asesino': [5.79, 4.706, 4.788],
    'asesor': [4.102, 3.112, 3.806],
    'asfalto': [5.897, 5.445, 5.4479999999999995],
    'asiento': [5.6, 6.004, 6.336],
    'asignatura': [5.167000000000001, 3.842, 6.81],
    'asilo': [5.957000000000001, 5.303, 4.538],
    'asimilación': [3.1660000000000004, 2.366, 4.856],
    'asistencia': [3.658, 4.82, 5.242000000000001],
    'asistenta': [4.923, 5.605, 4.606],
    'asistente': [4.377, 4.869, 5.439],
    'asistir': [4.458, 3.491, 5.4],
    'asma': [6.035, 3.536, 4.485],
    'asociación': [3.967, 3.583, 5.561],
    'asociada': [3.133, 3.495, 4.744],
    'asomar': [4.285, 4.519, 4.833],
    'asomarse': [4.237, 4.254, 5.8229999999999995],
    'asombro': [4.112, 4.84, 5.207000000000001],
    'aspavientos': [4.591, 3.699, 3.003],
    'aspecto': [3.075, 2.997, 5.983],
    'aspereza': [5.059, 3.94, 4.819],
    'aspiración': [3.4989999999999997, 3.572, 4.6419999999999995],
    'aspirantes': [4.691, 3.699, 5.093],
    'aspirar': [3.679, 3.9539999999999997, 4.996],
    'astillas': [5.37, 5.733, 3.466],
    'astrofísica': [4.9910000000000005, 2.952, 3.884],
    'astronauta': [6.294, 6.319, 5.879],
    'astros': [5.127000000000001, 5.632999999999999, 4.628],
    'astucia': [4.204, 3.305, 4.155],
    'asturiana': [6.098, 4.601, 4.0169999999999995],
    'asturiano': [6.47, 3.373, 5.125],
    'asumir': [4.228, 3.609, 5.733],
    'asunto': [2.911, 2.059, 5.037],
    'asustar': [4.7330000000000005, 4.883, 5.849],
    'atacar': [4.595, 5.055, 5.818],
    'atajar': [4.115, 3.702, 4.78],
    'atajo': [5.226, 4.981, 5.699],
    'ataque': [3.9419999999999997, 5.185, 6.282],
    'atar': [4.968999999999999, 5.202999999999999, 6.061],
    'atardecer': [5.681, 6.608, 5.865],
    'atasco': [5.403, 5.848, 6.084],
    'ataúd': [6.244, 5.381, 5.507999999999999],
    'atención': [4.093999999999999, 3.781, 6.603],
    'atender': [4.301, 3.8, 5.5489999999999995],
    'atentado': [5.268, 5.621, 5.1080000000000005],
    'atisbar': [3.713, 3.188, 3.158],
    'atlas': [5.644, 4.671, 5.41],
    'atleta': [5.226, 5.7379999999999995, 5.305],
    'atmósfera': [4.8, 4.3260000000000005, 5.315],
    'atracción': [3.0380000000000003, 4.073, 6.1739999999999995],
    'atraer': [3.4810000000000003, 3.715, 5.682],
    'atrapar': [4.382, 4.849, 5.261],
    'atraso': [4.268, 3.8360000000000003, 5.763],
    'atravesar': [3.8680000000000003, 3.8, 6.2],
    'atreverse': [3.158, 3.015, 6.731],
    'atribuir': [4.672, 2.011, 4.664],
    'atuendo': [3.9610000000000003, 4.816, 3.9130000000000003],
    'atún': [6.154, 5.697, 5.932],
    'audacia': [3.549, 3.1519999999999997, 5.122999999999999],
    'audiencia': [4.223, 3.763, 4.504],
    'auditorio': [5.599, 5.204, 2.859],
    'auge': [2.753, 3.1889999999999996, 4.4510000000000005],
    'aula': [5.747999999999999, 6.359, 6.097],
    'aullido': [5.354, 6.319, 4.96],
    'aumentar': [3.1, 3.7310000000000003, 6.297999999999999],
    'aumento': [4.008, 4.147, 5.901],
    'aura': [3.423, 4.124, 3.174],
    'aureola': [4.62, 3.16, 4.069],
    'aurora': [4.677, 4.426, 4.029],
    'ausencia': [3.9810000000000003, 3.786, 4.8260000000000005],
    'ausentes': [3.355, 3.505, 4.916],
    'australopithecus': [5.345, 3.642, 2.572],
    'autenticidad': [3.3680000000000003, 2.8560000000000003, 4.019],
    'auto': [3.877, 5.803, 5.301],
    'autobús': [6.728, 6.303999999999999, 6.522],
    'autoconciencia': [3.842, 1.749, 3.557],
    'automóvil': [6.024, 6.274, 5.336],
    'autonomía': [3.27, 2.352, 4.906000000000001],
    'autopista': [6.085, 6.057, 6.57],
    'autor': [4.537, 4.263, 6.0520000000000005],
    'autora': [4.845, 4.488, 6.1160000000000005],
    'autoridad': [3.798, 4.1819999999999995, 5.916],
    'autómata': [4.688, 3.431, 3.443],
    'auxiliar': [3.963, 4.34, 4.75],
    'auxilio': [4.132, 4.869, 4.21],
    'avalancha': [4.66, 5.593999999999999, 5.278],
    'avance': [4.256, 3.1660000000000004, 4.828],
    'avanzar': [4.1160000000000005, 3.819, 5.1],
    'avaricia': [4.668, 3.8110000000000004, 4.585],
    'avaro': [4.688, 3.843, 4.229],
    'avatares': [2.969, 3.109, 2.737],
    'avenida': [5.494, 5.377000000000001, 5.638999999999999],
    'aventura': [3.7960000000000003, 4.791, 6.13],
    'aventurera': [4.768, 4.816, 5.995],
    'aventureros': [4.93, 5.653, 5.336],
    'averiguar': [3.7910000000000004, 3.53, 5.045],
    'aversión': [3.904, 3.253, 3.679],
    'avestruz': [5.343, 6.399, 3.9730000000000003],
    'avidez': [3.46, 2.596, 3.655],
    'avisar': [4.687, 4.385, 5.872999999999999],
    'avión': [6.249, 5.81, 6.31],
    'axilas': [5.726, 6.096, 5.892],
    'ayuda': [3.78, 3.48, 6.566],
    'ayudante': [4.356, 5.178, 4.327],
    'ayudar': [3.7110000000000003, 4.88, 6.4479999999999995],
    'ayuntamiento': [6.297000000000001, 6.212999999999999, 6.234],
    'azar': [4.332, 3.096, 4.606],
    'azote': [4.553999999999999, 5.692, 4.423],
    'azotea': [6.079, 5.2170000000000005, 6.035],
    'aztecas': [5.7410000000000005, 4.356, 3.715],
    'azufre': [5.822, 3.555, 3.806],
    'azúcar': [6.537999999999999, 6.501, 6.612],
    'aérea': [4.31, 3.4930000000000003, 3.912],
    'añadidura': [3.3569999999999998, 2.859, 3.4330000000000003],
    'añadir': [4.207, 3.864, 5.82],
    'añicos': [5.0169999999999995, 4.837, 4.486000000000001],
    'año': [5.48, 3.747, 5.712000000000001],
    'añoranza': [3.39, 3.907, 4.871],
    'baba': [5.303, 6.056, 4.8839999999999995],
    'bacalao': [6.039, 6.534, 5.037],
    'bachillerato': [5.381, 3.7110000000000003, 5.556],
    'bacteria': [5.604, 3.432, 4.476],
    'bahía': [5.506, 5.278, 3.978],
    'bailar': [5.064, 5.792000000000001, 6.419],
    'bailarina': [5.6770000000000005, 6.127999999999999, 4.593999999999999],
    'bailarín': [5.849, 5.891, 4.518],
    'baile': [4.529, 6.189, 6.31],
    'baja': [4.052, 4.677, 6.024],
    'bajada': [4.538, 5.045, 5.982],
    'bajar': [4.76, 5.497000000000001, 6.518],
    'bajo': [4.096, 5.372000000000001, 6.398],
    'bala': [5.705, 5.575, 5.457000000000001],
    'balance': [3.761, 2.9330000000000003, 4.418],
    'balanceo': [4.334, 4.678999999999999, 5.0360000000000005],
    'balanza': [5.888, 6.007999999999999, 5.47],
    'balcón': [6.032, 6.176, 5.71],
    'baldosas': [6.039, 5.763, 4.55],
    'ballena': [6.4639999999999995, 6.44, 5.649],
    'balneario': [5.75, 5.04, 4.164],
    'baloncesto': [6.5729999999999995, 6.272, 5.312],
    'balón': [6.225, 6.355, 6.446000000000001],
    'bambú': [6.056, 5.439, 4.114],
    'banca': [4.492, 4.508, 4.524],
    'banco': [4.856, 5.711, 6.371],
    'banda': [4.027, 4.999, 6.026],
    'bandeja': [5.655, 5.597, 6.287999999999999],
    'bandera': [6.522, 6.051, 4.736000000000001],
    'bando': [3.338, 3.9010000000000002, 4.011],
    'banquero': [5.42, 5.4639999999999995, 5.277],
    'banquete': [5.5089999999999995, 6.135, 5.765],
    'bar': [6.053999999999999, 6.683, 6.4110000000000005],
    'baraja': [5.521, 6.181, 6.331],
    'baranda': [5.327999999999999, 5.16, 4.946000000000001],
    'barandilla': [5.946000000000001, 6.254, 5.747000000000001],
    'barba': [6.172999999999999, 6.055, 6.768],
    'barbarie': [4.02, 4.253, 3.3760000000000003],
    'barbero': [6.157, 5.511, 4.0760000000000005],
    'barbilla': [5.6129999999999995, 6.436, 6.215],
    'barca': [6.02, 5.93, 5.7860000000000005],
    'barco': [6.018, 6.292999999999999, 5.551],
    'barman': [5.9110000000000005, 5.952999999999999, 3.4989999999999997],
    'barniz': [5.625, 5.529, 4.832],
    'barra': [4.434, 5.69, 5.932],
    'barraca': [5.008, 6.015, 3.395],
    'barracón': [5.523, 5.268, 3.6830000000000003],
    'barranco': [5.597, 5.9239999999999995, 5.61],
    'barrer': [5.47, 5.113, 6.018],
    'barrera': [4.342, 5.4270000000000005, 5.055],
    'barreño': [5.534, 5.492000000000001, 4.328],
    'barrido': [3.35, 4.245, 3.937],
    'barriga': [6.216, 6.553999999999999, 5.432],
    'barrio': [5.547000000000001, 5.98, 6.027],
    'barro': [5.7860000000000005, 6.151, 6.101],
    'barroco': [4.619, 4.532, 3.3169999999999997],
    'barrotes': [5.904, 5.9239999999999995, 4.184],
    'barullo': [3.545, 5.744, 6.1739999999999995],
    'basa': [3.4989999999999997, 2.144, 2.7319999999999998],
    'base': [2.539, 3.4989999999999997, 6.53],
    'bastardo': [4.677, 3.096, 3.173],
    'bastidor': [5.242999999999999, 4.195, 4.205],
    'bastos': [4.109, 4.273, 4.796],
    'bastón': [6.204, 6.601, 5.352],
    'basílica': [5.747000000000001, 4.959, 3.803],
    'bata': [5.72, 5.957000000000001, 5.642],
    'batallón': [4.751, 5.24, 3.55],
    'batería': [4.544, 5.914, 5.984],
    'batida': [3.952, 2.929, 3.468],
    'batir': [4.335, 5.356, 5.782],
    'bautismo': [5.7589999999999995, 4.717, 4.26],
    'bautizo': [6.037999999999999, 5.476, 5.218999999999999],
    'bayeta': [5.779, 5.611000000000001, 5.563],
    'bañador': [6.256, 6.3389999999999995, 6.513],
    'bañarse': [5.402, 5.9270000000000005, 6.271],
    'bañera': [6.32, 6.692, 6.636],
    'baño': [5.435, 6.325, 6.311],
    'baúl': [6.3260000000000005, 6.061, 6.156000000000001],
    'beata': [4.975, 4.29, 4.282],
    'beatitud': [3.5060000000000002, 3.0039999999999996, 2.501],
    'bebedores': [5.17, 5.631, 5.72],
    'beber': [5.646, 6.191, 6.501],
    'bebida': [4.668, 5.522, 6.486000000000001],
    'bebé': [6.263, 6.8, 6.097],
    'bedel': [5.792000000000001, 4.925, 3.9389999999999996],
    'belga': [5.662999999999999, 3.8, 4.476],
    'belleza': [3.111, 4.455, 5.962000000000001],
    'belén': [5.136, 6.16, 5.551],
    'bendición': [3.918, 3.7889999999999997, 4.922],
    'beneficio': [3.745, 3.759, 5.843],
    'benevolencia': [3.37, 2.997, 3.302],
    'besar': [5.176, 6.111000000000001, 6.871],
    'beso': [5.4639999999999995, 6.277, 6.671],
    'bestia': [4.573, 5.885, 6.196000000000001],
    'biberón': [6.129, 6.428, 5.824],
    'biblia': [5.6610000000000005, 5.702000000000001, 4.663],
    'bibliografía': [5.724, 6.111000000000001, 6.167999999999999],
    'biblioteca': [6.087999999999999, 6.766, 6.86],
    'bicha': [3.51, 3.469, 2.106],
    'bicho': [3.3310000000000004, 5.76, 6.149],
    'bicicleta': [6.8, 6.577999999999999, 6.0760000000000005],
    'bidones': [5.859, 5.252000000000001, 4.613],
    'bien': [2.572, 3.7030000000000003, 6.739],
    'bienestar': [4.029, 4.2219999999999995, 5.319],
    'bienvenida': [3.97, 3.556, 4.6080000000000005],
    'bigote': [6.579, 6.504, 5.649],
    'billete': [4.933, 6.513999999999999, 6.513999999999999],
    'bingo': [5.428, 5.3839999999999995, 5.392],
    'biocontrol': [4.0089999999999995, 2.0269999999999997, 2.224],
    'biografía': [4.755, 3.909, 5.419],
    'biología': [5.148, 3.3739999999999997, 4.787],
    'bioquímica': [4.029, 2.211, 4.678],
    'bisabuelo': [6.5329999999999995, 4.266, 4.409],
    'bizcochos': [6.246, 5.8260000000000005, 4.908],
    'biólogo': [6.269, 4.865, 5.439],
    'blanco': [5.091, 5.587000000000001, 6.199],
    'blancura': [4.823, 5.261, 5.917999999999999],
    'blasfemia': [4.703, 3.0039999999999996, 4.231],
    'bloque': [3.563, 5.446000000000001, 5.152],
    'blusa': [6.4, 5.195, 5.681],
    'boba': [5.2, 3.574, 4.885],
    'bobadas': [4.5280000000000005, 4.0280000000000005, 5.61],
    'bobina': [5.306, 5.104, 2.9730000000000003],
    'boca': [6.013999999999999, 6.223, 6.515],
    'bocado': [5.202000000000001, 5.4879999999999995, 5.902],
    'bochorno': [3.63, 4.959, 4.606],
    'bocina': [6.034, 3.0, 2.67],
    'bodega': [5.735, 5.792999999999999, 6.037000000000001],
    'bofetadas': [5.754, 5.945, 6.196000000000001],
    'bohemia': [3.591, 3.009, 3.832],
    'boina': [6.2860000000000005, 5.949, 4.84],
    'bola': [5.247999999999999, 6.593999999999999, 6.329],
    'boleros': [3.915, 4.748, 5.178999999999999],
    'boletín': [4.086, 5.006, 5.542999999999999],
    'bolsa': [4.724, 5.035, 6.416],
    'bolsillo': [6.0729999999999995, 6.436, 6.194],
    'bolso': [5.345, 6.309, 6.309],
    'bolígrafo': [6.51, 6.696000000000001, 6.739],
    'bomba': [5.136, 5.792000000000001, 5.202000000000001],
    'bombardeo': [5.169, 5.944, 5.044],
    'bomberos': [6.005, 6.221, 6.007000000000001],
    'bombilla': [6.362, 6.202999999999999, 6.837999999999999],
    'bombones': [6.209, 6.45, 5.752999999999999],
    'bondad': [3.0789999999999997, 3.398, 5.669],
    'boquerón': [5.797999999999999, 5.797999999999999, 4.4319999999999995],
    'boquilla': [4.396, 4.939, 5.062],
    'bordados': [4.9319999999999995, 5.676, 4.8469999999999995],
    'borde': [4.13, 4.938, 6.079],
    'borracha': [5.707000000000001, 5.473, 5.822],
    'borrachera': [5.421, 6.114, 5.825],
    'borracho': [5.638999999999999, 6.22, 6.068],
    'borrar': [5.437, 5.843999999999999, 7.0],
    'bosnios': [5.986000000000001, 5.307, 5.19],
    'bosque': [5.902, 6.239, 5.044],
    'bostezo': [6.24, 6.557, 5.97],
    'bota': [5.428999999999999, 6.749, 6.345],
    'bote': [4.718999999999999, 5.74, 5.2410000000000005],
    'botella': [6.034, 6.765, 6.422999999999999],
    'botánico': [5.312, 4.341, 3.843],
    'botín': [4.928, 5.292000000000001, 3.2680000000000002],
    'botón': [6.125, 6.526, 6.51],
    'bragas': [6.382000000000001, 5.806, 6.365],
    'bragueta': [6.232, 5.907, 5.7139999999999995],
    'bramido': [5.026, 3.4989999999999997, 2.296],
    'brasa': [5.495, 4.955, 5.2829999999999995],
    'brasero': [5.678999999999999, 5.47, 3.8289999999999997],
    'brazo': [5.9639999999999995, 6.086, 6.7010000000000005],
    'brecha': [5.223, 4.52, 4.601],
    'brigada': [4.816, 3.725, 3.455],
    'brillante': [4.416, 5.012, 5.372999999999999],
    'brillantez': [3.205, 4.141, 5.473],
    'brillo': [4.699, 5.69, 5.667999999999999],
    'brisa': [5.005, 5.234, 5.777],
    'británica': [4.567, 3.9789999999999996, 4.995],
    'británicos': [5.406000000000001, 5.517, 5.399],
    'broche': [5.686, 5.919, 4.183],
    'broma': [4.5169999999999995, 4.045, 6.604],
    'bromear': [4.726, 5.096, 6.081],
    'bronca': [5.484, 5.422999999999999, 6.56],
    'bronce': [6.087999999999999, 5.229, 5.087],
    'brotar': [4.742, 4.442, 4.035],
    'bruja': [5.327000000000001, 6.127000000000001, 5.364],
    'brujo': [5.223, 5.1610000000000005, 5.28],
    'brutalidad': [3.6439999999999997, 4.373, 5.1610000000000005],
    'bucles': [6.252000000000001, 4.931, 2.91],
    'buenaventura': [3.713, 2.494, 2.57],
    'buey': [5.861000000000001, 5.607, 4.529],
    'bufanda': [6.7139999999999995, 6.07, 6.081],
    'buhardilla': [5.617999999999999, 5.614, 3.9760000000000004],
    'buitres': [5.757000000000001, 6.289, 5.322],
    'bullicio': [4.204, 5.053, 5.016],
    'bulto': [3.91, 4.707, 4.7989999999999995],
    'buque': [5.6770000000000005, 5.712000000000001, 4.2410000000000005],
    'burdel': [5.666, 5.447, 5.022],
    'burguesa': [4.763999999999999, 3.948, 4.61],
    'burguesía': [4.579, 4.564, 5.098],
    'burgués': [5.061, 4.1160000000000005, 3.9189999999999996],
    'burla': [3.7560000000000002, 4.196000000000001, 5.305],
    'burlarse': [4.5169999999999995, 4.638, 6.115],
    'burlón': [4.46, 3.655, 3.676],
    'burocracia': [4.349, 3.779, 4.273],
    'burra': [5.615, 6.079, 5.2860000000000005],
    'buscar': [3.403, 4.428, 6.419],
    'busto': [4.833, 5.5729999999999995, 4.738],
    'butaca': [6.122000000000001, 6.433, 5.482],
    'butifarra': [6.422999999999999, 5.506, 4.143],
    'buzón': [6.2379999999999995, 6.287999999999999, 6.524],
    'bíceps': [6.702000000000001, 5.352, 3.557],
    'bóveda': [5.443, 5.707999999999999, 5.197],
    'búfalo': [6.309, 5.502000000000001, 4.082],
    'búho': [6.097, 6.072, 5.354],
    'búsqueda': [3.801, 5.252999999999999, 6.4110000000000005],
    'cabalgata': [5.407, 5.707999999999999, 5.085],
    'caballero': [5.4239999999999995, 5.693, 5.834],
    'caballería': [4.98, 4.906000000000001, 3.1039999999999996],
    'caballete': [5.987, 6.0089999999999995, 2.354],
    'caballo': [6.228, 6.648, 5.596],
    'cabecera': [5.16, 5.577999999999999, 5.224],
    'cabellera': [5.537999999999999, 5.763999999999999, 5.066],
    'cabello': [5.831, 6.247999999999999, 6.063],
    'cabeza': [4.952, 6.026, 6.21],
    'cabida': [3.0610000000000004, 2.2569999999999997, 3.562],
    'cable': [5.815, 5.712000000000001, 5.597],
    'cabo': [3.952, 4.948, 4.995],
    'cabra': [6.22, 6.111000000000001, 5.989],
    'cabrera': [4.546, 3.4819999999999998, 3.64],
    'cabrón': [4.56, 4.462, 5.928999999999999],
    'caca': [5.803999999999999, 6.35, 5.242999999999999],
    'cacahuetes': [6.354, 6.398, 6.393],
    'cacería': [4.495, 5.733, 3.469],
    'cachondeo': [4.204, 5.142, 6.5920000000000005],
    'cachorro': [5.193, 6.425, 5.619],
    'cactus': [6.209, 6.5089999999999995, 5.252999999999999],
    'cadena': [4.143, 6.443, 6.555],
    'cadencia': [3.4, 2.8680000000000003, 2.42],
    'cadera': [6.285, 5.827999999999999, 6.477],
    'cadáver': [5.5120000000000005, 5.744, 4.409],
    'caer': [4.194, 4.905, 6.287000000000001],
    'caerse': [4.277, 5.388999999999999, 6.2589999999999995],
    'cafetería': [6.765, 7.0, 6.728],
    'caja': [4.581, 6.232, 6.5329999999999995],
    'cajero': [4.975, 5.638, 4.842],
    'cajón': [6.101, 6.392, 6.635],
    'cal': [6.077999999999999, 5.279, 5.098],
    'cala': [5.41, 5.04, 3.4360000000000004],
    'calabozo': [6.077000000000001, 5.956, 4.247],
    'calamidad': [4.104, 3.049, 4.671],
    'calavera': [5.702999999999999, 6.415, 5.9639999999999995],
    'calcetines': [6.513999999999999, 4.6530000000000005, 6.335],
    'caldo': [4.885, 5.886, 5.647],
    'calefacción': [6.392, 4.788, 5.606],
    'calendario': [6.18, 5.997000000000001, 6.416],
    'calentamiento': [3.447, 4.159, 5.8389999999999995],
    'calentar': [4.488, 5.052, 6.417000000000001],
    'calentura': [4.25, 4.475, 4.4110000000000005],
    'calibre': [3.813, 3.22, 2.835],
    'calidad': [3.84, 3.627, 5.295],
    'calificación': [4.766, 3.907, 5.968999999999999],
    'calificar': [3.4160000000000004, 3.36, 4.325],
    'calificativo': [3.455, 2.926, 4.745],
    'callar': [5.683, 4.978, 6.468999999999999],
    'calleja': [4.473, 4.331, 2.97],
    'callejero': [4.324, 3.9, 5.18],
    'callejón': [6.356, 5.815, 5.9079999999999995],
    'callo': [4.93, 4.419, 4.742],
    'calma': [4.311, 4.113, 5.899],
    'calor': [4.062, 5.707999999999999, 6.715],
    'calva': [6.005, 5.79, 5.975],
    'calvario': [3.7710000000000004, 3.7569999999999997, 4.513],
    'calvo': [5.497999999999999, 6.39, 5.681],
    'calzada': [4.739, 5.696000000000001, 5.033],
    'calzado': [5.037, 5.772, 5.995],
    'calzoncillos': [6.11, 6.707999999999999, 5.398],
    'cama': [6.1160000000000005, 7.0, 6.515],
    'camarada': [4.245, 4.548, 4.371],
    'camarera': [5.891, 6.266, 6.234],
    'camarero': [6.542000000000001, 6.16, 6.638],
    'camarote': [5.97, 5.513, 4.957],
    'cambiar': [3.53, 4.221, 6.489],
    'cambio': [2.625, 4.363, 6.468999999999999],
    'camilla': [5.901, 5.849, 5.129],
    'caminar': [4.822, 5.185, 6.672000000000001],
    'camino': [4.753, 6.101, 5.974],
    'camionero': [6.391, 5.5729999999999995, 5.25],
    'camisa': [6.292999999999999, 6.281000000000001, 6.7],
    'camiseta': [6.367999999999999, 6.528, 6.604],
    'camisón': [6.44, 6.518, 4.122],
    'camión': [6.495, 6.547999999999999, 6.312],
    'campamento': [5.421, 5.937, 5.325],
    'campana': [5.647, 6.4879999999999995, 6.127000000000001],
    'campanilla': [5.029, 5.692, 4.335],
    'campaña': [4.092, 3.822, 4.515],
    'campeonato': [5.265, 5.1160000000000005, 5.155],
    'campesina': [5.968999999999999, 6.0, 4.3580000000000005],
    'campesino': [6.334, 5.574, 6.011],
    'campeón': [4.755, 5.029, 6.272],
    'campo': [4.773, 5.962999999999999, 6.334],
    'canal': [3.8139999999999996, 4.146, 5.088],
    'canapés': [5.867000000000001, 4.857, 4.773],
    'canario': [5.784, 6.757000000000001, 6.61],
    'canas': [6.087999999999999, 5.682, 5.555],
    'cancela': [4.133, 2.7239999999999998, 4.258],
    'canción': [5.281000000000001, 5.341, 6.166],
    'candado': [6.178999999999999, 6.222, 5.615],
    'candidato': [4.708, 4.735, 4.262],
    'candil': [4.841, 5.694, 4.008],
    'canela': [6.0, 3.9339999999999997, 4.657],
    'cangrejos': [6.138999999999999, 6.196000000000001, 5.647],
    'canon': [3.3089999999999997, 2.734, 4.223],
    'cansancio': [3.958, 6.105, 5.832999999999999],
    'cantante': [5.369, 5.865, 6.481],
    'cantar': [5.306, 5.063, 6.042000000000001],
    'cante': [3.6069999999999998, 4.794, 4.617],
    'cantidad': [3.207, 4.42, 6.4879999999999995],
    'cantina': [6.218, 5.979, 5.095],
    'cantinero': [5.702999999999999, 4.666, 2.373],
    'canto': [4.316, 4.952, 5.795],
    'canuto': [4.9110000000000005, 5.932, 3.951],
    'caoba': [5.279, 4.51, 3.8360000000000003],
    'caos': [3.786, 4.8580000000000005, 4.453],
    'capacidad': [3.497, 3.464, 5.167999999999999],
    'capellán': [4.84, 5.111000000000001, 3.307],
    'capilla': [5.587000000000001, 6.461, 5.152],
    'capital': [3.86, 3.614, 6.146],
    'capitalismo': [4.496, 2.889, 5.155],
    'capitalista': [4.112, 3.307, 5.135],
    'capitán': [5.3260000000000005, 5.428, 4.091],
    'capote': [5.527, 4.571000000000001, 4.129],
    'capricho': [3.65, 4.303, 5.811],
    'captación': [3.7230000000000003, 3.4560000000000004, 3.8310000000000004],
    'captar': [3.611, 3.0, 5.848],
    'captura': [4.664, 4.838, 5.22],
    'capturar': [3.8169999999999997, 4.297, 5.711],
    'capucha': [5.587000000000001, 5.9110000000000005, 4.13],
    'capuchino': [5.62, 5.974, 5.531000000000001],
    'capullo': [4.727, 6.186, 5.579],
    'capítulo': [4.962, 4.939, 6.398],
    'cara': [5.151, 6.369, 6.921],
    'caracol': [6.126, 6.535, 5.067],
    'caracterización': [2.884, 3.5, 4.149],
    'caracterizar': [2.832, 3.275, 5.394],
    'característica': [2.591, 3.73, 6.095],
    'caravana': [5.246, 5.401, 3.863],
    'carbonero': [4.808, 4.928, 2.455],
    'carbono': [5.654, 2.793, 3.833],
    'carbón': [6.042000000000001, 6.119, 5.31],
    'carcajada': [5.736000000000001, 5.944, 4.621],
    'cardenal': [3.55, 5.902, 3.415],
    'carecer': [3.264, 3.127, 4.602],
    'carencia': [3.525, 4.662, 5.0280000000000005],
    'carga': [3.635, 4.217, 5.1579999999999995],
    'cargar': [3.693, 4.114, 6.156000000000001],
    'cargo': [3.63, 3.492, 5.511],
    'caricatura': [5.462000000000001, 5.62, 5.091],
    'caricia': [5.337000000000001, 5.172999999999999, 5.8020000000000005],
    'caridad': [4.125, 4.513, 5.127999999999999],
    'cariño': [3.716, 4.547, 5.688],
    'carmín': [5.428, 5.836, 5.041],
    'carnaval': [5.771, 6.438, 5.402],
    'carne': [5.643, 6.228, 6.506],
    'carnero': [6.0329999999999995, 5.657, 3.6889999999999996],
    'carnet': [5.519, 6.0120000000000005, 6.657],
    'carnicería': [6.084, 6.269, 5.66],
    'carpeta': [6.144, 6.468999999999999, 6.625],
    'carpintero': [6.466, 6.013999999999999, 5.012],
    'carrera': [3.556, 5.468, 6.454],
    'carretera': [6.042999999999999, 6.226, 6.379],
    'carro': [5.565, 5.966, 5.48],
    'carromato': [4.948, 5.555, 3.7539999999999996],
    'carroza': [4.729, 5.362, 5.31],
    'carroña': [4.192, 4.0360000000000005, 4.582],
    'carruaje': [5.7589999999999995, 5.7, 3.802],
    'carta': [5.729, 6.047999999999999, 6.614],
    'cartel': [4.987, 6.135, 5.961],
    'cartero': [6.377999999999999, 5.9510000000000005, 6.229],
    'cartulina': [5.879, 6.155, 5.912000000000001],
    'cartón': [5.893, 6.599, 6.191],
    'carácter': [3.08, 3.27, 5.51],
    'casa': [5.631, 6.575, 6.7589999999999995],
    'casada': [5.9910000000000005, 4.266, 6.335],
    'casado': [5.2620000000000005, 4.791, 6.311],
    'casamiento': [4.684, 5.306, 4.4719999999999995],
    'casar': [4.827, 4.543, 5.489],
    'casarse': [5.942, 5.52, 6.308],
    'cascabel': [5.8420000000000005, 5.497999999999999, 5.502000000000001],
    'cascada': [6.212999999999999, 6.228, 5.324],
    'casco': [4.402, 5.797000000000001, 5.983],
    'casera': [3.968, 4.271, 3.906],
    'casero': [4.789, 4.677, 5.734],
    'caseríos': [5.47, 4.861000000000001, 2.415],
    'caseta': [5.0489999999999995, 6.287999999999999, 5.131],
    'casino': [6.087000000000001, 5.4639999999999995, 3.8789999999999996],
    'caso': [2.438, 3.0460000000000003, 5.921],
    'casona': [5.127999999999999, 5.297000000000001, 2.7319999999999998],
    'casta': [4.0360000000000005, 2.213, 3.863],
    'castañas': [6.394, 5.155, 4.752],
    'castaño': [4.382, 5.3229999999999995, 5.143],
    'castañuelas': [6.8260000000000005, 6.1370000000000005, 3.64],
    'castellana': [4.287, 3.72, 4.927],
    'castellanos': [5.053999999999999, 3.733, 4.628],
    'castigado': [4.7780000000000005, 4.696000000000001, 5.223],
    'castigar': [4.831, 4.341, 5.301],
    'castigo': [4.795, 4.541, 6.064],
    'castillo': [5.914, 6.346, 4.602],
    'casual': [3.161, 2.105, 4.906000000000001],
    'casualidad': [3.861, 2.984, 6.399],
    'catalana': [5.5889999999999995, 5.577999999999999, 5.902],
    'catalán': [5.559, 4.154, 6.007999999999999],
    'catecismo': [5.426, 4.739, 2.5140000000000002],
    'catedral': [6.724, 6.394, 5.524],
    'catedrático': [5.582000000000001, 5.433, 5.271],
    'categoría': [3.076, 2.6860000000000004, 4.992],
    'catión': [4.6739999999999995, 2.128, 2.813],
    'catre': [5.705, 3.8369999999999997, 2.4090000000000003],
    'catálogo': [5.296, 5.141, 4.959],
    'catástrofe': [4.5680000000000005, 5.8870000000000005, 5.0889999999999995],
    'católico': [4.776, 4.16, 4.906000000000001],
    'cauce': [4.136, 3.616, 4.502],
    'caudal': [3.9930000000000003, 5.051, 4.3580000000000005],
    'caudillo': [5.122000000000001, 4.254, 3.542],
    'causa': [3.4419999999999997, 2.65, 6.376],
    'causalidad': [3.245, 2.4730000000000003, 4.8839999999999995],
    'causar': [3.0189999999999997, 2.265, 5.6],
    'cautela': [4.166, 3.3810000000000002, 4.652],
    'cautiverio': [4.5680000000000005, 4.124, 4.163],
    'cautivo': [4.877, 4.301, 2.969],
    'caverna': [6.34, 5.59, 4.689],
    'cavidad': [3.5860000000000003, 3.885, 3.9760000000000004],
    'cavilar': [3.858, 3.2969999999999997, 3.4760000000000004],
    'caza': [4.954, 5.086, 5.51],
    'cazador': [5.577999999999999, 5.5120000000000005, 5.586],
    'cazadora': [6.016, 5.745, 6.013999999999999],
    'cazar': [4.934, 5.3660000000000005, 5.327000000000001],
    'cazuela': [5.352, 6.093, 5.309],
    'caída': [4.337, 5.814, 6.454],
    'cañada': [4.814, 4.997, 3.029],
    'caño': [4.82, 4.624, 3.185],
    'cañón': [5.53, 5.593999999999999, 4.426],
    'cebo': [4.871, 5.0760000000000005, 4.445],
    'cebolla': [6.433, 6.406000000000001, 6.662000000000001],
    'ceder': [4.08, 3.18, 5.497999999999999],
    'ceguera': [5.0, 4.593, 4.794],
    'ceja': [6.042000000000001, 6.016, 6.607],
    'celda': [5.812, 6.242000000000001, 4.287],
    'celebración': [4.404, 5.749, 4.997],
    'celebrar': [4.65, 5.196000000000001, 5.888],
    'celebrarse': [4.6819999999999995, 3.9560000000000004, 5.475],
    'celeridad': [3.415, 1.726, 2.995],
    'celo': [3.627, 4.288, 5.501],
    'celofán': [6.309, 6.032, 3.5239999999999996],
    'celulosa': [5.569, 2.8310000000000004, 3.3939999999999997],
    'cementerio': [6.343999999999999, 6.406000000000001, 6.039],
    'cemento': [5.57, 5.638, 5.645],
    'cena': [6.297999999999999, 6.301, 6.733],
    'cenicero': [6.332000000000001, 5.941, 6.14],
    'ceniza': [5.706, 6.292000000000001, 5.777],
    'censo': [4.956, 3.807, 5.2170000000000005],
    'censura': [4.072, 3.415, 5.197],
    'centelleo': [4.1339999999999995, 4.79, 3.568],
    'centenar': [4.652, 3.285, 4.253],
    'centenario': [5.012, 3.772, 4.206],
    'central': [3.201, 3.0180000000000002, 5.431],
    'centro': [4.89, 5.611000000000001, 6.686],
    'centrómero': [5.441, 2.725, 2.384],
    'centígrados': [5.827000000000001, 2.489, 4.684],
    'centímetro': [6.22, 4.058, 5.584],
    'cepillo': [5.499, 6.002999999999999, 6.865],
    'cera': [4.748, 5.869, 5.896],
    'cercanía': [4.5489999999999995, 4.963, 5.815],
    'cerco': [4.063, 4.374, 3.1319999999999997],
    'cerdo': [5.391, 5.803999999999999, 6.263],
    'cerebro': [6.284, 5.707999999999999, 6.284],
    'ceremonia': [4.385, 5.8629999999999995, 5.834],
    'cerezas': [6.443, 6.357, 5.776],
    'cerilla': [6.28, 6.813, 5.865],
    'cerradura': [5.961, 5.777, 5.607],
    'cerrar': [4.648, 5.513999999999999, 6.484],
    'cerrarse': [4.101, 3.8080000000000003, 5.648],
    'cerro': [4.996, 4.841, 3.862],
    'cerrojo': [5.2860000000000005, 6.455, 5.715],
    'certeza': [3.3739999999999997, 1.883, 4.93],
    'certidumbre': [3.668, 2.9360000000000004, 3.813],
    'cerveza': [6.026, 6.395, 6.532],
    'cerámica': [5.433, 6.315, 3.739],
    'cesar': [3.3789999999999996, 3.595, 4.3469999999999995],
    'cesta': [5.811, 6.057, 5.806],
    'cetro': [4.87, 4.164, 3.01],
    'chaleco': [5.9879999999999995, 6.495, 6.16],
    'chalet': [6.367999999999999, 6.5760000000000005, 6.034],
    'chalé': [5.52, 5.515, 4.717],
    'champán': [6.301, 6.234, 5.358],
    'chapa': [5.0569999999999995, 5.325, 4.716],
    'chaqueta': [5.864, 6.591, 6.68],
    'charca': [5.8260000000000005, 5.482, 4.928999999999999],
    'charco': [5.441, 6.0760000000000005, 5.994],
    'charla': [4.11, 5.257000000000001, 5.481],
    'charlar': [4.4510000000000005, 4.637, 6.5360000000000005],
    'charlatán': [4.923, 5.31, 4.958],
    'chasquido': [4.926, 4.562, 4.752],
    'chata': [4.019, 4.688, 3.926],
    'chaval': [5.091, 4.965, 5.26],
    'chelo': [5.245, 5.23, 2.2],
    'chica': [5.756, 6.482, 6.5329999999999995],
    'chicle': [6.3839999999999995, 6.084, 6.474],
    'chico': [6.01, 6.854, 6.314],
    'chillido': [5.486000000000001, 5.194, 5.506],
    'chimenea': [6.169, 6.2860000000000005, 5.7010000000000005],
    'chinas': [4.655, 5.337000000000001, 5.127999999999999],
    'chip': [4.944, 3.386, 2.487],
    'chiquillo': [5.337000000000001, 6.074, 5.256],
    'chirrido': [5.58, 4.736000000000001, 4.024],
    'chisme': [2.8110000000000004, 3.431, 5.1770000000000005],
    'chispa': [4.648, 6.0089999999999995, 5.31],
    'chiste': [4.956, 4.723, 6.417000000000001],
    'chivo': [5.095, 4.904, 3.773],
    'chocar': [4.123, 5.6739999999999995, 6.093999999999999],
    'chocolate': [6.127000000000001, 6.624, 6.678],
    'chopos': [5.752000000000001, 4.492, 3.472],
    'choque': [4.915, 5.165, 5.81],
    'chorizo': [5.182, 6.335, 6.058],
    'chorradas': [3.872, 3.1210000000000004, 5.824],
    'chorro': [3.897, 6.145, 5.08],
    'choza': [5.178999999999999, 6.42, 4.87],
    'chulo': [4.425, 5.516, 5.8260000000000005],
    'chófer': [5.885, 6.107, 4.766],
    'cicatriz': [5.58, 5.96, 5.504],
    'ciclo': [3.33, 2.639, 5.055],
    'ciclón': [5.478, 4.801, 3.5380000000000003],
    'ciego': [5.728, 5.64, 5.99],
    'cielo': [5.156000000000001, 6.351, 6.292999999999999],
    'ciencia': [3.654, 2.722, 6.053],
    'científico': [5.237, 5.507999999999999, 5.42],
    'cierre': [4.084, 3.25, 4.992],
    'ciervo': [6.519, 5.999, 4.435],
    'cifra': [5.39, 5.638999999999999, 5.513999999999999],
    'cigarrillo': [6.2989999999999995, 5.832000000000001, 5.73],
    'cigarro': [6.247000000000001, 6.308, 5.718999999999999],
    'cigüeña': [5.797000000000001, 6.042000000000001, 5.306],
    'cilindro': [5.279, 5.3870000000000005, 4.7989999999999995],
    'cima': [4.888, 5.644, 4.687],
    'cimientos': [5.02, 5.289, 3.4539999999999997],
    'cinc': [5.457000000000001, 2.14, 2.134],
    'cine': [5.766, 6.575, 6.77],
    'cineasta': [5.495, 4.542, 3.088],
    'cinismo': [4.606, 2.9419999999999997, 4.314],
    'cinta': [3.813, 5.949, 6.654],
    'cintura': [6.058, 5.303999999999999, 6.066],
    'cinturón': [6.051, 5.832999999999999, 6.1160000000000005],
    'ciprés': [5.771, 6.215, 5.431],
    'circo': [5.193, 6.542000000000001, 6.146],
    'circuito': [4.601, 5.144, 4.672],
    'circulación': [3.411, 5.379, 6.131],
    'circular': [3.702, 3.61, 4.378],
    'circulo': [5.627000000000001, 6.019, 5.855],
    'circunstancia': [3.095, 2.7960000000000003, 5.62],
    'cirios': [6.057, 4.702, 3.3680000000000003],
    'cirugía': [5.4479999999999995, 5.642, 5.832000000000001],
    'cirujano': [6.081, 5.778, 5.37],
    'cisne': [6.546, 6.332999999999999, 5.555],
    'cisterna': [5.671, 5.43, 3.1189999999999998],
    'citar': [4.418, 3.4130000000000003, 4.868],
    'ciudad': [5.3389999999999995, 6.188, 6.567],
    'ciudadana': [5.346, 5.079, 5.596],
    'ciudadano': [4.849, 4.239, 5.932],
    'ciudadanía': [4.349, 2.562, 3.813],
    'civil': [3.946, 3.8310000000000004, 5.265],
    'civilización': [4.026, 4.706, 4.79],
    'clamor': [3.46, 4.229, 3.596],
    'clan': [3.9939999999999998, 3.78, 4.315],
    'clandestinidad': [3.69, 3.8939999999999997, 3.568],
    'clara': [3.387, 4.114, 4.357],
    'claridad': [3.7689999999999997, 4.695, 6.295],
    'claro': [3.74, 3.9539999999999997, 6.377999999999999],
    'clasificación': [3.98, 3.826, 5.789],
    'clasificar': [3.946, 4.757, 5.626],
    'claustro': [4.175, 4.78, 4.236000000000001],
    'clave': [3.685, 3.093, 4.136],
    'clavel': [6.672000000000001, 6.309, 4.448],
    'clavo': [5.888999999999999, 5.832000000000001, 5.6579999999999995],
    'clero': [5.869, 5.059, 4.352],
    'cliente': [5.046, 5.265, 6.3389999999999995],
    'clientela': [4.77, 5.105, 4.678999999999999],
    'clima': [4.695, 4.18, 4.867],
    'cloacas': [5.556, 5.305, 5.41],
    'cloro': [5.727, 4.717, 5.428],
    'cloruro': [4.974, 2.9189999999999996, 3.1919999999999997],
    'club': [5.2010000000000005, 4.993, 5.872999999999999],
    'clérigo': [5.4079999999999995, 6.169, 3.009],
    'clínica': [4.729, 5.468, 5.625],
    'coartada': [4.824, 3.443, 5.415],
    'cobarde': [3.8989999999999996, 3.85, 4.439],
    'cobertizo': [5.747999999999999, 4.913, 4.04],
    'cobijo': [4.544, 4.316, 3.569],
    'cobra': [4.707, 5.489, 4.32],
    'cobrar': [4.226, 5.377999999999999, 6.022],
    'cobre': [6.004, 6.1339999999999995, 4.99],
    'cobro': [4.686, 3.9530000000000003, 6.245],
    'coca': [4.485, 5.428, 5.535],
    'cocaína': [5.956, 5.525, 5.317],
    'coche': [5.672000000000001, 6.566, 6.641],
    'cochero': [5.593999999999999, 5.567, 4.596],
    'cocido': [4.846, 5.917000000000001, 5.281000000000001],
    'cocina': [6.044, 6.059, 6.379],
    'cocinero': [6.381, 6.353, 5.763999999999999],
    'codicia': [3.0069999999999997, 3.258, 3.383],
    'codo': [5.502999999999999, 4.285, 5.636],
    'cofrades': [5.194, 4.67, 3.315],
    'coger': [3.6069999999999998, 4.277, 6.385],
    'cogida': [2.93, 4.952, 4.368],
    'cogote': [5.511, 5.32, 4.154],
    'coherencia': [3.858, 2.298, 5.122000000000001],
    'cohesión': [3.875, 2.7, 3.61],
    'cohete': [5.952000000000001, 6.271, 5.66],
    'coincidencia': [4.465, 3.572, 5.13],
    'coincidir': [4.412, 2.761, 6.087000000000001],
    'coito': [6.307, 6.28, 4.291],
    'coja': [4.315, 4.7989999999999995, 5.202000000000001],
    'cojones': [5.712999999999999, 5.722, 5.563],
    'cojín': [6.022, 6.428999999999999, 6.265],
    'cola': [4.006, 5.933, 6.441],
    'colaboración': [3.997, 4.669, 6.316],
    'colaborador': [4.91, 4.324, 5.9],
    'colaborar': [3.8169999999999997, 4.301, 5.893],
    'colación': [2.702, 2.31, 1.8980000000000001],
    'colapso': [3.7539999999999996, 4.086, 3.917],
    'colcha': [6.433, 5.257999999999999, 5.962999999999999],
    'colchón': [6.21, 6.4670000000000005, 6.218],
    'coleccionista': [5.308, 5.145, 5.218999999999999],
    'colección': [4.971, 5.4670000000000005, 5.682],
    'colectividad': [2.946, 3.94, 4.332],
    'colectivo': [3.908, 3.85, 5.033],
    'colega': [4.816, 5.715, 6.039],
    'colegial': [5.559, 5.477, 5.5360000000000005],
    'coliflor': [6.402, 4.9639999999999995, 4.065],
    'colilla': [5.4910000000000005, 6.077000000000001, 4.455],
    'colina': [5.9110000000000005, 5.462000000000001, 3.0860000000000003],
    'colisión': [4.9319999999999995, 5.657, 4.493],
    'collar': [5.334, 6.542999999999999, 5.87],
    'colmo': [2.532, 2.458, 5.671],
    'colocación': [3.8510000000000004, 3.0860000000000003, 5.832000000000001],
    'colocar': [3.928, 4.4719999999999995, 6.52],
    'colocarse': [3.9960000000000004, 4.38, 5.559],
    'colonia': [5.099, 5.845, 6.396],
    'coloquio': [4.705, 5.084, 4.94],
    'color': [4.185, 5.254, 6.13],
    'colorines': [4.213, 5.801, 5.8629999999999995],
    'columna': [5.132999999999999, 6.645, 5.949],
    'coma': [3.736, 5.537999999999999, 5.928999999999999],
    'comandante': [5.191, 5.231, 4.316],
    'comarca': [4.633, 3.065, 4.561],
    'combate': [4.624, 5.212000000000001, 3.572],
    'combatientes': [4.822, 4.282, 3.508],
    'combatir': [3.6260000000000003, 4.328, 4.754],
    'combinación': [2.975, 3.928, 5.066],
    'combustible': [4.711, 5.563, 6.3229999999999995],
    'combustión': [4.061, 3.597, 3.262],
    'comedia': [4.791, 4.893, 5.53],
    'comensales': [5.19, 4.263, 2.9610000000000003],
    'comentar': [3.892, 3.7089999999999996, 6.005],
    'comentario': [3.6430000000000002, 3.5380000000000003, 6.023],
    'comentaristas': [4.518, 5.49, 5.528],
    'comenzar': [3.647, 3.5189999999999997, 5.994],
    'comer': [5.59, 6.303999999999999, 6.914],
    'comercialización': [3.528, 3.069, 4.814],
    'comerciante': [5.092, 5.462000000000001, 5.7],
    'comercio': [5.14, 5.3229999999999995, 6.024],
    'comerse': [4.007, 4.37, 5.4639999999999995],
    'cometa': [5.617999999999999, 6.066, 4.671],
    'cometer': [3.0839999999999996, 2.8939999999999997, 4.532],
    'cometido': [3.4210000000000003, 2.386, 3.4389999999999996],
    'comienzo': [4.309, 3.957, 5.736000000000001],
    'comisario': [5.917000000000001, 5.95, 4.57],
    'comisionado': [4.505, 2.293, 2.6319999999999997],
    'comisión': [3.898, 3.2439999999999998, 4.936],
    'comisuras': [4.785, 4.119, 4.58],
    'comitiva': [3.7889999999999997, 3.2739999999999996, 3.682],
    'comité': [4.6080000000000005, 4.5760000000000005, 3.795],
    'comodidad': [3.352, 4.397, 5.667999999999999],
    'compadre': [4.601, 4.245, 3.772],
    'comparación': [3.793, 3.082, 5.684],
    'comparar': [3.938, 2.611, 5.9639999999999995],
    'compararse': [3.465, 3.2769999999999997, 5.626],
    'compartimiento': [3.9539999999999997, 4.342, 5.517],
    'compartir': [4.689, 5.227, 6.347],
    'compasión': [3.1630000000000003, 3.639, 5.415],
    'compatriotas': [5.167999999999999, 4.26, 4.913],
    'compañera': [4.812, 5.303, 6.1339999999999995],
    'compañía': [3.161, 4.412, 6.159],
    'compensación': [4.079, 3.517, 4.467],
    'compensar': [3.77, 2.5269999999999997, 5.285],
    'competencia': [3.38, 4.173, 5.518],
    'competición': [4.46, 4.718, 5.7170000000000005],
    'competir': [3.8560000000000003, 4.599, 5.5329999999999995],
    'complacer': [3.773, 3.5469999999999997, 4.534],
    'complejidad': [3.2119999999999997, 2.966, 6.069],
    'complemento': [3.141, 3.4139999999999997, 5.524],
    'completar': [3.87, 3.469, 5.232],
    'complicación': [3.194, 3.073, 5.909],
    'complicidad': [4.128, 2.998, 5.079],
    'componente': [3.841, 3.4010000000000002, 4.4030000000000005],
    'componer': [3.676, 3.908, 5.452000000000001],
    'comportamiento': [4.4030000000000005, 4.511, 6.556],
    'comportarse': [3.778, 3.947, 5.754],
    'composición': [3.54, 3.778, 4.973],
    'compostura': [4.314, 3.219, 4.295],
    'compra': [4.621, 5.02, 6.343999999999999],
    'comprador': [5.215, 5.439, 5.295],
    'comprar': [4.019, 4.744, 6.449],
    'comprarse': [4.529, 3.7569999999999997, 5.641],
    'comprender': [4.165, 2.533, 6.212999999999999],
    'comprensión': [3.557, 2.616, 5.169],
    'compresión': [3.9160000000000004, 3.701, 5.349],
    'comprimido': [3.806, 3.3139999999999996, 3.766],
    'comprobación': [3.767, 2.541, 5.038],
    'comprobar': [3.556, 3.9330000000000003, 5.587999999999999],
    'compromiso': [3.338, 3.4560000000000004, 5.587000000000001],
    'compuesto': [3.967, 3.403, 4.6610000000000005],
    'computador': [5.347, 5.854, 5.046],
    'computadora': [5.4670000000000005, 5.88, 4.545],
    'compás': [5.8660000000000005, 6.182, 4.268],
    'comulgar': [5.101, 4.177, 4.735],
    'comunicado': [3.59, 4.113, 4.535],
    'comunicar': [4.14, 4.579, 6.313],
    'comunicarse': [4.281000000000001, 5.04, 6.129],
    'comunidad': [3.8739999999999997, 5.38, 4.663],
    'comunismo': [4.678, 3.815, 4.468],
    'comunista': [4.4639999999999995, 4.066, 3.7430000000000003],
    'comunión': [4.85, 5.519, 5.029],
    'conceder': [2.9819999999999998, 2.799, 5.164],
    'concentración': [4.263, 4.261, 5.497000000000001],
    'concentrados': [3.717, 3.787, 4.797],
    'concentrar': [4.08, 3.221, 5.5],
    'concentrarse': [5.2989999999999995, 4.49, 6.249],
    'concepción': [3.426, 3.4739999999999998, 4.082],
    'concepto': [2.24, 2.792, 4.894],
    'concesión': [3.1910000000000003, 2.665, 2.312],
    'conciencia': [3.9419999999999997, 2.124, 5.043],
    'concierto': [5.296, 6.5329999999999995, 5.98],
    'conciliar': [3.26, 2.5660000000000003, 5.083],
    'concluir': [4.04, 3.157, 5.466],
    'conclusión': [4.541, 3.173, 6.145],
    'concordia': [3.467, 2.6710000000000003, 4.494],
    'concretar': [4.187, 2.509, 5.202000000000001],
    'concubinas': [5.539, 4.663, 4.1819999999999995],
    'concurso': [5.761, 5.72, 6.01],
    'condena': [4.069, 4.468, 5.446000000000001],
    'condenación': [4.039, 2.885, 3.2569999999999997],
    'condenada': [4.349, 4.365, 3.929],
    'condenados': [4.756, 4.539, 4.9719999999999995],
    'condenar': [4.181, 4.3260000000000005, 3.5989999999999998],
    'condensación':
    [4.3660000000000005, 3.4139999999999997, 3.8539999999999996],
    'condesa': [5.506, 5.104, 4.9910000000000005],
    'condición': [3.029, 3.359, 5.244],
    'conducción': [3.9789999999999996, 4.175, 5.364],
    'conducir': [5.141, 4.958, 6.393],
    'conducta': [3.13, 2.009, 5.263],
    'conductividad': [3.552, 2.6039999999999996, 3.5810000000000004],
    'conductor': [4.727, 5.784, 6.3],
    'conectar': [4.14, 4.586, 5.832999999999999],
    'conejo': [6.365, 6.061, 6.029],
    'conferencia': [5.577999999999999, 5.067, 6.045],
    'confesar': [4.271, 4.8180000000000005, 4.66],
    'confesión': [3.609, 4.211, 4.994],
    'confesor': [5.386, 6.107, 4.223],
    'confianza': [4.322, 5.013999999999999, 6.571000000000001],
    'confiar': [4.033, 2.929, 4.97],
    'confidencia': [4.157, 4.062, 4.627],
    'confidente': [4.6530000000000005, 3.68, 4.293],
    'configuración': [3.307, 2.8680000000000003, 3.228],
    'configurar': [3.095, 2.125, 3.985],
    'confines': [3.577, 2.866, 3.9139999999999997],
    'confirmación': [4.225, 3.657, 4.814],
    'confirmar': [3.7510000000000003, 2.987, 4.896],
    'conflicto': [3.585, 4.322, 5.412000000000001],
    'conformidad': [4.136, 3.301, 5.8420000000000005],
    'confundir': [3.825, 3.5660000000000003, 6.388],
    'confusión': [4.043, 3.966, 5.811],
    'congoja': [3.157, 3.5039999999999996, 3.218],
    'congreso': [4.17, 4.332, 5.499],
    'conjetura': [3.4210000000000003, 2.193, 3.891],
    'conjunción': [4.151, 2.509, 4.8839999999999995],
    'conjunto': [2.64, 3.815, 5.7620000000000005],
    'conjuro': [3.6710000000000003, 3.267, 4.385],
    'conmoción': [4.555, 3.4739999999999998, 3.935],
    'conmutadores': [3.9139999999999997, 2.622, 2.546],
    'connotaciones': [3.198, 2.549, 4.716],
    'cono': [5.3839999999999995, 5.481, 4.277],
    'conocedor': [3.235, 2.971, 4.56],
    'conocer': [3.3139999999999996, 3.2489999999999997, 5.853],
    'conocida': [4.383, 4.777, 6.23],
    'conocimiento': [2.7119999999999997, 1.575, 5.692],
    'conquista': [4.1160000000000005, 4.178, 5.746],
    'conquistadores': [4.391, 5.178999999999999, 3.99],
    'conquistar': [3.49, 4.349, 5.209],
    'consciencia': [3.3739999999999997, 3.452, 6.146],
    'consecución': [3.2230000000000003, 2.6510000000000002, 3.35],
    'consecuencia': [4.15, 3.2769999999999997, 6.1979999999999995],
    'consejo': [3.946, 4.157, 6.075],
    'consenso': [3.5589999999999997, 2.713, 2.322],
    'consentimiento': [3.471, 2.6010000000000004, 4.931],
    'conserje': [5.999, 5.6979999999999995, 4.412],
    'conserva': [3.7289999999999996, 4.216, 4.702],
    'conservación': [3.3160000000000003, 3.755, 4.559],
    'conservador': [4.47, 3.082, 4.522],
    'conservadora': [3.844, 2.909, 4.853],
    'conservar': [3.778, 3.9539999999999997, 6.202000000000001],
    'conservatorio': [5.518, 4.552, 4.064],
    'consideración': [2.957, 3.094, 4.6930000000000005],
    'considerar': [3.2769999999999997, 3.1460000000000004, 5.9270000000000005],
    'considerarse': [2.9760000000000004, 1.969, 5.59],
    'consigna': [4.244, 3.678, 4.122],
    'consistencia': [2.966, 2.721, 3.73],
    'consola': [5.185, 6.063, 4.413],
    'consolación': [3.677, 3.465, 4.059],
    'consolarse': [3.9930000000000003, 3.8339999999999996, 4.9],
    'consolidación': [3.4739999999999998, 3.865, 3.977],
    'conspiración': [3.707, 3.273, 3.2119999999999997],
    'constancia': [3.6830000000000003, 3.2969999999999997, 4.217],
    'constante': [3.363, 3.154, 6.111000000000001],
    'constatación': [3.196, 1.5830000000000002, 2.7689999999999997],
    'constatar': [4.022, 2.401, 5.06],
    'constelación': [5.067, 4.785, 4.0],
    'constitución': [5.232, 3.2110000000000003, 4.645],
    'constituir': [3.234, 3.281, 5.131],
    'constituyente': [4.197, 3.056, 2.384],
    'construcción': [3.612, 5.443, 5.801],
    'construir': [3.825, 4.592, 5.513],
    'construirse': [3.877, 3.595, 4.984],
    'consuelo': [3.597, 3.975, 5.412999999999999],
    'consulado': [5.5920000000000005, 4.794, 4.133],
    'consulta': [4.065, 4.454, 5.653],
    'consumación': [3.2030000000000003, 2.714, 3.255],
    'consumir': [3.409, 4.5680000000000005, 5.876],
    'consumo': [3.7739999999999996, 3.404, 5.888],
    'contabilidad': [5.329, 3.6239999999999997, 4.5569999999999995],
    'contable': [4.891, 4.883, 5.216],
    'contacto': [3.397, 4.9639999999999995, 6.127000000000001],
    'contador': [4.111000000000001, 5.178, 5.457000000000001],
    'contagio': [4.702, 3.486, 4.868],
    'contaminación': [5.044, 4.489, 5.2],
    'contar': [3.748, 4.465, 6.553],
    'contemplación':
    [3.6919999999999997, 4.1930000000000005, 4.763999999999999],
    'contemplar': [3.5989999999999998, 4.563, 4.46],
    'contemporáneo': [4.346, 3.049, 4.485],
    'contención': [3.73, 2.6639999999999997, 3.866],
    'contener': [3.783, 3.608, 6.024],
    'contenido': [3.3939999999999997, 3.897, 5.939],
    'contertulios': [5.24, 4.252, 3.968],
    'contestación': [4.056, 3.935, 6.172000000000001],
    'contestador': [5.317, 5.694, 5.784],
    'contestar': [3.6189999999999998, 5.0, 6.359],
    'contexto': [3.245, 2.8960000000000004, 4.375],
    'contienda': [4.489, 3.7319999999999998, 3.089],
    'continente': [5.316, 5.4110000000000005, 5.575],
    'contingencia': [3.387, 2.51, 4.723],
    'continuación': [4.113, 3.034, 5.565],
    'continuar': [3.9210000000000003, 3.5210000000000004, 5.627000000000001],
    'continuidad': [3.3280000000000003, 2.39, 4.0089999999999995],
    'contorno': [3.7239999999999998, 4.529, 5.071000000000001],
    'contrabando': [4.559, 5.077, 4.476],
    'contracción': [3.653, 3.9160000000000004, 4.59],
    'contradicción': [4.277, 3.303, 5.442],
    'contrapartida': [3.6510000000000002, 1.635, 4.275],
    'contrariedad': [3.597, 3.398, 4.243],
    'contrarios': [3.455, 3.727, 5.2829999999999995],
    'contrarrestar': [4.224, 1.9809999999999999, 4.107],
    'contraste': [3.48, 3.574, 5.744],
    'contrato': [4.426, 5.584, 5.129],
    'contribución': [4.075, 3.562, 5.03],
    'contribuir': [3.3710000000000004, 2.681, 4.385],
    'contrincante': [5.555, 4.529, 4.897],
    'control': [3.338, 2.883, 5.695],
    'controlar': [3.4010000000000002, 3.1630000000000003, 6.615],
    'controversia': [2.909, 1.839, 3.305],
    'convencer': [4.578, 2.7969999999999997, 6.237],
    'convencerse': [3.951, 3.542, 5.247000000000001],
    'convencimiento': [3.5389999999999997, 3.386, 4.107],
    'convención': [4.803999999999999, 3.697, 4.261],
    'conveniencia': [3.6180000000000003, 2.383, 4.988],
    'convenio': [3.972, 3.049, 3.7039999999999997],
    'convento': [6.343999999999999, 5.566, 4.584],
    'convergencia': [3.734, 2.676, 3.2510000000000003],
    'conversación': [4.8, 4.957, 6.169],
    'conversar': [4.9719999999999995, 4.6419999999999995, 5.087],
    'conversión': [2.702, 2.395, 4.303999999999999],
    'convertir': [3.403, 3.3930000000000002, 4.657],
    'convertirse': [2.965, 2.4130000000000003, 5.289],
    'convicción': [3.782, 3.503, 4.749],
    'convivencia': [3.923, 4.626, 6.084],
    'convivir': [5.237, 4.904, 6.0489999999999995],
    'convocatoria': [4.481, 2.958, 5.351],
    'convulsiones': [5.075, 5.081, 4.2410000000000005],
    'cooperativistas': [4.402, 3.175, 3.85],
    'coordenadas': [4.301, 3.7, 5.1610000000000005],
    'copa': [5.289, 6.388, 6.017],
    'copia': [4.25, 4.808, 6.4479999999999995],
    'copiar': [4.893, 4.75, 5.821000000000001],
    'copla': [4.534, 4.209, 4.382],
    'copos': [4.645, 5.727, 5.75],
    'coraje': [3.5789999999999997, 3.838, 4.603],
    'coral': [5.22, 5.122000000000001, 3.8989999999999996],
    'coraza': [4.881, 5.301, 2.95],
    'corazón': [6.007999999999999, 6.1579999999999995, 6.7589999999999995],
    'corbata': [6.545, 6.148, 5.547000000000001],
    'cordel': [5.756, 4.7010000000000005, 4.191],
    'cordero': [6.039, 6.0120000000000005, 6.212999999999999],
    'cordialidad': [3.4619999999999997, 3.8930000000000002, 4.362],
    'cordillera': [5.722, 5.707000000000001, 4.761],
    'cordón': [5.3420000000000005, 6.0520000000000005, 5.497999999999999],
    'cornisa': [6.053, 2.47, 2.715],
    'coro': [4.801, 5.334, 5.5],
    'corona': [5.557, 5.557, 3.123],
    'corpus': [4.1160000000000005, 2.951, 3.911],
    'corredor': [4.531000000000001, 5.416, 5.682],
    'corregir': [4.071000000000001, 3.638, 4.99],
    'correlación': [4.248, 2.546, 5.32],
    'correo': [5.482, 4.945, 5.377999999999999],
    'correr': [4.64, 5.6, 6.481],
    'correspondencia': [4.681, 4.6530000000000005, 5.285],
    'corresponder': [3.083, 3.1510000000000002, 5.622000000000001],
    'corriente': [3.7289999999999996, 4.273, 5.97],
    'corrimiento': [3.387, 3.6060000000000003, 3.444],
    'corrupción': [4.923, 4.359, 5.981],
    'cortar': [4.336, 5.705, 5.696000000000001],
    'corte': [3.819, 4.474, 5.875],
    'cortes': [3.875, 3.582, 4.468999999999999],
    'cortesana': [5.194, 4.145, 3.628],
    'cortesía': [3.49, 3.6889999999999996, 4.851],
    'corteza': [4.766, 5.672999999999999, 4.912],
    'cortijo': [5.629, 4.749, 3.076],
    'cortina': [6.2, 5.638999999999999, 5.659],
    'corán': [5.778, 3.832, 3.638],
    'cosa': [2.627, 3.739, 4.89],
    'cosecha': [5.428999999999999, 5.405, 5.346],
    'coser': [5.593999999999999, 5.6770000000000005, 5.287999999999999],
    'cosmos': [4.145, 4.619, 3.093],
    'cosméticos': [5.234, 6.091, 5.294],
    'costa': [5.082, 5.441, 5.412999999999999],
    'costado': [4.761, 4.61, 4.165],
    'costar': [3.685, 4.1080000000000005, 6.178],
    'coste': [3.437, 2.358, 5.085],
    'costillas': [5.792000000000001, 5.98, 5.367000000000001],
    'costumbre': [5.098, 3.908, 6.3629999999999995],
    'costura': [5.456, 5.454, 4.465],
    'cota': [3.841, 3.073, 3.077],
    'cotilleo': [4.223, 5.202999999999999, 5.571000000000001],
    'coyote': [5.327000000000001, 5.789, 4.121],
    'coágulos': [5.386, 4.126, 4.31],
    'coño': [5.922000000000001, 5.377999999999999, 5.664],
    'creación': [3.569, 3.4589999999999996, 5.103],
    'creador': [3.99, 4.209, 4.962],
    'creadora': [3.822, 3.585, 5.529],
    'crear': [3.483, 4.128, 5.944],
    'crearse': [3.577, 2.7560000000000002, 5.162000000000001],
    'creatividad': [3.275, 4.814, 5.921],
    'crecer': [4.502, 4.95, 6.319],
    'crecimiento': [4.021, 4.0360000000000005, 6.074],
    'creencia': [4.22, 3.253, 5.329],
    'creer': [3.819, 4.106, 6.377999999999999],
    'creerse': [3.111, 3.071, 5.631],
    'crema': [4.9910000000000005, 6.029, 6.277],
    'cremallera': [5.82, 5.127000000000001, 5.3839999999999995],
    'crepúsculo': [5.37, 5.105, 4.485],
    'cresta': [4.893, 5.7829999999999995, 4.251],
    'creyente': [3.859, 3.696, 4.761],
    'criada': [5.392, 5.542999999999999, 5.468],
    'criado': [5.165, 5.867999999999999, 5.38],
    'crianza': [4.044, 3.767, 4.292],
    'criatura': [4.261, 5.218, 5.013],
    'crimen': [4.922, 5.601, 5.138999999999999],
    'crisis': [3.8160000000000003, 3.955, 6.352],
    'crisma': [4.645, 3.897, 2.519],
    'cristal': [5.879, 5.702999999999999, 6.638],
    'cristiano': [4.755, 4.262, 5.0969999999999995],
    'criterio': [3.031, 1.751, 4.651],
    'criticar': [4.798, 4.276, 5.832999999999999],
    'critico': [4.052, 3.6319999999999997, 5.931],
    'cromatina': [6.025, 2.7289999999999996, 2.699],
    'cromos': [5.459, 5.961, 5.41],
    'cromosoma': [6.0889999999999995, 4.166, 4.998],
    'cronista': [5.12, 4.282, 4.501],
    'cronología': [4.692, 3.1460000000000004, 5.1370000000000005],
    'cruce': [5.012, 5.845, 6.162999999999999],
    'crucero': [5.585, 5.936, 4.74],
    'crucifijo': [6.393, 6.4670000000000005, 4.1739999999999995],
    'crucifixión': [4.5680000000000005, 5.038, 3.3510000000000004],
    'crudeza': [4.023, 3.194, 4.059],
    'crueldad': [3.9360000000000004, 3.082, 4.762],
    'crujido': [4.454, 5.353, 4.879],
    'cruzadas': [4.159, 3.8689999999999998, 2.7969999999999997],
    'cruzado': [3.0610000000000004, 4.018, 4.365],
    'cruzar': [4.053999999999999, 4.913, 5.671],
    'crédito': [4.967, 2.761, 4.758],
    'cría': [4.471, 4.374, 5.364],
    'crío': [4.516, 5.457000000000001, 5.273],
    'crítica': [3.625, 3.1010000000000004, 6.1370000000000005],
    'crítico': [3.323, 3.15, 5.94],
    'crónica': [4.28, 3.755, 4.773],
    'cuaderno': [5.172999999999999, 6.399, 6.662999999999999],
    'cuadra': [5.485, 5.952999999999999, 5.063],
    'cuadrado': [5.61, 6.018, 6.272],
    'cuadrilla': [4.073, 4.48, 3.258],
    'cuadro': [4.5760000000000005, 6.656000000000001, 6.318],
    'cualidad': [2.517, 2.46, 5.316],
    'cuantía': [2.7769999999999997, 2.205, 3.556],
    'cuartel': [5.375, 5.984, 5.43],
    'cuarto': [3.9730000000000003, 5.553999999999999, 6.223],
    'cuarzo': [5.648, 5.415, 3.673],
    'cuba': [4.98, 5.132000000000001, 5.332999999999999],
    'cubierta': [3.78, 4.079, 3.8569999999999998],
    'cubiertos': [4.979, 6.167000000000001, 6.206],
    'cubil': [4.612, 4.237, 3.082],
    'cubismo': [4.387, 3.571, 3.2689999999999997],
    'cubo': [5.169, 5.129, 6.232],
    'cubrir': [4.303999999999999, 4.737, 6.097],
    'cuchilla': [5.815, 5.459, 5.647],
    'cuchillo': [6.506, 6.499, 6.335],
    'cuello': [5.772, 5.825, 6.017],
    'cuenca': [4.217, 3.872, 3.957],
    'cuenco': [5.122000000000001, 5.626, 5.126],
    'cuenta': [3.8339999999999996, 4.391, 6.0089999999999995],
    'cuento': [3.802, 5.707999999999999, 6.465],
    'cuerda': [5.329, 6.547000000000001, 6.065],
    'cuerno': [5.465, 6.053999999999999, 5.848],
    'cuero': [5.099, 4.898, 5.382999999999999],
    'cuerpo': [5.119, 6.115, 6.218],
    'cuervos': [5.801, 6.057, 5.593],
    'cuesta': [4.04, 5.402, 5.294],
    'cuestión': [3.25, 3.261, 5.617000000000001],
    'cueva': [6.002000000000001, 5.715, 4.4510000000000005],
    'cuidar': [4.144, 4.6080000000000005, 6.52],
    'cuidarse': [4.104, 3.492, 6.42],
    'cuitas': [2.752, 2.655, 1.526],
    'culebra': [6.522, 6.407, 6.282],
    'culminación': [4.215, 4.221, 3.765],
    'culminar': [3.176, 2.456, 3.219],
    'culo': [6.122999999999999, 6.398, 6.0760000000000005],
    'culpa': [3.622, 3.572, 5.617000000000001],
    'culpabilidad': [3.582, 4.401, 5.452000000000001],
    'culpable': [3.875, 4.4430000000000005, 5.394],
    'cultivar': [4.2219999999999995, 5.281000000000001, 4.8180000000000005],
    'cultivo': [4.542, 5.51, 5.021],
    'culto': [3.1189999999999998, 3.968, 5.278],
    'cultura': [3.105, 3.202, 6.305],
    'cumbre': [4.652, 5.865, 4.391],
    'cumpleaños': [5.891, 5.521, 6.874],
    'cumplido': [3.392, 2.875, 4.984],
    'cumplimiento': [3.4419999999999997, 2.524, 4.6610000000000005],
    'cumplir': [3.161, 2.891, 5.65],
    'cuna': [5.861000000000001, 6.069, 4.718],
    'cuneta': [4.803, 5.279, 4.744],
    'cuota': [4.58, 3.148, 5.066],
    'cura': [4.311, 5.455, 5.914],
    'curación': [4.019, 3.992, 5.739],
    'curar': [4.822, 4.272, 5.897],
    'curarse': [4.659, 3.9739999999999998, 5.234],
    'curiosidad': [4.291, 2.951, 5.572],
    'curioso': [4.7010000000000005, 3.9219999999999997, 6.331],
    'cursi': [4.7589999999999995, 5.149, 5.949],
    'curso': [4.129, 2.813, 5.082],
    'curva': [5.716, 6.194, 6.597],
    'curvatura': [3.4539999999999997, 4.355, 3.062],
    'custodia': [4.043, 4.164, 4.084],
    'cutis': [5.752999999999999, 5.372999999999999, 4.579],
    'cuñada': [5.796, 4.662, 5.693],
    'cuñado': [5.435, 5.062, 5.84],
    'cálculo': [4.046, 3.344, 5.018],
    'cáliz': [5.641, 5.7989999999999995, 4.647],
    'cámara': [4.43, 6.257000000000001, 6.231],
    'cáncer': [5.221, 4.481, 6.2170000000000005],
    'cárcel': [5.827000000000001, 5.75, 5.67],
    'cáscara': [5.892, 5.8629999999999995, 5.442],
    'cátedra': [5.277, 3.549, 4.228],
    'célula': [5.603, 4.454, 6.202999999999999],
    'césped': [6.065, 6.52, 5.615],
    'círculo': [5.627000000000001, 5.501, 6.0120000000000005],
    'cítricos': [4.6339999999999995, 5.004, 4.816],
    'código': [3.855, 4.2010000000000005, 4.668],
    'cólera': [4.058, 4.254, 3.248],
    'cómico': [4.809, 4.99, 4.526],
    'cómoda': [4.755, 5.939, 6.228],
    'cómplice': [4.853, 4.471, 5.14],
    'cónsul': [5.561, 2.399, 3.2710000000000004],
    'cónyuge': [5.481, 5.295, 3.7039999999999997],
    'cúmulo': [2.821, 2.271, 3.34],
    'cúpula': [5.667999999999999, 5.114, 3.8310000000000004],
    'dado': [5.712999999999999, 5.273, 5.31],
    'dama': [4.593999999999999, 5.4670000000000005, 3.6069999999999998],
    'danza': [4.685, 6.21, 4.92],
    'danés': [5.191, 4.665, 3.556],
    'dar': [3.843, 4.7219999999999995, 6.7010000000000005],
    'dardo': [5.938, 6.268, 5.489],
    'darwinista': [4.407, 2.55, 4.541],
    'dato': [3.7710000000000004, 3.516, 5.437],
    'daño': [4.538, 4.4830000000000005, 6.2170000000000005],
    'deambular': [3.8810000000000002, 3.841, 3.324],
    'deber': [3.648, 3.175, 6.151],
    'debilidad': [4.609, 3.2319999999999998, 6.011],
    'decadencia': [3.29, 3.52, 4.247],
    'decenio': [5.603, 2.633, 3.15],
    'decidir': [4.043, 3.2910000000000004, 6.2010000000000005],
    'decidirse': [4.007, 3.1660000000000004, 5.008],
    'decisión': [3.595, 2.793, 6.606],
    'declaración': [4.096, 4.565, 5.2139999999999995],
    'declarar': [3.4389999999999996, 3.74, 4.921],
    'declive': [3.5669999999999997, 3.1060000000000003, 2.782],
    'decoración': [4.772, 4.602, 6.152],
    'decorado': [4.745, 5.306, 5.675],
    'decreto': [4.669, 3.216, 3.617],
    'dedicación': [3.847, 3.5669999999999997, 5.159],
    'dedicar': [3.259, 3.156, 5.388999999999999],
    'dedicarse': [3.9810000000000003, 3.21, 6.292000000000001],
    'dedo': [6.337000000000001, 5.52, 6.377999999999999],
    'deducción': [4.122, 2.839, 4.718999999999999],
    'deducir': [3.105, 2.827, 6.04],
    'deducirse': [3.775, 2.653, 5.522],
    'defecto': [3.807, 4.763, 6.1],
    'defender': [3.739, 4.5, 5.449],
    'defenderse': [4.802, 4.79, 5.472],
    'defensa': [3.464, 3.5060000000000002, 5.191],
    'defensor': [4.571000000000001, 3.741, 4.643],
    'deficiencia': [3.806, 4.898, 5.606],
    'definición': [3.697, 3.883, 6.292999999999999],
    'definir': [3.67, 3.522, 5.733],
    'degeneración': [4.021, 3.4, 4.492],
    'degradación': [3.8760000000000003, 3.239, 3.747],
    'dejar': [4.247, 4.16, 6.318],
    'dejarme': [3.978, 3.614, 6.4639999999999995],
    'dejarse': [3.641, 2.784, 5.974],
    'deje': [2.937, 2.42, 3.949],
    'delantal': [6.013999999999999, 6.0889999999999995, 6.057],
    'delantera': [3.408, 4.71, 5.574],
    'delegación': [4.197, 3.4010000000000002, 3.312],
    'delfines': [6.432, 6.582000000000001, 5.194],
    'delgadez': [4.8260000000000005, 5.867999999999999, 6.176],
    'delicadeza': [4.1819999999999995, 4.393, 5.278],
    'delicia': [3.905, 4.681, 4.968],
    'delimitación': [3.5460000000000003, 3.431, 3.552],
    'delincuencia': [4.385, 4.204, 5.207000000000001],
    'delincuente': [5.3870000000000005, 5.252999999999999, 5.403],
    'delirio': [4.132, 3.3139999999999996, 5.146],
    'delito': [4.398, 4.34, 5.49],
    'delta': [4.235, 4.361000000000001, 3.965],
    'demanda': [3.861, 3.7539999999999996, 5.562],
    'democracia': [4.254, 3.134, 4.981],
    'demonio': [4.809, 5.142, 5.593],
    'demora': [3.9810000000000003, 4.354, 5.1370000000000005],
    'demostración': [3.201, 3.444, 5.093999999999999],
    'demostrar': [3.7769999999999997, 3.64, 5.944],
    'denominación': [3.602, 2.806, 4.218],
    'denominar': [3.8789999999999996, 1.7819999999999998, 3.945],
    'densidad': [4.313, 3.031, 4.774],
    'dentadura': [6.4910000000000005, 5.824, 5.733],
    'denuncia': [3.937, 3.7, 4.774],
    'denunciar': [4.857, 4.244, 5.475],
    'departamento': [4.659, 4.171, 4.963],
    'dependencia': [3.219, 3.372, 4.938],
    'deportistas': [4.981, 5.979, 6.659],
    'deportivo': [4.359, 5.07, 4.565],
    'depredadores': [4.168, 5.3020000000000005, 4.498],
    'depresión': [4.2860000000000005, 4.77, 5.832999999999999],
    'depósito': [3.648, 4.67, 4.8580000000000005],
    'derecha': [5.877999999999999, 4.977, 5.835],
    'derecho': [3.707, 3.75, 6.186],
    'derivadas': [3.174, 3.3169999999999997, 4.796],
    'derivados': [3.222, 2.8080000000000003, 4.718],
    'derribar': [3.945, 4.734, 3.806],
    'derroche': [3.306, 3.813, 4.629],
    'derrota': [4.413, 4.272, 5.229],
    'derroteros': [3.407, 1.818, 1.932],
    'desacuerdo': [4.373, 3.6489999999999996, 6.0760000000000005],
    'desafío': [3.918, 3.446, 4.601],
    'desagrado': [3.266, 3.835, 4.306],
    'desahogo': [3.563, 2.8480000000000003, 5.85],
    'desaliento': [3.912, 3.262, 3.165],
    'desamparo': [3.89, 3.721, 3.7260000000000004],
    'desaparecer': [3.966, 4.477, 5.6739999999999995],
    'desaparecidos': [4.155, 3.2680000000000002, 5.14],
    'desaparición': [3.719, 3.449, 5.24],
    'desarrollar': [3.265, 2.818, 5.004],
    'desarrollarse': [3.335, 3.2560000000000002, 6.382000000000001],
    'desarrollo': [3.261, 3.117, 5.6579999999999995],
    'desasosiego': [4.0969999999999995, 3.5180000000000002, 3.888],
    'desastre': [4.428999999999999, 4.832, 5.938],
    'desayunar': [5.871, 5.687, 6.5520000000000005],
    'desayuno': [5.808, 6.46, 5.99],
    'desazón': [3.677, 2.7680000000000002, 2.6489999999999996],
    'descampado': [4.566, 5.757999999999999, 4.8660000000000005],
    'descansar': [4.904, 5.195, 6.209],
    'descansillo': [4.737, 4.421, 4.484],
    'descanso': [5.242000000000001, 4.7330000000000005, 6.396],
    'descarga': [4.552, 4.447, 4.628],
    'descargar': [4.322, 5.702000000000001, 5.722],
    'descaro': [3.759, 3.596, 4.0680000000000005],
    'descartar': [3.286, 2.8139999999999996, 4.862],
    'descendencia': [4.321000000000001, 4.754, 5.0489999999999995],
    'descender': [4.071000000000001, 4.455, 4.899],
    'descendiente': [4.162, 3.511, 6.175],
    'descenso': [3.7430000000000003, 4.395, 4.935],
    'descifrar': [3.7539999999999996, 2.408, 5.515],
    'descomposición': [3.93, 4.229, 3.458],
    'desconcierto': [3.665, 3.109, 4.806],
    'desconfianza': [3.5660000000000003, 3.449, 5.4510000000000005],
    'desconfiar': [4.283, 3.781, 5.757999999999999],
    'desconocida': [4.84, 3.53, 4.7330000000000005],
    'desconocido': [3.9760000000000004, 3.275, 6.034],
    'desconsuelo': [3.417, 3.158, 3.9210000000000003],
    'descontento': [4.274, 4.189, 5.42],
    'descripción': [3.9210000000000003, 2.998, 5.256],
    'descubriendo': [3.159, 3.514, 5.524],
    'descubrimiento': [5.119, 4.454, 5.7010000000000005],
    'descubrir': [3.498, 4.032, 6.5360000000000005],
    'desdicha': [2.8510000000000004, 3.647, 4.683],
    'desdén': [4.371, 2.7110000000000003, 2.637],
    'desembarco': [5.5920000000000005, 4.7780000000000005, 4.669],
    'desembocar': [4.0489999999999995, 3.94, 4.609],
    'desempeñar': [3.693, 3.178, 4.997],
    'desencadenar': [3.408, 3.948, 4.578],
    'desencanto': [3.4210000000000003, 3.36, 4.609],
    'desengaños': [3.693, 4.315, 4.988],
    'desenlace': [4.5169999999999995, 3.322, 5.791],
    'desentrañar': [3.515, 2.211, 3.043],
    'desenvoltura': [2.9739999999999998, 3.6489999999999996, 3.611],
    'deseo': [3.8280000000000003, 4.678999999999999, 6.145],
    'desequilibrio': [3.147, 2.9760000000000004, 4.754],
    'desesperación': [4.245, 5.716, 6.119],
    'desesperanza': [3.055, 3.2710000000000004, 4.356],
    'desfachatez': [3.883, 3.722, 3.2760000000000002],
    'desfiladero': [5.564, 5.21, 3.1180000000000003],
    'desfilar': [4.821000000000001, 5.801, 5.072],
    'desfile': [4.721, 4.909, 5.189],
    'desgana': [4.312, 2.898, 4.077],
    'desgaste': [3.745, 3.425, 5.1579999999999995],
    'desgracia': [4.401, 4.204, 6.416],
    'desgraciados': [4.234, 4.172, 5.827000000000001],
    'deshacer': [2.7969999999999997, 3.69, 6.055],
    'deshacerse': [3.513, 3.585, 5.1],
    'deshecho': [3.4130000000000003, 4.178999999999999, 5.146],
    'desidia': [3.397, 2.522, 1.7309999999999999],
    'desierto': [5.1579999999999995, 6.652, 5.71],
    'designación': [3.4010000000000002, 2.946, 3.484],
    'designar': [3.74, 3.1239999999999997, 4.779],
    'desigualdad': [3.877, 4.063, 6.075],
    'desintegración': [3.971, 4.183, 4.21],
    'desinterés': [3.487, 3.252, 5.359],
    'desistir': [4.488, 2.667, 4.746],
    'deslizarse': [4.401, 4.72, 5.442],
    'desmayo': [4.967, 4.968, 4.698],
    'desmontar': [4.4430000000000005, 4.5569999999999995, 5.162999999999999],
    'desnudez': [4.774, 5.899, 4.513],
    'desnudo': [5.601, 6.494, 6.065],
    'desolación': [3.412, 3.4760000000000004, 4.508],
    'desorden': [3.525, 4.997, 5.8260000000000005],
    'despacho': [5.417000000000001, 4.912, 6.1370000000000005],
    'despecho': [3.095, 2.958, 3.738],
    'despegue': [3.8310000000000004, 5.0489999999999995, 3.5180000000000002],
    'desperdicios': [4.669, 5.678, 5.697],
    'despertador': [6.037999999999999, 6.641, 6.462999999999999],
    'despertar': [4.624, 5.099, 5.7379999999999995],
    'despertarse': [5.645, 5.118, 6.909],
    'despilfarro': [3.886, 3.676, 4.512],
    'despiste': [5.154, 3.96, 6.007999999999999],
    'desplazamiento': [4.131, 4.773, 4.55],
    'desplazarse': [4.341, 4.843, 5.486000000000001],
    'desplegar': [3.917, 3.6519999999999997, 4.5569999999999995],
    'despliegue': [3.1180000000000003, 2.4, 2.22],
    'despojos': [3.983, 3.867, 4.118],
    'despreciar': [3.8289999999999997, 3.333, 4.248],
    'desprecio': [3.827, 3.7310000000000003, 5.847],
    'despreocupación': [3.767, 3.728, 5.075],
    'destello': [4.298, 4.89, 3.4560000000000004],
    'desterrar': [4.664, 4.383, 4.329],
    'destierro': [4.005, 3.821, 3.2230000000000003],
    'destinatario': [4.941, 3.7119999999999997, 5.63],
    'destreza': [3.742, 2.946, 4.502],
    'destrucción': [4.615, 5.393, 5.318],
    'destruir': [3.9210000000000003, 4.984, 5.8229999999999995],
    'desuso': [3.345, 2.2119999999999997, 3.213],
    'desvelar': [3.917, 3.466, 3.8819999999999997],
    'desventaja': [3.6510000000000002, 3.1910000000000003, 5.1610000000000005],
    'desventura': [3.5660000000000003, 2.615, 4.618],
    'desviación': [3.1189999999999998, 3.8369999999999997, 5.255],
    'desviar': [3.5469999999999997, 3.4389999999999996, 5.325],
    'desván': [5.649, 6.127000000000001, 4.495],
    'desánimo': [3.943, 4.418, 5.8260000000000005],
    'detalle': [3.5260000000000002, 4.088, 5.542000000000001],
    'detección': [4.275, 2.806, 4.185],
    'detectar': [3.278, 2.97, 5.212999999999999],
    'detector': [4.199, 3.429, 4.795],
    'detención': [4.484, 4.578, 4.45],
    'detener': [4.0360000000000005, 4.801, 6.093],
    'detenerse': [4.644, 5.067, 4.659],
    'detenida': [4.496, 4.827, 5.226],
    'detenido': [4.385, 4.323, 4.852],
    'detergente': [6.042000000000001, 6.407, 6.25],
    'deterioro': [3.7510000000000003, 4.535, 4.928999999999999],
    'determinación': [3.157, 2.693, 3.793],
    'determinante': [3.6639999999999997, 2.029, 5.693],
    'determinar': [3.155, 1.94, 4.262],
    'determinismo': [3.6180000000000003, 2.571, 2.362],
    'deuda': [4.471, 3.873, 5.86],
    'deuterio': [3.1630000000000003, 1.555, 1.151],
    'devenir': [3.159, 2.387, 4.263999999999999],
    'devoción': [4.377, 3.04, 5.814],
    'devolver': [3.8510000000000004, 4.229, 6.507000000000001],
    'devorar': [5.093, 5.8629999999999995, 6.072],
    'devoto': [4.646, 4.213, 4.851],
    'diablo': [5.312, 5.506, 5.86],
    'diagnóstico': [4.333, 3.5980000000000003, 5.0],
    'diagonal': [5.231, 5.196000000000001, 5.4670000000000005],
    'diagrama': [5.105, 5.801, 4.553],
    'dialecto': [4.586, 3.0180000000000002, 3.4139999999999997],
    'dialogo': [5.181, 5.437, 5.93],
    'dialéctica': [4.067, 2.8310000000000004, 3.0439999999999996],
    'diamantes': [6.377999999999999, 6.107, 5.312],
    'diana': [5.587000000000001, 5.454, 3.472],
    'diapositivas': [6.077999999999999, 5.98, 5.803999999999999],
    'diario': [5.0360000000000005, 5.787999999999999, 6.351],
    'dibujar': [5.194, 5.797999999999999, 6.502000000000001],
    'dibujo': [4.868, 6.027, 6.096],
    'diccionario': [6.062, 6.2, 6.761],
    'dicción': [4.209, 2.0980000000000003, 2.72],
    'dicha': [3.138, 3.266, 4.763999999999999],
    'dicho': [2.738, 2.844, 5.083],
    'diciembre': [5.711, 5.449, 6.263],
    'dictado': [4.955, 5.104, 5.636],
    'dictadura': [4.559, 4.406000000000001, 4.863],
    'dictamen': [4.197, 2.58, 2.6689999999999996],
    'dictar': [4.8839999999999995, 4.47, 5.295],
    'diente': [6.239, 6.904, 6.314],
    'diestra': [4.89, 4.287, 4.867],
    'diestro': [5.461, 4.912, 4.853],
    'dieta': [4.901, 4.271, 5.902],
    'diferencia': [3.573, 3.114, 6.705],
    'diferenciar': [3.9389999999999996, 2.571, 5.008],
    'dificultad': [3.205, 3.41, 5.62],
    'difunta': [5.59, 5.403, 5.966],
    'difunto': [6.119, 6.33, 5.8020000000000005],
    'difusión': [3.135, 2.189, 4.122],
    'digestión': [5.475, 3.548, 5.728],
    'dignidad': [3.23, 2.85, 4.257],
    'dijiste': [3.761, 3.7489999999999997, 5.563],
    'dilatación': [3.965, 5.041, 4.081],
    'diligencia': [4.167, 3.279, 3.457],
    'dimensión': [2.7510000000000003, 2.2359999999999998, 4.626],
    'dinamismo': [3.5660000000000003, 3.7319999999999998, 5.063],
    'dinero': [5.75, 6.216, 6.7139999999999995],
    'dinámica': [2.926, 3.365, 5.546],
    'dios': [3.245, 3.855, 5.452000000000001],
    'diputación': [3.765, 2.9960000000000004, 2.7939999999999996],
    'diputado': [6.047000000000001, 5.023, 5.962000000000001],
    'dirección': [4.171, 3.9789999999999996, 6.055],
    'directivos': [4.552, 4.457, 5.052],
    'director': [5.962999999999999, 5.654, 6.229],
    'directora': [5.957000000000001, 5.244, 6.135],
    'dirigente': [4.473, 4.439, 4.811],
    'dirigir': [3.926, 4.203, 5.521],
    'dirigirse': [3.937, 3.4330000000000003, 5.475],
    'discernir': [3.702, 2.551, 3.718],
    'disciplina': [3.841, 3.806, 5.715],
    'disco': [5.189, 5.836, 6.071000000000001],
    'discordia': [3.694, 3.56, 4.626],
    'discoteca': [6.07, 6.101, 6.001],
    'discreción': [3.949, 2.8280000000000003, 4.545],
    'discrepancia': [3.469, 3.217, 3.5060000000000002],
    'discriminación': [4.499, 4.592, 5.1339999999999995],
    'disculpa': [4.334, 4.479, 5.478],
    'discurrir': [3.409, 2.622, 4.62],
    'discurso': [5.165, 4.6419999999999995, 6.105],
    'discusión': [4.275, 5.386, 5.867000000000001],
    'discutir': [4.489, 4.986000000000001, 5.981],
    'discípulo': [4.551, 3.9610000000000003, 5.011],
    'diseñador': [5.395, 5.195, 4.931],
    'diseñar': [4.132, 4.5969999999999995, 4.9319999999999995],
    'diseño': [3.5239999999999996, 4.084, 5.435],
    'disfraz': [5.07, 5.91, 4.487],
    'disfrutar': [4.2330000000000005, 4.8069999999999995, 6.354],
    'disfrute': [3.4219999999999997, 4.346, 5.93],
    'disgusto': [4.246, 4.4639999999999995, 6.375],
    'disimular': [4.261, 3.557, 6.025],
    'disimulo': [4.656000000000001, 3.6660000000000004, 5.162999999999999],
    'disminución': [3.863, 3.9789999999999996, 5.721],
    'disminuido': [3.838, 5.046, 5.381],
    'disminuir': [3.883, 3.596, 4.626],
    'disolución': [3.872, 3.318, 3.765],
    'disparar': [5.249, 4.987, 5.122000000000001],
    'disparate': [3.9219999999999997, 3.5660000000000003, 4.539],
    'disparo': [5.112, 5.4639999999999995, 5.393],
    'dispersión': [2.611, 3.25, 4.749],
    'disponer': [3.502, 2.988, 4.821000000000001],
    'disponibilidad': [3.593, 3.57, 4.256],
    'disposición': [2.99, 2.331, 4.944],
    'disputa': [4.427, 5.118, 3.93],
    'distanciamiento': [3.592, 4.09, 4.084],
    'distinción': [3.988, 3.75, 4.588],
    'distinguir': [3.728, 3.2560000000000002, 4.703],
    'distintivo': [3.799, 3.455, 4.781000000000001],
    'distorsión': [3.0669999999999997, 3.38, 4.598],
    'distraer': [4.088, 3.949, 5.784],
    'distraerse': [3.9160000000000004, 3.8939999999999997, 5.834],
    'distribución':
    [3.5810000000000004, 3.6239999999999997, 5.031000000000001],
    'diversidad': [2.315, 3.6689999999999996, 4.579],
    'diversión': [3.76, 5.6339999999999995, 6.504],
    'divertirse': [3.9160000000000004, 6.155, 6.457000000000001],
    'dividendos': [3.698, 3.4330000000000003, 3.8480000000000003],
    'dividir': [4.526, 4.771, 6.09],
    'divinidad': [3.142, 3.05, 4.609],
    'divisa': [5.002, 3.508, 2.109],
    'división': [4.166, 5.341, 5.404],
    'divorcio': [5.223, 4.274, 5.526],
    'diván': [6.023, 5.49, 3.515],
    'diálogo': [4.452, 4.73, 5.41],
    'diámetro': [5.504, 4.3, 4.325],
    'dióxido': [3.969, 2.0540000000000003, 3.71],
    'do': [4.521, 3.71, 3.391],
    'doble': [4.757, 4.109, 6.358],
    'docilidad': [3.293, 3.323, 3.925],
    'doctor': [4.593, 5.416, 6.07],
    'doctrina': [3.657, 2.853, 3.938],
    'documentación': [4.981, 5.181, 6.079],
    'documental': [4.939, 5.268, 6.108],
    'documento': [5.228, 4.9, 5.393],
    'dogma': [3.156, 2.864, 2.835],
    'dogmatismo': [3.261, 2.187, 3.0989999999999998],
    'dogmático': [4.14, 2.371, 4.334],
    'dolencia': [4.324, 4.539, 4.992],
    'dolor': [3.617, 5.225, 6.513999999999999],
    'domicilio': [6.015, 4.534, 6.261],
    'dominar': [3.818, 4.381, 5.917000000000001],
    'domingo': [6.256, 6.0520000000000005, 6.452000000000001],
    'dominicana': [5.603, 4.83, 3.9130000000000003],
    'dominio': [3.335, 2.8510000000000004, 4.4430000000000005],
    'don': [2.522, 1.715, 4.478],
    'doncella': [5.034, 5.769, 3.9819999999999998],
    'dorada': [4.137, 5.529, 5.346],
    'dormir': [5.776, 6.186, 6.676],
    'dormirse': [5.5, 5.067, 6.76],
    'dormitorio': [6.175, 6.401, 6.256],
    'dorso': [4.2780000000000005, 3.63, 4.265],
    'dosis': [4.14, 3.898, 3.966],
    'dotes': [3.612, 3.5469999999999997, 3.397],
    'dragón': [6.006, 5.882000000000001, 4.205],
    'dramatismo': [4.18, 3.5980000000000003, 4.854],
    'dramaturgo': [5.678999999999999, 3.9419999999999997, 3.1010000000000004],
    'droga': [5.307, 5.317, 6.205],
    'dualidad': [3.843, 2.627, 4.053],
    'ducado': [3.8480000000000003, 4.434, 3.614],
    'ducha': [5.303, 6.565, 7.0],
    'duda': [3.55, 3.342, 5.5489999999999995],
    'dudar': [3.5810000000000004, 2.983, 5.22],
    'dueña': [5.185, 4.925, 6.131],
    'dueño': [4.811, 4.025, 5.282],
    'dulzura': [2.867, 4.198, 5.196000000000001],
    'duque': [5.352, 4.247, 2.83],
    'duquesa': [4.998, 5.045, 4.752],
    'duración': [3.522, 2.737, 6.285],
    'durar': [3.548, 2.242, 5.937],
    'dureza': [3.6010000000000004, 4.343, 5.5489999999999995],
    'duro': [3.98, 5.245, 5.856],
    'década': [5.395, 3.0580000000000003, 5.252999999999999],
    'día': [4.897, 4.712, 5.857],
    'dólares': [6.196000000000001, 4.6610000000000005, 3.4539999999999997],
    'dúo': [6.1610000000000005, 5.885, 6.068],
    'echar': [4.442, 3.69, 6.51],
    'echarse': [3.778, 4.402, 5.196000000000001],
    'eclesiástico': [4.9239999999999995, 3.616, 3.158],
    'eco': [5.165, 3.9530000000000003, 5.012],
    'ecologista': [5.437, 4.496, 5.999],
    'ecología': [3.6660000000000004, 4.357, 5.273],
    'economía': [4.3580000000000005, 3.365, 6.615],
    'ecosistemas': [4.627, 4.553, 3.998],
    'ecuación': [4.85, 5.619, 5.0889999999999995],
    'edad': [5.483, 3.265, 6.916],
    'edición': [4.3839999999999995, 2.506, 4.749],
    'edificación': [4.1419999999999995, 5.019, 4.523],
    'edificar': [5.001, 5.038, 5.376],
    'edificio': [5.694, 6.568, 6.042000000000001],
    'editor': [5.066, 3.403, 3.975],
    'editorial': [4.131, 2.6639999999999997, 5.29],
    'educación': [4.5360000000000005, 3.918, 6.711],
    'educar': [4.052, 4.581, 6.15],
    'efectividad': [3.86, 3.748, 5.393],
    'efectivo': [3.572, 3.3480000000000003, 5.761],
    'efecto': [3.1919999999999997, 3.012, 5.519],
    'efectuar': [2.7310000000000003, 2.931, 5.401],
    'eficacia': [3.987, 2.844, 4.5569999999999995],
    'efigie': [5.571000000000001, 4.409, 2.714],
    'efluvios': [3.657, 2.594, 2.166],
    'egipcio': [5.691, 5.261, 5.331],
    'egoísmo': [3.8539999999999996, 2.935, 5.815],
    'eje': [4.501, 3.6689999999999996, 5.154],
    'ejecución': [4.434, 5.313, 5.24],
    'ejecutar': [4.325, 4.489, 5.337999999999999],
    'ejecutivo': [4.918, 5.99, 5.192],
    'ejemplo': [3.512, 3.016, 6.035],
    'ejercer': [3.46, 3.4739999999999998, 3.3939999999999997],
    'ejercicio': [4.262, 5.683, 6.513999999999999],
    'ejército': [5.587999999999999, 5.559, 5.607],
    'elaboración': [3.9019999999999997, 3.7760000000000002, 6.21],
    'elaborar': [3.889, 2.371, 4.5280000000000005],
    'elección': [4.243, 4.413, 5.277],
    'electricidad': [5.1979999999999995, 3.742, 5.818],
    'electrodos': [5.797999999999999, 3.8110000000000004, 4.7860000000000005],
    'electrón': [5.157, 2.9730000000000003, 3.883],
    'electrónica': [4.78, 3.4589999999999996, 5.568],
    'elefante': [6.412000000000001, 5.093999999999999, 5.82],
    'elegancia': [4.073, 4.169, 5.622999999999999],
    'elegir': [4.19, 3.9589999999999996, 6.662000000000001],
    'elemento': [3.2680000000000002, 3.273, 5.063],
    'elevación': [4.085, 3.887, 4.1530000000000005],
    'elevar': [4.162, 4.482, 4.81],
    'eliminación': [3.261, 2.866, 5.045],
    'eliminar': [3.873, 3.793, 5.1160000000000005],
    'elocuencia': [4.223, 2.7239999999999998, 3.7539999999999996],
    'elogiar': [4.303, 4.91, 4.801],
    'elogio': [4.02, 4.354, 4.1339999999999995],
    'eludir': [3.946, 3.049, 4.486000000000001],
    'elástico': [4.415, 4.3919999999999995, 5.528],
    'emancipación': [4.235, 2.9330000000000003, 4.3469999999999995],
    'embajada': [5.662000000000001, 4.388999999999999, 5.132999999999999],
    'embajador': [6.11, 4.954, 4.28],
    'embarazada': [6.051, 6.534, 6.252999999999999],
    'embarazo': [5.278, 5.528, 4.819],
    'emblema': [4.141, 3.725, 4.401],
    'embriaguez': [4.72, 5.229, 4.29],
    'embrión': [5.932, 4.636, 3.859],
    'embutido': [4.217, 5.935, 5.715],
    'emergencia': [4.779, 3.958, 5.9239999999999995],
    'emigración': [4.543, 4.548, 5.622999999999999],
    'emisión': [4.284, 3.338, 5.31],
    'emisor': [4.405, 3.8760000000000003, 3.838],
    'emisora': [5.053, 4.721, 5.696000000000001],
    'emitir': [2.9210000000000003, 3.072, 5.021],
    'emoción': [2.7319999999999998, 4.657, 5.765],
    'empacho': [4.723, 4.986000000000001, 5.8],
    'empezar': [4.029, 3.407, 6.665],
    'empeño': [3.6069999999999998, 3.214, 4.158],
    'emplazamiento': [3.705, 3.1630000000000003, 2.761],
    'empleada': [4.809, 4.615, 5.273],
    'empleado': [4.918, 5.041, 5.992000000000001],
    'emplear': [3.2030000000000003, 3.475, 5.435],
    'empleo': [5.303, 4.537, 5.642],
    'emprender': [3.925, 3.199, 4.1739999999999995],
    'emprendido': [3.952, 2.063, 4.562],
    'empresa': [5.172000000000001, 5.07, 5.84],
    'empresario': [5.195, 5.702000000000001, 5.417999999999999],
    'enamorada': [3.8510000000000004, 4.776, 6.303],
    'enamorado': [4.27, 5.643, 6.183],
    'enamorarse': [3.049, 5.928, 5.939],
    'enanas': [4.401, 4.522, 4.6080000000000005],
    'enano': [5.97, 5.484, 4.933],
    'encaje': [5.143, 4.665, 5.526],
    'encantador': [3.591, 4.013999999999999, 6.004],
    'encantadora': [3.792, 4.228, 5.96],
    'encantamiento': [3.447, 3.361, 4.032],
    'encanto': [3.358, 3.5210000000000004, 5.468],
    'encargada': [4.147, 4.939, 5.704],
    'encargado': [4.445, 4.444, 5.421],
    'encargo': [4.279, 3.728, 6.402],
    'encarnación': [3.2510000000000003, 1.847, 2.436],
    'encender': [3.3689999999999998, 5.268, 6.5329999999999995],
    'encendido': [4.291, 5.45, 6.709],
    'encerrarse': [3.995, 4.893, 5.4110000000000005],
    'enciclopedia': [5.867999999999999, 6.142, 5.746],
    'encierro': [4.37, 4.957, 4.296],
    'encontrar': [3.826, 4.148, 6.379],
    'encontrarse': [4.25, 4.425, 6.294],
    'encrucijada': [4.01, 3.904, 4.109],
    'encuentro': [3.219, 4.085, 6.1370000000000005],
    'encuesta': [5.249, 5.175, 5.586],
    'encías': [6.189, 5.437, 5.669],
    'enderezar': [4.685, 4.215, 4.506],
    'enemiga': [4.61, 4.365, 5.115],
    'enemigo': [5.023, 4.683, 5.646],
    'energía': [3.264, 2.7260000000000004, 5.9270000000000005],
    'enero': [5.8870000000000005, 4.308, 5.534],
    'enferma': [4.85, 5.817, 6.921],
    'enfermedad': [3.555, 4.962, 6.468],
    'enfermera': [6.597, 6.672999999999999, 6.403],
    'enfermo': [5.343, 6.11, 6.084],
    'enfocar': [3.767, 3.972, 4.265],
    'enfoque': [2.852, 2.464, 5.9],
    'enfrentamiento': [4.078, 4.499, 5.919],
    'enfrentar': [3.179, 3.3289999999999997, 4.765],
    'engañar': [3.841, 3.3560000000000003, 5.885],
    'engaño': [5.0569999999999995, 4.0280000000000005, 5.011],
    'engendrar': [4.657, 4.2669999999999995, 4.218999999999999],
    'engordar': [5.402, 5.615, 5.979],
    'enigma': [3.477, 3.565, 4.197],
    'enjambre': [5.607, 5.855, 3.728],
    'enlace': [3.972, 3.613, 4.857],
    'enojo': [3.965, 4.086, 3.802],
    'enredo': [4.022, 4.6610000000000005, 4.578],
    'ensalada': [5.114, 6.146, 6.575],
    'ensayo': [4.476, 3.76, 5.048],
    'enseres': [3.255, 3.888, 2.685],
    'enseñanza': [4.204, 4.4910000000000005, 5.335],
    'ensimismamiento': [4.386, 3.6919999999999997, 3.838],
    'ensoñación': [3.094, 4.156000000000001, 2.7689999999999997],
    'ente': [2.955, 2.213, 4.659],
    'entender': [3.6910000000000003, 3.572, 5.771],
    'entenderse': [3.772, 3.488, 6.191],
    'entendimiento': [3.17, 3.4339999999999997, 5.181],
    'enterar': [3.409, 3.094, 4.706],
    'entero': [3.37, 4.035, 6.255],
    'enterrar': [4.785, 5.6579999999999995, 4.715],
    'entidad': [3.572, 2.827, 4.042],
    'entierro': [5.374, 6.082999999999999, 5.945],
    'entonación': [4.031000000000001, 3.27, 4.198],
    'entorno': [3.475, 3.9130000000000003, 4.988],
    'entrada': [5.169, 5.106, 6.6129999999999995],
    'entrar': [4.96, 5.487, 6.593999999999999],
    'entraña': [3.924, 3.968, 3.659],
    'entrega': [4.026, 3.162, 4.941],
    'entregar': [4.291, 5.165, 6.735],
    'entregarse': [3.468, 3.716, 4.894],
    'entrenamiento': [3.784, 5.353, 6.024],
    'entrepierna': [5.984, 6.068, 5.478],
    'entresijos': [3.225, 3.5639999999999996, 2.41],
    'entretenimiento': [3.165, 4.421, 5.291],
    'entrever': [3.278, 3.2489999999999997, 3.699],
    'entrevista': [4.928, 5.167999999999999, 5.8020000000000005],
    'entusiasta': [3.835, 3.74, 4.2780000000000005],
    'enumerar': [4.673, 3.7319999999999998, 5.871],
    'enunciado': [4.2139999999999995, 4.523, 6.06],
    'envejecer': [4.382, 5.207999999999999, 5.852],
    'envergadura': [3.5589999999999997, 2.6710000000000003, 3.698],
    'enviar': [3.801, 4.109, 5.885],
    'envidia': [4.274, 3.575, 5.56],
    'envidiar': [4.131, 3.748, 5.131],
    'envoltorio': [5.39, 5.059, 5.412999999999999],
    'envolver': [3.958, 5.274, 5.6160000000000005],
    'enzima': [5.622000000000001, 2.5380000000000003, 4.268],
    'epidemia': [4.935, 3.978, 5.462999999999999],
    'episodio': [3.522, 3.725, 4.9110000000000005],
    'epistemología': [4.749, 1.246, 3.179],
    'epopeya': [3.823, 2.455, 2.764],
    'epígrafe': [4.02, 3.5239999999999996, 2.92],
    'equilibrio': [4.1530000000000005, 4.018, 5.052],
    'equipaje': [5.086, 5.995, 5.763],
    'equipo': [4.024, 5.641, 5.65],
    'equis': [5.0969999999999995, 5.546, 5.153],
    'equivalencia': [3.2910000000000004, 2.793, 3.909],
    'equivalente': [3.5610000000000004, 3.5469999999999997, 4.806],
    'equivocación': [4.604, 4.207, 5.561],
    'equivocarse': [4.689, 3.59, 6.21],
    'equívoco': [4.018, 2.438, 2.523],
    'erección': [5.379, 6.724, 5.066],
    'ermita': [4.805, 5.716, 4.09],
    'erotismo': [4.1160000000000005, 4.28, 6.252000000000001],
    'error': [3.782, 3.773, 6.684],
    'erudito': [4.192, 3.4989999999999997, 2.648],
    'erupciones': [4.2669999999999995, 5.307, 4.371],
    'esbozo': [3.827, 3.5, 4.195],
    'escala': [4.018, 3.7889999999999997, 4.9639999999999995],
    'escalera': [5.756, 6.5, 6.507000000000001],
    'escalinata': [5.797000000000001, 5.441, 3.3080000000000003],
    'escalofrío': [5.005, 4.812, 5.047],
    'escalón': [5.44, 5.8, 6.244],
    'escamas': [5.482, 5.795, 3.82],
    'escapada': [3.7089999999999996, 4.435, 3.721],
    'escapar': [4.112, 5.501, 6.438],
    'escaparate': [5.388, 6.08, 5.902],
    'escaparse': [4.0680000000000005, 4.68, 5.527],
    'escasez': [3.265, 3.784, 4.863],
    'escayola': [6.0120000000000005, 5.372999999999999, 4.9239999999999995],
    'escaño': [5.13, 2.33, 4.029],
    'escena': [3.971, 4.544, 5.417000000000001],
    'escenario': [5.726, 5.959, 6.051],
    'escenografía': [4.361000000000001, 4.198, 4.476],
    'escepticismo': [
        3.7769999999999997, 2.6839999999999997, 4.4030000000000005
    ],
    'esclava': [5.317, 5.707000000000001, 5.388],
    'esclavitud': [4.768, 5.751, 4.351],
    'esclavo': [5.409, 5.843999999999999, 5.4639999999999995],
    'escoba': [6.327999999999999, 5.849, 6.091],
    'escocesa': [5.4639999999999995, 4.406000000000001, 3.855],
    'escoger': [4.365, 4.032, 6.107],
    'escolta': [5.147, 5.284, 4.125],
    'escolástica': [4.2410000000000005, 2.266, 1.919],
    'esconder': [4.321000000000001, 4.666, 6.044],
    'esconderse': [4.876, 3.8, 5.9910000000000005],
    'escondite': [5.481, 4.46, 5.46],
    'escopeta': [5.617999999999999, 6.329, 3.67],
    'escote': [5.7989999999999995, 4.985, 6.0920000000000005],
    'escribir': [5.38, 6.01, 6.777],
    'escrito': [4.744, 4.895, 6.542000000000001],
    'escritor': [5.846, 6.0360000000000005, 6.09],
    'escritora': [5.676, 5.856, 5.688],
    'escritorio': [6.235, 6.462000000000001, 5.986000000000001],
    'escritura': [5.035, 5.557, 5.933],
    'escrúpulos': [3.384, 2.01, 4.813],
    'escuadra': [5.319, 4.1930000000000005, 3.0989999999999998],
    'escuadrón': [4.752, 4.644, 3.9139999999999997],
    'escucha': [4.035, 4.647, 5.625],
    'escucharse': [4.966, 3.773, 5.869],
    'escudo': [5.593999999999999, 5.117, 4.97],
    'escuela': [5.832000000000001, 6.005, 5.648],
    'escultor': [6.013999999999999, 5.5089999999999995, 5.207999999999999],
    'escultura': [5.627999999999999, 6.385, 5.631],
    'escupir': [5.825, 5.6610000000000005, 5.8839999999999995],
    'escándalo': [4.7330000000000005, 4.686, 6.457999999999999],
    'escéptico': [3.763, 2.65, 4.77],
    'esencia': [3.338, 3.133, 5.494],
    'esfera': [4.717, 5.961, 5.215],
    'esforzarse': [4.362, 3.6860000000000004, 6.31],
    'esfuerzo': [3.7489999999999997, 4.553, 5.816],
    'esgrima': [6.046, 5.444, 3.9210000000000003],
    'eslabón': [4.038, 5.428, 3.707],
    'esmeralda': [6.546, 5.525, 3.411],
    'esmero': [4.025, 2.63, 4.441],
    'esmoquin': [6.027, 5.922999999999999, 4.228],
    'espacio': [3.333, 4.988, 5.882000000000001],
    'espada': [6.461, 5.876, 5.295],
    'espalda': [6.564, 6.48, 6.331],
    'espanto': [3.082, 4.074, 4.706],
    'español': [5.417999999999999, 3.918, 6.532],
    'española': [4.7330000000000005, 4.38, 5.462999999999999],
    'especialidad': [3.486, 4.388999999999999, 5.975],
    'especialización': [4.237, 2.753, 5.537999999999999],
    'especias': [3.71, 5.5920000000000005, 5.718999999999999],
    'especie': [3.4010000000000002, 3.423, 4.609],
    'especificar': [4.61, 2.1719999999999997, 4.966],
    'espectador': [5.414, 5.327999999999999, 5.749],
    'espectáculo': [4.351, 4.893, 5.478],
    'especulación': [2.494, 2.311, 3.708],
    'espejismo': [3.85, 5.09, 5.144],
    'espejo': [6.345, 5.595, 5.513],
    'espera': [3.4160000000000004, 3.577, 6.122999999999999],
    'esperanza': [3.806, 3.9739999999999998, 6.063],
    'esperar': [4.03, 4.904, 6.357],
    'esperpento': [3.477, 3.292, 2.044],
    'espesor': [4.231, 3.86, 4.571000000000001],
    'espiar': [5.364, 4.198, 4.967],
    'espina': [5.31, 5.645, 5.763],
    'espinazo': [4.51, 3.7260000000000004, 3.4760000000000004],
    'espionaje': [4.985, 4.188, 5.327999999999999],
    'espiral': [5.611000000000001, 6.019, 5.083],
    'espiritualidad': [3.159, 3.58, 3.534],
    'esplendor': [3.9139999999999997, 4.7330000000000005, 4.651],
    'esponja': [5.94, 6.212000000000001, 6.367999999999999],
    'espontaneidad': [3.5639999999999996, 3.378, 4.869],
    'espontánea': [4.26, 3.5669999999999997, 4.898],
    'esposa': [5.351, 5.539, 4.966],
    'esposo': [5.226, 5.744, 4.746],
    'espuelas': [6.393, 4.44, 1.7690000000000001],
    'espuma': [5.037, 6.35, 5.178999999999999],
    'espía': [5.422000000000001, 5.005, 3.9389999999999996],
    'espíritu': [4.0760000000000005, 3.2239999999999998, 5.018],
    'esqueleto': [5.843999999999999, 6.354, 6.167999999999999],
    'esquema': [3.676, 4.7330000000000005, 6.379],
    'esquina': [5.452999999999999, 6.254, 6.142],
    'esquivar': [4.224, 4.921, 5.205],
    'estabilidad': [3.4360000000000004, 2.228, 5.206],
    'establecer': [3.9330000000000003, 2.511, 5.805],
    'establecimiento': [4.41, 4.933, 4.846],
    'estaca': [6.029, 5.932, 5.086],
    'estación': [3.845, 5.379, 6.327999999999999],
    'estadio': [4.312, 4.9719999999999995, 4.531000000000001],
    'estado': [3.568, 2.9, 5.861000000000001],
    'estadounidense': [5.9110000000000005, 4.605, 5.653],
    'estadística': [4.369, 3.3, 5.718999999999999],
    'estafa': [4.226, 3.112, 4.7],
    'estallar': [4.753, 5.478, 6.002999999999999],
    'estallido': [4.18, 4.788, 4.102],
    'estamento': [3.242, 3.432, 2.758],
    'estampa': [4.646, 4.288, 4.9030000000000005],
    'estancia': [3.951, 4.305, 4.902],
    'estanque': [5.667000000000001, 6.31, 5.379],
    'estantería': [6.037000000000001, 6.4239999999999995, 6.082000000000001],
    'estantes': [6.08, 5.3870000000000005, 4.3580000000000005],
    'estatua': [6.044, 6.045, 4.583],
    'estatura': [5.319, 4.968999999999999, 5.7860000000000005],
    'estatus': [3.8360000000000003, 3.065, 4.672],
    'estatuto': [4.81, 2.7489999999999997, 6.358],
    'estela': [4.508, 4.27, 3.555],
    'esterilidad': [4.893, 3.448, 4.282],
    'estigma': [4.334, 3.16, 3.096],
    'estilo': [3.1180000000000003, 3.272, 4.995],
    'estima': [3.6430000000000002, 3.7119999999999997, 4.914],
    'estimación': [2.553, 2.001, 4.004],
    'estimulante': [4.216, 4.308, 5.561],
    'estimular': [4.188, 3.347, 5.227],
    'estirar': [4.427, 4.946000000000001, 4.9910000000000005],
    'estiércol': [6.407, 5.343, 4.387],
    'estrategia': [3.489, 3.283, 4.827],
    'estratos': [3.675, 3.6460000000000004, 4.2],
    'estrechez': [3.886, 4.601, 5.29],
    'estrecho': [5.43, 5.518, 6.382999999999999],
    'estrella': [5.062, 5.912999999999999, 5.707999999999999],
    'estrellarse': [4.637, 5.752000000000001, 6.361000000000001],
    'estremecer': [3.3310000000000004, 3.5060000000000002, 4.387],
    'estremecimiento': [3.7310000000000003, 4.138999999999999, 3.945],
    'estrenar': [3.873, 3.679, 5.875],
    'estreno': [4.695, 5.046, 5.444],
    'estribillo': [4.976, 4.686, 5.599],
    'estructura': [3.969, 4.187, 4.433],
    'estructuralista': [3.3280000000000003, 2.12, 3.425],
    'estruendo': [4.044, 4.622, 4.393],
    'estrépito': [3.8480000000000003, 4.013, 3.95],
    'estrés': [4.402, 4.123, 5.4239999999999995],
    'estuche': [5.728, 5.774, 5.522],
    'estudiante': [5.974, 6.33, 6.809],
    'estudiar': [4.91, 5.819, 6.8229999999999995],
    'estudio': [4.0760000000000005, 5.47, 6.235],
    'estufa': [6.162000000000001, 5.992000000000001, 6.332000000000001],
    'estupefacción': [3.491, 3.2689999999999997, 3.217],
    'estupidez': [4.063, 3.239, 6.031000000000001],
    'estética': [4.15, 5.084, 5.211],
    'estímulo': [3.6689999999999996, 3.821, 6.372000000000001],
    'etapa': [3.679, 3.05, 6.143],
    'eternidad': [3.2539999999999996, 2.97, 5.061],
    'etiqueta': [4.718999999999999, 5.138999999999999, 6.242000000000001],
    'eucaliptos': [5.893, 5.848, 4.867],
    'eufemismo': [3.198, 2.051, 3.0780000000000003],
    'euforia': [4.217, 5.157, 5.348],
    'europeas': [4.435, 3.77, 5.705],
    'europeo': [4.28, 4.041, 6.571000000000001],
    'evangelio': [5.381, 4.059, 4.913],
    'evaporación': [4.801, 4.416, 4.756],
    'evasión': [3.7439999999999998, 3.805, 3.9589999999999996],
    'evento': [3.61, 3.589, 4.345],
    'eventualidad': [3.767, 1.4580000000000002, 4.211],
    'evidencia': [3.091, 2.6630000000000003, 4.54],
    'evitar': [3.759, 3.284, 4.6160000000000005],
    'evocación': [2.617, 2.229, 3.56],
    'evolucionista': [3.784, 2.125, 4.7860000000000005],
    'evolución': [3.6919999999999997, 3.155, 5.666],
    'exactitud': [4.189, 2.62, 4.881],
    'exageración': [3.832, 3.571, 5.6739999999999995],
    'exagerar': [4.293, 3.8710000000000004, 5.5729999999999995],
    'exaltación': [3.94, 3.4989999999999997, 4.372],
    'examen': [5.92, 6.4, 6.837999999999999],
    'examinar': [4.291, 4.532, 6.524],
    'excavaciones': [4.913, 5.882999999999999, 4.592],
    'excelencia': [3.608, 3.108, 3.9560000000000004],
    'excepción': [3.9560000000000004, 2.339, 5.462000000000001],
    'exceso': [3.037, 2.9760000000000004, 4.415],
    'excitación': [4.1080000000000005, 5.484, 5.662999999999999],
    'exclamación': [3.745, 3.543, 5.039],
    'excluir': [3.875, 3.888, 5.105],
    'exclusiva': [4.015, 2.937, 5.111000000000001],
    'exclusión': [3.5380000000000003, 2.532, 4.205],
    'excursión': [5.092, 6.172999999999999, 6.053999999999999],
    'excusa': [3.677, 4.0680000000000005, 5.5489999999999995],
    'exhibición': [4.28, 4.113, 5.42],
    'exhibir': [3.968, 3.536, 4.0760000000000005],
    'exigencia': [3.5380000000000003, 3.815, 5.784],
    'exigir': [3.8169999999999997, 3.378, 5.585],
    'exilio': [5.148, 3.489, 3.71],
    'existencia': [3.075, 2.512, 5.452999999999999],
    'existencialismo': [
        3.1639999999999997, 2.2680000000000002, 3.4410000000000003
    ],
    'existir': [3.27, 3.161, 6.051],
    'expansión': [3.853, 3.17, 5.64],
    'expectación': [3.623, 4.405, 4.58],
    'expediente': [5.284, 4.626, 4.827],
    'experiencia': [3.889, 3.7230000000000003, 6.4879999999999995],
    'experimentación': [4.396, 4.14, 5.62],
    'experimentar': [3.9139999999999997, 4.019, 5.749],
    'experimento': [4.205, 4.072, 5.94],
    'experta': [4.592, 2.715, 5.167999999999999],
    'experto': [4.283, 3.6060000000000003, 5.233],
    'explanada': [4.713, 4.654, 5.015],
    'explicación': [3.988, 4.832, 6.115],
    'explicar': [4.482, 4.372, 6.705],
    'explicarse': [3.5069999999999997, 3.8289999999999997, 6.542000000000001],
    'exploración': [4.434, 4.066, 4.543],
    'explorar': [3.661, 5.0280000000000005, 4.6],
    'explosión': [4.78, 6.109, 5.9670000000000005],
    'explotación': [3.4819999999999998, 4.739, 5.7170000000000005],
    'explotar': [3.821, 5.295, 6.013999999999999],
    'exponer': [4.274, 3.571, 5.631],
    'exportación': [3.918, 2.8560000000000003, 3.845],
    'exposición': [4.599, 5.978, 5.558],
    'expresar': [3.312, 3.1060000000000003, 5.431],
    'expresarse': [4.114, 3.9560000000000004, 5.904],
    'expresión': [2.718, 3.31, 5.9879999999999995],
    'expreso': [3.908, 3.8139999999999996, 3.2310000000000003],
    'expulsar': [3.588, 4.24, 5.067],
    'expulsión': [4.433, 4.2139999999999995, 5.7],
    'extender': [4.437, 3.971, 5.456],
    'extenderse': [3.9810000000000003, 3.6639999999999997, 5.9510000000000005],
    'extensión': [3.725, 3.622, 4.843999999999999],
    'exterior': [4.74, 4.553, 6.278],
    'exterioridad': [3.3480000000000003, 3.535, 4.044],
    'exterminio': [4.546, 4.598, 2.906],
    'extinción': [3.4410000000000003, 3.332, 4.585],
    'extinguirse': [4.084, 4.041, 4.176],
    'extra': [3.318, 3.727, 4.968999999999999],
    'extracción': [4.523, 3.9010000000000002, 4.793],
    'extraer': [3.64, 4.751, 4.823],
    'extranjera': [4.753, 5.5889999999999995, 5.87],
    'extranjero': [4.988, 5.124, 5.98],
    'extravío': [3.762, 3.555, 4.9319999999999995],
    'extrañar': [4.117, 3.613, 5.428],
    'extrañeza': [3.303, 2.4330000000000003, 4.74],
    'extraño': [4.046, 4.025, 6.062],
    'extremidades': [4.93, 5.205, 4.86],
    'extremo': [4.236000000000001, 4.5, 5.654],
    'fabrica': [4.961, 5.954, 5.656000000000001],
    'fabricación': [4.283, 3.305, 4.0569999999999995],
    'fabricantes': [5.059, 4.8180000000000005, 5.604],
    'fabricar': [5.11, 5.234, 6.169],
    'facetas': [3.071, 2.602, 4.36],
    'fachada': [5.566, 5.025, 5.602],
    'facilidad': [2.33, 2.762, 6.154],
    'facilitar': [3.352, 2.867, 5.564],
    'factor': [2.885, 2.0180000000000002, 3.6860000000000004],
    'factoría': [4.643, 4.1419999999999995, 3.298],
    'factura': [5.766, 5.736000000000001, 5.593],
    'facultad': [4.428999999999999, 4.843, 6.422000000000001],
    'faena': [3.688, 3.717, 5.511],
    'fajo': [3.54, 4.775, 4.205],
    'falacia': [3.758, 2.291, 3.915],
    'falda': [5.444, 6.591, 6.3420000000000005],
    'falla': [3.688, 4.812, 4.065],
    'fallar': [4.005, 3.387, 5.779],
    'fallo': [3.843, 3.5639999999999996, 4.853],
    'falsedad': [4.107, 3.662, 4.29],
    'falta': [3.3139999999999996, 3.7439999999999998, 5.691],
    'faltar': [3.388, 3.156, 5.706],
    'fama': [4.106, 4.166, 5.5760000000000005],
    'familia': [5.337000000000001, 6.121, 6.3870000000000005],
    'familiar': [4.353, 5.167000000000001, 6.239],
    'familiaridad': [3.2939999999999996, 3.9389999999999996, 5.936],
    'famosas': [3.907, 4.622, 5.732],
    'famosos': [4.418, 4.935, 6.205],
    'fans': [5.742999999999999, 5.757999999999999, 4.785],
    'fantasma': [4.8580000000000005, 5.336, 4.686],
    'fantasía': [2.965, 3.842, 6.311],
    'fanático': [3.446, 4.394, 5.445],
    'farmacia': [6.39, 5.836, 6.199],
    'farol': [4.864, 5.54, 4.734],
    'farolas': [6.3629999999999995, 5.846, 6.138],
    'farsa': [4.133, 3.44, 4.0360000000000005],
    'fascinación': [3.764, 4.099, 4.793],
    'fascista': [5.159, 4.5889999999999995, 4.215],
    'fatalidad': [3.4730000000000003, 3.1460000000000004, 3.125],
    'fatiga': [4.935, 4.165, 6.2989999999999995],
    'fauces': [4.459, 4.676, 2.655],
    'fauna': [4.641, 5.574, 5.406000000000001],
    'favor': [4.315, 3.813, 6.523],
    'favorita': [4.096, 2.971, 6.0360000000000005],
    'favorito': [4.957, 4.102, 6.135],
    'faz': [3.795, 4.298, 4.015],
    'fe': [2.658, 3.259, 5.855],
    'fealdad': [3.864, 4.041, 4.768],
    'febrero': [6.171, 3.742, 5.527],
    'fecha': [5.166, 4.52, 6.435],
    'fecundidad': [5.727, 5.119, 4.956],
    'felicidad': [3.681, 4.022, 6.077999999999999],
    'felinos': [5.237, 6.261, 4.21],
    'felpa': [5.079, 4.553999999999999, 3.075],
    'feminismo': [4.075, 3.6660000000000004, 6.096],
    'feminista': [4.687, 3.6289999999999996, 5.709],
    'fenómeno': [3.3510000000000004, 3.0039999999999996, 4.239],
    'feria': [4.9319999999999995, 5.76, 5.6610000000000005],
    'ferocidad': [4.165, 4.436, 4.468],
    'ferrocarril': [6.099, 6.31, 6.0360000000000005],
    'festejar': [4.7219999999999995, 5.77, 5.881],
    'festival': [4.591, 5.651, 5.74],
    'feudalismo': [5.325, 3.53, 4.916],
    'fibra': [4.515, 3.807, 4.609],
    'fibrina': [5.075, 1.655, 1.515],
    'ficción': [4.377, 3.449, 5.07],
    'ficha': [5.312, 5.872999999999999, 6.079],
    'fidelidad': [4.479, 3.022, 5.289],
    'fideos': [6.059, 6.8, 5.693],
    'fiebre': [5.7, 4.784, 5.271],
    'fieles': [3.069, 3.46, 3.1889999999999996],
    'fieltro': [6.124, 4.362, 4.206],
    'fiera': [4.316, 5.5920000000000005, 5.175],
    'fiesta': [4.698, 6.273, 6.75],
    'figura': [3.175, 5.303999999999999, 5.388],
    'figuración': [2.7260000000000004, 2.911, 3.182],
    'fijación': [3.465, 3.2739999999999996, 4.617],
    'fijar': [3.287, 3.025, 5.981],
    'fijarse': [3.457, 4.25, 6.27],
    'fila': [4.935, 5.224, 6.36],
    'filamentos': [4.364, 3.427, 3.5789999999999997],
    'filipinas': [5.888, 4.1080000000000005, 3.952],
    'filmación': [4.806, 4.5280000000000005, 4.811],
    'filmar': [4.811, 5.303999999999999, 4.62],
    'filme': [5.095, 5.733, 4.4110000000000005],
    'filo': [3.825, 3.715, 4.508],
    'filosofar': [3.43, 3.931, 5.584],
    'filosofía': [3.199, 2.9539999999999997, 5.672999999999999],
    'filtro': [4.547, 4.154, 4.928999999999999],
    'filón': [4.0969999999999995, 3.688, 3.765],
    'filósofo': [4.891, 4.605, 4.986000000000001],
    'fin': [4.543, 4.202, 6.301],
    'final': [3.904, 3.553, 6.712999999999999],
    'finalidad': [3.7439999999999998, 2.948, 5.272],
    'finalizar': [4.854, 4.013999999999999, 5.422999999999999],
    'financiación': [3.991, 2.625, 4.246],
    'financiero': [5.061, 4.561, 4.575],
    'finanzas': [4.024, 2.924, 3.925],
    'fingir': [4.092, 3.0810000000000004, 5.499],
    'finura': [3.557, 4.183, 4.137],
    'firma': [5.422999999999999, 5.915, 5.656000000000001],
    'firmamento': [5.045, 4.955, 5.252000000000001],
    'firmar': [5.064, 5.481, 6.362],
    'firmeza': [4.333, 3.966, 4.518],
    'fiscal': [5.442, 4.717, 3.488],
    'fisiología': [4.5969999999999995, 3.29, 5.196000000000001],
    'fisuras': [4.12, 4.271, 3.7910000000000004],
    'flamenco': [5.0489999999999995, 5.1370000000000005, 5.406000000000001],
    'flancos': [5.025, 2.909, 3.0239999999999996],
    'flauta': [6.1610000000000005, 5.971, 5.457999999999999],
    'flecha': [5.752000000000001, 6.119, 5.645],
    'flecos': [5.916, 3.805, 3.5780000000000003],
    'flema': [5.6339999999999995, 4.495, 3.968],
    'flequillo': [5.651, 5.879, 6.289],
    'flor': [5.6579999999999995, 6.306, 6.754],
    'flora': [4.316, 4.88, 4.334],
    'florecer': [4.242, 5.169, 5.51],
    'flotar': [4.369, 5.457000000000001, 4.8469999999999995],
    'fluctuaciones': [3.167, 2.469, 2.4930000000000003],
    'fluir': [3.75, 4.327, 3.978],
    'flujo': [4.982, 5.194, 5.365],
    'fobia': [4.155, 3.4139999999999997, 5.8260000000000005],
    'foca': [6.144, 5.899, 5.847],
    'foco': [4.993, 5.757999999999999, 5.931],
    'fogón': [5.928, 4.066, 2.867],
    'folclórica': [4.422, 5.043, 4.231],
    'folio': [6.574, 7.0, 6.61],
    'folleto': [4.766, 5.808, 5.86],
    'fomentar': [3.2, 2.78, 4.0],
    'fondo': [4.05, 4.873, 5.2379999999999995],
    'fonógrafo': [5.124, 3.803, 2.7510000000000003],
    'forastero': [5.646, 5.415, 5.01],
    'forjar': [3.7060000000000004, 3.15, 3.472],
    'forma': [3.11, 3.517, 4.877],
    'formación': [2.658, 2.9219999999999997, 5.529],
    'formar': [3.299, 2.753, 5.755],
    'formarse': [2.5610000000000004, 3.1310000000000002, 5.103],
    'formula': [4.33, 4.618, 5.223],
    'formulación': [3.156, 3.33, 3.555],
    'forro': [4.976, 5.992999999999999, 5.34],
    'fortaleza': [4.627, 5.131, 4.6610000000000005],
    'fortuna': [3.898, 4.783, 4.091],
    'forzar': [3.342, 3.6039999999999996, 5.6739999999999995],
    'fosa': [5.084, 5.662000000000001, 2.946],
    'foto': [6.152, 6.436, 6.627000000000001],
    'fotocopias': [6.281000000000001, 5.845, 6.773],
    'fotografía': [5.876, 6.282, 6.542000000000001],
    'fotógrafo': [6.358, 6.178999999999999, 6.263],
    'fracaso': [4.227, 3.455, 4.853],
    'fracción': [4.438, 4.012, 4.453],
    'fragancia': [4.42, 4.777, 4.373],
    'fragilidad': [3.725, 5.086, 4.664],
    'fragmento': [4.374, 4.013999999999999, 4.4719999999999995],
    'fragor': [2.526, 2.747, 1.865],
    'fragua': [5.053, 3.722, 2.96],
    'fraile': [5.577999999999999, 5.846, 3.736],
    'francesa': [5.61, 5.1739999999999995, 6.028],
    'franciscano': [6.119, 4.663, 3.537],
    'francos': [4.935, 4.343, 4.362],
    'francés': [5.849, 5.803999999999999, 6.367000000000001],
    'franja': [4.363, 4.313, 2.6039999999999996],
    'franquismo': [5.1339999999999995, 4.0089999999999995, 4.212],
    'franquista': [5.285, 3.8819999999999997, 3.917],
    'frasco': [5.224, 5.965, 5.357],
    'frase': [4.409, 5.345, 6.329],
    'fraternidad': [3.733, 3.028, 3.9360000000000004],
    'frecuencia': [3.906, 2.657, 6.19],
    'fregar': [5.235, 5.593, 6.0489999999999995],
    'frenesí': [3.213, 3.6189999999999998, 3.472],
    'freno': [5.1610000000000005, 5.175, 6.319],
    'frente': [4.543, 5.513999999999999, 6.287000000000001],
    'fresa': [5.877999999999999, 6.67, 6.692],
    'fresco': [3.395, 4.647, 5.931],
    'frescor': [4.585, 4.656000000000001, 5.712000000000001],
    'frescura': [3.032, 4.685, 4.673],
    'frialdad': [3.867, 3.0860000000000003, 4.415],
    'frontal': [3.9939999999999998, 3.4219999999999997, 4.683],
    'frontera': [4.526, 4.831, 5.7829999999999995],
    'frontón': [5.239, 5.791, 3.966],
    'frustración': [3.403, 3.52, 6.075],
    'fruta': [4.9110000000000005, 5.332999999999999, 6.33],
    'fruto': [3.846, 5.781000000000001, 6.085],
    'fuego': [5.819, 6.591, 6.755],
    'fuente': [5.053999999999999, 6.524, 6.3420000000000005],
    'fuerte': [3.872, 4.72, 6.596],
    'fuerza': [3.793, 4.508, 5.746],
    'fuga': [4.075, 4.236000000000001, 6.146],
    'fugitivo': [5.957000000000001, 4.959, 5.899],
    'fulano': [3.895, 4.327, 4.79],
    'fulgor': [2.915, 2.2640000000000002, 2.17],
    'fumador': [6.111000000000001, 6.197, 6.667000000000001],
    'fumar': [5.763, 5.667999999999999, 6.027],
    'funcionamiento': [3.563, 2.792, 5.073],
    'funcionar': [3.6069999999999998, 3.491, 5.766],
    'funcionario': [4.574, 4.805, 5.438],
    'función': [2.83, 2.84, 4.92],
    'funda': [4.734, 5.266, 5.308],
    'fundación': [3.508, 3.0180000000000002, 4.167],
    'fundador': [4.25, 3.9989999999999997, 5.14],
    'fundamentación': [3.467, 1.886, 4.23],
    'fundamentar': [3.471, 2.168, 4.725],
    'fundamento': [2.784, 2.457, 5.527],
    'fundar': [3.6689999999999996, 2.977, 4.251],
    'fundirse': [3.483, 4.5969999999999995, 5.0089999999999995],
    'funeral': [6.011, 5.902, 5.678],
    'furia': [3.571, 4.2860000000000005, 4.341],
    'furor': [4.048, 3.807, 4.297],
    'fuselaje': [4.625, 2.88, 1.6440000000000001],
    'fusil': [5.909, 5.836, 3.514],
    'fusión': [3.708, 2.9160000000000004, 3.355],
    'futuro': [3.117, 2.963, 6.621],
    'fábrica': [5.582000000000001, 5.237, 6.393],
    'fábula': [4.949, 4.14, 4.0569999999999995],
    'fármaco': [4.803999999999999, 4.913, 5.765],
    'física': [3.983, 3.305, 4.976],
    'físico': [3.9730000000000003, 4.695, 5.7],
    'fórmula': [4.252, 4.64, 4.975],
    'fósforo': [5.5120000000000005, 4.3580000000000005, 4.002],
    'fósiles': [5.434, 5.104, 3.614],
    'fútbol': [5.683, 6.289, 6.403],
    'gabardina': [6.0729999999999995, 6.055, 5.702000000000001],
    'gabinete': [4.624, 4.123, 4.545],
    'gafas': [6.284, 5.801, 6.721],
    'gala': [4.066, 3.568, 4.237],
    'galardón': [4.54, 4.812, 3.3289999999999997],
    'galaxia': [5.249, 5.294, 4.145],
    'galeras': [6.171, 4.763999999999999, 3.463],
    'galeón': [6.391, 5.1080000000000005, 2.391],
    'gallega': [5.449, 4.394, 4.386],
    'galletas': [6.145, 6.377999999999999, 6.6770000000000005],
    'gallina': [6.111000000000001, 6.718, 6.205],
    'gallinero': [5.5360000000000005, 6.244, 4.987],
    'gallo': [5.942, 6.614, 6.242999999999999],
    'galope': [4.93, 5.4670000000000005, 4.582],
    'galán': [5.438, 5.103, 5.295],
    'gama': [2.739, 2.845, 3.9130000000000003],
    'ganado': [4.138, 5.841, 3.843],
    'ganancia': [4.166, 4.383, 5.547000000000001],
    'ganar': [3.9730000000000003, 5.2989999999999995, 6.65],
    'ganas': [3.852, 3.037, 6.2860000000000005],
    'gancho': [4.658, 4.878, 5.285],
    'garaje': [6.36, 5.507000000000001, 6.222],
    'garantizar': [3.654, 2.504, 4.113],
    'garantía': [3.967, 4.183, 5.95],
    'garbanzos': [6.382000000000001, 6.278, 6.068],
    'garbo': [3.9339999999999997, 3.08, 3.457],
    'garfios': [5.545, 6.011, 2.8569999999999998],
    'garganta': [5.587000000000001, 5.09, 6.46],
    'garras': [5.222, 5.702000000000001, 4.76],
    'gas': [5.2589999999999995, 4.747, 6.452999999999999],
    'gaseosa': [5.112, 5.718, 6.318],
    'gasolina': [6.221, 4.754, 6.4670000000000005],
    'gastar': [4.032, 4.692, 6.664],
    'gasto': [4.029, 3.635, 5.473],
    'gata': [6.285, 5.66, 6.499],
    'gatillo': [5.622000000000001, 6.276, 4.123],
    'gaviota': [6.279, 6.541, 6.557],
    'gemelas': [5.678, 5.867000000000001, 5.662999999999999],
    'gemelos': [5.191, 6.257000000000001, 4.593],
    'gemido': [5.1610000000000005, 5.03, 4.377],
    'gen': [6.5360000000000005, 2.104, 5.331],
    'generación': [3.799, 3.7510000000000003, 4.914],
    'general': [2.909, 3.41, 5.18],
    'generalidad': [2.793, 2.342, 4.444],
    'generalización': [3.123, 2.239, 5.3260000000000005],
    'generar': [3.112, 2.7539999999999996, 5.556],
    'generosidad': [4.423, 2.9019999999999997, 6.287000000000001],
    'genio': [4.746, 3.755, 5.667000000000001],
    'genitales': [5.7, 5.849, 4.447],
    'gente': [4.64, 6.6579999999999995, 6.537000000000001],
    'gentío': [4.13, 5.507999999999999, 5.181],
    'geografía': [4.203, 3.91, 4.235],
    'geográfica': [4.787, 3.057, 5.09],
    'geometría': [4.508, 3.302, 3.8939999999999997],
    'geranios': [6.306, 5.902, 5.346],
    'gerente': [5.997000000000001, 4.164, 3.838],
    'germen': [4.555, 4.1819999999999995, 3.8939999999999997],
    'gesta': [3.556, 3.773, 2.608],
    'gestión': [2.718, 2.807, 4.734],
    'gesto': [4.6739999999999995, 4.787, 5.531000000000001],
    'gestores': [4.515, 3.115, 3.5669999999999997],
    'gigante': [5.207000000000001, 4.736000000000001, 5.575],
    'gilipollas': [5.232, 3.8680000000000003, 6.112],
    'gimnasia': [4.938, 5.56, 5.976],
    'gimnasio': [6.135, 6.492000000000001, 6.287999999999999],
    'ginebra': [5.874, 5.747000000000001, 4.541],
    'girar': [3.989, 4.619, 5.436],
    'giro': [3.7910000000000004, 4.001, 5.082],
    'gitana': [5.892, 6.268, 6.132999999999999],
    'gitano': [6.02, 6.2379999999999995, 4.996],
    'globo': [5.94, 6.242999999999999, 5.563],
    'gloria': [2.833, 3.8089999999999997, 5.882999999999999],
    'glorieta': [5.76, 4.402, 3.9789999999999996],
    'gobernador': [5.611000000000001, 4.315, 4.754],
    'gobernanta': [5.599, 5.196000000000001, 4.872],
    'gobernante': [4.796, 4.466, 5.306],
    'gobernar': [4.48, 4.539, 5.797000000000001],
    'gobierno': [4.122, 4.207, 6.2829999999999995],
    'goce': [4.165, 4.7669999999999995, 4.819],
    'golf': [5.796, 5.1370000000000005, 5.273],
    'golfo': [3.843, 5.166, 5.501],
    'golondrina': [6.18, 6.1979999999999995, 4.431],
    'golpe': [4.927, 5.34, 6.02],
    'golpear': [4.7010000000000005, 5.885, 6.148],
    'goma': [4.44, 6.164, 5.756],
    'gorra': [5.63, 6.091, 6.53],
    'gorriones': [6.318, 5.422999999999999, 4.158],
    'gorro': [6.044, 6.41, 5.794],
    'gota': [5.244, 6.1770000000000005, 6.055],
    'gozar': [4.08, 4.43, 5.6],
    'gozo': [3.343, 4.487, 4.8580000000000005],
    'grabado': [4.061, 5.164, 5.112],
    'grado': [3.214, 2.907, 5.6129999999999995],
    'graduación': [4.158, 4.107, 5.615],
    'gramos': [5.7589999999999995, 3.637, 6.702000000000001],
    'gramática': [4.625, 2.807, 5.289],
    'granero': [6.077999999999999, 5.757999999999999, 3.7569999999999997],
    'granito': [5.803999999999999, 6.417999999999999, 4.224],
    'granja': [5.829, 4.993, 4.644],
    'grano': [4.95, 6.255, 6.164],
    'grasa': [4.849, 4.74, 6.068],
    'gratitud': [4.298, 4.0169999999999995, 5.825],
    'gravedad': [4.12, 4.667, 5.353],
    'gravitación': [5.192, 1.85, 1.716],
    'gremio': [4.021, 3.781, 2.7430000000000003],
    'griega': [5.008, 3.764, 5.487],
    'griego': [5.172999999999999, 3.8789999999999996, 4.096],
    'grieta': [5.215, 5.062, 4.492],
    'grifo': [5.822, 5.807, 6.105],
    'grillos': [5.824, 6.108, 5.284],
    'gringos': [5.556, 3.969, 4.053999999999999],
    'gripe': [6.029, 4.967, 5.792999999999999],
    'gritar': [5.9510000000000005, 5.438, 6.181],
    'griterío': [4.445, 5.162000000000001, 4.831],
    'grito': [5.7989999999999995, 5.695, 5.813],
    'grosor': [4.435, 4.513999999999999, 3.758],
    'grueso': [4.84, 5.01, 4.922],
    'grullas': [5.19, 3.705, 2.843],
    'grupa': [5.082, 3.3689999999999998, 3.737],
    'grupo': [4.183, 5.587999999999999, 6.232],
    'gruta': [5.791, 4.91, 4.813],
    'gruñido': [4.675, 5.506, 4.9830000000000005],
    'gráfica': [4.8260000000000005, 4.734, 5.6339999999999995],
    'gráfico': [4.8660000000000005, 5.729, 5.247999999999999],
    'guante': [6.5729999999999995, 6.327999999999999, 4.272],
    'guardaespaldas': [5.776, 5.974, 5.603],
    'guardar': [4.062, 4.6930000000000005, 5.77],
    'guardia': [4.796, 5.405, 5.7410000000000005],
    'guardián': [5.218999999999999, 6.015, 3.7880000000000003],
    'guarida': [4.69, 4.891, 4.221],
    'guarnición': [4.629, 4.673, 4.229],
    'guerra': [5.903, 5.903, 6.153],
    'guerrero': [5.075, 5.943, 5.294],
    'guerrilleros': [4.942, 5.527, 4.468999999999999],
    'guionista': [5.2829999999999995, 4.195, 4.795],
    'guitarra': [5.921, 6.687, 5.657],
    'guiño': [5.645, 5.19, 4.755],
    'guión': [5.081, 5.282, 5.229],
    'gusano': [5.5760000000000005, 5.353, 6.007999999999999],
    'gustar': [3.81, 4.556, 6.207999999999999],
    'gusto': [3.988, 3.7110000000000003, 5.382999999999999],
    'guía': [4.075, 5.119, 5.187],
    'género': [3.242, 2.5869999999999997, 5.718999999999999],
    'génesis': [3.7880000000000003, 2.4019999999999997, 3.4589999999999996],
    'habano': [5.313, 4.92, 3.6010000000000004],
    'haber': [2.3080000000000003, 2.015, 6.517],
    'habilidad': [3.5439999999999996, 4.277, 5.922999999999999],
    'habitación': [5.172000000000001, 6.745, 6.901],
    'habitante': [5.395, 4.86, 5.675],
    'habitar': [4.303999999999999, 4.253, 4.952],
    'hablante': [4.065, 4.673, 4.6],
    'hablar': [5.2860000000000005, 5.781000000000001, 6.976],
    'hacer': [2.8089999999999997, 3.446, 6.795],
    'hacha': [6.347, 6.042999999999999, 3.9530000000000003],
    'hachís': [5.687, 4.981, 4.99],
    'hacienda': [3.9739999999999998, 4.003, 4.4830000000000005],
    'hada': [5.256, 4.967, 3.565],
    'hallar': [2.89, 3.1510000000000002, 4.58],
    'hallarse': [2.687, 2.984, 4.561],
    'hallazgo': [3.8369999999999997, 3.7030000000000003, 4.477],
    'halo': [3.822, 2.852, 2.997],
    'hamaca': [6.085, 6.566, 5.8020000000000005],
    'hambre': [3.8760000000000003, 5.4239999999999995, 5.912000000000001],
    'harina': [5.932, 5.362, 5.797999999999999],
    'harén': [4.783, 6.022, 4.425],
    'hastío': [4.051, 2.903, 2.44],
    'haz': [3.861, 4.192, 3.895],
    'hazaña': [4.298, 3.716, 5.209],
    'hebra': [4.819, 4.949, 3.9530000000000003],
    'hebreo': [5.106, 3.779, 4.325],
    'hecho': [2.171, 2.5, 5.655],
    'hectáreas': [5.665, 4.231, 4.08],
    'hedonismo': [3.66, 2.815, 3.3289999999999997],
    'hedor': [4.452, 4.446000000000001, 3.786],
    'hegemonía': [4.463, 2.093, 4.27],
    'helada': [5.287000000000001, 4.802, 5.697],
    'helado': [5.482, 6.321000000000001, 6.557],
    'helicópteros': [6.269, 6.1770000000000005, 5.184],
    'hembra': [4.709, 5.961, 4.225],
    'hemisferio': [4.406000000000001, 5.024, 4.175],
    'heredero': [6.124, 3.5810000000000004, 4.8660000000000005],
    'herejes': [4.7219999999999995, 3.4330000000000003, 3.6639999999999997],
    'herejía': [3.823, 3.4530000000000003, 3.565],
    'herencia': [5.122999999999999, 4.5569999999999995, 5.69],
    'herida': [5.337999999999999, 5.9110000000000005, 6.563],
    'heridos': [5.046, 5.787999999999999, 5.773],
    'herir': [4.312, 5.287999999999999, 5.672999999999999],
    'hermana': [5.524, 5.876, 6.051],
    'hermandad': [3.983, 3.698, 4.699],
    'hermano': [5.992999999999999, 6.486000000000001, 6.672999999999999],
    'heroína': [5.4510000000000005, 4.97, 5.412000000000001],
    'heroísmo': [3.537, 3.554, 4.0969999999999995],
    'herramienta': [4.209, 5.044, 5.782],
    'heterogeneidad': [3.7560000000000002, 2.533, 3.627],
    'hidalgo': [5.002, 3.5069999999999997, 3.5180000000000002],
    'hidrógeno': [5.041, 2.0340000000000003, 3.674],
    'hiedra': [6.031000000000001, 4.525, 4.74],
    'hielo': [6.164, 6.0089999999999995, 6.784],
    'hierba': [6.5360000000000005, 6.087000000000001, 6.318],
    'hierro': [5.849, 5.5729999999999995, 5.827999999999999],
    'higos': [6.141, 5.6160000000000005, 5.792999999999999],
    'higuera': [6.102, 6.11, 5.321000000000001],
    'hija': [5.997000000000001, 5.271, 6.527],
    'hijo': [5.683, 5.292999999999999, 6.097],
    'hilera': [4.533, 4.059, 3.905],
    'hilo': [5.825, 6.37, 6.6129999999999995],
    'hindú': [5.439, 4.386, 4.599],
    'hipócrita': [4.342, 3.4389999999999996, 4.706],
    'hipófisis': [6.251, 2.93, 4.585],
    'hipótesis': [4.162, 2.8169999999999997, 5.331],
    'hispano': [4.641, 4.315, 3.8930000000000002],
    'histeria': [4.416, 4.37, 5.2410000000000005],
    'historia': [3.8089999999999997, 4.351, 6.49],
    'historiador': [5.7170000000000005, 4.377, 4.992],
    'historietas': [4.887, 5.52, 5.507999999999999],
    'hito': [4.069, 3.1830000000000003, 3.096],
    'hocico': [5.723, 5.949, 4.676],
    'hogar': [4.894, 6.39, 6.601],
    'hoguera': [6.4910000000000005, 6.129, 4.959],
    'hoja': [5.261, 6.232, 6.175],
    'hojarasca': [5.34, 4.3, 2.912],
    'holandés': [5.577999999999999, 4.662, 5.229],
    'holocausto': [4.335, 4.588, 3.964],
    'hombre': [5.398, 6.611000000000001, 6.692],
    'hombreras': [6.444, 5.337999999999999, 6.08],
    'hombro': [6.41, 6.232, 6.35],
    'homenaje': [4.6, 4.409, 5.415],
    'homo': [4.041, 4.372, 3.865],
    'homosexual': [5.505, 4.527, 6.0360000000000005],
    'homosexualidad': [5.6, 5.104, 5.729],
    'hondas': [4.337, 5.131, 3.6689999999999996],
    'hongos': [5.263, 4.723, 4.481],
    'honor': [3.784, 3.0189999999999997, 5.285],
    'honra': [3.074, 2.7039999999999997, 4.57],
    'honradez': [3.7910000000000004, 3.128, 5.199],
    'hora': [5.416, 4.69, 6.231],
    'horario': [5.131, 5.261, 6.697],
    'horca': [5.723, 5.611000000000001, 3.15],
    'horda': [3.799, 2.352, 1.6119999999999999],
    'horizonte': [5.236000000000001, 5.7589999999999995, 5.184],
    'hormiga': [6.551, 6.507999999999999, 5.965],
    'hormigueo': [4.0760000000000005, 4.69, 4.043],
    'hormiguero': [5.888999999999999, 5.892, 5.216],
    'hormona': [5.483, 2.9410000000000003, 4.329],
    'horno': [6.058, 6.475, 6.5120000000000005],
    'horror': [4.073, 4.544, 4.357],
    'hortalizas': [5.223, 6.11, 5.06],
    'hospital': [6.609, 6.4670000000000005, 6.218999999999999],
    'hostia': [4.967, 6.093999999999999, 5.252999999999999],
    'hostilidad': [4.226, 4.7139999999999995, 4.346],
    'hotel': [6.346, 5.627999999999999, 6.36],
    'hoyo': [5.445, 5.336, 3.972],
    'hoz': [5.212000000000001, 4.72, 3.3689999999999998],
    'hueco': [4.7669999999999995, 5.569, 6.159],
    'huelga': [5.225, 5.348, 6.415],
    'huella': [5.312, 5.332999999999999, 4.942],
    'huerto': [5.885, 6.3420000000000005, 5.747999999999999],
    'hueso': [5.669, 6.037000000000001, 6.416],
    'huevo': [5.564, 6.319, 6.4479999999999995],
    'huida': [4.541, 5.188, 4.868],
    'huir': [4.546, 5.03, 5.4510000000000005],
    'humanidad': [4.066, 3.988, 5.0680000000000005],
    'humanismo': [3.5580000000000003, 3.0380000000000003, 3.963],
    'humanista': [3.549, 3.0460000000000003, 4.221],
    'humano': [5.27, 5.95, 5.9110000000000005],
    'humareda': [4.605, 5.957999999999999, 5.022],
    'humedad': [4.401, 4.708, 6.599],
    'humildad': [3.8989999999999996, 2.917, 4.745],
    'humillación': [3.932, 3.924, 4.375],
    'humo': [5.126, 5.881, 6.392],
    'humor': [3.1430000000000002, 4.208, 6.167999999999999],
    'hundimiento': [4.227, 4.908, 4.019],
    'hundir': [4.959, 5.0680000000000005, 6.294],
    'hundirse': [4.249, 5.218999999999999, 5.699],
    'huracán': [5.685, 5.294, 4.144],
    'hurgar': [3.908, 3.14, 2.444],
    'huérfana': [5.7139999999999995, 3.964, 3.332],
    'huésped': [5.723, 4.507, 4.893],
    'hábito': [3.517, 5.229, 5.31],
    'hálito': [3.386, 2.496, 2.367],
    'hélice': [6.156000000000001, 5.541, 4.5889999999999995],
    'héroe': [5.051, 5.678999999999999, 4.512],
    'hígado': [6.091, 5.346, 6.146],
    'ida': [3.7710000000000004, 2.821, 4.859],
    'idea': [4.078, 3.9760000000000004, 6.749],
    'ideal': [3.332, 3.4560000000000004, 5.653],
    'idealismo': [3.034, 2.4859999999999998, 4.8580000000000005],
    'idealistas': [3.647, 2.98, 4.683],
    'identidad': [3.642, 2.8, 5.662000000000001],
    'identidades': [3.59, 2.8789999999999996, 4.149],
    'identificación': [3.641, 4.452, 6.13],
    'identificar': [3.5610000000000004, 3.085, 4.718999999999999],
    'identificarse': [3.8080000000000003, 2.742, 5.507999999999999],
    'ideología': [2.695, 2.745, 5.375],
    'idilio': [4.575, 4.553999999999999, 3.983],
    'idioma': [5.078, 3.6439999999999997, 6.3420000000000005],
    'idiota': [4.129, 3.57, 5.81],
    'idéntico': [4.663, 4.3260000000000005, 6.143],
    'iglesia': [5.662000000000001, 5.712999999999999, 4.677],
    'ignorantes': [4.19, 3.0439999999999996, 4.657],
    'ignorar': [4.0089999999999995, 3.207, 5.371],
    'igualar': [3.6210000000000004, 2.968, 4.474],
    'igualdad': [3.823, 4.273, 5.405],
    'iguana': [6.1770000000000005, 5.561, 3.1],
    'iluminación': [4.3389999999999995, 4.982, 5.947],
    'iluminada': [3.699, 4.643, 5.859],
    'iluminado': [3.821, 4.056, 5.421],
    'iluminar': [3.9330000000000003, 4.685, 5.459],
    'ilusión': [3.373, 4.1, 6.611000000000001],
    'ilustración': [3.1660000000000004, 4.657, 4.585],
    'ilustrado': [3.605, 3.698, 4.414],
    'ilustrar': [3.616, 3.655, 3.648],
    'imagen': [3.4739999999999998, 4.27, 6.1739999999999995],
    'imaginación': [3.71, 2.8739999999999997, 6.284],
    'imaginar': [3.455, 4.235, 5.569],
    'imaginarse': [3.963, 3.68, 6.045],
    'imitación': [3.905, 4.1419999999999995, 6.151],
    'imitar': [4.619, 4.0969999999999995, 5.306],
    'impaciencia': [3.557, 3.687, 5.7139999999999995],
    'impacto': [4.197, 4.363, 4.7989999999999995],
    'impedido': [3.4019999999999997, 4.665, 4.4110000000000005],
    'impedir': [4.354, 3.2710000000000004, 5.584],
    'impenitente': [3.555, 1.8090000000000002, 2.028],
    'imperio': [4.208, 4.156000000000001, 3.7089999999999996],
    'impertinencia': [5.314, 3.658, 5.757000000000001],
    'implantación': [3.551, 3.272, 3.2239999999999998],
    'implicaciones': [2.813, 1.959, 3.997],
    'imponer': [4.331, 3.719, 4.967],
    'imponerse': [3.5010000000000003, 4.312, 5.531000000000001],
    'importancia': [3.8710000000000004, 3.4339999999999997, 6.372999999999999],
    'importe': [4.635, 4.079, 5.17],
    'imposición': [3.387, 2.7560000000000002, 4.4239999999999995],
    'impotencia': [3.49, 3.865, 5.635],
    'impotente': [4.387, 3.822, 5.7989999999999995],
    'imprenta': [5.38, 5.178999999999999, 4.9319999999999995],
    'impreso': [4.4110000000000005, 5.311, 4.81],
    'imprimir': [5.265, 4.73, 5.462000000000001],
    'improvisación': [3.762, 3.5669999999999997, 5.496],
    'impuesto': [4.629, 3.9160000000000004, 5.466],
    'impulso': [4.052, 3.903, 5.367000000000001],
    'impunidad': [3.7889999999999997, 1.895, 2.432],
    'impureza': [3.45, 3.198, 2.5980000000000003],
    'imán': [5.761, 5.942, 4.926],
    'inactivación': [4.095, 2.7960000000000003, 4.863],
    'inauguración': [4.025, 4.7219999999999995, 5.329],
    'incapacidad': [3.534, 3.287, 5.404],
    'incendio': [6.167000000000001, 5.638999999999999, 4.966],
    'incertidumbre': [3.552, 3.43, 4.33],
    'incidencia': [3.094, 2.298, 2.778],
    'incidente': [3.411, 3.128, 4.181],
    'incienso': [5.987, 5.3660000000000005, 4.058],
    'inclinación': [3.875, 4.319, 4.978],
    'inclinarse': [4.645, 5.779, 5.531000000000001],
    'incomprensión': [4.12, 3.407, 5.388],
    'inconveniente': [3.5580000000000003, 2.755, 4.162],
    'incorporación': [3.877, 3.37, 4.849],
    'incorporar': [3.8160000000000003, 3.028, 5.083],
    'incorporarse': [3.602, 2.91, 5.796],
    'incredulidad': [4.5360000000000005, 3.457, 4.635],
    'incrementar': [4.224, 3.593, 4.691],
    'incremento': [3.9730000000000003, 2.997, 5.153],
    'incumplimiento': [3.432, 3.22, 3.4339999999999997],
    'incurrir': [2.87, 1.83, 3.463],
    'incursión': [3.159, 3.3160000000000003, 3.693],
    'incógnita': [3.937, 2.799, 4.407],
    'indagación': [3.975, 3.5789999999999997, 4.02],
    'indagar': [4.146, 3.197, 3.637],
    'indecisión': [3.431, 4.23, 5.4670000000000005],
    'indeterminación': [3.407, 2.003, 3.767],
    'indias': [4.112, 5.4670000000000005, 4.603],
    'indicación': [4.295, 4.234, 5.246],
    'indicador': [3.639, 4.238, 4.59],
    'indicar': [4.435, 4.567, 5.693],
    'indicio': [3.205, 2.478, 4.575],
    'indiferencia': [2.76, 3.35, 4.953],
    'indignación': [4.189, 4.008, 5.109],
    'indio': [5.519, 6.593999999999999, 5.01],
    'individualidad': [3.783, 2.7310000000000003, 3.9819999999999998],
    'individualismo': [4.695, 2.89, 4.506],
    'individualista': [4.169, 3.3710000000000004, 5.103],
    'individuo': [4.715, 5.381, 5.907],
    'inducción': [3.5869999999999997, 1.9569999999999999, 3.8939999999999997],
    'inducir': [3.017, 2.05, 3.989],
    'indumentaria': [4.615, 4.588, 4.471],
    'industrial': [4.985, 4.5760000000000005, 5.547999999999999],
    'industrialización': [4.618, 4.86, 5.93],
    'indígenas': [5.249, 5.641, 5.566],
    'inercia': [3.995, 2.638, 4.736000000000001],
    'inestabilidad': [3.265, 4.1080000000000005, 5.25],
    'inexistencia': [3.052, 2.655, 3.497],
    'inexistente': [4.275, 2.352, 4.294],
    'infame': [3.235, 2.6519999999999997, 3.286],
    'infancia': [4.691, 4.756, 5.702999999999999],
    'infante': [4.4239999999999995, 4.746, 3.427],
    'infarto': [5.632000000000001, 4.249, 5.77],
    'infección': [5.1339999999999995, 4.4639999999999995, 5.061],
    'infeliz': [4.169, 4.824, 4.24],
    'inferioridad': [4.031000000000001, 3.907, 5.059],
    'infidelidad': [4.388999999999999, 4.747, 5.1770000000000005],
    'infierno': [4.187, 4.768, 5.7410000000000005],
    'infinito': [2.648, 3.509, 5.307],
    'infinitud': [2.219, 3.745, 4.408],
    'inflación': [3.636, 2.24, 3.472],
    'influencia': [4.171, 2.891, 5.477],
    'influjo': [2.821, 2.006, 3.8089999999999997],
    'información': [2.9960000000000004, 3.4, 5.434],
    'informar': [4.11, 3.2739999999999996, 5.901],
    'informativo': [4.205, 5.3839999999999995, 5.64],
    'informe': [4.563, 4.761, 5.2589999999999995],
    'informática': [5.542999999999999, 4.463, 5.968999999999999],
    'informático': [4.996, 4.556, 5.444],
    'ingenio': [3.387, 2.9619999999999997, 4.336],
    'ingenuidad': [3.838, 2.8960000000000004, 5.789],
    'ingles': [4.87, 4.277, 5.867999999999999],
    'inglesa': [4.177, 3.391, 4.587],
    'inglés': [4.958, 4.687, 5.394],
    'ingrediente': [3.596, 4.393, 6.223],
    'ingresar': [3.365, 4.121, 5.307],
    'ingreso': [3.9139999999999997, 3.5039999999999996, 4.931],
    'ingresos': [4.127, 3.71, 4.5760000000000005],
    'inhibición': [3.62, 3.656, 5.138],
    'inhibidores': [3.176, 2.7119999999999997, 5.0360000000000005],
    'iniciación': [3.339, 2.786, 3.94],
    'iniciada': [3.194, 3.08, 4.209],
    'iniciado': [3.464, 2.387, 4.065],
    'iniciales': [4.412, 4.199, 4.673],
    'iniciar': [3.884, 3.0410000000000004, 4.224],
    'iniciarse': [3.168, 2.517, 5.307],
    'iniciativa': [3.548, 3.093, 5.778],
    'inicio': [4.0360000000000005, 3.055, 5.422000000000001],
    'injusticia': [4.12, 4.8660000000000005, 6.063],
    'inmensidad': [2.7319999999999998, 4.446000000000001, 4.631],
    'inmortalidad': [4.361000000000001, 2.9739999999999998, 4.987],
    'inmovilidad': [4.801, 4.599, 4.069],
    'inmueble': [3.908, 4.655, 3.8989999999999996],
    'inmutarse': [4.305, 3.8510000000000004, 4.974],
    'innovación': [3.398, 2.705, 4.1160000000000005],
    'inocencia': [4.2, 4.022, 6.358],
    'inocente': [4.02, 3.841, 5.62],
    'inquietud': [3.5469999999999997, 4.06, 4.65],
    'inquisición': [4.805, 3.966, 4.706],
    'inquisidor': [4.247, 3.168, 2.705],
    'insatisfacción': [3.386, 3.847, 4.257],
    'inscripción': [4.893, 4.959, 5.727],
    'insecto': [4.808, 6.058, 5.928],
    'inseguridad': [3.752, 3.6660000000000004, 5.436],
    'inserción': [3.411, 3.3169999999999997, 3.571],
    'insistencia': [3.8360000000000003, 2.87, 5.39],
    'insistir': [4.52, 3.5789999999999997, 5.236000000000001],
    'insomnio': [5.195, 4.213, 5.971],
    'inspección': [3.782, 3.6630000000000003, 4.7139999999999995],
    'inspector': [5.172000000000001, 5.47, 5.28],
    'inspiración': [3.67, 4.1930000000000005, 5.29],
    'inspirar': [4.053999999999999, 3.761, 4.776],
    'instalación': [4.357, 3.389, 4.3660000000000005],
    'instalar': [4.018, 3.877, 4.9639999999999995],
    'instalarse': [4.2589999999999995, 3.614, 5.417999999999999],
    'instancia': [4.113, 3.6260000000000003, 3.8089999999999997],
    'instante': [4.383, 2.124, 5.369],
    'instantánea': [3.8789999999999996, 2.9, 4.816],
    'instinto': [4.421, 3.429, 6.225],
    'institución': [3.5189999999999997, 3.865, 5.263],
    'instituto': [5.303999999999999, 6.456, 6.746],
    'instrucción': [3.2969999999999997, 3.523, 4.428999999999999],
    'instrumental': [3.53, 4.363, 5.542999999999999],
    'insuficiencia': [3.283, 2.8169999999999997, 5.667000000000001],
    'insulina': [6.25, 3.0389999999999997, 3.487],
    'insulto': [3.9760000000000004, 3.801, 5.852],
    'integración': [3.662, 2.695, 4.87],
    'integrar': [3.553, 3.88, 5.16],
    'integrarse': [2.8089999999999997, 3.383, 4.915],
    'integridad': [3.537, 2.222, 4.294],
    'intelectual': [4.647, 4.504, 5.466],
    'inteligencia': [3.958, 3.01, 6.8],
    'intemperie': [4.9239999999999995, 4.646, 3.216],
    'intencionalidad': [3.48, 2.6260000000000003, 4.516],
    'intención': [3.9019999999999997, 2.176, 5.796],
    'intensidad': [3.0580000000000003, 3.003, 5.643],
    'intentar': [3.4339999999999997, 3.866, 6.098],
    'intento': [3.513, 3.307, 5.553],
    'interacción': [3.3360000000000003, 3.3810000000000002, 5.55],
    'intercambio': [3.9530000000000003, 3.846, 4.269],
    'interesada': [3.609, 3.608, 5.716],
    'interesado': [4.6160000000000005, 3.117, 5.565],
    'interesar': [3.8489999999999998, 3.673, 5.9639999999999995],
    'interferencia': [4.361000000000001, 4.144, 5.547999999999999],
    'interior': [3.718, 4.06, 5.582999999999999],
    'interioridad': [3.2680000000000002, 3.2110000000000003, 4.345],
    'interlocutor': [4.928, 5.12, 4.912],
    'intermedio': [3.872, 3.69, 6.1129999999999995],
    'internado': [4.873, 5.236000000000001, 4.956],
    'internas': [3.7110000000000003, 3.367, 4.955],
    'interpretar': [2.938, 3.898, 5.415],
    'interrogación': [4.602, 4.601, 5.652],
    'interrogante': [4.602, 4.738, 5.997000000000001],
    'interrogar': [4.556, 4.912, 5.434],
    'interrogatorio': [4.655, 5.42, 4.558],
    'interrumpir': [4.479, 3.897, 5.957999999999999],
    'interrupción': [3.695, 4.0169999999999995, 6.487],
    'intervalo': [4.102, 2.97, 5.662999999999999],
    'intervención': [2.7310000000000003, 3.5189999999999997, 5.146],
    'intervenir': [2.8139999999999996, 3.082, 5.4110000000000005],
    'interés': [2.977, 3.71, 6.433],
    'intestinos': [6.433, 5.075, 5.0089999999999995],
    'intimidad': [3.736, 3.992, 6.2860000000000005],
    'intransigencia': [3.4010000000000002, 3.34, 3.7110000000000003],
    'intriga': [3.865, 3.39, 5.015],
    'introducción': [4.176, 3.5589999999999997, 5.468],
    'introducir': [3.242, 4.266, 4.9319999999999995],
    'introducirse': [3.951, 4.2010000000000005, 5.141],
    'intromisión': [3.5839999999999996, 2.656, 2.991],
    'intruso': [5.218, 4.774, 4.875],
    'intuición': [4.266, 2.37, 5.968],
    'intuir': [3.582, 2.875, 5.425],
    'inundación': [5.564, 5.607, 5.446000000000001],
    'inutilidad': [3.7430000000000003, 2.8819999999999997, 5.718],
    'invadir': [4.133, 4.66, 6.007000000000001],
    'invasión': [4.976, 4.485, 4.619],
    'invasores': [5.5089999999999995, 5.347, 5.232],
    'invención': [4.033, 3.4419999999999997, 4.7989999999999995],
    'inventario': [4.167, 3.492, 3.8739999999999997],
    'inventiva': [2.812, 3.523, 3.6210000000000004],
    'invento': [4.284, 3.528, 4.944],
    'inventor': [6.027, 5.061, 4.909],
    'invernadero': [6.002999999999999, 5.8629999999999995, 5.686],
    'inversión': [3.813, 2.9989999999999997, 4.627],
    'investigación': [4.073, 4.533, 6.058],
    'investigador': [4.729, 4.975, 5.251],
    'investigar': [3.7689999999999997, 4.0889999999999995, 5.622000000000001],
    'invitación': [4.577, 4.796, 6.102],
    'invitada': [4.739, 4.151, 5.428999999999999],
    'invitado': [5.3, 4.808, 4.265],
    'invitar': [4.364, 4.55, 6.348],
    'invocar': [3.661, 2.958, 3.6489999999999996],
    'inyecciones': [5.367000000000001, 5.904, 5.821000000000001],
    'ir': [3.353, 3.1310000000000002, 6.492999999999999],
    'ira': [3.35, 4.671, 5.063],
    'iris': [5.12, 4.393, 4.026],
    'irlandés': [5.541, 3.477, 4.088],
    'ironía': [3.752, 2.6489999999999996, 5.746],
    'irracionalidad': [3.815, 2.64, 5.129],
    'irrealidad': [2.605, 2.7510000000000003, 4.169],
    'irritación': [3.645, 5.006, 5.154],
    'irse': [4.096, 4.624, 6.072],
    'isla': [6.4639999999999995, 6.15, 5.9079999999999995],
    'islam': [5.755, 3.968, 2.302],
    'italiana': [5.824, 4.454, 5.44],
    'italiano': [5.605, 6.414, 5.318],
    'itinerario': [5.051, 4.683, 3.877],
    'izquierda': [5.396, 4.257, 6.656000000000001],
    'ión': [4.538, 2.8689999999999998, 2.6189999999999998],
    'jabalí': [5.95, 5.69, 5.394],
    'jabón': [6.619, 5.648, 6.787000000000001],
    'jadeo': [4.33, 5.189, 4.7219999999999995],
    'jamón': [6.251, 6.125, 5.922999999999999],
    'japonesa': [5.695, 5.7010000000000005, 5.12],
    'japonés': [6.144, 4.522, 4.893],
    'jardinero': [6.223, 5.792999999999999, 5.542000000000001],
    'jardín': [6.261, 5.864, 6.218999999999999],
    'jarra': [6.2589999999999995, 5.829, 5.874],
    'jarrón': [6.249, 6.35, 5.377999999999999],
    'jaula': [6.07, 6.485, 6.47],
    'jazmín': [6.4510000000000005, 4.602, 3.0869999999999997],
    'jefatura': [4.2010000000000005, 4.475, 4.673],
    'jefe': [5.757000000000001, 5.382000000000001, 6.197],
    'jerarquización': [3.505, 2.347, 4.848],
    'jerarquía': [3.957, 3.53, 4.135],
    'jerga': [4.185, 2.764, 4.396],
    'jeringuilla': [6.249, 6.556, 5.468],
    'jersey': [6.39, 6.212000000000001, 6.438],
    'jesuita': [5.185, 4.132, 4.253],
    'jeta': [4.781000000000001, 3.572, 4.553999999999999],
    'jinete': [6.02, 6.154, 4.065],
    'joder': [4.387, 5.497000000000001, 5.53],
    'joderse': [3.821, 4.067, 4.9510000000000005],
    'jornada': [4.57, 4.175, 4.458],
    'joven': [4.919, 5.6770000000000005, 6.687],
    'joya': [5.11, 5.97, 6.053],
    'jubilado': [5.692, 5.4479999999999995, 6.154],
    'judía': [5.147, 4.652, 5.284],
    'judío': [5.872999999999999, 4.716, 5.156000000000001],
    'juego': [4.713, 5.475, 6.506],
    'juerga': [4.897, 5.486000000000001, 5.747999999999999],
    'juez': [6.007999999999999, 5.962999999999999, 5.381],
    'jugada': [3.94, 3.5980000000000003, 6.486000000000001],
    'jugador': [4.762, 5.975, 5.957000000000001],
    'jugar': [3.835, 5.433, 6.704],
    'jugo': [4.649, 5.731, 4.4430000000000005],
    'juguete': [5.0089999999999995, 6.598, 6.644],
    'juicio': [4.406000000000001, 5.406000000000001, 5.688],
    'juncos': [5.899, 5.2379999999999995, 2.656],
    'jungla': [4.965, 6.223, 5.35],
    'junio': [6.345, 4.081, 6.422000000000001],
    'junta': [3.93, 3.853, 4.537],
    'jura': [3.9210000000000003, 3.185, 4.829],
    'jurado': [5.221, 4.662, 5.791],
    'jurar': [4.327, 3.238, 5.462000000000001],
    'justificación': [4.046, 3.39, 5.067],
    'justificar': [3.763, 2.9210000000000003, 6.085],
    'juventud': [4.599, 5.261, 6.081],
    'juzgado': [5.651, 5.773, 5.414],
    'juzgar': [3.523, 4.099, 5.345],
    'júbilo': [4.099, 4.391, 3.8480000000000003],
    'júpiter': [6.024, 4.676, 4.555],
    'kilo': [5.555, 4.573, 6.325],
    'kilómetros': [6.044, 4.3389999999999995, 6.409],
    'laberinto': [5.789, 6.21, 5.5920000000000005],
    'labio': [6.1979999999999995, 6.726, 6.318],
    'labor': [2.6719999999999997, 3.1189999999999998, 4.877],
    'laboratorio': [5.768, 6.19, 5.559],
    'labrador': [6.0089999999999995, 5.755, 4.632],
    'ladera': [5.256, 4.229, 4.704],
    'lado': [4.0169999999999995, 4.063, 6.478],
    'ladrar': [5.867999999999999, 4.745, 6.489],
    'ladrido': [5.562, 5.252000000000001, 5.083],
    'ladrillo': [6.156000000000001, 5.432, 4.8469999999999995],
    'ladrón': [5.524, 5.438, 6.307],
    'lagartijas': [6.376, 6.3, 4.863],
    'lagarto': [5.899, 6.127000000000001, 5.468999999999999],
    'lago': [5.912999999999999, 5.962000000000001, 5.957999999999999],
    'laguna': [4.725, 6.218, 4.0360000000000005],
    'lamento': [3.878, 4.607, 5.555],
    'lana': [5.635, 5.11, 6.377000000000001],
    'lances': [3.412, 2.161, 2.589],
    'langostas': [6.117999999999999, 6.372000000000001, 4.081],
    'languidez': [3.971, 2.9139999999999997, 3.3510000000000004],
    'lanza': [5.246, 4.2, 4.593999999999999],
    'lanzamientos': [3.802, 5.075, 4.686],
    'lanzar': [4.63, 6.308, 5.167999999999999],
    'lanzarse': [3.465, 5.1739999999999995, 6.01],
    'lapso': [3.258, 3.63, 4.169],
    'larvas': [4.908, 4.7330000000000005, 2.949],
    'lateral': [4.808, 3.62, 5.497999999999999],
    'latido': [5.6610000000000005, 5.3260000000000005, 5.144],
    'latigazo': [5.234, 5.3260000000000005, 3.362],
    'latina': [3.9160000000000004, 3.748, 4.084],
    'latino': [4.905, 4.4430000000000005, 4.573],
    'latinoamericanos': [5.582999999999999, 5.247999999999999, 4.276],
    'latir': [4.73, 5.077, 5.377000000000001],
    'latín': [5.202000000000001, 4.478, 5.1160000000000005],
    'latón': [5.388, 4.7669999999999995, 4.156000000000001],
    'laurel': [6.228, 6.001, 4.373],
    'lavabo': [6.279, 6.622000000000001, 6.567],
    'lavadero': [5.372999999999999, 5.91, 5.218],
    'lavar': [4.986000000000001, 5.955, 6.394],
    'lavarse': [5.652, 5.277, 6.667000000000001],
    'lazo': [6.181, 6.465, 6.015],
    'lealtad': [4.35, 3.446, 4.785],
    'lección': [4.374, 4.159, 5.332000000000001],
    'leche': [5.686, 6.354, 6.59],
    'lecho': [4.901, 4.961, 3.6910000000000003],
    'lechuga': [6.152, 5.6579999999999995, 6.683],
    'lector': [5.351, 4.942, 4.97],
    'lectura': [4.917, 4.456, 5.981],
    'leer': [5.856, 5.412999999999999, 6.655],
    'legado': [4.026, 3.505, 2.98],
    'legalidad': [3.846, 2.549, 4.454],
    'legionario': [5.361000000000001, 5.03, 3.99],
    'legislación': [3.8080000000000003, 3.513, 3.753],
    'legitimación': [2.441, 1.55, 3.5980000000000003],
    'legitimidad': [3.718, 2.0340000000000003, 3.734],
    'legión': [5.475, 4.477, 4.606],
    'legua': [5.349, 3.339, 3.279],
    'lejanía': [4.058, 4.636, 5.565],
    'lema': [4.251, 3.6210000000000004, 4.688],
    'lencería': [5.666, 6.192, 5.937],
    'lengua': [5.443, 6.406000000000001, 5.614],
    'lenguaje': [3.878, 5.142, 6.284],
    'lentejas': [6.439, 5.801, 5.59],
    'lentejuelas': [5.696000000000001, 5.252000000000001, 4.354],
    'lentes': [5.59, 6.228, 4.723],
    'lentitud': [3.977, 4.252, 4.823],
    'leo': [4.958, 3.925, 5.193],
    'lesiones': [3.9530000000000003, 4.373, 6.184],
    'letargo': [3.813, 3.134, 3.3489999999999998],
    'letra': [5.447, 6.557, 6.249],
    'letrero': [6.187, 5.547000000000001, 5.478],
    'leucocitos': [6.216, 3.2060000000000004, 2.91],
    'levadura': [5.79, 5.416, 5.39],
    'levantar': [4.13, 4.346, 5.995],
    'levantarse': [4.94, 5.858, 6.853],
    'levante': [3.653, 3.498, 3.583],
    'ley': [4.732, 2.926, 4.963],
    'leña': [5.81, 6.553999999999999, 5.631],
    'león': [6.375, 6.763, 4.809],
    'liar': [2.64, 3.638, 5.211],
    'liberación': [3.69, 3.266, 5.277],
    'liberalismo': [3.554, 3.7569999999999997, 4.32],
    'liberar': [3.951, 5.138, 6.04],
    'liberarse': [4.038, 4.8, 5.65],
    'libertad': [3.7680000000000002, 4.934, 6.1339999999999995],
    'libra': [3.602, 4.88, 4.617],
    'librarse': [4.466, 4.173, 5.306],
    'librería': [6.306, 6.056, 6.672999999999999],
    'libreta': [5.441, 6.4270000000000005, 6.32],
    'libro': [6.066, 6.261, 6.857],
    'licencia': [4.841, 3.73, 4.981],
    'licenciada': [5.045, 4.9510000000000005, 5.431],
    'licenciado': [5.577000000000001, 3.8289999999999997, 5.731],
    'licor': [5.555, 6.2170000000000005, 5.593],
    'liebre': [6.1979999999999995, 6.0889999999999995, 3.678],
    'lienzo': [5.314, 5.587000000000001, 4.504],
    'liga': [4.67, 5.319, 6.235],
    'ligar': [3.386, 4.648, 5.485],
    'ligereza': [3.051, 4.127, 4.923],
    'limbo': [3.576, 2.036, 3.045],
    'limitación': [3.6860000000000004, 3.057, 6.171],
    'limitarse': [3.6239999999999997, 2.3209999999999997, 3.427],
    'limosna': [5.482, 5.412999999999999, 5.617999999999999],
    'limpiabotas': [6.43, 5.202999999999999, 3.65],
    'limpiar': [4.681, 5.093, 6.52],
    'limpieza': [4.629, 4.909, 6.077000000000001],
    'linaje': [4.421, 3.214, 3.8310000000000004],
    'lindezas': [3.185, 2.504, 3.512],
    'linfocitos': [6.037000000000001, 2.767, 3.845],
    'lingüística': [4.913, 3.282, 5.297999999999999],
    'linterna': [6.372999999999999, 5.792999999999999, 6.031000000000001],
    'lirio': [6.327000000000001, 4.619, 3.535],
    'lirismo': [2.969, 1.91, 2.7560000000000002],
    'lista': [3.9739999999999998, 5.666, 6.159],
    'literatura': [4.58, 4.473, 4.886],
    'litro': [5.346, 4.41, 5.88],
    'llaga': [5.126, 6.068, 4.436],
    'llama': [3.895, 5.921, 5.071000000000001],
    'llamaba': [3.435, 3.378, 5.775],
    'llamada': [4.394, 4.541, 5.829],
    'llamar': [3.543, 4.531000000000001, 5.537999999999999],
    'llamarse': [3.616, 2.279, 6.856],
    'llanto': [5.626, 6.045, 5.582000000000001],
    'llanura': [5.263, 5.524, 4.7589999999999995],
    'llave': [5.9079999999999995, 5.768, 6.736000000000001],
    'llegada': [4.172, 4.158, 6.034],
    'llegar': [4.045, 4.2780000000000005, 6.419],
    'llenar': [3.241, 4.854, 6.398],
    'llevar': [4.004, 4.444, 6.53],
    'llevarse': [3.7039999999999997, 3.1860000000000004, 6.542999999999999],
    'llorar': [5.121, 6.421, 6.412999999999999],
    'llovizna': [5.609, 5.22, 5.403],
    'lluvia': [6.016, 6.331, 5.7860000000000005],
    'loba': [5.726, 5.854, 4.449],
    'lobo': [5.9670000000000005, 6.103, 6.1339999999999995],
    'loca': [4.546, 5.404, 6.0520000000000005],
    'local': [4.81, 5.776, 5.91],
    'localidad': [4.572, 4.887, 5.218999999999999],
    'localización': [4.305, 3.515, 4.956],
    'loco': [4.2589999999999995, 5.228, 6.515],
    'locomotora': [6.136, 6.696000000000001, 3.555],
    'locura': [3.617, 4.385, 5.517],
    'locutor': [5.681, 5.524, 5.37],
    'lodo': [4.9639999999999995, 5.678999999999999, 3.545],
    'lograr': [4.226, 2.126, 5.282],
    'logro': [3.202, 3.679, 4.9830000000000005],
    'loma': [4.26, 3.975, 3.78],
    'lomo': [4.133, 5.885, 5.023],
    'lona': [5.337999999999999, 5.316, 5.1370000000000005],
    'londinense': [5.619, 4.484, 4.852],
    'longitud': [4.454, 4.206, 6.157],
    'loro': [6.341, 6.109, 6.096],
    'losa': [5.327999999999999, 5.388999999999999, 4.111000000000001],
    'lotería': [5.562, 6.122999999999999, 5.667000000000001],
    'loto': [4.001, 4.4319999999999995, 3.661],
    'lucha': [4.251, 5.33, 5.291],
    'luchar': [4.28, 4.611000000000001, 5.916],
    'lucidez': [3.08, 2.845, 4.901],
    'lucir': [3.15, 4.006, 5.461],
    'lucro': [4.053999999999999, 2.335, 3.5060000000000002],
    'lugar': [3.4339999999999997, 4.065, 6.172999999999999],
    'lujuria': [4.908, 3.608, 4.861000000000001],
    'lumbre': [5.609, 6.256, 3.37],
    'luminosidad': [4.268, 5.68, 5.167000000000001],
    'luminoso': [4.562, 5.481, 5.106],
    'luna': [6.282, 5.749, 5.96],
    'lunar': [4.975, 5.352, 5.517],
    'lunes': [5.777, 3.867, 7.0],
    'luto': [5.617000000000001, 5.3260000000000005, 5.457000000000001],
    'luz': [4.68, 6.191, 6.749],
    'lágrima': [6.4479999999999995, 6.205, 5.501],
    'lámina': [4.559, 5.337000000000001, 6.096],
    'lámpara': [6.112, 6.104, 6.154],
    'lápiz': [6.765, 5.96, 6.121],
    'láser': [5.981, 4.518, 4.465],
    'lástima': [3.8989999999999996, 3.713, 5.3420000000000005],
    'látigo': [6.551, 6.225, 3.529],
    'léxico': [3.9530000000000003, 5.433, 5.459],
    'líder': [5.196000000000001, 5.032, 6.013999999999999],
    'límite': [3.9560000000000004, 3.2889999999999997, 5.356],
    'línea': [4.788, 4.897, 6.166],
    'lío': [3.125, 3.52, 5.792000000000001],
    'líquido': [5.352, 6.05, 6.811],
    'lírica': [4.438, 3.28, 3.853],
    'lóbulo': [5.042, 4.946000000000001, 4.553999999999999],
    'lógica': [3.549, 2.668, 5.232],
    'macarra': [5.194, 5.725, 5.612],
    'macetas': [6.474, 6.403, 6.067],
    'macho': [5.767, 6.654, 6.017],
    'macizo': [3.647, 4.596, 4.686],
    'macromoléculas': [4.89, 2.7319999999999998, 2.891],
    'madera': [6.04, 6.353, 6.335],
    'madrastra': [5.515, 4.23, 2.37],
    'madre': [6.212000000000001, 6.742999999999999, 6.946000000000001],
    'madrileña': [5.9239999999999995, 4.166, 5.349],
    'madrileño': [5.59, 4.275, 4.571000000000001],
    'madrina': [5.736000000000001, 5.0489999999999995, 4.987],
    'madrugada': [5.7139999999999995, 4.7860000000000005, 6.077999999999999],
    'madrugar': [5.38, 5.0760000000000005, 6.445],
    'maduración': [3.4210000000000003, 3.702, 5.218],
    'madurez': [3.9589999999999996, 3.918, 4.813],
    'maestra': [5.845, 5.787000000000001, 5.984],
    'maestro': [5.59, 6.237, 5.806],
    'mafia': [4.681, 4.4239999999999995, 4.862],
    'magnetismo': [4.1, 3.1689999999999996, 4.636],
    'magnitud': [2.978, 2.349, 3.929],
    'mago': [5.415, 5.773, 5.834],
    'majestad': [5.18, 4.974, 4.995],
    'mal': [2.745, 2.862, 6.5489999999999995],
    'malaria': [5.79, 3.0389999999999997, 2.225],
    'maldad': [3.435, 4.515, 6.021],
    'maldición': [3.883, 4.156000000000001, 4.801],
    'maldito': [4.178, 2.8819999999999997, 5.122000000000001],
    'maleficio': [3.8110000000000004, 3.051, 2.491],
    'malentendidos': [3.512, 3.513, 4.931],
    'malestar': [3.303, 4.112, 5.148],
    'maleta': [6.12, 4.87, 5.837999999999999],
    'maletín': [5.996, 6.325, 3.549],
    'maleza': [4.813, 5.3020000000000005, 5.202000000000001],
    'malicia': [3.43, 4.198, 5.209],
    'malla': [4.806, 4.6339999999999995, 4.613],
    'malvados': [4.027, 4.966, 4.7669999999999995],
    'mama': [5.9479999999999995, 5.996, 6.042999999999999],
    'mamá': [6.47, 6.497999999999999, 6.598],
    'manada': [4.678, 5.9270000000000005, 4.668],
    'manantial': [5.8839999999999995, 6.282, 5.224],
    'mancha': [6.007000000000001, 6.393, 6.539],
    'mandar': [4.351, 4.252, 6.245],
    'mandato': [3.905, 3.353, 5.466],
    'mando': [3.843, 4.462, 5.662000000000001],
    'mandíbula': [6.34, 6.117999999999999, 5.575],
    'manejar': [3.4160000000000004, 3.9139999999999997, 5.774],
    'manera': [1.985, 2.0540000000000003, 6.268],
    'manga': [5.257000000000001, 5.542000000000001, 6.1160000000000005],
    'mango': [5.113, 5.763999999999999, 5.395],
    'manicomio': [6.0889999999999995, 5.4079999999999995, 4.7989999999999995],
    'manifestar': [3.5580000000000003, 3.4360000000000004, 4.58],
    'manifestarse': [4.309, 5.207999999999999, 6.066],
    'maniobra': [3.637, 3.645, 4.648],
    'manipulación': [3.571, 2.552, 4.673],
    'manipular': [3.2310000000000003, 3.113, 5.48],
    'manivela': [5.681, 5.662999999999999, 5.557],
    'mano': [6.315, 6.7170000000000005, 6.513999999999999],
    'manojo': [4.343999999999999, 5.03, 4.555],
    'manotazo': [5.847, 4.712, 5.071000000000001],
    'mansión': [5.9510000000000005, 5.936, 5.11],
    'manta': [6.086, 5.602, 6.7010000000000005],
    'mantel': [6.375, 6.0360000000000005, 6.306],
    'mantener': [2.3209999999999997, 2.363, 4.805],
    'mantenerse': [3.582, 3.4010000000000002, 5.986000000000001],
    'mantenimiento': [3.455, 2.531, 4.8389999999999995],
    'mantequilla': [6.435, 5.797999999999999, 6.3020000000000005],
    'manto': [4.527, 5.462000000000001, 2.773],
    'manual': [4.538, 3.801, 6.015],
    'manuscrito': [5.396, 5.047, 4.6530000000000005],
    'manzana': [6.132999999999999, 6.58, 6.535],
    'manía': [3.498, 3.907, 6.337000000000001],
    'mapa': [4.827, 6.17, 5.939],
    'maquillaje': [5.178, 5.449, 6.336],
    'maquinaria': [4.669, 5.502000000000001, 5.382999999999999],
    'mar': [6.292999999999999, 6.05, 6.545],
    'maracas': [6.349, 5.477, 3.832],
    'maravilla': [3.5389999999999997, 3.01, 5.729],
    'maraña': [3.688, 3.7569999999999997, 3.4539999999999997],
    'marca': [3.594, 4.666, 6.1739999999999995],
    'marcar': [3.88, 5.392, 6.066],
    'marcha': [3.12, 4.596, 5.43],
    'marchar': [4.758, 4.072, 6.502000000000001],
    'marcharse': [4.703, 5.138, 5.934],
    'marco': [4.417, 5.62, 5.626],
    'marea': [4.955, 5.044, 4.34],
    'marejada': [5.252000000000001, 4.922, 3.43],
    'mareo': [4.88, 5.083, 5.269],
    'marfil': [6.023, 5.3629999999999995, 3.9619999999999997],
    'margarita': [5.821000000000001, 6.678, 6.534],
    'margen': [4.061, 4.131, 5.294],
    'marginación': [3.58, 3.8360000000000003, 5.436],
    'marica': [4.77, 4.968999999999999, 4.7669999999999995],
    'maricón': [5.7010000000000005, 5.715, 5.34],
    'marido': [6.115, 4.873, 5.189],
    'marina': [4.3660000000000005, 4.317, 4.966],
    'marinero': [6.558, 6.41, 5.968],
    'marines': [5.247000000000001, 5.093999999999999, 3.822],
    'mariposa': [6.239, 6.657, 5.957000000000001],
    'mariquita': [5.48, 6.093, 5.013999999999999],
    'mariscal': [4.669, 4.021, 2.667],
    'marquesa': [5.193, 4.601, 3.793],
    'marqués': [5.49, 4.72, 3.8169999999999997],
    'martes': [6.197, 3.239, 6.329],
    'martillo': [5.903, 5.862, 5.626],
    'martirio': [3.7769999999999997, 3.4139999999999997, 2.6630000000000003],
    'marzo': [5.622999999999999, 4.103, 6.3],
    'masa': [3.668, 4.293, 5.3],
    'masaje': [5.5760000000000005, 6.142, 4.93],
    'mascar': [4.746, 5.593999999999999, 5.402],
    'masticar': [5.684, 6.28, 6.1160000000000005],
    'masturbación': [6.136, 5.7, 5.42],
    'masón': [4.633, 2.5839999999999996, 1.63],
    'matanza': [4.941, 5.172999999999999, 4.289],
    'matar': [5.207999999999999, 5.82, 5.359],
    'matemáticas': [5.212000000000001, 4.752, 5.629],
    'matemático': [4.5089999999999995, 4.073, 5.601],
    'materia': [2.261, 3.233, 5.672999999999999],
    'materialistas': [3.477, 3.5869999999999997, 6.1739999999999995],
    'maternidad': [5.3629999999999995, 4.704, 5.204],
    'matiz': [3.1189999999999998, 2.549, 4.534],
    'matorrales': [5.601, 6.151, 5.263999999999999],
    'matrimonio': [5.857, 5.709, 5.97],
    'matriz': [4.111000000000001, 4.3580000000000005, 4.862],
    'mayo': [6.267, 3.7910000000000004, 5.33],
    'mayordomo': [5.085, 6.197, 2.2569999999999997],
    'mazapanes': [6.245, 6.019, 4.939],
    'maíz': [6.406000000000001, 6.156000000000001, 6.148],
    'maña': [4.0680000000000005, 3.725, 4.631],
    'mañana': [4.861000000000001, 5.059, 6.4479999999999995],
    'mear': [5.596, 5.465, 6.195],
    'mecanismo': [2.715, 3.779, 4.928],
    'mecedora': [5.697, 6.138, 5.349],
    'mechero': [6.646, 6.5520000000000005, 6.441],
    'mechón': [4.8260000000000005, 6.021, 5.473],
    'mecánico': [6.032, 6.102, 6.331],
    'medalla': [5.627999999999999, 6.391, 5.806],
    'media': [2.9610000000000003, 5.3, 6.152],
    'mediación': [3.258, 1.972, 3.965],
    'mediana': [3.6430000000000002, 4.033, 4.5969999999999995],
    'medianoche': [6.199, 5.879, 6.004],
    'mediar': [3.0069999999999997, 2.226, 4.467],
    'medias': [4.668, 5.8870000000000005, 6.074],
    'medicamentos': [5.305, 5.696000000000001, 6.563],
    'medicina': [5.093, 5.18, 5.228],
    'medición': [3.7489999999999997, 3.404, 4.453],
    'medida': [2.889, 3.668, 5.996],
    'medio': [2.488, 2.907, 4.552],
    'mediodía': [5.519, 5.018, 6.059],
    'medir': [4.216, 4.265, 6.455],
    'meditación': [3.699, 4.123, 5.104],
    'meditar': [3.701, 4.544, 4.4719999999999995],
    'medrar': [4.367, 3.56, 4.024],
    'mejilla': [6.574, 5.569, 5.436],
    'mejora': [3.093, 3.74, 6.029],
    'mejorar': [3.378, 3.0210000000000004, 5.912000000000001],
    'melancolía': [4.656000000000001, 4.374, 5.154],
    'melena': [5.853, 6.345, 6.114],
    'mella': [3.739, 2.636, 2.613],
    'melodía': [4.721, 4.756, 4.993],
    'membrana': [4.627, 3.715, 4.953],
    'memoria': [4.609, 2.242, 5.801],
    'mencionar': [4.298, 3.3160000000000003, 5.731],
    'mendaz': [3.252, 2.249, 1.3769999999999998],
    'mendigo': [6.1610000000000005, 6.289, 5.982],
    'menester': [3.438, 2.468, 3.2119999999999997],
    'menor': [5.322, 4.327, 5.7989999999999995],
    'menosprecio': [4.508, 3.905, 3.9],
    'mensaje': [5.237, 4.363, 5.709],
    'mensajero': [5.716, 5.861000000000001, 6.156000000000001],
    'menstruación': [6.406000000000001, 5.7989999999999995, 5.817],
    'mentalidad': [4.994, 2.758, 4.351],
    'mente': [3.761, 2.8819999999999997, 6.362],
    'mentir': [3.906, 3.8569999999999998, 6.404],
    'mentira': [4.3660000000000005, 3.78, 6.617999999999999],
    'mentón': [5.93, 4.612, 2.8989999999999996],
    'mercaderes': [4.638, 5.3, 3.758],
    'mercado': [5.256, 5.737, 6.0120000000000005],
    'mercancía': [4.103, 5.159, 4.898],
    'merced': [3.0010000000000003, 2.32, 2.9939999999999998],
    'merecer': [3.552, 2.682, 4.954],
    'merendar': [6.638999999999999, 6.654, 6.169],
    'merienda': [6.086, 5.8420000000000005, 6.239],
    'merluza': [5.94, 5.971, 5.733],
    'merma': [3.292, 2.457, 2.7769999999999997],
    'mero': [4.2410000000000005, 3.825, 4.08],
    'mes': [4.532, 3.03, 6.779],
    'mesa': [6.395, 6.782, 6.575],
    'meseta': [5.004, 4.671, 4.815],
    'mesilla': [6.187, 5.707999999999999, 5.7379999999999995],
    'mesita': [5.539, 5.64, 5.322],
    'meta': [4.4639999999999995, 4.7780000000000005, 5.8229999999999995],
    'metafísica': [3.3789999999999996, 1.807, 3.405],
    'metal': [4.791, 5.351, 5.859],
    'metamorfosis': [4.114, 4.018, 4.077],
    'meteorología': [5.218999999999999, 3.358, 3.8560000000000003],
    'meter': [4.35, 5.647, 6.485],
    'meterse': [3.6, 4.813, 6.399],
    'metodología': [4.11, 2.12, 3.355],
    'metralleta': [6.42, 5.847, 4.31],
    'metro': [4.177, 5.825, 5.581],
    'metropolitano': [5.489, 3.111, 2.887],
    'metáfora': [4.337, 3.022, 4.593],
    'mezcla': [4.044, 3.801, 5.012],
    'mezclar': [4.427, 5.107, 6.147],
    'mezquita': [6.3389999999999995, 5.813, 4.037],
    'meñique': [6.2139999999999995, 6.343, 4.4510000000000005],
    'miaja': [3.4739999999999998, 3.958, 2.569],
    'micobacterias': [5.285, 3.452, 1.883],
    'microfibrillas': [4.7, 2.8960000000000004, 2.5540000000000003],
    'microorganismos': [4.834, 3.3819999999999997, 3.103],
    'microscopio': [6.69, 6.011, 4.412],
    'miedo': [3.4330000000000003, 4.9719999999999995, 6.2170000000000005],
    'miel': [6.64, 5.401, 5.671],
    'miembro': [3.694, 4.3919999999999995, 5.6339999999999995],
    'mierda': [5.372999999999999, 6.09, 6.694],
    'migas': [5.2620000000000005, 4.962, 5.405],
    'milagro': [3.115, 3.233, 5.5120000000000005],
    'milanés': [4.802, 3.611, 3.9960000000000004],
    'milenio': [5.275, 2.832, 3.127],
    'mili': [6.4510000000000005, 5.605, 6.207999999999999],
    'miliciano': [4.513, 3.553, 2.279],
    'militante': [4.102, 4.029, 3.9760000000000004],
    'militar': [5.48, 6.067, 4.552],
    'militarismo': [4.275, 3.23, 4.011],
    'millas': [5.604, 3.764, 3.804],
    'milímetro': [6.218, 4.966, 4.189],
    'mimetismo': [4.077, 2.965, 3.737],
    'mina': [4.63, 5.388, 4.62],
    'mineral': [4.816, 5.1979999999999995, 5.3629999999999995],
    'minero': [6.095, 5.561, 5.0280000000000005],
    'miniatura': [4.885, 5.64, 5.67],
    'minifalda': [6.403, 6.365, 5.517],
    'ministerio': [4.955, 3.715, 4.874],
    'ministra': [6.229, 3.9130000000000003, 4.949],
    'ministro': [5.6, 5.25, 5.586],
    'minoría': [4.046, 3.0839999999999996, 5.622000000000001],
    'minucias': [3.1060000000000003, 2.4859999999999998, 3.565],
    'minuciosidad': [3.31, 2.7239999999999998, 4.17],
    'minuto': [6.188, 3.28, 6.775],
    'miope': [5.831, 4.99, 5.345],
    'mira': [3.823, 3.7289999999999996, 5.12],
    'mirada': [4.811, 5.3839999999999995, 6.263999999999999],
    'mirador': [4.59, 5.621, 4.187],
    'miran': [4.442, 4.013999999999999, 6.13],
    'mirar': [4.69, 5.118, 6.655],
    'mirarme': [5.307, 4.0089999999999995, 6.172999999999999],
    'mirarse': [4.94, 5.459, 6.117000000000001],
    'mirilla': [5.557, 5.9479999999999995, 5.131],
    'misa': [5.919, 5.461, 4.774],
    'miseria': [3.383, 4.317, 5.127999999999999],
    'misiles': [6.513, 5.957000000000001, 5.257999999999999],
    'misión': [3.963, 4.471, 4.87],
    'misterio': [4.039, 3.855, 5.351],
    'mitad': [4.853, 5.167999999999999, 6.127999999999999],
    'mito': [4.0489999999999995, 3.09, 4.995],
    'mitología': [3.611, 3.5639999999999996, 4.7219999999999995],
    'mobiliario': [4.406000000000001, 4.53, 5.303],
    'mochila': [5.939, 5.825, 6.278],
    'mocos': [6.0089999999999995, 6.0760000000000005, 5.872000000000001],
    'moda': [3.7089999999999996, 5.545, 6.492999999999999],
    'modales': [3.2289999999999996, 4.003, 5.29],
    'modalidad': [2.687, 1.954, 4.378],
    'modelo': [3.948, 4.7780000000000005, 6.032],
    'moderación': [3.198, 2.898, 5.551],
    'modernidad': [3.0469999999999997, 3.841, 5.354],
    'modernismo': [3.8939999999999997, 3.714, 4.3],
    'modernistas': [4.021, 3.9410000000000003, 3.911],
    'modernización': [3.7039999999999997, 2.435, 5.127000000000001],
    'modestia': [3.975, 3.1260000000000003, 5.103],
    'modificación': [3.3960000000000004, 2.271, 4.8580000000000005],
    'modo': [2.481, 2.3680000000000003, 5.568],
    'mofletes': [6.035, 5.944, 5.4079999999999995],
    'molestar': [4.0969999999999995, 4.622, 5.861000000000001],
    'molestia': [3.4419999999999997, 4.35, 5.994],
    'molino': [5.54, 6.098, 5.688],
    'moluscos': [5.029, 5.115, 3.66],
    'molécula': [5.143, 2.557, 3.363],
    'momia': [6.0120000000000005, 5.77, 4.46],
    'mona': [5.497000000000001, 6.143, 5.606],
    'monarca': [5.45, 5.817, 4.955],
    'monarquía': [5.187, 4.163, 4.803],
    'monasterio': [5.744, 6.079, 4.798],
    'moneda': [5.872999999999999, 6.295, 6.218],
    'monitor': [4.441, 5.164, 5.457000000000001],
    'monja': [6.513, 5.961, 6.06],
    'monje': [6.141, 6.146, 4.21],
    'mono': [5.269, 6.562, 6.097],
    'monopolio': [3.8569999999999998, 2.707, 3.44],
    'monotonía': [3.937, 4.064, 5.5489999999999995],
    'monstruo': [4.736000000000001, 5.675, 5.947],
    'montaje': [2.787, 3.2039999999999997, 4.596],
    'montar': [4.021, 4.8660000000000005, 6.071000000000001],
    'montaña': [5.996, 5.122000000000001, 6.371],
    'monte': [5.728, 5.846, 6.252999999999999],
    'montera': [5.957999999999999, 4.927, 2.548],
    'montura': [4.743, 4.824, 2.4659999999999997],
    'montón': [3.342, 5.075, 6.207000000000001],
    'monumento': [5.355, 6.365, 6.232],
    'monólogo': [5.398, 4.71, 4.878],
    'moqueta': [6.147, 5.864, 5.629],
    'mora': [4.835, 6.212999999999999, 4.751],
    'moral': [2.329, 2.0540000000000003, 5.153],
    'moraleja': [4.77, 3.298, 3.525],
    'moralidad': [2.867, 2.474, 4.096],
    'morder': [5.502999999999999, 6.069, 6.079],
    'mordisco': [5.7860000000000005, 6.081, 5.882000000000001],
    'morenos': [5.169, 6.131, 5.726],
    'morfología': [4.235, 2.697, 3.392],
    'moribundo': [5.2410000000000005, 5.22, 4.486000000000001],
    'morir': [6.111000000000001, 5.447, 6.39],
    'morirse': [5.3260000000000005, 4.7589999999999995, 5.978],
    'moro': [5.117, 5.24, 5.728],
    'morro': [4.765, 5.247000000000001, 6.311],
    'mortal': [4.934, 3.97, 6.114],
    'mosaico': [5.5120000000000005, 4.4830000000000005, 4.881],
    'mosca': [6.111000000000001, 6.502000000000001, 5.942],
    'mosqueteros': [5.135, 5.118, 3.91],
    'mosquitos': [5.791, 6.269, 5.763],
    'mostrador': [5.47, 6.106, 6.507000000000001],
    'mostrar': [4.016, 4.177, 6.077999999999999],
    'mostrarse': [3.07, 3.923, 5.058],
    'mote': [4.828, 3.0810000000000004, 5.855],
    'motivaciones': [3.2539999999999996, 2.741, 6.029],
    'motivo': [4.072, 2.799, 5.534],
    'moto': [5.34, 6.898, 6.859],
    'motor': [5.516, 5.652, 5.352],
    'moverse': [3.832, 5.127999999999999, 6.49],
    'movida': [3.181, 4.084, 5.85],
    'movilidad': [3.217, 3.6010000000000004, 3.786],
    'movimiento': [4.08, 5.019, 6.117999999999999],
    'moza': [5.3229999999999995, 5.69, 3.446],
    'mozo': [4.87, 6.059, 5.765],
    'moño': [6.002999999999999, 5.761, 5.431],
    'muchacha': [5.716, 6.32, 4.617],
    'muchacho': [5.331, 5.859, 5.236000000000001],
    'muchedumbre': [5.026, 6.099, 4.127],
    'muda': [4.484, 5.407, 5.046],
    'mudar': [3.3289999999999997, 4.053999999999999, 3.875],
    'mudo': [6.256, 5.011, 5.904],
    'mueble': [4.391, 5.705, 6.26],
    'mueca': [4.917, 5.497000000000001, 4.723],
    'muelle': [5.207000000000001, 6.341, 5.468999999999999],
    'muerta': [5.797000000000001, 5.542999999999999, 6.047999999999999],
    'muerte': [4.0889999999999995, 4.33, 6.5329999999999995],
    'muerto': [5.801, 6.053, 6.081],
    'muestra': [3.194, 3.3, 5.749],
    'muestrario': [4.5, 4.947, 4.081],
    'mujer': [6.546, 6.62, 6.716],
    'mula': [6.167000000000001, 5.446000000000001, 4.774],
    'mulata': [5.938, 5.744, 5.095],
    'mulo': [5.176, 4.703, 3.7960000000000003],
    'multinacional': [4.535, 4.159, 5.4110000000000005],
    'multiplicar': [5.307, 4.154, 6.362],
    'multiplicidad': [3.048, 3.0860000000000003, 3.2960000000000003],
    'multitud': [5.279, 6.3260000000000005, 6.678],
    'mundial': [4.262, 5.169, 6.216],
    'mundo': [5.231, 5.582999999999999, 6.544],
    'municipal': [4.288, 4.9830000000000005, 5.336],
    'municipio': [5.202999999999999, 4.835, 5.0680000000000005],
    'muralla': [5.531000000000001, 5.317, 3.4019999999999997],
    'murciélago': [6.577999999999999, 6.428, 5.922000000000001],
    'murmullo': [5.535, 4.65, 5.564],
    'murmuraciones': [4.217, 4.569, 3.8280000000000003],
    'murmurar': [5.059, 5.127999999999999, 5.62],
    'muro': [5.662999999999999, 6.284, 6.056],
    'museo': [5.585, 6.279, 6.181],
    'musgo': [6.218, 5.859, 5.4510000000000005],
    'musicales': [4.1419999999999995, 5.157, 5.656000000000001],
    'muslo': [5.487, 5.345, 5.428],
    'musulmana': [6.08, 5.232, 4.191],
    'musulmanes': [5.49, 5.397, 4.731],
    'mutación': [4.613, 4.026, 4.322],
    'mutantes': [4.0569999999999995, 3.804, 3.572],
    'mutilación': [4.967, 4.756, 3.7439999999999998],
    'mutilado': [5.066, 5.291, 4.567],
    'mutismo': [4.6530000000000005, 2.766, 2.96],
    'mutua': [3.71, 3.375, 5.571000000000001],
    'muñeco': [5.782, 6.011, 6.45],
    'máquina': [4.246, 5.561, 5.987],
    'mármol': [6.377000000000001, 5.564, 5.372999999999999],
    'mártir': [4.962, 5.024, 4.593],
    'máscara': [4.843999999999999, 6.193, 5.301],
    'mástil': [6.001, 4.581, 3.845],
    'máxima': [3.609, 2.9410000000000003, 4.795],
    'médica': [5.523, 5.477, 4.803],
    'médico': [5.776, 6.278, 6.54],
    'médula': [5.915, 4.745, 5.223],
    'mérito': [3.485, 3.27, 5.182],
    'método': [3.383, 2.483, 5.895],
    'mínimo': [3.3, 2.863, 4.952],
    'mística': [3.958, 3.2539999999999996, 4.452],
    'místico': [3.435, 3.978, 3.92],
    'móvil': [3.9, 4.113, 5.103],
    'músculo': [5.861000000000001, 5.417000000000001, 6.278],
    'música': [4.897, 5.2139999999999995, 6.653],
    'músico': [5.422000000000001, 5.932, 5.8629999999999995],
    'nacidos': [5.167999999999999, 3.366, 6.313],
    'nacimiento': [5.269, 6.372000000000001, 6.082999999999999],
    'nacionalidad': [3.4760000000000004, 2.3409999999999997, 5.494],
    'nacionalismo': [4.645, 3.748, 4.939],
    'nacionalista': [4.828, 3.6289999999999996, 5.2989999999999995],
    'nación': [5.146, 4.0360000000000005, 5.542999999999999],
    'nadar': [6.013999999999999, 5.84, 6.621],
    'naipes': [6.082000000000001, 5.982, 4.454],
    'nalgas': [5.974, 6.5120000000000005, 4.831],
    'naranja': [5.641, 6.051, 6.443],
    'nariz': [6.649, 6.39, 6.497999999999999],
    'narración': [5.537999999999999, 4.418, 4.937],
    'narrador': [5.103, 3.79, 3.918],
    'narrar': [4.596, 4.51, 4.601],
    'narrativa': [4.035, 3.029, 4.31],
    'nata': [5.669, 6.6579999999999995, 6.067],
    'natalidad': [4.495, 3.725, 4.62],
    'nativa': [5.103, 4.553, 5.023],
    'nativo': [4.715, 4.487, 4.41],
    'naturaleza': [3.784, 5.841, 5.892],
    'naturalidad': [2.9330000000000003, 3.04, 5.881],
    'naturalismo': [3.695, 3.307, 4.319],
    'naturalista': [4.5680000000000005, 4.427, 4.249],
    'naufragio': [5.446000000000001, 5.602, 3.363],
    'navaja': [6.692, 6.615, 5.398],
    'nave': [5.256, 5.561, 5.324],
    'navegación': [4.613, 4.706, 4.452],
    'navegar': [5.263999999999999, 6.007999999999999, 6.103],
    'navidad': [5.737, 5.357, 6.178999999999999],
    'navío': [5.542000000000001, 5.287999999999999, 4.89],
    'nazis': [5.272, 5.568, 5.332999999999999],
    'neblina': [5.605, 5.0489999999999995, 4.773],
    'nebulosa': [4.218, 4.046, 3.548],
    'necesidad': [3.937, 3.303, 5.553999999999999],
    'necesitar': [3.676, 3.964, 6.386],
    'negación': [5.609, 5.291, 5.935],
    'negar': [5.095, 4.872, 5.81],
    'negarse': [4.669, 3.8789999999999996, 4.997],
    'negativa': [3.7489999999999997, 3.483, 4.838],
    'negociación': [4.043, 3.409, 5.332999999999999],
    'negociar': [3.25, 3.648, 4.755],
    'negocio': [4.535, 4.446000000000001, 5.985],
    'negra': [4.75, 6.412999999999999, 6.56],
    'negrura': [5.114, 5.729, 4.918],
    'nena': [4.705, 5.249, 3.862],
    'nene': [5.169, 5.949, 5.226],
    'neorrealismo': [3.372, 2.036, 2.316],
    'neptuno': [5.047, 4.997, 3.897],
    'nerviosismo': [4.228, 4.968, 6.175],
    'neuronas': [6.303, 4.9030000000000005, 5.417000000000001],
    'neurosis': [5.042, 2.68, 4.6160000000000005],
    'neutrón': [5.023, 2.334, 2.418],
    'nevada': [5.35, 5.945, 5.197],
    'nevera': [6.303999999999999, 6.234, 6.482],
    'nexo': [3.1919999999999997, 3.352, 4.42],
    'neón': [3.983, 3.34, 2.634],
    'nichos': [5.556, 5.478, 4.857],
    'nido': [5.399, 6.33, 6.005],
    'niebla': [5.525, 6.002000000000001, 5.711],
    'nieta': [6.375, 5.492999999999999, 6.2139999999999995],
    'nieto': [6.231, 4.878, 5.625],
    'nieve': [6.2989999999999995, 6.2860000000000005, 5.436],
    'nitidez': [3.51, 3.216, 3.6689999999999996],
    'nitrógeno': [6.097, 2.133, 2.633],
    'nivel': [3.5780000000000003, 4.254, 6.254],
    'niña': [6.254, 6.316, 6.901],
    'niñez': [4.715, 4.908, 4.633],
    'niño': [6.1770000000000005, 6.39, 6.513],
    'noble': [3.28, 3.7739999999999996, 5.127999999999999],
    'nobleza': [4.271, 4.314, 4.489],
    'noche': [5.814, 5.388999999999999, 6.649],
    'noción': [3.603, 2.2769999999999997, 5.207999999999999],
    'nocturno': [5.16, 4.9030000000000005, 5.5089999999999995],
    'nogal': [6.375, 4.787, 4.445],
    'nombramiento': [3.6860000000000004, 3.259, 5.048],
    'nombrar': [3.542, 3.5010000000000003, 5.3839999999999995],
    'nombre': [4.229, 3.3680000000000003, 6.862],
    'norma': [3.7230000000000003, 3.088, 5.36],
    'normalidad': [2.142, 2.253, 5.71],
    'normativa': [3.503, 2.8289999999999997, 4.006],
    'noroeste': [5.501, 2.6239999999999997, 5.439],
    'norte': [5.968999999999999, 4.9030000000000005, 6.507000000000001],
    'norteamericana': [5.767, 4.823, 5.307],
    'norteamericano': [6.275, 5.406000000000001, 5.811],
    'norteamérica': [6.082000000000001, 5.272, 5.72],
    'nostalgia': [3.7760000000000002, 3.237, 5.18],
    'nota': [3.245, 4.646, 6.902],
    'notable': [4.1930000000000005, 5.127999999999999, 5.593999999999999],
    'notar': [3.6210000000000004, 3.1310000000000002, 6.327999999999999],
    'notario': [5.441, 4.096, 3.688],
    'noticia': [4.813, 4.503, 6.622999999999999],
    'novedad': [3.3739999999999997, 3.477, 5.601],
    'novela': [5.989, 5.874, 5.567],
    'novelista': [5.215, 4.433, 5.053999999999999],
    'novia': [5.837000000000001, 5.66, 6.07],
    'noviazgo': [5.52, 4.672, 5.445],
    'noviembre': [6.666, 3.718, 6.274],
    'novio': [5.327999999999999, 4.794, 6.132999999999999],
    'nubarrones': [5.867000000000001, 6.234, 5.47],
    'nube': [6.001, 6.617999999999999, 5.962000000000001],
    'nuca': [6.3260000000000005, 6.055, 5.471],
    'nudillos': [5.2170000000000005, 5.9, 5.3260000000000005],
    'nudo': [4.772, 5.231, 4.781000000000001],
    'nuera': [6.37, 4.1419999999999995, 3.778],
    'nuez': [5.716, 5.309, 5.061],
    'numero': [5.336, 5.789, 6.718999999999999],
    'nupcias': [5.11, 4.535, 3.134],
    'nutrición': [4.359, 3.78, 5.465],
    'nutrientes': [3.6630000000000003, 2.158, 4.251],
    'náufragos': [5.756, 5.5489999999999995, 4.74],
    'náusea': [5.091, 4.565, 4.4319999999999995],
    'nómina': [5.195, 5.05, 4.1610000000000005],
    'núcleo': [3.909, 3.635, 4.694],
    'número': [5.044, 6.4879999999999995, 6.5089999999999995],
    'obedecer': [4.578, 4.129, 4.843],
    'obediencia': [3.983, 3.802, 5.597],
    'obispo': [6.684, 4.931, 3.5410000000000004],
    'objeción': [2.9389999999999996, 2.853, 4.357],
    'objetividad': [2.83, 1.87, 5.537000000000001],
    'objetivo': [3.4010000000000002, 2.903, 5.904],
    'objeto': [3.464, 5.254, 6.255],
    'obligación': [4.367, 4.248, 6.379],
    'obra': [4.401, 5.649, 6.212999999999999],
    'obrar': [2.9530000000000003, 4.048, 4.1],
    'obrero': [4.974, 6.207000000000001, 6.037999999999999],
    'obsequio': [4.378, 5.534, 4.148],
    'observación': [3.718, 3.873, 6.09],
    'observar': [3.714, 4.336, 6.487],
    'observarse': [3.784, 4.377, 5.332999999999999],
    'observatorio': [4.971, 5.051, 4.362],
    'obsesión': [3.4219999999999997, 4.169, 6.324],
    'obstinación': [3.759, 3.1210000000000004, 4.341],
    'obstáculo': [4.308, 4.669, 5.891],
    'obtención': [3.0239999999999996, 2.3, 4.481],
    'obtener': [3.448, 3.355, 5.434],
    'ocasión': [3.944, 3.14, 5.7860000000000005],
    'occidental': [4.272, 3.699, 5.166],
    'occidente': [4.796, 3.892, 5.4670000000000005],
    'ocio': [4.079, 3.847, 4.837],
    'octubre': [5.886, 3.852, 5.872000000000001],
    'ocultar': [4.813, 4.571000000000001, 5.556],
    'ocultarse': [4.289, 4.313, 4.49],
    'ocupación': [3.859, 3.114, 4.6819999999999995],
    'ocupantes': [4.638999999999999, 5.0680000000000005, 5.78],
    'ocupar': [4.394, 3.487, 5.579],
    'ocuparse': [3.611, 3.154, 6.064],
    'ocurrencia': [2.898, 3.5469999999999997, 5.468],
    'ocurrir': [2.7460000000000004, 3.072, 6.031000000000001],
    'océano': [5.501, 6.434, 5.396],
    'odiar': [3.53, 4.0360000000000005, 6.093],
    'odio': [4.553999999999999, 3.938, 5.233],
    'odisea': [2.9389999999999996, 2.8689999999999998, 3.553],
    'oeste': [5.457999999999999, 4.329, 5.617999999999999],
    'ofensiva': [3.685, 3.435, 3.258],
    'oficial': [4.515, 4.681, 4.223],
    'oficina': [5.2410000000000005, 6.042999999999999, 5.653],
    'oficio': [4.525, 5.111000000000001, 5.065],
    'ofrecer': [4.387, 3.846, 5.167999999999999],
    'ojales': [5.787000000000001, 5.843, 5.1770000000000005],
    'ojeada': [4.064, 4.4639999999999995, 5.254],
    'ojeras': [6.136, 5.612, 6.136],
    'ojo': [5.937, 6.309, 6.813],
    'ola': [5.067, 6.122000000000001, 6.624],
    'oleadas': [4.03, 4.349, 5.235],
    'oleaje': [5.688, 5.989, 4.843999999999999],
    'oler': [5.325, 4.01, 6.529],
    'olfato': [5.415, 3.9019999999999997, 5.377999999999999],
    'olivares': [5.832999999999999, 4.3, 3.926],
    'olivo': [6.667999999999999, 4.981, 4.043],
    'olla': [5.962000000000001, 6.186, 5.581],
    'olor': [4.5, 4.837, 5.8389999999999995],
    'olvidar': [3.9010000000000002, 3.589, 5.851],
    'olvidarse': [4.2219999999999995, 3.3960000000000004, 6.602],
    'olvido': [3.845, 3.969, 6.01],
    'ombligo': [6.013, 6.415, 5.917999999999999],
    'onda': [4.607, 4.581, 6.289],
    'opción': [3.642, 3.852, 5.5489999999999995],
    'operación': [4.381, 4.971, 5.502999999999999],
    'operar': [4.2410000000000005, 4.314, 5.011],
    'opinar': [4.327, 3.752, 5.7379999999999995],
    'opinión': [3.852, 3.342, 6.196000000000001],
    'opio': [6.096, 3.185, 3.466],
    'oponerse': [4.398, 3.802, 5.042],
    'oportunidad': [3.839, 2.812, 5.881],
    'oposición': [3.8280000000000003, 3.127, 5.486000000000001],
    'opresión': [3.687, 4.058, 4.0280000000000005],
    'optar': [3.195, 2.8369999999999997, 5.011],
    'optimismo': [3.625, 4.252, 5.532],
    'oración': [4.088, 4.156000000000001, 4.535],
    'orbital': [3.9789999999999996, 3.5239999999999996, 3.64],
    'orden': [3.741, 4.255, 5.818],
    'ordenación': [3.197, 4.505, 4.8389999999999995],
    'ordenador': [5.9079999999999995, 6.0089999999999995, 6.4670000000000005],
    'ordenanzas': [3.236, 3.2769999999999997, 3.676],
    'ordenar': [4.258, 5.086, 6.52],
    'oreja': [5.9910000000000005, 6.4510000000000005, 6.476],
    'organismo': [3.713, 4.748, 5.002],
    'organización': [3.778, 3.888, 6.545],
    'organizar': [4.043, 3.924, 6.085],
    'orgasmo': [5.711, 4.368, 6.077000000000001],
    'orgullo': [5.2170000000000005, 4.599, 6.263],
    'orgía': [4.905, 5.553, 4.783],
    'orientación': [3.1319999999999997, 2.639, 5.008],
    'oriental': [4.452, 5.475, 4.74],
    'orientarse': [4.1339999999999995, 3.114, 5.169],
    'oriente': [4.601, 4.349, 4.729],
    'origen': [3.463, 4.061, 6.254],
    'origina': [3.3710000000000004, 2.886, 4.416],
    'originalidad': [4.081, 3.3569999999999998, 5.528],
    'orilla': [5.414, 6.031000000000001, 5.9479999999999995],
    'orina': [6.72, 6.456, 5.082],
    'orinar': [6.5920000000000005, 6.416, 5.734],
    'oro': [6.045, 5.556, 5.224],
    'orquesta': [5.928, 6.046, 5.11],
    'ortografía': [5.702999999999999, 4.238, 4.711],
    'osadía': [3.84, 3.1439999999999997, 4.506],
    'oscilación': [3.648, 4.126, 3.68],
    'oscilar': [3.468, 3.4210000000000003, 5.209],
    'oscurecer': [4.573, 5.382999999999999, 5.074],
    'oscuridad': [5.341, 6.021, 6.653],
    'oso': [6.382999999999999, 5.3420000000000005, 5.517],
    'ostras': [6.4239999999999995, 5.242999999999999, 5.4110000000000005],
    'otoño': [5.73, 5.974, 5.734],
    'ovarios': [6.404, 5.223, 5.7139999999999995],
    'oveja': [6.207000000000001, 6.322, 6.062],
    'oxidación': [5.084, 3.4130000000000003, 4.406000000000001],
    'oxígeno': [6.104, 3.5069999999999997, 5.39],
    'oyentes': [4.677, 4.8180000000000005, 4.55],
    'oídas': [3.4939999999999998, 2.94, 4.984],
    'oído': [5.978, 5.121, 6.494],
    'oír': [5.172000000000001, 4.9110000000000005, 6.6610000000000005],
    'oírse': [5.303, 4.305, 5.992000000000001],
    'pabellón': [5.38, 5.752999999999999, 5.815],
    'paciente': [4.329, 5.292999999999999, 4.7],
    'pacificación': [3.8539999999999996, 3.3139999999999996, 4.205],
    'pacifismo': [3.892, 3.176, 5.641],
    'pactar': [4.147, 3.906, 5.274],
    'pacto': [3.505, 3.3360000000000003, 4.743],
    'padecer': [3.6630000000000003, 3.455, 4.618],
    'padre': [6.079, 6.787999999999999, 6.568],
    'padrino': [5.749, 5.359, 5.117],
    'paella': [5.917000000000001, 5.8229999999999995, 6.109],
    'paga': [4.726, 4.771, 5.343],
    'pagar': [5.119, 5.152, 6.202000000000001],
    'pago': [4.1530000000000005, 4.261, 5.857],
    'paisaje': [4.431, 5.8870000000000005, 5.23],
    'paisano': [4.58, 3.9219999999999997, 4.9030000000000005],
    'paja': [5.059, 5.818, 5.367000000000001],
    'pajar': [6.348, 5.898, 4.695],
    'pajarito': [5.2139999999999995, 5.307, 6.496],
    'pala': [5.479, 6.263, 4.513999999999999],
    'palabra': [4.228, 5.2010000000000005, 6.685],
    'palabrotas': [3.765, 4.3580000000000005, 5.218],
    'palacio': [5.7170000000000005, 5.9, 5.186],
    'paladar': [5.47, 5.113, 5.809],
    'palanca': [5.49, 4.613, 4.88],
    'palestinos': [6.072, 3.545, 5.145],
    'paleta': [4.883, 5.856, 4.894],
    'paletilla': [4.073, 4.794, 3.623],
    'palillo': [5.832000000000001, 6.425, 5.801],
    'paliza': [4.9910000000000005, 5.61, 5.044],
    'palma': [4.05, 6.417000000000001, 5.332999999999999],
    'palmeras': [6.235, 5.356, 5.067],
    'palmo': [4.085, 3.7680000000000002, 4.386],
    'palo': [5.265, 5.184, 5.456],
    'paloma': [6.4239999999999995, 6.393, 6.183],
    'palomares': [5.043, 5.1979999999999995, 3.845],
    'palpar': [4.572, 5.0889999999999995, 4.65],
    'pana': [5.1370000000000005, 5.099, 4.811],
    'panadero': [6.535, 6.393, 5.457999999999999],
    'pandilla': [4.6930000000000005, 5.553999999999999, 5.404],
    'panorama': [4.1339999999999995, 3.945, 5.05],
    'panorámica': [3.736, 5.197, 4.808],
    'pantalla': [4.928999999999999, 5.551, 6.242000000000001],
    'pantalón': [6.343, 6.37, 6.267],
    'pantano': [5.709, 6.101, 4.999],
    'pantera': [5.996, 5.851, 5.56],
    'panteón': [5.432, 5.81, 4.837],
    'panza': [5.053, 6.0489999999999995, 4.779],
    'papa': [5.593, 6.254, 6.294],
    'papel': [5.795, 6.395, 6.672999999999999],
    'papelera': [6.162999999999999, 6.789, 6.364],
    'papá': [6.289, 6.18, 6.7589999999999995],
    'paquete': [4.762, 6.281000000000001, 5.987],
    'par': [4.7589999999999995, 4.282, 6.279],
    'parabrisas': [6.501, 5.472, 5.327000000000001],
    'paracaídas': [6.452999999999999, 4.908, 3.565],
    'parada': [4.493, 4.379, 6.037999999999999],
    'paradigma': [4.129, 1.923, 3.866],
    'parado': [3.701, 5.172000000000001, 6.09],
    'paradoja': [3.8789999999999996, 2.2640000000000002, 3.965],
    'paraguas': [5.989, 5.9479999999999995, 6.162000000000001],
    'parajes': [4.791, 5.324, 4.176],
    'paralela': [4.473, 5.231, 5.287999999999999],
    'paralelo': [4.208, 3.764, 4.419],
    'parar': [4.261, 4.41, 6.68],
    'pararse': [4.6530000000000005, 4.55, 6.0],
    'paraíso': [4.368, 6.229, 5.855],
    'parcela': [5.4110000000000005, 5.57, 5.477],
    'parche': [5.114, 5.928999999999999, 5.696000000000001],
    'parecer': [3.239, 2.45, 5.942],
    'parecerse': [3.6180000000000003, 3.3169999999999997, 5.974],
    'parecido': [3.847, 3.285, 6.356],
    'pared': [6.252999999999999, 5.83, 6.271],
    'pareja': [5.001, 6.348, 6.803],
    'parentesco': [4.271, 4.3260000000000005, 4.388],
    'pariente': [4.617, 5.24, 4.902],
    'parir': [5.246, 5.052, 3.787],
    'paro': [3.965, 3.4410000000000003, 5.65],
    'parodia': [4.5969999999999995, 2.83, 4.133],
    'parpadeo': [5.957999999999999, 5.006, 5.497999999999999],
    'parque': [6.057, 6.557, 6.311],
    'parroquia': [5.611000000000001, 5.367999999999999, 5.079],
    'parroquiano': [4.459, 2.8560000000000003, 2.543],
    'parsimonia': [3.5389999999999997, 3.508, 4.345],
    'parte': [2.349, 3.5039999999999996, 5.69],
    'participación': [4.178999999999999, 3.6689999999999996, 5.686],
    'participantes': [4.543, 5.156000000000001, 4.784],
    'participar': [3.7569999999999997, 4.5089999999999995, 6.324],
    'particularidad': [3.4819999999999998, 2.005, 4.213],
    'partida': [3.403, 4.596, 6.115],
    'partidarios': [3.735, 3.503, 4.65],
    'partidista': [3.98, 2.151, 3.695],
    'partido': [3.5860000000000003, 5.626, 6.042999999999999],
    'partir': [3.502, 4.755, 5.807],
    'parto': [5.058, 5.8389999999999995, 5.307],
    'partícula': [4.254, 3.45, 3.682],
    'parábola': [4.635, 5.045, 4.574],
    'parálisis': [5.0969999999999995, 5.162000000000001, 4.82],
    'parámetros': [3.6510000000000002, 2.5869999999999997, 4.8180000000000005],
    'parásitos': [5.113, 4.258, 5.507999999999999],
    'paréntesis': [5.1739999999999995, 5.101, 5.376],
    'pasadizos': [5.705, 5.305, 4.401],
    'pasado': [3.37, 3.397, 6.55],
    'pasaje': [4.272, 4.454, 5.027],
    'pasajera': [4.088, 4.882, 5.518],
    'pasajero': [4.176, 3.8360000000000003, 3.4810000000000003],
    'pasaporte': [5.5920000000000005, 5.912000000000001, 4.853],
    'pasar': [3.503, 3.843, 5.847],
    'pasarse': [2.903, 4.368, 6.178],
    'pasas': [5.127999999999999, 5.4239999999999995, 5.53],
    'pasatiempo': [5.164, 4.895, 6.01],
    'pascua': [4.915, 4.386, 3.241],
    'pascuas': [4.283, 3.063, 4.7010000000000005],
    'pase': [3.361, 4.779, 5.348],
    'paseante': [5.059, 5.584, 2.563],
    'pasear': [4.879, 5.3420000000000005, 6.754],
    'pasearse': [4.873, 4.7139999999999995, 5.755],
    'paseo': [4.465, 5.64, 6.766],
    'pasillo': [5.524, 6.274, 6.723],
    'pasividad': [3.282, 3.9819999999999998, 4.835],
    'pasión': [3.44, 5.176, 5.888999999999999],
    'pasmo': [3.799, 3.7289999999999996, 3.512],
    'paso': [3.137, 4.583, 6.268],
    'pasta': [4.072, 5.652, 5.699],
    'pastel': [5.859, 6.63, 6.437],
    'pastilla': [5.3839999999999995, 6.291, 6.5120000000000005],
    'pasto': [4.7, 5.4670000000000005, 3.855],
    'pastor': [5.301, 5.648, 5.197],
    'pata': [5.1770000000000005, 5.912999999999999, 6.442],
    'patata': [6.192, 6.313, 6.781000000000001],
    'paternidad': [4.779, 5.297000000000001, 4.995],
    'patio': [6.091, 6.772, 5.898],
    'pato': [6.249, 6.5729999999999995, 5.593],
    'patria': [4.988, 3.95, 4.494],
    'patrimonio': [4.729, 3.259, 5.207999999999999],
    'patrocinio': [4.272, 2.125, 3.508],
    'patrona': [4.965, 4.939, 2.333],
    'patrulla': [4.997, 4.861000000000001, 5.473],
    'patrón': [4.313, 4.871, 5.335],
    'pautas': [3.114, 2.707, 4.499],
    'pavimento': [5.5489999999999995, 4.976, 5.072],
    'pavo': [6.1339999999999995, 4.658, 4.706],
    'pavor': [4.255, 3.11, 4.31],
    'payaso': [5.972, 6.331, 6.129],
    'paz': [4.566, 3.695, 6.274],
    'país': [5.484, 5.188, 6.309],
    'paño': [5.347, 4.934, 6.277],
    'pañuelo': [6.0760000000000005, 6.085, 6.287999999999999],
    'pecado': [3.87, 3.333, 5.372000000000001],
    'pecadores': [3.7460000000000004, 2.645, 3.502],
    'pecar': [3.0, 3.264, 5.412000000000001],
    'pecas': [6.075, 6.196000000000001, 4.927],
    'pecho': [6.087999999999999, 6.256, 6.132000000000001],
    'peculiaridad': [
        4.218999999999999, 2.9139999999999997, 3.7489999999999997
    ],
    'pedagogía': [4.614, 3.6039999999999996, 4.808],
    'pedazo': [2.87, 3.821, 4.846],
    'pedido': [4.247, 3.7310000000000003, 5.797000000000001],
    'pedir': [3.66, 4.497, 5.955],
    'pegadas': [4.192, 3.8139999999999996, 4.793],
    'pegar': [4.147, 5.312, 5.104],
    'peine': [6.665, 6.2410000000000005, 6.444],
    'peldaños': [6.225, 5.672999999999999, 6.06],
    'pelea': [5.3, 5.556, 6.361000000000001],
    'pelear': [5.044, 5.535, 6.269],
    'peligro': [3.802, 4.471, 5.769],
    'peligrosidad': [3.778, 4.284, 4.178],
    'pelota': [5.92, 6.211, 6.519],
    'pelotazo': [4.814, 5.847, 6.2010000000000005],
    'peluquero': [6.193, 6.35, 6.5489999999999995],
    'peluquería': [6.229, 5.88, 5.496],
    'película': [5.571000000000001, 6.369, 6.5920000000000005],
    'pena': [4.415, 4.345, 5.452000000000001],
    'pendiente': [3.678, 5.829, 5.812],
    'pene': [6.566, 6.414, 4.507],
    'penetración': [4.221, 5.765, 5.022],
    'penetrar': [4.124, 5.374, 5.335],
    'penitencia': [4.449, 4.14, 4.77],
    'pensador': [4.343, 4.482, 5.537999999999999],
    'pensamiento': [3.0, 3.022, 6.257000000000001],
    'pensar': [3.298, 4.668, 6.468999999999999],
    'pensarse': [3.6260000000000003, 3.26, 5.053999999999999],
    'pensión': [5.5089999999999995, 4.624, 5.125],
    'penumbra': [4.545, 4.8180000000000005, 3.502],
    'península': [6.018, 5.425, 5.096],
    'pepita': [5.025, 5.0889999999999995, 5.012],
    'pera': [6.013999999999999, 5.547999999999999, 5.876],
    'percance': [3.812, 3.534, 3.755],
    'percepción': [3.4410000000000003, 2.969, 6.055],
    'percha': [6.36, 6.614, 6.31],
    'percibir': [4.1530000000000005, 3.2969999999999997, 5.367999999999999],
    'perder': [3.989, 4.459, 6.659],
    'perderse': [3.909, 4.022, 5.803],
    'perdición': [3.505, 2.888, 4.39],
    'perdonar': [4.922, 3.74, 6.532],
    'perdón': [4.3389999999999995, 3.753, 5.452000000000001],
    'peregrinación': [4.492, 4.376, 4.31],
    'peregrino': [5.899, 5.495, 4.53],
    'pereza': [5.209, 4.322, 5.85],
    'perfección': [3.8369999999999997, 2.3369999999999997, 5.194],
    'perfil': [4.062, 4.295, 5.4079999999999995],
    'perfume': [5.4670000000000005, 6.027, 6.091],
    'pericia': [3.111, 2.715, 3.5810000000000004],
    'periferia': [3.995, 3.5469999999999997, 4.787],
    'periodismo': [5.763999999999999, 3.951, 5.511],
    'peripecia': [3.642, 3.096, 4.178],
    'perito': [5.301, 4.217, 4.431],
    'periódico': [5.861000000000001, 5.869, 6.156000000000001],
    'perjuicio': [3.435, 2.909, 4.3580000000000005],
    'perlas': [5.872999999999999, 5.888, 4.99],
    'permanecer': [3.194, 3.491, 4.303999999999999],
    'permeabilidad': [4.715, 3.5669999999999997, 4.723],
    'permiso': [4.043, 3.321, 6.4510000000000005],
    'permitir': [3.485, 2.772, 5.018],
    'permitirse': [3.764, 3.5810000000000004, 5.507000000000001],
    'perplejidad': [3.4939999999999998, 3.0069999999999997, 2.897],
    'perro': [6.443, 6.5729999999999995, 6.638999999999999],
    'persa': [4.78, 3.234, 4.349],
    'persecución': [4.781000000000001, 5.471, 5.626],
    'perseguir': [4.186, 4.864, 5.67],
    'perseverancia': [3.531, 2.279, 3.7489999999999997],
    'persiana': [6.284, 6.171, 5.787999999999999],
    'persistencia': [4.446000000000001, 3.082, 5.01],
    'persona': [5.716, 6.296, 7.0],
    'personal': [3.2510000000000003, 3.536, 5.987],
    'personalidad': [3.326, 3.625, 6.402],
    'perspectiva': [3.023, 3.095, 5.322],
    'persuasión': [3.8539999999999996, 2.708, 4.266],
    'pertenecer': [3.2439999999999998, 2.903, 4.585],
    'pertenencia': [3.988, 3.785, 4.275],
    'perversa': [4.334, 3.8080000000000003, 4.194],
    'perversidad': [4.463, 2.293, 3.79],
    'perversión': [3.1310000000000002, 4.061, 4.953],
    'pervivencia': [2.8789999999999996, 2.833, 2.707],
    'período': [3.95, 4.07, 5.186],
    'pesa': [5.305, 5.36, 6.207999999999999],
    'pesadez': [4.138, 3.926, 4.949],
    'pesadilla': [3.947, 5.409, 6.496],
    'pesadumbre': [4.247, 3.275, 3.7289999999999996],
    'pesar': [3.553, 4.541, 5.454],
    'pesca': [5.638, 5.324, 5.816],
    'pescado': [5.747999999999999, 6.901, 6.557],
    'pescador': [6.157, 5.735, 5.492999999999999],
    'pescar': [4.967, 5.649, 5.115],
    'pescuezo': [5.604, 5.372999999999999, 4.4910000000000005],
    'peseta': [6.291, 6.513, 6.5520000000000005],
    'pesimismo': [4.083, 4.037, 5.132000000000001],
    'peso': [4.363, 4.825, 6.497999999999999],
    'pesquisas': [3.367, 2.415, 2.261],
    'pestañas': [6.275, 4.538, 5.085],
    'pestañear': [6.2010000000000005, 5.903, 5.165],
    'petaca': [5.692, 5.976, 3.957],
    'petate': [5.524, 5.403, 3.3680000000000003],
    'petición': [4.223, 3.908, 4.624],
    'petróleo': [6.272, 5.409, 5.364],
    'pez': [5.1739999999999995, 6.77, 5.169],
    'pezones': [5.864, 5.979, 5.165],
    'peña': [4.369, 4.684, 4.99],
    'peón': [4.2410000000000005, 5.765, 4.7010000000000005],
    'piano': [6.577000000000001, 6.565, 5.861000000000001],
    'picaporte': [6.461, 6.202999999999999, 4.8469999999999995],
    'picardía': [3.8110000000000004, 3.432, 4.301],
    'picaresca': [3.574, 3.1060000000000003, 3.367],
    'pico': [4.198, 5.944, 5.666],
    'pie': [6.625, 5.102, 6.419],
    'piedra': [6.2989999999999995, 6.237, 6.421],
    'piel': [5.295, 6.465, 6.231],
    'pierna': [6.29, 5.867999999999999, 6.484],
    'pieza': [3.405, 4.6339999999999995, 5.231],
    'pila': [5.23, 6.028, 6.364],
    'pilares': [4.518, 4.486000000000001, 3.637],
    'piloto': [5.407, 5.388999999999999, 5.188],
    'pinar': [5.507000000000001, 4.583, 4.378],
    'pincel': [6.346, 5.86, 5.2989999999999995],
    'pincelada': [4.688, 5.146, 4.125],
    'pino': [6.212999999999999, 6.521, 6.057],
    'pinta': [3.952, 4.01, 5.251],
    'pintada': [4.7010000000000005, 5.662000000000001, 5.847],
    'pintar': [4.86, 5.78, 6.236000000000001],
    'pintor': [5.957999999999999, 6.062, 5.877999999999999],
    'pintura': [4.45, 6.26, 5.027],
    'piojos': [6.14, 4.7410000000000005, 4.521],
    'pioneros': [4.461, 3.304, 3.799],
    'pipa': [5.247000000000001, 6.271, 5.465],
    'pirata': [5.898, 6.152, 5.57],
    'pirueta': [4.875, 5.765, 4.602],
    'pirámide': [5.805, 5.7589999999999995, 5.078],
    'pis': [5.972, 5.9670000000000005, 5.226],
    'pisadas': [4.919, 5.611000000000001, 5.564],
    'pisar': [4.978, 5.422000000000001, 6.649],
    'piscina': [6.522, 6.54, 5.9270000000000005],
    'piso': [4.623, 5.952000000000001, 6.659],
    'pista': [3.423, 5.1080000000000005, 5.7139999999999995],
    'pistola': [5.7620000000000005, 6.011, 4.7780000000000005],
    'pitillo': [6.085, 6.3629999999999995, 6.442],
    'pito': [5.36, 5.585, 5.048],
    'pizarra': [6.242000000000001, 5.976, 6.314],
    'placa': [3.404, 5.207000000000001, 5.48],
    'placer': [3.715, 5.002, 5.291],
    'placidez': [3.763, 4.081, 3.093],
    'plaga': [4.507, 5.4110000000000005, 5.33],
    'plan': [3.5589999999999997, 3.2289999999999996, 5.899],
    'plancha': [5.456, 5.6579999999999995, 6.622999999999999],
    'planeta': [5.8420000000000005, 5.773, 4.715],
    'planetario': [5.459, 5.4110000000000005, 3.575],
    'planificación': [3.571, 3.806, 4.666],
    'plano': [3.747, 4.717, 4.419],
    'planta': [5.11, 5.946000000000001, 6.6],
    'planteamiento': [2.637, 2.215, 4.7589999999999995],
    'plantear': [2.966, 2.593, 5.452999999999999],
    'plantearse': [3.745, 2.1630000000000003, 5.252999999999999],
    'plata': [6.145, 5.1579999999999995, 5.001],
    'plataforma': [4.274, 4.814, 4.989],
    'platillo': [4.387, 5.909, 5.53],
    'platino': [4.415, 3.6660000000000004, 4.362],
    'playa': [6.377000000000001, 6.439, 6.377999999999999],
    'plaza': [5.6339999999999995, 5.827999999999999, 6.443],
    'plazo': [4.261, 3.6719999999999997, 5.53],
    'pleito': [4.96, 3.799, 3.699],
    'plenitud': [2.891, 2.781, 4.9030000000000005],
    'pleno': [3.085, 3.679, 4.737],
    'pliego': [4.511, 3.654, 3.63],
    'pliegue': [4.731, 4.438, 3.5660000000000003],
    'plomo': [5.452999999999999, 4.35, 5.597],
    'pluma': [4.821000000000001, 5.957999999999999, 5.805],
    'plural': [4.33, 2.9130000000000003, 5.4479999999999995],
    'pluralidad': [3.463, 2.892, 4.197],
    'plástico': [5.557, 5.9670000000000005, 6.127999999999999],
    'plátanos': [6.646, 7.0, 6.587000000000001],
    'población': [4.412, 4.91, 5.773],
    'poblado': [5.452000000000001, 5.909, 4.894],
    'pobre': [4.837, 5.669, 6.242999999999999],
    'pobreza': [3.8689999999999998, 5.492000000000001, 6.5889999999999995],
    'poder': [3.361, 3.611, 5.2139999999999995],
    'poderosa': [4.165, 4.138999999999999, 4.164],
    'poderoso': [3.52, 4.324, 5.769],
    'poderío': [3.5639999999999996, 3.3789999999999996, 4.909],
    'podredumbre': [4.7, 3.821, 3.242],
    'poema': [5.329, 5.502000000000001, 4.338],
    'poesía': [5.986000000000001, 5.569, 5.513],
    'poeta': [5.645, 5.6370000000000005, 6.301],
    'polen': [6.002000000000001, 4.8069999999999995, 4.274],
    'policía': [5.916, 6.861000000000001, 6.112],
    'polillas': [6.193, 4.497, 3.5389999999999997],
    'polisacárido': [5.882999999999999, 2.648, 3.773],
    'polla': [5.872999999999999, 5.692, 4.917],
    'pollo': [6.4910000000000005, 6.505, 6.362],
    'polo': [4.084, 5.132000000000001, 5.61],
    'polvo': [4.572, 5.8389999999999995, 6.367000000000001],
    'polémica': [3.94, 4.282, 5.356],
    'política': [3.752, 3.3569999999999998, 4.071000000000001],
    'político': [5.2589999999999995, 5.377999999999999, 6.1370000000000005],
    'pompa': [3.91, 5.702999999999999, 3.2710000000000004],
    'poner': [4.016, 4.455, 6.135],
    'poniente': [4.364, 3.157, 3.875],
    'popa': [5.461, 4.768, 2.8369999999999997],
    'popularidad': [4.284, 3.6069999999999998, 4.533],
    'porcelana': [5.906000000000001, 5.7620000000000005, 5.273],
    'porcentaje': [4.81, 3.466, 5.737],
    'porche': [5.178999999999999, 5.737, 3.864],
    'pormenores': [3.569, 2.24, 3.18],
    'porno': [4.8919999999999995, 4.946000000000001, 5.336],
    'pornografía': [5.332999999999999, 5.784, 5.626],
    'porquería': [3.58, 5.722, 5.37],
    'porro': [5.69, 6.257000000000001, 5.872999999999999],
    'portada': [4.716, 5.256, 6.085],
    'portador': [3.485, 3.253, 3.883],
    'portal': [6.004, 5.572, 5.968],
    'portavoz': [5.57, 3.5180000000000002, 4.53],
    'portazo': [5.64, 5.736000000000001, 5.829],
    'porte': [3.612, 2.576, 2.5639999999999996],
    'portero': [5.314, 6.169, 6.169],
    'portería': [5.069, 5.59, 5.7620000000000005],
    'portugués': [5.749, 4.393, 4.577],
    'portón': [4.853, 5.526, 4.7219999999999995],
    'porvenir': [3.928, 3.627, 5.535],
    'posada': [5.48, 5.789, 4.226],
    'poseer': [3.3339999999999996, 3.699, 4.891],
    'posesión': [3.455, 3.75, 4.801],
    'posguerra': [5.492999999999999, 3.73, 4.489],
    'posibilidad': [3.2460000000000004, 2.96, 6.459],
    'posición': [3.3280000000000003, 3.3339999999999996, 5.671],
    'postal': [6.026, 6.51, 6.402],
    'postes': [5.027, 5.296, 4.77],
    'postre': [5.42, 6.261, 6.159],
    'postrimerías': [2.428, 2.3569999999999998, 1.556],
    'postulado': [3.258, 2.64, 2.8510000000000004],
    'postura': [3.855, 4.647, 5.5889999999999995],
    'potasio': [5.632000000000001, 2.7289999999999996, 4.019],
    'potencia': [3.2880000000000003, 3.487, 3.781],
    'potencial': [2.7039999999999997, 1.8559999999999999, 4.315],
    'potencialidad': [3.0380000000000003, 2.597, 3.3289999999999997],
    'pozo': [6.002000000000001, 6.169, 5.268],
    'practicar': [3.7030000000000003, 4.104, 6.388],
    'pradera': [6.051, 6.457000000000001, 5.409],
    'prado': [5.638999999999999, 6.16, 5.294],
    'pragmática': [3.398, 1.6480000000000001, 2.823],
    'precariedad': [3.739, 3.134, 3.1519999999999997],
    'precaución': [3.5410000000000004, 3.5269999999999997, 4.98],
    'precedente': [3.415, 3.2569999999999997, 4.253],
    'precepto': [3.523, 2.371, 3.037],
    'precio': [4.356, 4.253, 6.2829999999999995],
    'precipicio': [4.954, 5.608, 4.61],
    'precipitación': [4.021, 3.2289999999999996, 4.633],
    'precisar': [3.372, 2.873, 4.486000000000001],
    'precisión': [3.787, 3.167, 5.206],
    'precursor': [3.8789999999999996, 2.479, 4.796],
    'predecir': [3.528, 2.31, 4.09],
    'predicción': [3.4730000000000003, 3.057, 4.886],
    'predominio': [3.322, 2.426, 5.409],
    'preferencia': [3.216, 2.611, 4.945],
    'preferir': [3.3689999999999998, 3.985, 5.586],
    'pregunta': [5.218, 5.266, 6.362],
    'preguntar': [4.821000000000001, 3.7, 5.792000000000001],
    'preguntarse': [4.614, 3.807, 6.396],
    'prejuicio': [3.3560000000000003, 2.8939999999999997, 4.8469999999999995],
    'premio': [5.3660000000000005, 5.684, 6.254],
    'premisa': [3.872, 1.9069999999999998, 3.931],
    'premonición': [3.568, 2.427, 3.9939999999999998],
    'prenda': [3.805, 5.657, 6.031000000000001],
    'preocupación': [3.78, 3.835, 6.2989999999999995],
    'preocuparse': [4.328, 5.032, 6.445],
    'preparación': [3.424, 3.853, 6.331],
    'preparados': [2.8989999999999996, 3.003, 5.711],
    'preparar': [3.4730000000000003, 3.427, 5.818],
    'prepararse': [4.038, 3.696, 5.954],
    'preparativos': [3.892, 4.051, 4.396],
    'preponderancia': [3.412, 2.358, 3.5839999999999996],
    'presa': [4.21, 5.101, 5.662999999999999],
    'presagio': [4.016, 2.242, 3.093],
    'presencia': [3.3, 2.96, 5.914],
    'presenciar': [3.843, 4.221, 5.0],
    'presentación': [3.33, 4.5969999999999995, 5.982],
    'presentar': [3.674, 4.474, 6.305],
    'presentarse': [4.013, 3.785, 5.992000000000001],
    'presente': [3.717, 3.5439999999999996, 6.535],
    'presentimiento': [3.8789999999999996, 3.545, 6.0729999999999995],
    'preservar': [4.573, 3.0580000000000003, 4.857],
    'preservativo': [6.205, 5.959, 5.968999999999999],
    'presidencia': [3.9389999999999996, 3.264, 3.0660000000000003],
    'presidente': [5.591, 4.59, 6.251],
    'presión': [3.549, 3.6289999999999996, 4.718],
    'preso': [5.537000000000001, 5.862, 5.439],
    'prestar': [4.064, 3.6910000000000003, 6.446000000000001],
    'prestigio': [4.341, 3.108, 4.9639999999999995],
    'presumir': [4.745, 4.595, 5.971],
    'presunción': [3.2689999999999997, 2.35, 3.286],
    'pretender': [3.596, 3.29, 5.047],
    'pretendiente': [4.792, 4.909, 4.631],
    'pretensión': [3.7289999999999996, 2.395, 5.433],
    'pretexto': [3.758, 3.09, 4.27],
    'pretérito': [4.256, 2.407, 3.444],
    'prevención': [3.517, 3.1860000000000004, 5.683],
    'prevenir': [3.85, 3.0660000000000003, 5.305],
    'prever': [3.219, 2.69, 4.529],
    'previsiones': [3.1919999999999997, 2.951, 3.866],
    'prima': [4.535, 4.92, 5.199],
    'primavera': [5.672000000000001, 5.727, 6.797999999999999],
    'primo': [5.425, 3.51, 6.7139999999999995],
    'princesa': [5.928999999999999, 5.746, 4.769],
    'principio': [3.872, 2.908, 5.276],
    'prior': [4.552, 2.938, 2.13],
    'prioridad': [3.225, 3.156, 4.54],
    'prisa': [4.41, 4.602, 6.55],
    'prisionera': [4.913, 5.545, 5.033],
    'prisión': [5.773, 5.622999999999999, 5.539],
    'prismáticos': [6.541, 3.24, 3.86],
    'privación': [3.8289999999999997, 3.675, 4.763999999999999],
    'privilegiado': [4.434, 4.0089999999999995, 5.228],
    'privilegio': [3.972, 2.81, 5.024],
    'proa': [5.715, 4.791, 2.863],
    'probar': [3.176, 4.485, 5.676],
    'problema': [2.937, 4.0169999999999995, 6.519],
    'problemática': [3.98, 2.6660000000000004, 4.737],
    'proceder': [2.998, 1.864, 4.7589999999999995],
    'procedimiento': [3.9339999999999997, 2.612, 5.189],
    'procesado': [4.348, 3.8739999999999997, 4.371],
    'procesión': [4.811, 5.712999999999999, 5.46],
    'proceso': [2.8369999999999997, 2.696, 5.496],
    'proclamar': [3.302, 3.088, 4.218],
    'procurar': [3.573, 2.417, 5.331],
    'prodigio': [3.484, 3.66, 5.176],
    'producción': [4.368, 3.5669999999999997, 5.771],
    'producir': [3.217, 3.568, 6.155],
    'producirse': [3.097, 2.6660000000000004, 5.617000000000001],
    'producto': [3.265, 4.195, 5.926],
    'productor': [3.889, 4.317, 4.977],
    'profano': [4.188, 3.367, 4.255],
    'profecía': [4.154, 2.383, 4.3660000000000005],
    'profesional': [4.869, 4.0569999999999995, 5.606],
    'profesión': [3.995, 4.607, 5.715],
    'profesor': [5.468999999999999, 6.297999999999999, 6.882999999999999],
    'profesora': [6.0, 5.975, 6.317],
    'profeta': [5.237, 4.731, 3.6710000000000003],
    'profundidad': [4.217, 5.0569999999999995, 5.709],
    'profundizar': [3.952, 2.989, 6.026],
    'progenie': [4.503, 2.497, 1.81],
    'programa': [4.997, 5.403, 6.542999999999999],
    'programación': [4.078, 3.734, 6.1129999999999995],
    'progresista': [4.024, 3.1910000000000003, 4.474],
    'prohibición': [3.9810000000000003, 4.146, 5.526],
    'prohibir': [4.716, 4.221, 5.4239999999999995],
    'prole': [4.269, 4.645, 2.52],
    'proletariado': [5.029, 4.37, 4.841],
    'proliferación': [3.282, 2.654, 3.1460000000000004],
    'prolongación': [4.191, 3.05, 4.995],
    'prolongar': [3.925, 3.623, 4.886],
    'promesa': [4.533, 3.299, 5.75],
    'prometer': [3.386, 3.193, 5.871],
    'prometida': [4.129, 4.466, 4.11],
    'promoción': [4.119, 3.653, 5.563],
    'promontorio': [3.674, 3.4010000000000002, 2.912],
    'promover': [3.327, 2.443, 4.935],
    'pronunciar': [4.336, 4.367, 5.9510000000000005],
    'pronóstico': [4.4430000000000005, 2.7119999999999997, 4.417],
    'propaganda': [5.045, 5.544, 6.145],
    'propensión': [3.964, 2.6189999999999998, 3.46],
    'propiciar': [3.071, 2.0469999999999997, 3.925],
    'propiedad': [4.006, 3.323, 4.923],
    'propietario': [5.281000000000001, 4.947, 5.319],
    'propina': [5.513999999999999, 5.24, 6.23],
    'proponer': [3.011, 2.3409999999999997, 5.476],
    'proponerse': [3.611, 3.048, 5.316],
    'proporcionar': [3.642, 3.455, 5.0169999999999995],
    'proporción': [3.77, 2.853, 5.437],
    'proposición': [3.3510000000000004, 3.676, 4.648],
    'propuesta': [3.438, 2.4090000000000003, 5.636],
    'propósito': [3.5810000000000004, 2.917, 4.633],
    'prosa': [5.002, 4.251, 5.136],
    'proseguir': [4.111000000000001, 2.805, 3.6430000000000002],
    'prosperar': [4.021, 3.949, 5.119],
    'prosperidad': [3.7260000000000004, 3.438, 4.081],
    'prostitución': [5.417999999999999, 4.445, 6.061],
    'prostíbulo': [5.974, 5.718999999999999, 4.544],
    'protagonismo': [3.903, 2.863, 5.832999999999999],
    'protagonista': [4.849, 4.038, 6.494],
    'protección': [4.646, 3.977, 5.768],
    'protector': [3.718, 4.391, 4.937],
    'protectora': [3.616, 3.023, 4.177],
    'proteger': [3.7539999999999996, 3.509, 5.704],
    'protegido': [4.35, 3.972, 4.541],
    'protesta': [4.336, 4.402, 5.172000000000001],
    'protestar': [3.906, 4.558, 5.819],
    'proteína': [5.337000000000001, 2.944, 5.731],
    'protocolo': [4.659, 3.0189999999999997, 4.272],
    'prototipo': [3.51, 2.8110000000000004, 4.772],
    'protón': [6.15, 2.458, 2.326],
    'provecho': [3.733, 2.614, 4.529],
    'providencia': [2.6889999999999996, 2.3480000000000003, 2.481],
    'provincia': [5.369, 4.46, 4.958],
    'provisiones': [4.27, 4.885, 3.984],
    'provocación': [3.562, 3.64, 5.436],
    'provocador': [3.387, 3.312, 3.9810000000000003],
    'provocar': [3.577, 3.6839999999999997, 5.256],
    'proyección': [4.184, 4.048, 5.157],
    'proyectil': [5.03, 5.162999999999999, 4.1160000000000005],
    'proyecto': [4.4639999999999995, 3.52, 5.932],
    'prudencia': [4.0280000000000005, 2.755, 5.651],
    'prueba': [3.6180000000000003, 3.863, 6.33],
    'práctica': [2.387, 4.025, 6.474],
    'práctico': [3.3680000000000003, 3.2569999999999997, 5.199],
    'príncipe': [5.76, 5.865, 5.547000000000001],
    'prójimo': [4.228, 4.4, 4.794],
    'prólogo': [4.98, 4.553999999999999, 4.337],
    'prótesis': [5.143, 4.169, 4.651],
    'psicoanalistas': [5.457999999999999, 4.681, 5.63],
    'psicoanálisis': [6.007000000000001, 4.003, 5.928999999999999],
    'psicología': [3.597, 4.313, 6.442],
    'psiquiatra': [6.357, 5.1, 5.43],
    'pubis': [5.792000000000001, 5.3420000000000005, 4.1339999999999995],
    'publicación': [4.149, 4.68, 5.282],
    'publicar': [4.563, 3.819, 6.087000000000001],
    'publicidad': [5.237, 6.122000000000001, 6.239],
    'puchero': [6.025, 5.343, 4.855],
    'pudor': [3.892, 2.859, 3.903],
    'pueblo': [4.901, 6.03, 6.626],
    'puerta': [6.3229999999999995, 5.803999999999999, 6.784],
    'puerto': [5.695, 6.126, 6.202000000000001],
    'puesta': [2.6910000000000003, 3.3560000000000003, 5.063],
    'puesto': [2.9760000000000004, 3.008, 5.428],
    'pugna': [3.955, 3.56, 2.718],
    'pulgas': [6.0360000000000005, 3.927, 5.4910000000000005],
    'pulmón': [6.245, 5.441, 5.74],
    'pulsera': [6.162999999999999, 5.954, 6.465],
    'pulso': [4.829, 4.0280000000000005, 5.044],
    'punta': [4.185, 5.287999999999999, 5.723],
    'puntera': [5.472, 4.317, 3.037],
    'puntillas': [4.215, 5.16, 4.692],
    'punto': [4.667, 5.43, 6.483],
    'punzada': [4.4030000000000005, 4.649, 4.125],
    'pupila': [6.246, 6.4079999999999995, 6.011],
    'pupitre': [6.347, 5.8629999999999995, 4.511],
    'pureza': [3.403, 3.784, 4.57],
    'purgatorio': [5.146, 2.844, 2.572],
    'purificación': [2.826, 2.452, 3.3539999999999996],
    'puritana': [4.749, 3.3760000000000003, 4.553999999999999],
    'puta': [5.791, 5.706, 5.852],
    'puñado': [4.0089999999999995, 4.103, 5.055],
    'puñeta': [3.8110000000000004, 2.963, 4.78],
    'puño': [6.316, 5.0, 5.065],
    'página': [6.165, 5.176, 6.6],
    'pánico': [3.222, 4.923, 6.152],
    'párpados': [6.33, 6.242000000000001, 6.409],
    'párrafo': [5.8020000000000005, 5.86, 6.455],
    'péndulo': [5.379, 5.709, 4.377],
    'pérdida': [3.4619999999999997, 2.8810000000000002, 6.409],
    'pétalos': [5.981, 6.405, 5.495],
    'pómulos': [6.242999999999999, 5.656000000000001, 4.137],
    'púas': [4.868, 4.803, 4.227],
    'público': [4.803999999999999, 5.442, 6.156000000000001],
    'púlpito': [5.1610000000000005, 4.243, 2.34],
    'púlsar': [4.41, 4.709, 4.435],
    'quebrar': [3.841, 3.636, 3.397],
    'quedar': [3.196, 3.47, 5.871],
    'quedarse': [4.495, 3.718, 5.4670000000000005],
    'quehacer': [3.198, 2.826, 3.5180000000000002],
    'queja': [3.8960000000000004, 3.8169999999999997, 5.337000000000001],
    'quejido': [4.503, 5.869, 5.242000000000001],
    'quemar': [5.077, 6.108, 6.607],
    'querencia': [3.324, 2.714, 2.407],
    'querer': [3.452, 4.204, 6.347],
    'querido': [4.133, 4.895, 5.396],
    'queso': [5.992000000000001, 5.849, 5.931],
    'quicio': [3.096, 2.94, 4.2780000000000005],
    'quiebra': [3.9730000000000003, 3.4989999999999997, 3.0839999999999996],
    'quietud': [3.536, 4.067, 4.881],
    'quimera': [3.764, 2.761, 2.908],
    'quinta': [4.35, 4.063, 5.156000000000001],
    'quiosco': [5.771, 5.72, 6.064],
    'quirófano': [6.059, 5.8839999999999995, 4.833],
    'quitar': [4.508, 3.783, 5.2860000000000005],
    'quitarse': [3.5460000000000003, 4.069, 5.945],
    'quite': [3.614, 2.488, 3.267],
    'química': [4.205, 4.72, 5.577000000000001],
    'químico': [5.352, 5.374, 5.425],
    'rabia': [4.755, 4.188, 5.382000000000001],
    'rabo': [5.239, 5.915, 4.828],
    'racimos': [5.167000000000001, 5.937, 5.252000000000001],
    'raciocinio': [4.342, 2.741, 3.03],
    'racionalidad': [3.92, 2.004, 5.447],
    'racionalismo': [3.239, 2.358, 3.819],
    'racionalista': [4.173, 2.617, 4.552],
    'racionamiento': [3.859, 3.594, 3.245],
    'racista': [5.141, 4.629, 5.646],
    'ración': [4.374, 4.703, 5.138],
    'radiación': [4.462, 2.63, 5.086],
    'radiactividad': [4.939, 3.0069999999999997, 4.516],
    'radical': [3.924, 3.616, 5.321000000000001],
    'radio': [5.81, 6.002000000000001, 6.308],
    'radiografía': [6.108, 3.15, 3.5610000000000004],
    'rama': [4.72, 6.114, 6.1160000000000005],
    'ramo': [4.8839999999999995, 6.176, 5.627000000000001],
    'rana': [6.37, 6.267, 5.763],
    'rancho': [4.975, 5.313, 3.766],
    'rango': [3.4739999999999998, 3.217, 4.72],
    'ranura': [4.897, 5.966, 3.9760000000000004],
    'rapaz': [4.478, 5.5089999999999995, 4.686],
    'rapidez': [4.221, 3.8280000000000003, 6.3020000000000005],
    'rapto': [3.81, 5.03, 4.92],
    'rareza': [3.0410000000000004, 3.2430000000000003, 4.078],
    'rascacielos': [6.379, 6.084, 4.617],
    'rasgo': [3.342, 2.397, 5.019],
    'rastrear': [4.227, 4.155, 4.082],
    'rata': [6.537999999999999, 6.15, 6.307],
    'rato': [4.36, 3.485, 6.459],
    'ratón': [5.9510000000000005, 6.212999999999999, 5.961],
    'raya': [4.694, 6.063, 5.8629999999999995],
    'rayo': [5.596, 6.224, 5.899],
    'raza': [4.3660000000000005, 5.607, 5.858],
    'razonamiento': [3.332, 2.7119999999999997, 4.8580000000000005],
    'razonar': [3.432, 3.0660000000000003, 5.269],
    'razón': [2.542, 2.926, 6.34],
    'raíz': [5.2379999999999995, 5.801, 6.43],
    'reaccionar': [3.4530000000000003, 3.6180000000000003, 5.82],
    'reacción': [3.3810000000000002, 3.801, 4.721],
    'realeza': [4.605, 3.63, 5.279],
    'realidad': [3.248, 3.011, 4.418],
    'realismo': [3.389, 2.293, 5.085],
    'realista': [4.578, 3.43, 5.563],
    'realización': [3.647, 3.088, 5.66],
    'realizar': [2.582, 2.8560000000000003, 5.557],
    'realizarse': [3.138, 2.9989999999999997, 5.584],
    'rebajas': [5.577999999999999, 5.962000000000001, 6.216],
    'rebasar': [4.696000000000001, 4.246, 5.84],
    'rebaño': [5.41, 6.184, 4.582],
    'rebeldes': [4.218999999999999, 3.86, 5.459],
    'rebeldía': [3.571, 4.297, 5.662000000000001],
    'rebelión': [3.8539999999999996, 5.372000000000001, 5.005],
    'recabar': [3.8510000000000004, 3.2430000000000003, 3.466],
    'recado': [4.367, 3.627, 5.369],
    'recelo': [3.2039999999999997, 3.01, 3.7569999999999997],
    'receptor': [5.081, 4.398, 5.803],
    'receta': [5.36, 5.4270000000000005, 5.917000000000001],
    'rechazar': [4.107, 3.7569999999999997, 5.223],
    'rechazo': [3.758, 3.7939999999999996, 4.383],
    'recibidor': [4.462, 5.053999999999999, 5.1739999999999995],
    'recibir': [3.9539999999999997, 4.274, 5.747999999999999],
    'recibo': [4.712, 4.558, 5.545],
    'recinto': [4.94, 4.838, 5.478],
    'recipiente': [4.046, 5.188, 4.979],
    'recitar': [5.22, 4.452, 4.061],
    'reclamar': [4.348, 3.748, 5.2410000000000005],
    'reclamo': [3.907, 3.216, 4.484],
    'recobrar': [3.6039999999999996, 2.958, 4.814],
    'recodo': [4.573, 3.886, 3.658],
    'recoger': [4.146, 4.648, 5.905],
    'recogimiento': [2.612, 2.978, 3.531],
    'recomendación': [3.72, 3.08, 5.349],
    'recomendar': [4.101, 2.86, 5.54],
    'recompensa': [4.95, 5.507000000000001, 5.1160000000000005],
    'reconciliación': [4.798, 4.673, 5.7410000000000005],
    'reconocer': [4.229, 4.13, 5.755],
    'reconocerse': [3.865, 3.722, 5.517],
    'reconocimiento': [3.208, 3.341, 5.787000000000001],
    'reconquista': [4.2410000000000005, 3.593, 4.525],
    'reconstrucción': [4.48, 4.381, 5.039],
    'reconstruir': [4.7989999999999995, 4.239, 4.968999999999999],
    'reconversión': [3.588, 2.721, 3.241],
    'recordar': [3.898, 3.0639999999999996, 6.053999999999999],
    'recorrer': [3.839, 4.285, 5.721],
    'recorrido': [3.907, 3.785, 6.257999999999999],
    'recorte': [4.008, 4.503, 5.211],
    'recovecos': [3.032, 3.076, 3.112],
    'recrear': [2.8680000000000003, 3.029, 4.236000000000001],
    'recta': [5.7989999999999995, 6.603, 6.271],
    'recto': [4.562, 4.8, 5.817],
    'rector': [5.9239999999999995, 4.963, 4.87],
    'rectángulo': [5.664, 5.91, 6.079],
    'recuento': [4.404, 3.147, 4.388],
    'recuerdo': [3.65, 4.077, 6.41],
    'recuperación': [3.728, 4.069, 5.655],
    'recuperar': [4.223, 4.189, 6.11],
    'recurrir': [3.963, 2.972, 4.57],
    'red': [4.696000000000001, 5.912000000000001, 3.312],
    'redacción': [4.7669999999999995, 4.487, 5.666],
    'redactar': [4.9030000000000005, 4.234, 5.415],
    'redactor': [5.4879999999999995, 4.271, 4.248],
    'redención': [3.45, 2.04, 2.45],
    'reduccionismo': [3.48, 2.274, 4.406000000000001],
    'reducción': [3.201, 2.405, 4.0889999999999995],
    'reducir': [3.65, 3.157, 5.33],
    'reducto': [4.2, 2.4219999999999997, 2.0180000000000002],
    'referencia': [3.305, 2.783, 5.271],
    'referentes': [2.728, 2.262, 3.978],
    'referirse': [3.8819999999999997, 2.494, 5.732],
    'reflejar': [3.898, 3.9530000000000003, 4.381],
    'reflejo': [3.155, 3.888, 5.148],
    'reflexionar': [3.583, 3.503, 5.906000000000001],
    'reforma': [4.215, 4.755, 6.106],
    'reforzar': [3.301, 3.281, 6.066],
    'refrán': [5.62, 4.099, 5.7829999999999995],
    'refugiado': [4.796, 5.045, 5.572],
    'refugiarse': [4.195, 4.631, 4.737],
    'refugio': [4.596, 5.84, 5.382000000000001],
    'regalo': [4.788, 6.03, 5.974],
    'regazo': [4.124, 4.343999999999999, 4.021],
    'regenta': [4.105, 2.8960000000000004, 3.09],
    'regimiento': [4.906000000000001, 4.888999999999999, 5.037],
    'registrador': [4.6610000000000005, 3.24, 3.676],
    'registrar': [3.4010000000000002, 3.7680000000000002, 4.636],
    'registro': [3.7510000000000003, 3.8160000000000003, 4.454],
    'región': [4.824, 4.6419999999999995, 5.077],
    'regla': [4.941, 5.585, 6.271],
    'reglamento': [4.188, 4.073, 4.7860000000000005],
    'regocijo': [3.415, 2.859, 3.8369999999999997],
    'regresar': [4.511, 4.593, 5.64],
    'regresión': [3.392, 2.5469999999999997, 5.438],
    'regreso': [3.9010000000000002, 4.852, 5.287000000000001],
    'regulación': [3.638, 2.455, 3.236],
    'regulador': [4.2669999999999995, 3.035, 3.091],
    'regularidad': [3.8480000000000003, 3.154, 4.548],
    'rehacer': [3.0789999999999997, 3.389, 4.512],
    'reina': [5.372999999999999, 6.343999999999999, 5.51],
    'reinado': [4.58, 4.5969999999999995, 3.47],
    'reino': [4.48, 4.794, 5.36],
    'reiteración': [4.566, 2.569, 3.449],
    'reivindicación': [3.2, 3.4539999999999997, 4.115],
    'reja': [6.122000000000001, 5.829, 5.774],
    'relación': [2.932, 3.855, 6.638999999999999],
    'relajación': [3.926, 4.9319999999999995, 6.119],
    'relatividad': [2.815, 1.7730000000000001, 3.825],
    'relativismo': [2.878, 2.057, 3.4589999999999996],
    'relativistas': [3.8939999999999997, 1.96, 2.198],
    'relato': [3.568, 4.371, 4.43],
    'relevancia': [3.529, 2.005, 4.838],
    'relieve': [4.365, 5.059, 4.356],
    'religioso': [4.281000000000001, 3.89, 3.8289999999999997],
    'religión': [4.235, 4.2410000000000005, 4.9639999999999995],
    'reliquia': [4.973, 4.81, 5.251],
    'rellenar': [4.114, 4.957, 5.732],
    'relleno': [3.767, 4.415, 5.944],
    'reloj': [6.518, 6.042999999999999, 6.768],
    'relojería': [5.662000000000001, 5.9239999999999995, 5.132999999999999],
    'relucir': [4.189, 4.562, 4.235],
    'relámpago': [6.22, 6.218, 4.65],
    'rematar': [4.103, 3.925, 5.082],
    'remediar': [3.957, 3.234, 5.361000000000001],
    'remedio': [4.034, 3.699, 6.124],
    'remilgos': [4.158, 3.057, 3.466],
    'remolino': [4.883, 5.23, 5.212999999999999],
    'remordimiento': [3.906, 3.572, 5.29],
    'remover': [4.077, 4.95, 6.104],
    'renacer': [3.4160000000000004, 2.256, 4.095],
    'renacimiento': [4.675, 4.7219999999999995, 4.871],
    'rencor': [4.551, 3.3569999999999998, 4.212],
    'rendición': [4.2, 3.3989999999999996, 4.5169999999999995],
    'rendija': [4.895, 4.247, 4.437],
    'rendimiento': [3.975, 3.6039999999999996, 5.829],
    'rendir': [4.239, 3.911, 6.029],
    'rendirse': [4.551, 4.138, 5.278],
    'renegar': [4.503, 2.719, 3.734],
    'renombre': [3.835, 2.866, 4.0569999999999995],
    'renovación': [3.76, 2.4930000000000003, 4.273],
    'renovar': [3.5, 3.4539999999999997, 5.331],
    'renta': [4.698, 3.5210000000000004, 4.3389999999999995],
    'rentabilidad': [3.773, 2.231, 3.661],
    'renuncia': [3.873, 3.5660000000000003, 5.2410000000000005],
    'renunciar': [3.742, 3.0189999999999997, 4.902],
    'reojo': [4.872, 4.904, 5.2139999999999995],
    'reparación': [4.206, 4.18, 4.676],
    'reparar': [3.763, 4.431, 5.704],
    'repartir': [4.54, 3.905, 5.896],
    'reparto': [4.0280000000000005, 4.289, 5.686],
    'repaso': [3.986, 3.971, 6.359],
    'repertorio': [3.613, 3.342, 4.79],
    'repetición': [4.468999999999999, 4.203, 5.778],
    'repetir': [4.412, 3.87, 6.568],
    'repetirse': [3.523, 3.8, 6.683],
    'repisa': [5.7139999999999995, 5.43, 4.93],
    'reportaje': [4.888999999999999, 5.406000000000001, 5.999],
    'representación': [2.738, 3.525, 5.529],
    'representante': [4.154, 5.24, 5.058],
    'representar': [3.535, 3.298, 5.541],
    'represión': [3.65, 3.9010000000000002, 5.31],
    'reproche': [4.235, 3.475, 5.562],
    'reproducción': [4.426, 4.736000000000001, 5.223],
    'reproducir': [3.5389999999999997, 3.372, 4.852],
    'reptil': [4.923, 6.403, 5.87],
    'republicana': [4.705, 2.603, 3.045],
    'republicano': [5.4110000000000005, 3.5389999999999997, 3.616],
    'repudio': [3.556, 3.392, 2.6210000000000004],
    'repuesto': [3.781, 3.272, 5.23],
    'repugnancia': [5.234, 5.584, 5.5489999999999995],
    'repulsión': [3.344, 3.312, 3.815],
    'reputación': [3.673, 2.552, 4.999],
    'república': [4.872, 2.8080000000000003, 3.998],
    'requerimientos': [3.397, 2.305, 3.71],
    'requisitos': [3.301, 2.244, 4.5489999999999995],
    'res': [5.14, 4.718, 2.77],
    'resaca': [5.08, 4.524, 5.574],
    'resaltar': [3.161, 3.444, 5.2410000000000005],
    'resbalar': [5.122999999999999, 4.984, 5.995],
    'rescatar': [4.369, 4.306, 5.569],
    'rescate': [4.466, 4.531000000000001, 5.431],
    'resentimiento': [3.938, 2.415, 4.038],
    'reserva': [3.577, 3.609, 5.026],
    'residencia': [5.24, 5.307, 6.24],
    'residuo': [4.302, 5.112, 4.955],
    'resignación': [3.9789999999999996, 3.4589999999999996, 4.689],
    'resistir': [3.944, 4.466, 5.504],
    'resolución': [4.342, 3.437, 4.436],
    'resolver': [4.293, 3.623, 6.233],
    'resonancia': [4.316, 3.1310000000000002, 4.551],
    'resorte': [5.39, 5.812, 4.419],
    'respaldo': [5.096, 4.663, 5.393],
    'respetable': [3.615, 3.326, 4.213],
    'respetar': [3.9989999999999997, 3.708, 6.254],
    'respeto': [3.6519999999999997, 3.773, 5.782],
    'respingo': [3.7060000000000004, 2.923, 3.4930000000000003],
    'respiración': [5.581, 3.9019999999999997, 5.468999999999999],
    'respirar': [5.531000000000001, 5.084, 6.261],
    'respiro': [4.743, 4.2219999999999995, 5.881],
    'resplandor': [4.272, 5.3420000000000005, 4.419],
    'responder': [4.802, 4.523, 6.247000000000001],
    'responsabilidad': [3.638, 3.9360000000000004, 5.529],
    'respuesta': [4.846, 3.938, 6.675],
    'resta': [4.944, 3.926, 5.987],
    'restablecer': [3.0260000000000002, 2.555, 2.842],
    'restauración': [4.678999999999999, 4.4910000000000005, 5.504],
    'restaurante': [6.034, 6.523, 6.192],
    'resto': [2.532, 2.6010000000000004, 5.162999999999999],
    'restricción': [3.572, 2.748, 3.773],
    'resucitar': [4.886, 3.2239999999999998, 5.492000000000001],
    'resuello': [3.9189999999999996, 3.18, 3.554],
    'resultado': [4.086, 3.753, 5.449],
    'resultante': [3.491, 3.013, 3.735],
    'resultar': [3.238, 2.69, 4.857],
    'resumen': [5.207999999999999, 4.243, 5.852],
    'resumir': [5.103, 4.088, 6.49],
    'resurrección': [3.898, 3.37, 3.8280000000000003],
    'retablo': [5.236000000000001, 4.859, 3.949],
    'retener': [3.858, 2.752, 5.053999999999999],
    'retina': [6.422999999999999, 4.973, 4.998],
    'retirada': [4.104, 3.915, 4.7860000000000005],
    'retirar': [3.7569999999999997, 3.8339999999999996, 5.4670000000000005],
    'retirarse': [4.035, 3.4619999999999997, 5.0280000000000005],
    'reto': [4.8260000000000005, 3.361, 5.252000000000001],
    'retorno': [4.059, 3.0660000000000003, 3.385],
    'retraso': [3.72, 4.025, 6.36],
    'retrato': [5.513999999999999, 6.37, 5.754],
    'retrete': [6.1129999999999995, 6.072, 5.438],
    'retrovisor': [6.246, 5.907, 5.602],
    'retórica': [3.492, 2.263, 2.7310000000000003],
    'reunión': [4.466, 5.292999999999999, 5.691],
    'revelación': [3.986, 2.461, 4.811],
    'revelar': [3.384, 4.293, 4.849],
    'reverencia': [4.909, 5.37, 4.592],
    'reverendo': [5.1979999999999995, 5.52, 2.6860000000000004],
    'reverso': [4.248, 3.603, 3.295],
    'revisar': [3.545, 3.931, 5.099],
    'revisión': [4.168, 3.049, 5.419],
    'revista': [5.38, 6.122999999999999, 6.521],
    'revivir': [3.766, 3.6180000000000003, 5.081],
    'revolucionaria': [4.3389999999999995, 3.787, 5.537999999999999],
    'revolucionario': [4.354, 4.757, 5.311],
    'revolución': [4.185, 4.753, 5.09],
    'revuelo': [3.628, 4.204, 4.6819999999999995],
    'revuelta': [3.633, 3.985, 4.577],
    'revés': [3.6839999999999997, 3.588, 5.021],
    'revólver': [6.141, 6.2620000000000005, 5.638999999999999],
    'rezar': [5.502999999999999, 4.715, 5.985],
    'rezo': [4.66, 5.329, 4.533],
    'reír': [5.906000000000001, 6.063, 6.359],
    'reírse': [5.081, 5.773, 6.0920000000000005],
    'ribera': [4.645, 4.738, 4.0360000000000005],
    'rica': [4.321000000000001, 4.86, 5.227],
    'rictus': [4.348, 2.91, 1.9480000000000002],
    'ridículo': [5.109, 3.307, 5.68],
    'rienda': [4.524, 4.501, 4.417],
    'riesgo': [4.164, 4.2139999999999995, 5.256],
    'rigor': [3.468, 2.57, 3.2960000000000003],
    'rima': [5.4, 3.4560000000000004, 5.44],
    'rincón': [5.776, 4.981, 6.099],
    'riqueza': [4.368, 4.926, 5.352],
    'risa': [5.645, 5.687, 6.752000000000001],
    'risotadas': [5.1979999999999995, 5.507999999999999, 3.8810000000000002],
    'ritmo': [4.167, 4.328, 5.155],
    'rito': [3.8810000000000002, 4.322, 4.735],
    'ritual': [4.406000000000001, 4.7780000000000005, 4.898],
    'rival': [4.548, 4.302, 5.791],
    'rivalidad': [4.166, 4.979, 5.331],
    'rizos': [5.35, 6.507999999999999, 6.398],
    'riñón': [6.193, 5.959, 6.001],
    'robar': [4.904, 4.971, 5.819],
    'roble': [6.468, 4.915, 4.173],
    'robo': [5.187, 5.353, 6.4110000000000005],
    'robot': [5.479, 6.099, 4.623],
    'robótica': [4.313, 3.156, 1.7619999999999998],
    'roca': [5.553999999999999, 6.153, 6.301],
    'roce': [3.715, 4.294, 5.851],
    'rocío': [4.457, 5.337999999999999, 4.407],
    'rodaje': [4.005, 4.133, 4.381],
    'rodar': [4.801, 5.013999999999999, 3.892],
    'rodilla': [6.556, 4.6339999999999995, 5.9510000000000005],
    'roedores': [4.787, 6.2010000000000005, 4.906000000000001],
    'rojo': [5.25, 6.343, 6.126],
    'rollo': [3.483, 4.9030000000000005, 6.31],
    'romana': [5.349, 4.652, 4.323],
    'romance': [4.448, 4.798, 4.7219999999999995],
    'romano': [5.482, 6.053, 5.199],
    'romanticismo': [3.388, 4.624, 5.0169999999999995],
    'romero': [5.6, 5.013, 5.101],
    'rompecabezas': [5.401, 5.82, 5.029],
    'romper': [4.638, 5.2620000000000005, 6.142],
    'romántica': [3.85, 3.8810000000000002, 5.617000000000001],
    'romántico': [4.232, 5.352, 5.452999999999999],
    'ron': [5.767, 5.557, 4.44],
    'ronda': [3.335, 3.1460000000000004, 3.3680000000000003],
    'ronquido': [6.0, 6.206, 6.01],
    'ronroneo': [3.964, 4.842, 4.268],
    'ropa': [3.7910000000000004, 6.218, 6.6129999999999995],
    'ropaje': [4.416, 4.896, 3.3510000000000004],
    'ropero': [5.256, 5.975, 4.141],
    'rosal': [6.53, 6.472, 6.12],
    'rosario': [5.642, 5.774, 6.055],
    'rostro': [5.242000000000001, 5.707999999999999, 4.645],
    'rotación': [4.149, 3.492, 4.215],
    'rotura': [3.873, 4.806, 4.335],
    'rubia': [4.959, 6.2010000000000005, 6.412000000000001],
    'rubio': [5.541, 6.068, 6.267],
    'rueda': [6.077000000000001, 6.479, 6.3389999999999995],
    'ruego': [4.026, 4.14, 3.826],
    'rufianes': [4.953, 3.9619999999999997, 3.6460000000000004],
    'rugido': [5.66, 5.268, 3.408],
    'ruido': [4.037, 5.335, 6.392],
    'ruina': [5.143, 5.152, 5.716],
    'rumbo': [3.395, 3.534, 5.308],
    'rumor': [3.735, 4.334, 5.1739999999999995],
    'ruptura': [3.488, 4.199, 5.852],
    'rusa': [4.732, 4.928, 5.142],
    'ruso': [6.007999999999999, 5.102, 5.337000000000001],
    'ruta': [5.05, 5.434, 5.821000000000001],
    'rutina': [4.5280000000000005, 3.98, 5.027],
    'rápido': [4.659, 4.73, 6.2860000000000005],
    'récord': [5.404, 4.104, 5.47],
    'réplica': [3.935, 3.952, 4.624],
    'ría': [5.225, 4.955, 5.996],
    'río': [6.271, 6.255, 6.307],
    'rótulo': [5.529, 5.891, 4.707],
    'saber': [3.447, 2.69, 5.1339999999999995],
    'saberse': [2.8739999999999997, 2.739, 5.484],
    'sabia': [4.622, 3.315, 4.515],
    'sabiduría': [3.8480000000000003, 4.915, 5.617999999999999],
    'sabio': [4.7, 5.23, 5.209],
    'sable': [6.412000000000001, 4.875, 3.33],
    'sabor': [3.682, 4.5169999999999995, 6.263],
    'sacar': [3.617, 4.04, 6.445],
    'sacerdote': [6.03, 5.877000000000001, 4.53],
    'saciedad': [4.103, 3.7260000000000004, 4.712],
    'saco': [5.052, 5.767, 5.1339999999999995],
    'sacramento': [3.8960000000000004, 2.904, 4.11],
    'sacrificar': [4.004, 4.437, 4.6819999999999995],
    'sacrificio': [4.055, 3.662, 5.801],
    'sacristán': [5.879, 5.165, 4.542],
    'sacristía': [5.236000000000001, 5.126, 3.605],
    'sacudida': [4.239, 4.0680000000000005, 5.013999999999999],
    'sadismo': [4.073, 4.398, 3.403],
    'sal': [5.896, 6.327999999999999, 6.519],
    'sala': [4.617, 6.055, 5.997999999999999],
    'salario': [5.553, 4.365, 4.402],
    'saldo': [4.828, 3.529, 4.465],
    'salida': [4.8069999999999995, 5.593, 6.631],
    'salinidad': [4.372, 3.286, 3.838],
    'salir': [3.906, 4.431, 6.7410000000000005],
    'salirse': [3.5410000000000004, 3.9160000000000004, 5.835],
    'salita': [5.487, 5.875, 5.553],
    'saliva': [6.627999999999999, 5.695, 5.966],
    'salsa': [4.882, 5.454, 6.122000000000001],
    'saltar': [5.228, 6.296, 5.691],
    'salto': [4.361000000000001, 5.206, 6.2589999999999995],
    'salud': [4.4639999999999995, 4.1530000000000005, 6.579],
    'saludar': [4.579, 5.5889999999999995, 5.9910000000000005],
    'saludo': [4.4, 5.295, 6.487],
    'salvación': [3.102, 3.0039999999999996, 3.725],
    'salvaje': [4.213, 5.432, 6.065],
    'salvar': [4.102, 4.088, 5.593],
    'salvarse': [4.155, 4.315, 5.612],
    'salvavidas': [6.122999999999999, 6.4110000000000005, 5.202000000000001],
    'salón': [4.78, 6.4270000000000005, 6.444],
    'samaritana': [4.735, 4.468999999999999, 3.701],
    'sanatorio': [5.6770000000000005, 5.732, 4.478],
    'sanción': [4.211, 3.782, 4.822],
    'sangre': [6.542000000000001, 6.09, 6.5489999999999995],
    'sanidad': [3.585, 3.042, 5.353],
    'sanitario': [4.255, 4.352, 5.2170000000000005],
    'santa': [4.762, 4.645, 4.863],
    'santidad': [4.275, 3.904, 3.034],
    'santo': [4.567, 4.744, 5.386],
    'santuario': [5.897, 5.807, 5.523],
    'sapo': [6.104, 6.14, 5.048],
    'sarcasmo': [4.4239999999999995, 2.7689999999999997, 4.579],
    'sargento': [5.484, 6.042000000000001, 5.447],
    'sarmiento': [3.8689999999999998, 1.9669999999999999, 2.142],
    'sartén': [6.506, 5.58, 5.984],
    'sastre': [6.042000000000001, 5.539, 4.271],
    'satanás': [5.685, 4.869, 3.96],
    'satisfacer': [2.733, 3.258, 6.106],
    'satélite': [4.783, 4.938, 4.547],
    'sauna': [5.933, 5.593, 5.65],
    'sazón': [4.01, 2.562, 3.429],
    'secar': [4.993, 5.6160000000000005, 6.324],
    'secarse': [5.124, 4.813, 5.646],
    'sección': [2.802, 3.596, 5.066],
    'secretaria': [5.907, 5.936, 6.1129999999999995],
    'secretario': [5.5489999999999995, 5.827999999999999, 5.3389999999999995],
    'secretaría': [5.733, 5.582999999999999, 5.557],
    'secreto': [4.516, 3.21, 5.861000000000001],
    'sector': [2.9130000000000003, 2.82, 4.288],
    'secuela': [4.341, 3.502, 4.159],
    'secuencia': [3.3789999999999996, 3.025, 4.47],
    'secuestro': [5.787000000000001, 5.2, 5.449],
    'secular': [3.7710000000000004, 1.966, 2.016],
    'sed': [4.953, 4.725, 6.346],
    'seda': [5.689, 5.756, 5.928],
    'sedante': [5.349, 4.555, 5.242000000000001],
    'sede': [3.6510000000000002, 2.9160000000000004, 3.608],
    'sedimento': [3.9610000000000003, 3.9389999999999996, 2.34],
    'seducción': [3.7110000000000003, 4.6610000000000005, 4.688],
    'seductora': [4.28, 4.641, 5.252000000000001],
    'segmento': [4.285, 4.28, 4.504],
    'segregación': [4.293, 3.307, 4.341],
    'seguidores': [4.455, 5.046, 6.405],
    'seguimiento': [4.3660000000000005, 3.528, 4.258],
    'seguir': [3.6319999999999997, 3.1460000000000004, 6.3],
    'segundo': [4.477, 2.69, 5.485],
    'seguridad': [3.6689999999999996, 3.071, 6.157],
    'seguro': [4.612, 3.63, 6.121],
    'seiscientos': [5.622999999999999, 4.75, 5.831],
    'seleccionar': [4.379, 4.034, 6.041],
    'selección': [3.957, 4.401, 5.982],
    'selectividad': [5.183, 5.462999999999999, 5.797999999999999],
    'selva': [6.2829999999999995, 6.376, 5.636],
    'semana': [6.364, 4.606, 6.935],
    'semblante': [3.7889999999999997, 3.9739999999999998, 3.658],
    'sembrado': [4.945, 5.183, 3.627],
    'sembrar': [4.763, 6.1129999999999995, 4.894],
    'semejante': [3.7569999999999997, 3.659, 5.504],
    'semejanza': [3.571, 3.63, 4.695],
    'semen': [6.502000000000001, 5.885, 4.085],
    'semiconductores': [
        3.6189999999999998, 2.1069999999999998, 1.7890000000000001
    ],
    'semilla': [5.5489999999999995, 5.46, 4.628],
    'semántica': [3.6889999999999996, 2.792, 4.681],
    'senado': [5.484, 3.8939999999999997, 5.18],
    'sencillez': [3.733, 3.1069999999999998, 6.169],
    'senda': [4.9719999999999995, 5.5489999999999995, 3.786],
    'sendero': [4.893, 5.653, 4.431],
    'seno': [4.093, 5.77, 4.706],
    'sensación': [2.864, 4.266, 5.681],
    'sensores': [4.811, 3.435, 2.9],
    'sensualidad': [3.805, 4.662, 4.537],
    'sentar': [4.695, 4.9319999999999995, 6.09],
    'sentarse': [5.604, 5.172999999999999, 6.755],
    'sentencia': [4.1, 3.1839999999999997, 3.9160000000000004],
    'sentido': [3.145, 2.8939999999999997, 6.343],
    'sentimiento': [2.307, 4.164, 6.074],
    'sentir': [2.617, 3.3560000000000003, 6.042000000000001],
    'sentirse': [2.915, 3.8930000000000002, 6.172000000000001],
    'separación': [3.388, 4.381, 5.702000000000001],
    'separada': [4.035, 4.543, 6.191],
    'separar': [3.8339999999999996, 4.436, 5.962999999999999],
    'separarse': [3.428, 3.7460000000000004, 5.965],
    'septiembre': [6.176, 4.305, 5.792999999999999],
    'sepulcro': [6.0329999999999995, 5.629, 4.385],
    'sepultura': [5.167999999999999, 5.535, 3.945],
    'sequedad': [4.565, 3.1189999999999998, 4.675],
    'sequía': [5.215, 5.627999999999999, 4.939],
    'serenidad': [3.655, 3.237, 4.81],
    'sereno': [3.9339999999999997, 4.2139999999999995, 4.387],
    'seres': [2.667, 4.254, 5.379],
    'serie': [2.674, 3.214, 5.805],
    'sermón': [4.113, 5.314, 5.877999999999999],
    'serpiente': [6.051, 6.195, 4.155],
    'servicio': [4.473, 4.022, 6.449],
    'servidor': [3.551, 3.696, 4.157],
    'servidora': [4.07, 4.412, 4.535],
    'servilleta': [6.678, 6.2860000000000005, 6.4479999999999995],
    'servir': [4.369, 5.355, 6.016],
    'servirse': [3.633, 4.618, 5.853],
    'sesión': [3.6069999999999998, 2.615, 5.662000000000001],
    'setos': [5.091, 5.926, 3.917],
    'seudónimo': [4.822, 3.135, 4.0889999999999995],
    'severidad': [3.847, 2.861, 3.327],
    'sevillanas': [4.73, 4.98, 5.849],
    'sevillano': [5.755, 6.365, 5.688],
    'sexo': [4.949, 5.678, 6.718999999999999],
    'sexualidad': [4.82, 5.377999999999999, 6.457999999999999],
    'seña': [3.9339999999999997, 4.351, 4.293],
    'señal': [4.2989999999999995, 4.806, 5.532],
    'señalar': [4.414, 4.8839999999999995, 6.343999999999999],
    'señor': [4.819, 5.566, 6.04],
    'señora': [5.752999999999999, 5.867999999999999, 6.221],
    'señorita': [5.566, 5.916, 5.249],
    'señorito': [5.268, 5.405, 2.8960000000000004],
    'señorío': [4.467, 3.6910000000000003, 4.029],
    'sida': [6.23, 3.9760000000000004, 5.562],
    'siembra': [3.785, 4.261, 3.945],
    'sien': [6.598, 5.184, 3.6239999999999997],
    'sierra': [5.473, 5.814, 5.6770000000000005],
    'siervos': [4.749, 4.537, 2.785],
    'siesta': [5.511, 4.784, 5.888],
    'sigilo': [3.9130000000000003, 4.029, 3.105],
    'siglo': [5.652, 2.859, 6.041],
    'significación': [3.255, 2.764, 5.527],
    'significado': [3.4130000000000003, 3.141, 6.266],
    'significante': [3.458, 2.8310000000000004, 4.087],
    'significar': [3.0780000000000003, 3.102, 6.3839999999999995],
    'significatividad': [3.233, 2.006, 2.8710000000000004],
    'signo': [3.885, 5.1339999999999995, 6.138],
    'silbido': [5.571000000000001, 4.83, 6.0889999999999995],
    'silencio': [5.202000000000001, 4.101, 6.007000000000001],
    'silicio': [6.374, 2.888, 2.322],
    'silla': [6.524, 6.54, 6.831],
    'sillón': [6.245, 5.6339999999999995, 6.416],
    'silueta': [4.928999999999999, 5.8839999999999995, 4.0969999999999995],
    'simbolismo': [2.968, 2.521, 3.5669999999999997],
    'simetría': [4.815, 4.717, 4.362],
    'similitud': [3.755, 3.7760000000000002, 5.191],
    'simpatía': [4.914, 4.148, 6.571000000000001],
    'simplicidad': [3.87, 2.861, 4.744],
    'simplificación': [3.892, 2.4019999999999997, 4.749],
    'simulacro': [4.559, 4.55, 4.246],
    'simulador': [4.11, 3.071, 3.645],
    'simular': [3.286, 3.563, 4.652],
    'sinceridad': [4.24, 3.48, 6.107],
    'sindicato': [4.966, 3.3280000000000003, 5.275],
    'sinfonía': [4.663, 4.726, 5.002],
    'singular': [3.272, 2.6910000000000003, 4.863],
    'singularidad': [3.028, 3.003, 4.7989999999999995],
    'sintaxis': [4.721, 2.823, 3.951],
    'sintetizar': [3.676, 3.653, 5.025],
    'sintonía': [4.648, 3.0660000000000003, 4.446000000000001],
    'sinvergüenza': [4.349, 3.715, 5.544],
    'sinónimo': [4.647, 2.745, 6.062],
    'sirena': [4.324, 5.881, 5.744],
    'sirvienta': [5.312, 4.57, 3.9939999999999998],
    'sirvientes': [5.5120000000000005, 5.3629999999999995, 3.8569999999999998],
    'sistema': [2.2119999999999997, 2.865, 5.71],
    'sitio': [3.925, 4.027, 5.455],
    'situación': [2.843, 3.08, 6.109],
    'situar': [3.662, 3.4560000000000004, 5.269],
    'situarse': [3.895, 3.52, 6.287999999999999],
    'sobacos': [6.3389999999999995, 6.0729999999999995, 4.48],
    'soberano': [4.699, 5.218, 5.119],
    'soberanía': [3.79, 3.585, 3.715],
    'soberbia': [4.265, 4.031000000000001, 4.306],
    'sobra': [4.485, 4.669, 6.374],
    'sobremesa': [3.608, 4.865, 4.595],
    'sobrenombre': [4.95, 2.623, 3.95],
    'sobres': [4.676, 5.6979999999999995, 6.178999999999999],
    'sobresaltado': [4.371, 5.1370000000000005, 3.755],
    'sobresalto': [4.178, 4.641, 4.251],
    'sobrevivir': [4.534, 4.335, 5.766],
    'sobrina': [6.0489999999999995, 4.331, 5.358],
    'socialismo': [4.407, 3.438, 4.107],
    'socialista': [5.252000000000001, 4.352, 5.781000000000001],
    'sociedad': [4.147, 4.191, 5.63],
    'socio': [5.132999999999999, 3.803, 5.143],
    'sociología': [4.457, 3.738, 5.865],
    'sociólogo': [5.894, 3.9610000000000003, 4.8839999999999995],
    'socorro': [3.875, 4.546, 5.052],
    'soda': [5.077, 4.375, 4.23],
    'sodio': [5.724, 2.863, 3.971],
    'sofisticación': [2.91, 3.147, 4.66],
    'sofá': [6.7139999999999995, 6.0760000000000005, 6.531000000000001],
    'soga': [5.113, 6.002999999999999, 4.513],
    'sol': [6.157, 6.526, 6.652],
    'solapa': [5.247000000000001, 5.957999999999999, 4.342],
    'solar': [5.239, 4.739, 5.586],
    'soldado': [6.042999999999999, 5.928999999999999, 5.577000000000001],
    'soledad': [4.604, 4.812, 5.2860000000000005],
    'solemnidad': [3.468, 3.0069999999999997, 2.2840000000000003],
    'solicitud': [4.622, 4.16, 5.225],
    'solidaridad': [3.759, 3.97, 5.1579999999999995],
    'solidez': [3.7030000000000003, 3.157, 3.9139999999999997],
    'solitaria': [4.516, 4.446000000000001, 5.422000000000001],
    'solitario': [4.372, 5.026, 6.287999999999999],
    'sollozos': [4.677, 5.649, 4.19],
    'soltar': [4.317, 5.155, 5.611000000000001],
    'soltera': [6.34, 4.709, 5.605],
    'soltero': [5.773, 3.8339999999999996, 5.858],
    'solterona': [5.8629999999999995, 5.386, 5.081],
    'soltura': [3.9960000000000004, 2.8280000000000003, 3.887],
    'solucionar': [4.05, 3.5380000000000003, 6.395],
    'solución': [4.452, 4.02, 6.445],
    'sombra': [5.483, 6.045, 5.687],
    'sombrero': [5.9270000000000005, 6.559, 3.2430000000000003],
    'sombrilla': [5.727, 5.471, 5.2620000000000005],
    'someter': [2.9330000000000003, 3.295, 4.177],
    'someterse': [3.7319999999999998, 2.7119999999999997, 4.655],
    'somnolencia': [4.478, 4.3839999999999995, 3.779],
    'sonda': [4.223, 5.002, 4.338],
    'soneto': [5.415, 4.306, 4.063],
    'sonido': [4.119, 4.658, 6.331],
    'sonreír': [5.925, 5.507000000000001, 5.678999999999999],
    'sonrisa': [5.662999999999999, 6.216, 6.2],
    'sopa': [6.164, 6.227, 6.402],
    'soplo': [3.96, 4.677, 3.779],
    'sopor': [4.641, 2.9610000000000003, 3.281],
    'soportar': [3.673, 2.865, 5.832999999999999],
    'soporte': [4.027, 4.846, 5.245],
    'sorbo': [4.743, 4.691, 4.895],
    'sorda': [5.521, 4.85, 6.011],
    'sordera': [5.132999999999999, 4.083, 6.26],
    'sordo': [5.706, 5.0760000000000005, 6.153],
    'sorprender': [3.6919999999999997, 4.431, 6.097],
    'sorpresa': [4.207, 5.229, 6.3870000000000005],
    'sosiego': [3.985, 3.5869999999999997, 3.363],
    'sospecha': [3.9930000000000003, 3.009, 5.617000000000001],
    'sospechar': [4.331, 3.628, 5.624],
    'sospechosa': [4.275, 3.714, 5.4639999999999995],
    'sospechoso': [4.383, 2.957, 5.285],
    'sostener': [3.8569999999999998, 4.136, 5.654],
    'sostén': [5.63, 5.157, 5.952999999999999],
    'sotana': [6.265, 5.851, 4.833],
    'soviética': [4.8660000000000005, 4.3919999999999995, 4.561],
    'soviético': [5.85, 5.0680000000000005, 4.162],
    'soñador': [4.729, 3.154, 5.392],
    'soñar': [4.779, 5.189, 6.084],
    'suavidad': [3.6660000000000004, 5.303, 6.0],
    'subconjunto': [3.98, 2.983, 3.56],
    'subconsciente': [3.8360000000000003, 1.979, 5.581],
    'subida': [4.123, 4.909, 6.313],
    'subir': [4.412, 5.814, 6.6739999999999995],
    'subirse': [4.377, 4.6080000000000005, 6.057],
    'subjetividad': [2.614, 1.5119999999999998, 4.813],
    'subjetivismo': [2.8480000000000003, 2.741, 4.723],
    'sublevación': [4.209, 4.081, 4.061],
    'subrayar': [5.2139999999999995, 5.231, 6.2],
    'subsistencia': [4.205, 2.49, 4.484],
    'substancia': [2.906, 2.359, 4.379],
    'substrato': [3.678, 3.05, 3.391],
    'subteniente': [5.977, 3.7910000000000004, 3.029],
    'subterránea': [5.186, 4.513, 5.122000000000001],
    'subterráneos': [5.465, 5.9639999999999995, 5.09],
    'suburbio': [4.6160000000000005, 5.251, 3.648],
    'subvenciones': [4.131, 3.2769999999999997, 5.167999999999999],
    'suceder': [2.908, 2.6519999999999997, 5.604],
    'sucesión': [3.7460000000000004, 2.9360000000000004, 4.777],
    'suceso': [3.758, 3.6189999999999998, 4.938],
    'sucesor': [5.16, 3.904, 5.511],
    'suciedad': [4.984, 6.332999999999999, 4.763999999999999],
    'sucursal': [4.995, 4.458, 4.994],
    'sudar': [6.316, 5.187, 6.261],
    'sudor': [6.02, 5.946000000000001, 6.442],
    'sueco': [5.382999999999999, 4.982, 5.237],
    'suegra': [6.608, 4.279, 5.111000000000001],
    'suela': [5.617000000000001, 6.337999999999999, 5.622000000000001],
    'sueldo': [5.635, 4.919, 6.0329999999999995],
    'suelo': [5.492999999999999, 6.229, 6.617999999999999],
    'suero': [5.905, 4.976, 4.55],
    'sueño': [4.053999999999999, 5.127000000000001, 6.523],
    'sufrimiento': [3.511, 4.6419999999999995, 5.301],
    'sugerencia': [4.1610000000000005, 3.793, 5.395],
    'sugerir': [3.472, 2.823, 5.468],
    'sugestión': [2.6919999999999997, 2.741, 4.869],
    'suicida': [5.403, 4.556, 4.769],
    'suicidio': [6.568, 5.388999999999999, 4.6160000000000005],
    'sujetador': [5.392, 5.4079999999999995, 6.101],
    'sujetar': [5.093999999999999, 4.658, 6.385],
    'sujeto': [4.888999999999999, 5.023, 6.237],
    'sultán': [5.848, 5.059, 3.6],
    'suma': [4.845, 4.71, 5.914],
    'sumar': [4.931, 4.873, 6.4110000000000005],
    'sumarse': [3.3310000000000004, 3.533, 5.815],
    'sumergirse': [3.863, 5.8389999999999995, 4.175],
    'suministro': [4.207, 3.4939999999999998, 3.7319999999999998],
    'superación': [3.322, 3.069, 5.138],
    'superar': [3.2089999999999996, 3.241, 5.507999999999999],
    'superconductividad': [3.832, 2.449, 2.605],
    'superdotado': [5.336, 3.733, 5.035],
    'superficie': [3.92, 4.702, 5.396],
    'superintendente': [4.9319999999999995, 4.253, 2.6919999999999997],
    'superior': [3.7960000000000003, 3.605, 4.887],
    'superiora': [4.601, 4.125, 2.655],
    'superioridad': [4.06, 4.001, 4.5280000000000005],
    'supermercado': [5.522, 6.617999999999999, 6.501],
    'superstición': [4.4910000000000005, 3.437, 5.2589999999999995],
    'supervivencia': [4.971, 3.6519999999999997, 4.5089999999999995],
    'suplemento': [3.6180000000000003, 3.2310000000000003, 5.074],
    'suplicio': [3.675, 3.446, 3.641],
    'suplir': [3.592, 2.63, 3.719],
    'suponer': [3.612, 2.847, 6.226],
    'suposición': [2.928, 2.077, 4.001],
    'suprema': [3.075, 2.5869999999999997, 3.5989999999999998],
    'supremo': [3.693, 3.429, 5.3260000000000005],
    'suprimir': [4.482, 3.397, 4.744],
    'supuesto': [2.549, 1.974, 5.004],
    'sur': [5.065, 4.322, 5.684],
    'surco': [4.64, 4.994, 4.128],
    'suscitar': [3.148, 2.333, 4.315],
    'suspender': [5.015, 5.77, 5.961],
    'suspenso': [5.084, 4.867, 6.556],
    'suspiro': [5.449, 4.94, 5.324],
    'sustancia': [2.568, 3.878, 5.747000000000001],
    'sustantivo': [4.033, 3.2430000000000003, 4.218],
    'sustento': [3.7310000000000003, 3.972, 3.965],
    'sustituir': [4.05, 2.9760000000000004, 5.584],
    'susto': [4.868, 4.984, 6.096],
    'sustrato': [3.18, 2.109, 3.457],
    'susurro': [5.1160000000000005, 5.101, 6.016],
    'sutileza': [3.335, 2.206, 3.627],
    'sábado': [6.6129999999999995, 4.909, 6.4510000000000005],
    'sábana': [5.9, 6.446000000000001, 6.261],
    'sátira': [4.766, 3.514, 5.218],
    'sífilis': [5.836, 2.9160000000000004, 3.8810000000000002],
    'sílabas': [5.247999999999999, 4.666, 5.768],
    'símbolo': [3.27, 4.974, 5.106],
    'síndrome': [3.832, 2.992, 4.757],
    'síntesis': [3.657, 2.8289999999999997, 4.823],
    'síntoma': [5.2170000000000005, 3.293, 5.6370000000000005],
    'sólido': [4.7589999999999995, 5.195, 4.774],
    'sótano': [6.485, 5.742999999999999, 5.7379999999999995],
    'súbditos': [4.1160000000000005, 4.51, 4.308],
    'súplica': [4.553999999999999, 3.8280000000000003, 5.529],
    'tabaco': [6.097, 5.983, 5.569],
    'taberna': [5.702999999999999, 6.103, 4.706],
    'tabernero': [5.82, 5.614, 4.283],
    'tabique': [6.103, 4.822, 4.913],
    'tabla': [4.948, 4.836, 5.829],
    'tablero': [4.843999999999999, 5.7620000000000005, 4.7139999999999995],
    'taburete': [6.1370000000000005, 5.859, 4.914],
    'tabú': [4.019, 3.1719999999999997, 4.832],
    'tacha': [3.6719999999999997, 4.6, 3.7710000000000004],
    'tachar': [4.96, 5.78, 5.956],
    'taco': [3.279, 5.184, 5.494],
    'tacto': [4.044, 4.5089999999999995, 4.758],
    'tacón': [5.54, 6.103, 6.2],
    'tajo': [4.583, 4.7139999999999995, 3.1060000000000003],
    'talante': [3.824, 2.8310000000000004, 3.64],
    'talego': [4.398, 4.518, 4.371],
    'talla': [4.3839999999999995, 3.4219999999999997, 5.5889999999999995],
    'taller': [5.252000000000001, 5.874, 5.642],
    'talones': [5.487, 5.112, 5.247999999999999],
    'tamaño': [3.455, 3.457, 6.272],
    'tambor': [6.153, 6.212999999999999, 5.712000000000001],
    'tango': [6.035, 5.319, 5.47],
    'tanque': [5.222, 5.992999999999999, 5.28],
    'tapa': [4.888, 5.356, 5.627999999999999],
    'tapar': [4.864, 4.899, 6.239],
    'tapete': [5.377000000000001, 5.9110000000000005, 4.458],
    'tapia': [5.489, 4.962, 4.574],
    'tapicería': [5.712000000000001, 5.611000000000001, 5.172999999999999],
    'tapiz': [5.233, 5.406000000000001, 4.078],
    'tapón': [5.8660000000000005, 5.932, 6.129],
    'taquilla': [5.813, 5.747999999999999, 6.056],
    'tardar': [3.7, 3.964, 6.5520000000000005],
    'tarde': [3.5980000000000003, 5.115, 6.6160000000000005],
    'tarea': [3.677, 4.391, 5.875],
    'tarima': [5.691, 5.622000000000001, 3.633],
    'tarjeta': [4.607, 5.24, 6.475],
    'tarta': [6.361000000000001, 6.336, 6.239],
    'tasa': [3.5469999999999997, 2.204, 5.078],
    'tata': [4.468999999999999, 4.133, 3.219],
    'tatarabuela': [5.6739999999999995, 4.572, 3.697],
    'taxi': [6.318, 6.654, 6.067],
    'taxista': [5.9910000000000005, 5.62, 6.581],
    'taza': [5.9910000000000005, 5.341, 6.412999999999999],
    'teatro': [6.034, 6.03, 5.915],
    'tebeos': [5.845, 6.314, 5.843999999999999],
    'techo': [5.676, 5.872999999999999, 6.524],
    'tecnología': [3.595, 3.877, 5.791],
    'tedio': [4.3580000000000005, 3.375, 3.265],
    'tejado': [5.58, 6.1370000000000005, 5.702000000000001],
    'tejas': [5.733, 6.45, 5.3020000000000005],
    'tejer': [4.809, 5.994, 4.391],
    'tejido': [5.012, 5.186, 5.218999999999999],
    'tela': [5.559, 6.156000000000001, 5.7829999999999995],
    'tele': [6.031000000000001, 6.34, 6.497999999999999],
    'telefónica': [5.5, 4.907, 6.082999999999999],
    'telegrama': [5.962000000000001, 6.337999999999999, 5.64],
    'telescopio': [6.525, 5.551, 4.9110000000000005],
    'televisión': [6.235, 6.377000000000001, 6.42],
    'televisor': [6.224, 6.535, 6.728],
    'teléfono': [6.42, 6.723, 6.954],
    'telégrafo': [6.021, 4.622, 5.2989999999999995],
    'telón': [5.617000000000001, 6.154, 4.638],
    'tema': [3.445, 4.453, 6.58],
    'temblor': [4.81, 5.303999999999999, 5.336],
    'temer': [3.835, 3.748, 6.087000000000001],
    'temerario': [4.592, 3.8169999999999997, 4.992],
    'temor': [2.71, 3.555, 6.086],
    'temperamento': [4.032, 4.011, 5.417999999999999],
    'temperatura': [5.2170000000000005, 4.41, 5.996],
    'tempestad': [4.89, 5.369, 4.812],
    'temple': [3.514, 2.824, 3.165],
    'templo': [5.96, 5.881, 5.636],
    'temporada': [3.815, 3.21, 4.79],
    'temporal': [3.9139999999999997, 4.465, 5.306],
    'temática': [3.282, 2.642, 4.646],
    'tendencia': [2.685, 2.175, 5.303],
    'tender': [4.149, 4.813, 5.944],
    'tendido': [3.548, 5.257000000000001, 4.004],
    'tenedor': [6.292000000000001, 6.412999999999999, 6.14],
    'tener': [3.603, 3.2239999999999998, 6.331],
    'teniente': [5.81, 5.381, 3.505],
    'tenis': [6.018, 5.495, 6.1579999999999995],
    'tenor': [5.157, 6.107, 4.664],
    'tensión': [3.4139999999999997, 3.66, 4.998],
    'tentación': [3.764, 3.918, 5.608],
    'tentativa': [3.7769999999999997, 2.61, 3.423],
    'teología': [4.763, 2.8080000000000003, 3.98],
    'teorema': [4.475, 2.6039999999999996, 4.016],
    'teoría': [3.636, 2.9019999999999997, 6.556],
    'terciopelo': [5.771, 5.994, 5.23],
    'terminal': [3.4210000000000003, 4.238, 5.189],
    'terminar': [3.4330000000000003, 4.053, 6.609],
    'terminología': [3.1260000000000003, 2.224, 4.495],
    'ternura': [3.412, 4.798, 5.471],
    'terraza': [6.025, 5.859, 6.129],
    'terreno': [3.9789999999999996, 5.446000000000001, 5.959],
    'territorio': [4.228, 4.246, 5.034],
    'terror': [3.801, 4.643, 4.763],
    'terrorismo': [4.663, 5.257000000000001, 5.678],
    'terroristas': [5.541, 6.032, 5.928],
    'tertulia': [5.023, 5.706, 4.064],
    'tesis': [5.144, 3.305, 4.412],
    'tesitura': [3.642, 2.225, 2.657],
    'tesoro': [5.059, 5.78, 4.6739999999999995],
    'test': [5.3389999999999995, 5.987, 6.013999999999999],
    'testamento': [5.527, 5.188, 4.625],
    'testimonio': [4.561, 4.001, 4.848],
    'testículos': [6.334, 5.995, 4.887],
    'tesón': [4.628, 2.7689999999999997, 3.713],
    'tetas': [6.2170000000000005, 5.712999999999999, 5.848],
    'textura': [4.035, 4.211, 4.532],
    'teólogos': [5.756, 4.296, 3.072],
    'teórica': [4.145, 3.463, 6.305],
    'teórico': [4.199, 3.752, 4.663],
    'tibias': [3.62, 3.7880000000000003, 3.8510000000000004],
    'tiburones': [5.91, 5.968, 5.013],
    'tic': [4.919, 5.122999999999999, 4.959],
    'tiempo': [3.2910000000000004, 3.2689999999999997, 6.33],
    'tienda': [4.8069999999999995, 6.409, 6.609],
    'tierra': [5.68, 6.5120000000000005, 6.36],
    'tigre': [6.489, 6.3629999999999995, 5.535],
    'tijeras': [6.455, 6.254, 6.593],
    'timbre': [5.513, 6.132999999999999, 5.7010000000000005],
    'timidez': [3.7560000000000002, 3.615, 5.294],
    'timo': [4.104, 3.77, 3.7089999999999996],
    'timonel': [5.4910000000000005, 4.2989999999999995, 3.767],
    'timón': [6.005, 5.933, 4.9639999999999995],
    'tinglado': [2.875, 4.209, 3.674],
    'tiniebla': [4.857, 4.723, 4.053999999999999],
    'tinta': [5.593, 4.985, 6.11],
    'tinte': [5.419, 6.278, 5.4239999999999995],
    'tinto': [5.006, 5.275, 5.853],
    'tipo': [2.186, 2.597, 4.72],
    'tira': [3.407, 5.077, 5.754],
    'tirada': [3.478, 4.105, 4.493],
    'tirano': [4.665, 4.479, 3.716],
    'tirantes': [5.749, 5.485, 5.392],
    'tiranía': [4.736000000000001, 4.043, 4.0569999999999995],
    'tirar': [4.3180000000000005, 5.263999999999999, 6.71],
    'tiro': [5.227, 4.942, 5.295],
    'tirones': [4.191, 4.4639999999999995, 4.335],
    'titulada': [4.2219999999999995, 3.155, 5.843999999999999],
    'titulado': [3.9389999999999996, 3.752, 5.046],
    'titular': [3.7939999999999996, 2.84, 5.934],
    'toalla': [6.397, 6.367000000000001, 6.598],
    'tobillos': [6.269, 6.22, 6.343],
    'tocadiscos': [6.569, 6.358, 5.686],
    'tocador': [5.104, 5.74, 3.966],
    'tocar': [4.09, 5.421, 5.577000000000001],
    'todopoderoso': [4.08, 3.798, 3.528],
    'toldo': [5.944, 6.188, 5.452999999999999],
    'tolerancia': [3.253, 2.929, 5.159],
    'toma': [3.182, 3.3680000000000003, 5.2139999999999995],
    'tomarse': [3.3789999999999996, 3.313, 5.4639999999999995],
    'tomate': [6.416, 6.627999999999999, 6.402],
    'tomo': [4.051, 5.2139999999999995, 4.598],
    'tonadilla': [3.924, 3.6919999999999997, 2.258],
    'tonalidad': [3.4139999999999997, 3.109, 4.622],
    'toneladas': [5.422000000000001, 3.867, 5.1339999999999995],
    'tono': [3.99, 3.984, 5.13],
    'tonta': [4.547, 5.099, 6.268],
    'tontería': [3.7030000000000003, 3.72, 6.553],
    'toparse': [3.923, 4.055, 4.498],
    'tope': [4.126, 4.28, 5.812],
    'topografía': [5.5329999999999995, 3.488, 4.48],
    'toque': [3.694, 3.9, 5.101],
    'torbellino': [4.689, 5.146, 2.895],
    'torero': [6.019, 6.107, 5.361000000000001],
    'tormenta': [5.334, 6.346, 6.586],
    'tormento': [3.573, 3.972, 4.662],
    'torno': [4.857, 3.738, 3.185],
    'toro': [6.263999999999999, 5.858, 5.523],
    'torpeza': [3.931, 3.9160000000000004, 5.3],
    'torre': [5.7170000000000005, 6.138999999999999, 5.814],
    'torrente': [5.142, 4.928, 4.486000000000001],
    'torso': [5.147, 3.926, 3.241],
    'torta': [4.198, 5.757999999999999, 5.195],
    'tortilla': [5.843999999999999, 5.9910000000000005, 6.183],
    'tortuga': [6.692, 6.417999999999999, 6.287000000000001],
    'tos': [5.979, 5.414, 6.055],
    'tostadas': [5.877999999999999, 5.6160000000000005, 5.85],
    'total': [3.813, 2.861, 5.456],
    'totalidad': [3.35, 3.4989999999999997, 4.67],
    'trabajador': [5.0089999999999995, 5.4479999999999995, 6.511],
    'trabajar': [4.449, 5.169, 6.132999999999999],
    'trabajo': [4.965, 5.187, 6.176],
    'tradición': [4.284, 3.074, 5.14],
    'traducción': [4.414, 4.402, 5.647],
    'traducir': [5.2170000000000005, 3.4389999999999996, 4.507],
    'traductor': [5.2410000000000005, 4.885, 5.7170000000000005],
    'traer': [3.38, 3.554, 6.535],
    'traerse': [2.714, 2.1630000000000003, 5.349],
    'tragedia': [4.088, 4.559, 5.236000000000001],
    'trago': [4.172, 4.62, 5.739],
    'traición': [3.803, 3.4339999999999997, 4.196000000000001],
    'traje': [5.318, 5.943, 6.422999999999999],
    'trajín': [3.755, 4.0760000000000005, 3.5039999999999996],
    'trama': [2.7680000000000002, 3.378, 3.9560000000000004],
    'tramo': [3.6660000000000004, 3.7030000000000003, 4.635],
    'trampa': [4.591, 4.963, 5.957000000000001],
    'trance': [3.595, 4.0089999999999995, 4.158],
    'tranquilidad': [5.012, 3.911, 6.4110000000000005],
    'transacciones': [3.375, 2.291, 3.46],
    'transcripción': [4.172, 2.9539999999999997, 4.373],
    'transcurrir': [3.47, 2.638, 3.227],
    'transcurso': [3.056, 2.455, 5.003],
    'transferencia': [3.906, 2.463, 4.795],
    'transformación': [3.0380000000000003, 3.26, 5.731],
    'transformar': [3.091, 3.2110000000000003, 5.404],
    'transformarse': [3.588, 4.1530000000000005, 4.771],
    'transfusiones': [5.436, 4.7219999999999995, 4.5680000000000005],
    'transgresión': [3.911, 1.9809999999999999, 2.545],
    'transición': [3.6719999999999997, 2.12, 4.519],
    'transistor': [5.997000000000001, 5.4, 5.593],
    'transmisión': [3.464, 2.9360000000000004, 4.665],
    'transmitir': [3.0810000000000004, 3.5, 3.9389999999999996],
    'transparencia': [4.475, 4.816, 5.905],
    'transporte': [4.872, 5.6160000000000005, 6.327999999999999],
    'tranvía': [6.1129999999999995, 6.001, 4.765],
    'trapo': [5.149, 6.0489999999999995, 4.738],
    'trascendencia': [2.784, 1.9769999999999999, 4.794],
    'trasera': [3.409, 4.216, 4.948],
    'trasfondo': [4.297, 2.531, 4.11],
    'trasladado': [4.662, 3.385, 4.684],
    'trasladar': [3.153, 3.864, 5.492000000000001],
    'trasladarse': [4.422, 5.013, 6.106],
    'traslado': [4.279, 4.109, 5.765],
    'traspasar': [3.66, 3.58, 5.204],
    'trastienda': [5.671, 4.883, 3.497],
    'trastornos': [3.495, 4.02, 5.916],
    'trasvase': [3.78, 3.0580000000000003, 3.214],
    'tratado': [3.6710000000000003, 3.1689999999999996, 4.609],
    'tratamiento': [3.67, 3.945, 5.205],
    'tratar': [3.216, 2.793, 5.414],
    'tratarse': [2.687, 2.623, 5.6610000000000005],
    'trato': [3.681, 3.355, 5.61],
    'trauma': [3.748, 4.038, 5.316],
    'travesía': [4.998, 4.687, 4.001],
    'trayecto': [4.689, 4.481, 5.223],
    'trayectoria': [3.6689999999999996, 4.45, 5.752000000000001],
    'trazado': [4.148, 4.922, 4.312],
    'trazar': [4.163, 4.271, 5.565],
    'trecho': [3.915, 3.0839999999999996, 3.404],
    'tregua': [3.7769999999999997, 3.758, 3.404],
    'tren': [6.188, 6.528, 6.659],
    'trenza': [5.562, 6.48, 5.582000000000001],
    'trepar': [4.935, 5.655, 5.167000000000001],
    'tribu': [5.181, 5.643, 4.466],
    'tribuna': [5.191, 5.317, 4.132],
    'tribunal': [4.968, 5.85, 5.033],
    'tributo': [3.5610000000000004, 3.466, 4.143],
    'trigo': [6.412000000000001, 5.412000000000001, 4.0680000000000005],
    'trincheras': [6.207000000000001, 5.619, 3.031],
    'tripa': [6.348, 4.476, 4.828],
    'tripulación': [5.084, 4.6819999999999995, 5.196000000000001],
    'tripulantes': [5.325, 5.266, 5.226],
    'triunfar': [3.862, 5.022, 5.815],
    'triunfo': [4.56, 4.852, 5.222],
    'trivialidad': [2.5469999999999997, 2.2569999999999997, 2.556],
    'triángulo': [5.808, 5.754, 5.916],
    'trofeo': [5.6, 5.012, 3.721],
    'trompeta': [6.16, 6.31, 4.735],
    'trompicones': [4.356, 2.907, 4.445],
    'tronco': [5.001, 5.909, 5.428],
    'trono': [5.862, 5.06, 3.9789999999999996],
    'tropa': [4.471, 5.2, 3.708],
    'tropel': [4.197, 4.271, 2.384],
    'tropezar': [4.428, 5.781000000000001, 5.544],
    'tropiezo': [4.626, 5.577000000000001, 5.126],
    'trote': [4.291, 4.231, 3.17],
    'trozo': [3.835, 4.1, 6.04],
    'truco': [4.64, 3.739, 4.508],
    'trueno': [5.8839999999999995, 6.061, 5.178999999999999],
    'tráfico': [5.234, 5.877000000000001, 5.853],
    'trámite': [3.1919999999999997, 2.695, 3.8110000000000004],
    'tránsito': [3.608, 3.753, 3.762],
    'trío': [5.399, 5.632999999999999, 6.1370000000000005],
    'tuberculosis': [5.001, 3.252, 4.29],
    'tubo': [5.169, 6.013, 5.968],
    'tuerto': [6.307, 5.709, 3.122],
    'tufo': [4.931, 4.282, 5.574],
    'tumba': [5.601, 6.024, 4.877],
    'tumor': [5.415, 3.307, 4.208],
    'tumulto': [4.217, 4.1930000000000005, 3.378],
    'turba': [4.544, 3.763, 1.808],
    'turbulencia': [4.854, 4.309, 4.4239999999999995],
    'turca': [4.762, 4.205, 3.53],
    'turco': [5.956, 4.269, 3.458],
    'turismo': [4.4719999999999995, 5.311, 5.376],
    'turista': [5.441, 6.405, 5.882000000000001],
    'turno': [3.8689999999999998, 3.655, 5.3870000000000005],
    'táctica': [3.6289999999999996, 2.908, 4.395],
    'té': [6.376, 5.684, 6.199],
    'técnica': [3.588, 3.068, 4.9239999999999995],
    'técnico': [4.2330000000000005, 4.4110000000000005, 4.7860000000000005],
    'término': [3.708, 2.865, 4.795],
    'tía': [4.737, 5.456, 6.336],
    'tío': [5.2620000000000005, 5.292000000000001, 6.867999999999999],
    'título': [4.796, 4.479, 6.284],
    'tópico': [2.7030000000000003, 2.233, 4.266],
    'tórax': [6.444, 5.443, 4.41],
    'túnel': [6.031000000000001, 6.207000000000001, 6.497000000000001],
    'túnica': [5.281000000000001, 5.79, 3.4010000000000002],
    'ubicación': [3.7289999999999996, 3.199, 3.693],
    'umbral': [3.903, 3.077, 5.005],
    'unanimidad': [3.705, 2.484, 4.213],
    'unidad': [4.5280000000000005, 4.548, 5.871],
    'unificación': [3.432, 3.136, 4.437],
    'uniforme': [4.928, 5.938, 3.218],
    'uniformidad': [3.633, 2.675, 3.2569999999999997],
    'unir': [4.338, 5.061, 6.256],
    'unirse': [3.728, 4.225, 5.354],
    'universalidad': [3.455, 3.682, 5.318],
    'universidad': [6.085, 6.231, 6.638999999999999],
    'universitaria': [5.357, 6.246, 6.636],
    'universitarios': [5.492000000000001, 5.6579999999999995, 6.562],
    'universo': [3.862, 5.098, 5.027],
    'unión': [3.986, 5.003, 6.0729999999999995],
    'uranio': [5.111000000000001, 3.103, 3.1889999999999996],
    'urbanidad': [3.747, 4.206, 3.475],
    'urbanismo': [4.325, 3.21, 4.797],
    'urbanización': [4.583, 5.422999999999999, 5.4270000000000005],
    'urbano': [4.292, 4.485, 5.053999999999999],
    'urgencia': [5.093999999999999, 4.647, 5.329],
    'urraca': [5.501, 3.8960000000000004, 3.515],
    'usar': [2.401, 3.537, 6.593999999999999],
    'uso': [2.245, 2.86, 5.7010000000000005],
    'usuario': [4.349, 4.085, 4.888999999999999],
    'utensilios': [3.2569999999999997, 4.6819999999999995, 4.877],
    'utilidad': [3.8510000000000004, 2.255, 5.026],
    'utilitarismo': [3.222, 2.267, 2.781],
    'utilización': [3.168, 2.8689999999999998, 5.36],
    'utilizar': [3.463, 3.155, 6.25],
    'utopía': [3.3, 2.503, 4.033],
    'uña': [6.332999999999999, 6.609, 6.343999999999999],
    'vaca': [6.499, 6.023, 6.122999999999999],
    'vacaciones': [5.687, 4.893, 5.67],
    'vaciar': [4.565, 4.968, 6.595],
    'vacilación': [3.022, 2.81, 3.233],
    'vacilar': [3.281, 3.682, 5.796],
    'vacuna': [4.917, 4.574, 5.803],
    'vacío': [3.451, 3.685, 6.077000000000001],
    'vaga': [4.449, 4.303, 5.9479999999999995],
    'vagabundo': [5.672000000000001, 6.362, 6.096],
    'vago': [3.696, 5.532, 6.004],
    'vagón': [5.867000000000001, 6.086, 5.655],
    'vaho': [5.151, 4.933, 5.086],
    'vaina': [5.127000000000001, 4.324, 3.617],
    'vale': [2.8139999999999996, 3.14, 5.694],
    'valenciana': [5.76, 4.2989999999999995, 5.167999999999999],
    'valenciano': [5.816, 4.67, 6.0],
    'valer': [3.4019999999999997, 3.281, 5.483],
    'validez': [3.677, 3.562, 4.4830000000000005],
    'valido': [4.225, 3.312, 4.4910000000000005],
    'valla': [5.901, 5.516, 5.2139999999999995],
    'valle': [5.6370000000000005, 6.148, 5.484],
    'valor': [3.2489999999999997, 3.4619999999999997, 6.189],
    'valoración': [3.302, 3.307, 5.02],
    'vals': [5.7170000000000005, 5.496, 3.9010000000000002],
    'vampiro': [5.645, 5.905, 4.282],
    'vanguardia': [3.281, 2.316, 4.435],
    'vanidad': [3.9939999999999998, 2.481, 3.659],
    'vapor': [5.125, 5.565, 5.771],
    'vaquero': [4.979, 5.678999999999999, 5.567],
    'vara': [4.678999999999999, 5.306, 5.157],
    'variable': [2.742, 2.508, 5.521],
    'variante': [2.88, 2.045, 3.687],
    'variar': [3.1239999999999997, 2.4090000000000003, 5.082],
    'variedad': [3.1839999999999997, 3.503, 5.015],
    'varillas': [4.7989999999999995, 4.712, 3.458],
    'varón': [5.676, 6.069, 5.895],
    'vasco': [4.3919999999999995, 4.7669999999999995, 4.52],
    'vasija': [5.6370000000000005, 5.654, 3.966],
    'vaso': [6.523, 6.6129999999999995, 6.22],
    'vecina': [5.815, 5.687, 6.422999999999999],
    'vecindad': [4.841, 4.971, 5.053999999999999],
    'vecindario': [4.77, 5.638999999999999, 4.578],
    'vecino': [5.827000000000001, 5.751, 6.8],
    'vegetación': [3.8169999999999997, 5.949, 5.572],
    'vegetal': [4.008, 5.1610000000000005, 5.952000000000001],
    'vehemencia': [4.263999999999999, 2.381, 3.6069999999999998],
    'vehículo': [5.347, 6.381, 6.104],
    'vejez': [4.914, 5.678999999999999, 5.207999999999999],
    'vela': [5.098, 5.781000000000001, 5.815],
    'velada': [4.448, 4.716, 4.137],
    'velar': [3.61, 3.6010000000000004, 4.7010000000000005],
    'velo': [5.63, 6.111000000000001, 3.5069999999999997],
    'velocidad': [4.508, 5.162999999999999, 6.058],
    'vena': [5.532, 5.875, 4.998],
    'vencedor': [4.603, 4.883, 5.021],
    'vencer': [4.111000000000001, 4.512, 5.266],
    'vendedor': [4.5360000000000005, 5.602, 6.409],
    'veneno': [4.475, 4.547, 5.08],
    'veneración': [3.823, 2.952, 2.734],
    'venganza': [3.2960000000000003, 3.3960000000000004, 5.454],
    'vengarse': [4.896, 2.678, 5.406000000000001],
    'venir': [4.169, 3.717, 5.831],
    'venta': [3.807, 4.273, 6.202000000000001],
    'ventaja': [4.093, 3.139, 5.832999999999999],
    'ventana': [6.077000000000001, 6.518, 6.821000000000001],
    'ventanal': [6.0760000000000005, 5.88, 5.931],
    'ventanilla': [6.0120000000000005, 4.747, 5.956],
    'ventilador': [6.27, 5.947, 5.678],
    'ver': [4.419, 4.046, 6.751],
    'vera': [3.639, 3.69, 3.054],
    'veracidad': [3.5069999999999997, 2.8110000000000004, 5.377999999999999],
    'verano': [5.212999999999999, 5.968, 6.8229999999999995],
    'verbena': [5.644, 5.7829999999999995, 5.523],
    'verbo': [4.274, 3.2889999999999997, 5.524],
    'verdad': [3.095, 2.085, 6.718],
    'verdugo': [5.86, 5.417999999999999, 3.778],
    'verduras': [4.58, 5.895, 6.111000000000001],
    'veredicto': [5.24, 3.7680000000000002, 4.602],
    'vergüenza': [3.4589999999999996, 3.714, 6.143],
    'verificar': [4.2410000000000005, 3.181, 4.35],
    'verja': [5.441, 5.321000000000001, 4.95],
    'verse': [3.804, 4.32, 5.756],
    'versión': [3.0239999999999996, 2.52, 5.294],
    'verso': [5.055, 5.375, 4.698],
    'vertebrados': [4.995, 4.865, 4.678999999999999],
    'vertical': [4.896, 5.646, 5.96],
    'vertiente': [3.1839999999999997, 2.991, 4.026],
    'vestiduras': [4.518, 4.502, 3.217],
    'vestigios': [3.4219999999999997, 3.786, 2.371],
    'vestir': [4.543, 4.999, 5.805],
    'vestirse': [5.742000000000001, 5.781000000000001, 6.4079999999999995],
    'vestíbulo': [5.372000000000001, 5.477, 4.638],
    'veteranos': [5.029, 4.355, 4.944],
    'veterinario': [6.101, 6.002999999999999, 5.593],
    'vez': [2.9960000000000004, 2.1390000000000002, 6.07],
    'viajar': [5.289, 6.18, 6.487],
    'viaje': [5.058, 5.011, 6.532],
    'viajero': [5.731, 5.586, 5.287000000000001],
    'vibración': [3.903, 4.504, 4.1],
    'vicepresidente': [5.946000000000001, 4.459, 5.038],
    'vicio': [3.147, 4.386, 6.19],
    'victoria': [3.8689999999999998, 4.167, 3.767],
    'vida': [3.822, 4.093999999999999, 6.544],
    'vidriera': [5.265, 5.252000000000001, 4.7010000000000005],
    'vidrio': [5.319, 5.587000000000001, 5.277],
    'vieja': [4.8260000000000005, 6.024, 5.925],
    'viejo': [5.143, 6.07, 6.257999999999999],
    'viento': [5.255, 5.968999999999999, 6.106],
    'vientre': [5.937, 5.619, 5.149],
    'viernes': [5.391, 5.2170000000000005, 6.497000000000001],
    'viga': [5.591, 5.63, 5.297000000000001],
    'vigilancia': [4.6419999999999995, 3.969, 5.593],
    'vigilante': [5.569, 5.66, 5.81],
    'vigilia': [4.76, 3.926, 5.268],
    'vigor': [3.391, 2.909, 3.8110000000000004],
    'vil': [4.129, 3.196, 2.539],
    'villa': [5.235, 4.982, 4.367],
    'villancicos': [5.495, 5.355, 5.1160000000000005],
    'villanos': [4.619, 4.984, 2.9210000000000003],
    'vinagre': [6.672999999999999, 6.093999999999999, 5.197],
    'vinculación': [3.553, 2.568, 3.698],
    'vino': [5.676, 6.157, 6.419],
    'violación': [4.718999999999999, 5.553, 5.84],
    'violador': [5.358, 4.735, 4.893],
    'violar': [4.688, 4.663, 5.746],
    'violencia': [4.022, 5.705, 5.973],
    'violín': [6.321000000000001, 6.398, 5.94],
    'virgen': [4.628, 5.555, 5.436],
    'virginidad': [4.409, 3.2689999999999997, 5.872000000000001],
    'virtud': [3.358, 3.489, 5.016],
    'viruela': [5.65, 3.9539999999999997, 3.9010000000000002],
    'visillos': [6.099, 6.023, 4.504],
    'visita': [4.556, 5.095, 6.149],
    'visitadores': [3.529, 4.265, 4.012],
    'visitante': [4.399, 5.231, 4.238],
    'visitar': [4.132, 4.421, 6.345],
    'visión': [4.345, 4.373, 6.194],
    'visos': [2.764, 2.371, 1.984],
    'vista': [4.918, 4.64, 6.209],
    'vistazo': [3.516, 3.875, 6.002999999999999],
    'vitalidad': [3.7489999999999997, 4.406000000000001, 4.868],
    'vitaminas': [5.417999999999999, 3.9589999999999996, 6.23],
    'vitrina': [5.486000000000001, 4.881, 4.462],
    'viuda': [5.962000000000001, 4.922, 5.437],
    'viudo': [6.395, 5.417000000000001, 6.159],
    'vivencias': [2.616, 3.5010000000000003, 4.442],
    'vivienda': [5.45, 6.172000000000001, 4.854],
    'viviente': [4.381, 3.947, 5.412999999999999],
    'vivir': [4.059, 5.744, 7.0],
    'vizcainos': [5.544, 3.466, 2.8339999999999996],
    'vocablo': [4.624, 3.031, 4.381],
    'vocabulario': [4.696000000000001, 2.989, 6.156000000000001],
    'vocación': [4.021, 2.528, 5.561],
    'vocales': [4.871, 5.414, 6.007000000000001],
    'vodka': [6.484, 5.9639999999999995, 5.235],
    'volante': [5.224, 6.5089999999999995, 6.225],
    'volar': [5.479, 4.968999999999999, 5.322],
    'volcán': [6.195, 6.167000000000001, 3.8819999999999997],
    'volumen': [3.755, 3.793, 5.869],
    'voluntad': [3.4960000000000004, 3.66, 5.386],
    'voluntario': [4.335, 4.913, 5.093],
    'volver': [4.242, 4.2, 6.358],
    'volverse': [3.389, 3.517, 5.65],
    'vomitar': [5.531000000000001, 5.654, 5.903],
    'votar': [4.825, 5.947, 6.1370000000000005],
    'voto': [4.917, 4.013999999999999, 5.78],
    'voz': [5.167000000000001, 4.913, 6.206],
    'vuelta': [4.021, 4.611000000000001, 6.438],
    'vulgaridad': [3.7460000000000004, 4.4239999999999995, 5.441],
    'válvulas': [4.506, 3.418, 2.983],
    'vértice': [4.8660000000000005, 4.077, 4.25],
    'vértigo': [4.405, 3.84, 5.055],
    'vía': [3.9139999999999997, 5.8020000000000005, 5.7379999999999995],
    'víctima': [5.03, 4.488, 6.212999999999999],
    'vídeo': [6.82, 5.934, 6.417000000000001],
    'vínculo': [3.728, 2.948, 3.5789999999999997],
    'víspera': [4.865, 3.05, 4.473],
    'vómitos': [5.502999999999999, 6.058, 5.7139999999999995],
    'yacimiento': [4.8839999999999995, 4.666, 2.213],
    'yanqui': [4.94, 4.791, 3.6189999999999998],
    'yate': [5.857, 6.3229999999999995, 3.556],
    'yegua': [6.185, 5.766, 5.103],
    'yema': [5.234, 4.859, 5.734],
    'yerba': [5.821000000000001, 6.535, 4.565],
    'yerma': [3.985, 3.0010000000000003, 2.11],
    'yeso': [5.6129999999999995, 5.772, 4.05],
    'zaguán': [4.106, 4.954, 2.013],
    'zanahoria': [6.667000000000001, 6.477, 5.575],
    'zanja': [5.02, 4.553999999999999, 4.212],
    'zapatillas': [6.185, 5.602, 6.516],
    'zapato': [6.48, 5.636, 6.434],
    'zarzal': [6.29, 5.22, 2.846],
    'zombi': [5.4910000000000005, 4.727, 4.815],
    'zoológico': [6.499, 5.945, 5.0],
    'zorra': [4.977, 5.564, 5.152],
    'zorro': [6.047000000000001, 6.204, 5.825],
    'zumbido': [4.587, 4.976, 4.632],
    'zumo': [5.228, 6.61, 5.55],
    'ácido': [5.2170000000000005, 5.11, 5.39],
    'águila': [6.406000000000001, 5.591, 4.444],
    'álamos': [5.685, 4.1930000000000005, 4.419],
    'álbum': [5.4479999999999995, 6.369, 6.053],
    'ámbar': [5.153, 5.1579999999999995, 3.4939999999999998],
    'ámbito': [2.421, 1.962, 4.508],
    'ángel': [5.058, 5.38, 5.712000000000001],
    'ángulo': [4.934, 4.945, 4.598],
    'ánimo': [2.983, 4.062, 6.058],
    'ánodo': [4.2139999999999995, 3.8089999999999997, 2.109],
    'ápice': [3.4560000000000004, 2.299, 2.582],
    'árabe': [5.675, 5.15, 5.712000000000001],
    'árbol': [5.921, 6.292000000000001, 6.678],
    'área': [3.074, 3.3680000000000003, 4.551],
    'átomo': [4.765, 3.9560000000000004, 3.824],
    'élite': [3.725, 3.2310000000000003, 4.372],
    'énfasis': [4.303, 3.466, 5.438],
    'épica': [3.764, 2.9419999999999997, 3.2969999999999997],
    'época': [4.169, 2.9610000000000003, 5.7589999999999995],
    'ética': [2.988, 3.522, 4.76],
    'éxito': [3.833, 3.7939999999999996, 6.268],
    'éxtasis': [4.13, 4.205, 5.189],
    'índice': [3.957, 3.912, 4.785],
    'índole': [2.423, 3.284, 3.195],
    'óleo': [5.751, 5.723, 3.312],
    'ópera': [5.646, 5.457999999999999, 4.945],
    'óptica': [5.39, 5.125, 5.782],
    'óptico': [4.863, 3.287, 4.412],
    'órbita': [4.763999999999999, 4.279, 4.886],
    'órgano': [4.7669999999999995, 5.587000000000001, 4.7669999999999995],
    'óxidos': [4.599, 3.238, 3.2439999999999998],
    'útero': [6.496, 4.854, 5.183],
    'útil': [3.307, 3.713, 6.382999999999999]
}
