"""Spanish emotion lexicon from http://www.cic.ipn.mx/~sidorov/#SEL."""

SPANISH_EMOTION_LEXICON = {
    'abundancia': (0.83, 'Alegría'),
    'acabalar': (0.396, 'Alegría'),
    'acallar': (0.198, 'Alegría'),
    'acatar': (0.198, 'Alegría'),
    'acción': (0.397, 'Alegría'),
    'aceptable': (0.594, 'Alegría'),
    'aceptación': (0.696, 'Alegría'),
    'acicate': (0.429, 'Alegría'),
    'aclamación': (0.799, 'Alegría'),
    'aclamar': (0.799, 'Alegría'),
    'acogedor': (0.83, 'Alegría'),
    'acoger': (0.729, 'Alegría'),
    'acomodadamente': (0.729, 'Alegría'),
    'acuciar': (0.264, 'Alegría'),
    'acucioso': (0.232, 'Alegría'),
    'adecuar': (0.331, 'Alegría'),
    'adicto': (0.429, 'Alegría'),
    'admirable': (0.73, 'Sorpresa'),
    'admirablemente': (0.663, 'Sorpresa'),
    'admiración': (0.764, 'Sorpresa'),
    'admirar': (0.73, 'Sorpresa'),
    'admitir': (0.53, 'Alegría'),
    'adorable': (0.898, 'Alegría'),
    'adorablemente': (0.865, 'Alegría'),
    'adoración': (0.765, 'Alegría'),
    'adorador': (0.664, 'Alegría'),
    'adorar': (0.764, 'Alegría'),
    'afable': (0.696, 'Alegría'),
    'afán': (0.764, 'Alegría'),
    'afectivo': (0.864, 'Alegría'),
    'afecto': (0.899, 'Alegría'),
    'afectuosamente': (0.966, 'Alegría'),
    'afectuosidad': (0.932, 'Alegría'),
    'afectuoso': (0.898, 'Alegría'),
    'afervorizar': (0.731, 'Alegría'),
    'afición': (0.729, 'Alegría'),
    'aficionar': (0.595, 'Alegría'),
    'afortunadamente': (0.831, 'Alegría'),
    'afortunado': (0.932, 'Alegría'),
    'agradable': (0.899, 'Alegría'),
    'agradar': (0.798, 'Alegría'),
    'agradecer': (0.763, 'Alegría'),
    'agradecido': (0.764, 'Alegría'),
    'agudeza': (0.331, 'Alegría'),
    'aguzar': (0.199, 'Alegría'),
    'ahínco': (0.73, 'Alegría'),
    'ahíto': (0.564, 'Alegría'),
    'airoso': (0.565, 'Alegría'),
    'alabar': (0.53, 'Alegría'),
    'alborozar': (0.899, 'Alegría'),
    'alborozo': (0.899, 'Alegría'),
    'alegrar': (0.966, 'Alegría'),
    'alegre': (1.0, 'Alegría'),
    'alegremente': (1.0, 'Alegría'),
    'alegría': (1.0, 'Alegría'),
    'alentar': (0.73, 'Alegría'),
    'aliviar': (0.763, 'Alegría'),
    'alivio': (0.763, 'Alegría'),
    'allegar': (0.364, 'Alegría'),
    'alma': (0.165, 'Tristeza'),
    'altivo': (0.33, 'Enojo'),
    'altruismo': (0.529, 'Alegría'),
    'alzar': (0.298, 'Alegría'),
    'amabilidad': (0.728, 'Alegría'),
    'amable': (0.762, 'Alegría'),
    'amablemente': (0.762, 'Alegría'),
    'amante': (0.731, 'Alegría'),
    'amar': (0.899, 'Alegría'),
    'amartelado': (0.966, 'Alegría'),
    'amartelar': (0.731, 'Alegría'),
    'amativo': (0.764, 'Alegría'),
    'amatorio': (0.832, 'Alegría'),
    'ambición': (0.429, 'Alegría'),
    'ambicioso': (0.363, 'Alegría'),
    'amigabilidad': (0.898, 'Alegría'),
    'amigable': (0.898, 'Alegría'),
    'amigablemente': (0.864, 'Alegría'),
    'amigo': (0.898, 'Alegría'),
    'amistad': (0.966, 'Alegría'),
    'amistosamente': (0.898, 'Alegría'),
    'amistoso': (0.966, 'Alegría'),
    'amor': (0.966, 'Alegría'),
    'amorosamente': (0.932, 'Alegría'),
    'amorosidad': (0.898, 'Alegría'),
    'amoroso': (0.898, 'Alegría'),
    'amuleto': (0.398, 'Alegría'),
    'anhelo': (0.297, 'Alegría'),
    'animación': (0.562, 'Alegría'),
    'animado': (0.865, 'Alegría'),
    'animar': (0.797, 'Alegría'),
    'ánimo': (0.099, 'Enojo'),
    'animoso': (0.83, 'Alegría'),
    'anticipar': (0.231, 'Alegría'),
    'apaciguar': (0.298, 'Alegría'),
    'apasionadamente': (0.663, 'Alegría'),
    'apasionamiento': (0.696, 'Alegría'),
    'apasionante': (0.798, 'Alegría'),
    'apego': (0.597, 'Alegría'),
    'apetecer': (0.363, 'Alegría'),
    'aplaudir': (0.797, 'Alegría'),
    'aplauso': (0.763, 'Alegría'),
    'apreciar': (0.629, 'Alegría'),
    'aprobación': (0.596, 'Alegría'),
    'aprobar': (0.664, 'Alegría'),
    'aprobatorio': (0.732, 'Alegría'),
    'aquietar': (0.165, 'Alegría'),
    'ardiente': (0.33, 'Alegría'),
    'ardor': (0.265, 'Alegría'),
    'armonía': (0.864, 'Alegría'),
    'arreglar': (0.33, 'Alegría'),
    'arrobo': (0.631, 'Alegría'),
    'arrojo': (0.363, 'Alegría'),
    'asombro': (0.966, 'Sorpresa'),
    'atracción': (0.663, 'Alegría'),
    'atractivo': (0.696, 'Alegría'),
    'atraer': (0.631, 'Alegría'),
    'atrayente': (0.53, 'Alegría'),
    'atrayentemente': (0.497, 'Alegría'),
    'autocomplacencia': (0.63, 'Alegría'),
    'autorización': (0.397, 'Alegría'),
    'autorrespeto': (0.598, 'Alegría'),
    'autosatisfacción': (0.798, 'Alegría'),
    'autosatisfecho': (0.796, 'Alegría'),
    'autosuficiencia': (0.764, 'Alegría'),
    'ávido': (0.198, 'Alegría'),
    'avivar': (0.33, 'Alegría'),
    'benefactor': (0.562, 'Alegría'),
    'beneficencia': (0.596, 'Alegría'),
    'beneficiado': (0.83, 'Alegría'),
    'beneficiar': (0.729, 'Alegría'),
    'beneficio': (0.898, 'Alegría'),
    'beneficiosamente': (0.797, 'Alegría'),
    'beneficioso': (0.864, 'Alegría'),
    'benéfico': (0.831, 'Alegría'),
    'beneplácito': (0.564, 'Alegría'),
    'benévolamente': (0.462, 'Alegría'),
    'benevolencia': (0.462, 'Alegría'),
    'benevolente': (0.528, 'Alegría'),
    'benévolo': (0.495, 'Alegría'),
    'benignamente': (0.465, 'Alegría'),
    'benigno': (0.465, 'Alegría'),
    'bien': (0.798, 'Alegría'),
    'bienandanza': (0.765, 'Alegría'),
    'bienaventurado': (0.831, 'Alegría'),
    'bienaventuranza': (0.63, 'Alegría'),
    'bienestar': (0.932, 'Alegría'),
    'bienhechor': (0.695, 'Alegría'),
    'bienquerencia': (0.729, 'Alegría'),
    'bienquerer': (0.762, 'Alegría'),
    'bizbirondo': (0.899, 'Alegría'),
    'blando': (0.198, 'Alegría'),
    'blandura': (0.132, 'Alegría'),
    'bondad': (0.696, 'Alegría'),
    'bondadosamente': (0.696, 'Alegría'),
    'bondadoso': (0.763, 'Alegría'),
    'bonhomía': (0.462, 'Alegría'),
    'brillante': (0.663, 'Alegría'),
    'brío': (0.463, 'Alegría'),
    'brioso': (0.463, 'Alegría'),
    'bromear': (0.831, 'Alegría'),
    'bueno': (0.898, 'Alegría'),
    'bullanguero': (0.664, 'Alegría'),
    'bullicioso': (0.664, 'Alegría'),
    'burla': (0.364, 'Alegría'),
    'burlar': (0.431, 'Alegría'),
    'cabal': (0.264, 'Alegría'),
    'calidez': (0.628, 'Alegría'),
    'cálido': (0.43, 'Alegría'),
    'caliente': (0.264, 'Alegría'),
    'calmado': (0.231, 'Alegría'),
    'calor': (0.099, 'Alegría'),
    'calurosamente': (0.365, 'Alegría'),
    'camaradería': (0.63, 'Alegría'),
    'campante': (0.529, 'Alegría'),
    'captivar': (0.43, 'Alegría'),
    'capturar': (0.099, 'Alegría'),
    'carcajada': (0.932, 'Alegría'),
    'caridad': (0.63, 'Alegría'),
    'cariño': (0.864, 'Alegría'),
    'cariñosamente': (0.764, 'Alegría'),
    'cariñoso': (0.83, 'Alegría'),
    'caritativo': (0.63, 'Alegría'),
    'cautivador': (0.628, 'Alegría'),
    'cautivadoramente': (0.595, 'Alegría'),
    'cautivar': (0.562, 'Alegría'),
    'celebrar': (0.933, 'Alegría'),
    'celo': (0.132, 'Alegría'),
    'celosamente': (0.066, 'Alegría'),
    'celoso': (0.033, 'Alegría'),
    'chancear': (0.698, 'Alegría'),
    'chanza': (0.598, 'Alegría'),
    'chotear': (0.665, 'Alegría'),
    'choteo': (0.564, 'Alegría'),
    'chulear': (0.629, 'Alegría'),
    'clemente': (0.264, 'Alegría'),
    'cogida': (0.199, 'Alegría'),
    'cogollo': (0.066, 'Alegría'),
    'colmar': (0.165, 'Alegría'),
    'colosal': (0.463, 'Alegría'),
    'cómodamente': (0.629, 'Alegría'),
    'comodidad': (0.662, 'Alegría'),
    'cómodo': (0.695, 'Alegría'),
    'compañerismo': (0.73, 'Alegría'),
    'compasión': (0.63, 'Tristeza'),
    'compasivo': (0.63, 'Tristeza'),
    'compatibilidad': (0.496, 'Alegría'),
    'compatible': (0.462, 'Alegría'),
    'compatiblemente': (0.363, 'Alegría'),
    'compensación': (0.331, 'Alegría'),
    'complacencia': (0.629, 'Alegría'),
    'complacer': (0.73, 'Alegría'),
    'complacible': (0.595, 'Alegría'),
    'complacido': (0.864, 'Alegría'),
    'complaciente': (0.73, 'Alegría'),
    'comprensivo': (0.562, 'Alegría'),
    'concernir': (0.066, 'Alegría'),
    'condescender': (0.363, 'Alegría'),
    'condescendiente': (0.396, 'Alegría'),
    'condimento': (0.099, 'Alegría'),
    'condolencia': (0.796, 'Tristeza'),
    'confiado': (0.297, 'Alegría'),
    'confirmación': (0.363, 'Alegría'),
    'confirmar': (0.363, 'Alegría'),
    'confort': (0.596, 'Alegría'),
    'confortable': (0.663, 'Alegría'),
    'confortablemente': (0.595, 'Alegría'),
    'confortación': (0.529, 'Alegría'),
    'confortador': (0.496, 'Alegría'),
    'confortar': (0.529, 'Alegría'),
    'confraternidad': (0.73, 'Alegría'),
    'congeniar': (0.628, 'Alegría'),
    'congraciar': (0.594, 'Alegría'),
    'congratular': (0.731, 'Alegría'),
    'conmiseración': (0.066, 'Alegría'),
    'conmover': (0.165, 'Alegría'),
    'conquista': (0.463, 'Alegría'),
    'consenso': (0.33, 'Alegría'),
    'consentimiento': (0.396, 'Alegría'),
    'consideración': (0.396, 'Alegría'),
    'considerar': (0.396, 'Alegría'),
    'consolación': (0.397, 'Alegría'),
    'consolador': (0.331, 'Alegría'),
    'consolar': (0.397, 'Alegría'),
    'consuelo': (0.43, 'Alegría'),
    'consumar': (0.364, 'Alegría'),
    'contemporizar': (0.165, 'Alegría'),
    'contentar': (0.762, 'Alegría'),
    'contento': (0.966, 'Alegría'),
    'copiosidad': (0.562, 'Alegría'),
    'copioso': (0.462, 'Alegría'),
    'corazón': (0.33, 'Alegría'),
    'cordial': (0.629, 'Alegría'),
    'cordialidad': (0.663, 'Alegría'),
    'cordialmente': (0.729, 'Alegría'),
    'cortesía': (0.695, 'Alegría'),
    'cosquillear': (0.764, 'Alegría'),
    'cosquilleo': (0.764, 'Alegría'),
    'crecer': (0.53, 'Alegría'),
    'cuidar': (0.33, 'Alegría'),
    'culminación': (0.398, 'Alegría'),
    'culto': (0.264, 'Alegría'),
    'cumplido': (0.529, 'Alegría'),
    'cumplimentar': (0.364, 'Alegría'),
    'cumplir': (0.496, 'Alegría'),
    'decorativo': (0.363, 'Alegría'),
    'dedicar': (0.462, 'Alegría'),
    'deferencia': (0.495, 'Alegría'),
    'deleitar': (0.796, 'Alegría'),
    'deléitese': (0.695, 'Alegría'),
    'delicadeza': (0.264, 'Alegría'),
    'delicado': (0.066, 'Enojo'),
    'delicia': (0.663, 'Alegría'),
    'desagraviar': (0.231, 'Alegría'),
    'desahogo': (0.363, 'Alegría'),
    'desear': (0.033, 'Enojo'),
    'desempeñar': (0.463, 'Alegría'),
    'desempeño': (0.529, 'Alegría'),
    'desenvoltura': (0.264, 'Alegría'),
    'deseoso': (0.398, 'Alegría'),
    'despenar': (0.297, 'Alegría'),
    'despertar': (0.198, 'Alegría'),
    'despreocupación': (0.563, 'Alegría'),
    'devoción': (0.497, 'Alegría'),
    'devoto': (0.463, 'Alegría'),
    'dicha': (0.731, 'Alegría'),
    'dichosamente': (0.764, 'Alegría'),
    'dichoso': (0.832, 'Alegría'),
    'dignificar': (0.462, 'Alegría'),
    'dilección': (0.563, 'Alegría'),
    'disfrutar': (0.83, 'Alegría'),
    'disfrute': (0.898, 'Alegría'),
    'divertidamente': (0.966, 'Alegría'),
    'divertidísimamente': (1.0, 'Alegría'),
    'divertido': (1.0, 'Alegría'),
    'divertir': (0.966, 'Alegría'),
    'divinizar': (0.363, 'Alegría'),
    'divino': (0.563, 'Alegría'),
    'donaire': (0.396, 'Alegría'),
    'dulce': (0.562, 'Alegría'),
    'dulzura': (0.663, 'Alegría'),
    'edificante': (0.497, 'Alegría'),
    'edificar': (0.363, 'Alegría'),
    'efusión': (0.497, 'Alegría'),
    'efusivamente': (0.73, 'Alegría'),
    'efusivo': (0.764, 'Alegría'),
    'ejemplo': (0.231, 'Alegría'),
    'elección': (0.264, 'Alegría'),
    'elegante': (0.231, 'Alegría'),
    'elevar': (0.165, 'Alegría'),
    'elogio': (0.463, 'Alegría'),
    'embebecer': (0.596, 'Alegría'),
    'embelesar': (0.596, 'Alegría'),
    'embeleso': (0.497, 'Alegría'),
    'embobar': (0.099, 'Sorpresa'),
    'emborrachar': (0.562, 'Alegría'),
    'embriagar': (0.562, 'Alegría'),
    'embromar': (0.595, 'Alegría'),
    'embrujar': (0.132, 'Alegría'),
    'embrujo': (0.099, 'Alegría'),
    'emoción': (0.798, 'Alegría'),
    'emocionante': (0.831, 'Alegría'),
    'emocionar': (0.831, 'Alegría'),
    'emotivo': (0.763, 'Alegría'),
    'empatía': (0.462, 'Alegría'),
    'empático': (0.396, 'Alegría'),
    'empeño': (0.396, 'Alegría'),
    'enaltecer': (0.496, 'Alegría'),
    'enamoramiento': (0.864, 'Alegría'),
    'enamorar': (0.831, 'Alegría'),
    'encalmar': (0.198, 'Alegría'),
    'encantado': (0.495, 'Alegría'),
    'encantador': (0.695, 'Alegría'),
    'encanto': (0.562, 'Alegría'),
    'encomiar': (0.529, 'Alegría'),
    'endiosar': (0.396, 'Alegría'),
    'energía': (0.496, 'Alegría'),
    'engrandecer': (0.53, 'Alegría'),
    'ennoblecer': (0.463, 'Alegría'),
    'enorgullecer': (0.797, 'Alegría'),
    'enternecimiento': (0.564, 'Alegría'),
    'entraña': (0.099, 'Alegría'),
    'entrañable': (0.298, 'Alegría'),
    'entrar': (0.165, 'Alegría'),
    'entregar': (0.231, 'Alegría'),
    'entusiasmado': (0.864, 'Alegría'),
    'entusiasmar': (0.83, 'Alegría'),
    'entusiasmo': (0.864, 'Alegría'),
    'entusiasta': (0.864, 'Alegría'),
    'erótico': (0.529, 'Alegría'),
    'espectacular': (0.563, 'Alegría'),
    'esperanza': (0.495, 'Alegría'),
    'esperanzado': (0.496, 'Alegría'),
    'espléndido': (0.696, 'Alegría'),
    'estimar': (0.629, 'Alegría'),
    'estimulante': (0.497, 'Alegría'),
    'estimular': (0.496, 'Alegría'),
    'estremecer': (0.628, 'Miedo'),
    'estupendo': (0.698, 'Sorpresa'),
    'euforia': (0.663, 'Alegría'),
    'eufórico': (0.663, 'Alegría'),
    'euforizante': (0.663, 'Alegría'),
    'exaltar': (0.563, 'Alegría'),
    'excelente': (0.763, 'Alegría'),
    'excitante': (0.864, 'Alegría'),
    'excitar': (0.265, 'Enojo'),
    'exhortar': (0.165, 'Alegría'),
    'éxito': (0.864, 'Alegría'),
    'expansivo': (0.363, 'Alegría'),
    'expectación': (0.264, 'Alegría'),
    'expectativa': (0.297, 'Alegría'),
    'explosión': (0.198, 'Alegría'),
    'expresión': (0.297, 'Alegría'),
    'extasiante': (0.796, 'Alegría'),
    'extasiar': (0.762, 'Alegría'),
    'extenso': (0.099, 'Alegría'),
    'exuberante': (0.396, 'Alegría'),
    'exuberantemente': (0.363, 'Alegría'),
    'exultar': (0.796, 'Alegría'),
    'familiar': (0.529, 'Alegría'),
    'familiaridad': (0.629, 'Alegría'),
    'fantasía': (0.596, 'Alegría'),
    'fascinación': (0.898, 'Alegría'),
    'fascinado': (0.898, 'Alegría'),
    'fascinante': (0.73, 'Sorpresa'),
    'fascinar': (0.731, 'Alegría'),
    'fasto': (0.265, 'Alegría'),
    'fastuoso': (0.363, 'Alegría'),
    'fausto': (0.363, 'Alegría'),
    'favor': (0.33, 'Alegría'),
    'favorable': (0.596, 'Alegría'),
    'favorablemente': (0.563, 'Alegría'),
    'favorecedor': (0.562, 'Alegría'),
    'favorecimiento': (0.562, 'Alegría'),
    'felicidad': (1.0, 'Alegría'),
    'felicitar': (0.831, 'Alegría'),
    'feliz': (0.966, 'Alegría'),
    'felizmente': (0.966, 'Alegría'),
    'feraz': (0.33, 'Alegría'),
    'fervor': (0.597, 'Alegría'),
    'fervoroso': (0.564, 'Alegría'),
    'festivo': (0.729, 'Alegría'),
    'fetiche': (0.265, 'Alegría'),
    'fibra': (0.0, 'Alegría'),
    'fidelidad': (0.43, 'Alegría'),
    'fiebre': (0.132, 'Alegría'),
    'fiel': (0.463, 'Alegría'),
    'fiesta': (0.83, 'Alegría'),
    'fijar': (0.132, 'Alegría'),
    'filantropo': (0.463, 'Alegría'),
    'final': (0.198, 'Alegría'),
    'fino': (0.198, 'Alegría'),
    'flechar': (0.297, 'Alegría'),
    'florecer': (0.595, 'Alegría'),
    'fogosidad': (0.561, 'Alegría'),
    'fraternidad': (0.595, 'Alegría'),
    'fraternizar': (0.529, 'Alegría'),
    'furor': (0.566, 'Enojo'),
    'gala': (0.297, 'Alegría'),
    'gana': (0.463, 'Alegría'),
    'ganar': (0.764, 'Alegría'),
    'generosidad': (0.628, 'Alegría'),
    'generoso': (0.628, 'Alegría'),
    'genial': (0.864, 'Alegría'),
    'gloria': (0.797, 'Alegría'),
    'gloriar': (0.562, 'Alegría'),
    'glorificar': (0.529, 'Alegría'),
    'goce': (0.763, 'Alegría'),
    'gozar': (0.831, 'Alegría'),
    'gozo': (0.831, 'Alegría'),
    'gozosamente': (0.765, 'Alegría'),
    'gozoso': (0.798, 'Alegría'),
    'gracia': (0.597, 'Alegría'),
    'gracioso': (0.83, 'Alegría'),
    'grande': (0.396, 'Alegría'),
    'grandioso': (0.63, 'Sorpresa'),
    'gratificador': (0.664, 'Alegría'),
    'gratificante': (0.697, 'Alegría'),
    'gratificar': (0.598, 'Alegría'),
    'gratis': (0.563, 'Alegría'),
    'grato': (0.663, 'Alegría'),
    'guasa': (0.429, 'Alegría'),
    'gustar': (0.596, 'Alegría'),
    'gusto': (0.629, 'Alegría'),
    'gustoso': (0.762, 'Alegría'),
    'halagar': (0.563, 'Alegría'),
    'halagüeño': (0.396, 'Alegría'),
    'hartar': (0.898, 'Enojo'),
    'hechizar': (0.231, 'Alegría'),
    'hechizo': (0.297, 'Miedo'),
    'hermandad': (0.561, 'Alegría'),
    'hilarante': (0.63, 'Alegría'),
    'hilarantemente': (0.597, 'Alegría'),
    'hilaridad': (0.664, 'Alegría'),
    'hipnotizar': (0.165, 'Alegría'),
    'holgura': (0.265, 'Alegría'),
    'honorable': (0.53, 'Alegría'),
    'honrar': (0.396, 'Alegría'),
    'honrosamente': (0.429, 'Alegría'),
    'hospitalario': (0.563, 'Alegría'),
    'hospitalidad': (0.629, 'Alegría'),
    'humanidad': (0.33, 'Alegría'),
    'humanitarismo': (0.264, 'Alegría'),
    'humor': (0.265, 'Enojo'),
    'identificar': (0.132, 'Alegría'),
    'idilio': (0.396, 'Alegría'),
    'ilusionadamente': (0.462, 'Alegría'),
    'ilusionar': (0.495, 'Alegría'),
    'impactar': (0.732, 'Sorpresa'),
    'ímpetu': (0.529, 'Alegría'),
    'impetuosidad': (0.463, 'Alegría'),
    'impresionar': (0.865, 'Sorpresa'),
    'impulsar': (0.363, 'Alegría'),
    'inclinación': (0.099, 'Alegría'),
    'inmortalizar': (0.198, 'Alegría'),
    'inspirar': (0.53, 'Alegría'),
    'interés': (0.33, 'Alegría'),
    'intoxicante': (0.066, 'Alegría'),
    'jacarero': (0.664, 'Alegría'),
    'jarana': (0.365, 'Alegría'),
    'jocoso': (0.564, 'Alegría'),
    'jocundo': (0.763, 'Alegría'),
    'jovial': (0.73, 'Alegría'),
    'júbilo': (0.83, 'Alegría'),
    'jubilosamente': (0.73, 'Alegría'),
    'jubiloso': (0.731, 'Alegría'),
    'juerga': (0.531, 'Alegría'),
    'laudable': (0.363, 'Alegría'),
    'leal': (0.463, 'Alegría'),
    'lealtad': (0.463, 'Alegría'),
    'ledamente': (0.731, 'Alegría'),
    'lenificar': (0.265, 'Alegría'),
    'lenizar': (0.199, 'Alegría'),
    'levantar': (0.198, 'Alegría'),
    'libre': (0.696, 'Alegría'),
    'lisonjero': (0.73, 'Alegría'),
    'llenar': (0.33, 'Alegría'),
    'loable': (0.33, 'Alegría'),
    'lograr': (0.663, 'Alegría'),
    'lucro': (0.198, 'Alegría'),
    'macanudo': (0.73, 'Sorpresa'),
    'magia': (0.561, 'Alegría'),
    'magnetizar': (0.132, 'Alegría'),
    'magnifíco': (0.798, 'Alegría'),
    'magno': (0.365, 'Alegría'),
    'majo': (0.429, 'Alegría'),
    'maravillar': (0.898, 'Sorpresa'),
    'maravillosamente': (0.932, 'Sorpresa'),
    'mejorar': (0.529, 'Alegría'),
    'meloso': (0.396, 'Alegría'),
    'miramiento': (0.231, 'Alegría'),
    'mirar': (0.165, 'Alegría'),
    'misericordia': (0.198, 'Alegría'),
    'mitigar': (0.165, 'Alegría'),
    'mollar': (0.099, 'Alegría'),
    'motivar': (0.597, 'Alegría'),
    'mover': (0.099, 'Alegría'),
    'oferta': (0.165, 'Alegría'),
    'opimo': (0.396, 'Alegría'),
    'opíparo': (0.396, 'Alegría'),
    'orgullo': (0.596, 'Alegría'),
    'orgullosamente': (0.697, 'Alegría'),
    'orgulloso': (0.531, 'Alegría'),
    'ovación': (0.796, 'Alegría'),
    'ovacionar': (0.663, 'Alegría'),
    'pacificar': (0.332, 'Alegría'),
    'paladear': (0.33, 'Alegría'),
    'palmas': (0.496, 'Alegría'),
    'parranda': (0.628, 'Alegría'),
    'pasión': (0.763, 'Alegría'),
    'paz': (0.63, 'Alegría'),
    'piadoso': (0.363, 'Alegría'),
    'piedad': (0.297, 'Alegría'),
    'placentero': (0.796, 'Alegría'),
    'placer': (0.864, 'Alegría'),
    'pleitesía': (0.199, 'Alegría'),
    'preferencia': (0.397, 'Alegría'),
    'prerrogativa': (0.231, 'Alegría'),
    'preservar': (0.165, 'Alegría'),
    'presumir': (0.264, 'Alegría'),
    'prever': (0.264, 'Alegría'),
    'privilegio': (0.463, 'Alegría'),
    'probar': (0.198, 'Alegría'),
    'profusión': (0.198, 'Alegría'),
    'propiciar': (0.264, 'Alegría'),
    'propicio': (0.33, 'Alegría'),
    'próspero': (0.762, 'Alegría'),
    'protectoramente': (0.231, 'Alegría'),
    'proteger': (0.231, 'Alegría'),
    'provecho': (0.463, 'Alegría'),
    'provechoso': (0.53, 'Alegría'),
    'providencial': (0.231, 'Alegría'),
    'pujanza': (0.165, 'Alegría'),
    'querer': (0.63, 'Alegría'),
    'quietud': (0.198, 'Alegría'),
    'quillotrar': (0.363, 'Alegría'),
    'radiante': (0.53, 'Alegría'),
    'ratificar': (0.132, 'Alegría'),
    'realización': (0.364, 'Alegría'),
    'realizar': (0.231, 'Alegría'),
    'recoger': (0.132, 'Alegría'),
    'recogimiento': (0.132, 'Alegría'),
    'recomendar': (0.297, 'Alegría'),
    'recompensa': (0.629, 'Alegría'),
    'reconfortante': (0.797, 'Alegría'),
    'reconfortar': (0.696, 'Alegría'),
    'recrear': (0.497, 'Alegría'),
    'refocilar': (0.563, 'Alegría'),
    'regalo': (0.764, 'Alegría'),
    'regocijadamente': (0.763, 'Alegría'),
    'regocijar': (0.696, 'Alegría'),
    'regocijo': (0.764, 'Alegría'),
    'regodear': (0.43, 'Alegría'),
    'regodeo': (0.363, 'Alegría'),
    'reidor': (0.798, 'Alegría'),
    'relamer': (0.396, 'Alegría'),
    'reparación': (0.198, 'Alegría'),
    'reproducir': (0.264, 'Alegría'),
    'respetar': (0.531, 'Alegría'),
    'respeto': (0.497, 'Alegría'),
    'respetuoso': (0.531, 'Alegría'),
    'resplandecer': (0.598, 'Alegría'),
    'reverencia': (0.364, 'Alegría'),
    'risa': (0.932, 'Alegría'),
    'risueño': (0.932, 'Alegría'),
    'romántico': (0.63, 'Alegría'),
    'saber': (0.297, 'Alegría'),
    'saborear': (0.43, 'Alegría'),
    'saciar': (0.464, 'Alegría'),
    'saciedad': (0.464, 'Alegría'),
    'sandunga': (0.629, 'Alegría'),
    'satisfacción': (0.864, 'Alegría'),
    'satisfacer': (0.83, 'Alegría'),
    'satisfacible': (0.763, 'Alegría'),
    'satisfactoriamente': (0.831, 'Alegría'),
    'satisfactorio': (0.831, 'Alegría'),
    'satisfecho': (0.864, 'Alegría'),
    'seducción': (0.529, 'Alegría'),
    'seducir': (0.496, 'Alegría'),
    'seductivo': (0.596, 'Alegría'),
    'seguro': (0.465, 'Alegría'),
    'selecto': (0.364, 'Alegría'),
    'serenar': (0.231, 'Alegría'),
    'sereno': (0.198, 'Alegría'),
    'simpatía': (0.797, 'Alegría'),
    'simpático': (0.83, 'Alegría'),
    'simpatizar': (0.83, 'Alegría'),
    'sincero': (0.397, 'Alegría'),
    'soberbio': (0.165, 'Alegría'),
    'sociable': (0.53, 'Alegría'),
    'solaz': (0.198, 'Alegría'),
    'solazar': (0.264, 'Alegría'),
    'solidaridad': (0.464, 'Alegría'),
    'sonriente': (0.966, 'Alegría'),
    'sortilegio': (0.264, 'Alegría'),
    'sosegar': (0.264, 'Alegría'),
    'suave': (0.231, 'Alegría'),
    'suavidad': (0.231, 'Alegría'),
    'subyugar': (0.099, 'Alegría'),
    'superabundancia': (0.564, 'Alegría'),
    'superabundante': (0.63, 'Alegría'),
    'suspender': (0.099, 'Alegría'),
    'terneza': (0.397, 'Alegría'),
    'ternura': (0.529, 'Alegría'),
    'tesón': (0.132, 'Alegría'),
    'tiernamente': (0.53, 'Alegría'),
    'tierno': (0.53, 'Alegría'),
    'tranquilizar': (0.364, 'Alegría'),
    'tranquilo': (0.397, 'Alegría'),
    'transportar': (0.199, 'Alegría'),
    'tratable': (0.297, 'Alegría'),
    'triunfador': (0.796, 'Alegría'),
    'triunfal': (0.796, 'Alegría'),
    'triunfalmente': (0.728, 'Alegría'),
    'triunfante': (0.796, 'Alegría'),
    'triunfantemente': (0.796, 'Alegría'),
    'triunfar': (0.83, 'Alegría'),
    'triunfo': (0.864, 'Alegría'),
    'tuitivo': (0.298, 'Alegría'),
    'ubérrimo': (0.165, 'Alegría'),
    'ufanamente': (0.132, 'Alegría'),
    'ufanía': (0.099, 'Alegría'),
    'ufano': (0.132, 'Alegría'),
    'ultimar': (0.165, 'Alegría'),
    'unción': (0.231, 'Alegría'),
    'unión': (0.297, 'Alegría'),
    'útil': (0.429, 'Alegría'),
    'valía': (0.43, 'Alegría'),
    'valimiento': (0.331, 'Alegría'),
    'valorar': (0.497, 'Alegría'),
    'vehemencia': (0.331, 'Alegría'),
    'vehemente': (0.331, 'Alegría'),
    'vencedor': (0.696, 'Alegría'),
    'veneración': (0.496, 'Alegría'),
    'venerar': (0.463, 'Alegría'),
    'ventajosamente': (0.297, 'Alegría'),
    'ventajoso': (0.33, 'Alegría'),
    'venturosamente': (0.53, 'Alegría'),
    'venturoso': (0.63, 'Alegría'),
    'victorear': (0.563, 'Alegría'),
    'victoria': (0.763, 'Alegría'),
    'victorioso': (0.797, 'Alegría'),
    'vigor': (0.497, 'Alegría'),
    'vítor': (0.297, 'Alegría'),
    'vitorear': (0.297, 'Alegría'),
    'vivaz': (0.563, 'Alegría'),
    'viveza': (0.629, 'Alegría'),
    'vivificar': (0.563, 'Alegría'),
    'vivir': (0.63, 'Alegría'),
    'abominable': (0.797, 'Miedo'),
    'abominación': (0.464, 'Enojo'),
    'abominar': (0.797, 'Repulsión'),
    'aborrecer': (0.966, 'Repulsión'),
    'aborrecible': (0.966, 'Repulsión'),
    'aborreciblemente': (0.629, 'Enojo'),
    'aborrecimiento': (0.966, 'Repulsión'),
    'abusar': (0.697, 'Repulsión'),
    'acometedor': (0.463, 'Enojo'),
    'acometer': (0.497, 'Enojo'),
    'acometiente': (0.464, 'Enojo'),
    'acometimiento': (0.431, 'Enojo'),
    'acometividad': (0.397, 'Enojo'),
    'acosar': (0.465, 'Enojo'),
    'acribillar': (0.666, 'Enojo'),
    'acrimonia': (0.363, 'Enojo'),
    'acritud': (0.33, 'Enojo'),
    'adversario': (0.363, 'Enojo'),
    'aferrar': (0.265, 'Enojo'),
    'afrenta': (0.53, 'Enojo'),
    'agarrar': (0.231, 'Enojo'),
    'agobiar': (0.697, 'Tristeza'),
    'agobio': (0.231, 'Enojo'),
    'agravamiento': (0.397, 'Enojo'),
    'agravante': (0.463, 'Enojo'),
    'agravar': (0.43, 'Enojo'),
    'agraviar': (0.331, 'Tristeza'),
    'agravio': (0.43, 'Enojo'),
    'agresividad': (0.831, 'Enojo'),
    'agresivo': (0.865, 'Enojo'),
    'agresor': (0.83, 'Enojo'),
    'agriado': (0.497, 'Enojo'),
    'airadamente': (0.596, 'Enojo'),
    'airamiento': (0.563, 'Enojo'),
    'airar': (0.663, 'Enojo'),
    'alevosía': (0.396, 'Enojo'),
    'altivez': (0.264, 'Enojo'),
    'amargar': (0.363, 'Enojo'),
    'amargo': (0.264, 'Tristeza'),
    'amargor': (0.132, 'Enojo'),
    'amohinar': (0.599, 'Enojo'),
    'amoscamiento': (0.397, 'Enojo'),
    'animadversión': (0.664, 'Repulsión'),
    'animosidad': (0.297, 'Repulsión'),
    'antagónico': (0.199, 'Enojo'),
    'antagonismo': (0.364, 'Enojo'),
    'antipatía': (0.662, 'Repulsión'),
    'antipático': (0.728, 'Repulsión'),
    'apesadumbrar': (0.495, 'Enojo'),
    'arrebatamiento': (0.63, 'Enojo'),
    'arrebato': (0.497, 'Enojo'),
    'arrojar': (0.496, 'Enojo'),
    'asar': (0.165, 'Enojo'),
    'asediar': (0.364, 'Enojo'),
    'aspereza': (0.298, 'Enojo'),
    'asurar': (0.398, 'Enojo'),
    'atacar': (0.832, 'Enojo'),
    'ataque': (0.899, 'Enojo'),
    'atizar': (0.465, 'Enojo'),
    'atormentar': (0.53, 'Tristeza'),
    'atosigar': (0.563, 'Enojo'),
    'atrabiliario': (0.664, 'Enojo'),
    'atrocidad': (0.331, 'Enojo'),
    'atropellar': (0.398, 'Enojo'),
    'atropello': (0.397, 'Enojo'),
    'atroz': (0.696, 'Miedo'),
    'atufar': (0.398, 'Enojo'),
    'azuzar': (0.264, 'Enojo'),
    'baquetear': (0.365, 'Enojo'),
    'barbaridad': (0.364, 'Enojo'),
    'batallar': (0.463, 'Enojo'),
    'belicosidad': (0.53, 'Enojo'),
    'belicoso': (0.53, 'Enojo'),
    'beligerante': (0.396, 'Enojo'),
    'berrinche': (0.629, 'Enojo'),
    'bilis': (0.532, 'Enojo'),
    'bochinche': (0.363, 'Enojo'),
    'bravo': (0.563, 'Enojo'),
    'bufar': (0.532, 'Enojo'),
    'cabrear': (0.597, 'Enojo'),
    'cargoso': (0.363, 'Enojo'),
    'celos': (0.63, 'Enojo'),
    'chalar': (0.232, 'Enojo'),
    'chinche': (0.396, 'Enojo'),
    'cinismo': (0.298, 'Enojo'),
    'cizañar': (0.463, 'Enojo'),
    'cocolía': (0.631, 'Repulsión'),
    'cólera': (0.73, 'Enojo'),
    'coléricamente': (0.83, 'Enojo'),
    'colérico': (0.762, 'Enojo'),
    'concitar': (0.363, 'Enojo'),
    'contrariar': (0.463, 'Enojo'),
    'contrariedad': (0.331, 'Enojo'),
    'convulsión': (0.33, 'Miedo'),
    'coraje': (0.899, 'Enojo'),
    'corajudo': (0.831, 'Enojo'),
    'corroer': (0.297, 'Enojo'),
    'crispar': (0.43, 'Enojo'),
    'crucificar': (0.198, 'Enojo'),
    'cuenta': (0.0, 'Enojo'),
    'decepción': (0.898, 'Tristeza'),
    'decepcionar': (0.898, 'Tristeza'),
    'demente': (0.364, 'Enojo'),
    'demonio': (0.63, 'Miedo'),
    'denigrar': (0.496, 'Enojo'),
    'desaforo': (0.132, 'Enojo'),
    'desagradable': (0.898, 'Repulsión'),
    'desagradar': (0.628, 'Enojo'),
    'desagrado': (0.798, 'Repulsión'),
    'desairar': (0.53, 'Enojo'),
    'desaire': (0.53, 'Enojo'),
    'desaprobar': (0.463, 'Enojo'),
    'desazón': (0.165, 'Tristeza'),
    'descaro': (0.563, 'Enojo'),
    'descontentar': (0.562, 'Enojo'),
    'descontento': (0.397, 'Tristeza'),
    'desdén': (0.463, 'Enojo'),
    'desdeñar': (0.397, 'Enojo'),
    'deseable': (0.099, 'Enojo'),
    'desesperante': (0.496, 'Enojo'),
    'desmán': (0.529, 'Enojo'),
    'desorden': (0.496, 'Enojo'),
    'despecho': (0.662, 'Enojo'),
    'desplacer': (0.595, 'Enojo'),
    'despreciar': (0.696, 'Enojo'),
    'desprecio': (0.696, 'Enojo'),
    'desquiciante': (0.83, 'Enojo'),
    'desquiciar': (0.898, 'Enojo'),
    'destemplar': (0.397, 'Enojo'),
    'desvarío': (0.231, 'Enojo'),
    'detestable': (0.966, 'Repulsión'),
    'detestablemente': (0.932, 'Repulsión'),
    'detestación': (0.932, 'Repulsión'),
    'detestar': (0.663, 'Enojo'),
    'diantre': (0.432, 'Enojo'),
    'discordia': (0.562, 'Enojo'),
    'discrepancia': (0.33, 'Enojo'),
    'disgustar': (0.595, 'Repulsión'),
    'disgusto': (0.595, 'Repulsión'),
    'displacer': (0.463, 'Enojo'),
    'disputa': (0.763, 'Enojo'),
    'doloso': (0.397, 'Enojo'),
    'embestir': (0.564, 'Enojo'),
    'embravecer': (0.731, 'Enojo'),
    'emperrarse': (0.764, 'Enojo'),
    'emponzoñar': (0.665, 'Enojo'),
    'enajenación': (0.397, 'Enojo'),
    'enajenar': (0.33, 'Enojo'),
    'encabritar': (0.83, 'Enojo'),
    'encalabrinar': (0.563, 'Enojo'),
    'encocorar': (0.664, 'Enojo'),
    'encolerizar': (0.83, 'Enojo'),
    'enconar': (0.331, 'Enojo'),
    'encono': (0.298, 'Enojo'),
    'encorajinar': (0.831, 'Enojo'),
    'endemoniar': (0.83, 'Enojo'),
    'enemigo': (0.83, 'Enojo'),
    'enemistad': (0.831, 'Enojo'),
    'enemistoso': (0.797, 'Enojo'),
    'enérgico': (0.431, 'Enojo'),
    'enfadado': (0.932, 'Enojo'),
    'enfadar': (0.898, 'Enojo'),
    'enfado': (0.898, 'Enojo'),
    'enfadoso': (0.864, 'Enojo'),
    'enfierecido': (0.864, 'Enojo'),
    'enfurecer': (0.932, 'Enojo'),
    'enfurecimiento': (0.864, 'Enojo'),
    'enfurruñamiento': (0.696, 'Enojo'),
    'enganza': (0.596, 'Enojo'),
    'engativamente': (0.563, 'Enojo'),
    'engorro': (0.264, 'Enojo'),
    'engorroso': (0.264, 'Enojo'),
    'enloquecedor': (0.463, 'Enojo'),
    'enloquecer': (0.463, 'Enojo'),
    'enloquecimiento': (0.43, 'Enojo'),
    'enojadizo': (0.864, 'Enojo'),
    'enojado': (0.966, 'Enojo'),
    'enojamiento': (0.898, 'Enojo'),
    'enojar': (0.966, 'Enojo'),
    'enojo': (0.966, 'Enojo'),
    'enojosamente': (0.932, 'Enojo'),
    'enojoso': (0.932, 'Enojo'),
    'enrabiar': (0.966, 'Enojo'),
    'enrabietar': (0.932, 'Enojo'),
    'ensañamiento': (0.596, 'Enojo'),
    'ensañar': (0.596, 'Enojo'),
    'entuerto': (0.298, 'Enojo'),
    'envenenar': (0.364, 'Enojo'),
    'envidia': (0.496, 'Enojo'),
    'envidioso': (0.462, 'Enojo'),
    'escandalizar': (0.297, 'Enojo'),
    'escándalo': (0.198, 'Enojo'),
    'estafar': (0.43, 'Enojo'),
    'estorbar': (0.331, 'Enojo'),
    'estorbo': (0.331, 'Enojo'),
    'estropear': (0.53, 'Enojo'),
    'exabrupto': (0.663, 'Enojo'),
    'exacerbación': (0.729, 'Enojo'),
    'exacerbante': (0.729, 'Enojo'),
    'exacerbar': (0.73, 'Enojo'),
    'exagerar': (0.33, 'Enojo'),
    'exasperación': (0.63, 'Enojo'),
    'exasperante': (0.696, 'Enojo'),
    'exasperar': (0.696, 'Enojo'),
    'excandecencia': (0.731, 'Enojo'),
    'exceso': (0.198, 'Enojo'),
    'execrar': (0.299, 'Enojo'),
    'fastidiado': (0.729, 'Enojo'),
    'fastidiante': (0.729, 'Enojo'),
    'fastidiar': (0.53, 'Repulsión'),
    'fastidio': (0.597, 'Repulsión'),
    'fastidioso': (0.762, 'Enojo'),
    'feo': (0.297, 'Miedo'),
    'fiera': (0.53, 'Enojo'),
    'fracaso': (0.43, 'Enojo'),
    'frenético': (0.496, 'Enojo'),
    'fruncir': (0.496, 'Enojo'),
    'furia': (0.866, 'Enojo'),
    'furibundamente': (0.831, 'Enojo'),
    'furibundo': (0.831, 'Enojo'),
    'furiosamente': (0.933, 'Enojo'),
    'furioso': (0.833, 'Enojo'),
    'fustigar': (0.397, 'Enojo'),
    'genio': (0.43, 'Enojo'),
    'grima': (0.629, 'Repulsión'),
    'gruñón': (0.763, 'Enojo'),
    'guerra': (0.832, 'Enojo'),
    'hastiar': (0.596, 'Repulsión'),
    'hastioso': (0.629, 'Enojo'),
    'hiel': (0.595, 'Enojo'),
    'hostigador': (0.563, 'Enojo'),
    'hostigar': (0.53, 'Enojo'),
    'hostil': (0.498, 'Repulsión'),
    'hostilidad': (0.564, 'Enojo'),
    'hostilizar': (0.564, 'Enojo'),
    'impacientar': (0.529, 'Enojo'),
    'importunar': (0.496, 'Enojo'),
    'importuno': (0.462, 'Enojo'),
    'improperio': (0.429, 'Enojo'),
    'inaguantable': (0.563, 'Enojo'),
    'incomodar': (0.529, 'Enojo'),
    'incomodidad': (0.463, 'Enojo'),
    'incontrol': (0.363, 'Enojo'),
    'incordiar': (0.531, 'Enojo'),
    'incordio': (0.531, 'Enojo'),
    'indignación': (0.563, 'Enojo'),
    'indignado': (0.597, 'Enojo'),
    'indignante': (0.597, 'Enojo'),
    'indignar': (0.597, 'Enojo'),
    'infamar': (0.43, 'Enojo'),
    'inicuo': (0.364, 'Enojo'),
    'injuriar': (0.597, 'Repulsión'),
    'inquina': (0.665, 'Repulsión'),
    'insatisfecho': (0.331, 'Tristeza'),
    'insidia': (0.43, 'Enojo'),
    'insultar': (0.832, 'Enojo'),
    'insulto': (0.764, 'Repulsión'),
    'intratable': (0.696, 'Enojo'),
    'ira': (0.966, 'Enojo'),
    'iracundia': (0.697, 'Enojo'),
    'iracundo': (0.797, 'Enojo'),
    'irascible': (0.731, 'Enojo'),
    'irritabilidad': (0.864, 'Enojo'),
    'irritable': (0.898, 'Enojo'),
    'irritación': (0.796, 'Enojo'),
    'irritado': (0.83, 'Enojo'),
    'irritante': (0.83, 'Enojo'),
    'irritar': (0.796, 'Enojo'),
    'jaqueca': (0.528, 'Enojo'),
    'jorobar': (0.697, 'Enojo'),
    'latoso': (0.63, 'Enojo'),
    'loco': (0.396, 'Enojo'),
    'lrascible': (0.463, 'Enojo'),
    'majadero': (0.63, 'Enojo'),
    'mal': (0.431, 'Tristeza'),
    'maldición': (0.664, 'Enojo'),
    'maldito': (0.264, 'Tristeza'),
    'malévolo': (0.595, 'Enojo'),
    'malhumor': (0.764, 'Enojo'),
    'malhumorado': (0.797, 'Enojo'),
    'malicia': (0.595, 'Enojo'),
    'maliciar': (0.562, 'Enojo'),
    'malignidad': (0.462, 'Enojo'),
    'maligno': (0.764, 'Miedo'),
    'malo': (0.265, 'Tristeza'),
    'malpensado': (0.33, 'Enojo'),
    'malquerencia': (0.798, 'Repulsión'),
    'malvadamente': (0.495, 'Enojo'),
    'malvado': (0.798, 'Repulsión'),
    'manía': (0.264, 'Repulsión'),
    'martirio': (0.298, 'Enojo'),
    'martirizar': (0.397, 'Enojo'),
    'misoneísmo': (0.099, 'Enojo'),
    'mohíno': (0.498, 'Enojo'),
    'molestar': (0.132, 'Tristeza'),
    'molesto': (0.696, 'Enojo'),
    'molestoso': (0.696, 'Enojo'),
    'mortificar': (0.397, 'Enojo'),
    'mosconear': (0.332, 'Enojo'),
    'nervioso': (0.165, 'Enojo'),
    'obstaculizar': (0.231, 'Enojo'),
    'odiar': (0.932, 'Enojo'),
    'odio': (0.764, 'Repulsión'),
    'ofensa': (0.764, 'Enojo'),
    'ofensividad': (0.729, 'Enojo'),
    'ofensivo': (0.697, 'Repulsión'),
    'ojeriza': (0.662, 'Repulsión'),
    'opresión': (0.264, 'Tristeza'),
    'pelea': (0.73, 'Enojo'),
    'pendenciar': (0.463, 'Enojo'),
    'pendenciero': (0.463, 'Enojo'),
    'pernicioso': (0.396, 'Enojo'),
    'perseguir': (0.231, 'Tristeza'),
    'pesado': (0.264, 'Enojo'),
    'pestilente': (0.864, 'Repulsión'),
    'picar': (0.132, 'Enojo'),
    'pique': (0.429, 'Enojo'),
    'prender': (0.231, 'Enojo'),
    'provocación': (0.561, 'Enojo'),
    'provocar': (0.528, 'Enojo'),
    'puchero': (0.231, 'Enojo'),
    'pugna': (0.198, 'Enojo'),
    'pugnante': (0.165, 'Enojo'),
    'punzar': (0.165, 'Enojo'),
    'quejar': (0.561, 'Enojo'),
    'querellar': (0.529, 'Enojo'),
    'quicio': (0.596, 'Enojo'),
    'rabia': (0.763, 'Repulsión'),
    'rabiosamente': (0.864, 'Enojo'),
    'rabioso': (0.797, 'Enojo'),
    'regañadientes': (0.728, 'Enojo'),
    'regaño': (0.729, 'Enojo'),
    'rencilloso': (0.496, 'Enojo'),
    'rencor': (0.83, 'Repulsión'),
    'rencorosamente': (0.73, 'Enojo'),
    'rencoroso': (0.764, 'Enojo'),
    'repudiar': (0.898, 'Repulsión'),
    'repugnancia': (0.932, 'Repulsión'),
    'repugnar': (0.932, 'Repulsión'),
    'resentido': (0.731, 'Enojo'),
    'resentimiento': (0.731, 'Enojo'),
    'resentir': (0.698, 'Enojo'),
    'respingar': (0.396, 'Enojo'),
    'resquemor': (0.298, 'Enojo'),
    'retar': (0.396, 'Enojo'),
    'revancha': (0.33, 'Enojo'),
    'riña': (0.764, 'Enojo'),
    'rivalidad': (0.595, 'Enojo'),
    'saña': (0.763, 'Enojo'),
    'sañoso': (0.629, 'Enojo'),
    'suplicio': (0.298, 'Enojo'),
    'tenso': (0.496, 'Miedo'),
    'tirria': (0.629, 'Repulsión'),
    'torear': (0.297, 'Enojo'),
    'tormento': (0.53, 'Tristeza'),
    'tropelía': (0.297, 'Enojo'),
    'ultrajar': (0.595, 'Enojo'),
    'ultraje': (0.596, 'Enojo'),
    'vejación': (0.297, 'Tristeza'),
    'vejar': (0.396, 'Tristeza'),
    'venganza': (0.864, 'Enojo'),
    'vengar': (0.864, 'Enojo'),
    'vengativo': (0.864, 'Enojo'),
    'vesania': (0.698, 'Enojo'),
    'vesánico': (0.665, 'Enojo'),
    'vilipendiar': (0.529, 'Enojo'),
    'vilipendio': (0.496, 'Enojo'),
    'vinagre': (0.165, 'Enojo'),
    'violencia': (0.932, 'Enojo'),
    'violento': (0.932, 'Enojo'),
    'viperino': (0.132, 'Enojo'),
    'vituperio': (0.264, 'Enojo'),
    'voraz': (0.231, 'Enojo'),
    'zaherir': (0.697, 'Repulsión'),
    'accidente': (0.696, 'Miedo'),
    'acobardar': (0.865, 'Miedo'),
    'acomplejado': (0.597, 'Miedo'),
    'acoquinamiento': (0.598, 'Miedo'),
    'acoquinar': (0.831, 'Miedo'),
    'agüero': (0.297, 'Miedo'),
    'ahuyentar': (0.696, 'Miedo'),
    'alarma': (0.596, 'Miedo'),
    'alarmado': (0.695, 'Miedo'),
    'alarmante': (0.595, 'Miedo'),
    'alarmar': (0.63, 'Miedo'),
    'alertar': (0.53, 'Miedo'),
    'amedentrar': (0.898, 'Miedo'),
    'amedrentador': (0.831, 'Miedo'),
    'amedrentamiento': (0.831, 'Miedo'),
    'amenazar': (0.865, 'Miedo'),
    'amilanar': (0.831, 'Miedo'),
    'angustia': (0.763, 'Tristeza'),
    'angustiado': (0.831, 'Miedo'),
    'angustiosamente': (0.831, 'Miedo'),
    'ansioso': (0.264, 'Miedo'),
    'aprensión': (0.529, 'Repulsión'),
    'aprensivo': (0.364, 'Miedo'),
    'araña': (0.429, 'Repulsión'),
    'arredrar': (0.463, 'Miedo'),
    'asesinar': (0.73, 'Miedo'),
    'asustadizo': (0.864, 'Miedo'),
    'asustar': (0.864, 'Miedo'),
    'atemorizado': (0.932, 'Miedo'),
    'atemorizante': (0.932, 'Miedo'),
    'atemorizar': (0.932, 'Miedo'),
    'atento': (0.099, 'Miedo'),
    'aterrado': (0.966, 'Miedo'),
    'aterrador': (1.0, 'Miedo'),
    'aterradoramente': (1.0, 'Miedo'),
    'aterrar': (1.0, 'Miedo'),
    'aterrorizador': (0.966, 'Miedo'),
    'aterrorizar': (0.966, 'Miedo'),
    'avergonzado': (0.297, 'Miedo'),
    'avergonzar': (0.297, 'Tristeza'),
    'azoramiento': (0.529, 'Miedo'),
    'azorar': (0.696, 'Miedo'),
    'barbarie': (0.463, 'Miedo'),
    'bruja': (0.495, 'Miedo'),
    'brujo': (0.495, 'Miedo'),
    'cadaver': (0.697, 'Miedo'),
    'calaca': (0.462, 'Miedo'),
    'calamidad': (0.396, 'Miedo'),
    'calamitoso': (0.363, 'Miedo'),
    'calofrío': (0.463, 'Miedo'),
    'cohibición': (0.463, 'Miedo'),
    'cohibidamente': (0.43, 'Miedo'),
    'cohibir': (0.496, 'Miedo'),
    'confuso': (0.231, 'Tristeza'),
    'conminar': (0.529, 'Miedo'),
    'cortar': (0.165, 'Repulsión'),
    'cortedad': (0.165, 'Miedo'),
    'cruento': (0.33, 'Miedo'),
    'desesperado': (0.33, 'Miedo'),
    'desfallecer': (0.429, 'Tristeza'),
    'desfallecimiento': (0.429, 'Tristeza'),
    'desgracia': (0.83, 'Tristeza'),
    'desmayar': (0.099, 'Tristeza'),
    'desorientado': (0.132, 'Miedo'),
    'despavorir': (0.864, 'Miedo'),
    'despeluznante': (0.831, 'Miedo'),
    'despeluznar': (0.696, 'Miedo'),
    'despiadadamente': (0.663, 'Miedo'),
    'despiadado': (0.663, 'Miedo'),
    'diablo': (0.664, 'Miedo'),
    'encoger': (0.264, 'Tristeza'),
    'enfriar': (0.066, 'Miedo'),
    'escalofrío': (0.73, 'Miedo'),
    'espantable': (0.831, 'Miedo'),
    'espantadizo': (0.899, 'Miedo'),
    'espantar': (0.831, 'Sorpresa'),
    'espanto': (0.831, 'Sorpresa'),
    'espantoso': (0.899, 'Miedo'),
    'espeluznante': (0.932, 'Miedo'),
    'espeluznar': (0.932, 'Miedo'),
    'esperpento': (0.529, 'Miedo'),
    'espiritu': (0.231, 'Miedo'),
    'execrable': (0.763, 'Repulsión'),
    'exorcismo': (0.629, 'Miedo'),
    'fantasma': (0.596, 'Miedo'),
    'fealdad': (0.396, 'Miedo'),
    'fobia': (0.663, 'Repulsión'),
    'frío': (0.198, 'Tristeza'),
    'friolero': (0.099, 'Miedo'),
    'gallina': (0.265, 'Miedo'),
    'helado': (0.099, 'Miedo'),
    'helar': (0.033, 'Miedo'),
    'histeria': (0.562, 'Miedo'),
    'histéricamente': (0.496, 'Miedo'),
    'histérico': (0.497, 'Miedo'),
    'histerismo': (0.463, 'Miedo'),
    'horrendamente': (0.731, 'Miedo'),
    'horrendo': (0.731, 'Repulsión'),
    'horrible': (0.429, 'Sorpresa'),
    'horriblemente': (0.83, 'Miedo'),
    'hórrido': (0.731, 'Miedo'),
    'horrificar': (0.798, 'Miedo'),
    'horripilación': (0.697, 'Repulsión'),
    'horripilante': (0.831, 'Miedo'),
    'horripilar': (0.798, 'Miedo'),
    'horrísono': (0.663, 'Miedo'),
    'horror': (0.764, 'Repulsión'),
    'horrorizado': (0.898, 'Miedo'),
    'horrorizante': (0.898, 'Miedo'),
    'horrorizar': (0.898, 'Miedo'),
    'horrorosamente': (0.831, 'Miedo'),
    'horroroso': (0.764, 'Repulsión'),
    'huidizo': (0.764, 'Miedo'),
    'impotente': (0.464, 'Tristeza'),
    'incertidumbre': (0.396, 'Miedo'),
    'indeciso': (0.331, 'Miedo'),
    'inquietantemente': (0.496, 'Miedo'),
    'inquietar': (0.463, 'Miedo'),
    'inquieto': (0.364, 'Miedo'),
    'insecto': (0.298, 'Miedo'),
    'inseguro': (0.331, 'Miedo'),
    'intimidación': (0.629, 'Miedo'),
    'intimidar': (0.595, 'Miedo'),
    'intrinquilo': (0.496, 'Miedo'),
    'lengüicorto': (0.397, 'Miedo'),
    'maldad': (0.596, 'Miedo'),
    'medrana': (0.797, 'Miedo'),
    'medroso': (0.831, 'Miedo'),
    'mieditis': (0.831, 'Miedo'),
    'miedo': (0.297, 'Sorpresa'),
    'miedoso': (0.932, 'Miedo'),
    'monstruosamente': (0.797, 'Miedo'),
    'monstruoso': (0.831, 'Miedo'),
    'mortuorio': (0.764, 'Miedo'),
    'mounstro': (0.797, 'Miedo'),
    'muerte': (0.865, 'Tristeza'),
    'neblina': (0.33, 'Miedo'),
    'niebla': (0.331, 'Miedo'),
    'nublar': (0.099, 'Miedo'),
    'ominar': (0.231, 'Miedo'),
    'palidecer': (0.53, 'Miedo'),
    'palido': (0.529, 'Miedo'),
    'pánico': (0.898, 'Miedo'),
    'panteón': (0.563, 'Tristeza'),
    'pávido': (0.763, 'Miedo'),
    'pavor': (0.898, 'Miedo'),
    'pavorosamente': (0.83, 'Miedo'),
    'pavoroso': (0.83, 'Miedo'),
    'pena': (0.695, 'Tristeza'),
    'penumbra': (0.364, 'Tristeza'),
    'poseído': (0.63, 'Miedo'),
    'premonición': (0.33, 'Miedo'),
    'preocupación': (0.529, 'Miedo'),
    'preocupadamente': (0.563, 'Miedo'),
    'preocupado': (0.53, 'Miedo'),
    'pusilánime': (0.364, 'Miedo'),
    'pusilanimidad': (0.364, 'Miedo'),
    'rata': (0.531, 'Repulsión'),
    'recelo': (0.531, 'Miedo'),
    'receloso': (0.497, 'Miedo'),
    'rodeor': (0.231, 'Miedo'),
    'sangre': (0.364, 'Repulsión'),
    'sangriento': (0.496, 'Repulsión'),
    'sanguinario': (0.629, 'Miedo'),
    'satan': (0.631, 'Miedo'),
    'secuestro': (0.765, 'Miedo'),
    'sevicia': (0.495, 'Miedo'),
    'sobrecoger': (0.397, 'Sorpresa'),
    'sobrecogimiento': (0.431, 'Sorpresa'),
    'sobresaltar': (0.729, 'Miedo'),
    'sombra': (0.264, 'Miedo'),
    'suspenso': (0.529, 'Sorpresa'),
    'susto': (0.663, 'Sorpresa'),
    'temblor': (0.562, 'Miedo'),
    'temer': (0.932, 'Miedo'),
    'temerosamente': (0.864, 'Miedo'),
    'temeroso': (0.898, 'Miedo'),
    'temible': (0.932, 'Miedo'),
    'temor': (0.198, 'Tristeza'),
    'temorosamente': (0.864, 'Miedo'),
    'terremoto': (0.631, 'Miedo'),
    'terrible': (0.898, 'Miedo'),
    'terriblemente': (0.796, 'Miedo'),
    'terror': (0.966, 'Miedo'),
    'terrorífico': (0.898, 'Miedo'),
    'tímidamente': (0.596, 'Miedo'),
    'timidez': (0.497, 'Miedo'),
    'tímido': (0.531, 'Miedo'),
    'timorato': (0.631, 'Miedo'),
    'tragedia': (0.561, 'Miedo'),
    'tremebundo': (0.731, 'Miedo'),
    'tremendo': (0.429, 'Sorpresa'),
    'ultimatum': (0.297, 'Miedo'),
    'ultratumba': (0.663, 'Miedo'),
    'verecundia': (0.264, 'Miedo'),
    'verecundio': (0.264, 'Miedo'),
    'verecundo': (0.264, 'Miedo'),
    'vergonzoso': (0.231, 'Tristeza'),
    'vitando': (0.397, 'Miedo'),
    'abominablemente': (0.73, 'Repulsión'),
    'adversión': (0.497, 'Repulsión'),
    'alergia': (0.397, 'Repulsión'),
    'ampolla': (0.497, 'Repulsión'),
    'apestar': (0.831, 'Repulsión'),
    'apestoso': (0.899, 'Repulsión'),
    'asco': (0.966, 'Repulsión'),
    'asqueadamente': (0.932, 'Repulsión'),
    'asquear': (0.932, 'Repulsión'),
    'asquerosamente': (0.966, 'Repulsión'),
    'asqueroso': (1.0, 'Repulsión'),
    'astroso': (0.629, 'Repulsión'),
    'aversión': (0.629, 'Repulsión'),
    'basca': (0.865, 'Repulsión'),
    'bascosidad': (0.798, 'Repulsión'),
    'bascoso': (0.664, 'Repulsión'),
    'basura': (0.796, 'Repulsión'),
    'birria': (0.331, 'Repulsión'),
    'borracho': (0.563, 'Repulsión'),
    'caca': (0.898, 'Repulsión'),
    'carroña': (0.864, 'Repulsión'),
    'cicatriz': (0.396, 'Repulsión'),
    'coágulo': (0.397, 'Repulsión'),
    'cochino': (0.562, 'Repulsión'),
    'contaminar': (0.63, 'Repulsión'),
    'corromper': (0.596, 'Repulsión'),
    'desagradablemente': (0.831, 'Repulsión'),
    'desasosegar': (0.298, 'Repulsión'),
    'descomposicón': (0.763, 'Repulsión'),
    'deshonrar': (0.429, 'Tristeza'),
    'desperdicio': (0.562, 'Repulsión'),
    'diarrea': (0.697, 'Repulsión'),
    'distanciamiento': (0.363, 'Repulsión'),
    'empalagamiento': (0.33, 'Repulsión'),
    'empalagar': (0.33, 'Repulsión'),
    'empalagoso': (0.363, 'Repulsión'),
    'emporcar': (0.595, 'Repulsión'),
    'enfermedad': (0.629, 'Tristeza'),
    'enfermizo': (0.496, 'Repulsión'),
    'enfermo': (0.564, 'Repulsión'),
    'ensuciar': (0.662, 'Repulsión'),
    'envilecer': (0.798, 'Repulsión'),
    'escrúpulo': (0.33, 'Repulsión'),
    'estiércol': (0.73, 'Repulsión'),
    'excremento': (0.798, 'Repulsión'),
    'execrablemente': (0.763, 'Repulsión'),
    'fétido': (0.898, 'Repulsión'),
    'fila': (0.366, 'Repulsión'),
    'gases': (0.663, 'Repulsión'),
    'gelatinoso': (0.231, 'Repulsión'),
    'guácala': (0.966, 'Repulsión'),
    'gusano': (0.462, 'Repulsión'),
    'harto': (0.497, 'Repulsión'),
    'hastío': (0.563, 'Repulsión'),
    'hediondo': (0.864, 'Repulsión'),
    'herida': (0.33, 'Repulsión'),
    'hincha': (0.664, 'Repulsión'),
    'hinchado': (0.565, 'Repulsión'),
    'hongos': (0.396, 'Repulsión'),
    'impúdico': (0.496, 'Repulsión'),
    'impuro': (0.597, 'Repulsión'),
    'incasto': (0.43, 'Repulsión'),
    'indecente': (0.63, 'Repulsión'),
    'indecoroso': (0.563, 'Repulsión'),
    'indisponer': (0.364, 'Repulsión'),
    'infame': (0.63, 'Repulsión'),
    'infección': (0.531, 'Repulsión'),
    'infecto': (0.664, 'Repulsión'),
    'infrahumano': (0.431, 'Repulsión'),
    'inframundo': (0.597, 'Repulsión'),
    'injuriante': (0.498, 'Repulsión'),
    'injurioso': (0.597, 'Repulsión'),
    'inmoral': (0.464, 'Tristeza'),
    'inmundo': (0.932, 'Repulsión'),
    'insubordinar': (0.365, 'Repulsión'),
    'insultante': (0.73, 'Repulsión'),
    'insurrección': (0.264, 'Repulsión'),
    'insurreccionar': (0.264, 'Repulsión'),
    'intranquilo': (0.132, 'Repulsión'),
    'lepra': (0.765, 'Repulsión'),
    'licencioso': (0.63, 'Repulsión'),
    'malasangre': (0.798, 'Repulsión'),
    'mancha': (0.496, 'Repulsión'),
    'marrano': (0.664, 'Repulsión'),
    'mefítico': (0.664, 'Repulsión'),
    'moco': (0.798, 'Repulsión'),
    'mórbido': (0.398, 'Repulsión'),
    'morboso': (0.73, 'Repulsión'),
    'mosca': (0.531, 'Repulsión'),
    'mugre': (0.732, 'Repulsión'),
    'náusea': (0.865, 'Repulsión'),
    'nauseabundamente': (0.831, 'Repulsión'),
    'nauseabundo': (0.865, 'Repulsión'),
    'nausear': (0.831, 'Repulsión'),
    'náuseas': (0.898, 'Repulsión'),
    'nefasto': (0.33, 'Tristeza'),
    'obsceno': (0.764, 'Repulsión'),
    'odiosamente': (0.73, 'Repulsión'),
    'odioso': (0.764, 'Repulsión'),
    'ofender': (0.697, 'Repulsión'),
    'oponer': (0.363, 'Repulsión'),
    'orina': (0.563, 'Repulsión'),
    'patológico': (0.332, 'Repulsión'),
    'pecaminoso': (0.464, 'Repulsión'),
    'pedo': (0.865, 'Repulsión'),
    'pérfido': (0.766, 'Repulsión'),
    'perinquina': (0.763, 'Repulsión'),
    'perverso': (0.132, 'Tristeza'),
    'pervertir': (0.698, 'Repulsión'),
    'pésimo': (0.63, 'Repulsión'),
    'peste': (0.864, 'Repulsión'),
    'podrido': (0.797, 'Repulsión'),
    'podrir': (0.297, 'Tristeza'),
    'popo': (0.797, 'Repulsión'),
    'pornográfico': (0.663, 'Repulsión'),
    'procaz': (0.565, 'Repulsión'),
    'protervo': (0.664, 'Repulsión'),
    'puaf': (0.165, 'Repulsión'),
    'puercamente': (0.864, 'Repulsión'),
    'puerco': (0.763, 'Repulsión'),
    'pus': (0.765, 'Repulsión'),
    'putrefacción': (0.865, 'Repulsión'),
    'putrido': (0.865, 'Repulsión'),
    'rastrero': (0.564, 'Repulsión'),
    'rechazamiento': (0.664, 'Repulsión'),
    'rechazar': (0.73, 'Repulsión'),
    'rechazo': (0.696, 'Repulsión'),
    'reherir': (0.629, 'Repulsión'),
    'repeler': (0.697, 'Repulsión'),
    'repelo': (0.664, 'Repulsión'),
    'repudiable': (0.898, 'Repulsión'),
    'repudio': (0.898, 'Repulsión'),
    'repugnadamente': (0.932, 'Repulsión'),
    'repugnante': (0.932, 'Repulsión'),
    'repugnantemente': (0.932, 'Repulsión'),
    'repulsar': (0.932, 'Repulsión'),
    'repulsión': (0.966, 'Repulsión'),
    'repulsivamente': (1.0, 'Repulsión'),
    'repulsivo': (1.0, 'Repulsión'),
    'rufián': (0.697, 'Repulsión'),
    'ruin': (0.731, 'Repulsión'),
    'secreción': (0.697, 'Repulsión'),
    'sórdido': (0.697, 'Repulsión'),
    'submundo': (0.498, 'Repulsión'),
    'sucio': (0.73, 'Repulsión'),
    'tripas': (0.463, 'Repulsión'),
    'ultrajante': (0.596, 'Repulsión'),
    'usgo': (0.765, 'Repulsión'),
    'vil': (0.696, 'Repulsión'),
    'víscera': (0.631, 'Repulsión'),
    'viscoso': (0.464, 'Repulsión'),
    'vomito': (0.899, 'Repulsión'),
    'zahiriente': (0.731, 'Repulsión'),
    'abierto': (0.298, 'Sorpresa'),
    'abobamiento': (0.199, 'Sorpresa'),
    'abobar': (0.298, 'Sorpresa'),
    'acertijo': (0.531, 'Sorpresa'),
    'acojonante': (0.73, 'Sorpresa'),
    'adivinanza': (0.498, 'Sorpresa'),
    'admiracion': (0.664, 'Sorpresa'),
    'agenciar': (0.198, 'Sorpresa'),
    'alcanzar': (0.265, 'Sorpresa'),
    'alelamiento': (0.198, 'Sorpresa'),
    'alelar': (0.132, 'Sorpresa'),
    'anonadamiento': (0.765, 'Sorpresa'),
    'anonadar': (0.731, 'Sorpresa'),
    'apoteósico': (0.598, 'Sorpresa'),
    'arrocinar': (0.165, 'Sorpresa'),
    'asombramiento': (0.932, 'Sorpresa'),
    'asombrar': (0.966, 'Sorpresa'),
    'asombrosamente': (0.966, 'Sorpresa'),
    'asombroso': (0.966, 'Sorpresa'),
    'atarantar': (0.132, 'Sorpresa'),
    'atolondrar': (0.199, 'Sorpresa'),
    'atónito': (0.799, 'Sorpresa'),
    'atontamiento': (0.232, 'Sorpresa'),
    'atontar': (0.232, 'Sorpresa'),
    'atrapar': (0.463, 'Sorpresa'),
    'atronar': (0.265, 'Sorpresa'),
    'aturdimiento': (0.165, 'Sorpresa'),
    'aturdir': (0.165, 'Sorpresa'),
    'aturrullar': (0.165, 'Sorpresa'),
    'aturullar': (0.165, 'Sorpresa'),
    'batir': (0.066, 'Sorpresa'),
    'bizco': (0.265, 'Sorpresa'),
    'bobalicón': (0.066, 'Sorpresa'),
    'bobo': (0.099, 'Sorpresa'),
    'bombo': (0.331, 'Sorpresa'),
    'boquiabierto': (0.799, 'Sorpresa'),
    'bruto': (0.165, 'Sorpresa'),
    'chasco': (0.399, 'Sorpresa'),
    'coger': (0.429, 'Sorpresa'),
    'confundir': (0.264, 'Sorpresa'),
    'confusión': (0.264, 'Sorpresa'),
    'conmoción': (0.631, 'Sorpresa'),
    'conmocionar': (0.663, 'Sorpresa'),
    'conseguir': (0.33, 'Sorpresa'),
    'consternación': (0.595, 'Tristeza'),
    'consternar': (0.43, 'Sorpresa'),
    'conturbar': (0.632, 'Sorpresa'),
    'descomunalmente': (0.798, 'Sorpresa'),
    'desconcertar': (0.664, 'Sorpresa'),
    'desconcierto': (0.631, 'Sorpresa'),
    'descuidar': (0.363, 'Sorpresa'),
    'deslumbramiento': (0.597, 'Sorpresa'),
    'deslumbrantemente': (0.664, 'Sorpresa'),
    'deslumbrar': (0.664, 'Sorpresa'),
    'desmayo': (0.53, 'Sorpresa'),
    'despampanante': (0.833, 'Sorpresa'),
    'despistar': (0.297, 'Sorpresa'),
    'desprevenido': (0.661, 'Sorpresa'),
    'distraído': (0.463, 'Sorpresa'),
    'embobamiento': (0.132, 'Sorpresa'),
    'embobecer': (0.165, 'Sorpresa'),
    'embrutecer': (0.165, 'Sorpresa'),
    'encandilar': (0.597, 'Sorpresa'),
    'enigma': (0.565, 'Sorpresa'),
    'enmudecer': (0.664, 'Sorpresa'),
    'entontecer': (0.198, 'Sorpresa'),
    'entontecimiento': (0.099, 'Sorpresa'),
    'estólido': (0.099, 'Sorpresa'),
    'estrellas': (0.232, 'Sorpresa'),
    'estruendo': (0.497, 'Sorpresa'),
    'estupefacción': (0.798, 'Sorpresa'),
    'estupefacto': (0.899, 'Sorpresa'),
    'estupendamente': (0.664, 'Sorpresa'),
    'estúpido': (0.099, 'Sorpresa'),
    'estupor': (0.765, 'Sorpresa'),
    'exclamación': (0.497, 'Sorpresa'),
    'extrañar': (0.198, 'Sorpresa'),
    'extrañeza': (0.464, 'Sorpresa'),
    'extraordinario': (0.665, 'Sorpresa'),
    'fabuloso': (0.597, 'Sorpresa'),
    'fantásticamente': (0.696, 'Sorpresa'),
    'fantástico': (0.763, 'Sorpresa'),
    'fascinacion': (0.663, 'Sorpresa'),
    'frustrar': (0.165, 'Sorpresa'),
    'golpe': (0.265, 'Sorpresa'),
    'gritar': (0.528, 'Sorpresa'),
    'grito': (0.528, 'Sorpresa'),
    'idiotizar': (0.099, 'Sorpresa'),
    'imbécil': (0.033, 'Sorpresa'),
    'impresión': (0.731, 'Sorpresa'),
    'impresionante': (0.899, 'Sorpresa'),
    'inaudito': (0.899, 'Sorpresa'),
    'increible': (0.966, 'Sorpresa'),
    'increíblemente': (0.899, 'Sorpresa'),
    'inepto': (0.066, 'Sorpresa'),
    'interrogante': (0.298, 'Sorpresa'),
    'interrogar': (0.331, 'Sorpresa'),
    'intrigar': (0.429, 'Sorpresa'),
    'lelo': (0.066, 'Sorpresa'),
    'llegar': (0.165, 'Sorpresa'),
    'llevar': (0.132, 'Sorpresa'),
    'maravilla': (0.899, 'Sorpresa'),
    'maravilloso': (0.966, 'Sorpresa'),
    'milagro': (0.764, 'Sorpresa'),
    'mirífico': (0.933, 'Sorpresa'),
    'misterio': (0.331, 'Sorpresa'),
    'mistificar': (0.132, 'Sorpresa'),
    'mudo': (0.198, 'Sorpresa'),
    'nefando': (0.066, 'Sorpresa'),
    'noqueado': (0.297, 'Sorpresa'),
    'noquear': (0.231, 'Sorpresa'),
    'obtuso': (0.066, 'Sorpresa'),
    'ofuscar': (0.264, 'Sorpresa'),
    'pasmar': (0.597, 'Sorpresa'),
    'pasmo': (0.398, 'Sorpresa'),
    'pasmosamente': (0.431, 'Sorpresa'),
    'pasmoso': (0.564, 'Sorpresa'),
    'perplejidad': (0.731, 'Sorpresa'),
    'perplejo': (0.764, 'Sorpresa'),
    'portento': (0.696, 'Sorpresa'),
    'portentosamente': (0.63, 'Sorpresa'),
    'portentoso': (0.696, 'Sorpresa'),
    'preguntar': (0.198, 'Sorpresa'),
    'prodigiosamente': (0.596, 'Sorpresa'),
    'prodigiosidad': (0.563, 'Sorpresa'),
    'prodigioso': (0.629, 'Sorpresa'),
    'quedar': (0.33, 'Sorpresa'),
    'quimérico': (0.364, 'Sorpresa'),
    'quisicosa': (0.33, 'Sorpresa'),
    'recibir': (0.364, 'Sorpresa'),
    'repente': (0.63, 'Sorpresa'),
    'repentino': (0.696, 'Sorpresa'),
    'rompecabezas': (0.099, 'Sorpresa'),
    'shock': (0.664, 'Sorpresa'),
    'shoqueado': (0.731, 'Sorpresa'),
    'sobresalto': (0.565, 'Sorpresa'),
    'sonso': (0.066, 'Sorpresa'),
    'sorprendente': (0.966, 'Sorpresa'),
    'sorprendentemente': (0.932, 'Sorpresa'),
    'sorprender': (0.966, 'Sorpresa'),
    'sorpresa': (0.966, 'Sorpresa'),
    'sorpresivamente': (0.966, 'Sorpresa'),
    'sorpresivo': (0.966, 'Sorpresa'),
    'subito': (0.662, 'Sorpresa'),
    'tambaleante': (0.132, 'Sorpresa'),
    'tambalear': (0.132, 'Sorpresa'),
    'titubeante': (0.099, 'Sorpresa'),
    'titubear': (0.099, 'Sorpresa'),
    'traspiés': (0.033, 'Sorpresa'),
    'zonzo': (0.066, 'Sorpresa'),
    'zopenco': (0.066, 'Sorpresa'),
    'abajamiento': (0.497, 'Tristeza'),
    'abajo': (0.364, 'Tristeza'),
    'abandonamiento': (0.865, 'Tristeza'),
    'abandonar': (0.898, 'Tristeza'),
    'abatidamente': (0.832, 'Tristeza'),
    'abatido': (0.865, 'Tristeza'),
    'abatimiento': (0.798, 'Tristeza'),
    'abatir': (0.765, 'Tristeza'),
    'abochornar': (0.264, 'Tristeza'),
    'abrumar': (0.43, 'Tristeza'),
    'aburrir': (0.264, 'Tristeza'),
    'aciago': (0.563, 'Tristeza'),
    'acongojar': (0.796, 'Tristeza'),
    'acuitadamente': (0.463, 'Tristeza'),
    'acuitar': (0.562, 'Tristeza'),
    'adolecer': (0.563, 'Tristeza'),
    'adverso': (0.464, 'Tristeza'),
    'aflicción': (0.764, 'Tristeza'),
    'afligidamente': (0.83, 'Tristeza'),
    'afligido': (0.83, 'Tristeza'),
    'afligir': (0.796, 'Tristeza'),
    'agobiado': (0.764, 'Tristeza'),
    'agobiante': (0.73, 'Tristeza'),
    'agobiantemente': (0.73, 'Tristeza'),
    'aguantar': (0.364, 'Tristeza'),
    'aherrojar': (0.198, 'Tristeza'),
    'ahogo': (0.463, 'Tristeza'),
    'alicaído': (0.464, 'Tristeza'),
    'aliquebrado': (0.497, 'Tristeza'),
    'amargura': (0.528, 'Tristeza'),
    'amurriar': (0.697, 'Tristeza'),
    'angustiadamente': (0.697, 'Tristeza'),
    'angustiar': (0.729, 'Tristeza'),
    'angustioso': (0.763, 'Tristeza'),
    'aniquilar': (0.463, 'Tristeza'),
    'añicos': (0.463, 'Tristeza'),
    'apabullar': (0.429, 'Tristeza'),
    'apenar': (0.397, 'Tristeza'),
    'apiadarse': (0.464, 'Tristeza'),
    'aplanar': (0.166, 'Tristeza'),
    'aplastar': (0.232, 'Tristeza'),
    'aquejar': (0.497, 'Tristeza'),
    'arrastradamente': (0.297, 'Tristeza'),
    'arrastrar': (0.198, 'Tristeza'),
    'arrepentimiento': (0.462, 'Tristeza'),
    'arrepentir': (0.462, 'Tristeza'),
    'asolar': (0.53, 'Tristeza'),
    'atormentadamente': (0.496, 'Tristeza'),
    'atribular': (0.529, 'Tristeza'),
    'atrición': (0.495, 'Tristeza'),
    'bajo': (0.264, 'Tristeza'),
    'cabizbajo': (0.898, 'Tristeza'),
    'cabizcaído': (0.898, 'Tristeza'),
    'caer': (0.528, 'Tristeza'),
    'caerse': (0.462, 'Tristeza'),
    'caída': (0.529, 'Tristeza'),
    'caído': (0.528, 'Tristeza'),
    'calvario': (0.763, 'Tristeza'),
    'cancamurria': (0.799, 'Tristeza'),
    'carcel': (0.596, 'Tristeza'),
    'carecer': (0.529, 'Tristeza'),
    'cargar': (0.33, 'Tristeza'),
    'castigo': (0.595, 'Tristeza'),
    'cetrino': (0.165, 'Tristeza'),
    'compadecer': (0.564, 'Tristeza'),
    'compunción': (0.464, 'Tristeza'),
    'compungidamente': (0.331, 'Tristeza'),
    'compungir': (0.397, 'Tristeza'),
    'condoler': (0.796, 'Tristeza'),
    'congoja': (0.496, 'Tristeza'),
    'congojoso': (0.529, 'Tristeza'),
    'contrición': (0.429, 'Tristeza'),
    'contristar': (0.663, 'Tristeza'),
    'contrito': (0.63, 'Tristeza'),
    'crisis': (0.696, 'Tristeza'),
    'cuita': (0.73, 'Tristeza'),
    'cuitado': (0.597, 'Tristeza'),
    'culpa': (0.598, 'Tristeza'),
    'culpabilidad': (0.631, 'Tristeza'),
    'culpable': (0.565, 'Tristeza'),
    'culpado': (0.631, 'Tristeza'),
    'culposo': (0.631, 'Tristeza'),
    'dañino': (0.562, 'Tristeza'),
    'debilitar': (0.33, 'Tristeza'),
    'decaer': (0.729, 'Tristeza'),
    'decaído': (0.831, 'Tristeza'),
    'decaimiento': (0.797, 'Tristeza'),
    'defectuoso': (0.33, 'Tristeza'),
    'deficiente': (0.363, 'Tristeza'),
    'dejarse': (0.233, 'Tristeza'),
    'dejazón': (0.166, 'Tristeza'),
    'deplorable': (0.563, 'Tristeza'),
    'deplorablemente': (0.563, 'Tristeza'),
    'deplorar': (0.53, 'Tristeza'),
    'depresión': (0.898, 'Tristeza'),
    'depresivo': (0.898, 'Tristeza'),
    'deprimente': (0.898, 'Tristeza'),
    'deprimir': (0.864, 'Tristeza'),
    'derribado': (0.563, 'Tristeza'),
    'derribar': (0.431, 'Tristeza'),
    'derrota': (0.764, 'Tristeza'),
    'desafortunado': (0.898, 'Tristeza'),
    'desalentadamente': (0.797, 'Tristeza'),
    'desalentar': (0.764, 'Tristeza'),
    'desaliento': (0.797, 'Tristeza'),
    'desalojar': (0.496, 'Tristeza'),
    'desamparar': (0.629, 'Tristeza'),
    'desamparo': (0.596, 'Tristeza'),
    'desanimado': (0.729, 'Tristeza'),
    'desanimar': (0.729, 'Tristeza'),
    'desánimo': (0.762, 'Tristeza'),
    'desaquellar': (0.596, 'Tristeza'),
    'desarrapado': (0.198, 'Tristeza'),
    'desastrado': (0.232, 'Tristeza'),
    'desazonar': (0.165, 'Tristeza'),
    'descaecimiento': (0.331, 'Tristeza'),
    'descomponer': (0.264, 'Tristeza'),
    'desconsolado': (0.83, 'Tristeza'),
    'desconsolador': (0.73, 'Tristeza'),
    'desconsolar': (0.73, 'Tristeza'),
    'desconsuelo': (0.83, 'Tristeza'),
    'descorazonamiento': (0.43, 'Tristeza'),
    'descorazonar': (0.463, 'Tristeza'),
    'descuajar': (0.198, 'Tristeza'),
    'desdicha': (0.83, 'Tristeza'),
    'desdichado': (0.83, 'Tristeza'),
    'desengaño': (0.663, 'Tristeza'),
    'desesperación': (0.464, 'Tristeza'),
    'desesperadamente': (0.464, 'Tristeza'),
    'desesperanza': (0.698, 'Tristeza'),
    'desesperanzar': (0.764, 'Tristeza'),
    'desesperar': (0.332, 'Tristeza'),
    'desestimar': (0.265, 'Tristeza'),
    'desestimular': (0.264, 'Tristeza'),
    'desgarrador': (0.564, 'Tristeza'),
    'desgarro': (0.397, 'Tristeza'),
    'desgastar': (0.365, 'Tristeza'),
    'desgraciar': (0.73, 'Tristeza'),
    'deshecho': (0.531, 'Tristeza'),
    'deshincharse': (0.099, 'Tristeza'),
    'desierto': (0.099, 'Tristeza'),
    'desinflar': (0.198, 'Tristeza'),
    'deslucir': (0.132, 'Tristeza'),
    'desmadejado': (0.165, 'Tristeza'),
    'desmalazado': (0.264, 'Tristeza'),
    'desmayadamente': (0.132, 'Tristeza'),
    'desmayado': (0.132, 'Tristeza'),
    'desmedrar': (0.165, 'Tristeza'),
    'desmoralización': (0.529, 'Tristeza'),
    'desmoralizador': (0.595, 'Tristeza'),
    'desmoralizante': (0.595, 'Tristeza'),
    'desmoralizar': (0.562, 'Tristeza'),
    'desmotivar': (0.762, 'Tristeza'),
    'desolación': (0.762, 'Tristeza'),
    'desolar': (0.729, 'Tristeza'),
    'despojar': (0.496, 'Tristeza'),
    'desposeer': (0.297, 'Tristeza'),
    'desprivar': (0.264, 'Tristeza'),
    'desprotección': (0.264, 'Tristeza'),
    'desprotegido': (0.363, 'Tristeza'),
    'destartalado': (0.33, 'Tristeza'),
    'destrozo': (0.562, 'Tristeza'),
    'desventura': (0.729, 'Tristeza'),
    'desventurado': (0.629, 'Tristeza'),
    'devastar': (0.764, 'Tristeza'),
    'doler': (0.764, 'Tristeza'),
    'doliente': (0.832, 'Tristeza'),
    'dolor': (0.832, 'Tristeza'),
    'dolorido': (0.832, 'Tristeza'),
    'doloroso': (0.866, 'Tristeza'),
    'duelo': (0.497, 'Tristeza'),
    'echar': (0.099, 'Tristeza'),
    'encuitar': (0.232, 'Tristeza'),
    'enervar': (0.231, 'Tristeza'),
    'enflaquecer': (0.563, 'Tristeza'),
    'enlutar': (0.797, 'Tristeza'),
    'ensombrecer': (0.697, 'Tristeza'),
    'entristecedor': (0.899, 'Tristeza'),
    'entristecer': (0.932, 'Tristeza'),
    'entristecimiento': (0.899, 'Tristeza'),
    'escarmentar': (0.331, 'Tristeza'),
    'escasez': (0.398, 'Tristeza'),
    'escaso': (0.365, 'Tristeza'),
    'esplín': (0.466, 'Tristeza'),
    'estragar': (0.165, 'Tristeza'),
    'flaquear': (0.396, 'Tristeza'),
    'flaqueza': (0.363, 'Tristeza'),
    'flébil': (0.697, 'Tristeza'),
    'frustación': (0.396, 'Tristeza'),
    'fúnebre': (0.696, 'Tristeza'),
    'fúnebremente': (0.662, 'Tristeza'),
    'funeral': (0.763, 'Tristeza'),
    'funerario': (0.764, 'Tristeza'),
    'funesto': (0.497, 'Tristeza'),
    'grave': (0.463, 'Tristeza'),
    'gris': (0.564, 'Tristeza'),
    'hambre': (0.331, 'Tristeza'),
    'huérfano': (0.764, 'Tristeza'),
    'humilde': (0.396, 'Tristeza'),
    'humillar': (0.496, 'Tristeza'),
    'hundido': (0.496, 'Tristeza'),
    'hundir': (0.464, 'Tristeza'),
    'hundírsele': (0.299, 'Tristeza'),
    'imperfecto': (0.231, 'Tristeza'),
    'impotencia': (0.53, 'Tristeza'),
    'inconforme': (0.33, 'Tristeza'),
    'inconformidad': (0.264, 'Tristeza'),
    'inconsolable': (0.732, 'Tristeza'),
    'indigente': (0.398, 'Tristeza'),
    'infausto': (0.53, 'Tristeza'),
    'infectar': (0.297, 'Tristeza'),
    'infedelidad': (0.597, 'Tristeza'),
    'infelicidad': (0.898, 'Tristeza'),
    'infeliz': (0.966, 'Tristeza'),
    'inferior': (0.264, 'Tristeza'),
    'infortunado': (0.73, 'Tristeza'),
    'infortunio': (0.729, 'Tristeza'),
    'inhabitado': (0.33, 'Tristeza'),
    'injusticia': (0.496, 'Tristeza'),
    'innoble': (0.463, 'Tristeza'),
    'inquietud': (0.231, 'Tristeza'),
    'insatisfacción': (0.297, 'Tristeza'),
    'lacerar': (0.529, 'Tristeza'),
    'laceria': (0.463, 'Tristeza'),
    'lacrimoso': (0.63, 'Tristeza'),
    'lágrima': (0.763, 'Tristeza'),
    'lagrimar': (0.763, 'Tristeza'),
    'lágrimas': (0.763, 'Tristeza'),
    'lagrimear': (0.762, 'Tristeza'),
    'lagrimoso': (0.662, 'Tristeza'),
    'laido': (0.53, 'Tristeza'),
    'lamentable': (0.629, 'Tristeza'),
    'lamentablemente': (0.597, 'Tristeza'),
    'lamentar': (0.729, 'Tristeza'),
    'lamento': (0.729, 'Tristeza'),
    'lamentoso': (0.729, 'Tristeza'),
    'lánguidamente': (0.496, 'Tristeza'),
    'lánguido': (0.496, 'Tristeza'),
    'larga': (0.066, 'Tristeza'),
    'lastima': (0.73, 'Tristeza'),
    'lastimeramente': (0.696, 'Tristeza'),
    'lastimero': (0.73, 'Tristeza'),
    'lastimoso': (0.763, 'Tristeza'),
    'llanto': (0.865, 'Tristeza'),
    'llorar': (0.865, 'Tristeza'),
    'llorón': (0.763, 'Tristeza'),
    'lloroso': (0.797, 'Tristeza'),
    'lóbregamente': (0.463, 'Tristeza'),
    'lóbrego': (0.464, 'Tristeza'),
    'luctuosamente': (0.83, 'Tristeza'),
    'luctuoso': (0.898, 'Tristeza'),
    'lúgubre': (0.865, 'Tristeza'),
    'lugubres': (0.865, 'Tristeza'),
    'luto': (0.932, 'Tristeza'),
    'lutoso': (0.932, 'Tristeza'),
    'macabro': (0.199, 'Tristeza'),
    'malandante': (0.363, 'Tristeza'),
    'malaventurado': (0.63, 'Tristeza'),
    'malcontento': (0.563, 'Tristeza'),
    'malhadado': (0.529, 'Tristeza'),
    'malhumorar': (0.297, 'Tristeza'),
    'maltrecho': (0.33, 'Tristeza'),
    'melancolía': (0.865, 'Tristeza'),
    'melancólicamente': (0.865, 'Tristeza'),
    'melancólico': (0.865, 'Tristeza'),
    'menesteroso': (0.462, 'Tristeza'),
    'menguante': (0.099, 'Tristeza'),
    'mezquinamente': (0.231, 'Tristeza'),
    'mezquindad': (0.231, 'Tristeza'),
    'miserable': (0.628, 'Tristeza'),
    'miserablemente': (0.661, 'Tristeza'),
    'míseramente': (0.596, 'Tristeza'),
    'miseria': (0.596, 'Tristeza'),
    'mísero': (0.562, 'Tristeza'),
    'misérrimamente': (0.463, 'Tristeza'),
    'morriña': (0.532, 'Tristeza'),
    'muerto': (0.731, 'Tristeza'),
    'mustiamente': (0.298, 'Tristeza'),
    'mustio': (0.365, 'Tristeza'),
    'necesitado': (0.497, 'Tristeza'),
    'negro': (0.198, 'Tristeza'),
    'nocturno': (0.033, 'Tristeza'),
    'nostálgico': (0.831, 'Tristeza'),
    'obscuridad': (0.265, 'Tristeza'),
    'obscuro': (0.265, 'Tristeza'),
    'onerosamente': (0.165, 'Tristeza'),
    'opacidad': (0.264, 'Tristeza'),
    'opresivamente': (0.396, 'Tristeza'),
    'opresivo': (0.363, 'Tristeza'),
    'oprimente': (0.396, 'Tristeza'),
    'oprimir': (0.198, 'Tristeza'),
    'oscuramente': (0.033, 'Tristeza'),
    'oscurecer': (0.066, 'Tristeza'),
    'oscuridad': (0.099, 'Tristeza'),
    'oscuro': (0.066, 'Tristeza'),
    'padecer': (0.429, 'Tristeza'),
    'padecimiento': (0.429, 'Tristeza'),
    'partir': (0.596, 'Tristeza'),
    'patético': (0.165, 'Tristeza'),
    'paupérrimamente': (0.232, 'Tristeza'),
    'paupérrimo': (0.232, 'Tristeza'),
    'penalidad': (0.331, 'Tristeza'),
    'penar': (0.628, 'Tristeza'),
    'penitencia': (0.496, 'Tristeza'),
    'penitente': (0.496, 'Tristeza'),
    'penosamente': (0.396, 'Tristeza'),
    'penoso': (0.363, 'Tristeza'),
    'perder': (0.629, 'Tristeza'),
    'pérdida': (0.864, 'Tristeza'),
    'pesadumbre': (0.496, 'Tristeza'),
    'pesar': (0.562, 'Tristeza'),
    'pesaroso': (0.496, 'Tristeza'),
    'pesimismo': (0.429, 'Tristeza'),
    'pisotear': (0.33, 'Tristeza'),
    'pobre': (0.462, 'Tristeza'),
    'pobremente': (0.396, 'Tristeza'),
    'pobrete': (0.363, 'Tristeza'),
    'pobreto': (0.363, 'Tristeza'),
    'pobreza': (0.396, 'Tristeza'),
    'preocupar': (0.462, 'Tristeza'),
    'presionar': (0.264, 'Tristeza'),
    'privar': (0.496, 'Tristeza'),
    'quebranto': (0.628, 'Tristeza'),
    'reducir': (0.099, 'Tristeza'),
    'remordimiento': (0.595, 'Tristeza'),
    'ruina': (0.43, 'Tristeza'),
    'serio': (0.132, 'Tristeza'),
    'soledad': (0.763, 'Tristeza'),
    'solitario': (0.83, 'Tristeza'),
    'sollozar': (0.798, 'Tristeza'),
    'solo': (0.729, 'Tristeza'),
    'sombrío': (0.397, 'Tristeza'),
    'sufrimiento': (0.898, 'Tristeza'),
    'sufrir': (0.898, 'Tristeza'),
    'sumisamente': (0.43, 'Tristeza'),
    'taciturnidad': (0.431, 'Tristeza'),
    'taciturno': (0.464, 'Tristeza'),
    'tenebrosamente': (0.198, 'Tristeza'),
    'tenebrosidad': (0.132, 'Tristeza'),
    'tenebroso': (0.132, 'Tristeza'),
    'tétrico': (0.199, 'Tristeza'),
    'triste': (0.966, 'Tristeza'),
    'tristemente': (0.966, 'Tristeza'),
    'tristeza': (0.966, 'Tristeza'),
    'trizas': (0.464, 'Tristeza'),
    'zangarriana': (0.53, 'Tristeza'),
}
