import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export interface AfterCreateProps {
    /**
     * Resources to trigger on. Resources can come from any stack in the app.
     *
     * @default [] Run the trigger at any time during stack deployment.
     */
    readonly resources?: Construct[];
    /**
     * The handler to execute once after all the resources are created.
     *
     * The trigger will be executed every time the handler changes (code or
     * configuration).
     */
    readonly handler: lambda.Function;
}
export declare class AfterCreate extends Construct {
    constructor(scope: Construct, id: string, props: AfterCreateProps);
}
