"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AfterCreate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class AfterCreate extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const provider = aws_cdk_lib_1.CustomResourceProvider.getOrCreateProvider(this, 'AWSCDK.TriggerCustomResourceProvider', {
            runtime: aws_cdk_lib_1.CustomResourceProviderRuntime.NODEJS_14_X,
            codeDirectory: path_1.join(__dirname, '..', 'lambda'),
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: ['lambda:InvokeFunction'],
                    Resource: ['*'],
                },
            ],
        });
        const resource = new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            resourceType: 'Custom::Trigger',
            serviceToken: provider.serviceToken,
            properties: {
                // we use 'currentVersion' because a new version is created every time the
                // handler changes (either code or configuration). this will have the effect
                // that the trigger will be executed every time the handler is changed.
                HandlerArn: props.handler.currentVersion.functionArn,
            },
        });
        // add a dependency between our resource and the resources we want to invoke
        // after.
        resource.node.addDependency(...(_b = props.resources) !== null && _b !== void 0 ? _b : []);
    }
}
exports.AfterCreate = AfterCreate;
_a = JSII_RTTI_SYMBOL_1;
AfterCreate[_a] = { fqn: "cdk-triggers.AfterCreate", version: "0.1.35" };
//# sourceMappingURL=data:application/json;base64,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