# Copyright 2021 IRT Saint Exupéry, https://www.irt-saintexupery.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License version 3 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""Datasets post-processing.

A :class:`.DatasetPlot` is a generic graphical representation of a :class:`.Dataset`
that can be displayed on screen or saved to a file.
The different visualization tools
(:class:`.OptPostProcessor`, :meth:`.SensitivityAnalysis.plot`, ...)
proposed by |g| rely more and more on it
to factorize the code,
separate data and graph generation
and standardize the visualizations.

As an example,
:class:`~gemseo.post.dataset.radar_chart.RadarChart` implements a
`radar chart <https://en.wikipedia.org/wiki/Radar_chart>`__
and is used by both
:class:`~gemseo.post.radar_chart.RadarChart`
to visualize the constraints stored in a :class:`.Database`
and :meth:`.SensitivityAnalysis.plot_radar`
to visualize the sensitivity indices generated by a :class:`.SensitivityAnalysis`.
"""
from __future__ import annotations
