"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const cfnspec = require("../lib");
const schema_1 = require("../lib/schema");
function resourceAugmentationTest(resource) {
    return (test) => {
        const model = cfnspec.resourceAugmentation(resource);
        if (model.metrics) {
            test.ok(typeof (model.metrics.namespace) === 'string', `namespace is invalid: ${model.metrics.namespace}`);
            test.ok(typeof (model.metrics.dimensions) === 'object', `dimensions is invalid: ${model.metrics.dimensions}`);
            for (const metric of model.metrics.metrics) {
                test.ok(typeof metric.name === 'string', `name is invalid: ${metric.name}`);
                test.ok(typeof metric.documentation === 'string', `documentation is invalid: ${metric.documentation}`);
                test.ok(metric.type === undefined || [schema_1.MetricType.Attrib, schema_1.MetricType.Count, schema_1.MetricType.Gauge].includes(metric.type), `Metric Type is invalid: ${metric.type}`);
            }
        }
        test.done();
    };
}
const files = fs.readdirSync(path.resolve(__dirname, '../lib/augmentations'));
for (const file of files) {
    const resource = file.replace(/\.json$/, '').replace(/_/g, '::');
    exports[`Validate augmentation schema for ${resource}`] = resourceAugmentationTest(resource);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5hdWdtZW50YXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LmF1Z21lbnRhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHlCQUF5QjtBQUN6Qiw2QkFBNkI7QUFFN0Isa0NBQWtDO0FBQ2xDLDBDQUEyQztBQUUzQyxTQUFTLHdCQUF3QixDQUFDLFFBQWdCO0lBQ2hELE9BQU8sQ0FBQyxJQUFVLEVBQUUsRUFBRTtRQUNwQixNQUFNLEtBQUssR0FBRyxPQUFPLENBQUMsb0JBQW9CLENBQUMsUUFBUSxDQUFDLENBQUM7UUFFckQsSUFBSSxLQUFLLENBQUMsT0FBTyxFQUFFO1lBQ2pCLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBTSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLEtBQUssUUFBUSxFQUFFLHlCQUF5QixLQUFLLENBQUMsT0FBTyxDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUM7WUFDMUcsSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFNLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsS0FBSyxRQUFRLEVBQUUsMEJBQTBCLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQztZQUM3RyxLQUFLLE1BQU0sTUFBTSxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFO2dCQUMxQyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQU8sTUFBTSxDQUFDLElBQUksS0FBSyxRQUFRLEVBQUUsb0JBQW9CLE1BQU0sQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDO2dCQUM1RSxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQU8sTUFBTSxDQUFDLGFBQWEsS0FBSyxRQUFRLEVBQUUsNkJBQTZCLE1BQU0sQ0FBQyxhQUFhLEVBQUUsQ0FBQyxDQUFDO2dCQUN2RyxJQUFJLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssU0FBUyxJQUFJLENBQUMsbUJBQVUsQ0FBQyxNQUFNLEVBQUUsbUJBQVUsQ0FBQyxLQUFLLEVBQUUsbUJBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUNoSCwyQkFBMkIsTUFBTSxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7YUFDN0M7U0FDRjtRQUNELElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUMsQ0FBQztBQUNKLENBQUM7QUFFRCxNQUFNLEtBQUssR0FBRyxFQUFFLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxFQUFFLHNCQUFzQixDQUFDLENBQUMsQ0FBQztBQUM5RSxLQUFLLE1BQU0sSUFBSSxJQUFJLEtBQUssRUFBRTtJQUN4QixNQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsRUFBRSxFQUFFLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0lBQ2pFLE9BQU8sQ0FBQyxvQ0FBb0MsUUFBUSxFQUFFLENBQUMsR0FBRyx3QkFBd0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztDQUM5RiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzJztcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBUZXN0IH0gZnJvbSAnbm9kZXVuaXQnO1xuaW1wb3J0ICogYXMgY2Zuc3BlYyBmcm9tICcuLi9saWInO1xuaW1wb3J0IHsgTWV0cmljVHlwZSB9IGZyb20gJy4uL2xpYi9zY2hlbWEnO1xuXG5mdW5jdGlvbiByZXNvdXJjZUF1Z21lbnRhdGlvblRlc3QocmVzb3VyY2U6IHN0cmluZykge1xuICByZXR1cm4gKHRlc3Q6IFRlc3QpID0+IHtcbiAgICBjb25zdCBtb2RlbCA9IGNmbnNwZWMucmVzb3VyY2VBdWdtZW50YXRpb24ocmVzb3VyY2UpO1xuXG4gICAgaWYgKG1vZGVsLm1ldHJpY3MpIHtcbiAgICAgIHRlc3Qub2sodHlwZW9mKG1vZGVsLm1ldHJpY3MubmFtZXNwYWNlKSA9PT0gJ3N0cmluZycsIGBuYW1lc3BhY2UgaXMgaW52YWxpZDogJHttb2RlbC5tZXRyaWNzLm5hbWVzcGFjZX1gKTtcbiAgICAgIHRlc3Qub2sodHlwZW9mKG1vZGVsLm1ldHJpY3MuZGltZW5zaW9ucykgPT09ICdvYmplY3QnLCBgZGltZW5zaW9ucyBpcyBpbnZhbGlkOiAke21vZGVsLm1ldHJpY3MuZGltZW5zaW9uc31gKTtcbiAgICAgIGZvciAoY29uc3QgbWV0cmljIG9mIG1vZGVsLm1ldHJpY3MubWV0cmljcykge1xuICAgICAgICB0ZXN0Lm9rKHR5cGVvZiBtZXRyaWMubmFtZSA9PT0gJ3N0cmluZycsIGBuYW1lIGlzIGludmFsaWQ6ICR7bWV0cmljLm5hbWV9YCk7XG4gICAgICAgIHRlc3Qub2sodHlwZW9mIG1ldHJpYy5kb2N1bWVudGF0aW9uID09PSAnc3RyaW5nJywgYGRvY3VtZW50YXRpb24gaXMgaW52YWxpZDogJHttZXRyaWMuZG9jdW1lbnRhdGlvbn1gKTtcbiAgICAgICAgdGVzdC5vayhtZXRyaWMudHlwZSA9PT0gdW5kZWZpbmVkIHx8IFtNZXRyaWNUeXBlLkF0dHJpYiwgTWV0cmljVHlwZS5Db3VudCwgTWV0cmljVHlwZS5HYXVnZV0uaW5jbHVkZXMobWV0cmljLnR5cGUpLFxuICAgICAgICAgIGBNZXRyaWMgVHlwZSBpcyBpbnZhbGlkOiAke21ldHJpYy50eXBlfWApO1xuICAgICAgfVxuICAgIH1cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfTtcbn1cblxuY29uc3QgZmlsZXMgPSBmcy5yZWFkZGlyU3luYyhwYXRoLnJlc29sdmUoX19kaXJuYW1lLCAnLi4vbGliL2F1Z21lbnRhdGlvbnMnKSk7XG5mb3IgKGNvbnN0IGZpbGUgb2YgZmlsZXMpIHtcbiAgY29uc3QgcmVzb3VyY2UgPSBmaWxlLnJlcGxhY2UoL1xcLmpzb24kLywgJycpLnJlcGxhY2UoL18vZywgJzo6Jyk7XG4gIGV4cG9ydHNbYFZhbGlkYXRlIGF1Z21lbnRhdGlvbiBzY2hlbWEgZm9yICR7cmVzb3VyY2V9YF0gPSByZXNvdXJjZUF1Z21lbnRhdGlvblRlc3QocmVzb3VyY2UpO1xufVxuIl19