"use strict";
const nodeunit_1 = require("nodeunit");
const index_1 = require("../lib/index");
const spec_validators_1 = require("./spec-validators");
const tests = {
    'filteredSpecification(/^AWS::S3::.*/)'(test) {
        const filteredSpec = index_1.filteredSpecification(/^AWS::S3::.*/);
        test.notDeepEqual(filteredSpec, index_1.specification, 'The filteredSpecification result is not the whole specification');
        test.notDeepEqual(filteredSpec.ResourceTypes, {}, 'The filtered spec is not empty');
        test.done();
    },
    'filteredSpecification(s => s.startsWith("AWS::S3::")'(test) {
        const filteredSpec = index_1.filteredSpecification(s => s.startsWith('AWS::S3::'));
        test.notDeepEqual(filteredSpec, index_1.specification, 'The filteredSpecification result is not the whole specification');
        test.notDeepEqual(filteredSpec.ResourceTypes, {}, 'The filtered spec is not empty');
        test.done();
    },
};
for (const name of index_1.resourceTypes().sort()) {
    tests[`filteredSpecification(${JSON.stringify(name)})`] = (test) => {
        const filteredSpec = index_1.filteredSpecification(name);
        test.notDeepEqual(filteredSpec, index_1.specification, 'The filteredSpecification result is not the whole specification');
        test.notDeepEqual(filteredSpec.ResourceTypes, {}, 'The filtered spec is not empty');
        // Validate the spec is conform & coherent.
        spec_validators_1.validateSpecification(test, filteredSpec);
        test.done();
    };
}
module.exports = nodeunit_1.testCase(tests);
//# sourceMappingURL=data:application/json;base64,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