import { Construct } from 'constructs';
import { CfnElement } from './cfn-element';
/**
 * Construction properties of {@link CfnHook}.
 *
 * @stability stable
 */
export interface CfnHookProps {
    /**
     * The type of the hook (for example, "AWS::CodeDeploy::BlueGreen").
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * The properties of the hook.
     *
     * @default - no properties
     * @stability stable
     */
    readonly properties?: {
        [name: string]: any;
    };
}
/**
 * Represents a CloudFormation resource.
 *
 * @stability stable
 */
export declare class CfnHook extends CfnElement {
    /**
     * The type of the hook (for example, "AWS::CodeDeploy::BlueGreen").
     *
     * @stability stable
     */
    readonly type: string;
    private readonly _cfnHookProperties?;
    /**
     * Creates a new Hook object.
     *
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CfnHookProps);
    /** @internal */
    _toCloudFormation(): object;
    /**
     * @stability stable
     */
    protected renderProperties(props?: {
        [key: string]: any;
    }): {
        [key: string]: any;
    } | undefined;
}
