import { Construct } from 'constructs';
import { ConstructNode } from './construct-compat';
/**
 * Functions for devising unique names for constructs.
 *
 * For example, those can be
 * used to allocate unique physical names for resources.
 *
 * @stability stable
 */
export declare class Names {
    /**
     * Returns a CloudFormation-compatible unique identifier for a construct based on its path.
     *
     * The identifier includes a human readable portion rendered
     * from the path components and a hash suffix.
     *
     * @param construct The construct.
     * @returns a unique id based on the construct path
     * @stability stable
     */
    static uniqueId(construct: Construct): string;
    /**
     * Returns a CloudFormation-compatible unique identifier for a construct based on its path.
     *
     * The identifier includes a human readable portion rendered
     * from the path components and a hash suffix.
     *
     * TODO (v2): replace with API to use `constructs.Node`.
     *
     * @param node The construct node.
     * @returns a unique id based on the construct path
     * @stability stable
     */
    static nodeUniqueId(node: ConstructNode): string;
    private constructor();
}
