import * as cxschema from '@aws-cdk/cloud-assembly-schema';
import { CloudArtifact } from '../cloud-artifact';
import { CloudAssembly } from '../cloud-assembly';
/**
 * Asset manifest is a description of a set of assets which need to be built and published.
 *
 * @stability stable
 */
export declare class NestedCloudAssemblyArtifact extends CloudArtifact {
    /**
     * The relative directory name of the asset manifest.
     *
     * @stability stable
     */
    readonly directoryName: string;
    /**
     * Display name.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Cache for the inner assembly loading
     */
    private _nestedAssembly?;
    /**
     * @stability stable
     */
    constructor(assembly: CloudAssembly, name: string, artifact: cxschema.ArtifactManifest);
    /**
     * Full path to the nested assembly directory.
     *
     * @stability stable
     */
    get fullPath(): string;
    /**
     * The nested Assembly.
     *
     * @stability stable
     */
    get nestedAssembly(): CloudAssembly;
}
