"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackStatus = void 0;
/**
 * A utility class to inspect CloudFormation stack statuses.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html
 */
class StackStatus {
    constructor(name, reason) {
        this.name = name;
        this.reason = reason;
    }
    static fromStackDescription(description) {
        return new StackStatus(description.StackStatus, description.StackStatusReason);
    }
    get isCreationFailure() {
        return this.name === 'ROLLBACK_COMPLETE'
            || this.name === 'ROLLBACK_FAILED';
    }
    get isDeleted() {
        return this.name.startsWith('DELETE_');
    }
    get isFailure() {
        return this.name.endsWith('FAILED');
    }
    get isInProgress() {
        return this.name.endsWith('_IN_PROGRESS');
    }
    get isNotFound() {
        return this.name === 'NOT_FOUND';
    }
    get isDeploySuccess() {
        return !this.isNotFound && (this.name === 'CREATE_COMPLETE' || this.name === 'UPDATE_COMPLETE');
    }
    toString() {
        return this.name + (this.reason ? ` (${this.reason})` : '');
    }
}
exports.StackStatus = StackStatus;
//# sourceMappingURL=data:application/json;base64,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