"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointServiceAZContextProviderPlugin = void 0;
const cxapi = require("@aws-cdk/cx-api");
const api_1 = require("../api");
const logging_1 = require("../logging");
/**
 * Plugin to retrieve the Availability Zones for an endpoint service
 */
class EndpointServiceAZContextProviderPlugin {
    constructor(aws) {
        this.aws = aws;
    }
    async getValue(args) {
        const region = args.region;
        const account = args.account;
        const serviceName = args.serviceName;
        logging_1.debug(`Reading AZs for ${account}:${region}:${serviceName}`);
        const options = { assumeRoleArn: args.lookupRoleArn };
        const ec2 = (await this.aws.forEnvironment(cxapi.EnvironmentUtils.make(account, region), api_1.Mode.ForReading, options)).ec2();
        const response = await ec2.describeVpcEndpointServices({ ServiceNames: [serviceName] }).promise();
        // expect a service in the response
        if (!response.ServiceDetails || response.ServiceDetails.length === 0) {
            logging_1.debug(`Could not retrieve service details for ${account}:${region}:${serviceName}`);
            return [];
        }
        const azs = response.ServiceDetails[0].AvailabilityZones;
        logging_1.debug(`Endpoint service ${account}:${region}:${serviceName} is available in availability zones ${azs}`);
        return azs;
    }
}
exports.EndpointServiceAZContextProviderPlugin = EndpointServiceAZContextProviderPlugin;
//# sourceMappingURL=data:application/json;base64,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