"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ifDefined = exports.isArray = exports.isObject = void 0;
/**
 * Return whether the given value is an object
 *
 * Even though arrays technically are objects, we usually want to treat them differently,
 * so we return false in those cases.
 */
function isObject(x) {
    return x !== null && typeof x === 'object' && !exports.isArray(x);
}
exports.isObject = isObject;
/**
 * Return whether the given value is an array
 */
exports.isArray = Array.isArray;
/**
 * Return the value of the first argument if it's not undefined, otherwise the default
 */
function ifDefined(x, def) {
    return typeof x !== 'undefined' ? x : def;
}
exports.ifDefined = ifDefined;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0eXBlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFXQTs7Ozs7R0FLRztBQUNILFNBQWdCLFFBQVEsQ0FBQyxDQUFNO0lBQzdCLE9BQU8sQ0FBQyxLQUFLLElBQUksSUFBSSxPQUFPLENBQUMsS0FBSyxRQUFRLElBQUksQ0FBQyxlQUFPLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDNUQsQ0FBQztBQUZELDRCQUVDO0FBRUQ7O0dBRUc7QUFDVSxRQUFBLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO0FBRXJDOztHQUVHO0FBQ0gsU0FBZ0IsU0FBUyxDQUFJLENBQWdCLEVBQUUsR0FBTTtJQUNuRCxPQUFPLE9BQU8sQ0FBQyxLQUFLLFdBQVcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUM7QUFDNUMsQ0FBQztBQUZELDhCQUVDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBUeXBlIG9mIGEgbWFwIG1hcHBpbmcgc3RyaW5ncyB0byBzb21lIGFyYml0cmFyeSB0eXBlXG4gKlxuICogTmFtZSBpcyBub3QgaWRlYWwsIGJ1dDpcbiAqXG4gKiAtIENhbm5vdCBjYWxsIGl0IE9iamVjdCwgdGhhdCBhbHJlYWR5IG1lYW5zIHNvbWV0aGluZy5cbiAqIC0gQ2Fubm90IGNhbGwgaXQgRGljdCBvciBEaWN0aW9uYXJ5LCBzaW5jZSBpbiBvdGhlciBsYW5ndWFnZXNcbiAqICAgdGhvc2UgYWxzbyBhbGxvdyBzcGVjaWZ5aW5nIHRoZSBrZXkgdHlwZS5cbiAqL1xuZXhwb3J0IHR5cGUgT2JqPFQ+ID0ge1trZXk6IHN0cmluZ106IFR9O1xuXG4vKipcbiAqIFJldHVybiB3aGV0aGVyIHRoZSBnaXZlbiB2YWx1ZSBpcyBhbiBvYmplY3RcbiAqXG4gKiBFdmVuIHRob3VnaCBhcnJheXMgdGVjaG5pY2FsbHkgYXJlIG9iamVjdHMsIHdlIHVzdWFsbHkgd2FudCB0byB0cmVhdCB0aGVtIGRpZmZlcmVudGx5LFxuICogc28gd2UgcmV0dXJuIGZhbHNlIGluIHRob3NlIGNhc2VzLlxuICovXG5leHBvcnQgZnVuY3Rpb24gaXNPYmplY3QoeDogYW55KTogeCBpcyBPYmo8YW55PiB7XG4gIHJldHVybiB4ICE9PSBudWxsICYmIHR5cGVvZiB4ID09PSAnb2JqZWN0JyAmJiAhaXNBcnJheSh4KTtcbn1cblxuLyoqXG4gKiBSZXR1cm4gd2hldGhlciB0aGUgZ2l2ZW4gdmFsdWUgaXMgYW4gYXJyYXlcbiAqL1xuZXhwb3J0IGNvbnN0IGlzQXJyYXkgPSBBcnJheS5pc0FycmF5O1xuXG4vKipcbiAqIFJldHVybiB0aGUgdmFsdWUgb2YgdGhlIGZpcnN0IGFyZ3VtZW50IGlmIGl0J3Mgbm90IHVuZGVmaW5lZCwgb3RoZXJ3aXNlIHRoZSBkZWZhdWx0XG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBpZkRlZmluZWQ8VD4oeDogVCB8IHVuZGVmaW5lZCwgZGVmOiBUKTogVCB7XG4gIHJldHVybiB0eXBlb2YgeCAhPT0gJ3VuZGVmaW5lZCcgPyB4IDogZGVmO1xufVxuIl19