"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws = require("aws-sdk");
const AWS = require("aws-sdk-mock");
const ami_1 = require("../../lib/context-providers/ami");
const mock_sdk_1 = require("../util/mock-sdk");
AWS.setSDKInstance(aws);
afterEach(done => {
    AWS.restore();
    done();
});
const mockSDK = new mock_sdk_1.MockSdkProvider();
test('calls DescribeImages on the request', async () => {
    // GIVEN
    let request;
    AWS.mock('EC2', 'describeImages', (params, cb) => {
        request = params;
        return cb(null, { Images: [{ ImageId: 'ami-1234' }] });
    });
    // WHEN
    await new ami_1.AmiContextProviderPlugin(mockSDK).getValue({
        account: '1234',
        region: 'asdf',
        owners: ['some-owner'],
        filters: {
            'some-filter': ['filtered'],
        },
    });
    // THEN
    expect(request).toEqual({
        Owners: ['some-owner'],
        Filters: [
            {
                Name: 'some-filter',
                Values: ['filtered'],
            },
        ],
    });
});
test('returns the most recent AMI matching the criteria', async () => {
    // GIVEN
    AWS.mock('EC2', 'describeImages', (_, cb) => {
        return cb(null, {
            Images: [
                {
                    ImageId: 'ami-1234',
                    CreationDate: '2016-06-22T08:39:59.000Z',
                },
                {
                    ImageId: 'ami-5678',
                    CreationDate: '2019-06-22T08:39:59.000Z',
                },
            ],
        });
    });
    // WHEN
    const result = await new ami_1.AmiContextProviderPlugin(mockSDK).getValue({
        account: '1234',
        region: 'asdf',
        filters: {},
    });
    // THEN
    expect(result).toBe('ami-5678');
});
//# sourceMappingURL=data:application/json;base64,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