"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../../lib/util");
test('flatten combines arrays', () => {
    const output = util_1.flatten([
        ['a', 'b'],
        [],
        ['c'],
    ]);
    expect(output).toEqual(['a', 'b', 'c']);
});
test('flatMap maps and combines', () => {
    const input = ['A', 'B', 'C'];
    const output = util_1.flatMap(input, x => [x.toLowerCase()]);
    expect(output).toEqual(['a', 'b', 'c']);
});
test('partition splits the collection in twain', () => {
    const xs = [1, 2, 3, 4, 5];
    const evens = util_1.partition(xs, x => x % 2 === 0);
    expect(evens).toEqual([2, 4]);
    expect(xs).toEqual([1, 3, 5]);
});
//# sourceMappingURL=data:application/json;base64,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