"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const AWS = require("aws-sdk");
const awscli_compatible_1 = require("../../lib/api/aws-auth/awscli-compatible");
const util_1 = require("../util");
beforeEach(() => {
    // Set to paths that don't exist so the SDK doesn't accidentally load this config
    process.env.AWS_CONFIG_FILE = '/home/dummydummy/.bxt/config';
    process.env.AWS_SHARED_CREDENTIALS_FILE = '/home/dummydummy/.bxt/credentials';
    // Scrub some environment variables that might be set if we're running on CodeBuild which will interfere with the tests.
    delete process.env.AWS_REGION;
    delete process.env.AWS_DEFAULT_REGION;
    delete process.env.AWS_ACCESS_KEY_ID;
    delete process.env.AWS_SECRET_ACCESS_KEY;
    delete process.env.AWS_SESSION_TOKEN;
});
test('on an EC2 instance, region lookup queries IMDS', async () => {
    return util_1.withMockedClassSingleton(AWS, 'MetadataService', async (mdService) => {
        mdService.request
            // First call for a token
            .mockImplementationOnce((_1, _2, cb) => { cb(undefined, 'token'); })
            // Second call for the region
            .mockImplementationOnce((_1, _2, cb) => { cb(undefined, JSON.stringify({ region: 'some-region' })); });
        const region = await awscli_compatible_1.AwsCliCompatible.region({ ec2instance: true });
        expect(region).toEqual('some-region');
    });
});
test('Use web identity when available', async () => {
    // Scrub some environment variables that are maybe set for Ecs Credentials
    delete process.env.ECS_CONTAINER_METADATA_URI_V4;
    delete process.env.ECS_CONTAINER_METADATA_URI;
    delete process.env.AWS_CONTAINER_CREDENTIALS_RELATIVE_URI;
    // create and configure the web identity token file
    process.env.AWS_WEB_IDENTITY_TOKEN_FILE = 'some-value';
    process.env.AWS_ROLE_ARN = 'some-value';
    // create the chain
    const providers = (await awscli_compatible_1.AwsCliCompatible.credentialChain()).providers;
    // make sure the web identity provider is in the chain
    const webIdentify = providers[2]();
    expect(webIdentify).toBeInstanceOf(AWS.TokenFileWebIdentityCredentials);
});
//# sourceMappingURL=data:application/json;base64,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