"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockToolkitInfo = void 0;
const api_1 = require("../../lib/api");
function mockLike() {
    return jest.fn();
}
class MockToolkitInfo extends api_1.ToolkitInfo {
    constructor(sdk, props = {}) {
        var _a, _b, _c;
        super(sdk);
        this.found = true;
        this.prepareEcrRepository = mockLike();
        this.bucketName = (_a = props.bucketName) !== null && _a !== void 0 ? _a : 'MockToolkitBucketName';
        this.bucketUrl = (_b = props.bucketUrl) !== null && _b !== void 0 ? _b : `https://${this.bucketName}.s3.amazonaws.com/`;
        this.version = (_c = props.version) !== null && _c !== void 0 ? _c : 1;
        this._bootstrapStack = props.bootstrapStack;
    }
    get bootstrapStack() {
        if (!this._bootstrapStack) {
            throw new Error('Bootstrap stack object expected but not supplied to MockToolkitInfo');
        }
        return this._bootstrapStack;
    }
    async validateVersion(expectedVersion, ssmParameterName) {
        const version = ssmParameterName !== undefined ? await this.versionFromSsmParameter(ssmParameterName) : this.version;
        if (expectedVersion > version) {
            throw new Error(`This CDK deployment requires bootstrap stack version '${expectedVersion}', found '${version}'. Please run 'cdk bootstrap' with a newer CLI version.`);
        }
    }
}
exports.MockToolkitInfo = MockToolkitInfo;
//# sourceMappingURL=data:application/json;base64,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