"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../../lib/util");
test('deepSet can set deeply', () => {
    const obj = {};
    util_1.deepSet(obj, ['a', 'b'], 3);
    expect(obj).toEqual({ a: { b: 3 } });
});
test('deepGet can get deeply', () => {
    const obj = { a: { b: 3 } };
    expect(util_1.deepGet(obj, ['a', 'b'])).toBe(3);
});
test('deepGet can return an array', () => {
    const obj = { a: [1, 2, 3] };
    expect(util_1.deepGet(obj, ['a'])).toEqual([1, 2, 3]);
});
test('changing deepClones copy leaves the original intact', () => {
    const original = { a: [{ b: 3 }] };
    const copy = util_1.deepClone(original);
    copy.a[0].c = 5;
    expect(original).toEqual({ a: [{ b: 3 }] });
});
test('deepMerge merges objects', () => {
    const original = { a: { b: 3 } };
    util_1.deepMerge(original, { a: { c: 4 } });
    expect(original).toEqual({ a: { b: 3, c: 4 } });
});
test('deepMerge overwrites non-objects', () => {
    const original = { a: [] };
    util_1.deepMerge(original, { a: { b: 3 } });
    expect(original).toEqual({ a: { b: 3 } });
});
test('deepMerge does not overwrite if rightmost is "undefined"', () => {
    const original = { a: 1 };
    util_1.deepMerge(original, { a: undefined });
    expect(original).toEqual({ a: 1 });
});
//# sourceMappingURL=data:application/json;base64,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