import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [healthlake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonhealthlake.html).
 *
 * @experimental
 */
export declare class Healthlake extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to create a datastore that can ingest and export FHIR data.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_CreateFHIRDatastore.html
     *
     * @experimental
     */
    toCreateFHIRDatastore(): this;
    /**
     * (experimental) Grants permission to create resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/crud-healthlake.html
     *
     * @experimental
     */
    toCreateResource(): this;
    /**
     * (experimental) Grants permission to delete a datastore.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_DeleteFHIRDatastore.html
     *
     * @experimental
     */
    toDeleteFHIRDatastore(): this;
    /**
     * (experimental) Grants permission to delete resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/crud-healthlake.html
     *
     * @experimental
     */
    toDeleteResource(): this;
    /**
     * (experimental) Grants permission to get the properties associated with the FHIR datastore, including the datastore ID, datastore ARN, datastore name, datastore status, created at, datastore type version, and datastore endpoint.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_DescribeFHIRDatastore.html
     *
     * @experimental
     */
    toDescribeFHIRDatastore(): this;
    /**
     * (experimental) Grants permission to display the properties of a FHIR export job, including the ID, ARN, name, and the status of the datastore.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_DescribeFHIRExportJob.html
     *
     * @experimental
     */
    toDescribeFHIRExportJob(): this;
    /**
     * (experimental) Grants permission to display the properties of a FHIR import job, including the ID, ARN, name, and the status of the datastore.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_DescribeFHIRImportJob.html
     *
     * @experimental
     */
    toDescribeFHIRImportJob(): this;
    /**
     * (experimental) Grants permission to get the capabilities of a FHIR datastore.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/crud-healthlake.html
     *
     * @experimental
     */
    toGetCapabilities(): this;
    /**
     * (experimental) Grants permission to list all FHIR datastores that are in the user’s account, regardless of datastore status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_ListFHIRDatastores.html
     *
     * @experimental
     */
    toListFHIRDatastores(): this;
    /**
     * (experimental) Grants permission to get a list of export jobs for the specified datastore.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_ListFHIRExportJobs.html
     *
     * @experimental
     */
    toListFHIRExportJobs(): this;
    /**
     * (experimental) Grants permission to get a list of import jobs for the specified datastore.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_ListFHIRImportJobs.html
     *
     * @experimental
     */
    toListFHIRImportJobs(): this;
    /**
     * (experimental) Grants permission to get a list of tags for the specified datastore.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to read resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/crud-healthlake.html
     *
     * @experimental
     */
    toReadResource(): this;
    /**
     * (experimental) Grants permission to search resources with GET method.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/search-healthlake.html
     *
     * @experimental
     */
    toSearchWithGet(): this;
    /**
     * (experimental) Grants permission to search resources with POST method.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/search-healthlake.html
     *
     * @experimental
     */
    toSearchWithPost(): this;
    /**
     * (experimental) Grants permission to begin a FHIR Export job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_StartFHIRExportJob.html
     *
     * @experimental
     */
    toStartFHIRExportJob(): this;
    /**
     * (experimental) Grants permission to begin a FHIR Import job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_StartFHIRImportJob.html
     *
     * @experimental
     */
    toStartFHIRImportJob(): this;
    /**
     * (experimental) Grants permission to add tags to a datastore.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags associated with a datastore.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/crud-healthlake.html
     *
     * @experimental
     */
    toUpdateResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type datastore to the statement.
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_DatastoreProperties.html
     *
     * @param datastoreId - Identifier for the datastoreId.
     * @param accountId - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDatastore(datastoreId: string, accountId?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [healthlake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonhealthlake.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
