import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
 *
 * @experimental
 */
export declare class Support extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Adds one or more attachments to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html
     *
     * @experimental
     */
    toAddAttachmentsToSet(): this;
    /**
     * (experimental) Adds a customer communication to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html
     *
     * @experimental
     */
    toAddCommunicationToCase(): this;
    /**
     * (experimental) Creates a new AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html
     *
     * @experimental
     */
    toCreateCase(): this;
    /**
     * (experimental) Returns the description for an attachment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html
     *
     * @experimental
     */
    toDescribeAttachment(): this;
    /**
     * (experimental) This is an internally managed function which allows secondary services to read AWS Support case attributes.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeCaseAttributes(): this;
    /**
     * (experimental) Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html
     *
     * @experimental
     */
    toDescribeCases(): this;
    /**
     * (experimental) Returns the communications and attachments for one or more AWS Support cases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html
     *
     * @experimental
     */
    toDescribeCommunications(): this;
    /**
     * (experimental) Returns issue types for AWS Support cases.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeIssueTypes(): this;
    /**
     * (experimental) Returns the current list of AWS services and categories that applies to each service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html
     *
     * @experimental
     */
    toDescribeServices(): this;
    /**
     * (experimental) Returns the list of severity levels that can be assigned to an AWS Support case.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html
     *
     * @experimental
     */
    toDescribeSeverityLevels(): this;
    /**
     * (experimental) Returns the support level for an AWS Account identifier.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeSupportLevel(): this;
    /**
     * (experimental) Returns the status of a Trusted Advisor refresh check based on a list of check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorCheckRefreshStatuses(): this;
    /**
     * (experimental) Returns the results of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorCheckResult(): this;
    /**
     * (experimental) Returns the summaries of the results of the Trusted Advisor checks that have the specified check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorCheckSummaries(): this;
    /**
     * (experimental) Returns a list of all available Trusted Advisor checks, including name, identifier, category and description.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorChecks(): this;
    /**
     * (experimental) This is an internally managed function to initiate a call on AWS Support Center.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toInitiateCallForCase(): this;
    /**
     * (experimental) This is an internally managed function to initiate a chat on AWS Support Center.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toInitiateChatForCase(): this;
    /**
     * (experimental) This is an internally managed function which allows secondary services to attach attributes to AWS Support cases.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toPutCaseAttributes(): this;
    /**
     * (experimental) Rate an AWS Support case communication.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toRateCaseCommunication(): this;
    /**
     * (experimental) Requests a refresh of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html
     *
     * @experimental
     */
    toRefreshTrustedAdvisorCheck(): this;
    /**
     * (experimental) Resolves an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html
     *
     * @experimental
     */
    toResolveCase(): this;
    /**
     * (experimental) Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toSearchForCases(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
