# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 file_shares: pulumi.Input['InstanceFileSharesArgs'],
                 networks: pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]],
                 tier: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input['InstanceFileSharesArgs'] file_shares: File system shares on the instance. For this version, only a
               single file share is supported.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]] networks: VPC networks to which the instance is connected. For this version,
               only a single network is supported.
               Structure is documented below.
        :param pulumi.Input[str] tier: The service tier of the instance.
               Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD and ENTERPRISE
        :param pulumi.Input[str] description: A description of the instance.
        :param pulumi.Input[str] kms_key_name: KMS key name used for data encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user-provided metadata.
        :param pulumi.Input[str] location: The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        :param pulumi.Input[str] name: The name of the fileshare (16 characters or less)
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] zone: -
               (Optional, Deprecated)
               The name of the Filestore zone of the instance.
        """
        pulumi.set(__self__, "file_shares", file_shares)
        pulumi.set(__self__, "networks", networks)
        pulumi.set(__self__, "tier", tier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if zone is not None:
            warnings.warn("""Deprecated in favor of location.""", DeprecationWarning)
            pulumi.log.warn("""zone is deprecated: Deprecated in favor of location.""")
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="fileShares")
    def file_shares(self) -> pulumi.Input['InstanceFileSharesArgs']:
        """
        File system shares on the instance. For this version, only a
        single file share is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "file_shares")

    @file_shares.setter
    def file_shares(self, value: pulumi.Input['InstanceFileSharesArgs']):
        pulumi.set(self, "file_shares", value)

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]:
        """
        VPC networks to which the instance is connected. For this version,
        only a single network is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[str]:
        """
        The service tier of the instance.
        Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD and ENTERPRISE
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        KMS key name used for data encryption.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels to represent user-provided metadata.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the fileshare (16 characters or less)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        -
        (Optional, Deprecated)
        The name of the Filestore zone of the instance.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 file_shares: Optional[pulumi.Input['InstanceFileSharesArgs']] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] create_time: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: A description of the instance.
        :param pulumi.Input[str] etag: Server-specified ETag for the instance resource to prevent simultaneous updates from overwriting each other.
        :param pulumi.Input['InstanceFileSharesArgs'] file_shares: File system shares on the instance. For this version, only a
               single file share is supported.
               Structure is documented below.
        :param pulumi.Input[str] kms_key_name: KMS key name used for data encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user-provided metadata.
        :param pulumi.Input[str] location: The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        :param pulumi.Input[str] name: The name of the fileshare (16 characters or less)
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]] networks: VPC networks to which the instance is connected. For this version,
               only a single network is supported.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] tier: The service tier of the instance.
               Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD and ENTERPRISE
        :param pulumi.Input[str] zone: -
               (Optional, Deprecated)
               The name of the Filestore zone of the instance.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if file_shares is not None:
            pulumi.set(__self__, "file_shares", file_shares)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if zone is not None:
            warnings.warn("""Deprecated in favor of location.""", DeprecationWarning)
            pulumi.log.warn("""zone is deprecated: Deprecated in favor of location.""")
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Server-specified ETag for the instance resource to prevent simultaneous updates from overwriting each other.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="fileShares")
    def file_shares(self) -> Optional[pulumi.Input['InstanceFileSharesArgs']]:
        """
        File system shares on the instance. For this version, only a
        single file share is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "file_shares")

    @file_shares.setter
    def file_shares(self, value: Optional[pulumi.Input['InstanceFileSharesArgs']]):
        pulumi.set(self, "file_shares", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        KMS key name used for data encryption.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels to represent user-provided metadata.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the fileshare (16 characters or less)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]]:
        """
        VPC networks to which the instance is connected. For this version,
        only a single network is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The service tier of the instance.
        Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD and ENTERPRISE
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        -
        (Optional, Deprecated)
        The name of the Filestore zone of the instance.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_shares: Optional[pulumi.Input[pulumi.InputType['InstanceFileSharesArgs']]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Google Cloud Filestore instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/filestore/docs/reference/rest/v1beta1/projects.locations.instances/create)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/filestore/docs/creating-instances)
            * [Use with Kubernetes](https://cloud.google.com/filestore/docs/accessing-fileshares)
            * [Copying Data In/Out](https://cloud.google.com/filestore/docs/copying-data)

        ## Example Usage
        ### Filestore Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.filestore.Instance("instance",
            file_shares=gcp.filestore.InstanceFileSharesArgs(
                capacity_gb=2660,
                name="share1",
            ),
            location="us-central1-b",
            networks=[gcp.filestore.InstanceNetworkArgs(
                modes=["MODE_IPV4"],
                network="default",
            )],
            tier="PREMIUM")
        ```
        ### Filestore Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.filestore.Instance("instance",
            file_shares=gcp.filestore.InstanceFileSharesArgs(
                capacity_gb=2660,
                name="share1",
                nfs_export_options=[
                    gcp.filestore.InstanceFileSharesNfsExportOptionArgs(
                        access_mode="READ_WRITE",
                        ip_ranges=["10.0.0.0/24"],
                        squash_mode="NO_ROOT_SQUASH",
                    ),
                    gcp.filestore.InstanceFileSharesNfsExportOptionArgs(
                        access_mode="READ_ONLY",
                        anon_gid=456,
                        anon_uid=123,
                        ip_ranges=["10.10.0.0/24"],
                        squash_mode="ROOT_SQUASH",
                    ),
                ],
            ),
            location="us-central1-b",
            networks=[gcp.filestore.InstanceNetworkArgs(
                connect_mode="DIRECT_PEERING",
                modes=["MODE_IPV4"],
                network="default",
            )],
            tier="BASIC_SSD")
        ```
        ### Filestore Instance Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        filestore_keyring = gcp.kms.KeyRing("filestoreKeyring", location="us-central1")
        filestore_key = gcp.kms.CryptoKey("filestoreKey", key_ring=filestore_keyring.id)
        instance = gcp.filestore.Instance("instance",
            location="us-central1",
            tier="ENTERPRISE",
            file_shares=gcp.filestore.InstanceFileSharesArgs(
                capacity_gb=2560,
                name="share1",
            ),
            networks=[gcp.filestore.InstanceNetworkArgs(
                network="default",
                modes=["MODE_IPV4"],
            )],
            kms_key_name=filestore_key.id)
        ```

        ## Import

        Instance can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:filestore/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{name}}
        ```

        ```sh
         $ pulumi import gcp:filestore/instance:Instance default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:filestore/instance:Instance default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the instance.
        :param pulumi.Input[pulumi.InputType['InstanceFileSharesArgs']] file_shares: File system shares on the instance. For this version, only a
               single file share is supported.
               Structure is documented below.
        :param pulumi.Input[str] kms_key_name: KMS key name used for data encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user-provided metadata.
        :param pulumi.Input[str] location: The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        :param pulumi.Input[str] name: The name of the fileshare (16 characters or less)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkArgs']]]] networks: VPC networks to which the instance is connected. For this version,
               only a single network is supported.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] tier: The service tier of the instance.
               Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD and ENTERPRISE
        :param pulumi.Input[str] zone: -
               (Optional, Deprecated)
               The name of the Filestore zone of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Filestore instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/filestore/docs/reference/rest/v1beta1/projects.locations.instances/create)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/filestore/docs/creating-instances)
            * [Use with Kubernetes](https://cloud.google.com/filestore/docs/accessing-fileshares)
            * [Copying Data In/Out](https://cloud.google.com/filestore/docs/copying-data)

        ## Example Usage
        ### Filestore Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.filestore.Instance("instance",
            file_shares=gcp.filestore.InstanceFileSharesArgs(
                capacity_gb=2660,
                name="share1",
            ),
            location="us-central1-b",
            networks=[gcp.filestore.InstanceNetworkArgs(
                modes=["MODE_IPV4"],
                network="default",
            )],
            tier="PREMIUM")
        ```
        ### Filestore Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.filestore.Instance("instance",
            file_shares=gcp.filestore.InstanceFileSharesArgs(
                capacity_gb=2660,
                name="share1",
                nfs_export_options=[
                    gcp.filestore.InstanceFileSharesNfsExportOptionArgs(
                        access_mode="READ_WRITE",
                        ip_ranges=["10.0.0.0/24"],
                        squash_mode="NO_ROOT_SQUASH",
                    ),
                    gcp.filestore.InstanceFileSharesNfsExportOptionArgs(
                        access_mode="READ_ONLY",
                        anon_gid=456,
                        anon_uid=123,
                        ip_ranges=["10.10.0.0/24"],
                        squash_mode="ROOT_SQUASH",
                    ),
                ],
            ),
            location="us-central1-b",
            networks=[gcp.filestore.InstanceNetworkArgs(
                connect_mode="DIRECT_PEERING",
                modes=["MODE_IPV4"],
                network="default",
            )],
            tier="BASIC_SSD")
        ```
        ### Filestore Instance Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        filestore_keyring = gcp.kms.KeyRing("filestoreKeyring", location="us-central1")
        filestore_key = gcp.kms.CryptoKey("filestoreKey", key_ring=filestore_keyring.id)
        instance = gcp.filestore.Instance("instance",
            location="us-central1",
            tier="ENTERPRISE",
            file_shares=gcp.filestore.InstanceFileSharesArgs(
                capacity_gb=2560,
                name="share1",
            ),
            networks=[gcp.filestore.InstanceNetworkArgs(
                network="default",
                modes=["MODE_IPV4"],
            )],
            kms_key_name=filestore_key.id)
        ```

        ## Import

        Instance can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:filestore/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{name}}
        ```

        ```sh
         $ pulumi import gcp:filestore/instance:Instance default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:filestore/instance:Instance default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_shares: Optional[pulumi.Input[pulumi.InputType['InstanceFileSharesArgs']]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["description"] = description
            if file_shares is None and not opts.urn:
                raise TypeError("Missing required property 'file_shares'")
            __props__.__dict__["file_shares"] = file_shares
            __props__.__dict__["kms_key_name"] = kms_key_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if networks is None and not opts.urn:
                raise TypeError("Missing required property 'networks'")
            __props__.__dict__["networks"] = networks
            __props__.__dict__["project"] = project
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            if zone is not None and not opts.urn:
                warnings.warn("""Deprecated in favor of location.""", DeprecationWarning)
                pulumi.log.warn("""zone is deprecated: Deprecated in favor of location.""")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["create_time"] = None
            __props__.__dict__["etag"] = None
        super(Instance, __self__).__init__(
            'gcp:filestore/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            file_shares: Optional[pulumi.Input[pulumi.InputType['InstanceFileSharesArgs']]] = None,
            kms_key_name: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkArgs']]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            tier: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: A description of the instance.
        :param pulumi.Input[str] etag: Server-specified ETag for the instance resource to prevent simultaneous updates from overwriting each other.
        :param pulumi.Input[pulumi.InputType['InstanceFileSharesArgs']] file_shares: File system shares on the instance. For this version, only a
               single file share is supported.
               Structure is documented below.
        :param pulumi.Input[str] kms_key_name: KMS key name used for data encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user-provided metadata.
        :param pulumi.Input[str] location: The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        :param pulumi.Input[str] name: The name of the fileshare (16 characters or less)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkArgs']]]] networks: VPC networks to which the instance is connected. For this version,
               only a single network is supported.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] tier: The service tier of the instance.
               Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD and ENTERPRISE
        :param pulumi.Input[str] zone: -
               (Optional, Deprecated)
               The name of the Filestore zone of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["file_shares"] = file_shares
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["project"] = project
        __props__.__dict__["tier"] = tier
        __props__.__dict__["zone"] = zone
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Server-specified ETag for the instance resource to prevent simultaneous updates from overwriting each other.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="fileShares")
    def file_shares(self) -> pulumi.Output['outputs.InstanceFileShares']:
        """
        File system shares on the instance. For this version, only a
        single file share is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "file_shares")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[Optional[str]]:
        """
        KMS key name used for data encryption.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource labels to represent user-provided metadata.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the fileshare (16 characters or less)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.InstanceNetwork']]:
        """
        VPC networks to which the instance is connected. For this version,
        only a single network is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[str]:
        """
        The service tier of the instance.
        Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD and ENTERPRISE
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        -
        (Optional, Deprecated)
        The name of the Filestore zone of the instance.
        """
        return pulumi.get(self, "zone")

