[![PyPI](https://img.shields.io/pypi/v/dmri-amico)](https://pypi.org/project/dmri-amico/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/dmri-amico)](#)
[![GitHub](https://img.shields.io/github/license/daducci/AMICO)](#)
[![GitHub top language](https://img.shields.io/github/languages/top/daducci/amico?color=lightgray)](#)
[![reference](https://img.shields.io/badge/DOI-10.1016/j.neuroimage.2014.10.026-red.svg)](https://www.sciencedirect.com/science/article/pii/S1053811914008519)

[![GitHub stars](https://img.shields.io/github/stars/daducci/AMICO?style=social)](#)
[![GitHub forks](https://img.shields.io/github/forks/daducci/AMICO?style=social)](#)
[![GitHub watchers](https://img.shields.io/github/watchers/daducci/AMICO?style=social)](#)
[![GitHub followers](https://img.shields.io/github/followers/daducci?style=social)](#)
[![GitHub contributors](https://img.shields.io/github/contributors-anon/daducci/AMICO?style=social&link)](#)
[![Twitter Follow](https://img.shields.io/twitter/follow/ADaducci)](https://twitter.com/intent/follow?screen_name=ADaducci)

# AMICO

Implementation of the linear framework for Accelerated Microstructure Imaging via Convex Optimization (AMICO) described here:

> **Accelerated Microstructure Imaging via Convex Optimization (AMICO) from diffusion MRI data**  
> *Alessandro Daducci, Erick Canales-Rodriguez, Hui Zhang, Tim Dyrby, Daniel Alexander, Jean-Philippe Thiran*  
> NeuroImage 105, pp. 32-44 (2015)

## Code implementation

AMICO is written in **python** and **does not require** the [NODDI MATLAB toolbox](http://mig.cs.ucl.ac.uk/index.php?n=Download.NODDI) to be present on your system; all the necessary MATLAB functions for generating the response functions of the NODDI model have in fact been ported to Python.

# Documentation

The documentation, including the [installation guide](https://github.com/daducci/AMICO/wiki/Installation) as well as a series of demos/tutorials to show how to use AMICO to fit different models to the data, can be found in the [wiki pages](https://github.com/daducci/AMICO/wiki/Home).

For questions, requesting assistance, suggesting enhancements or new ideas as well as for reporting bugs, please open an [issue](https://github.com/daducci/AMICO/issues).
