import { aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface ManagedInstanceRoleProps {
    /**
     * The managed policies to apply to the role in addition to the default policies.
     */
    readonly managedPolicies?: iam.ManagedPolicy[];
    /**
     * Should the role include directory service access with SSM.
     */
    readonly domainJoinEnabled?: boolean;
    /**
     * Should the role include SSM management. By default if domainJoinEnabled is true then this role is always included.
     */
    readonly ssmManagementEnabled?: boolean;
}
export declare class ManagedInstanceRole extends Construct {
    readonly instanceProfile: iam.CfnInstanceProfile;
    constructor(scope: Construct, id: string, props: ManagedInstanceRoleProps);
}
