#used some code from the WxPython wiki:
#-1.4 Recursively building a list into a wxTreeCtrl (yet another sample) by Rob
#-1.5 Simple Drag and Drop by Titus
#-TraversingwxTree

#tested on wxPython 2.5.4 and Python 2.4, under Windows and Linux

import  wx
#import wx.gizmos
import SpecViewLite_build2 as svl
import RICviewLite as rvl
import RICviewLite_multi as rvl_multi
import mzStudio
import mz_workbench.protein_core as protein_core
import cPickle
import subprocess
import wx.lib.agw.hypertreelist as HTL
import wx.lib.mixins.listctrl  as  listmix
import wx.lib.agw.hypertreelist as HTL
#---------------------------------------------------------------------------


#class MyTreeCtrl(wx.gizmos.TreeListCtrl, listmix.TextEditMixin):#wx.TreeCtrl
class MyTreeCtrl(HTL.HyperTreeList):
    def __init__(self, parent, id, pos, size, style, log):
        print '-------'
        print pos
        #wx.TreeCtrl.__init__(self, parent, id, pos, size, style)
        #wx.gizmos.TreeListCtrl.__init__(self,parent,id, pos,size,style)
        HTL.HyperTreeList.__init__(self,parent,id, pos,size,style)
        
        self.log = log
        
        #------------NEEDED TREELISTCTRL
        #listmix.TextEditMixin.__init__(self)

    def Traverse(self, func, startNode):
        """Apply 'func' to each node in a branch, beginning with 'startNode'. """
        def TraverseAux(node, depth, func):
            nc = self.GetChildrenCount(node, 0)
            child, cookie = self.GetFirstChild(node)
            # In wxPython 2.5.4, GetFirstChild only takes 1 argument
            for i in xrange(nc):
                func(child, depth)
                TraverseAux(child, depth + 1, func)
                child, cookie = self.GetNextChild(node, cookie)
        func(startNode, 0)
        TraverseAux(startNode, 1, func)

    def ItemIsChildOf(self, item1, item2):
        ''' Tests if item1 is a child of item2, using the Traverse function '''
        self.result = False
        def test_func(node, depth):
            if node == item1:
                self.result = True

        self.Traverse(test_func, item2)
        return self.result

    def SaveItemsToList(self, startnode):
        ''' Generates a python object representation of the tree (or a branch of it),
            composed of a list of dictionaries with the following key/values:
            label:      the text that the tree item had
            data:       the node's data, returned from GetItemPyData(node)
            children:   a list containing the node's children (one of these dictionaries for each)
        '''
        global list
        list = []
        #print startnode
        def save_func(node, depth):
            tmplist = list
            for x in range(depth):
                if type(tmplist[-1]) is not dict:
                    tmplist.append({})
                tmplist = tmplist[-1].setdefault('children', [])

            item = {}
            item['label'] = self.GetItemText(node)
            item['data'] = self.GetItemPyData(node)
            item['icon-normal'] = self.GetItemImage(node, wx.TreeItemIcon_Normal)
            item['icon-selected'] = self.GetItemImage(node, wx.TreeItemIcon_Selected)
            item['icon-expanded'] = self.GetItemImage(node, wx.TreeItemIcon_Expanded)
            item['icon-selectedexpanded'] = self.GetItemImage(node, wx.TreeItemIcon_SelectedExpanded)
            item['columnLabel'] = self.GetItemText(node, 1)
            #item[''] = self.GetItemText(node, 1)

            tmplist.append(item)

        self.Traverse(save_func, startnode)
        #print list
        return list

    def InsertItemsFromList(self, itemlist, parent, insertafter=None, appendafter=False):
        ''' Takes a list, 'itemslist', generated by SaveItemsToList, and inserts
            it in to the tree. The items are inserted as children of the
            treeitem given by 'parent', and if 'insertafter' is specified, they
            are inserted directly after that treeitem. Otherwise, they are put at
            the beginning.
            
            If 'appendafter' is True, each item is appended. Otherwise it is prepended.
            In the case of children, you want to append them to keep them in the same order.
            However, to put an item at the start of a branch that has children, you need to
            use prepend. (This will need modification for multiple inserts. Probably reverse
            the list.)

            Returns a list of the newly inserted treeitems, so they can be
            selected, etc..'''
        newitems = []
        for item in itemlist:
            if insertafter:
                node = self.InsertItem(parent, insertafter, item['label'])
            elif appendafter:
                node = self.AppendItem(parent, item['label'])
            else:
                node = self.PrependItem(parent, item['label'])
            self.SetItemPyData(node, item['data'])
            self.SetItemImage(node, item['icon-normal'], wx.TreeItemIcon_Normal)
            self.SetItemImage(node, item['icon-selected'], wx.TreeItemIcon_Selected)
            self.SetItemImage(node, item['icon-expanded'], wx.TreeItemIcon_Expanded)
            self.SetItemImage(node, item['icon-selectedexpanded'], wx.TreeItemIcon_SelectedExpanded)
            self.SetItemText(node, item['columnLabel'], 1)
            newitems.append(node)
            if 'children' in item:
                self.InsertItemsFromList(item['children'], node, appendafter=True)
        return newitems

def OnCompareItems(self, item1, item2):
        t1 = self.GetItemText(item1)
        t2 = self.GetItemText(item2)
        self.log.WriteText('compare: ' + t1 + ' <> ' + t2 + '\n')
        if t1 < t2: return -1
        if t1 == t2: return 0
        return 1


#---------------------------------------------------------------------------
#TestTreeCtrlPanel = Panel; self.tree = MyTreeCtrl
class TestTreeCtrlPanel(wx.Panel):
    def __init__(self, parent, log, parentframe=None, pos=wx.DefaultPosition):
        # Use the WANTS_CHARS style so the panel doesn't eat the Return key.
        wx.Panel.__init__(self, parent, -1, style=wx.WANTS_CHARS|wx.TR_EDIT_LABELS, pos=pos) #wx.WANTS_CHARS|
        self.Bind(wx.EVT_SIZE, self.OnSize)

        self.log = log
        tID = wx.NewId()

        self.tree = MyTreeCtrl(self, tID, pos, wx.DefaultSize,
                                    wx.TR_HAS_BUTTONS | wx.TR_EDIT_LABELS, self.log)
        # Example needs some more work to use wx.TR_MULTIPLE

        isize = (16,16)
        il = wx.ImageList(isize[0], isize[1])
        fldridx   = il.Add(wx.ArtProvider_GetBitmap(wx.ART_FOLDER,  wx.ART_OTHER, isize))
        fldropenidx = il.Add(wx.ArtProvider_GetBitmap(wx.ART_FILE_OPEN, wx.ART_OTHER,isize))
        fileidx   = il.Add(wx.ArtProvider_GetBitmap(wx.ART_REPORT_VIEW, wx.ART_OTHER,isize))

        self.tree.SetImageList(il)
        self.il = il

        self.tree.AddColumn("Peptide Sequences")
        self.tree.AddColumn("Title")
        #self.tree.AddColumn("Column 2")
        self.tree.SetMainColumn(0) # the one with the tree in it...
        self.tree.SetColumnWidth(0, 250)
        self.tree.SetColumnWidth(1, 250)


        self.root = self.tree.AddRoot("The Root Item")
        self.tree.SetPyData(self.root, {"type":"container"})
        self.tree.SetItemImage(self.root, fldridx, wx.TreeItemIcon_Normal)
        self.tree.SetItemImage(self.root, fldropenidx, wx.TreeItemIcon_Expanded)
        self.tree.SetItemText(self.root, "Sequence", 1)
        #self.tree.SetItemText(self.root, "col 1 root", 2)

        for x in range(15):
            child = self.tree.AppendItem(self.root, "Item %d" % x)
            self.tree.SetPyData(child, {"type":"container"})
            self.tree.SetItemImage(child, fldridx, wx.TreeItemIcon_Normal)
            self.tree.SetItemImage(child, fldropenidx, wx.TreeItemIcon_Expanded)
            for y in range(5):
                last = self.tree.AppendItem(child, "item %d-%s" % (x,chr(ord("a")+y)))
                self.tree.SetPyData(last,{"type":"container"})
                self.tree.SetItemImage(last, fldridx, wx.TreeItemIcon_Normal)
                self.tree.SetItemImage(last, fldropenidx,wx.TreeItemIcon_Expanded)
                for z in range(5):
                    item = self.tree.AppendItem(last,  "item %d-%s-%d" % (x, chr(ord("a")+y), z))
                    self.tree.SetPyData(item, {"type":"item"})
                    self.tree.SetItemImage(item, fileidx, wx.TreeItemIcon_Normal)
                    self.tree.SetItemImage(item, fileidx, wx.TreeItemIcon_Selected)

        self.tree.Expand(self.root)
        
        self.tree.GetMainWindow().Bind(wx.EVT_CONTEXT_MENU, self.OnContextMenu)
        self.tree.GetMainWindow().Bind(wx.EVT_RIGHT_UP, self.OnRightUp)
        self.tree.GetMainWindow().Bind(wx.EVT_RIGHT_DOWN, self.OnRightDown)
        self.tree.Bind(wx.EVT_TREE_ITEM_ACTIVATED, self.OnActivate)
        self.tree.Bind(wx.EVT_TREE_ITEM_RIGHT_CLICK, self.OnContextMenu)
        
        self.tree.Bind(wx.EVT_LEFT_DCLICK, self.OnLeftDClick)
        self.tree.Bind(wx.EVT_RIGHT_DOWN, self.OnRightDown)
        print "Bound"
        self.tree.Bind(wx.EVT_LEFT_DOWN, self.OnLeftDown)
        #self.tree.Bind(wx.EVT_TREE_)
        # These go at the end of __init__
        self.tree.Bind(wx.EVT_TREE_BEGIN_RDRAG, self.OnBeginRightDrag)
        self.tree.Bind(wx.EVT_TREE_BEGIN_DRAG, self.OnBeginLeftDrag)
        self.tree.Bind(wx.EVT_TREE_END_DRAG, self.OnEndDrag)
        self.parent = parentframe
        #self.tree.Bind(wx.TR_EDIT_LABELS, self.OnEditItem)
        #menu=wx.Menu()
        #mi = menu.Append(-1, "Edit Item")
        #self.Bind(wx.EVT_MENU, self.OnEditItem, mi)
        #mb = wx.MenuBar()
        #mb.Append(menu, "Edit")
        #frame.SetMenuBar(mb)

    def OnContextMenu(self, event):
        print "CONTEXT"
        if not hasattr(self, "popupID1"):
            print "making..."
            self.popupID1 = wx.NewId()
            self.popupID2 = wx.NewId()
            self.Bind(wx.EVT_MENU, self.OnPopupOne_evt, id=self.popupID1)
            self.Bind(wx.EVT_MENU, self.OnPopupTwo_evt, id=self.popupID2)

        # make a menu
        menu = wx.Menu()
        # Show how to put an icon in the menu
        item = wx.MenuItem(menu, self.popupID1,"Sequence-->BPC")
        item2 = wx.MenuItem(menu, self.popupID2,"Sequence-->Clipboard")
        #bmp = images.Smiles.GetBitmap()
        #item.SetBitmap(bmp)
        menu.AppendItem(item)
        menu.AppendItem(item2)
        # add some other items
        
        # Popup the menu.  If an item is selected then its handler
        # will be called before PopupMenu returns.
        self.PopupMenu(menu)
        menu.Destroy()

    def OnPopupOne_evt(self, event):
        print "Pop 1"
        item = self.tree.GetSelection()
        obj = self.tree.GetPyData(item)['obj']     
        current_sequence = obj.sequence
        fixedmod = obj.fixedmod
        varmod = obj.varmod  
        if obj.sequence.find("-") > -1:
            #H-AAVEEGIVLGGGykl-4-126CALLR-OH
            seqstart = obj.sequence.find("-")
            seqend = obj.sequence.rfind("-")
            current_sequence = obj.sequence[seqstart+1:seqend]
            #current_sequence = obj.sequence.split("-")[1]
            if obj.sequence.split("-")[0] != "H":
                if not fixedmod:
                    fixedmod = "N-term: " + obj.sequence.split("-")[0]
                else:
                    fixedmod += ", N-term: " + obj.sequence.split("-")[0]
            else:
                self.parent.bpc.FindWindowByName("nTerm").SetValue("None")
        self.parent.bpc.FindWindowByName("sequence").SetValue(current_sequence)
        mod_dict = {'iTRAQ4plex': 'iTRAQ',
                  'TMT6plex': 'TMT',
                  'iTRAQ8plex': 'iTRAQ8plex',
                  'HGly-HGly': 'HCGlyHCGly',
                  'HCGly-HCGly': 'HCGlyHCGly',
                  'HCGly-HCGly-HCGly-HCGly': 'HCGlyHCGlyHCGlyHCGly',
                  'HNGly-HNGly': 'HNGlyHNGly',
                  'LbA-LbA': 'LbALbA',
                  'Acetyl':'Acetyl'}
        for mod in fixedmod.split(","):
            print mod
            mod = mod.strip()
            if mod.find("N-term") > -1:
                print "NTERM"
                mod = mod.split(" ")[1]
                mod = mod.strip()
                if mod in mod_dict.keys():
                    self.parent.bpc.FindWindowByName("nTerm").SetValue(mod_dict[mod])
                print mod_dict[mod]
        self.parent.bpc.OnCalculate(None)
        self.parent.bpc.Refresh()        
        
        
    def OnPopupTwo_evt(self, event):
        print "Pop 2"    
        item = self.tree.GetSelection()
        #print event.GetItem()
        #print self.tree.GetItemText(event.GetSelection())
        obj = self.tree.GetPyData(item)['obj']     
        print obj.sequence
        print obj.fixedmod
        print obj.varmod
        if not wx.TheClipboard.IsOpened():
            wx.TheClipboard.Open()
        clipdata = wx.TextDataObject()
        clipdata.SetText(obj.sequence)
        wx.TheClipboard.SetData(clipdata)
        wx.TheClipboard.Close()
        

    def OnEditItem(self, event):
        print "EDIT"
        item=self.tree.GetSelection()
        if item:
            self.tree.EditLabel(item)
        event.Skip()

    def OnActivate(self, event):
        print self.tree.GetItemText(event.GetItem())
        item = event.GetItem()
        
        obj = self.tree.GetPyData(item)["obj"]
        if obj.type == "Spectrum":
            #print self.tree.GetPyData(item)["scan_data"]
            frame = svl.SpecViewLitePanel(None, self.tree.GetPyData(item)["obj"])
        if obj.type == "multiXIC":
            frame = rvl_multi.RICviewLitePanel(None, self.tree.GetPyData(item)["obj"])        
        if obj.type == "XIC":
            frame = rvl.RICviewLitePanel(None, self.tree.GetPyData(item)["obj"])
        if obj.type == "Protein Coverage Map":
            pickle_file = open(obj.filename, "r")
            prot = cPickle.load(pickle_file)
            pickle_file.close()
            frame = protein_core.TextFrame(prot)
        if obj.type == "AuxFile":
            print obj.filename
            if obj.filename.lower().find(".ppt") > -1:
                subprocess.Popen('"C:\Program Files (x86)\Microsoft Office\OFFICE11\POWERPNT.EXE" "' + obj.filename + '"')
            elif obj.filename.lower().find(".xls") > -1:
                subprocess.Popen('"C:\Program Files (x86)\Microsoft Office\OFFICE11\EXCEL.EXE" "' + obj.filename + '"')
            #subprocess.Popen('"' + obj.filename + '"')
        if obj.type == "Folder":
            subprocess.Popen('explorer "' + obj.folder + '"')
        if obj.type in ["Spectrum", "XIC","Protein Coverage Map", "multiXIC"]:
            frame.Show()
            event.Skip()
        if obj.type == "Analysis":
            data = self.tree.GetPyData(item)["obj"]
            print data
            frame = mzStudio.DrawPanel(None, 1)
            for i in range(0, len(data.file_data.keys())):
                m = data.display[i]
                print m
                print m.lower()
                frame.msdb.addFile(m)
                frame.Refresh()
                currentFile = frame.msdb.files[frame.msdb.Display_ID[i]]
                frame.msdb.set_scan(data.file_data[data.display[i]]["scanNum"], i)
                #for i in range(0, len(currentFile["xic_mass_ranges"])):
                #    currentFile["scanNum"]=data.file_data[data.display[0]]["scanNum"]
                #    file_data[file]["xr"].append(list(time_range)+currentFile["xic_params"])
                print "Building XICs..."
                frm = mzStudio.xicFrame(frame, frame.msdb.files[frame.msdb.Display_ID[i]], i)
                for m in [0,1,2,3]:
                    for n in [0,1,2]:
                        frm.grid.SetCellValue(m, n, "")
                for j, member in enumerate(data.file_data[data.display[i]]["xr"]):
                    print member
                    frm.grid.SetCellValue(j, 0, str(data.file_data[data.display[i]]["xr"][j][2]))
                    frm.grid.SetCellValue(j, 1, str(data.file_data[data.display[i]]["xr"][j][3]))
                    frm.grid.SetCellValue(j, 2, str(data.file_data[data.display[i]]["xr"][j][4]))
                frm.OnClick(None)
                frm.Destroy()
                frame.msdb.active_file = i
                if 'xlsSource' in data.file_data[data.display[i]].keys():
                    print "Found source"
                    print data.file_data[data.display[i]]['xlsSource']
                    if data.file_data[data.display[i]]['xlsSource']:
                        print "LOADING"
                        frame.LoadDb(None, data.file_data[data.display[i]]['xlsSource'], data.file_data[data.display[i]]['SearchType'])
            frame.msdb.active_file = 0
            frame.Show()
            event.Skip()

    def OnBeginLeftDrag(self, event):
        '''Allow drag-and-drop for leaf nodes.'''
        print "DRAG"
        #self.log.WriteText("OnBeginDrag")
        event.Allow()
        self.dragType = "left button"
        self.dragItem = event.GetItem()
        event.Skip()

    def OnBeginRightDrag(self, event):
        print "RDRAG"
        '''Allow drag-and-drop for leaf nodes.'''
        #self.log.WriteText("OnBeginDrag")
        event.Allow()
        self.dragType = "right button"
        self.dragItem = event.GetItem()
        event.Skip()

    def OnEndDrag(self, event):
        print "OnEndDrag"

        # If we dropped somewhere that isn't on top of an item, ignore the event
        if event.GetItem().IsOk():
            target = event.GetItem()
        else:
            return

        # Make sure this member exists.
        try:
            source = self.dragItem
        except:
            return

        # Prevent the user from dropping an item inside of itself
        if self.tree.ItemIsChildOf(target, source):
            print "the tree item can not be moved in to itself! "
            self.tree.Unselect()
            return

        # Get the target's parent's ID
        targetparent = self.tree.GetItemParent(target)
        if not targetparent.IsOk():
            targetparent = self.tree.GetRootItem()

        # One of the following methods of inserting will be called...   
        def MoveHere(event):
            # Save + delete the source
            save = self.tree.SaveItemsToList(source)
            self.tree.Delete(source)
            newitems = self.tree.InsertItemsFromList(save, targetparent, target)
            #self.tree.UnselectAll()
            for item in newitems:
                self.tree.SelectItem(item)

        def InsertInToThisGroup(event):
            # Save + delete the source
            save = self.tree.SaveItemsToList(source)
            self.tree.Delete(source)
            newitems = self.tree.InsertItemsFromList(save, target)
            #self.tree.UnselectAll()
            for item in newitems:
                self.tree.SelectItem(item)
        #---------------------------------------

        if self.tree.GetPyData(target)["type"] == "container" and self.dragType == "right button":
            menu = wx.Menu()
            menu.Append(101, "Move to after this group", "")
            menu.Append(102, "Insert into this group", "")
            menu.UpdateUI()
            menu.Bind(wx.EVT_MENU, MoveHere, id=101)
            menu.Bind(wx.EVT_MENU, InsertInToThisGroup,id=102)
            self.PopupMenu(menu)
        else:
            if self.tree.IsExpanded(target):
               InsertInToThisGroup(None)
            else:
               MoveHere(None)
        event.Skip()

    def OnRightUp(self, event):
        pt = event.GetPosition()
        print "ORU"
        #item, flags = self.tree.HitTest(pt)
        #self.log.WriteText("OnRightUp: %s (manually starting label edit)\n" % self.tree.GetItemText(item))
        #self.tree.EditLabel(item)
        event.Skip()

    def OnLeftDown(self, event):
        print "control key is -- ", event.m_controlDown

        pt = event.GetPosition();
        #item, flags = self.tree.HitTest(pt)
        item = self.tree.HitTest(pt)
        try:
            self.tree.SelectItem(item)
        except:
            pass
        event.Skip()

    def OnRightDown(self, event):
        pos = event.GetPosition()
        item, flags, col = self.tree.HitTest(pos)         
        #print "control key is", event.m_controlDown
        try:
            seq = self.tree.GetItemText(item)
            #print item.GetString()
            #print flags
            #print col
        except:
            pass
        #pt = event.GetPosition();
        #item, flags = self.tree.HitTest(pt)
        #self.tree.SelectItem(item)
        self.tree.currentSequence = seq
        event.Skip()

    def OnLeftDClick(self, event):
        pt = event.GetPosition();
        item, flags = self.tree.HitTest(pt)
        #self.log.WriteText("OnLeftDClick: %s\n" % self.tree.GetItemText(item))

        #expand/collapse toggle
        self.tree.Toggle(item)
        print "toggled ", item
        event.Skip()

    def OnSize(self, event):
        w,h = self.GetClientSizeTuple()
        self.tree.SetDimensions(0, 0, w, h)


#---------------------------------------------------------------------------

class MyLog:
    def __init__(self):
        pass
    def WriteText(self, text):
        print text

class MyFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        wx.Frame.__init__(self, *args, **kwds)
        log = MyLog()
        pnl = TestTreeCtrlPanel(self, log)

class MyApp(wx.App):
    def OnInit(self):
        wx.InitAllImageHandlers()
        frame_1 = MyFrame(None, -1, "")
        self.SetTopWindow(frame_1)
        frame_1.Show(1)
        return 1

# end of class MyApp

if __name__ == "__main__":
    app = MyApp(0)
    app.MainLoop()
