"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import common.common_pb2
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Serving(google.protobuf.message.Message):
    """
    A Serving (Group) is a collection of Model(s).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    MODELS_FIELD_NUMBER: builtins.int
    DEPLOYMENT_ENDPOINT_FIELD_NUMBER: builtins.int
    MODEL_ENDPOINTS_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    CPU_SCALE_CONFIG_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID for the Serving Group"""
    name: builtins.str
    """name of the Serving Group"""
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """list of models"""
    @property
    def deployment_endpoint(self) -> global___Endpoint:
        """Endpoint for the Serving Group"""
    @property
    def model_endpoints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Endpoint]:
        """Endpoints for the models. Copy of models[*].endpoint."""
    @property
    def resource(self) -> common.common_pb2.Resource: ...
    @property
    def cpu_scale_config(self) -> global___ScaleConfig: ...
    description: builtins.str
    """description of the serving group"""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """metadata for serving group"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        models: collections.abc.Iterable[global___Model] | None = ...,
        deployment_endpoint: global___Endpoint | None = ...,
        model_endpoints: collections.abc.Iterable[global___Endpoint] | None = ...,
        resource: common.common_pb2.Resource | None = ...,
        cpu_scale_config: global___ScaleConfig | None = ...,
        description: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cpu_scale_config", b"cpu_scale_config", "created_at", b"created_at", "deployment_endpoint", b"deployment_endpoint", "resource", b"resource"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cpu_scale_config", b"cpu_scale_config", "created_at", b"created_at", "deployment_endpoint", b"deployment_endpoint", "description", b"description", "id", b"id", "metadata", b"metadata", "model_endpoints", b"model_endpoints", "models", b"models", "name", b"name", "resource", b"resource"]) -> None: ...

global___Serving = Serving

@typing_extensions.final
class Endpoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    ACCESS_KEY_FIELD_NUMBER: builtins.int
    HOST_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Model or Serving (Group) ID"""
    url: builtins.str
    """URL to access the model or serving group"""
    access_key: builtins.str
    """access_key is used to authenticate requests to the endpoint.
    It is used in the following ways:
    curl -H "NBX-KEY:  $access_key" https://api.nimblebox.ai/ |  $url
    """
    host: builtins.str
    """Hostname of the endpoint defined in the apisix route"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        url: builtins.str = ...,
        access_key: builtins.str = ...,
        host: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["access_key", b"access_key", "host", b"host", "id", b"id", "url", b"url"]) -> None: ...

global___Endpoint = Endpoint

@typing_extensions.final
class ServingStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ServingStatus._Status.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: ServingStatus._Status.ValueType  # 0
        """Unknown status"""
        STATUS_PENDING: ServingStatus._Status.ValueType  # 1
        """Deployment is pending"""
        STATUS_SUCCESS: ServingStatus._Status.ValueType  # 2
        """Deployment is successful"""
        STATUS_FAILED: ServingStatus._Status.ValueType  # 3
        """Deployment is failed"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: ServingStatus.Status.ValueType  # 0
    """Unknown status"""
    STATUS_PENDING: ServingStatus.Status.ValueType  # 1
    """Deployment is pending"""
    STATUS_SUCCESS: ServingStatus.Status.ValueType  # 2
    """Deployment is successful"""
    STATUS_FAILED: ServingStatus.Status.ValueType  # 3
    """Deployment is failed"""

    UPLOAD_STATUS_FIELD_NUMBER: builtins.int
    DEPLOY_STATUS_FIELD_NUMBER: builtins.int
    upload_status: global___ServingStatus.Status.ValueType
    deploy_status: global___ServingStatus.Status.ValueType
    def __init__(
        self,
        *,
        upload_status: global___ServingStatus.Status.ValueType = ...,
        deploy_status: global___ServingStatus.Status.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deploy_status", b"deploy_status", "upload_status", b"upload_status"]) -> None: ...

global___ServingStatus = ServingStatus

@typing_extensions.final
class ScaleConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_REPLICAS_FIELD_NUMBER: builtins.int
    MAX_REPLICAS_FIELD_NUMBER: builtins.int
    THRESHOLD_FIELD_NUMBER: builtins.int
    min_replicas: builtins.int
    max_replicas: builtins.int
    threshold: builtins.float
    def __init__(
        self,
        *,
        min_replicas: builtins.int = ...,
        max_replicas: builtins.int = ...,
        threshold: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_replicas", b"max_replicas", "min_replicas", b"min_replicas", "threshold", b"threshold"]) -> None: ...

global___ScaleConfig = ScaleConfig

@typing_extensions.final
class ServingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUTH_INFO_FIELD_NUMBER: builtins.int
    SERVING_FIELD_NUMBER: builtins.int
    INTEGRATION_DATA_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> common.common_pb2.NBXAuthInfo: ...
    @property
    def serving(self) -> global___Serving: ...
    @property
    def integration_data(self) -> common.common_pb2.IntegrationData: ...
    def __init__(
        self,
        *,
        auth_info: common.common_pb2.NBXAuthInfo | None = ...,
        serving: global___Serving | None = ...,
        integration_data: common.common_pb2.IntegrationData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data", "serving", b"serving"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data", "serving", b"serving"]) -> None: ...

global___ServingRequest = ServingRequest

@typing_extensions.final
class UpdateServingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUTH_INFO_FIELD_NUMBER: builtins.int
    SERVING_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    INTEGRATION_DATA_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> common.common_pb2.NBXAuthInfo: ...
    @property
    def serving(self) -> global___Serving: ...
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask: ...
    @property
    def integration_data(self) -> common.common_pb2.IntegrationData: ...
    def __init__(
        self,
        *,
        auth_info: common.common_pb2.NBXAuthInfo | None = ...,
        serving: global___Serving | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        integration_data: common.common_pb2.IntegrationData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data", "serving", b"serving", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data", "serving", b"serving", "update_mask", b"update_mask"]) -> None: ...

global___UpdateServingRequest = UpdateServingRequest

@typing_extensions.final
class ServingListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUTH_INFO_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    INTEGRATION_DATA_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> common.common_pb2.NBXAuthInfo: ...
    limit: builtins.int
    offset: builtins.int
    @property
    def integration_data(self) -> common.common_pb2.IntegrationData: ...
    def __init__(
        self,
        *,
        auth_info: common.common_pb2.NBXAuthInfo | None = ...,
        limit: builtins.int = ...,
        offset: builtins.int = ...,
        integration_data: common.common_pb2.IntegrationData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data", "limit", b"limit", "offset", b"offset"]) -> None: ...

global___ServingListRequest = ServingListRequest

@typing_extensions.final
class ServingListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SERVINGS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_FIELD_NUMBER: builtins.int
    @property
    def servings(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Serving]: ...
    next_page: builtins.int
    def __init__(
        self,
        *,
        servings: collections.abc.Iterable[global___Serving] | None = ...,
        next_page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page", b"next_page", "servings", b"servings"]) -> None: ...

global___ServingListResponse = ServingListResponse

@typing_extensions.final
class Model(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ServingType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._ServingType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVING_TYPE_UNSPECIFIED: Model._ServingType.ValueType  # 0
        """Unknown deployment type"""
        SERVING_TYPE_NBOX_OP: Model._ServingType.ValueType  # 1
        """Serving via nbox Operators"""

    class ServingType(_ServingType, metaclass=_ServingTypeEnumTypeWrapper):
        """Deployment type"""

    SERVING_TYPE_UNSPECIFIED: Model.ServingType.ValueType  # 0
    """Unknown deployment type"""
    SERVING_TYPE_NBOX_OP: Model.ServingType.ValueType  # 1
    """Serving via nbox Operators"""

    class _PinStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PinStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._PinStatus.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PIN_STATUS_UNSPECIFIED: Model._PinStatus.ValueType  # 0
        """Unknown pin status"""
        PIN_STATUS_PINNED: Model._PinStatus.ValueType  # 1
        """Model is pinned"""
        PIN_STATUS_UNPINNED: Model._PinStatus.ValueType  # 2
        """Model is unpinned"""

    class PinStatus(_PinStatus, metaclass=_PinStatusEnumTypeWrapper): ...
    PIN_STATUS_UNSPECIFIED: Model.PinStatus.ValueType  # 0
    """Unknown pin status"""
    PIN_STATUS_PINNED: Model.PinStatus.ValueType  # 1
    """Model is pinned"""
    PIN_STATUS_UNPINNED: Model.PinStatus.ValueType  # 2
    """Model is unpinned"""

    @typing_extensions.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class FeatureGatesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SERVING_GROUP_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    ENDPOINT_FIELD_NUMBER: builtins.int
    PIN_STATUS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    REPLICAS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    K8SINFO_FIELD_NUMBER: builtins.int
    FEATURE_GATES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID for the model"""
    name: builtins.str
    """name of the model"""
    serving_group_id: builtins.str
    """ID of the serving group the model belongs to"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """time created"""
    type: global___Model.ServingType.ValueType
    @property
    def resource(self) -> common.common_pb2.Resource:
        """model resource"""
    @property
    def code(self) -> common.common_pb2.Code: ...
    @property
    def endpoint(self) -> global___Endpoint: ...
    pin_status: global___Model.PinStatus.ValueType
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """metadata for model"""
    replicas: builtins.int
    """number of replicas for model"""
    @property
    def status(self) -> global___ServingStatus: ...
    @property
    def k8sInfo(self) -> common.common_pb2.K8sInfo: ...
    @property
    def feature_gates(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        serving_group_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        type: global___Model.ServingType.ValueType = ...,
        resource: common.common_pb2.Resource | None = ...,
        code: common.common_pb2.Code | None = ...,
        endpoint: global___Endpoint | None = ...,
        pin_status: global___Model.PinStatus.ValueType = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        replicas: builtins.int | None = ...,
        status: global___ServingStatus | None = ...,
        k8sInfo: common.common_pb2.K8sInfo | None = ...,
        feature_gates: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_replicas", b"_replicas", "code", b"code", "created_at", b"created_at", "endpoint", b"endpoint", "k8sInfo", b"k8sInfo", "replicas", b"replicas", "resource", b"resource", "status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_replicas", b"_replicas", "code", b"code", "created_at", b"created_at", "endpoint", b"endpoint", "feature_gates", b"feature_gates", "id", b"id", "k8sInfo", b"k8sInfo", "metadata", b"metadata", "name", b"name", "pin_status", b"pin_status", "replicas", b"replicas", "resource", b"resource", "serving_group_id", b"serving_group_id", "status", b"status", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_replicas", b"_replicas"]) -> typing_extensions.Literal["replicas"] | None: ...

global___Model = Model

@typing_extensions.final
class ModelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUTH_INFO_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    INTEGRATION_DATA_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> common.common_pb2.NBXAuthInfo: ...
    @property
    def model(self) -> global___Model: ...
    @property
    def integration_data(self) -> common.common_pb2.IntegrationData: ...
    def __init__(
        self,
        *,
        auth_info: common.common_pb2.NBXAuthInfo | None = ...,
        model: global___Model | None = ...,
        integration_data: common.common_pb2.IntegrationData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data", "model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data", "model", b"model"]) -> None: ...

global___ModelRequest = ModelRequest

@typing_extensions.final
class UpdateModelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUTH_INFO_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    INTEGRATION_DATA_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> common.common_pb2.NBXAuthInfo: ...
    @property
    def model(self) -> global___Model: ...
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask: ...
    @property
    def integration_data(self) -> common.common_pb2.IntegrationData: ...
    def __init__(
        self,
        *,
        auth_info: common.common_pb2.NBXAuthInfo | None = ...,
        model: global___Model | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        integration_data: common.common_pb2.IntegrationData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data", "model", b"model", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data", "model", b"model", "update_mask", b"update_mask"]) -> None: ...

global___UpdateModelRequest = UpdateModelRequest

@typing_extensions.final
class ModelListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUTH_INFO_FIELD_NUMBER: builtins.int
    SERVING_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    INTEGRATION_DATA_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> common.common_pb2.NBXAuthInfo: ...
    serving_id: builtins.str
    limit: builtins.int
    offset: builtins.int
    @property
    def integration_data(self) -> common.common_pb2.IntegrationData: ...
    def __init__(
        self,
        *,
        auth_info: common.common_pb2.NBXAuthInfo | None = ...,
        serving_id: builtins.str = ...,
        limit: builtins.int = ...,
        offset: builtins.int = ...,
        integration_data: common.common_pb2.IntegrationData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info", b"auth_info", "integration_data", b"integration_data", "limit", b"limit", "offset", b"offset", "serving_id", b"serving_id"]) -> None: ...

global___ModelListRequest = ModelListRequest

@typing_extensions.final
class ModelListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]: ...
    next_page: builtins.int
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page", b"next_page"]) -> None: ...

global___ModelListResponse = ModelListResponse
