"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import common.common_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import jobs.dag_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Job(google.protobuf.message.Message):
    """Job is the definition of a Job ceated by nbox, with a schedule"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Job._Status.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: Job._Status.ValueType  # 0
        NOT_SET: Job._Status.ValueType  # 1
        """when user creates from FE"""
        PREPARING: Job._Status.ValueType  # 2
        """if the run is being prepared"""
        PAUSED: Job._Status.ValueType  # 3
        """if user from FE/nbox said pause"""
        SCHEDULED: Job._Status.ValueType  # 4
        """is a run is scheduled"""
        ACTIVE: Job._Status.ValueType  # 5
        """run is running"""
        ERROR: Job._Status.ValueType  # 6
        """run errored -> paused"""
        COMPLETED: Job._Status.ValueType  # 7
        """last run done and there is nothing scheduled"""
        ARCHIVED: Job._Status.ValueType  # 8
        """when user deletes this job"""
        CANCELLED: Job._Status.ValueType  # 9
        """run status if job is pasued or archive"""
        KILLED: Job._Status.ValueType  # 10
        """run status if job is archived or paused while run is active"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    UNKNOWN: Job.Status.ValueType  # 0
    NOT_SET: Job.Status.ValueType  # 1
    """when user creates from FE"""
    PREPARING: Job.Status.ValueType  # 2
    """if the run is being prepared"""
    PAUSED: Job.Status.ValueType  # 3
    """if user from FE/nbox said pause"""
    SCHEDULED: Job.Status.ValueType  # 4
    """is a run is scheduled"""
    ACTIVE: Job.Status.ValueType  # 5
    """run is running"""
    ERROR: Job.Status.ValueType  # 6
    """run errored -> paused"""
    COMPLETED: Job.Status.ValueType  # 7
    """last run done and there is nothing scheduled"""
    ARCHIVED: Job.Status.ValueType  # 8
    """when user deletes this job"""
    CANCELLED: Job.Status.ValueType  # 9
    """run status if job is pasued or archive"""
    KILLED: Job.Status.ValueType  # 10
    """run status if job is archived or paused while run is active"""

    @typing_extensions.final
    class FeatureGatesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class Schedule(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        START_FIELD_NUMBER: builtins.int
        END_FIELD_NUMBER: builtins.int
        CRON_FIELD_NUMBER: builtins.int
        @property
        def start(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
        @property
        def end(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
        cron: builtins.str
        def __init__(
            self,
            *,
            start: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            end: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            cron: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["end", b"end", "start", b"start"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["cron", b"cron", "end", b"end", "start", b"start"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    FEATURE_GATES_FIELD_NUMBER: builtins.int
    SCHEDULE_FIELD_NUMBER: builtins.int
    DAG_FIELD_NUMBER: builtins.int
    PAUSED_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    K8SINFO_FIELD_NUMBER: builtins.int
    id: builtins.str
    """unique id of the job"""
    name: builtins.str
    """user defined name of the job
    // user provided description of the job
    string description = 3;
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """time created"""
    @property
    def code(self) -> common.common_pb2.Code: ...
    @property
    def resource(self) -> common.common_pb2.Resource: ...
    @property
    def feature_gates(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def schedule(self) -> global___Job.Schedule:
        """schedule of the job"""
    @property
    def dag(self) -> jobs.dag_pb2.DAG:
        """nbox created DAG information
        get this from dag.proto
        """
    paused: builtins.bool
    """if the job is/has to be paused"""
    status: global___Job.Status.ValueType
    """Job Status, as used within WS"""
    @property
    def k8sInfo(self) -> common.common_pb2.K8sInfo: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        code: common.common_pb2.Code | None = ...,
        resource: common.common_pb2.Resource | None = ...,
        feature_gates: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        schedule: global___Job.Schedule | None = ...,
        dag: jobs.dag_pb2.DAG | None = ...,
        paused: builtins.bool = ...,
        status: global___Job.Status.ValueType = ...,
        k8sInfo: common.common_pb2.K8sInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["code", b"code", "created_at", b"created_at", "dag", b"dag", "k8sInfo", b"k8sInfo", "resource", b"resource", "schedule", b"schedule"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["code", b"code", "created_at", b"created_at", "dag", b"dag", "feature_gates", b"feature_gates", "id", b"id", "k8sInfo", b"k8sInfo", "name", b"name", "paused", b"paused", "resource", b"resource", "schedule", b"schedule", "status", b"status"]) -> None: ...

global___Job = Job
