# Generated by Django 3.1.14 on 2022-05-20 13:09

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import ob_dj_store.utils.model


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("stores", "0014_auto_20220519_0018"),
    ]

    operations = [
        migrations.CreateModel(
            name="Inventory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("ACTIVE", "Active"), ("NOT_ACTIVE", "Not active")],
                        default="ACTIVE",
                        max_length=32,
                    ),
                ),
                ("quantity", models.PositiveIntegerField(default=0)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "store",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="inventories",
                        to="stores.store",
                    ),
                ),
                (
                    "variant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="inventories",
                        to="stores.productvariant",
                    ),
                ),
            ],
            options={
                "verbose_name": "Inventory",
                "verbose_name_plural": "Inventories",
                "unique_together": {("store", "variant")},
            },
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
        migrations.CreateModel(
            name="InventoryOperations",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "type_of_operation",
                    models.CharField(
                        choices=[("STOCK_IN", "stock in"), ("STOCK_OUT", "stock out")],
                        default="STOCK_IN",
                        max_length=32,
                    ),
                ),
                ("quantity", models.PositiveIntegerField(default=0)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "inventory",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="inventory_operations",
                        to="stores.inventory",
                    ),
                ),
                (
                    "operator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="inventory_operations",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "product_variant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="inventory_operations",
                        to="stores.productvariant",
                    ),
                ),
                (
                    "store",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="inventory_operations",
                        to="stores.store",
                    ),
                ),
            ],
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
    ]
