# Generated by Django 3.1.14 on 2022-05-24 06:12

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("stores", "0016_productvariant_preparation_time"),
    ]

    operations = [
        migrations.CreateModel(
            name="Payment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("INIT", "Init"),
                            ("SUCCESS", "Success"),
                            ("FAILED", "Failed"),
                            ("ERROR", "Error"),
                        ],
                        default="INIT",
                        max_length=100,
                    ),
                ),
                (
                    "gateway",
                    models.CharField(
                        choices=[("cod", "Cod"), ("tap", "Tap")], max_length=40
                    ),
                ),
                (
                    "gateway_ref_id",
                    models.BigIntegerField(
                        blank=True,
                        help_text="A reference (Primary key) of the gateway transaction table",
                        null=True,
                    ),
                ),
                ("amount", models.DecimalField(decimal_places=4, max_digits=10)),
                ("currency", models.CharField(max_length=10, verbose_name="Currency")),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created at"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Updated at"),
                ),
                (
                    "payment_post_at",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="Payment Post At"
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
            },
        ),
        migrations.RemoveField(
            model_name="order",
            name="payment",
        ),
        migrations.DeleteModel(
            name="OrderPayment",
        ),
        migrations.AddField(
            model_name="payment",
            name="order",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, to="stores.order"
            ),
        ),
    ]
