# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Database']


class Database(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_character_set: Optional[pulumi.Input[str]] = None,
                 default_collation: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        The ``Database`` resource creates and manages a database on a MySQL
        server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_mysql as mysql

        app = mysql.Database("app")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_character_set: The default character set to use when
               a table is created without specifying an explicit character set. Defaults
               to "utf8".
        :param pulumi.Input[str] default_collation: The default collation to use when a table
               is created without specifying an explicit collation. Defaults to
               ``utf8_general_ci``. Each character set has its own set of collations, so
               changing the character set requires also changing the collation.
        :param pulumi.Input[str] name: The name of the database. This must be unique within
               a given MySQL server and may or may not be case-sensitive depending on
               the operating system on which the MySQL server is running.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['default_character_set'] = default_character_set
            __props__['default_collation'] = default_collation
            __props__['name'] = name
        super(Database, __self__).__init__(
            'mysql:index/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_character_set: Optional[pulumi.Input[str]] = None,
            default_collation: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_character_set: The default character set to use when
               a table is created without specifying an explicit character set. Defaults
               to "utf8".
        :param pulumi.Input[str] default_collation: The default collation to use when a table
               is created without specifying an explicit collation. Defaults to
               ``utf8_general_ci``. Each character set has its own set of collations, so
               changing the character set requires also changing the collation.
        :param pulumi.Input[str] name: The name of the database. This must be unique within
               a given MySQL server and may or may not be case-sensitive depending on
               the operating system on which the MySQL server is running.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["default_character_set"] = default_character_set
        __props__["default_collation"] = default_collation
        __props__["name"] = name
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultCharacterSet")
    def default_character_set(self) -> pulumi.Output[Optional[str]]:
        """
        The default character set to use when
        a table is created without specifying an explicit character set. Defaults
        to "utf8".
        """
        return pulumi.get(self, "default_character_set")

    @property
    @pulumi.getter(name="defaultCollation")
    def default_collation(self) -> pulumi.Output[Optional[str]]:
        """
        The default collation to use when a table
        is created without specifying an explicit collation. Defaults to
        ``utf8_general_ci``. Each character set has its own set of collations, so
        changing the character set requires also changing the collation.
        """
        return pulumi.get(self, "default_collation")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the database. This must be unique within
        a given MySQL server and may or may not be case-sensitive depending on
        the operating system on which the MySQL server is running.
        """
        return pulumi.get(self, "name")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

