import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [amplify](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplify.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Amplify extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [amplify](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplify.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a new Amplify App
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toCreateApp(): this;
    /**
     * Grants permission to create a new backend environment for an Amplify App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toCreateBackendEnvironment(): this;
    /**
     * Grants permission to create a new Branch for an Amplify App
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toCreateBranch(): this;
    /**
     * Grants permission to create a deployment for manual deploy apps. (Apps are not connected to repository)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toCreateDeployment(): this;
    /**
     * Grants permission to create a new DomainAssociation on an App
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toCreateDomainAssociation(): this;
    /**
     * Grants permission to create a new webhook on an App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toCreateWebHook(): this;
    /**
     * Grants permission to delete an existing Amplify App by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toDeleteApp(): this;
    /**
     * Grants permission to delete a branch for an Amplify App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toDeleteBackendEnvironment(): this;
    /**
     * Grants permission to delete a branch for an Amplify App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toDeleteBranch(): this;
    /**
     * Grants permission to delete a DomainAssociation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toDeleteDomainAssociation(): this;
    /**
     * Grants permission to delete a job, for an Amplify branch, part of Amplify App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toDeleteJob(): this;
    /**
     * Grants permission to delete a webhook by id
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toDeleteWebHook(): this;
    /**
     * Grants permission to generate website access logs for a specific time range via a pre-signed URL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toGenerateAccessLogs(): this;
    /**
     * Grants permission to retrieve an existing Amplify App by appId
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toGetApp(): this;
    /**
     * Grants permission to retrieve artifact info that corresponds to a artifactId
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toGetArtifactUrl(): this;
    /**
     * Grants permission to retrieve a backend environment for an Amplify App
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toGetBackendEnvironment(): this;
    /**
     * Grants permission to retrieve a branch for an Amplify App
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toGetBranch(): this;
    /**
     * Grants permission to retrieve domain info that corresponds to an appId and domainName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toGetDomainAssociation(): this;
    /**
     * Grants permission to get a job for a branch, part of an Amplify App
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toGetJob(): this;
    /**
     * Grants permission to retrieve webhook info that corresponds to a webhookId
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toGetWebHook(): this;
    /**
     * Grants permission to list existing Amplify Apps
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toListApps(): this;
    /**
     * Grants permission to list artifacts with an app, a branch, a job and an artifact type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toListArtifacts(): this;
    /**
     * Grants permission to list backend environments for an Amplify App
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toListBackendEnvironments(): this;
    /**
     * Grants permission to list branches for an Amplify App
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toListBranches(): this;
    /**
     * Grants permission to list domains with an app
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toListDomainAssociations(): this;
    /**
     * Grants permission to list Jobs for a branch, part of an Amplify App
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toListJobs(): this;
    /**
     * Grants permission to list tags for an AWS Amplify Console resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list webhooks on an App
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toListWebHooks(): this;
    /**
     * Grants permission to start a deployment for manual deploy apps. (Apps are not connected to repository)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toStartDeployment(): this;
    /**
     * Grants permission to start a new job for a branch, part of an Amplify App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toStartJob(): this;
    /**
     * Grants permission to stop a job that is in progress, for an Amplify branch, part of Amplify App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toStopJob(): this;
    /**
     * Grants permission to tag an AWS Amplify Console resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove a tag from an AWS Amplify Console resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an existing Amplify App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toUpdateApp(): this;
    /**
     * Grants permission to update a branch for an Amplify App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toUpdateBranch(): this;
    /**
     * Grants permission to update a DomainAssociation on an App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toUpdateDomainAssociation(): this;
    /**
     * Grants permission to update a webhook
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     */
    toUpdateWebHook(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type apps to the statement
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApps(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type branches to the statement
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @param appId - Identifier for the appId.
     * @param branchName - Identifier for the branchName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBranches(appId: string, branchName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type jobs to the statement
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @param appId - Identifier for the appId.
     * @param branchName - Identifier for the branchName.
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onJobs(appId: string, branchName: string, jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type domains to the statement
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @param appId - Identifier for the appId.
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDomains(appId: string, domainName: string, account?: string, region?: string, partition?: string): this;
}
