import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [a2c](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapp2container.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class A2c extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [a2c](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapp2container.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to get the details of all Containerization jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toGetContainerizationJobDetails(): this;
    /**
     * Grants permission to get the details of all Deployment jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toGetDeploymentJobDetails(): this;
    /**
     * Grants permission to start a Containerization job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toStartContainerizationJob(): this;
    /**
     * Grants permission to start a Deploymnet job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toStartDeploymentJob(): this;
    protected accessLevelList: AccessLevelList;
}
